﻿# Shell Configuration
Set-Alias -Name Clear-AWSCredentials -Value Clear-AWSCredential
Set-Alias -Name Clear-AWSDefaults -Value Clear-AWSDefaultConfiguration
Set-Alias -Name Get-AWSCredentials -Value Get-AWSCredential
Set-Alias -Name Initialize-AWSDefaults -Value Initialize-AWSDefaultConfiguration
Set-Alias -Name New-AWSCredentials -Value New-AWSCredential
Set-Alias -Name Set-AWSCredentials -Value Set-AWSCredential

# ApiGatewayV2
Set-Alias -Name Get-AG2ApiLis -Value Get-AG2ApiList

# ApplicationAutoScaling
Set-Alias -Name Write-AASScalingPolicy -Value Set-AASScalingPolicy

# ApplicationDiscoveryService
Set-Alias -Name Remove-ADSApplications -Value Remove-ADSApplication

# AutoScaling
Set-Alias -Name Add-ASInstances -Value Mount-ASInstance
Set-Alias -Name Dismount-ASInstances -Value Dismount-ASInstance
Set-Alias -Name Get-ASAccountLimits -Value Get-ASAccountLimit
Set-Alias -Name Get-ASLifecycleHooks -Value Get-ASLifecycleHook
Set-Alias -Name Get-ASLifecycleHookTypes -Value Get-ASLifecycleHookType

# AWSSupport
Set-Alias -Name Get-ASACases -Value Get-ASACase
Set-Alias -Name Get-ASACommunications -Value Get-ASACommunication
Set-Alias -Name Get-ASAServices -Value Get-ASAService
Set-Alias -Name Get-ASASeverityLevels -Value Get-ASASeverityLevel
Set-Alias -Name Get-ASATrustedAdvisorCheckRefreshStatuses -Value Get-ASATrustedAdvisorCheckRefreshStatus
Set-Alias -Name Get-ASATrustedAdvisorChecks -Value Get-ASATrustedAdvisorCheck
Set-Alias -Name Get-ASATrustedAdvisorCheckSummaries -Value Get-ASATrustedAdvisorCheckSummary

# Backup
Set-Alias -Name Remove-BAKBackupVaultNotifications -Value Remove-BAKBackupVaultNotification

# Batch
Set-Alias -Name Get-BATJobsList -Value Get-BATJobList

# CloudFormation
Set-Alias -Name Get-CFNAccountLimits -Value Get-CFNAccountLimit
Set-Alias -Name Get-CFNStackEvents -Value Get-CFNStackEvent
Set-Alias -Name Get-CFNStackResources -Value Get-CFNStackResourceList
Set-Alias -Name Get-CFNStackResourceSummaries -Value Get-CFNStackResourceSummary
Set-Alias -Name Get-CFNStackSummaries -Value Get-CFNStackSummary

# CloudFront
Set-Alias -Name Get-CFCloudFrontOriginAccessIdentities -Value Get-CFCloudFrontOriginAccessIdentityList
Set-Alias -Name Get-CFDistributions -Value Get-CFDistributionList
Set-Alias -Name Get-CFInvalidations -Value Get-CFInvalidationList
Set-Alias -Name Get-CFStreamingDistributions -Value Get-CFStreamingDistributionList

# CloudHSM
Set-Alias -Name Get-HSMAvailableZones -Value Get-HSMAvailableZone

# CloudSearch
Set-Alias -Name Get-CSAnalysisSchemes -Value Get-CSAnalysisScheme
Set-Alias -Name Get-CSAvailabilityOptions -Value Get-CSAvailabilityOption
Set-Alias -Name Get-CSIndexFields -Value Get-CSIndexField
Set-Alias -Name Get-CSListDomainNames -Value Get-CSDomainNameList
Set-Alias -Name Get-CSScalingParameters -Value Get-CSScalingParameter
Set-Alias -Name Get-CSServiceAccessPolicies -Value Get-CSServiceAccessPolicy
Set-Alias -Name Update-CSAvailabilityOptions -Value Update-CSAvailabilityOption
Set-Alias -Name Update-CSScalingParameters -Value Update-CSScalingParameter
Set-Alias -Name Update-CSServiceAccessPolicies -Value Update-CSServiceAccessPolicy

# CloudSearchDomain
Set-Alias -Name Get-CSDSuggestions -Value Get-CSDSuggestion
Set-Alias -Name Search-CSDDocuments -Value Search-CSDDocument
Set-Alias -Name Write-CSDDocuments -Value Write-CSDDocument

# CloudTrail
Set-Alias -Name Add-CTTag -Value Add-CTResourceTag
Set-Alias -Name Find-CTEvents -Value Find-CTEvent
Set-Alias -Name Get-CTEventSelectors -Value Get-CTEventSelector
Set-Alias -Name Get-CTTag -Value Get-CTResourceTag
Set-Alias -Name Remove-CTTag -Value Remove-CTResourceTag
Set-Alias -Name Write-CTEventSelectors -Value Write-CTEventSelector

# CloudWatch
Set-Alias -Name Get-CWMetrics -Value Get-CWMetricList
Set-Alias -Name Get-CWMetricStatistics -Value Get-CWMetricStatistic

# CloudWatchLogs
Set-Alias -Name Get-CWLExportTasks -Value Get-CWLExportTask
Set-Alias -Name Get-CWLLogEvents -Value Get-CWLLogEvent
Set-Alias -Name Get-CWLLogGroups -Value Get-CWLLogGroup
Set-Alias -Name Get-CWLLogStreams -Value Get-CWLLogStream
Set-Alias -Name Get-CWLMetricFilters -Value Get-CWLMetricFilter
Set-Alias -Name Get-CWLSubscriptionFilters -Value Get-CWLSubscriptionFilter
Set-Alias -Name Write-CWLLogEvents -Value Write-CWLLogEvent

# CodeDeploy
Set-Alias -Name Get-CDApplications -Value Get-CDApplicationBatch
Set-Alias -Name Get-CDDeployments -Value Get-CDDeploymentBatch

# CodePipeline
Set-Alias -Name Get-CPActionableJobs -Value Get-CPActionableJobList
Set-Alias -Name Get-CPActionableThirdPartyJobs -Value Get-CPActionableThirdPartyJobList
Set-Alias -Name Get-CPJobDetails -Value Get-CPJobDetail
Set-Alias -Name Get-CPThirdPartyJobDetails -Value Get-CPThirdPartyJobDetail

# ConfigService
Set-Alias -Name Get-CFGConfigRules -Value Get-CFGConfigRule
Set-Alias -Name Get-CFGConfigurationRecorders -Value Get-CFGConfigurationRecorder
Set-Alias -Name Get-CFGDeliveryChannels -Value Get-CFGDeliveryChannel
Set-Alias -Name Write-CFGEvaluations -Value Write-CFGEvaluation

# CostAndUsageReport
Set-Alias -Name Get-CURReportDefinitions -Value Get-CURReportDefinition

# DataPipeline
Set-Alias -Name Add-DPTags -Value Add-DPResourceTag
Set-Alias -Name Remove-DPTags -Value Remove-DPResourceTag

# DirectConnect
Set-Alias -Name Get-DCLocations -Value Get-DCLocation

# DirectoryService
Set-Alias -Name Add-DSIpRoutes -Value Add-DSIpRoute
Set-Alias -Name Get-DSIpRoutes -Value Get-DSIpRouteList
Set-Alias -Name Remove-DSIpRoutes -Value Remove-DSIpRoute

# DynamoDBv2
Set-Alias -Name Get-DDBBackupsList -Value Get-DDBBackupList
Set-Alias -Name Get-DDBTables -Value Get-DDBTableList
Set-Alias -Name Get-GlobalTablesList -Value Get-GlobalTableList

# EC2
Set-Alias -Name Confirm-EC2EndpointConnection -Value Approve-EC2EndpointConnection
Set-Alias -Name Confirm-EC2ReservedInstancesExchangeQuote -Value Approve-EC2ReservedInstancesExchangeQuote
Set-Alias -Name Confirm-EC2TransitGatewayPeeringAttachment -Value Approve-EC2TransitGatewayPeeringAttachment
Set-Alias -Name Confirm-EC2TransitGatewayVpcAttachment -Value Approve-EC2TransitGatewayVpcAttachment
Set-Alias -Name Confirm-EC2VpcPeeringConnection -Value Approve-EC2VpcPeeringConnection
Set-Alias -Name Edit-EC2Hosts -Value Edit-EC2Host
Set-Alias -Name Get-EC2AccountAttributes -Value Get-EC2AccountAttribute
Set-Alias -Name Get-EC2ExportTasks -Value Get-EC2ExportTask
Set-Alias -Name Get-EC2FlowLogs -Value Get-EC2FlowLog
Set-Alias -Name Get-EC2Hosts -Value Get-EC2Host
Set-Alias -Name Get-EC2ReservedInstancesModifications -Value Get-EC2ReservedInstancesModification
Set-Alias -Name Get-EC2Snapshots -Value Get-EC2Snapshot
Set-Alias -Name Get-EC2VpcPeeringConnections -Value Get-EC2VpcPeeringConnection
Set-Alias -Name New-EC2FlowLogs -Value New-EC2FlowLog
Set-Alias -Name New-EC2Hosts -Value New-EC2Host
Set-Alias -Name ReleaseHosts -Value Remove-EC2Host
Set-Alias -Name Remove-EC2FlowLogs -Value Remove-EC2FlowLog

# ECS
Set-Alias -Name Get-ECSClusters -Value Get-ECSClusterList
Set-Alias -Name Get-ECSContainerInstances -Value Get-ECSContainerInstanceList
Set-Alias -Name Get-ECSTaskDefinitionFamilies -Value Get-ECSTaskDefinitionFamilyList
Set-Alias -Name Get-ECSTaskDefinitions -Value Get-ECSTaskDefinitionList
Set-Alias -Name Get-ECSTasks -Value Get-ECSTaskList

# ElastiCache
Set-Alias -Name Get-ECCacheEngineVersions -Value Get-ECCacheEngineVersion
Set-Alias -Name Get-ECCacheSubnetGroups -Value Get-ECCacheSubnetGroup
Set-Alias -Name Get-ECReplicationGroups -Value Get-ECReplicationGroup
Set-Alias -Name Get-ECSnapshots -Value Get-ECSnapshot

# ElasticBeanstalk
Set-Alias -Name Get-EBApplications -Value Get-EBApplication
Set-Alias -Name Get-EBApplicationVersions -Value Get-EBApplicationVersion
Set-Alias -Name Get-EBAvailableSolutionStack -Value Get-EBAvailableSolutionStackList
Set-Alias -Name Get-EBConfigurationOptions -Value Get-EBConfigurationOption
Set-Alias -Name Get-EBConfigurationSettings -Value Get-EBConfigurationSetting
Set-Alias -Name Get-EBEnvironmentResources -Value Get-EBEnvironmentResource
Set-Alias -Name Set-EBEnvironmentCNAMEs -Value Set-EBEnvironmentCNAME
Set-Alias -Name Test-EBConfigurationSettings -Value Test-EBConfigurationSetting

# ElasticLoadBalancing
Set-Alias -Name Add-ELBTags -Value Add-ELBResourceTag
Set-Alias -Name Get-ELBTags -Value Get-ELBResourceTag
Set-Alias -Name Remove-ELBTags -Value Remove-ELBResourceTag

# ElasticMapReduce
Set-Alias -Name Add-EMRTag -Value Add-EMRResourceTag
Set-Alias -Name Get-EMRBootstrapActions -Value Get-EMRBootstrapActionList
Set-Alias -Name Get-EMRClusters -Value Get-EMRClusterList
Set-Alias -Name Get-EMRInstanceFleets -Value Get-EMRInstanceFleetList
Set-Alias -Name Get-EMRInstanceGroups -Value Get-EMRInstanceGroupList
Set-Alias -Name Get-EMRInstances -Value Get-EMRInstanceList
Set-Alias -Name Get-EMRSteps -Value Get-EMRStepList
Set-Alias -Name Remove-EMRTag -Value Remove-EMRResourceTag
Set-Alias -Name Set-EMRVisibleToAllUsers -Value Set-EMRVisibleToAllUser
Set-Alias -Name Stop-EMRSteps -Value Stop-EMRStep

# Elasticsearch
Set-Alias -Name Add-ESTag -Value Add-ESResourceTag
Set-Alias -Name Get-ESTag -Value Get-ESResourceTag
Set-Alias -Name Remove-ESTag -Value Remove-ESResourceTag

# ElasticTranscoder
Set-Alias -Name Update-ETSPipelineNotifications -Value Update-ETSPipelineNotification

# Glacier
Set-Alias -Name Get-GLCVaultTagsList -Value Get-GLCVaultTagList

# Glue
Set-Alias -Name Get-GLUECrawlerMetricsList -Value Get-GLUECrawlerMetricList

# IdentityManagement
Set-Alias -Name Get-IAMAccountAuthorizationDetails -Value Get-IAMAccountAuthorizationDetail
Set-Alias -Name Get-IAMAttachedGroupPolicies -Value Get-IAMAttachedGroupPolicyList
Set-Alias -Name Get-IAMAttachedRolePolicies -Value Get-IAMAttachedRolePolicyList
Set-Alias -Name Get-IAMAttachedUserPolicies -Value Get-IAMAttachedUserPolicyList
Set-Alias -Name Get-IAMGroupPolicies -Value Get-IAMGroupPolicyList
Set-Alias -Name Get-IAMGroups -Value Get-IAMGroupList
Set-Alias -Name Get-IAMInstanceProfiles -Value Get-IAMInstanceProfileList
Set-Alias -Name Get-IAMOpenIDConnectProviders -Value Get-IAMOpenIDConnectProviderList
Set-Alias -Name Get-IAMPolicies -Value Get-IAMPolicyList
Set-Alias -Name Get-IAMPolicyVersions -Value Get-IAMPolicyVersionList
Set-Alias -Name Get-IAMRolePolicies -Value Get-IAMRolePolicyList
Set-Alias -Name Get-IAMRoles -Value Get-IAMRoleList
Set-Alias -Name Get-IAMSAMLProviders -Value Get-IAMSAMLProviderList
Set-Alias -Name Get-IAMServerCertificates -Value Get-IAMServerCertificateList
Set-Alias -Name Get-IAMUserPolicies -Value Get-IAMUserPolicyList
Set-Alias -Name Get-IAMUsers -Value Get-IAMUserList

# IoT
Set-Alias -Name Get-IOTAttachedPoliciesList -Value Get-IOTAttachedPolicyList
Set-Alias -Name Get-IOTAuthorizersList -Value Get-IOTAuthorizerList
Set-Alias -Name Get-IOTIndicesList -Value Get-IOTIndexList
Set-Alias -Name Get-IOTJobsList -Value Get-IOTJobList
Set-Alias -Name Get-IOTLoggingOptions -Value Get-IOTLoggingOption
Set-Alias -Name Get-IOTPolicyPrincipalsList -Value Get-IOTPolicyPrincipalList
Set-Alias -Name Get-IOTRoleAliasesList -Value Get-IOTRoleAliasList
Set-Alias -Name Get-IOTThingGroupsList -Value Get-IOTThingGroupList
Set-Alias -Name Get-IOTThingRegistrationTaskReportsList -Value Get-IOTThingRegistrationTaskReportList
Set-Alias -Name Get-IOTThingRegistrationTasksList -Value Get-IOTThingRegistrationTaskList
Set-Alias -Name Get-IOTThingTypesList -Value Get-IOTThingTypeList
Set-Alias -Name Get-IOTV2LoggingLevelsList -Value Get-IOTV2LoggingLevelList
Set-Alias -Name Get-IOTViolationEventsList -Value Get-IOTViolationEventList
Set-Alias -Name Set-IOTLoggingOptions -Value Set-IOTLoggingOption

# KeyManagementService
Set-Alias -Name Get-KMSAliases -Value Get-KMSAliasList
Set-Alias -Name Get-KMSGrants -Value Get-KMSGrantList
Set-Alias -Name Get-KMSKeyPolicies -Value Get-KMSKeyPolicyList
Set-Alias -Name Get-KMSKeys -Value Get-KMSKeyList

# Kinesis
Set-Alias -Name Get-KINStreams -Value Get-KINStreamList

# Lambda
Set-Alias -Name Get-LMEventSourceMappings -Value Get-LMEventSourceMappingList
Set-Alias -Name Get-LMFunctions -Value Get-LMFunctionList

# LexModelsV2
Set-Alias -Name Build-LMBV2BotLocale -Value Invoke-LMBV2BuildBotLocale

# MachineLearning
Set-Alias -Name Add-MLTag -Value Add-MLResourceTag
Set-Alias -Name Get-MLBatchPredictions -Value Get-MLBatchPredictionList
Set-Alias -Name Get-MLDataSources -Value Get-MLDataSourceList
Set-Alias -Name Get-MLEvaluations -Value Get-MLEvaluationList
Set-Alias -Name Get-MLModels -Value Get-MLModelList
Set-Alias -Name Get-MLTag -Value Get-MLResourceTag
Set-Alias -Name Remove-MLTag -Value Remove-MLResourceTag

# OpenSearchService
Set-Alias -Name Add-ESTag -Value Add-OSResourceTag
Set-Alias -Name Get-ESTag -Value Get-OSResourceTag
Set-Alias -Name Remove-ESTag -Value Remove-OSResourceTag

# Organizations
Set-Alias -Name Enable-ORGAllFeatures -Value Enable-ORGAllFeature

# RDS
Set-Alias -Name Get-RDSAccountAttributes -Value Get-RDSAccountAttribute
Set-Alias -Name Get-RDSCertificates -Value Get-RDSCertificate
Set-Alias -Name Get-RDSDBLogFiles -Value Get-RDSDBLogFile
Set-Alias -Name Get-RDSDBSnapshotAttributes -Value Get-RDSDBSnapshotAttribute
Set-Alias -Name Get-RDSEventCategories -Value Get-RDSEventCategory
Set-Alias -Name Get-RDSEventSubscriptions -Value Get-RDSEventSubscription
Set-Alias -Name Get-RDSPendingMaintenanceActions -Value Get-RDSPendingMaintenanceAction
Set-Alias -Name Get-RDSReservedDBInstancesOffering -Value New-RDSReservedDBInstancesOfferingPurchase
Set-Alias -Name Get-RDSReservedDBInstancesOfferings -Value Get-RDSReservedDBInstancesOfferingList

# RDSDataService
Set-Alias -Name Begin-RDSDTransaction -Value Start-RDSDTransaction
Set-Alias -Name Commit-RDSDTransaction -Value Confirm-RDSDTransaction
Set-Alias -Name Rollback-RDSDTransaction -Value Reset-RDSDTransaction

# Redshift
Set-Alias -Name Edit-RSClusterIamRoles -Value Edit-RSClusterIamRole
Set-Alias -Name Get-RSClusterParameterGroups -Value Get-RSClusterParameterGroup
Set-Alias -Name Get-RSClusterParameters -Value Get-RSClusterParameter
Set-Alias -Name Get-RSClusters -Value Get-RSCluster
Set-Alias -Name Get-RSClusterSecurityGroups -Value Get-RSClusterSecurityGroup
Set-Alias -Name Get-RSClusterSnapshots -Value Get-RSClusterSnapshot
Set-Alias -Name Get-RSClusterSubnetGroups -Value Get-RSClusterSubnetGroup
Set-Alias -Name Get-RSClusterVersions -Value Get-RSClusterVersion
Set-Alias -Name Get-RSDefaultClusterParameters -Value Get-RSDefaultClusterParameter
Set-Alias -Name Get-RSEventCategories -Value Get-RSEventCategory
Set-Alias -Name Get-RSEvents -Value Get-RSEvent
Set-Alias -Name Get-RSEventSubscriptions -Value Get-RSEventSubscription
Set-Alias -Name Get-RSHsmClientCertificates -Value Get-RSHsmClientCertificate
Set-Alias -Name Get-RSHsmConfigurations -Value Get-RSHsmConfiguration
Set-Alias -Name Get-RSOrderableClusterOptions -Value Get-RSOrderableClusterOption
Set-Alias -Name Get-RSReservedNodeOfferings -Value Get-RSReservedNodeOffering
Set-Alias -Name Get-RSReservedNodes -Value Get-RSReservedNode
Set-Alias -Name Get-RSTags -Value Get-RSResourceTag
Set-Alias -Name New-RSTags -Value New-RSResourceTag
Set-Alias -Name Remove-RSTags -Value Remove-RSResourceTag

# Rekognition
Set-Alias -Name Get-REKStreamProcessorsList -Value Get-REKStreamProcessorList

# Route53
Set-Alias -Name Get-R53CheckerIpRanges -Value Get-R53CheckerIpRange
Set-Alias -Name Get-R53GeoLocations -Value Get-R53GeoLocationList
Set-Alias -Name Get-R53HealthChecks -Value Get-R53HealthCheckList
Set-Alias -Name Get-R53HostedZones -Value Get-R53HostedZoneList
Set-Alias -Name Get-R53ReusableDelegationSets -Value Get-R53ReusableDelegationSetList
Set-Alias -Name Get-R53TagsForResources -Value Get-R53TagsForResourceList
Set-Alias -Name Get-R53TrafficPolicies -Value Get-R53TrafficPolicyList
Set-Alias -Name Get-R53TrafficPolicyInstances -Value Get-R53TrafficPolicyInstanceList
Set-Alias -Name Get-R53TrafficPolicyVersions -Value Get-R53TrafficPolicyVersionList

# Route53Domains
Set-Alias -Name Get-R53DDomainAvailability -Value Test-R53DDomainAvailability
Set-Alias -Name Get-R53DDomains -Value Get-R53DDomainList
Set-Alias -Name Get-R53DOperations -Value Get-R53DOperationList
Set-Alias -Name Update-R53DDomainNameservers -Value Update-R53DDomainNameserver

# S3
Set-Alias -Name Remove-S3MultipartUploads -Value Remove-S3MultipartUpload

# ServiceCatalog
Set-Alias -Name Get-SCAcceptedPortfolioSharesList -Value Get-SCAcceptedPortfolioShareList
Set-Alias -Name Get-SCProductPortfoliosList -Value Get-SCProductPortfolioList

# SimpleEmail
Set-Alias -Name Get-SESIdentityMailFromDomainAttributes -Value Get-SESIdentityMailFromDomainAttribute
Set-Alias -Name Get-SESReceiptFilters -Value Get-SESReceiptFilterList
Set-Alias -Name Get-SESReceiptRuleSets -Value Get-SESReceiptRuleSetList
Set-Alias -Name Get-SESSendStatistics -Value Get-SESSendStatistic

# SimpleNotificationService
Set-Alias -Name Get-SNSEndpointAttributes -Value Get-SNSEndpointAttribute
Set-Alias -Name Get-SNSPlatformApplicationAttributes -Value Get-SNSPlatformApplicationAttribute
Set-Alias -Name Get-SNSPlatformApplications -Value Get-SNSPlatformApplicationList
Set-Alias -Name Get-SNSSMSAttributes -Value Get-SNSSMSAttribute
Set-Alias -Name Set-SNSEndpointAttributes -Value Set-SNSEndpointAttribute
Set-Alias -Name Set-SNSPlatformApplicationAttributes -Value Set-SNSPlatformApplicationAttribute
Set-Alias -Name Set-SNSSMSAttributes -Value Set-SNSSMSAttribute

# SimpleSystemsManagement
Set-Alias -Name Get-SSMComplianceItemsList -Value Get-SSMComplianceItemList
Set-Alias -Name Get-SSMComplianceSummariesList -Value Get-SSMComplianceSummaryList
Set-Alias -Name Get-SSMInventoryEntriesList -Value Get-SSMInventoryEntryList
Set-Alias -Name Get-SSMMaintenanceWindowTargets -Value Get-SSMMaintenanceWindowTarget
Set-Alias -Name Get-SSMParameterNameList -Value Get-SSMParameterValue
Set-Alias -Name Get-SSMResourceComplianceSummariesList -Value Get-SSMResourceComplianceSummaryList

# Snowball
Set-Alias -Name Get-SNOWJobsList -Value Get-SNOWJobList

# SQS
Set-Alias -Name Get-SQSDeadLetterSourceQueues -Value Get-SQSDeadLetterSourceQueue

# StorageGateway
Set-Alias -Name Get-SGChapCredentials -Value Get-SGChapCredential
Set-Alias -Name Get-SGResourceTags -Value Get-SGResourceTag
Set-Alias -Name Get-SGTapeArchives -Value Get-SGTapeArchiveList
Set-Alias -Name Get-SGTapeRecoveryPoints -Value Get-SGTapeRecoveryPointList
Set-Alias -Name Get-SGTapes -Value Get-SGTapeList
Set-Alias -Name Get-SGVolumeInitiators -Value Get-SGVolumeInitiatorList
Set-Alias -Name Get-SGVTLDevices -Value Get-SGVTLDevice
Set-Alias -Name New-SGTapes -Value New-SGTape
Set-Alias -Name Remove-SGChapCredentials -Value Remove-SGChapCredential
Set-Alias -Name Update-SGChapCredentials -Value Update-SGChapCredential

# WellArchitected
Set-Alias -Name Add-WATLense -Value Register-WATLens
Set-Alias -Name Get-WATLenseList -Value Get-WATLensList
Set-Alias -Name Remove-WATLense -Value Unregister-WATLens

# WorkSpaces
Set-Alias -Name Get-WKSWorkspaceBundles -Value Get-WKSWorkspaceBundle
Set-Alias -Name Get-WKSWorkspaceDirectories -Value Get-WKSWorkspaceDirectory
Set-Alias -Name Get-WKSWorkspaces -Value Get-WKSWorkspace

Export-ModuleMember -Alias *
# SIG # Begin signature block
# MIIutAYJKoZIhvcNAQcCoIIupTCCLqECAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCByF1bScYpLc8zG
# h4+5bbgEn8uk+NpCbE1yWkE9YuCovaCCE+owggXAMIIEqKADAgECAhAP0bvKeWvX
# +N1MguEKmpYxMA0GCSqGSIb3DQEBCwUAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQK
# EwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xKzApBgNV
# BAMTIkRpZ2lDZXJ0IEhpZ2ggQXNzdXJhbmNlIEVWIFJvb3QgQ0EwHhcNMjIwMTEz
# MDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEVMBMGA1UEChMM
# RGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQD
# ExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3DQEBAQUAA4IC
# DwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZwuEppz1Yq3aa
# za57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4VpX6+n6lXFllV
# cq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAdYyktzuxeTsiT
# +CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3T6cw2Vbuyntd
# 463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjUN6QuBX2I9YI+
# EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNdaSaTC5qmgZ92k
# J7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtmmnTK3kse5w5j
# rubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyVw4/3IbKyEbe7
# f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3AeEPlAwhHbJU
# KSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYiCd98THU/Y+wh
# X8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmpsh3lGwIDAQAB
# o4IBZjCCAWIwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7NfjgtJxXWRM3y5n
# P+e6mK4cD08wHwYDVR0jBBgwFoAUsT7DaQP4v0cB1JgmGggC72NkK8MwDgYDVR0P
# AQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMH8GCCsGAQUFBwEBBHMwcTAk
# BggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEkGCCsGAQUFBzAC
# hj1odHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNzdXJh
# bmNlRVZSb290Q0EuY3J0MEsGA1UdHwREMEIwQKA+oDyGOmh0dHA6Ly9jcmwzLmRp
# Z2ljZXJ0LmNvbS9EaWdpQ2VydEhpZ2hBc3N1cmFuY2VFVlJvb3RDQS5jcmwwHAYD
# VR0gBBUwEzAHBgVngQwBAzAIBgZngQwBBAEwDQYJKoZIhvcNAQELBQADggEBAEHx
# qRH0DxNHecllao3A7pgEpMbjDPKisedfYk/ak1k2zfIe4R7sD+EbP5HU5A/C5pg0
# /xkPZigfT2IxpCrhKhO61z7H0ZL+q93fqpgzRh9Onr3g7QdG64AupP2uU7SkwaT1
# IY1rzAGt9Rnu15ClMlIr28xzDxj4+87eg3Gn77tRWwR2L62t0+od/P1Tk+WMieNg
# GbngLyOOLFxJy34riDkruQZhiPOuAnZ2dMFkkbiJUZflhX0901emWG4f7vtpYeJa
# 3Cgh6GO6Ps9W7Zrk9wXqyvPsEt84zdp7PiuTUy9cUQBY3pBIowrHC/Q7bVUx8ALM
# R3eWUaNetbxcyEMRoacwggawMIIEmKADAgECAhAIrUCyYNKcTJ9ezam9k67ZMA0G
# CSqGSIb3DQEBDAUAMGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJ
# bmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERpZ2lDZXJ0
# IFRydXN0ZWQgUm9vdCBHNDAeFw0yMTA0MjkwMDAwMDBaFw0zNjA0MjgyMzU5NTla
# MGkxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjFBMD8GA1UE
# AxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNpZ25pbmcgUlNBNDA5NiBTSEEz
# ODQgMjAyMSBDQTEwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDVtC9C
# 0CiteLdd1TlZG7GIQvUzjOs9gZdwxbvEhSYwn6SOaNhc9es0JAfhS0/TeEP0F9ce
# 2vnS1WcaUk8OoVf8iJnBkcyBAz5NcCRks43iCH00fUyAVxJrQ5qZ8sU7H/Lvy0da
# E6ZMswEgJfMQ04uy+wjwiuCdCcBlp/qYgEk1hz1RGeiQIXhFLqGfLOEYwhrMxe6T
# SXBCMo/7xuoc82VokaJNTIIRSFJo3hC9FFdd6BgTZcV/sk+FLEikVoQ11vkunKoA
# FdE3/hoGlMJ8yOobMubKwvSnowMOdKWvObarYBLj6Na59zHh3K3kGKDYwSNHR7Oh
# D26jq22YBoMbt2pnLdK9RBqSEIGPsDsJ18ebMlrC/2pgVItJwZPt4bRc4G/rJvmM
# 1bL5OBDm6s6R9b7T+2+TYTRcvJNFKIM2KmYoX7BzzosmJQayg9Rc9hUZTO1i4F4z
# 8ujo7AqnsAMrkbI2eb73rQgedaZlzLvjSFDzd5Ea/ttQokbIYViY9XwCFjyDKK05
# huzUtw1T0PhH5nUwjewwk3YUpltLXXRhTT8SkXbev1jLchApQfDVxW0mdmgRQRNY
# mtwmKwH0iU1Z23jPgUo+QEdfyYFQc4UQIyFZYIpkVMHMIRroOBl8ZhzNeDhFMJlP
# /2NPTLuqDQhTQXxYPUez+rbsjDIJAsxsPAxWEQIDAQABo4IBWTCCAVUwEgYDVR0T
# AQH/BAgwBgEB/wIBADAdBgNVHQ4EFgQUaDfg67Y7+F8Rhvv+YXsIiGX0TkIwHwYD
# VR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6mK4cD08wDgYDVR0PAQH/BAQDAgGGMBMG
# A1UdJQQMMAoGCCsGAQUFBwMDMHcGCCsGAQUFBwEBBGswaTAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEEGCCsGAQUFBzAChjVodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNydDBDBgNV
# HR8EPDA6MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRU
# cnVzdGVkUm9vdEc0LmNybDAcBgNVHSAEFTATMAcGBWeBDAEDMAgGBmeBDAEEATAN
# BgkqhkiG9w0BAQwFAAOCAgEAOiNEPY0Idu6PvDqZ01bgAhql+Eg08yy25nRm95Ry
# sQDKr2wwJxMSnpBEn0v9nqN8JtU3vDpdSG2V1T9J9Ce7FoFFUP2cvbaF4HZ+N3HL
# IvdaqpDP9ZNq4+sg0dVQeYiaiorBtr2hSBh+3NiAGhEZGM1hmYFW9snjdufE5Btf
# Q/g+lP92OT2e1JnPSt0o618moZVYSNUa/tcnP/2Q0XaG3RywYFzzDaju4ImhvTnh
# OE7abrs2nfvlIVNaw8rpavGiPttDuDPITzgUkpn13c5UbdldAhQfQDN8A+KVssIh
# dXNSy0bYxDQcoqVLjc1vdjcshT8azibpGL6QB7BDf5WIIIJw8MzK7/0pNVwfiThV
# 9zeKiwmhywvpMRr/LhlcOXHhvpynCgbWJme3kuZOX956rEnPLqR0kq3bPKSchh/j
# wVYbKyP/j7XqiHtwa+aguv06P0WmxOgWkVKLQcBIhEuWTatEQOON8BUozu3xGFYH
# Ki8QxAwIZDwzj64ojDzLj4gLDb879M4ee47vtevLt/B3E+bnKD+sEq6lLyJsQfmC
# XBVmzGwOysWGw/YmMwwHS6DTBwJqakAwSEs0qFEgu60bhQjiWQ1tygVQK+pKHJ6l
# /aCnHwZ05/LWUpD9r4VIIflXO7ScA+2GRfS0YW6/aOImYIbqyK+p/pQd52MbOoZW
# eE4wggduMIIFVqADAgECAhADmooc3J4LAjb9FLn2g0iAMA0GCSqGSIb3DQEBCwUA
# MGkxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjFBMD8GA1UE
# AxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNpZ25pbmcgUlNBNDA5NiBTSEEz
# ODQgMjAyMSBDQTEwHhcNMjUwNjAzMDAwMDAwWhcNMjYwNjAyMjM1OTU5WjCB9jET
# MBEGCysGAQQBgjc8AgEDEwJVUzEZMBcGCysGAQQBgjc8AgECEwhEZWxhd2FyZTEd
# MBsGA1UEDwwUUHJpdmF0ZSBPcmdhbml6YXRpb24xEDAOBgNVBAUTBzQxNTI5NTQx
# CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdTZWF0
# dGxlMSIwIAYDVQQKExlBbWF6b24gV2ViIFNlcnZpY2VzLCBJbmMuMRcwFQYDVQQL
# Ew5TREtzIGFuZCBUb29sczEiMCAGA1UEAxMZQW1hem9uIFdlYiBTZXJ2aWNlcywg
# SW5jLjCCAaIwDQYJKoZIhvcNAQEBBQADggGPADCCAYoCggGBAKc7ffRFlFB89cU3
# j76EOoK8sFXFunuUhvU6LMeAzgO2fjlMn2l3WJBPZmrHXIicBHmejbJDRgMc+FPd
# oSUR6ZsuVX08txcdv8yHqC+u2BHrj+GRakq7WF148X1PR8kOhkon+qNSh+cxoIHm
# m+Lxg9kZuddkr1m+Fuv79VGj3E9xp4YjbhvVEVbxLs86p812WgVz3eoqvpNXBC0m
# H4eM3FUmNHcDA6ubRR/qh3OGYQHyQs4PeMOGACqcySO+XNRKxMNxIzf+fkQU8cuR
# A8eYl6s0pQ+KlJudGt2psY+5nkTU9TOC99wvRmfuuG+jpG7vEMsuGy26wCOp7hry
# k5kinq/EFImAxdx1WQ3pJuk+rcuSnuOcSieW+zSKEczJOCsbemDbF+9P5Iv0f0nx
# kHPYrrjdgValyxosQENsHeq1HztsE46IbBq2S4I9kGzZcaal5hKT/Yxcom9tBfXq
# oNs1KaL54mC4ddBGx07kAGE0kiHpY5pr4al2lGpOmBH4B5xKmwIDAQABo4ICAjCC
# Af4wHwYDVR0jBBgwFoAUaDfg67Y7+F8Rhvv+YXsIiGX0TkIwHQYDVR0OBBYEFALy
# CdwoelU9i0FZLXOC5NXeXmVqMD0GA1UdIAQ2MDQwMgYFZ4EMAQMwKTAnBggrBgEF
# BQcCARYbaHR0cDovL3d3dy5kaWdpY2VydC5jb20vQ1BTMA4GA1UdDwEB/wQEAwIH
# gDATBgNVHSUEDDAKBggrBgEFBQcDAzCBtQYDVR0fBIGtMIGqMFOgUaBPhk1odHRw
# Oi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVkRzRDb2RlU2lnbmlu
# Z1JTQTQwOTZTSEEzODQyMDIxQ0ExLmNybDBToFGgT4ZNaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZEc0Q29kZVNpZ25pbmdSU0E0MDk2U0hB
# Mzg0MjAyMUNBMS5jcmwwgZQGCCsGAQUFBwEBBIGHMIGEMCQGCCsGAQUFBzABhhho
# dHRwOi8vb2NzcC5kaWdpY2VydC5jb20wXAYIKwYBBQUHMAKGUGh0dHA6Ly9jYWNl
# cnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNENvZGVTaWduaW5nUlNB
# NDA5NlNIQTM4NDIwMjFDQTEuY3J0MAkGA1UdEwQCMAAwDQYJKoZIhvcNAQELBQAD
# ggIBACHYo9QgnoH4+yG1TQT8lxxsYPuy3+FiWd2sZxn/4dwBautbZSLaP5yAKlE0
# o7SFQq5IYV2FVA4c5LwJf3eoF0/8+Bh+SMmAHTteqHcAJ3VK8+VETL/qr9kFQx8j
# cMA3kF2OOaLVWuB5ffEsGCRqCnS2r8r2lCstb/oEqJLyUXkqEDbyJxgkJ0vQp1XD
# agCi68ujhDBwVQPoHmBux2V8TWaOuAT/5kZUJsqwUhBTxYSCKVdIYYkRppaUemJ0
# oULhtxeg1M5zumgLf432qyk6xchohECA1QSXsPflhLZ+eWk3RneSt0fAV/caEBma
# mfVj4OysofDA4bCgZSWFk/16O4PEMsLZhR8FCnFr5lxFYKUgAcnVczo75KSBKp2r
# aoUVAWIw9w1Z1NQljqfZbFUxWCIWLjmXmEbfy3IXeEpvlXidjPVwdqwbleyl0WR/
# ENGBEiy+I4a/ezu+HoA5zK+1b7INjLgxk8m5MnD75k6Pq+XctyTkzEh6F4Whhq7s
# ck16llf7N+i28flIkqzcXuSHxeOZUZb2VNDIcCXiapaxS7cslbP4wafWGEYs2SN3
# +Q398T0fI7uJ4ATp58qdIp6w7Z9PomrVKE0LQMC1P1j9VDiCv7VqnU1cM/2uPpzA
# Lop57Q8mTPr7Mh7nl0/QusIr8V/o6XWwRynumecNqn1oeMlaMYIaIDCCGhwCAQEw
# fTBpMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNV
# BAMTOERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5nIFJTQTQwOTYgU0hB
# Mzg0IDIwMjEgQ0ExAhADmooc3J4LAjb9FLn2g0iAMA0GCWCGSAFlAwQCAQUAoHww
# EAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYK
# KwYBBAGCNwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIJml5+jI
# dx8m7hVpaM5qNRTGsY4FyOm1xE6dzxzBOTZgMA0GCSqGSIb3DQEBAQUABIIBgEFX
# nI4DqzycCO8onOXalhGb6EHIjWnlf13VIVbpZeP93y8Al1OC1KjTDd+J5RikyPaH
# b2lPl1PSgpwlx/KzT4WNJEnk0XK43xjClZI7rL3nKrBkLcqPFiszWL2c+c2B5rq3
# H+bgp0kiLYS/WDZlWLyvGUb1Ct+Emh/9SsRKGpjpvs8CLg6PFs0QOG1eQBJnmReM
# eCKBTNu1oVkwMcci/x/18tsQmldd8VwHlSPAUedhfiCI+e2EjWcg+HGkJ4J8RiTo
# rHYxb9yUTYYBsLBI9na1uOxwaqPW+qz42LjASKGXVetnwvl8NC44k5ImXpxParzI
# ozJBaWbY2U/YFUT56MsI07NPUHJ2XuEyN38dJFKHRkGV02/PdOAlDf5VXR4a7JBi
# JDL/1x3fl2OgQMfNk7ztiDCN47PB2QgNYyg1Vf7pVi88FxZ3OoYpONqgxUeo6MVB
# 73TinicGI8G4tdaTjV3wT8D8rAkNIfX0DlE1Qu5zVpt760QmHO7eIdA+qpGyiqGC
# F3YwghdyBgorBgEEAYI3AwMBMYIXYjCCF14GCSqGSIb3DQEHAqCCF08wghdLAgED
# MQ8wDQYJYIZIAWUDBAIBBQAwdwYLKoZIhvcNAQkQAQSgaARmMGQCAQEGCWCGSAGG
# /WwHATAxMA0GCWCGSAFlAwQCAQUABCC1gkCGj8WZuCGrBLQkLqHfjxK0nt78a5Mw
# /VxsC3RCiwIQQILAL/ejDhC2IP3xjLZScBgPMjAyNTEwMzEyMDQ0NTBaoIITOjCC
# Bu0wggTVoAMCAQICEAqA7xhLjfEFgtHEdqeVdGgwDQYJKoZIhvcNAQELBQAwaTEL
# MAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMUEwPwYDVQQDEzhE
# aWdpQ2VydCBUcnVzdGVkIEc0IFRpbWVTdGFtcGluZyBSU0E0MDk2IFNIQTI1NiAy
# MDI1IENBMTAeFw0yNTA2MDQwMDAwMDBaFw0zNjA5MDMyMzU5NTlaMGMxCzAJBgNV
# BAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNl
# cnQgU0hBMjU2IFJTQTQwOTYgVGltZXN0YW1wIFJlc3BvbmRlciAyMDI1IDEwggIi
# MA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDQRqwtEsae0OquYFazK1e6b1H/
# hnAKAd/KN8wZQjBjMqiZ3xTWcfsLwOvRxUwXcGx8AUjni6bz52fGTfr6PHRNv6T7
# zsf1Y/E3IU8kgNkeECqVQ+3bzWYesFtkepErvUSbf+EIYLkrLKd6qJnuzK8Vcn0D
# vbDMemQFoxQ2Dsw4vEjoT1FpS54dNApZfKY61HAldytxNM89PZXUP/5wWWURK+If
# xiOg8W9lKMqzdIo7VA1R0V3Zp3DjjANwqAf4lEkTlCDQ0/fKJLKLkzGBTpx6EYev
# vOi7XOc4zyh1uSqgr6UnbksIcFJqLbkIXIPbcNmA98Oskkkrvt6lPAw/p4oDSRZr
# eiwB7x9ykrjS6GS3NR39iTTFS+ENTqW8m6THuOmHHjQNC3zbJ6nJ6SXiLSvw4Smz
# 8U07hqF+8CTXaETkVWz0dVVZw7knh1WZXOLHgDvundrAtuvz0D3T+dYaNcwafsVC
# GZKUhQPL1naFKBy1p6llN3QgshRta6Eq4B40h5avMcpi54wm0i2ePZD5pPIssosz
# QyF4//3DoK2O65Uck5Wggn8O2klETsJ7u8xEehGifgJYi+6I03UuT1j7FnrqVrOz
# aQoVJOeeStPeldYRNMmSF3voIgMFtNGh86w3ISHNm0IaadCKCkUe2LnwJKa8TIlw
# CUNVwppwn4D3/Pt5pwIDAQABo4IBlTCCAZEwDAYDVR0TAQH/BAIwADAdBgNVHQ4E
# FgQU5Dv88jHt/f3X85FxYxlQQ89hjOgwHwYDVR0jBBgwFoAU729TSunkBnx6yuKQ
# VvYv1Ensy04wDgYDVR0PAQH/BAQDAgeAMBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMI
# MIGVBggrBgEFBQcBAQSBiDCBhTAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
# aWNlcnQuY29tMF0GCCsGAQUFBzAChlFodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5j
# b20vRGlnaUNlcnRUcnVzdGVkRzRUaW1lU3RhbXBpbmdSU0E0MDk2U0hBMjU2MjAy
# NUNBMS5jcnQwXwYDVR0fBFgwVjBUoFKgUIZOaHR0cDovL2NybDMuZGlnaWNlcnQu
# Y29tL0RpZ2lDZXJ0VHJ1c3RlZEc0VGltZVN0YW1waW5nUlNBNDA5NlNIQTI1NjIw
# MjVDQTEuY3JsMCAGA1UdIAQZMBcwCAYGZ4EMAQQCMAsGCWCGSAGG/WwHATANBgkq
# hkiG9w0BAQsFAAOCAgEAZSqt8RwnBLmuYEHs0QhEnmNAciH45PYiT9s1i6UKtW+F
# ERp8FgXRGQ/YAavXzWjZhY+hIfP2JkQ38U+wtJPBVBajYfrbIYG+Dui4I4PCvHpQ
# uPqFgqp1PzC/ZRX4pvP/ciZmUnthfAEP1HShTrY+2DE5qjzvZs7JIIgt0GCFD9kt
# x0LxxtRQ7vllKluHWiKk6FxRPyUPxAAYH2Vy1lNM4kzekd8oEARzFAWgeW3az2xe
# jEWLNN4eKGxDJ8WDl/FQUSntbjZ80FU3i54tpx5F/0Kr15zW/mJAxZMVBrTE2oi0
# fcI8VMbtoRAmaaslNXdCG1+lqvP4FbrQ6IwSBXkZagHLhFU9HCrG/syTRLLhAezu
# /3Lr00GrJzPQFnCEH1Y58678IgmfORBPC1JKkYaEt2OdDh4GmO0/5cHelAK2/gTl
# QJINqDr6JfwyYHXSd+V08X1JUPvB4ILfJdmL+66Gp3CSBXG6IwXMZUXBhtCyIaeh
# r0XkBoDIGMUG1dUtwq1qmcwbdUfcSYCn+OwncVUXf53VJUNOaMWMts0VlRYxe5nK
# +At+DI96HAlXHAL5SlfYxJ7La54i71McVWRP66bW+yERNpbJCjyCYG2j+bdpxo/1
# Cy4uPcU3AWVPGrbn5PhDBf3Froguzzhk++ami+r3Qrx5bIbY3TVzgiFI7Gq3zWcw
# gga0MIIEnKADAgECAhANx6xXBf8hmS5AQyIMOkmGMA0GCSqGSIb3DQEBCwUAMGIx
# CzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3
# dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERpZ2lDZXJ0IFRydXN0ZWQgUm9vdCBH
# NDAeFw0yNTA1MDcwMDAwMDBaFw0zODAxMTQyMzU5NTlaMGkxCzAJBgNVBAYTAlVT
# MRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjFBMD8GA1UEAxM4RGlnaUNlcnQgVHJ1
# c3RlZCBHNCBUaW1lU3RhbXBpbmcgUlNBNDA5NiBTSEEyNTYgMjAyNSBDQTEwggIi
# MA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQC0eDHTCphBcr48RsAcrHXbo0Zo
# dLRRF51NrY0NlLWZloMsVO1DahGPNRcybEKq+RuwOnPhof6pvF4uGjwjqNjfEvUi
# 6wuim5bap+0lgloM2zX4kftn5B1IpYzTqpyFQ/4Bt0mAxAHeHYNnQxqXmRinvuNg
# xVBdJkf77S2uPoCj7GH8BLuxBG5AvftBdsOECS1UkxBvMgEdgkFiDNYiOTx4OtiF
# cMSkqTtF2hfQz3zQSku2Ws3IfDReb6e3mmdglTcaarps0wjUjsZvkgFkriK9tUKJ
# m/s80FiocSk1VYLZlDwFt+cVFBURJg6zMUjZa/zbCclF83bRVFLeGkuAhHiGPMvS
# GmhgaTzVyhYn4p0+8y9oHRaQT/aofEnS5xLrfxnGpTXiUOeSLsJygoLPp66bkDX1
# ZlAeSpQl92QOMeRxykvq6gbylsXQskBBBnGy3tW/AMOMCZIVNSaz7BX8VtYGqLt9
# MmeOreGPRdtBx3yGOP+rx3rKWDEJlIqLXvJWnY0v5ydPpOjL6s36czwzsucuoKs7
# Yk/ehb//Wx+5kMqIMRvUBDx6z1ev+7psNOdgJMoiwOrUG2ZdSoQbU2rMkpLiQ6bG
# RinZbI4OLu9BMIFm1UUl9VnePs6BaaeEWvjJSjNm2qA+sdFUeEY0qVjPKOWug/G6
# X5uAiynM7Bu2ayBjUwIDAQABo4IBXTCCAVkwEgYDVR0TAQH/BAgwBgEB/wIBADAd
# BgNVHQ4EFgQU729TSunkBnx6yuKQVvYv1Ensy04wHwYDVR0jBBgwFoAU7NfjgtJx
# XWRM3y5nP+e6mK4cD08wDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUF
# BwMIMHcGCCsGAQUFBwEBBGswaTAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
# aWNlcnQuY29tMEEGCCsGAQUFBzAChjVodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5j
# b20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNydDBDBgNVHR8EPDA6MDigNqA0hjJo
# dHRwOi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNy
# bDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEwDQYJKoZIhvcNAQEL
# BQADggIBABfO+xaAHP4HPRF2cTC9vgvItTSmf83Qh8WIGjB/T8ObXAZz8OjuhUxj
# aaFdleMM0lBryPTQM2qEJPe36zwbSI/mS83afsl3YTj+IQhQE7jU/kXjjytJgnn0
# hvrV6hqWGd3rLAUt6vJy9lMDPjTLxLgXf9r5nWMQwr8Myb9rEVKChHyfpzee5kH0
# F8HABBgr0UdqirZ7bowe9Vj2AIMD8liyrukZ2iA/wdG2th9y1IsA0QF8dTXqvcnT
# mpfeQh35k5zOCPmSNq1UH410ANVko43+Cdmu4y81hjajV/gxdEkMx1NKU4uHQcKf
# ZxAvBAKqMVuqte69M9J6A47OvgRaPs+2ykgcGV00TYr2Lr3ty9qIijanrUR3anzE
# wlvzZiiyfTPjLbnFRsjsYg39OlV8cipDoq7+qNNjqFzeGxcytL5TTLL4ZaoBdqbh
# OhZ3ZRDUphPvSRmMThi0vw9vODRzW6AxnJll38F0cuJG7uEBYTptMSbhdhGQDpOX
# gpIUsWTjd6xpR6oaQf/DJbg3s6KCLPAlZ66RzIg9sC+NJpud/v4+7RWsWCiKi9EO
# LLHfMR2ZyJ/+xhCx9yHbxtl5TPau1j/1MIDpMPx0LckTetiSuEtQvLsNz3Qbp7wG
# WqbIiOWCnb5WqxL3/BAPvIXKUjPSxyZsq8WhbaM2tszWkPZPubdcMIIFjTCCBHWg
# AwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0EwHhcN
# MjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEVMBMG
# A1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMSEw
# HwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3DQEB
# AQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZwuEp
# pz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4VpX6+
# n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAdYykt
# zuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3T6cw
# 2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjUN6Qu
# BX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNdaSaTC
# 5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtmmnTK
# 3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyVw4/3
# IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3AeEP
# lAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYiCd98
# THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmpsh3l
# GwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7NfjgtJx
# XWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8w
# DgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYYaHR0
# cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2FjZXJ0
# cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUGA1Ud
# HwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3DQEB
# DAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+IcaaVQi
# 7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096wwepqL
# sl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcDx4eo
# 0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsgjTVg
# HAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37YOtnw
# toeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMYIDfDCCA3gCAQEwfTBpMQswCQYDVQQG
# EwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMTOERpZ2lDZXJ0
# IFRydXN0ZWQgRzQgVGltZVN0YW1waW5nIFJTQTQwOTYgU0hBMjU2IDIwMjUgQ0Ex
# AhAKgO8YS43xBYLRxHanlXRoMA0GCWCGSAFlAwQCAQUAoIHRMBoGCSqGSIb3DQEJ
# AzENBgsqhkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMjUxMDMxMjA0NDUwWjAr
# BgsqhkiG9w0BCRACDDEcMBowGDAWBBTdYjCshgotMGvaOLFoeVIwB/tBfjAvBgkq
# hkiG9w0BCQQxIgQgb14XEYGP/20rxMbMzHl9jVMKZNzSnS+zohk2m5foQlgwNwYL
# KoZIhvcNAQkQAi8xKDAmMCQwIgQgSqA/oizXXITFXJOPgo5na5yuyrM/420mmqM0
# 8UYRCjMwDQYJKoZIhvcNAQEBBQAEggIAoEO9BTGiQbion2NGPl7NDKwSYBAdWzh0
# x+3WRss9JUXNdQO4s16quRk4R2B5F/mWS34jDkre+82jnTl4G9uPGb5VjQ3xxe5I
# y25lU4dJAEtJN2+m18Qjb8b2VqfKAOY8f2F2o2dGmVRp0Hq7OWDNL3WuJSubvU09
# tdhH204+GE0BWfRRGh7UW/FTDdVIMKcWJt8B3IK+h0+paeCmQI7SDLLm8UWFV1c5
# UVy/pBdFzH8tNNSAvpWEyEc9POXTUaCqITN8WMp+Hj8D2rZRXjcwWXczBcMTPfmt
# NfqispJhxOrSkGA5LFmtlHDFbTV3sVBM0FvXT3O6Jart10WdB8T7LKjC5u/jQMqX
# qvCyBpsyoMMgNWdh4rKBaNidWoPL+9AVTPcpsdzQVNwPbT8KBgDMDZT/LzHq4e3N
# YJ9S/MQ2VuQUhbjVtLp9gaJT7bQJjRfMB2jBaKViIP0P7eLWjjLlix9aje2nhh5V
# JpdDq2DmPpuuEQOQo2Epsw99z+KVqk+dVW00myr9mkpL6fwDSDGm+E/ErlSmyyhQ
# CtA+puaq2/MnH534cw8EbONXCF0QA8aBI6MwiEVGCv/z+665RhJV+kUcm2ycomb3
# m+xUjr0BhYnuEvcbdkZlKh41gELYtyUlhVnU7JJp56CMre1BlKEzrC7RM1h+M8UO
# gFQV7d7+cRw=
# SIG # End signature block
