# Auto-generated argument completers for parameters of SDK ConstantClass-derived type used in cmdlets.
# Do not modify this file; it may be overwritten during version upgrades.

$psMajorVersion = $PSVersionTable.PSVersion.Major
if ($psMajorVersion -eq 2) 
{ 
	Write-Verbose "Dynamic argument completion not supported in PowerShell version 2; skipping load."
	return 
}

# PowerShell's native Register-ArgumentCompleter cmdlet is available on v5.0 or higher. For lower
# version, we can use the version in the TabExpansion++ module if installed.
$registrationCmdletAvailable = ($psMajorVersion -ge 5) -Or !((Get-Command Register-ArgumentCompleter -ea Ignore) -eq $null)

# internal function to perform the registration using either cmdlet or manipulation
# of the options table
function _awsArgumentCompleterRegistration()
{
    param
    (
        [scriptblock]$scriptBlock,
        [hashtable]$param2CmdletsMap
    )

    if ($registrationCmdletAvailable)
    {
        foreach ($paramName in $param2CmdletsMap.Keys)
        {
             $args = @{
                "ScriptBlock" = $scriptBlock
                "Parameter" = $paramName
            }

            $cmdletNames = $param2CmdletsMap[$paramName]
            if ($cmdletNames -And $cmdletNames.Length -gt 0)
            {
                $args["Command"] = $cmdletNames
            }

            Register-ArgumentCompleter @args
        }
    }
    else
    {
        if (-not $global:options) { $global:options = @{ CustomArgumentCompleters = @{ }; NativeArgumentCompleters = @{ } } }

        foreach ($paramName in $param2CmdletsMap.Keys)
        {
            $cmdletNames = $param2CmdletsMap[$paramName]

            if ($cmdletNames -And $cmdletNames.Length -gt 0)
            {
                foreach ($cn in $cmdletNames)
                {
                    $fqn =  [string]::Concat($cn, ":", $paramName)
                    $global:options['CustomArgumentCompleters'][$fqn] = $scriptBlock
                }
            }
            else
            {
                $global:options['CustomArgumentCompleters'][$paramName] = $scriptBlock
            }
        }

        $function:tabexpansion2 = $function:tabexpansion2 -replace 'End\r\n{', 'End { if ($null -ne $options) { $options += $global:options} else {$options = $global:options}'
    }
}

# To allow for same-name parameters of different ConstantClass-derived types 
# each completer function checks on command name concatenated with parameter name.
# Additionally, the standard code pattern for completers is to pipe through 
# sort-object after filtering against $wordToComplete but we omit this as our members 
# are already sorted.

# Argument completions for service AWS IAM Access Analyzer


$IAMAA_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.AccessAnalyzer.AccessCheckPolicyType
        {
            ($_ -eq "Test-IAMAAAccessNotGranted/PolicyType") -Or
            ($_ -eq "Test-IAMAANoNewAccess/PolicyType")
        }
        {
            $v = "IDENTITY_POLICY","RESOURCE_POLICY"
            break
        }

        # Amazon.AccessAnalyzer.AccessCheckResourceType
        "Test-IAMAANoPublicAccess/ResourceType"
        {
            $v = "AWS::ApiGateway::RestApi","AWS::Backup::BackupVault","AWS::CloudTrail::Dashboard","AWS::CloudTrail::EventDataStore","AWS::CodeArtifact::Domain","AWS::DynamoDB::Stream","AWS::DynamoDB::Table","AWS::EFS::FileSystem","AWS::IAM::AssumeRolePolicyDocument","AWS::Kinesis::Stream","AWS::Kinesis::StreamConsumer","AWS::KMS::Key","AWS::Lambda::Function","AWS::OpenSearchService::Domain","AWS::S3::AccessPoint","AWS::S3::Bucket","AWS::S3::Glacier","AWS::S3Express::AccessPoint","AWS::S3Express::DirectoryBucket","AWS::S3Outposts::AccessPoint","AWS::S3Outposts::Bucket","AWS::S3Tables::Table","AWS::S3Tables::TableBucket","AWS::SecretsManager::Secret","AWS::SNS::Topic","AWS::SQS::Queue"
            break
        }

        # Amazon.AccessAnalyzer.FindingStatusUpdate
        "Update-IAMAAFinding/Status"
        {
            $v = "ACTIVE","ARCHIVED"
            break
        }

        # Amazon.AccessAnalyzer.Locale
        "Use-IAMAAPolicyValidation/Locale"
        {
            $v = "DE","EN","ES","FR","IT","JA","KO","PT_BR","ZH_CN","ZH_TW"
            break
        }

        # Amazon.AccessAnalyzer.OrderBy
        {
            ($_ -eq "Get-IAMAAFindingList/Sort_OrderBy") -Or
            ($_ -eq "Get-IAMAAFindingsV2List/Sort_OrderBy")
        }
        {
            $v = "ASC","DESC"
            break
        }

        # Amazon.AccessAnalyzer.PolicyType
        "Use-IAMAAPolicyValidation/PolicyType"
        {
            $v = "IDENTITY_POLICY","RESOURCE_CONTROL_POLICY","RESOURCE_POLICY","SERVICE_CONTROL_POLICY"
            break
        }

        # Amazon.AccessAnalyzer.ResourceType
        "Get-IAMAAAnalyzedResourceList/ResourceType"
        {
            $v = "AWS::DynamoDB::Stream","AWS::DynamoDB::Table","AWS::EC2::Snapshot","AWS::ECR::Repository","AWS::EFS::FileSystem","AWS::IAM::Role","AWS::IAM::User","AWS::KMS::Key","AWS::Lambda::Function","AWS::Lambda::LayerVersion","AWS::RDS::DBClusterSnapshot","AWS::RDS::DBSnapshot","AWS::S3::Bucket","AWS::S3Express::DirectoryBucket","AWS::SecretsManager::Secret","AWS::SNS::Topic","AWS::SQS::Queue"
            break
        }

        # Amazon.AccessAnalyzer.Type
        {
            ($_ -eq "Get-IAMAAAnalyzerList/Type") -Or
            ($_ -eq "New-IAMAAAnalyzer/Type")
        }
        {
            $v = "ACCOUNT","ACCOUNT_INTERNAL_ACCESS","ACCOUNT_UNUSED_ACCESS","ORGANIZATION","ORGANIZATION_INTERNAL_ACCESS","ORGANIZATION_UNUSED_ACCESS"
            break
        }

        # Amazon.AccessAnalyzer.ValidatePolicyResourceType
        "Use-IAMAAPolicyValidation/ValidatePolicyResourceType"
        {
            $v = "AWS::DynamoDB::Table","AWS::IAM::AssumeRolePolicyDocument","AWS::S3::AccessPoint","AWS::S3::Bucket","AWS::S3::MultiRegionAccessPoint","AWS::S3ObjectLambda::AccessPoint"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$IAMAA_map = @{
    "Locale"=@("Use-IAMAAPolicyValidation")
    "PolicyType"=@("Test-IAMAAAccessNotGranted","Test-IAMAANoNewAccess","Use-IAMAAPolicyValidation")
    "ResourceType"=@("Get-IAMAAAnalyzedResourceList","Test-IAMAANoPublicAccess")
    "Sort_OrderBy"=@("Get-IAMAAFindingList","Get-IAMAAFindingsV2List")
    "Status"=@("Update-IAMAAFinding")
    "Type"=@("Get-IAMAAAnalyzerList","New-IAMAAAnalyzer")
    "ValidatePolicyResourceType"=@("Use-IAMAAPolicyValidation")
}

_awsArgumentCompleterRegistration $IAMAA_Completers $IAMAA_map

$IAMAA_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.IAMAA.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$IAMAA_SelectMap = @{
    "Select"=@("Start-IAMAAArchiveRule",
               "Stop-IAMAAPolicyGeneration",
               "Test-IAMAAAccessNotGranted",
               "Test-IAMAANoNewAccess",
               "Test-IAMAANoPublicAccess",
               "New-IAMAAAccessPreview",
               "New-IAMAAAnalyzer",
               "New-IAMAAArchiveRule",
               "Remove-IAMAAAnalyzer",
               "Remove-IAMAAArchiveRule",
               "Start-IAMAAFindingRecommendation",
               "Get-IAMAAAccessPreview",
               "Get-IAMAAAnalyzedResource",
               "Get-IAMAAAnalyzer",
               "Get-IAMAAArchiveRule",
               "Get-IAMAAFinding",
               "Get-IAMAAFindingRecommendation",
               "Get-IAMAAFindingsStatistic",
               "Get-IAMAAFindingV2",
               "Get-IAMAAGeneratedPolicy",
               "Get-IAMAAAccessPreviewFindingList",
               "Get-IAMAAAccessPreviewList",
               "Get-IAMAAAnalyzedResourceList",
               "Get-IAMAAAnalyzerList",
               "Get-IAMAAArchiveRuleList",
               "Get-IAMAAFindingList",
               "Get-IAMAAFindingsV2List",
               "Get-IAMAAPolicyGenerationList",
               "Get-IAMAAResourceTag",
               "Start-IAMAAPolicyGeneration",
               "Start-IAMAAResourceScan",
               "Add-IAMAAResourceTag",
               "Remove-IAMAAResourceTag",
               "Update-IAMAAAnalyzer",
               "Update-IAMAAArchiveRule",
               "Update-IAMAAFinding",
               "Use-IAMAAPolicyValidation")
}

_awsArgumentCompleterRegistration $IAMAA_SelectCompleters $IAMAA_SelectMap
# Argument completions for service AWS Account


$ACCT_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.Account.AlternateContactType
        {
            ($_ -eq "Get-ACCTAlternateContact/AlternateContactType") -Or
            ($_ -eq "Remove-ACCTAlternateContact/AlternateContactType") -Or
            ($_ -eq "Write-ACCTAlternateContact/AlternateContactType")
        }
        {
            $v = "BILLING","OPERATIONS","SECURITY"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ACCT_map = @{
    "AlternateContactType"=@("Get-ACCTAlternateContact","Remove-ACCTAlternateContact","Write-ACCTAlternateContact")
}

_awsArgumentCompleterRegistration $ACCT_Completers $ACCT_map

$ACCT_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.ACCT.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ACCT_SelectMap = @{
    "Select"=@("Approve-ACCTPrimaryEmailUpdate",
               "Remove-ACCTAlternateContact",
               "Disable-ACCTRegion",
               "Enable-ACCTRegion",
               "Get-ACCTAccountInformation",
               "Get-ACCTAlternateContact",
               "Get-ACCTContactInformation",
               "Get-ACCTPrimaryEmail",
               "Get-ACCTRegionOptStatus",
               "Get-ACCTRegionList",
               "Write-ACCTAccountName",
               "Write-ACCTAlternateContact",
               "Write-ACCTContactInformation",
               "Start-ACCTPrimaryEmailUpdate")
}

_awsArgumentCompleterRegistration $ACCT_SelectCompleters $ACCT_SelectMap
# Argument completions for service AWS Certificate Manager Private Certificate Authority


$PCA_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ACMPCA.AuditReportResponseFormat
        "New-PCACertificateAuthorityAuditReport/AuditReportResponseFormat"
        {
            $v = "CSV","JSON"
            break
        }

        # Amazon.ACMPCA.CertificateAuthorityStatus
        "Update-PCACertificateAuthority/Status"
        {
            $v = "ACTIVE","CREATING","DELETED","DISABLED","EXPIRED","FAILED","PENDING_CERTIFICATE"
            break
        }

        # Amazon.ACMPCA.CertificateAuthorityType
        "New-PCACertificateAuthority/CertificateAuthorityType"
        {
            $v = "ROOT","SUBORDINATE"
            break
        }

        # Amazon.ACMPCA.CertificateAuthorityUsageMode
        "New-PCACertificateAuthority/UsageMode"
        {
            $v = "GENERAL_PURPOSE","SHORT_LIVED_CERTIFICATE"
            break
        }

        # Amazon.ACMPCA.KeyStorageSecurityStandard
        "New-PCACertificateAuthority/KeyStorageSecurityStandard"
        {
            $v = "CCPC_LEVEL_1_OR_HIGHER","FIPS_140_2_LEVEL_2_OR_HIGHER","FIPS_140_2_LEVEL_3_OR_HIGHER"
            break
        }

        # Amazon.ACMPCA.ResourceOwner
        "Get-PCACertificateAuthorityList/ResourceOwner"
        {
            $v = "OTHER_ACCOUNTS","SELF"
            break
        }

        # Amazon.ACMPCA.RevocationReason
        "Revoke-PCACertificate/RevocationReason"
        {
            $v = "AFFILIATION_CHANGED","A_A_COMPROMISE","CERTIFICATE_AUTHORITY_COMPROMISE","CESSATION_OF_OPERATION","KEY_COMPROMISE","PRIVILEGE_WITHDRAWN","SUPERSEDED","UNSPECIFIED"
            break
        }

        # Amazon.ACMPCA.SigningAlgorithm
        "New-PCACertificate/SigningAlgorithm"
        {
            $v = "SHA256WITHECDSA","SHA256WITHRSA","SHA384WITHECDSA","SHA384WITHRSA","SHA512WITHECDSA","SHA512WITHRSA","SM3WITHSM2"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$PCA_map = @{
    "AuditReportResponseFormat"=@("New-PCACertificateAuthorityAuditReport")
    "CertificateAuthorityType"=@("New-PCACertificateAuthority")
    "KeyStorageSecurityStandard"=@("New-PCACertificateAuthority")
    "ResourceOwner"=@("Get-PCACertificateAuthorityList")
    "RevocationReason"=@("Revoke-PCACertificate")
    "SigningAlgorithm"=@("New-PCACertificate")
    "Status"=@("Update-PCACertificateAuthority")
    "UsageMode"=@("New-PCACertificateAuthority")
}

_awsArgumentCompleterRegistration $PCA_Completers $PCA_map

$PCA_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.PCA.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$PCA_SelectMap = @{
    "Select"=@("New-PCACertificateAuthority",
               "New-PCACertificateAuthorityAuditReport",
               "New-PCAPermission",
               "Remove-PCACertificateAuthority",
               "Remove-PCAPermission",
               "Remove-PCAPolicy",
               "Get-PCACertificateAuthority",
               "Get-PCACertificateAuthorityAuditReport",
               "Get-PCACertificate",
               "Get-PCACertificateAuthorityCertificate",
               "Get-PCACertificateAuthorityCsr",
               "Get-PCAPolicy",
               "Import-PCACertificateAuthorityCertificate",
               "New-PCACertificate",
               "Get-PCACertificateAuthorityList",
               "Get-PCAPermissionList",
               "Get-PCACertificateAuthorityTagList",
               "Set-PCAPolicy",
               "Restore-PCACertificateAuthority",
               "Revoke-PCACertificate",
               "Add-PCACertificateAuthorityTag",
               "Remove-PCACertificateAuthorityTag",
               "Update-PCACertificateAuthority")
}

_awsArgumentCompleterRegistration $PCA_SelectCompleters $PCA_SelectMap
# Argument completions for service AWS Certificate Manager


$ACM_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CertificateManager.CertificateExport
        {
            ($_ -eq "Get-ACMCertificateList/Includes_ExportOption") -Or
            ($_ -eq "New-ACMCertificate/Options_Export") -Or
            ($_ -eq "Update-ACMCertificateOption/Options_Export")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.CertificateManager.CertificateManagedBy
        {
            ($_ -eq "Get-ACMCertificateList/Includes_ManagedBy") -Or
            ($_ -eq "New-ACMCertificate/ManagedBy")
        }
        {
            $v = "CLOUDFRONT"
            break
        }

        # Amazon.CertificateManager.CertificateTransparencyLoggingPreference
        {
            ($_ -eq "New-ACMCertificate/Options_CertificateTransparencyLoggingPreference") -Or
            ($_ -eq "Update-ACMCertificateOption/Options_CertificateTransparencyLoggingPreference")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.CertificateManager.KeyAlgorithm
        "New-ACMCertificate/KeyAlgorithm"
        {
            $v = "EC_prime256v1","EC_secp384r1","EC_secp521r1","RSA_1024","RSA_2048","RSA_3072","RSA_4096"
            break
        }

        # Amazon.CertificateManager.RevocationReason
        "Revoke-ACMCertificate/RevocationReason"
        {
            $v = "AFFILIATION_CHANGED","A_A_COMPROMISE","CA_COMPROMISE","CERTIFICATE_HOLD","CESSATION_OF_OPERATION","KEY_COMPROMISE","PRIVILEGE_WITHDRAWN","REMOVE_FROM_CRL","SUPERCEDED","SUPERSEDED","UNSPECIFIED"
            break
        }

        # Amazon.CertificateManager.SortBy
        "Get-ACMCertificateList/SortBy"
        {
            $v = "CREATED_AT"
            break
        }

        # Amazon.CertificateManager.SortOrder
        "Get-ACMCertificateList/SortOrder"
        {
            $v = "ASCENDING","DESCENDING"
            break
        }

        # Amazon.CertificateManager.ValidationMethod
        "New-ACMCertificate/ValidationMethod"
        {
            $v = "DNS","EMAIL","HTTP"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ACM_map = @{
    "Includes_ExportOption"=@("Get-ACMCertificateList")
    "Includes_ManagedBy"=@("Get-ACMCertificateList")
    "KeyAlgorithm"=@("New-ACMCertificate")
    "ManagedBy"=@("New-ACMCertificate")
    "Options_CertificateTransparencyLoggingPreference"=@("New-ACMCertificate","Update-ACMCertificateOption")
    "Options_Export"=@("New-ACMCertificate","Update-ACMCertificateOption")
    "RevocationReason"=@("Revoke-ACMCertificate")
    "SortBy"=@("Get-ACMCertificateList")
    "SortOrder"=@("Get-ACMCertificateList")
    "ValidationMethod"=@("New-ACMCertificate")
}

_awsArgumentCompleterRegistration $ACM_Completers $ACM_map

$ACM_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.ACM.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ACM_SelectMap = @{
    "Select"=@("Add-ACMCertificateTag",
               "Remove-ACMCertificate",
               "Get-ACMCertificateDetail",
               "Export-ACMCertificate",
               "Get-ACMAccountConfiguration",
               "Get-ACMCertificate",
               "Import-ACMCertificate",
               "Get-ACMCertificateList",
               "Get-ACMCertificateTagList",
               "Write-ACMAccountConfiguration",
               "Remove-ACMCertificateTag",
               "Invoke-ACMCertificateRenewal",
               "New-ACMCertificate",
               "Send-ACMValidationEmail",
               "Revoke-ACMCertificate",
               "Update-ACMCertificateOption")
}

_awsArgumentCompleterRegistration $ACM_SelectCompleters $ACM_SelectMap
# Argument completions for service AWS AI Ops


$AIOps_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.AIOps.EncryptionConfigurationType
        {
            ($_ -eq "New-AIOpsInvestigationGroup/EncryptionConfiguration_Type") -Or
            ($_ -eq "Update-AIOpsInvestigationGroup/EncryptionConfiguration_Type")
        }
        {
            $v = "AWS_OWNED_KEY","CUSTOMER_MANAGED_KMS_KEY"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AIOps_map = @{
    "EncryptionConfiguration_Type"=@("New-AIOpsInvestigationGroup","Update-AIOpsInvestigationGroup")
}

_awsArgumentCompleterRegistration $AIOps_Completers $AIOps_map

$AIOps_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.AIOps.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AIOps_SelectMap = @{
    "Select"=@("New-AIOpsInvestigationGroup",
               "Remove-AIOpsInvestigationGroup",
               "Remove-AIOpsInvestigationGroupPolicy",
               "Get-AIOpsInvestigationGroup",
               "Get-AIOpsInvestigationGroupPolicy",
               "Get-AIOpsInvestigationGroupList",
               "Get-AIOpsResourceTag",
               "Write-AIOpsInvestigationGroupPolicy",
               "Add-AIOpsResourceTag",
               "Remove-AIOpsResourceTag",
               "Update-AIOpsInvestigationGroup")
}

_awsArgumentCompleterRegistration $AIOps_SelectCompleters $AIOps_SelectMap
# Argument completions for service AWS Amplify


$AMP_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.Amplify.BuildComputeType
        {
            ($_ -eq "New-AMPApp/JobConfig_BuildComputeType") -Or
            ($_ -eq "Update-AMPApp/JobConfig_BuildComputeType")
        }
        {
            $v = "LARGE_16GB","STANDARD_8GB","XLARGE_72GB"
            break
        }

        # Amazon.Amplify.CacheConfigType
        {
            ($_ -eq "New-AMPApp/CacheConfig_Type") -Or
            ($_ -eq "Update-AMPApp/CacheConfig_Type")
        }
        {
            $v = "AMPLIFY_MANAGED","AMPLIFY_MANAGED_NO_COOKIES"
            break
        }

        # Amazon.Amplify.CertificateType
        {
            ($_ -eq "New-AMPDomainAssociation/CertificateSettings_Type") -Or
            ($_ -eq "Update-AMPDomainAssociation/CertificateSettings_Type")
        }
        {
            $v = "AMPLIFY_MANAGED","CUSTOM"
            break
        }

        # Amazon.Amplify.JobType
        "Start-AMPJob/JobType"
        {
            $v = "MANUAL","RELEASE","RETRY","WEB_HOOK"
            break
        }

        # Amazon.Amplify.Platform
        {
            ($_ -eq "New-AMPApp/Platform") -Or
            ($_ -eq "Update-AMPApp/Platform")
        }
        {
            $v = "WEB","WEB_COMPUTE","WEB_DYNAMIC"
            break
        }

        # Amazon.Amplify.SourceUrlType
        "Start-AMPDeployment/SourceUrlType"
        {
            $v = "BUCKET_PREFIX","ZIP"
            break
        }

        # Amazon.Amplify.Stage
        {
            ($_ -eq "New-AMPApp/AutoBranchCreationConfig_Stage") -Or
            ($_ -eq "Update-AMPApp/AutoBranchCreationConfig_Stage") -Or
            ($_ -eq "New-AMPBranch/Stage") -Or
            ($_ -eq "Update-AMPBranch/Stage")
        }
        {
            $v = "BETA","DEVELOPMENT","EXPERIMENTAL","PRODUCTION","PULL_REQUEST"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AMP_map = @{
    "AutoBranchCreationConfig_Stage"=@("New-AMPApp","Update-AMPApp")
    "CacheConfig_Type"=@("New-AMPApp","Update-AMPApp")
    "CertificateSettings_Type"=@("New-AMPDomainAssociation","Update-AMPDomainAssociation")
    "JobConfig_BuildComputeType"=@("New-AMPApp","Update-AMPApp")
    "JobType"=@("Start-AMPJob")
    "Platform"=@("New-AMPApp","Update-AMPApp")
    "SourceUrlType"=@("Start-AMPDeployment")
    "Stage"=@("New-AMPBranch","Update-AMPBranch")
}

_awsArgumentCompleterRegistration $AMP_Completers $AMP_map

$AMP_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.AMP.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AMP_SelectMap = @{
    "Select"=@("New-AMPApp",
               "New-AMPBackendEnvironment",
               "New-AMPBranch",
               "New-AMPDeployment",
               "New-AMPDomainAssociation",
               "New-AMPWebhook",
               "Remove-AMPApp",
               "Remove-AMPBackendEnvironment",
               "Remove-AMPBranch",
               "Remove-AMPDomainAssociation",
               "Remove-AMPJob",
               "Remove-AMPWebhook",
               "New-AMPAccessLog",
               "Get-AMPApp",
               "Get-AMPArtifactUrl",
               "Get-AMPBackendEnvironment",
               "Get-AMPBranch",
               "Get-AMPDomainAssociation",
               "Get-AMPJob",
               "Get-AMPWebhook",
               "Get-AMPAppList",
               "Get-AMPArtifactList",
               "Get-AMPBackendEnvironmentList",
               "Get-AMPBranchList",
               "Get-AMPDomainAssociationList",
               "Get-AMPJobList",
               "Get-AMPResourceTag",
               "Get-AMPWebhookList",
               "Start-AMPDeployment",
               "Start-AMPJob",
               "Stop-AMPJob",
               "Add-AMPResourceTag",
               "Remove-AMPResourceTag",
               "Update-AMPApp",
               "Update-AMPBranch",
               "Update-AMPDomainAssociation",
               "Update-AMPWebhook")
}

_awsArgumentCompleterRegistration $AMP_SelectCompleters $AMP_SelectMap
# Argument completions for service Amplify Backend


$AMPB_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.AmplifyBackend.AuthResources
        {
            ($_ -eq "New-AMPBBackendAuth/ResourceConfig_AuthResource") -Or
            ($_ -eq "Update-AMPBBackendAuth/ResourceConfig_AuthResource")
        }
        {
            $v = "IDENTITY_POOL_AND_USER_POOL","USER_POOL_ONLY"
            break
        }

        # Amazon.AmplifyBackend.DeliveryMethod
        {
            ($_ -eq "New-AMPBBackendAuth/ForgotPassword_DeliveryMethod") -Or
            ($_ -eq "Update-AMPBBackendAuth/ForgotPassword_DeliveryMethod") -Or
            ($_ -eq "New-AMPBBackendAuth/VerificationMessage_DeliveryMethod") -Or
            ($_ -eq "Update-AMPBBackendAuth/VerificationMessage_DeliveryMethod")
        }
        {
            $v = "EMAIL","SMS"
            break
        }

        # Amazon.AmplifyBackend.MFAMode
        {
            ($_ -eq "New-AMPBBackendAuth/Mfa_MFAMode") -Or
            ($_ -eq "Update-AMPBBackendAuth/Mfa_MFAMode")
        }
        {
            $v = "OFF","ON","OPTIONAL"
            break
        }

        # Amazon.AmplifyBackend.Mode
        {
            ($_ -eq "Get-AMPBBackendAPI/DefaultAuthType_Mode") -Or
            ($_ -eq "New-AMPBBackendAPI/DefaultAuthType_Mode") -Or
            ($_ -eq "Remove-AMPBBackendAPI/DefaultAuthType_Mode") -Or
            ($_ -eq "Update-AMPBBackendAPI/DefaultAuthType_Mode")
        }
        {
            $v = "AMAZON_COGNITO_USER_POOLS","API_KEY","AWS_IAM","OPENID_CONNECT"
            break
        }

        # Amazon.AmplifyBackend.OAuthGrantType
        {
            ($_ -eq "New-AMPBBackendAuth/OAuth_OAuthGrantType") -Or
            ($_ -eq "Update-AMPBBackendAuth/OAuth_OAuthGrantType")
        }
        {
            $v = "CODE","IMPLICIT"
            break
        }

        # Amazon.AmplifyBackend.ResolutionStrategy
        {
            ($_ -eq "Get-AMPBBackendAPI/ConflictResolution_ResolutionStrategy") -Or
            ($_ -eq "New-AMPBBackendAPI/ConflictResolution_ResolutionStrategy") -Or
            ($_ -eq "Remove-AMPBBackendAPI/ConflictResolution_ResolutionStrategy") -Or
            ($_ -eq "Update-AMPBBackendAPI/ConflictResolution_ResolutionStrategy")
        }
        {
            $v = "AUTOMERGE","LAMBDA","NONE","OPTIMISTIC_CONCURRENCY"
            break
        }

        # Amazon.AmplifyBackend.Service
        {
            ($_ -eq "New-AMPBBackendAuth/ResourceConfig_Service") -Or
            ($_ -eq "Update-AMPBBackendAuth/ResourceConfig_Service")
        }
        {
            $v = "COGNITO"
            break
        }

        # Amazon.AmplifyBackend.ServiceName
        {
            ($_ -eq "New-AMPBBackendStorage/ResourceConfig_ServiceName") -Or
            ($_ -eq "Update-AMPBBackendStorage/ResourceConfig_ServiceName") -Or
            ($_ -eq "Import-AMPBBackendStorage/ServiceName") -Or
            ($_ -eq "Remove-AMPBBackendStorage/ServiceName")
        }
        {
            $v = "S3"
            break
        }

        # Amazon.AmplifyBackend.SignInMethod
        "New-AMPBBackendAuth/UserPoolConfigs_SignInMethod"
        {
            $v = "EMAIL","EMAIL_AND_PHONE_NUMBER","PHONE_NUMBER","USERNAME"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AMPB_map = @{
    "ConflictResolution_ResolutionStrategy"=@("Get-AMPBBackendAPI","New-AMPBBackendAPI","Remove-AMPBBackendAPI","Update-AMPBBackendAPI")
    "DefaultAuthType_Mode"=@("Get-AMPBBackendAPI","New-AMPBBackendAPI","Remove-AMPBBackendAPI","Update-AMPBBackendAPI")
    "ForgotPassword_DeliveryMethod"=@("New-AMPBBackendAuth","Update-AMPBBackendAuth")
    "Mfa_MFAMode"=@("New-AMPBBackendAuth","Update-AMPBBackendAuth")
    "OAuth_OAuthGrantType"=@("New-AMPBBackendAuth","Update-AMPBBackendAuth")
    "ResourceConfig_AuthResource"=@("New-AMPBBackendAuth","Update-AMPBBackendAuth")
    "ResourceConfig_Service"=@("New-AMPBBackendAuth","Update-AMPBBackendAuth")
    "ResourceConfig_ServiceName"=@("New-AMPBBackendStorage","Update-AMPBBackendStorage")
    "ServiceName"=@("Import-AMPBBackendStorage","Remove-AMPBBackendStorage")
    "UserPoolConfigs_SignInMethod"=@("New-AMPBBackendAuth")
    "VerificationMessage_DeliveryMethod"=@("New-AMPBBackendAuth","Update-AMPBBackendAuth")
}

_awsArgumentCompleterRegistration $AMPB_Completers $AMPB_map

$AMPB_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.AMPB.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AMPB_SelectMap = @{
    "Select"=@("Copy-AMPBBackend",
               "New-AMPBBackend",
               "New-AMPBBackendAPI",
               "New-AMPBBackendAuth",
               "New-AMPBBackendConfig",
               "New-AMPBBackendStorage",
               "New-AMPBToken",
               "Remove-AMPBBackend",
               "Remove-AMPBBackendAPI",
               "Remove-AMPBBackendAuth",
               "Remove-AMPBBackendStorage",
               "Remove-AMPBToken",
               "New-AMPBBackendAPIModel",
               "Get-AMPBBackend",
               "Get-AMPBBackendAPI",
               "Get-AMPBBackendAPIModel",
               "Get-AMPBBackendAuth",
               "Get-AMPBBackendJob",
               "Get-AMPBBackendStorage",
               "Get-AMPBToken",
               "Import-AMPBBackendAuth",
               "Import-AMPBBackendStorage",
               "Get-AMPBBackendJobList",
               "Get-AMPBS3BucketList",
               "Remove-AMPBAllBackend",
               "Remove-AMPBBackendConfig",
               "Update-AMPBBackendAPI",
               "Update-AMPBBackendAuth",
               "Update-AMPBBackendConfig",
               "Update-AMPBBackendJob",
               "Update-AMPBBackendStorage")
}

_awsArgumentCompleterRegistration $AMPB_SelectCompleters $AMPB_SelectMap
# Argument completions for service AWS Amplify UI Builder


$AMPUI_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.AmplifyUIBuilder.CodegenJobGenericDataSourceType
        "New-AMPUICodegenJob/GenericDataSchema_DataSourceType"
        {
            $v = "DataStore"
            break
        }

        # Amazon.AmplifyUIBuilder.FixedPosition
        {
            ($_ -eq "New-AMPUIForm/FormToCreate_Cta_Cancel_Position_Fixed") -Or
            ($_ -eq "New-AMPUIForm/FormToCreate_Cta_Clear_Position_Fixed") -Or
            ($_ -eq "New-AMPUIForm/FormToCreate_Cta_Submit_Position_Fixed") -Or
            ($_ -eq "Update-AMPUIForm/UpdatedForm_Cta_Cancel_Position_Fixed") -Or
            ($_ -eq "Update-AMPUIForm/UpdatedForm_Cta_Clear_Position_Fixed") -Or
            ($_ -eq "Update-AMPUIForm/UpdatedForm_Cta_Submit_Position_Fixed")
        }
        {
            $v = "first"
            break
        }

        # Amazon.AmplifyUIBuilder.FormActionType
        {
            ($_ -eq "New-AMPUIForm/FormToCreate_FormActionType") -Or
            ($_ -eq "Update-AMPUIForm/UpdatedForm_FormActionType")
        }
        {
            $v = "create","update"
            break
        }

        # Amazon.AmplifyUIBuilder.FormButtonsPosition
        {
            ($_ -eq "New-AMPUIForm/Cta_Position") -Or
            ($_ -eq "Update-AMPUIForm/Cta_Position")
        }
        {
            $v = "bottom","top","top_and_bottom"
            break
        }

        # Amazon.AmplifyUIBuilder.FormDataSourceType
        {
            ($_ -eq "New-AMPUIForm/DataType_DataSourceType") -Or
            ($_ -eq "Update-AMPUIForm/DataType_DataSourceType")
        }
        {
            $v = "Custom","DataStore"
            break
        }

        # Amazon.AmplifyUIBuilder.JSModule
        "New-AMPUICodegenJob/React_Module"
        {
            $v = "es2020","esnext"
            break
        }

        # Amazon.AmplifyUIBuilder.JSScript
        "New-AMPUICodegenJob/React_Script"
        {
            $v = "js","jsx","tsx"
            break
        }

        # Amazon.AmplifyUIBuilder.JSTarget
        "New-AMPUICodegenJob/React_Target"
        {
            $v = "es2015","es2020"
            break
        }

        # Amazon.AmplifyUIBuilder.LabelDecorator
        {
            ($_ -eq "New-AMPUIForm/FormToCreate_LabelDecorator") -Or
            ($_ -eq "Update-AMPUIForm/UpdatedForm_LabelDecorator")
        }
        {
            $v = "none","optional","required"
            break
        }

        # Amazon.AmplifyUIBuilder.TokenProviders
        {
            ($_ -eq "Convert-AMPUICodeForToken/Provider") -Or
            ($_ -eq "Update-AMPUIToken/Provider")
        }
        {
            $v = "figma"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AMPUI_map = @{
    "Cta_Position"=@("New-AMPUIForm","Update-AMPUIForm")
    "DataType_DataSourceType"=@("New-AMPUIForm","Update-AMPUIForm")
    "FormToCreate_Cta_Cancel_Position_Fixed"=@("New-AMPUIForm")
    "FormToCreate_Cta_Clear_Position_Fixed"=@("New-AMPUIForm")
    "FormToCreate_Cta_Submit_Position_Fixed"=@("New-AMPUIForm")
    "FormToCreate_FormActionType"=@("New-AMPUIForm")
    "FormToCreate_LabelDecorator"=@("New-AMPUIForm")
    "GenericDataSchema_DataSourceType"=@("New-AMPUICodegenJob")
    "Provider"=@("Convert-AMPUICodeForToken","Update-AMPUIToken")
    "React_Module"=@("New-AMPUICodegenJob")
    "React_Script"=@("New-AMPUICodegenJob")
    "React_Target"=@("New-AMPUICodegenJob")
    "UpdatedForm_Cta_Cancel_Position_Fixed"=@("Update-AMPUIForm")
    "UpdatedForm_Cta_Clear_Position_Fixed"=@("Update-AMPUIForm")
    "UpdatedForm_Cta_Submit_Position_Fixed"=@("Update-AMPUIForm")
    "UpdatedForm_FormActionType"=@("Update-AMPUIForm")
    "UpdatedForm_LabelDecorator"=@("Update-AMPUIForm")
}

_awsArgumentCompleterRegistration $AMPUI_Completers $AMPUI_map

$AMPUI_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.AMPUI.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AMPUI_SelectMap = @{
    "Select"=@("New-AMPUIComponent",
               "New-AMPUIForm",
               "New-AMPUITheme",
               "Remove-AMPUIComponent",
               "Remove-AMPUIForm",
               "Remove-AMPUITheme",
               "Convert-AMPUICodeForToken",
               "Export-AMPUIComponent",
               "Export-AMPUIForm",
               "Export-AMPUITheme",
               "Get-AMPUICodegenJob",
               "Get-AMPUIComponent",
               "Get-AMPUIForm",
               "Get-AMPUIMetadata",
               "Get-AMPUITheme",
               "Get-AMPUICodegenJobList",
               "Get-AMPUIComponentList",
               "Get-AMPUIFormList",
               "Get-AMPUIResourceTag",
               "Get-AMPUIThemeList",
               "Write-AMPUIMetadataFlag",
               "Update-AMPUIToken",
               "New-AMPUICodegenJob",
               "Add-AMPUIResourceTag",
               "Remove-AMPUIResourceTag",
               "Update-AMPUIComponent",
               "Update-AMPUIForm",
               "Update-AMPUITheme")
}

_awsArgumentCompleterRegistration $AMPUI_SelectCompleters $AMPUI_SelectMap
# Argument completions for service Amazon API Gateway


$AG_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.APIGateway.AccessAssociationSourceType
        "New-AGDomainNameAccessAssociation/AccessAssociationSourceType"
        {
            $v = "VPCE"
            break
        }

        # Amazon.APIGateway.ApiKeysFormat
        "Import-AGApiKey/Format"
        {
            $v = "csv"
            break
        }

        # Amazon.APIGateway.ApiKeySourceType
        "New-AGRestApi/ApiKeySource"
        {
            $v = "AUTHORIZER","HEADER"
            break
        }

        # Amazon.APIGateway.AuthorizerType
        "New-AGAuthorizer/Type"
        {
            $v = "COGNITO_USER_POOLS","REQUEST","TOKEN"
            break
        }

        # Amazon.APIGateway.CacheClusterSize
        {
            ($_ -eq "New-AGDeployment/CacheClusterSize") -Or
            ($_ -eq "New-AGStage/CacheClusterSize")
        }
        {
            $v = "0.5","1.6","118","13.5","237","28.4","58.2","6.1"
            break
        }

        # Amazon.APIGateway.ConnectionType
        "Write-AGIntegration/ConnectionType"
        {
            $v = "INTERNET","VPC_LINK"
            break
        }

        # Amazon.APIGateway.ContentHandlingStrategy
        {
            ($_ -eq "Write-AGIntegration/ContentHandling") -Or
            ($_ -eq "Write-AGIntegrationResponse/ContentHandling")
        }
        {
            $v = "CONVERT_TO_BINARY","CONVERT_TO_TEXT"
            break
        }

        # Amazon.APIGateway.DocumentationPartType
        {
            ($_ -eq "New-AGDocumentationPart/Location_Type") -Or
            ($_ -eq "Get-AGDocumentationPartList/Type")
        }
        {
            $v = "API","AUTHORIZER","METHOD","MODEL","PATH_PARAMETER","QUERY_PARAMETER","REQUEST_BODY","REQUEST_HEADER","RESOURCE","RESPONSE","RESPONSE_BODY","RESPONSE_HEADER"
            break
        }

        # Amazon.APIGateway.GatewayResponseType
        {
            ($_ -eq "Get-AGGatewayResponse/ResponseType") -Or
            ($_ -eq "Remove-AGGatewayResponse/ResponseType") -Or
            ($_ -eq "Update-AGGatewayResponse/ResponseType") -Or
            ($_ -eq "Write-AGGatewayResponse/ResponseType")
        }
        {
            $v = "ACCESS_DENIED","API_CONFIGURATION_ERROR","AUTHORIZER_CONFIGURATION_ERROR","AUTHORIZER_FAILURE","BAD_REQUEST_BODY","BAD_REQUEST_PARAMETERS","DEFAULT_4XX","DEFAULT_5XX","EXPIRED_TOKEN","INTEGRATION_FAILURE","INTEGRATION_TIMEOUT","INVALID_API_KEY","INVALID_SIGNATURE","MISSING_AUTHENTICATION_TOKEN","QUOTA_EXCEEDED","REQUEST_TOO_LARGE","RESOURCE_NOT_FOUND","THROTTLED","UNAUTHORIZED","UNSUPPORTED_MEDIA_TYPE","WAF_FILTERED"
            break
        }

        # Amazon.APIGateway.IntegrationType
        "Write-AGIntegration/Type"
        {
            $v = "AWS","AWS_PROXY","HTTP","HTTP_PROXY","MOCK"
            break
        }

        # Amazon.APIGateway.IpAddressType
        {
            ($_ -eq "New-AGDomainName/EndpointConfiguration_IpAddressType") -Or
            ($_ -eq "New-AGRestApi/EndpointConfiguration_IpAddressType")
        }
        {
            $v = "dualstack","ipv4"
            break
        }

        # Amazon.APIGateway.LocationStatusType
        "Get-AGDocumentationPartList/LocationStatus"
        {
            $v = "DOCUMENTED","UNDOCUMENTED"
            break
        }

        # Amazon.APIGateway.PutMode
        {
            ($_ -eq "Import-AGDocumentationPartList/Mode") -Or
            ($_ -eq "Write-AGRestApi/Mode")
        }
        {
            $v = "merge","overwrite"
            break
        }

        # Amazon.APIGateway.QuotaPeriodType
        "New-AGUsagePlan/Quota_Period"
        {
            $v = "DAY","MONTH","WEEK"
            break
        }

        # Amazon.APIGateway.ResourceOwner
        {
            ($_ -eq "Get-AGDomainNameAccessAssociation/ResourceOwner") -Or
            ($_ -eq "Get-AGDomainNameList/ResourceOwner")
        }
        {
            $v = "OTHER_ACCOUNTS","SELF"
            break
        }

        # Amazon.APIGateway.RoutingMode
        "New-AGDomainName/RoutingMode"
        {
            $v = "BASE_PATH_MAPPING_ONLY","ROUTING_RULE_ONLY","ROUTING_RULE_THEN_BASE_PATH_MAPPING"
            break
        }

        # Amazon.APIGateway.SecurityPolicy
        "New-AGDomainName/SecurityPolicy"
        {
            $v = "TLS_1_0","TLS_1_2"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AG_map = @{
    "AccessAssociationSourceType"=@("New-AGDomainNameAccessAssociation")
    "ApiKeySource"=@("New-AGRestApi")
    "CacheClusterSize"=@("New-AGDeployment","New-AGStage")
    "ConnectionType"=@("Write-AGIntegration")
    "ContentHandling"=@("Write-AGIntegration","Write-AGIntegrationResponse")
    "EndpointConfiguration_IpAddressType"=@("New-AGDomainName","New-AGRestApi")
    "Format"=@("Import-AGApiKey")
    "Location_Type"=@("New-AGDocumentationPart")
    "LocationStatus"=@("Get-AGDocumentationPartList")
    "Mode"=@("Import-AGDocumentationPartList","Write-AGRestApi")
    "Quota_Period"=@("New-AGUsagePlan")
    "ResourceOwner"=@("Get-AGDomainNameAccessAssociation","Get-AGDomainNameList")
    "ResponseType"=@("Get-AGGatewayResponse","Remove-AGGatewayResponse","Update-AGGatewayResponse","Write-AGGatewayResponse")
    "RoutingMode"=@("New-AGDomainName")
    "SecurityPolicy"=@("New-AGDomainName")
    "Type"=@("Get-AGDocumentationPartList","New-AGAuthorizer","Write-AGIntegration")
}

_awsArgumentCompleterRegistration $AG_Completers $AG_map

$AG_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.AG.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AG_SelectMap = @{
    "Select"=@("New-AGApiKey",
               "New-AGAuthorizer",
               "New-AGBasePathMapping",
               "New-AGDeployment",
               "New-AGDocumentationPart",
               "New-AGDocumentationVersion",
               "New-AGDomainName",
               "New-AGDomainNameAccessAssociation",
               "New-AGModel",
               "New-AGRequestValidator",
               "New-AGResource",
               "New-AGRestApi",
               "New-AGStage",
               "New-AGUsagePlan",
               "New-AGUsagePlanKey",
               "New-AGVpcLink",
               "Remove-AGApiKey",
               "Remove-AGAuthorizer",
               "Remove-AGBasePathMapping",
               "Remove-AGClientCertificate",
               "Remove-AGDeployment",
               "Remove-AGDocumentationPart",
               "Remove-AGDocumentationVersion",
               "Remove-AGDomainName",
               "Remove-AGDomainNameAccessAssociation",
               "Remove-AGGatewayResponse",
               "Remove-AGIntegration",
               "Remove-AGIntegrationResponse",
               "Remove-AGMethod",
               "Remove-AGMethodResponse",
               "Remove-AGModel",
               "Remove-AGRequestValidator",
               "Remove-AGResource",
               "Remove-AGRestApi",
               "Remove-AGStage",
               "Remove-AGUsagePlan",
               "Remove-AGUsagePlanKey",
               "Remove-AGVpcLink",
               "Clear-AGStageAuthorizersCache",
               "Clear-AGStageCache",
               "New-AGClientCertificate",
               "Get-AGAccount",
               "Get-AGApiKey",
               "Get-AGApiKeyList",
               "Get-AGAuthorizer",
               "Get-AGAuthorizerList",
               "Get-AGBasePathMapping",
               "Get-AGBasePathMappingList",
               "Get-AGClientCertificate",
               "Get-AGClientCertificateList",
               "Get-AGDeployment",
               "Get-AGDeploymentList",
               "Get-AGDocumentationPart",
               "Get-AGDocumentationPartList",
               "Get-AGDocumentationVersion",
               "Get-AGDocumentationVersionList",
               "Get-AGDomainName",
               "Get-AGDomainNameAccessAssociation",
               "Get-AGDomainNameList",
               "Get-AGExport",
               "Get-AGGatewayResponse",
               "Get-AGGatewayResponseList",
               "Get-AGIntegration",
               "Get-AGIntegrationResponse",
               "Get-AGMethod",
               "Get-AGMethodResponse",
               "Get-AGModel",
               "Get-AGModelList",
               "Get-AGModelTemplate",
               "Get-AGRequestValidator",
               "Get-AGValidatorList",
               "Get-AGResource",
               "Get-AGResourceList",
               "Get-AGRestApi",
               "Get-AGRestApiList",
               "Get-AGSdk",
               "Get-AGSdkType",
               "Get-AGSdkTypeList",
               "Get-AGStage",
               "Get-AGStageList",
               "Get-AGResourceTag",
               "Get-AGUsage",
               "Get-AGUsagePlan",
               "Get-AGUsagePlanKey",
               "Get-AGUsagePlanKeyList",
               "Get-AGUsagePlanList",
               "Get-AGVpcLink",
               "Get-AGVpcLinkList",
               "Import-AGApiKey",
               "Import-AGDocumentationPartList",
               "Import-AGRestApi",
               "Write-AGGatewayResponse",
               "Write-AGIntegration",
               "Write-AGIntegrationResponse",
               "Write-AGMethod",
               "Write-AGMethodResponse",
               "Write-AGRestApi",
               "Disable-AGDomainNameAccessAssociation",
               "Add-AGResourceTag",
               "Test-AGInvokeAuthorizer",
               "Test-AGInvokeMethod",
               "Remove-AGResourceTag",
               "Update-AGAccount",
               "Update-AGApiKey",
               "Update-AGAuthorizer",
               "Update-AGBasePathMapping",
               "Update-AGClientCertificate",
               "Update-AGDeployment",
               "Update-AGDocumentationPart",
               "Update-AGDocumentationVersion",
               "Update-AGDomainName",
               "Update-AGGatewayResponse",
               "Update-AGIntegration",
               "Update-AGIntegrationResponse",
               "Update-AGMethod",
               "Update-AGMethodResponse",
               "Update-AGModel",
               "Update-AGRequestValidator",
               "Update-AGResource",
               "Update-AGRestApi",
               "Update-AGStage",
               "Update-AGUsage",
               "Update-AGUsagePlan",
               "Update-AGVpcLink")
}

_awsArgumentCompleterRegistration $AG_SelectCompleters $AG_SelectMap
# Argument completions for service Amazon API Gateway Management API


$AGM_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.AGM.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AGM_SelectMap = @{
    "Select"=@("Remove-AGMConnection",
               "Get-AGMConnection",
               "Send-AGMDataToConnection")
}

_awsArgumentCompleterRegistration $AGM_SelectCompleters $AGM_SelectMap
# Argument completions for service Amazon API Gateway V2


$AG2_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ApiGatewayV2.AuthorizationType
        {
            ($_ -eq "New-AG2Route/AuthorizationType") -Or
            ($_ -eq "Update-AG2Route/AuthorizationType")
        }
        {
            $v = "AWS_IAM","CUSTOM","JWT","NONE"
            break
        }

        # Amazon.ApiGatewayV2.AuthorizerType
        {
            ($_ -eq "New-AG2Authorizer/AuthorizerType") -Or
            ($_ -eq "Update-AG2Authorizer/AuthorizerType")
        }
        {
            $v = "JWT","REQUEST"
            break
        }

        # Amazon.ApiGatewayV2.ConnectionType
        {
            ($_ -eq "New-AG2Integration/ConnectionType") -Or
            ($_ -eq "Update-AG2Integration/ConnectionType")
        }
        {
            $v = "INTERNET","VPC_LINK"
            break
        }

        # Amazon.ApiGatewayV2.ContentHandlingStrategy
        {
            ($_ -eq "New-AG2Integration/ContentHandlingStrategy") -Or
            ($_ -eq "New-AG2IntegrationResponse/ContentHandlingStrategy") -Or
            ($_ -eq "Update-AG2Integration/ContentHandlingStrategy") -Or
            ($_ -eq "Update-AG2IntegrationResponse/ContentHandlingStrategy")
        }
        {
            $v = "CONVERT_TO_BINARY","CONVERT_TO_TEXT"
            break
        }

        # Amazon.ApiGatewayV2.IntegrationType
        {
            ($_ -eq "New-AG2Integration/IntegrationType") -Or
            ($_ -eq "Update-AG2Integration/IntegrationType")
        }
        {
            $v = "AWS","AWS_PROXY","HTTP","HTTP_PROXY","MOCK"
            break
        }

        # Amazon.ApiGatewayV2.IpAddressType
        {
            ($_ -eq "New-AG2Api/IpAddressType") -Or
            ($_ -eq "Update-AG2Api/IpAddressType")
        }
        {
            $v = "dualstack","ipv4"
            break
        }

        # Amazon.ApiGatewayV2.LoggingLevel
        {
            ($_ -eq "New-AG2Stage/DefaultRouteSettings_LoggingLevel") -Or
            ($_ -eq "Update-AG2Stage/DefaultRouteSettings_LoggingLevel")
        }
        {
            $v = "ERROR","INFO","OFF"
            break
        }

        # Amazon.ApiGatewayV2.PassthroughBehavior
        {
            ($_ -eq "New-AG2Integration/PassthroughBehavior") -Or
            ($_ -eq "Update-AG2Integration/PassthroughBehavior")
        }
        {
            $v = "NEVER","WHEN_NO_MATCH","WHEN_NO_TEMPLATES"
            break
        }

        # Amazon.ApiGatewayV2.ProtocolType
        "New-AG2Api/ProtocolType"
        {
            $v = "HTTP","WEBSOCKET"
            break
        }

        # Amazon.ApiGatewayV2.RoutingMode
        {
            ($_ -eq "New-AG2DomainName/RoutingMode") -Or
            ($_ -eq "Update-AG2DomainName/RoutingMode")
        }
        {
            $v = "API_MAPPING_ONLY","ROUTING_RULE_ONLY","ROUTING_RULE_THEN_API_MAPPING"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AG2_map = @{
    "AuthorizationType"=@("New-AG2Route","Update-AG2Route")
    "AuthorizerType"=@("New-AG2Authorizer","Update-AG2Authorizer")
    "ConnectionType"=@("New-AG2Integration","Update-AG2Integration")
    "ContentHandlingStrategy"=@("New-AG2Integration","New-AG2IntegrationResponse","Update-AG2Integration","Update-AG2IntegrationResponse")
    "DefaultRouteSettings_LoggingLevel"=@("New-AG2Stage","Update-AG2Stage")
    "IntegrationType"=@("New-AG2Integration","Update-AG2Integration")
    "IpAddressType"=@("New-AG2Api","Update-AG2Api")
    "PassthroughBehavior"=@("New-AG2Integration","Update-AG2Integration")
    "ProtocolType"=@("New-AG2Api")
    "RoutingMode"=@("New-AG2DomainName","Update-AG2DomainName")
}

_awsArgumentCompleterRegistration $AG2_Completers $AG2_map

$AG2_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.AG2.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AG2_SelectMap = @{
    "Select"=@("New-AG2Api",
               "New-AG2ApiMapping",
               "New-AG2Authorizer",
               "New-AG2Deployment",
               "New-AG2DomainName",
               "New-AG2Integration",
               "New-AG2IntegrationResponse",
               "New-AG2Model",
               "New-AG2Route",
               "New-AG2RouteResponse",
               "New-AG2RoutingRule",
               "New-AG2Stage",
               "New-AG2VpcLink",
               "Remove-AG2AccessLogSetting",
               "Remove-AG2Api",
               "Remove-AG2ApiMapping",
               "Remove-AG2Authorizer",
               "Remove-AG2CorsConfiguration",
               "Remove-AG2Deployment",
               "Remove-AG2DomainName",
               "Remove-AG2Integration",
               "Remove-AG2IntegrationResponse",
               "Remove-AG2Model",
               "Remove-AG2Route",
               "Remove-AG2RouteRequestParameter",
               "Remove-AG2RouteResponse",
               "Remove-AG2RouteSetting",
               "Remove-AG2RoutingRule",
               "Remove-AG2Stage",
               "Remove-AG2VpcLink",
               "Export-AG2Api",
               "Get-AG2Api",
               "Get-AG2ApiMapping",
               "Get-AG2ApiMappingList",
               "Get-AG2ApiList",
               "Get-AG2Authorizer",
               "Get-AG2AuthorizerList",
               "Get-AG2Deployment",
               "Get-AG2DeploymentList",
               "Get-AG2DomainName",
               "Get-AG2DomainNameList",
               "Get-AG2Integration",
               "Get-AG2IntegrationResponse",
               "Get-AG2IntegrationResponseList",
               "Get-AG2IntegrationList",
               "Get-AG2Model",
               "Get-AG2ModelList",
               "Get-AG2ModelTemplate",
               "Get-AG2Route",
               "Get-AG2RouteResponse",
               "Get-AG2RouteResponseList",
               "Get-AG2RouteList",
               "Get-AG2RoutingRule",
               "Get-AG2Stage",
               "Get-AG2StageList",
               "Get-AG2Tag",
               "Get-AG2VpcLink",
               "Get-AG2VpcLinkList",
               "Import-AG2Api",
               "Get-AG2RoutingRuleList",
               "Write-AG2RoutingRule",
               "Update-AG2ApiImport",
               "Reset-AG2AuthorizersCache",
               "Add-AG2ResourceTag",
               "Remove-AG2ResourceTag",
               "Update-AG2Api",
               "Update-AG2ApiMapping",
               "Update-AG2Authorizer",
               "Update-AG2Deployment",
               "Update-AG2DomainName",
               "Update-AG2Integration",
               "Update-AG2IntegrationResponse",
               "Update-AG2Model",
               "Update-AG2Route",
               "Update-AG2RouteResponse",
               "Update-AG2Stage",
               "Update-AG2VpcLink")
}

_awsArgumentCompleterRegistration $AG2_SelectCompleters $AG2_SelectMap
# Argument completions for service AWS AppConfig


$APPC_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.AppConfig.DeletionProtectionCheck
        {
            ($_ -eq "Remove-APPCConfigurationProfile/DeletionProtectionCheck") -Or
            ($_ -eq "Remove-APPCEnvironment/DeletionProtectionCheck")
        }
        {
            $v = "ACCOUNT_DEFAULT","APPLY","BYPASS"
            break
        }

        # Amazon.AppConfig.GrowthType
        {
            ($_ -eq "New-APPCDeploymentStrategy/GrowthType") -Or
            ($_ -eq "Update-APPCDeploymentStrategy/GrowthType")
        }
        {
            $v = "EXPONENTIAL","LINEAR"
            break
        }

        # Amazon.AppConfig.ReplicateTo
        "New-APPCDeploymentStrategy/ReplicateTo"
        {
            $v = "NONE","SSM_DOCUMENT"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$APPC_map = @{
    "DeletionProtectionCheck"=@("Remove-APPCConfigurationProfile","Remove-APPCEnvironment")
    "GrowthType"=@("New-APPCDeploymentStrategy","Update-APPCDeploymentStrategy")
    "ReplicateTo"=@("New-APPCDeploymentStrategy")
}

_awsArgumentCompleterRegistration $APPC_Completers $APPC_map

$APPC_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.APPC.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$APPC_SelectMap = @{
    "Select"=@("New-APPCApplication",
               "New-APPCConfigurationProfile",
               "New-APPCDeploymentStrategy",
               "New-APPCEnvironment",
               "New-APPCExtension",
               "New-APPCExtensionAssociation",
               "New-APPCHostedConfigurationVersion",
               "Remove-APPCApplication",
               "Remove-APPCConfigurationProfile",
               "Remove-APPCDeploymentStrategy",
               "Remove-APPCEnvironment",
               "Remove-APPCExtension",
               "Remove-APPCExtensionAssociation",
               "Remove-APPCHostedConfigurationVersion",
               "Get-APPCAccountSetting",
               "Get-APPCApplication",
               "Get-APPCConfiguration",
               "Get-APPCConfigurationProfile",
               "Get-APPCDeployment",
               "Get-APPCDeploymentStrategy",
               "Get-APPCEnvironment",
               "Get-APPCExtension",
               "Get-APPCExtensionAssociation",
               "Get-APPCHostedConfigurationVersion",
               "Get-APPCApplicationList",
               "Get-APPCConfigurationProfileList",
               "Get-APPCDeploymentList",
               "Get-APPCDeploymentStrategyList",
               "Get-APPCEnvironmentList",
               "Get-APPCExtensionAssociationList",
               "Get-APPCExtensionList",
               "Get-APPCHostedConfigurationVersionList",
               "Get-APPCResourceTag",
               "Start-APPCDeployment",
               "Stop-APPCDeployment",
               "Add-APPCResourceTag",
               "Remove-APPCResourceTag",
               "Update-APPCAccountSetting",
               "Update-APPCApplication",
               "Update-APPCConfigurationProfile",
               "Update-APPCDeploymentStrategy",
               "Update-APPCEnvironment",
               "Update-APPCExtension",
               "Update-APPCExtensionAssociation",
               "Test-APPCConfigurationValidity")
}

_awsArgumentCompleterRegistration $APPC_SelectCompleters $APPC_SelectMap
# Argument completions for service AWS AppConfig Data


$ACD_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.ACD.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ACD_SelectMap = @{
    "Select"=@("Get-ACDLatestConfiguration",
               "Start-ACDConfigurationSession")
}

_awsArgumentCompleterRegistration $ACD_SelectCompleters $ACD_SelectMap
# Argument completions for service Amazon Web Services AppFabric


$AFAB_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.AppFabric.AuthType
        "New-AFABAppAuthorization/AuthType"
        {
            $v = "apiKey","oauth2"
            break
        }

        # Amazon.AppFabric.Format
        "New-AFABIngestionDestination/AuditLog_Format"
        {
            $v = "json","parquet"
            break
        }

        # Amazon.AppFabric.IngestionType
        "New-AFABIngestion/IngestionType"
        {
            $v = "auditLog"
            break
        }

        # Amazon.AppFabric.Schema
        "New-AFABIngestionDestination/AuditLog_Schema"
        {
            $v = "ocsf","raw"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AFAB_map = @{
    "AuditLog_Format"=@("New-AFABIngestionDestination")
    "AuditLog_Schema"=@("New-AFABIngestionDestination")
    "AuthType"=@("New-AFABAppAuthorization")
    "IngestionType"=@("New-AFABIngestion")
}

_awsArgumentCompleterRegistration $AFAB_Completers $AFAB_map

$AFAB_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.AFAB.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AFAB_SelectMap = @{
    "Select"=@("Get-AFABUserAccessTaskList",
               "Connect-AFABAppAuthorization",
               "New-AFABAppAuthorization",
               "New-AFABAppBundle",
               "New-AFABIngestion",
               "New-AFABIngestionDestination",
               "Remove-AFABAppAuthorization",
               "Remove-AFABAppBundle",
               "Remove-AFABIngestion",
               "Remove-AFABIngestionDestination",
               "Get-AFABAppAuthorization",
               "Get-AFABAppBundle",
               "Get-AFABIngestion",
               "Get-AFABIngestionDestination",
               "Get-AFABAppAuthorizationList",
               "Get-AFABAppBundleList",
               "Get-AFABIngestionDestinationList",
               "Get-AFABIngestionList",
               "Get-AFABResourceTag",
               "Start-AFABIngestion",
               "Start-AFABUserAccessTask",
               "Stop-AFABIngestion",
               "Add-AFABResourceTag",
               "Remove-AFABResourceTag",
               "Update-AFABAppAuthorization",
               "Update-AFABIngestionDestination")
}

_awsArgumentCompleterRegistration $AFAB_SelectCompleters $AFAB_SelectMap
# Argument completions for service Amazon Appflow


$AF_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.Appflow.ConnectionMode
        {
            ($_ -eq "New-AFConnectorProfile/ConnectionMode") -Or
            ($_ -eq "Update-AFConnectorProfile/ConnectionMode")
        }
        {
            $v = "Private","Public"
            break
        }

        # Amazon.Appflow.ConnectorProvisioningType
        "Register-AFConnector/ConnectorProvisioningType"
        {
            $v = "LAMBDA"
            break
        }

        # Amazon.Appflow.ConnectorType
        {
            ($_ -eq "Get-AFConnector/ConnectorType") -Or
            ($_ -eq "Get-AFConnectorEntity/ConnectorType") -Or
            ($_ -eq "Get-AFConnectorEntityList/ConnectorType") -Or
            ($_ -eq "Get-AFConnectorProfile/ConnectorType") -Or
            ($_ -eq "New-AFConnectorProfile/ConnectorType") -Or
            ($_ -eq "Reset-AFConnectorMetadataCache/ConnectorType") -Or
            ($_ -eq "New-AFFlow/SourceFlowConfig_ConnectorType") -Or
            ($_ -eq "Update-AFFlow/SourceFlowConfig_ConnectorType")
        }
        {
            $v = "Amplitude","CustomConnector","CustomerProfiles","Datadog","Dynatrace","EventBridge","Googleanalytics","Honeycode","Infornexus","LookoutMetrics","Marketo","Pardot","Redshift","S3","Salesforce","SAPOData","Servicenow","Singular","Slack","Snowflake","Trendmicro","Upsolver","Veeva","Zendesk"
            break
        }

        # Amazon.Appflow.DataPullMode
        {
            ($_ -eq "New-AFFlow/Scheduled_DataPullMode") -Or
            ($_ -eq "Update-AFFlow/Scheduled_DataPullMode")
        }
        {
            $v = "Complete","Incremental"
            break
        }

        # Amazon.Appflow.DataTransferApiType
        {
            ($_ -eq "New-AFFlow/DataTransferApi_Type") -Or
            ($_ -eq "Update-AFFlow/DataTransferApi_Type")
        }
        {
            $v = "ASYNC","AUTOMATIC","SYNC"
            break
        }

        # Amazon.Appflow.S3InputFileType
        {
            ($_ -eq "New-AFFlow/S3InputFormatConfig_S3InputFileType") -Or
            ($_ -eq "Update-AFFlow/S3InputFormatConfig_S3InputFileType")
        }
        {
            $v = "CSV","JSON"
            break
        }

        # Amazon.Appflow.SalesforceDataTransferApi
        {
            ($_ -eq "New-AFFlow/Salesforce_DataTransferApi") -Or
            ($_ -eq "Update-AFFlow/Salesforce_DataTransferApi")
        }
        {
            $v = "AUTOMATIC","BULKV2","REST_SYNC"
            break
        }

        # Amazon.Appflow.TriggerType
        {
            ($_ -eq "New-AFFlow/TriggerConfig_TriggerType") -Or
            ($_ -eq "Update-AFFlow/TriggerConfig_TriggerType")
        }
        {
            $v = "Event","OnDemand","Scheduled"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AF_map = @{
    "ConnectionMode"=@("New-AFConnectorProfile","Update-AFConnectorProfile")
    "ConnectorProvisioningType"=@("Register-AFConnector")
    "ConnectorType"=@("Get-AFConnector","Get-AFConnectorEntity","Get-AFConnectorEntityList","Get-AFConnectorProfile","New-AFConnectorProfile","Reset-AFConnectorMetadataCache")
    "DataTransferApi_Type"=@("New-AFFlow","Update-AFFlow")
    "S3InputFormatConfig_S3InputFileType"=@("New-AFFlow","Update-AFFlow")
    "Salesforce_DataTransferApi"=@("New-AFFlow","Update-AFFlow")
    "Scheduled_DataPullMode"=@("New-AFFlow","Update-AFFlow")
    "SourceFlowConfig_ConnectorType"=@("New-AFFlow","Update-AFFlow")
    "TriggerConfig_TriggerType"=@("New-AFFlow","Update-AFFlow")
}

_awsArgumentCompleterRegistration $AF_Completers $AF_map

$AF_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.AF.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AF_SelectMap = @{
    "Select"=@("Stop-AFFlowExecution",
               "New-AFConnectorProfile",
               "New-AFFlow",
               "Remove-AFConnectorProfile",
               "Remove-AFFlow",
               "Get-AFConnector",
               "Get-AFConnectorEntity",
               "Get-AFConnectorProfile",
               "Get-AFConnectorConfigurationList",
               "Get-AFFlow",
               "Get-AFFlowExecutionRecord",
               "Get-AFConnectorEntityList",
               "Get-AFConnectorList",
               "Get-AFFlowList",
               "Get-AFResourceTag",
               "Register-AFConnector",
               "Reset-AFConnectorMetadataCache",
               "Start-AFFlow",
               "Stop-AFFlow",
               "Add-AFResourceTag",
               "Unregister-AFConnector",
               "Remove-AFResourceTag",
               "Update-AFConnectorProfile",
               "Update-AFConnectorRegistration",
               "Update-AFFlow")
}

_awsArgumentCompleterRegistration $AF_SelectCompleters $AF_SelectMap
# Argument completions for service Amazon AppIntegrations Service


$AIS_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.AppIntegrationsService.ContactHandlingScope
        {
            ($_ -eq "New-AISApplication/ContactHandling_Scope") -Or
            ($_ -eq "Update-AISApplication/ContactHandling_Scope")
        }
        {
            $v = "CROSS_CONTACTS","PER_CONTACT"
            break
        }

        # Amazon.AppIntegrationsService.ExecutionMode
        {
            ($_ -eq "New-AISDataIntegrationAssociation/ExecutionConfiguration_ExecutionMode") -Or
            ($_ -eq "Update-AISDataIntegrationAssociation/ExecutionConfiguration_ExecutionMode")
        }
        {
            $v = "ON_DEMAND","SCHEDULED"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AIS_map = @{
    "ContactHandling_Scope"=@("New-AISApplication","Update-AISApplication")
    "ExecutionConfiguration_ExecutionMode"=@("New-AISDataIntegrationAssociation","Update-AISDataIntegrationAssociation")
}

_awsArgumentCompleterRegistration $AIS_Completers $AIS_map

$AIS_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.AIS.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AIS_SelectMap = @{
    "Select"=@("New-AISApplication",
               "New-AISDataIntegration",
               "New-AISDataIntegrationAssociation",
               "New-AISEventIntegration",
               "Remove-AISApplication",
               "Remove-AISDataIntegration",
               "Remove-AISEventIntegration",
               "Get-AISApplication",
               "Get-AISDataIntegration",
               "Get-AISEventIntegration",
               "Get-AISApplicationAssociationList",
               "Get-AISApplicationList",
               "Get-AISDataIntegrationAssociationList",
               "Get-AISDataIntegrationList",
               "Get-AISEventIntegrationAssociationList",
               "Get-AISEventIntegrationList",
               "Get-AISResourceTag",
               "Add-AISResourceTag",
               "Remove-AISResourceTag",
               "Update-AISApplication",
               "Update-AISDataIntegration",
               "Update-AISDataIntegrationAssociation",
               "Update-AISEventIntegration")
}

_awsArgumentCompleterRegistration $AIS_SelectCompleters $AIS_SelectMap
# Argument completions for service Application Auto Scaling


$AAS_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ApplicationAutoScaling.AdjustmentType
        "Set-AASScalingPolicy/StepScalingPolicyConfiguration_AdjustmentType"
        {
            $v = "ChangeInCapacity","ExactCapacity","PercentChangeInCapacity"
            break
        }

        # Amazon.ApplicationAutoScaling.MetricAggregationType
        "Set-AASScalingPolicy/StepScalingPolicyConfiguration_MetricAggregationType"
        {
            $v = "Average","Maximum","Minimum"
            break
        }

        # Amazon.ApplicationAutoScaling.MetricStatistic
        "Set-AASScalingPolicy/CustomizedMetricSpecification_Statistic"
        {
            $v = "Average","Maximum","Minimum","SampleCount","Sum"
            break
        }

        # Amazon.ApplicationAutoScaling.MetricType
        "Set-AASScalingPolicy/PredefinedMetricSpecification_PredefinedMetricType"
        {
            $v = "ALBRequestCountPerTarget","AppStreamAverageCapacityUtilization","CassandraReadCapacityUtilization","CassandraWriteCapacityUtilization","ComprehendInferenceUtilization","DynamoDBReadCapacityUtilization","DynamoDBWriteCapacityUtilization","EC2SpotFleetRequestAverageCPUUtilization","EC2SpotFleetRequestAverageNetworkIn","EC2SpotFleetRequestAverageNetworkOut","ECSServiceAverageCPUUtilization","ECSServiceAverageMemoryUtilization","ElastiCacheDatabaseCapacityUsageCountedForEvictPercentage","ElastiCacheDatabaseMemoryUsageCountedForEvictPercentage","ElastiCacheDatabaseMemoryUsagePercentage","ElastiCacheEngineCPUUtilization","ElastiCachePrimaryEngineCPUUtilization","ElastiCacheReplicaEngineCPUUtilization","KafkaBrokerStorageUtilization","LambdaProvisionedConcurrencyUtilization","NeptuneReaderAverageCPUUtilization","RDSReaderAverageCPUUtilization","RDSReaderAverageDatabaseConnections","SageMakerInferenceComponentConcurrentRequestsPerCopyHighResolution","SageMakerInferenceComponentInvocationsPerCopy","SageMakerVariantConcurrentRequestsPerModelHighResolution","SageMakerVariantInvocationsPerInstance","SageMakerVariantProvisionedConcurrencyUtilization","WorkSpacesAverageUserSessionsCapacityUtilization"
            break
        }

        # Amazon.ApplicationAutoScaling.PolicyType
        "Set-AASScalingPolicy/PolicyType"
        {
            $v = "PredictiveScaling","StepScaling","TargetTrackingScaling"
            break
        }

        # Amazon.ApplicationAutoScaling.PredictiveScalingMaxCapacityBreachBehavior
        "Set-AASScalingPolicy/PredictiveScalingPolicyConfiguration_MaxCapacityBreachBehavior"
        {
            $v = "HonorMaxCapacity","IncreaseMaxCapacity"
            break
        }

        # Amazon.ApplicationAutoScaling.PredictiveScalingMode
        "Set-AASScalingPolicy/PredictiveScalingPolicyConfiguration_Mode"
        {
            $v = "ForecastAndScale","ForecastOnly"
            break
        }

        # Amazon.ApplicationAutoScaling.ScalableDimension
        {
            ($_ -eq "Add-AASScalableTarget/ScalableDimension") -Or
            ($_ -eq "Get-AASPredictiveScalingForecast/ScalableDimension") -Or
            ($_ -eq "Get-AASScalableTarget/ScalableDimension") -Or
            ($_ -eq "Get-AASScalingActivity/ScalableDimension") -Or
            ($_ -eq "Get-AASScalingPolicy/ScalableDimension") -Or
            ($_ -eq "Get-AASScheduledAction/ScalableDimension") -Or
            ($_ -eq "Remove-AASScalableTarget/ScalableDimension") -Or
            ($_ -eq "Remove-AASScalingPolicy/ScalableDimension") -Or
            ($_ -eq "Remove-AASScheduledAction/ScalableDimension") -Or
            ($_ -eq "Set-AASScalingPolicy/ScalableDimension") -Or
            ($_ -eq "Set-AASScheduledAction/ScalableDimension")
        }
        {
            $v = "appstream:fleet:DesiredCapacity","cassandra:table:ReadCapacityUnits","cassandra:table:WriteCapacityUnits","comprehend:document-classifier-endpoint:DesiredInferenceUnits","comprehend:entity-recognizer-endpoint:DesiredInferenceUnits","custom-resource:ResourceType:Property","dynamodb:index:ReadCapacityUnits","dynamodb:index:WriteCapacityUnits","dynamodb:table:ReadCapacityUnits","dynamodb:table:WriteCapacityUnits","ec2:spot-fleet-request:TargetCapacity","ecs:service:DesiredCount","elasticache:cache-cluster:Nodes","elasticache:replication-group:NodeGroups","elasticache:replication-group:Replicas","elasticmapreduce:instancegroup:InstanceCount","kafka:broker-storage:VolumeSize","lambda:function:ProvisionedConcurrency","neptune:cluster:ReadReplicaCount","rds:cluster:ReadReplicaCount","sagemaker:inference-component:DesiredCopyCount","sagemaker:variant:DesiredInstanceCount","sagemaker:variant:DesiredProvisionedConcurrency","workspaces:workspacespool:DesiredUserSessions"
            break
        }

        # Amazon.ApplicationAutoScaling.ServiceNamespace
        {
            ($_ -eq "Add-AASScalableTarget/ServiceNamespace") -Or
            ($_ -eq "Get-AASPredictiveScalingForecast/ServiceNamespace") -Or
            ($_ -eq "Get-AASScalableTarget/ServiceNamespace") -Or
            ($_ -eq "Get-AASScalingActivity/ServiceNamespace") -Or
            ($_ -eq "Get-AASScalingPolicy/ServiceNamespace") -Or
            ($_ -eq "Get-AASScheduledAction/ServiceNamespace") -Or
            ($_ -eq "Remove-AASScalableTarget/ServiceNamespace") -Or
            ($_ -eq "Remove-AASScalingPolicy/ServiceNamespace") -Or
            ($_ -eq "Remove-AASScheduledAction/ServiceNamespace") -Or
            ($_ -eq "Set-AASScalingPolicy/ServiceNamespace") -Or
            ($_ -eq "Set-AASScheduledAction/ServiceNamespace")
        }
        {
            $v = "appstream","cassandra","comprehend","custom-resource","dynamodb","ec2","ecs","elasticache","elasticmapreduce","kafka","lambda","neptune","rds","sagemaker","workspaces"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AAS_map = @{
    "CustomizedMetricSpecification_Statistic"=@("Set-AASScalingPolicy")
    "PolicyType"=@("Set-AASScalingPolicy")
    "PredefinedMetricSpecification_PredefinedMetricType"=@("Set-AASScalingPolicy")
    "PredictiveScalingPolicyConfiguration_MaxCapacityBreachBehavior"=@("Set-AASScalingPolicy")
    "PredictiveScalingPolicyConfiguration_Mode"=@("Set-AASScalingPolicy")
    "ScalableDimension"=@("Add-AASScalableTarget","Get-AASPredictiveScalingForecast","Get-AASScalableTarget","Get-AASScalingActivity","Get-AASScalingPolicy","Get-AASScheduledAction","Remove-AASScalableTarget","Remove-AASScalingPolicy","Remove-AASScheduledAction","Set-AASScalingPolicy","Set-AASScheduledAction")
    "ServiceNamespace"=@("Add-AASScalableTarget","Get-AASPredictiveScalingForecast","Get-AASScalableTarget","Get-AASScalingActivity","Get-AASScalingPolicy","Get-AASScheduledAction","Remove-AASScalableTarget","Remove-AASScalingPolicy","Remove-AASScheduledAction","Set-AASScalingPolicy","Set-AASScheduledAction")
    "StepScalingPolicyConfiguration_AdjustmentType"=@("Set-AASScalingPolicy")
    "StepScalingPolicyConfiguration_MetricAggregationType"=@("Set-AASScalingPolicy")
}

_awsArgumentCompleterRegistration $AAS_Completers $AAS_map

$AAS_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.AAS.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AAS_SelectMap = @{
    "Select"=@("Remove-AASScalingPolicy",
               "Remove-AASScheduledAction",
               "Remove-AASScalableTarget",
               "Get-AASScalableTarget",
               "Get-AASScalingActivity",
               "Get-AASScalingPolicy",
               "Get-AASScheduledAction",
               "Get-AASPredictiveScalingForecast",
               "Get-AASResourceTag",
               "Set-AASScalingPolicy",
               "Set-AASScheduledAction",
               "Add-AASScalableTarget",
               "Add-AASResourceTag",
               "Remove-AASResourceTag")
}

_awsArgumentCompleterRegistration $AAS_SelectCompleters $AAS_SelectMap
# Argument completions for service Amazon CloudWatch Application Insights


$CWAI_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ApplicationInsights.ConfigurationEventStatus
        "Get-CWAIConfigurationHistoryList/EventStatus"
        {
            $v = "ERROR","INFO","WARN"
            break
        }

        # Amazon.ApplicationInsights.GroupingType
        "New-CWAIApplication/GroupingType"
        {
            $v = "ACCOUNT_BASED"
            break
        }

        # Amazon.ApplicationInsights.RecommendationType
        "Get-CWAIComponentConfigurationRecommendation/RecommendationType"
        {
            $v = "ALL","INFRA_ONLY","WORKLOAD_ONLY"
            break
        }

        # Amazon.ApplicationInsights.Tier
        {
            ($_ -eq "Get-CWAIComponentConfigurationRecommendation/Tier") -Or
            ($_ -eq "Update-CWAIComponentConfiguration/Tier") -Or
            ($_ -eq "Add-CWAIWorkload/WorkloadConfiguration_Tier") -Or
            ($_ -eq "Update-CWAIWorkload/WorkloadConfiguration_Tier")
        }
        {
            $v = "ACTIVE_DIRECTORY","CUSTOM","DEFAULT","DOT_NET_CORE","DOT_NET_WEB","DOT_NET_WEB_TIER","DOT_NET_WORKER","JAVA_JMX","MYSQL","ORACLE","POSTGRESQL","SAP_ASE_HIGH_AVAILABILITY","SAP_ASE_SINGLE_NODE","SAP_HANA_HIGH_AVAILABILITY","SAP_HANA_MULTI_NODE","SAP_HANA_SINGLE_NODE","SAP_NETWEAVER_DISTRIBUTED","SAP_NETWEAVER_HIGH_AVAILABILITY","SAP_NETWEAVER_STANDARD","SHAREPOINT","SQL_SERVER","SQL_SERVER_ALWAYSON_AVAILABILITY_GROUP","SQL_SERVER_FAILOVER_CLUSTER_INSTANCE"
            break
        }

        # Amazon.ApplicationInsights.UpdateStatus
        "Update-CWAIProblem/UpdateStatus"
        {
            $v = "RESOLVED"
            break
        }

        # Amazon.ApplicationInsights.Visibility
        {
            ($_ -eq "Get-CWAIProblemList/Visibility") -Or
            ($_ -eq "Update-CWAIProblem/Visibility")
        }
        {
            $v = "IGNORED","VISIBLE"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CWAI_map = @{
    "EventStatus"=@("Get-CWAIConfigurationHistoryList")
    "GroupingType"=@("New-CWAIApplication")
    "RecommendationType"=@("Get-CWAIComponentConfigurationRecommendation")
    "Tier"=@("Get-CWAIComponentConfigurationRecommendation","Update-CWAIComponentConfiguration")
    "UpdateStatus"=@("Update-CWAIProblem")
    "Visibility"=@("Get-CWAIProblemList","Update-CWAIProblem")
    "WorkloadConfiguration_Tier"=@("Add-CWAIWorkload","Update-CWAIWorkload")
}

_awsArgumentCompleterRegistration $CWAI_Completers $CWAI_map

$CWAI_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CWAI.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CWAI_SelectMap = @{
    "Select"=@("Add-CWAIWorkload",
               "New-CWAIApplication",
               "New-CWAIComponent",
               "New-CWAILogPattern",
               "Remove-CWAIApplication",
               "Remove-CWAIComponent",
               "Remove-CWAILogPattern",
               "Get-CWAIApplication",
               "Get-CWAIComponent",
               "Get-CWAIComponentConfiguration",
               "Get-CWAIComponentConfigurationRecommendation",
               "Get-CWAILogPattern",
               "Get-CWAIObservation",
               "Get-CWAIProblem",
               "Get-CWAIProblemObservation",
               "Get-CWAIWorkload",
               "Get-CWAIApplicationList",
               "Get-CWAIComponentList",
               "Get-CWAIConfigurationHistoryList",
               "Get-CWAILogPatternList",
               "Get-CWAILogPatternSetList",
               "Get-CWAIProblemList",
               "Get-CWAIResourceTag",
               "Get-CWAIWorkloadList",
               "Remove-CWAIWorkload",
               "Add-CWAIResourceTag",
               "Remove-CWAIResourceTag",
               "Update-CWAIApplication",
               "Update-CWAIComponent",
               "Update-CWAIComponentConfiguration",
               "Update-CWAILogPattern",
               "Update-CWAIProblem",
               "Update-CWAIWorkload")
}

_awsArgumentCompleterRegistration $CWAI_SelectCompleters $CWAI_SelectMap
# Argument completions for service Amazon CloudWatch Application Signals


$CWAS_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ApplicationSignals.DurationUnit
        {
            ($_ -eq "New-CWASServiceLevelObjective/CalendarInterval_DurationUnit") -Or
            ($_ -eq "Update-CWASServiceLevelObjective/CalendarInterval_DurationUnit") -Or
            ($_ -eq "New-CWASServiceLevelObjective/RollingInterval_DurationUnit") -Or
            ($_ -eq "Update-CWASServiceLevelObjective/RollingInterval_DurationUnit")
        }
        {
            $v = "DAY","HOUR","MINUTE","MONTH"
            break
        }

        # Amazon.ApplicationSignals.ServiceLevelIndicatorComparisonOperator
        {
            ($_ -eq "New-CWASServiceLevelObjective/RequestBasedSliConfig_ComparisonOperator") -Or
            ($_ -eq "Update-CWASServiceLevelObjective/RequestBasedSliConfig_ComparisonOperator") -Or
            ($_ -eq "New-CWASServiceLevelObjective/SliConfig_ComparisonOperator") -Or
            ($_ -eq "Update-CWASServiceLevelObjective/SliConfig_ComparisonOperator")
        }
        {
            $v = "GreaterThan","GreaterThanOrEqualTo","LessThan","LessThanOrEqualTo"
            break
        }

        # Amazon.ApplicationSignals.ServiceLevelIndicatorMetricType
        {
            ($_ -eq "New-CWASServiceLevelObjective/RequestBasedSliMetricConfig_MetricType") -Or
            ($_ -eq "Update-CWASServiceLevelObjective/RequestBasedSliMetricConfig_MetricType") -Or
            ($_ -eq "New-CWASServiceLevelObjective/SliMetricConfig_MetricType") -Or
            ($_ -eq "Update-CWASServiceLevelObjective/SliMetricConfig_MetricType")
        }
        {
            $v = "AVAILABILITY","LATENCY"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CWAS_map = @{
    "CalendarInterval_DurationUnit"=@("New-CWASServiceLevelObjective","Update-CWASServiceLevelObjective")
    "RequestBasedSliConfig_ComparisonOperator"=@("New-CWASServiceLevelObjective","Update-CWASServiceLevelObjective")
    "RequestBasedSliMetricConfig_MetricType"=@("New-CWASServiceLevelObjective","Update-CWASServiceLevelObjective")
    "RollingInterval_DurationUnit"=@("New-CWASServiceLevelObjective","Update-CWASServiceLevelObjective")
    "SliConfig_ComparisonOperator"=@("New-CWASServiceLevelObjective","Update-CWASServiceLevelObjective")
    "SliMetricConfig_MetricType"=@("New-CWASServiceLevelObjective","Update-CWASServiceLevelObjective")
}

_awsArgumentCompleterRegistration $CWAS_Completers $CWAS_map

$CWAS_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CWAS.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CWAS_SelectMap = @{
    "Select"=@("Get-CWASBatchServiceLevelObjectiveBudgetReport",
               "Update-CWASUpdateExclusionWindow",
               "New-CWASServiceLevelObjective",
               "Remove-CWASGroupingConfiguration",
               "Remove-CWASServiceLevelObjective",
               "Get-CWASService",
               "Get-CWASServiceLevelObjective",
               "Get-CWASAuditFindingList",
               "Get-CWASGroupingAttributeDefinitionList",
               "Get-CWASServiceDependencyList",
               "Get-CWASServiceDependentList",
               "Get-CWASServiceLevelObjectiveExclusionWindowList",
               "Get-CWASServiceLevelObjectiveList",
               "Get-CWASServiceOperationList",
               "Get-CWASServiceList",
               "Get-CWASServiceStateList",
               "Get-CWASResourceTag",
               "Write-CWASGroupingConfiguration",
               "Start-CWASDiscovery",
               "Add-CWASResourceTag",
               "Remove-CWASResourceTag",
               "Update-CWASServiceLevelObjective")
}

_awsArgumentCompleterRegistration $CWAS_SelectCompleters $CWAS_SelectMap
# Argument completions for service Amazon ApplicationCostProfiler


$ACP_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ApplicationCostProfiler.Format
        {
            ($_ -eq "Update-ACPReportDefinition/Format") -Or
            ($_ -eq "Write-ACPReportDefinition/Format")
        }
        {
            $v = "CSV","PARQUET"
            break
        }

        # Amazon.ApplicationCostProfiler.ReportFrequency
        {
            ($_ -eq "Update-ACPReportDefinition/ReportFrequency") -Or
            ($_ -eq "Write-ACPReportDefinition/ReportFrequency")
        }
        {
            $v = "ALL","DAILY","MONTHLY"
            break
        }

        # Amazon.ApplicationCostProfiler.S3BucketRegion
        "Import-ACPApplicationUsage/SourceS3Location_Region"
        {
            $v = "af-south-1","ap-east-1","eu-south-1","me-south-1"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ACP_map = @{
    "Format"=@("Update-ACPReportDefinition","Write-ACPReportDefinition")
    "ReportFrequency"=@("Update-ACPReportDefinition","Write-ACPReportDefinition")
    "SourceS3Location_Region"=@("Import-ACPApplicationUsage")
}

_awsArgumentCompleterRegistration $ACP_Completers $ACP_map

$ACP_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.ACP.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ACP_SelectMap = @{
    "Select"=@("Remove-ACPReportDefinition",
               "Get-ACPReportDefinition",
               "Import-ACPApplicationUsage",
               "Get-ACPReportDefinitionList",
               "Write-ACPReportDefinition",
               "Update-ACPReportDefinition")
}

_awsArgumentCompleterRegistration $ACP_SelectCompleters $ACP_SelectMap
# Argument completions for service AWS App Mesh


$AMSH_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.AppMesh.DefaultGatewayRouteRewrite
        {
            ($_ -eq "New-AMSHGatewayRoute/Spec_GrpcRoute_Action_Rewrite_Hostname_DefaultTargetHostname") -Or
            ($_ -eq "Update-AMSHGatewayRoute/Spec_GrpcRoute_Action_Rewrite_Hostname_DefaultTargetHostname") -Or
            ($_ -eq "New-AMSHGatewayRoute/Spec_Http2Route_Action_Rewrite_Hostname_DefaultTargetHostname") -Or
            ($_ -eq "Update-AMSHGatewayRoute/Spec_Http2Route_Action_Rewrite_Hostname_DefaultTargetHostname") -Or
            ($_ -eq "New-AMSHGatewayRoute/Spec_Http2Route_Action_Rewrite_Prefix_DefaultPrefix") -Or
            ($_ -eq "Update-AMSHGatewayRoute/Spec_Http2Route_Action_Rewrite_Prefix_DefaultPrefix") -Or
            ($_ -eq "New-AMSHGatewayRoute/Spec_HttpRoute_Action_Rewrite_Hostname_DefaultTargetHostname") -Or
            ($_ -eq "Update-AMSHGatewayRoute/Spec_HttpRoute_Action_Rewrite_Hostname_DefaultTargetHostname") -Or
            ($_ -eq "New-AMSHGatewayRoute/Spec_HttpRoute_Action_Rewrite_Prefix_DefaultPrefix") -Or
            ($_ -eq "Update-AMSHGatewayRoute/Spec_HttpRoute_Action_Rewrite_Prefix_DefaultPrefix")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.AppMesh.DnsResponseType
        {
            ($_ -eq "New-AMSHVirtualNode/Dns_ResponseType") -Or
            ($_ -eq "Update-AMSHVirtualNode/Dns_ResponseType")
        }
        {
            $v = "ENDPOINTS","LOADBALANCER"
            break
        }

        # Amazon.AppMesh.DurationUnit
        {
            ($_ -eq "New-AMSHRoute/Spec_GrpcRoute_RetryPolicy_PerRetryTimeout_Unit") -Or
            ($_ -eq "Update-AMSHRoute/Spec_GrpcRoute_RetryPolicy_PerRetryTimeout_Unit") -Or
            ($_ -eq "New-AMSHRoute/Spec_GrpcRoute_Timeout_Idle_Unit") -Or
            ($_ -eq "Update-AMSHRoute/Spec_GrpcRoute_Timeout_Idle_Unit") -Or
            ($_ -eq "New-AMSHRoute/Spec_GrpcRoute_Timeout_PerRequest_Unit") -Or
            ($_ -eq "Update-AMSHRoute/Spec_GrpcRoute_Timeout_PerRequest_Unit") -Or
            ($_ -eq "New-AMSHRoute/Spec_Http2Route_RetryPolicy_PerRetryTimeout_Unit") -Or
            ($_ -eq "Update-AMSHRoute/Spec_Http2Route_RetryPolicy_PerRetryTimeout_Unit") -Or
            ($_ -eq "New-AMSHRoute/Spec_Http2Route_Timeout_Idle_Unit") -Or
            ($_ -eq "Update-AMSHRoute/Spec_Http2Route_Timeout_Idle_Unit") -Or
            ($_ -eq "New-AMSHRoute/Spec_Http2Route_Timeout_PerRequest_Unit") -Or
            ($_ -eq "Update-AMSHRoute/Spec_Http2Route_Timeout_PerRequest_Unit") -Or
            ($_ -eq "New-AMSHRoute/Spec_HttpRoute_RetryPolicy_PerRetryTimeout_Unit") -Or
            ($_ -eq "Update-AMSHRoute/Spec_HttpRoute_RetryPolicy_PerRetryTimeout_Unit") -Or
            ($_ -eq "New-AMSHRoute/Spec_HttpRoute_Timeout_Idle_Unit") -Or
            ($_ -eq "Update-AMSHRoute/Spec_HttpRoute_Timeout_Idle_Unit") -Or
            ($_ -eq "New-AMSHRoute/Spec_HttpRoute_Timeout_PerRequest_Unit") -Or
            ($_ -eq "Update-AMSHRoute/Spec_HttpRoute_Timeout_PerRequest_Unit") -Or
            ($_ -eq "New-AMSHRoute/Spec_TcpRoute_Timeout_Idle_Unit") -Or
            ($_ -eq "Update-AMSHRoute/Spec_TcpRoute_Timeout_Idle_Unit")
        }
        {
            $v = "ms","s"
            break
        }

        # Amazon.AppMesh.EgressFilterType
        {
            ($_ -eq "New-AMSHMesh/EgressFilter_Type") -Or
            ($_ -eq "Update-AMSHMesh/EgressFilter_Type")
        }
        {
            $v = "ALLOW_ALL","DROP_ALL"
            break
        }

        # Amazon.AppMesh.HttpMethod
        {
            ($_ -eq "New-AMSHGatewayRoute/Spec_Http2Route_Match_Method") -Or
            ($_ -eq "New-AMSHRoute/Spec_Http2Route_Match_Method") -Or
            ($_ -eq "Update-AMSHGatewayRoute/Spec_Http2Route_Match_Method") -Or
            ($_ -eq "Update-AMSHRoute/Spec_Http2Route_Match_Method") -Or
            ($_ -eq "New-AMSHGatewayRoute/Spec_HttpRoute_Match_Method") -Or
            ($_ -eq "New-AMSHRoute/Spec_HttpRoute_Match_Method") -Or
            ($_ -eq "Update-AMSHGatewayRoute/Spec_HttpRoute_Match_Method") -Or
            ($_ -eq "Update-AMSHRoute/Spec_HttpRoute_Match_Method")
        }
        {
            $v = "CONNECT","DELETE","GET","HEAD","OPTIONS","PATCH","POST","PUT","TRACE"
            break
        }

        # Amazon.AppMesh.HttpScheme
        {
            ($_ -eq "New-AMSHRoute/Spec_Http2Route_Match_Scheme") -Or
            ($_ -eq "Update-AMSHRoute/Spec_Http2Route_Match_Scheme") -Or
            ($_ -eq "New-AMSHRoute/Spec_HttpRoute_Match_Scheme") -Or
            ($_ -eq "Update-AMSHRoute/Spec_HttpRoute_Match_Scheme")
        }
        {
            $v = "http","https"
            break
        }

        # Amazon.AppMesh.IpPreference
        {
            ($_ -eq "New-AMSHVirtualNode/AwsCloudMap_IpPreference") -Or
            ($_ -eq "Update-AMSHVirtualNode/AwsCloudMap_IpPreference") -Or
            ($_ -eq "New-AMSHVirtualNode/Dns_IpPreference") -Or
            ($_ -eq "Update-AMSHVirtualNode/Dns_IpPreference") -Or
            ($_ -eq "New-AMSHMesh/ServiceDiscovery_IpPreference") -Or
            ($_ -eq "Update-AMSHMesh/ServiceDiscovery_IpPreference")
        }
        {
            $v = "IPv4_ONLY","IPv4_PREFERRED","IPv6_ONLY","IPv6_PREFERRED"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AMSH_map = @{
    "AwsCloudMap_IpPreference"=@("New-AMSHVirtualNode","Update-AMSHVirtualNode")
    "Dns_IpPreference"=@("New-AMSHVirtualNode","Update-AMSHVirtualNode")
    "Dns_ResponseType"=@("New-AMSHVirtualNode","Update-AMSHVirtualNode")
    "EgressFilter_Type"=@("New-AMSHMesh","Update-AMSHMesh")
    "ServiceDiscovery_IpPreference"=@("New-AMSHMesh","Update-AMSHMesh")
    "Spec_GrpcRoute_Action_Rewrite_Hostname_DefaultTargetHostname"=@("New-AMSHGatewayRoute","Update-AMSHGatewayRoute")
    "Spec_GrpcRoute_RetryPolicy_PerRetryTimeout_Unit"=@("New-AMSHRoute","Update-AMSHRoute")
    "Spec_GrpcRoute_Timeout_Idle_Unit"=@("New-AMSHRoute","Update-AMSHRoute")
    "Spec_GrpcRoute_Timeout_PerRequest_Unit"=@("New-AMSHRoute","Update-AMSHRoute")
    "Spec_Http2Route_Action_Rewrite_Hostname_DefaultTargetHostname"=@("New-AMSHGatewayRoute","Update-AMSHGatewayRoute")
    "Spec_Http2Route_Action_Rewrite_Prefix_DefaultPrefix"=@("New-AMSHGatewayRoute","Update-AMSHGatewayRoute")
    "Spec_Http2Route_Match_Method"=@("New-AMSHGatewayRoute","New-AMSHRoute","Update-AMSHGatewayRoute","Update-AMSHRoute")
    "Spec_Http2Route_Match_Scheme"=@("New-AMSHRoute","Update-AMSHRoute")
    "Spec_Http2Route_RetryPolicy_PerRetryTimeout_Unit"=@("New-AMSHRoute","Update-AMSHRoute")
    "Spec_Http2Route_Timeout_Idle_Unit"=@("New-AMSHRoute","Update-AMSHRoute")
    "Spec_Http2Route_Timeout_PerRequest_Unit"=@("New-AMSHRoute","Update-AMSHRoute")
    "Spec_HttpRoute_Action_Rewrite_Hostname_DefaultTargetHostname"=@("New-AMSHGatewayRoute","Update-AMSHGatewayRoute")
    "Spec_HttpRoute_Action_Rewrite_Prefix_DefaultPrefix"=@("New-AMSHGatewayRoute","Update-AMSHGatewayRoute")
    "Spec_HttpRoute_Match_Method"=@("New-AMSHGatewayRoute","New-AMSHRoute","Update-AMSHGatewayRoute","Update-AMSHRoute")
    "Spec_HttpRoute_Match_Scheme"=@("New-AMSHRoute","Update-AMSHRoute")
    "Spec_HttpRoute_RetryPolicy_PerRetryTimeout_Unit"=@("New-AMSHRoute","Update-AMSHRoute")
    "Spec_HttpRoute_Timeout_Idle_Unit"=@("New-AMSHRoute","Update-AMSHRoute")
    "Spec_HttpRoute_Timeout_PerRequest_Unit"=@("New-AMSHRoute","Update-AMSHRoute")
    "Spec_TcpRoute_Timeout_Idle_Unit"=@("New-AMSHRoute","Update-AMSHRoute")
}

_awsArgumentCompleterRegistration $AMSH_Completers $AMSH_map

$AMSH_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.AMSH.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AMSH_SelectMap = @{
    "Select"=@("New-AMSHGatewayRoute",
               "New-AMSHMesh",
               "New-AMSHRoute",
               "New-AMSHVirtualGateway",
               "New-AMSHVirtualNode",
               "New-AMSHVirtualRouter",
               "New-AMSHVirtualService",
               "Remove-AMSHGatewayRoute",
               "Remove-AMSHMesh",
               "Remove-AMSHRoute",
               "Remove-AMSHVirtualGateway",
               "Remove-AMSHVirtualNode",
               "Remove-AMSHVirtualRouter",
               "Remove-AMSHVirtualService",
               "Get-AMSHGatewayRoute",
               "Get-AMSHMesh",
               "Get-AMSHRoute",
               "Get-AMSHVirtualGateway",
               "Get-AMSHVirtualNode",
               "Get-AMSHVirtualRouter",
               "Get-AMSHVirtualService",
               "Get-AMSHGatewayRouteList",
               "Get-AMSHMeshList",
               "Get-AMSHRouteList",
               "Get-AMSHResourceTag",
               "Get-AMSHVirtualGatewayList",
               "Get-AMSHVirtualNodeList",
               "Get-AMSHVirtualRouterList",
               "Get-AMSHVirtualServiceList",
               "Add-AMSHResourceTag",
               "Remove-AMSHResourceTag",
               "Update-AMSHGatewayRoute",
               "Update-AMSHMesh",
               "Update-AMSHRoute",
               "Update-AMSHVirtualGateway",
               "Update-AMSHVirtualNode",
               "Update-AMSHVirtualRouter",
               "Update-AMSHVirtualService")
}

_awsArgumentCompleterRegistration $AMSH_SelectCompleters $AMSH_SelectMap
# Argument completions for service AWS App Runner


$AAR_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.AppRunner.ConfigurationSource
        {
            ($_ -eq "New-AARService/CodeConfiguration_ConfigurationSource") -Or
            ($_ -eq "Update-AARService/CodeConfiguration_ConfigurationSource")
        }
        {
            $v = "API","REPOSITORY"
            break
        }

        # Amazon.AppRunner.EgressType
        {
            ($_ -eq "New-AARService/EgressConfiguration_EgressType") -Or
            ($_ -eq "Update-AARService/EgressConfiguration_EgressType")
        }
        {
            $v = "DEFAULT","VPC"
            break
        }

        # Amazon.AppRunner.HealthCheckProtocol
        {
            ($_ -eq "New-AARService/HealthCheckConfiguration_Protocol") -Or
            ($_ -eq "Update-AARService/HealthCheckConfiguration_Protocol")
        }
        {
            $v = "HTTP","TCP"
            break
        }

        # Amazon.AppRunner.ImageRepositoryType
        {
            ($_ -eq "New-AARService/ImageRepository_ImageRepositoryType") -Or
            ($_ -eq "Update-AARService/ImageRepository_ImageRepositoryType")
        }
        {
            $v = "ECR","ECR_PUBLIC"
            break
        }

        # Amazon.AppRunner.IpAddressType
        {
            ($_ -eq "New-AARService/NetworkConfiguration_IpAddressType") -Or
            ($_ -eq "Update-AARService/NetworkConfiguration_IpAddressType")
        }
        {
            $v = "DUAL_STACK","IPV4"
            break
        }

        # Amazon.AppRunner.ProviderType
        "New-AARConnection/ProviderType"
        {
            $v = "BITBUCKET","GITHUB"
            break
        }

        # Amazon.AppRunner.Runtime
        {
            ($_ -eq "New-AARService/CodeConfigurationValues_Runtime") -Or
            ($_ -eq "Update-AARService/CodeConfigurationValues_Runtime")
        }
        {
            $v = "CORRETTO_11","CORRETTO_8","DOTNET_6","GO_1","NODEJS_12","NODEJS_14","NODEJS_16","NODEJS_18","NODEJS_22","PHP_81","PYTHON_3","PYTHON_311","RUBY_31"
            break
        }

        # Amazon.AppRunner.SourceCodeVersionType
        {
            ($_ -eq "New-AARService/SourceCodeVersion_Type") -Or
            ($_ -eq "Update-AARService/SourceCodeVersion_Type")
        }
        {
            $v = "BRANCH"
            break
        }

        # Amazon.AppRunner.TracingVendor
        "New-AARObservabilityConfiguration/TraceConfiguration_Vendor"
        {
            $v = "AWSXRAY"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AAR_map = @{
    "CodeConfiguration_ConfigurationSource"=@("New-AARService","Update-AARService")
    "CodeConfigurationValues_Runtime"=@("New-AARService","Update-AARService")
    "EgressConfiguration_EgressType"=@("New-AARService","Update-AARService")
    "HealthCheckConfiguration_Protocol"=@("New-AARService","Update-AARService")
    "ImageRepository_ImageRepositoryType"=@("New-AARService","Update-AARService")
    "NetworkConfiguration_IpAddressType"=@("New-AARService","Update-AARService")
    "ProviderType"=@("New-AARConnection")
    "SourceCodeVersion_Type"=@("New-AARService","Update-AARService")
    "TraceConfiguration_Vendor"=@("New-AARObservabilityConfiguration")
}

_awsArgumentCompleterRegistration $AAR_Completers $AAR_map

$AAR_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.AAR.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AAR_SelectMap = @{
    "Select"=@("Add-AARCustomDomain",
               "New-AARAutoScalingConfiguration",
               "New-AARConnection",
               "New-AARObservabilityConfiguration",
               "New-AARService",
               "New-AARVpcConnector",
               "New-AARVpcIngressConnection",
               "Remove-AARAutoScalingConfiguration",
               "Remove-AARConnection",
               "Remove-AARObservabilityConfiguration",
               "Remove-AARService",
               "Remove-AARVpcConnector",
               "Remove-AARVpcIngressConnection",
               "Get-AARAutoScalingConfiguration",
               "Get-AARCustomDomain",
               "Get-AARObservabilityConfiguration",
               "Get-AARService",
               "Get-AARVpcConnector",
               "Get-AARVpcIngressConnection",
               "Remove-AARCustomDomain",
               "Get-AARAutoScalingConfigurationList",
               "Get-AARConnectionList",
               "Get-AARObservabilityConfigurationList",
               "Get-AAROperationList",
               "Get-AARServiceList",
               "Get-AARServicesForAutoScalingConfigurationList",
               "Get-AARResourceTag",
               "Get-AARVpcConnectorList",
               "Get-AARVpcIngressConnectionList",
               "Suspend-AARService",
               "Resume-AARService",
               "Start-AARDeployment",
               "Add-AARResourceTag",
               "Remove-AARResourceTag",
               "Update-AARDefaultAutoScalingConfiguration",
               "Update-AARService",
               "Update-AARVpcIngressConnection")
}

_awsArgumentCompleterRegistration $AAR_SelectCompleters $AAR_SelectMap
# Argument completions for service Amazon AppStream


$APS_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.AppStream.AppBlockBuilderPlatformType
        "New-APSAppBlockBuilder/Platform"
        {
            $v = "WINDOWS_SERVER_2019"
            break
        }

        # Amazon.AppStream.AppVisibility
        {
            ($_ -eq "New-APSEntitlement/AppVisibility") -Or
            ($_ -eq "Update-APSEntitlement/AppVisibility")
        }
        {
            $v = "ALL","ASSOCIATED"
            break
        }

        # Amazon.AppStream.AuthenticationType
        {
            ($_ -eq "Disable-APSUser/AuthenticationType") -Or
            ($_ -eq "Enable-APSUser/AuthenticationType") -Or
            ($_ -eq "Get-APSSessionList/AuthenticationType") -Or
            ($_ -eq "Get-APSUser/AuthenticationType") -Or
            ($_ -eq "Get-APSUserStackAssociation/AuthenticationType") -Or
            ($_ -eq "New-APSUser/AuthenticationType") -Or
            ($_ -eq "Remove-APSUser/AuthenticationType")
        }
        {
            $v = "API","AWS_AD","SAML","USERPOOL"
            break
        }

        # Amazon.AppStream.CertificateBasedAuthStatus
        {
            ($_ -eq "New-APSDirectoryConfig/CertificateBasedAuthProperties_Status") -Or
            ($_ -eq "Update-APSDirectoryConfig/CertificateBasedAuthProperties_Status")
        }
        {
            $v = "DISABLED","ENABLED","ENABLED_NO_DIRECTORY_LOGIN_FALLBACK"
            break
        }

        # Amazon.AppStream.FleetType
        "New-APSFleet/FleetType"
        {
            $v = "ALWAYS_ON","ELASTIC","ON_DEMAND"
            break
        }

        # Amazon.AppStream.MessageAction
        "New-APSUser/MessageAction"
        {
            $v = "RESEND","SUPPRESS"
            break
        }

        # Amazon.AppStream.PackagingType
        "New-APSAppBlock/PackagingType"
        {
            $v = "APPSTREAM2","CUSTOM"
            break
        }

        # Amazon.AppStream.PlatformType
        {
            ($_ -eq "New-APSFleet/Platform") -Or
            ($_ -eq "Update-APSAppBlockBuilder/Platform") -Or
            ($_ -eq "Update-APSFleet/Platform")
        }
        {
            $v = "AMAZON_LINUX2","RHEL8","ROCKY_LINUX8","WINDOWS","WINDOWS_SERVER_2016","WINDOWS_SERVER_2019","WINDOWS_SERVER_2022"
            break
        }

        # Amazon.AppStream.PreferredProtocol
        {
            ($_ -eq "New-APSStack/StreamingExperienceSettings_PreferredProtocol") -Or
            ($_ -eq "Update-APSStack/StreamingExperienceSettings_PreferredProtocol")
        }
        {
            $v = "TCP","UDP"
            break
        }

        # Amazon.AppStream.StreamView
        {
            ($_ -eq "New-APSFleet/StreamView") -Or
            ($_ -eq "Update-APSFleet/StreamView")
        }
        {
            $v = "APP","DESKTOP"
            break
        }

        # Amazon.AppStream.ThemeState
        "Update-APSThemeForStack/State"
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.AppStream.ThemeStyling
        {
            ($_ -eq "New-APSThemeForStack/ThemeStyling") -Or
            ($_ -eq "Update-APSThemeForStack/ThemeStyling")
        }
        {
            $v = "BLUE","LIGHT_BLUE","PINK","RED"
            break
        }

        # Amazon.AppStream.VisibilityType
        "Get-APSImageList/Type"
        {
            $v = "PRIVATE","PUBLIC","SHARED"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$APS_map = @{
    "AppVisibility"=@("New-APSEntitlement","Update-APSEntitlement")
    "AuthenticationType"=@("Disable-APSUser","Enable-APSUser","Get-APSSessionList","Get-APSUser","Get-APSUserStackAssociation","New-APSUser","Remove-APSUser")
    "CertificateBasedAuthProperties_Status"=@("New-APSDirectoryConfig","Update-APSDirectoryConfig")
    "FleetType"=@("New-APSFleet")
    "MessageAction"=@("New-APSUser")
    "PackagingType"=@("New-APSAppBlock")
    "Platform"=@("New-APSAppBlockBuilder","New-APSFleet","Update-APSAppBlockBuilder","Update-APSFleet")
    "State"=@("Update-APSThemeForStack")
    "StreamingExperienceSettings_PreferredProtocol"=@("New-APSStack","Update-APSStack")
    "StreamView"=@("New-APSFleet","Update-APSFleet")
    "ThemeStyling"=@("New-APSThemeForStack","Update-APSThemeForStack")
    "Type"=@("Get-APSImageList")
}

_awsArgumentCompleterRegistration $APS_Completers $APS_map

$APS_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.APS.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$APS_SelectMap = @{
    "Select"=@("Add-APSAppBlockBuilderAppBlock",
               "Register-APSApplicationFleet",
               "Add-APSApplicationToEntitlement",
               "Register-APSFleet",
               "Add-APSSoftwareToImageBuilder",
               "Register-APSUserStackBatch",
               "Unregister-APSUserStackBatch",
               "Copy-APSImage",
               "New-APSAppBlock",
               "New-APSAppBlockBuilder",
               "New-APSAppBlockBuilderStreamingURL",
               "New-APSApplication",
               "New-APSDirectoryConfig",
               "New-APSEntitlement",
               "New-APSFleet",
               "New-APSImageBuilder",
               "New-APSImageBuilderStreamingURL",
               "New-APSStack",
               "New-APSStreamingURL",
               "New-APSThemeForStack",
               "New-APSUpdatedImage",
               "New-APSUsageReportSubscription",
               "New-APSUser",
               "Remove-APSAppBlock",
               "Remove-APSAppBlockBuilder",
               "Remove-APSApplication",
               "Remove-APSDirectoryConfig",
               "Remove-APSEntitlement",
               "Remove-APSFleet",
               "Remove-APSImage",
               "Remove-APSImageBuilder",
               "Remove-APSImagePermission",
               "Remove-APSStack",
               "Remove-APSThemeForStack",
               "Remove-APSUsageReportSubscription",
               "Remove-APSUser",
               "Get-APSAppBlockBuilderAppBlockAssociation",
               "Get-APSAppBlockBuilder",
               "Get-APSAppBlock",
               "Get-APSApplicationFleetAssociation",
               "Get-APSApplication",
               "Get-APSAppLicenseUsage",
               "Get-APSDirectoryConfigList",
               "Get-APSEntitlement",
               "Get-APSFleetList",
               "Get-APSImageBuilderList",
               "Get-APSImagePermission",
               "Get-APSImageList",
               "Get-APSSessionList",
               "Get-APSSoftwareAssociation",
               "Get-APSStackList",
               "Get-APSThemeForStack",
               "Get-APSUsageReportSubscription",
               "Get-APSUser",
               "Get-APSUserStackAssociation",
               "Disable-APSUser",
               "Remove-APSAppBlockBuilderAppBlock",
               "Unregister-APSApplicationFleet",
               "Remove-APSApplicationFromEntitlement",
               "Unregister-APSFleet",
               "Remove-APSSoftwareFromImageBuilder",
               "Enable-APSUser",
               "Revoke-APSSession",
               "Get-APSAssociatedFleetList",
               "Get-APSAssociatedStackList",
               "Get-APSEntitledApplicationList",
               "Get-APSTagsForResourceList",
               "Start-APSAppBlockBuilder",
               "Start-APSFleet",
               "Start-APSImageBuilder",
               "Start-APSSoftwareDeploymentToImageBuilder",
               "Stop-APSAppBlockBuilder",
               "Stop-APSFleet",
               "Stop-APSImageBuilder",
               "Add-APSResourceTag",
               "Remove-APSResourceTag",
               "Update-APSAppBlockBuilder",
               "Update-APSApplication",
               "Update-APSDirectoryConfig",
               "Update-APSEntitlement",
               "Update-APSFleet",
               "Update-APSImagePermission",
               "Update-APSStack",
               "Update-APSThemeForStack")
}

_awsArgumentCompleterRegistration $APS_SelectCompleters $APS_SelectMap
# Argument completions for service AWS AppSync


$ASYN_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.AppSync.ApiCacheType
        {
            ($_ -eq "New-ASYNApiCache/Type") -Or
            ($_ -eq "Update-ASYNApiCache/Type")
        }
        {
            $v = "LARGE","LARGE_12X","LARGE_2X","LARGE_4X","LARGE_8X","MEDIUM","R4_2XLARGE","R4_4XLARGE","R4_8XLARGE","R4_LARGE","R4_XLARGE","SMALL","T2_MEDIUM","T2_SMALL","XLARGE"
            break
        }

        # Amazon.AppSync.ApiCachingBehavior
        {
            ($_ -eq "New-ASYNApiCache/ApiCachingBehavior") -Or
            ($_ -eq "Update-ASYNApiCache/ApiCachingBehavior")
        }
        {
            $v = "FULL_REQUEST_CACHING","OPERATION_LEVEL_CACHING","PER_RESOLVER_CACHING"
            break
        }

        # Amazon.AppSync.AuthenticationType
        {
            ($_ -eq "New-ASYNGraphqlApi/AuthenticationType") -Or
            ($_ -eq "Update-ASYNGraphqlApi/AuthenticationType")
        }
        {
            $v = "AMAZON_COGNITO_USER_POOLS","API_KEY","AWS_IAM","AWS_LAMBDA","OPENID_CONNECT"
            break
        }

        # Amazon.AppSync.CacheHealthMetricsConfig
        {
            ($_ -eq "New-ASYNApiCache/HealthMetricsConfig") -Or
            ($_ -eq "Update-ASYNApiCache/HealthMetricsConfig")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.AppSync.ConflictDetectionType
        {
            ($_ -eq "New-ASYNFunction/SyncConfig_ConflictDetection") -Or
            ($_ -eq "New-ASYNResolver/SyncConfig_ConflictDetection") -Or
            ($_ -eq "Update-ASYNFunction/SyncConfig_ConflictDetection") -Or
            ($_ -eq "Update-ASYNResolver/SyncConfig_ConflictDetection")
        }
        {
            $v = "NONE","VERSION"
            break
        }

        # Amazon.AppSync.ConflictHandlerType
        {
            ($_ -eq "New-ASYNFunction/SyncConfig_ConflictHandler") -Or
            ($_ -eq "New-ASYNResolver/SyncConfig_ConflictHandler") -Or
            ($_ -eq "Update-ASYNFunction/SyncConfig_ConflictHandler") -Or
            ($_ -eq "Update-ASYNResolver/SyncConfig_ConflictHandler")
        }
        {
            $v = "AUTOMERGE","LAMBDA","NONE","OPTIMISTIC_CONCURRENCY"
            break
        }

        # Amazon.AppSync.DataSourceLevelMetricsBehavior
        {
            ($_ -eq "New-ASYNGraphqlApi/EnhancedMetricsConfig_DataSourceLevelMetricsBehavior") -Or
            ($_ -eq "Update-ASYNGraphqlApi/EnhancedMetricsConfig_DataSourceLevelMetricsBehavior")
        }
        {
            $v = "FULL_REQUEST_DATA_SOURCE_METRICS","PER_DATA_SOURCE_METRICS"
            break
        }

        # Amazon.AppSync.DataSourceLevelMetricsConfig
        {
            ($_ -eq "New-ASYNDataSource/MetricsConfig") -Or
            ($_ -eq "Update-ASYNDataSource/MetricsConfig")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.AppSync.DataSourceType
        {
            ($_ -eq "New-ASYNDataSource/Type") -Or
            ($_ -eq "Update-ASYNDataSource/Type")
        }
        {
            $v = "AMAZON_BEDROCK_RUNTIME","AMAZON_DYNAMODB","AMAZON_ELASTICSEARCH","AMAZON_EVENTBRIDGE","AMAZON_OPENSEARCH_SERVICE","AWS_LAMBDA","HTTP","NONE","RELATIONAL_DATABASE"
            break
        }

        # Amazon.AppSync.EventLogLevel
        {
            ($_ -eq "New-ASYNApi/LogConfig_LogLevel") -Or
            ($_ -eq "Update-ASYNApi/LogConfig_LogLevel")
        }
        {
            $v = "ALL","DEBUG","ERROR","INFO","NONE"
            break
        }

        # Amazon.AppSync.FieldLogLevel
        {
            ($_ -eq "New-ASYNGraphqlApi/LogConfig_FieldLogLevel") -Or
            ($_ -eq "Update-ASYNGraphqlApi/LogConfig_FieldLogLevel")
        }
        {
            $v = "ALL","DEBUG","ERROR","INFO","NONE"
            break
        }

        # Amazon.AppSync.GraphQLApiIntrospectionConfig
        {
            ($_ -eq "New-ASYNGraphqlApi/IntrospectionConfig") -Or
            ($_ -eq "Update-ASYNGraphqlApi/IntrospectionConfig")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.AppSync.GraphQLApiType
        {
            ($_ -eq "Get-ASYNGraphqlApiList/ApiType") -Or
            ($_ -eq "New-ASYNGraphqlApi/ApiType")
        }
        {
            $v = "GRAPHQL","MERGED"
            break
        }

        # Amazon.AppSync.GraphQLApiVisibility
        "New-ASYNGraphqlApi/Visibility"
        {
            $v = "GLOBAL","PRIVATE"
            break
        }

        # Amazon.AppSync.HandlerBehavior
        {
            ($_ -eq "New-ASYNChannelNamespace/OnPublish_Behavior") -Or
            ($_ -eq "Update-ASYNChannelNamespace/OnPublish_Behavior") -Or
            ($_ -eq "New-ASYNChannelNamespace/OnSubscribe_Behavior") -Or
            ($_ -eq "Update-ASYNChannelNamespace/OnSubscribe_Behavior")
        }
        {
            $v = "CODE","DIRECT"
            break
        }

        # Amazon.AppSync.InvokeType
        {
            ($_ -eq "New-ASYNChannelNamespace/OnPublish_LambdaConfig_InvokeType") -Or
            ($_ -eq "Update-ASYNChannelNamespace/OnPublish_LambdaConfig_InvokeType") -Or
            ($_ -eq "New-ASYNChannelNamespace/OnSubscribe_LambdaConfig_InvokeType") -Or
            ($_ -eq "Update-ASYNChannelNamespace/OnSubscribe_LambdaConfig_InvokeType")
        }
        {
            $v = "EVENT","REQUEST_RESPONSE"
            break
        }

        # Amazon.AppSync.MergeType
        {
            ($_ -eq "Start-ASYNMergedGraphqlApi/SourceApiAssociationConfig_MergeType") -Or
            ($_ -eq "Start-ASYNSourceGraphqlApi/SourceApiAssociationConfig_MergeType") -Or
            ($_ -eq "Update-ASYNSourceApiAssociation/SourceApiAssociationConfig_MergeType")
        }
        {
            $v = "AUTO_MERGE","MANUAL_MERGE"
            break
        }

        # Amazon.AppSync.OperationLevelMetricsConfig
        {
            ($_ -eq "New-ASYNGraphqlApi/EnhancedMetricsConfig_OperationLevelMetricsConfig") -Or
            ($_ -eq "Update-ASYNGraphqlApi/EnhancedMetricsConfig_OperationLevelMetricsConfig")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.AppSync.OutputType
        "Get-ASYNIntrospectionSchema/Format"
        {
            $v = "JSON","SDL"
            break
        }

        # Amazon.AppSync.Ownership
        "Get-ASYNGraphqlApiList/Owner"
        {
            $v = "CURRENT_ACCOUNT","OTHER_ACCOUNTS"
            break
        }

        # Amazon.AppSync.RelationalDatabaseSourceType
        {
            ($_ -eq "New-ASYNDataSource/RelationalDatabaseConfig_RelationalDatabaseSourceType") -Or
            ($_ -eq "Update-ASYNDataSource/RelationalDatabaseConfig_RelationalDatabaseSourceType")
        }
        {
            $v = "RDS_HTTP_ENDPOINT"
            break
        }

        # Amazon.AppSync.ResolverKind
        {
            ($_ -eq "New-ASYNResolver/Kind") -Or
            ($_ -eq "Update-ASYNResolver/Kind")
        }
        {
            $v = "PIPELINE","UNIT"
            break
        }

        # Amazon.AppSync.ResolverLevelMetricsBehavior
        {
            ($_ -eq "New-ASYNGraphqlApi/EnhancedMetricsConfig_ResolverLevelMetricsBehavior") -Or
            ($_ -eq "Update-ASYNGraphqlApi/EnhancedMetricsConfig_ResolverLevelMetricsBehavior")
        }
        {
            $v = "FULL_REQUEST_RESOLVER_METRICS","PER_RESOLVER_METRICS"
            break
        }

        # Amazon.AppSync.ResolverLevelMetricsConfig
        {
            ($_ -eq "New-ASYNResolver/MetricsConfig") -Or
            ($_ -eq "Update-ASYNResolver/MetricsConfig")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.AppSync.RuntimeName
        {
            ($_ -eq "New-ASYNFunction/Runtime_Name") -Or
            ($_ -eq "New-ASYNResolver/Runtime_Name") -Or
            ($_ -eq "Test-ASYNCode/Runtime_Name") -Or
            ($_ -eq "Update-ASYNFunction/Runtime_Name") -Or
            ($_ -eq "Update-ASYNResolver/Runtime_Name")
        }
        {
            $v = "APPSYNC_JS"
            break
        }

        # Amazon.AppSync.TypeDefinitionFormat
        {
            ($_ -eq "Get-ASYNType/Format") -Or
            ($_ -eq "Get-ASYNTypeList/Format") -Or
            ($_ -eq "Get-ASYNTypesByAssociationList/Format") -Or
            ($_ -eq "New-ASYNType/Format") -Or
            ($_ -eq "Update-ASYNType/Format")
        }
        {
            $v = "JSON","SDL"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ASYN_map = @{
    "ApiCachingBehavior"=@("New-ASYNApiCache","Update-ASYNApiCache")
    "ApiType"=@("Get-ASYNGraphqlApiList","New-ASYNGraphqlApi")
    "AuthenticationType"=@("New-ASYNGraphqlApi","Update-ASYNGraphqlApi")
    "EnhancedMetricsConfig_DataSourceLevelMetricsBehavior"=@("New-ASYNGraphqlApi","Update-ASYNGraphqlApi")
    "EnhancedMetricsConfig_OperationLevelMetricsConfig"=@("New-ASYNGraphqlApi","Update-ASYNGraphqlApi")
    "EnhancedMetricsConfig_ResolverLevelMetricsBehavior"=@("New-ASYNGraphqlApi","Update-ASYNGraphqlApi")
    "Format"=@("Get-ASYNIntrospectionSchema","Get-ASYNType","Get-ASYNTypeList","Get-ASYNTypesByAssociationList","New-ASYNType","Update-ASYNType")
    "HealthMetricsConfig"=@("New-ASYNApiCache","Update-ASYNApiCache")
    "IntrospectionConfig"=@("New-ASYNGraphqlApi","Update-ASYNGraphqlApi")
    "Kind"=@("New-ASYNResolver","Update-ASYNResolver")
    "LogConfig_FieldLogLevel"=@("New-ASYNGraphqlApi","Update-ASYNGraphqlApi")
    "LogConfig_LogLevel"=@("New-ASYNApi","Update-ASYNApi")
    "MetricsConfig"=@("New-ASYNDataSource","New-ASYNResolver","Update-ASYNDataSource","Update-ASYNResolver")
    "OnPublish_Behavior"=@("New-ASYNChannelNamespace","Update-ASYNChannelNamespace")
    "OnPublish_LambdaConfig_InvokeType"=@("New-ASYNChannelNamespace","Update-ASYNChannelNamespace")
    "OnSubscribe_Behavior"=@("New-ASYNChannelNamespace","Update-ASYNChannelNamespace")
    "OnSubscribe_LambdaConfig_InvokeType"=@("New-ASYNChannelNamespace","Update-ASYNChannelNamespace")
    "Owner"=@("Get-ASYNGraphqlApiList")
    "RelationalDatabaseConfig_RelationalDatabaseSourceType"=@("New-ASYNDataSource","Update-ASYNDataSource")
    "Runtime_Name"=@("New-ASYNFunction","New-ASYNResolver","Test-ASYNCode","Update-ASYNFunction","Update-ASYNResolver")
    "SourceApiAssociationConfig_MergeType"=@("Start-ASYNMergedGraphqlApi","Start-ASYNSourceGraphqlApi","Update-ASYNSourceApiAssociation")
    "SyncConfig_ConflictDetection"=@("New-ASYNFunction","New-ASYNResolver","Update-ASYNFunction","Update-ASYNResolver")
    "SyncConfig_ConflictHandler"=@("New-ASYNFunction","New-ASYNResolver","Update-ASYNFunction","Update-ASYNResolver")
    "Type"=@("New-ASYNApiCache","New-ASYNDataSource","Update-ASYNApiCache","Update-ASYNDataSource")
    "Visibility"=@("New-ASYNGraphqlApi")
}

_awsArgumentCompleterRegistration $ASYN_Completers $ASYN_map

$ASYN_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.ASYN.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ASYN_SelectMap = @{
    "Select"=@("Start-ASYNApiAssociation",
               "Start-ASYNMergedGraphqlApi",
               "Start-ASYNSourceGraphqlApi",
               "New-ASYNApi",
               "New-ASYNApiCache",
               "New-ASYNApiKey",
               "New-ASYNChannelNamespace",
               "New-ASYNDataSource",
               "New-ASYNDomainName",
               "New-ASYNFunction",
               "New-ASYNGraphqlApi",
               "New-ASYNResolver",
               "New-ASYNType",
               "Remove-ASYNApi",
               "Remove-ASYNApiCache",
               "Remove-ASYNApiKey",
               "Remove-ASYNChannelNamespace",
               "Remove-ASYNDataSource",
               "Remove-ASYNDomainName",
               "Remove-ASYNFunction",
               "Remove-ASYNGraphqlApi",
               "Remove-ASYNResolver",
               "Remove-ASYNType",
               "Stop-ASYNApiAssociation",
               "Stop-ASYNMergedGraphqlApi",
               "Stop-ASYNSourceGraphqlApi",
               "Test-ASYNCode",
               "Test-ASYNMappingTemplate",
               "Clear-ASYNApiCache",
               "Get-ASYNApi",
               "Get-ASYNApiAssociation",
               "Get-ASYNApiCache",
               "Get-ASYNChannelNamespace",
               "Get-ASYNDataSource",
               "Get-ASYNDataSourceIntrospection",
               "Get-ASYNDomainName",
               "Get-ASYNFunction",
               "Get-ASYNGraphqlApi",
               "Get-ASYNGraphqlApiEnvironmentVariable",
               "Get-ASYNIntrospectionSchema",
               "Get-ASYNResolver",
               "Get-ASYNSchemaCreationStatus",
               "Get-ASYNSourceApiAssociation",
               "Get-ASYNType",
               "Get-ASYNApiKeyList",
               "Get-ASYNApiList",
               "Get-ASYNChannelNamespaceList",
               "Get-ASYNDataSourceList",
               "Get-ASYNDomainNameList",
               "Get-ASYNFunctionList",
               "Get-ASYNGraphqlApiList",
               "Get-ASYNResolverList",
               "Get-ASYNResolverListByFunction",
               "Get-ASYNSourceApiAssociationList",
               "Get-ASYNResourceTag",
               "Get-ASYNTypeList",
               "Get-ASYNTypesByAssociationList",
               "Write-ASYNGraphqlApiEnvironmentVariable",
               "Start-ASYNDataSourceIntrospection",
               "Start-ASYNSchemaCreation",
               "Start-ASYNSchemaMerge",
               "Add-ASYNResourceTag",
               "Remove-ASYNResourceTag",
               "Update-ASYNApi",
               "Update-ASYNApiCache",
               "Update-ASYNApiKey",
               "Update-ASYNChannelNamespace",
               "Update-ASYNDataSource",
               "Update-ASYNDomainName",
               "Update-ASYNFunction",
               "Update-ASYNGraphqlApi",
               "Update-ASYNResolver",
               "Update-ASYNSourceApiAssociation",
               "Update-ASYNType")
}

_awsArgumentCompleterRegistration $ASYN_SelectCompleters $ASYN_SelectMap
# Argument completions for service Amazon Prometheus Service


$PROM_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.PROM.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$PROM_SelectMap = @{
    "Select"=@("New-PROMAlertManagerDefinition",
               "New-PROMAnomalyDetector",
               "New-PROMLoggingConfiguration",
               "New-PROMQueryLoggingConfiguration",
               "New-PROMRuleGroupsNamespace",
               "New-PROMScraper",
               "New-PROMWorkspace",
               "Remove-PROMAlertManagerDefinition",
               "Remove-PROMAnomalyDetector",
               "Remove-PROMLoggingConfiguration",
               "Remove-PROMQueryLoggingConfiguration",
               "Remove-PROMResourcePolicy",
               "Remove-PROMRuleGroupsNamespace",
               "Remove-PROMScraper",
               "Remove-PROMScraperLoggingConfiguration",
               "Remove-PROMWorkspace",
               "Get-PROMAlertManagerDefinition",
               "Get-PROMAnomalyDetector",
               "Get-PROMLoggingConfiguration",
               "Get-PROMQueryLoggingConfiguration",
               "Get-PROMResourcePolicy",
               "Get-PROMRuleGroupsNamespace",
               "Get-PROMScraper",
               "Get-PROMScraperLoggingConfiguration",
               "Get-PROMWorkspace",
               "Get-PROMWorkspaceConfiguration",
               "Get-PROMDefaultScraperConfiguration",
               "Get-PROMAnomalyDetectorList",
               "Get-PROMRuleGroupsNamespaceList",
               "Get-PROMScraperList",
               "Get-PROMResourceTag",
               "Get-PROMWorkspaceList",
               "Write-PROMAlertManagerDefinition",
               "Write-PROMAnomalyDetector",
               "Write-PROMResourcePolicy",
               "Write-PROMRuleGroupsNamespace",
               "Add-PROMResourceTag",
               "Remove-PROMResourceTag",
               "Update-PROMLoggingConfiguration",
               "Update-PROMQueryLoggingConfiguration",
               "Update-PROMScraper",
               "Update-PROMScraperLoggingConfiguration",
               "Update-PROMWorkspaceAlias",
               "Update-PROMWorkspaceConfiguration")
}

_awsArgumentCompleterRegistration $PROM_SelectCompleters $PROM_SelectMap
# Argument completions for service ARC - Region switch


$ARC_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ARCRegionswitch.Approval
        "Approve-ARCPlanExecutionStep/Approval"
        {
            $v = "approve","decline"
            break
        }

        # Amazon.ARCRegionswitch.ExecutionAction
        "Start-ARCPlanExecution/Action"
        {
            $v = "activate","deactivate"
            break
        }

        # Amazon.ARCRegionswitch.ExecutionMode
        "Start-ARCPlanExecution/Mode"
        {
            $v = "graceful","ungraceful"
            break
        }

        # Amazon.ARCRegionswitch.ExecutionState
        "Get-ARCPlanExecutionList/State"
        {
            $v = "canceled","completed","completedMonitoringApplicationHealth","completedWithExceptions","failed","inProgress","pausedByFailedStep","pausedByOperator","pending","pendingManualApproval","planExecutionTimedOut"
            break
        }

        # Amazon.ARCRegionswitch.RecoveryApproach
        "New-ARCPlan/RecoveryApproach"
        {
            $v = "activeActive","activePassive"
            break
        }

        # Amazon.ARCRegionswitch.UpdatePlanExecutionAction
        "Update-ARCPlanExecution/Action"
        {
            $v = "pause","resume","switchToGraceful","switchToUngraceful"
            break
        }

        # Amazon.ARCRegionswitch.UpdatePlanExecutionStepAction
        "Update-ARCPlanExecutionStep/ActionToTake"
        {
            $v = "skip","switchToUngraceful"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ARC_map = @{
    "Action"=@("Start-ARCPlanExecution","Update-ARCPlanExecution")
    "ActionToTake"=@("Update-ARCPlanExecutionStep")
    "Approval"=@("Approve-ARCPlanExecutionStep")
    "Mode"=@("Start-ARCPlanExecution")
    "RecoveryApproach"=@("New-ARCPlan")
    "State"=@("Get-ARCPlanExecutionList")
}

_awsArgumentCompleterRegistration $ARC_Completers $ARC_map

$ARC_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.ARC.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ARC_SelectMap = @{
    "Select"=@("Approve-ARCPlanExecutionStep",
               "Stop-ARCPlanExecution",
               "New-ARCPlan",
               "Remove-ARCPlan",
               "Get-ARCPlan",
               "Get-ARCPlanEvaluationStatus",
               "Get-ARCPlanExecution",
               "Get-ARCPlanInRegion",
               "Get-ARCPlanExecutionEventList",
               "Get-ARCPlanExecutionList",
               "Get-ARCPlanList",
               "Get-ARCPlansInRegionList",
               "Get-ARCRoute53HealthCheckList",
               "Get-ARCResourceTag",
               "Start-ARCPlanExecution",
               "Add-ARCResourceTag",
               "Remove-ARCResourceTag",
               "Update-ARCPlan",
               "Update-ARCPlanExecution",
               "Update-ARCPlanExecutionStep")
}

_awsArgumentCompleterRegistration $ARC_SelectCompleters $ARC_SelectMap
# Argument completions for service AWS ARC - Zonal Shift


$AZS_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ARCZonalShift.AutoshiftExecutionStatus
        "Get-AZSAutoshiftList/Status"
        {
            $v = "ACTIVE","COMPLETED"
            break
        }

        # Amazon.ARCZonalShift.AutoshiftObserverNotificationStatus
        "Update-AZSAutoshiftObserverNotificationStatus/Status"
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.ARCZonalShift.ZonalAutoshiftStatus
        "Update-AZSZonalAutoshiftConfiguration/ZonalAutoshiftStatus"
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.ARCZonalShift.ZonalShiftStatus
        "Get-AZSZonalShiftList/Status"
        {
            $v = "ACTIVE","CANCELED","EXPIRED"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AZS_map = @{
    "Status"=@("Get-AZSAutoshiftList","Get-AZSZonalShiftList","Update-AZSAutoshiftObserverNotificationStatus")
    "ZonalAutoshiftStatus"=@("Update-AZSZonalAutoshiftConfiguration")
}

_awsArgumentCompleterRegistration $AZS_Completers $AZS_map

$AZS_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.AZS.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AZS_SelectMap = @{
    "Select"=@("Stop-AZSPracticeRun",
               "Stop-AZSZonalShift",
               "New-AZSPracticeRunConfiguration",
               "Remove-AZSPracticeRunConfiguration",
               "Get-AZSAutoshiftObserverNotificationStatus",
               "Get-AZSManagedResource",
               "Get-AZSAutoshiftList",
               "Get-AZSManagedResourceList",
               "Get-AZSZonalShiftList",
               "Start-AZSPracticeRun",
               "Start-AZSZonalShift",
               "Update-AZSAutoshiftObserverNotificationStatus",
               "Update-AZSPracticeRunConfiguration",
               "Update-AZSZonalAutoshiftConfiguration",
               "Update-AZSZonalShift")
}

_awsArgumentCompleterRegistration $AZS_SelectCompleters $AZS_SelectMap
# Argument completions for service AWS Artifact


$ART_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.Artifact.NotificationSubscriptionStatus
        "Write-ARTAccountSetting/NotificationSubscriptionStatus"
        {
            $v = "NOT_SUBSCRIBED","SUBSCRIBED"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ART_map = @{
    "NotificationSubscriptionStatus"=@("Write-ARTAccountSetting")
}

_awsArgumentCompleterRegistration $ART_Completers $ART_map

$ART_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.ART.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ART_SelectMap = @{
    "Select"=@("Get-ARTAccountSetting",
               "Get-ARTReport",
               "Get-ARTReportMetadata",
               "Get-ARTTermForReport",
               "Get-ARTCustomerAgreementList",
               "Get-ARTReportList",
               "Write-ARTAccountSetting")
}

_awsArgumentCompleterRegistration $ART_SelectCompleters $ART_SelectMap
# Argument completions for service Amazon Athena


$ATH_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.Athena.AuthenticationType
        {
            ($_ -eq "New-ATHWorkGroup/QueryResultsS3AccessGrantsConfiguration_AuthenticationType") -Or
            ($_ -eq "Update-ATHWorkGroup/QueryResultsS3AccessGrantsConfiguration_AuthenticationType")
        }
        {
            $v = "DIRECTORY_IDENTITY"
            break
        }

        # Amazon.Athena.CalculationExecutionState
        "Get-ATHCalculationExecutionList/StateFilter"
        {
            $v = "CANCELED","CANCELING","COMPLETED","CREATED","CREATING","FAILED","QUEUED","RUNNING"
            break
        }

        # Amazon.Athena.DataCatalogType
        {
            ($_ -eq "New-ATHDataCatalog/Type") -Or
            ($_ -eq "Update-ATHDataCatalog/Type")
        }
        {
            $v = "FEDERATED","GLUE","HIVE","LAMBDA"
            break
        }

        # Amazon.Athena.EncryptionOption
        {
            ($_ -eq "New-ATHWorkGroup/EncryptionConfiguration_EncryptionOption") -Or
            ($_ -eq "Start-ATHQueryExecution/EncryptionConfiguration_EncryptionOption") -Or
            ($_ -eq "Update-ATHWorkGroup/EncryptionConfiguration_EncryptionOption")
        }
        {
            $v = "CSE_KMS","SSE_KMS","SSE_S3"
            break
        }

        # Amazon.Athena.ExecutorState
        "Get-ATHExecutorList/ExecutorStateFilter"
        {
            $v = "CREATED","CREATING","FAILED","REGISTERED","TERMINATED","TERMINATING"
            break
        }

        # Amazon.Athena.NotebookType
        {
            ($_ -eq "Import-ATHNotebook/Type") -Or
            ($_ -eq "Update-ATHNotebook/Type")
        }
        {
            $v = "IPYNB"
            break
        }

        # Amazon.Athena.QueryResultType
        "Get-ATHQueryResult/QueryResultType"
        {
            $v = "DATA_MANIFEST","DATA_ROWS"
            break
        }

        # Amazon.Athena.S3AclOption
        {
            ($_ -eq "New-ATHWorkGroup/AclConfiguration_S3AclOption") -Or
            ($_ -eq "Start-ATHQueryExecution/AclConfiguration_S3AclOption") -Or
            ($_ -eq "Update-ATHWorkGroup/AclConfiguration_S3AclOption")
        }
        {
            $v = "BUCKET_OWNER_FULL_CONTROL"
            break
        }

        # Amazon.Athena.SessionState
        "Get-ATHSessionList/StateFilter"
        {
            $v = "BUSY","CREATED","CREATING","DEGRADED","FAILED","IDLE","TERMINATED","TERMINATING"
            break
        }

        # Amazon.Athena.WorkGroupState
        "Update-ATHWorkGroup/State"
        {
            $v = "DISABLED","ENABLED"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ATH_map = @{
    "AclConfiguration_S3AclOption"=@("New-ATHWorkGroup","Start-ATHQueryExecution","Update-ATHWorkGroup")
    "EncryptionConfiguration_EncryptionOption"=@("New-ATHWorkGroup","Start-ATHQueryExecution","Update-ATHWorkGroup")
    "ExecutorStateFilter"=@("Get-ATHExecutorList")
    "QueryResultsS3AccessGrantsConfiguration_AuthenticationType"=@("New-ATHWorkGroup","Update-ATHWorkGroup")
    "QueryResultType"=@("Get-ATHQueryResult")
    "State"=@("Update-ATHWorkGroup")
    "StateFilter"=@("Get-ATHCalculationExecutionList","Get-ATHSessionList")
    "Type"=@("Import-ATHNotebook","New-ATHDataCatalog","Update-ATHDataCatalog","Update-ATHNotebook")
}

_awsArgumentCompleterRegistration $ATH_Completers $ATH_map

$ATH_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.ATH.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ATH_SelectMap = @{
    "Select"=@("Get-ATHNamedQueryBatch",
               "Get-ATHBatchPreparedStatement",
               "Get-ATHQueryExecutionBatch",
               "Stop-ATHCapacityReservation",
               "New-ATHCapacityReservation",
               "New-ATHDataCatalog",
               "New-ATHNamedQuery",
               "New-ATHNotebook",
               "New-ATHPreparedStatement",
               "New-ATHPresignedNotebookUrl",
               "New-ATHWorkGroup",
               "Remove-ATHCapacityReservation",
               "Remove-ATHDataCatalog",
               "Remove-ATHNamedQuery",
               "Remove-ATHNotebook",
               "Remove-ATHPreparedStatement",
               "Remove-ATHWorkGroup",
               "Export-ATHNotebook",
               "Get-ATHCalculationExecution",
               "Get-ATHCalculationExecutionCode",
               "Get-ATHCalculationExecutionStatus",
               "Get-ATHCapacityAssignmentConfiguration",
               "Get-ATHCapacityReservation",
               "Get-ATHDatabase",
               "Get-ATHDataCatalog",
               "Get-ATHNamedQuery",
               "Get-ATHNotebookMetadata",
               "Get-ATHPreparedStatement",
               "Get-ATHQueryExecution",
               "Get-ATHQueryResult",
               "Get-ATHQueryRuntimeStatistic",
               "Get-ATHSession",
               "Get-ATHSessionStatus",
               "Get-ATHTableMetadata",
               "Get-ATHWorkGroup",
               "Import-ATHNotebook",
               "Get-ATHApplicationDPUSizeList",
               "Get-ATHCalculationExecutionList",
               "Get-ATHCapacityReservationList",
               "Get-ATHDatabasisList",
               "Get-ATHDataCatalogList",
               "Get-ATHEngineVersionList",
               "Get-ATHExecutorList",
               "Get-ATHNamedQueryList",
               "Get-ATHNotebookMetadataList",
               "Get-ATHNotebookSessionList",
               "Get-ATHPreparedStatementList",
               "Get-ATHQueryExecutionList",
               "Get-ATHSessionList",
               "Get-ATHTableMetadataList",
               "Get-ATHResourceTag",
               "Get-ATHWorkGroupList",
               "Write-ATHCapacityAssignmentConfiguration",
               "Start-ATHCalculationExecution",
               "Start-ATHQueryExecution",
               "Start-ATHSession",
               "Stop-ATHCalculationExecution",
               "Stop-ATHQueryExecution",
               "Add-ATHResourceTag",
               "Remove-ATHSession",
               "Remove-ATHResourceTag",
               "Update-ATHCapacityReservation",
               "Update-ATHDataCatalog",
               "Update-ATHNamedQuery",
               "Update-ATHNotebook",
               "Update-ATHNotebookMetadata",
               "Update-ATHPreparedStatement",
               "Update-ATHWorkGroup")
}

_awsArgumentCompleterRegistration $ATH_SelectCompleters $ATH_SelectMap
# Argument completions for service AWS Audit Manager


$AUDM_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.AuditManager.AssessmentReportDestinationType
        {
            ($_ -eq "Edit-AUDMAssessment/AssessmentReportsDestination_DestinationType") -Or
            ($_ -eq "New-AUDMAssessment/AssessmentReportsDestination_DestinationType") -Or
            ($_ -eq "Edit-AUDMSetting/DefaultAssessmentReportsDestination_DestinationType")
        }
        {
            $v = "S3"
            break
        }

        # Amazon.AuditManager.AssessmentStatus
        {
            ($_ -eq "Edit-AUDMAssessmentStatus/Status") -Or
            ($_ -eq "Get-AUDMAssessmentList/Status")
        }
        {
            $v = "ACTIVE","INACTIVE"
            break
        }

        # Amazon.AuditManager.ControlSetStatus
        "Edit-AUDMAssessmentControlSetStatus/Status"
        {
            $v = "ACTIVE","REVIEWED","UNDER_REVIEW"
            break
        }

        # Amazon.AuditManager.ControlStatus
        "Edit-AUDMAssessmentControl/ControlStatus"
        {
            $v = "INACTIVE","REVIEWED","UNDER_REVIEW"
            break
        }

        # Amazon.AuditManager.ControlType
        "Get-AUDMControlList/ControlType"
        {
            $v = "Core","Custom","Standard"
            break
        }

        # Amazon.AuditManager.DataSourceType
        "Get-AUDMKeywordForDataSourceList/Source"
        {
            $v = "AWS_API_Call","AWS_Cloudtrail","AWS_Config","AWS_Security_Hub","MANUAL"
            break
        }

        # Amazon.AuditManager.DeleteResources
        "Edit-AUDMSetting/DeregistrationPolicy_DeleteResource"
        {
            $v = "ALL","DEFAULT"
            break
        }

        # Amazon.AuditManager.ExportDestinationType
        "Edit-AUDMSetting/DefaultExportDestination_DestinationType"
        {
            $v = "S3"
            break
        }

        # Amazon.AuditManager.FrameworkType
        "Get-AUDMAssessmentFrameworkList/FrameworkType"
        {
            $v = "Custom","Standard"
            break
        }

        # Amazon.AuditManager.SettingAttribute
        "Get-AUDMSetting/Attribute"
        {
            $v = "ALL","DEFAULT_ASSESSMENT_REPORTS_DESTINATION","DEFAULT_EXPORT_DESTINATION","DEFAULT_PROCESS_OWNERS","DEREGISTRATION_POLICY","EVIDENCE_FINDER_ENABLEMENT","IS_AWS_ORG_ENABLED","SNS_TOPIC"
            break
        }

        # Amazon.AuditManager.ShareRequestAction
        "Update-AUDMAssessmentFrameworkShare/Action"
        {
            $v = "ACCEPT","DECLINE","REVOKE"
            break
        }

        # Amazon.AuditManager.ShareRequestType
        {
            ($_ -eq "Get-AUDMAssessmentFrameworkShareRequestList/RequestType") -Or
            ($_ -eq "Remove-AUDMAssessmentFrameworkShare/RequestType") -Or
            ($_ -eq "Update-AUDMAssessmentFrameworkShare/RequestType")
        }
        {
            $v = "RECEIVED","SENT"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AUDM_map = @{
    "Action"=@("Update-AUDMAssessmentFrameworkShare")
    "AssessmentReportsDestination_DestinationType"=@("Edit-AUDMAssessment","New-AUDMAssessment")
    "Attribute"=@("Get-AUDMSetting")
    "ControlStatus"=@("Edit-AUDMAssessmentControl")
    "ControlType"=@("Get-AUDMControlList")
    "DefaultAssessmentReportsDestination_DestinationType"=@("Edit-AUDMSetting")
    "DefaultExportDestination_DestinationType"=@("Edit-AUDMSetting")
    "DeregistrationPolicy_DeleteResource"=@("Edit-AUDMSetting")
    "FrameworkType"=@("Get-AUDMAssessmentFrameworkList")
    "RequestType"=@("Get-AUDMAssessmentFrameworkShareRequestList","Remove-AUDMAssessmentFrameworkShare","Update-AUDMAssessmentFrameworkShare")
    "Source"=@("Get-AUDMKeywordForDataSourceList")
    "Status"=@("Edit-AUDMAssessmentControlSetStatus","Edit-AUDMAssessmentStatus","Get-AUDMAssessmentList")
}

_awsArgumentCompleterRegistration $AUDM_Completers $AUDM_map

$AUDM_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.AUDM.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AUDM_SelectMap = @{
    "Select"=@("Add-AUDMAssessmentReportEvidenceFolder",
               "Add-AUDMAssessmentReportEvidence",
               "New-AUDMCreateDelegationByAssessment",
               "Remove-AUDMDelegationByAssessment",
               "Remove-AUDMAssessmentReportEvidence",
               "Add-AUDMEvidenceToAssessmentControl",
               "New-AUDMAssessment",
               "New-AUDMAssessmentFramework",
               "New-AUDMAssessmentReport",
               "New-AUDMControl",
               "Remove-AUDMAssessment",
               "Remove-AUDMAssessmentFramework",
               "Remove-AUDMAssessmentFrameworkShare",
               "Remove-AUDMAssessmentReport",
               "Remove-AUDMControl",
               "Unregister-AUDMAccount",
               "Unregister-AUDMOrganizationAdminAccount",
               "Remove-AUDMAssessmentReportEvidenceFolder",
               "Get-AUDMAccountStatus",
               "Get-AUDMAssessment",
               "Get-AUDMAssessmentFramework",
               "Get-AUDMAssessmentReportUrl",
               "Get-AUDMChangeLog",
               "Get-AUDMControl",
               "Get-AUDMDelegation",
               "Get-AUDMEvidence",
               "Get-AUDMEvidenceByEvidenceFolder",
               "Get-AUDMEvidenceFileUploadUrl",
               "Get-AUDMEvidenceFolder",
               "Get-AUDMEvidenceFolderByAssessment",
               "Get-AUDMEvidenceFolderByAssessmentControl",
               "Get-AUDMInsight",
               "Get-AUDMInsightsByAssessment",
               "Get-AUDMOrganizationAdminAccount",
               "Get-AUDMServiceInScope",
               "Get-AUDMSetting",
               "Get-AUDMAssessmentControlInsightsByControlDomainList",
               "Get-AUDMAssessmentFrameworkList",
               "Get-AUDMAssessmentFrameworkShareRequestList",
               "Get-AUDMAssessmentReportList",
               "Get-AUDMAssessmentList",
               "Get-AUDMControlDomainInsightList",
               "Get-AUDMControlDomainInsightsByAssessmentList",
               "Get-AUDMControlInsightsByControlDomainList",
               "Get-AUDMControlList",
               "Get-AUDMKeywordForDataSourceList",
               "Get-AUDMNotificationList",
               "Get-AUDMResourceTagList",
               "Register-AUDMAccount",
               "Register-AUDMOrganizationAdminAccount",
               "Start-AUDMAssessmentFrameworkShare",
               "Add-AUDMResourceTag",
               "Remove-AUDMResourceTag",
               "Edit-AUDMAssessment",
               "Edit-AUDMAssessmentControl",
               "Edit-AUDMAssessmentControlSetStatus",
               "Edit-AUDMAssessmentFramework",
               "Update-AUDMAssessmentFrameworkShare",
               "Edit-AUDMAssessmentStatus",
               "Edit-AUDMControl",
               "Edit-AUDMSetting",
               "Confirm-AUDMAssessmentReportIntegrity")
}

_awsArgumentCompleterRegistration $AUDM_SelectCompleters $AUDM_SelectMap
# Argument completions for service AWS Auto Scaling Plans


$ASP_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.AutoScalingPlans.ForecastDataType
        "Get-ASPScalingPlanResourceForecastData/ForecastDataType"
        {
            $v = "CapacityForecast","LoadForecast","ScheduledActionMaxCapacity","ScheduledActionMinCapacity"
            break
        }

        # Amazon.AutoScalingPlans.ScalableDimension
        "Get-ASPScalingPlanResourceForecastData/ScalableDimension"
        {
            $v = "autoscaling:autoScalingGroup:DesiredCapacity","dynamodb:index:ReadCapacityUnits","dynamodb:index:WriteCapacityUnits","dynamodb:table:ReadCapacityUnits","dynamodb:table:WriteCapacityUnits","ec2:spot-fleet-request:TargetCapacity","ecs:service:DesiredCount","rds:cluster:ReadReplicaCount"
            break
        }

        # Amazon.AutoScalingPlans.ServiceNamespace
        "Get-ASPScalingPlanResourceForecastData/ServiceNamespace"
        {
            $v = "autoscaling","dynamodb","ec2","ecs","rds"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ASP_map = @{
    "ForecastDataType"=@("Get-ASPScalingPlanResourceForecastData")
    "ScalableDimension"=@("Get-ASPScalingPlanResourceForecastData")
    "ServiceNamespace"=@("Get-ASPScalingPlanResourceForecastData")
}

_awsArgumentCompleterRegistration $ASP_Completers $ASP_map

$ASP_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.ASP.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ASP_SelectMap = @{
    "Select"=@("New-ASPScalingPlan",
               "Remove-ASPScalingPlan",
               "Get-ASPScalingPlanResource",
               "Get-ASPScalingPlan",
               "Get-ASPScalingPlanResourceForecastData",
               "Update-ASPScalingPlan")
}

_awsArgumentCompleterRegistration $ASP_SelectCompleters $ASP_SelectMap
# Argument completions for service AWS Auto Scaling


$AS_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.AutoScaling.CapacityDistributionStrategy
        {
            ($_ -eq "New-ASAutoScalingGroup/AvailabilityZoneDistribution_CapacityDistributionStrategy") -Or
            ($_ -eq "Update-ASAutoScalingGroup/AvailabilityZoneDistribution_CapacityDistributionStrategy")
        }
        {
            $v = "balanced-best-effort","balanced-only"
            break
        }

        # Amazon.AutoScaling.CapacityReservationPreference
        {
            ($_ -eq "New-ASAutoScalingGroup/CapacityReservationSpecification_CapacityReservationPreference") -Or
            ($_ -eq "Update-ASAutoScalingGroup/CapacityReservationSpecification_CapacityReservationPreference")
        }
        {
            $v = "capacity-reservations-first","capacity-reservations-only","default","none"
            break
        }

        # Amazon.AutoScaling.ImpairedZoneHealthCheckBehavior
        {
            ($_ -eq "New-ASAutoScalingGroup/AvailabilityZoneImpairmentPolicy_ImpairedZoneHealthCheckBehavior") -Or
            ($_ -eq "Update-ASAutoScalingGroup/AvailabilityZoneImpairmentPolicy_ImpairedZoneHealthCheckBehavior")
        }
        {
            $v = "IgnoreUnhealthy","ReplaceUnhealthy"
            break
        }

        # Amazon.AutoScaling.InstanceMetadataEndpointState
        "New-ASLaunchConfiguration/MetadataOptions_HttpEndpoint"
        {
            $v = "disabled","enabled"
            break
        }

        # Amazon.AutoScaling.InstanceMetadataHttpTokensState
        "New-ASLaunchConfiguration/MetadataOptions_HttpToken"
        {
            $v = "optional","required"
            break
        }

        # Amazon.AutoScaling.MetricStatistic
        "Write-ASScalingPolicy/CustomizedMetricSpecification_Statistic"
        {
            $v = "Average","Maximum","Minimum","SampleCount","Sum"
            break
        }

        # Amazon.AutoScaling.MetricType
        "Write-ASScalingPolicy/PredefinedMetricSpecification_PredefinedMetricType"
        {
            $v = "ALBRequestCountPerTarget","ASGAverageCPUUtilization","ASGAverageNetworkIn","ASGAverageNetworkOut"
            break
        }

        # Amazon.AutoScaling.PredictiveScalingMaxCapacityBreachBehavior
        "Write-ASScalingPolicy/PredictiveScalingConfiguration_MaxCapacityBreachBehavior"
        {
            $v = "HonorMaxCapacity","IncreaseMaxCapacity"
            break
        }

        # Amazon.AutoScaling.PredictiveScalingMode
        "Write-ASScalingPolicy/PredictiveScalingConfiguration_Mode"
        {
            $v = "ForecastAndScale","ForecastOnly"
            break
        }

        # Amazon.AutoScaling.RefreshStrategy
        "Start-ASInstanceRefresh/Strategy"
        {
            $v = "Rolling"
            break
        }

        # Amazon.AutoScaling.ScaleInProtectedInstances
        "Start-ASInstanceRefresh/Preferences_ScaleInProtectedInstance"
        {
            $v = "Ignore","Refresh","Wait"
            break
        }

        # Amazon.AutoScaling.StandbyInstances
        "Start-ASInstanceRefresh/Preferences_StandbyInstance"
        {
            $v = "Ignore","Terminate","Wait"
            break
        }

        # Amazon.AutoScaling.WarmPoolState
        "Write-ASWarmPool/PoolState"
        {
            $v = "Hibernated","Running","Stopped"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AS_map = @{
    "AvailabilityZoneDistribution_CapacityDistributionStrategy"=@("New-ASAutoScalingGroup","Update-ASAutoScalingGroup")
    "AvailabilityZoneImpairmentPolicy_ImpairedZoneHealthCheckBehavior"=@("New-ASAutoScalingGroup","Update-ASAutoScalingGroup")
    "CapacityReservationSpecification_CapacityReservationPreference"=@("New-ASAutoScalingGroup","Update-ASAutoScalingGroup")
    "CustomizedMetricSpecification_Statistic"=@("Write-ASScalingPolicy")
    "MetadataOptions_HttpEndpoint"=@("New-ASLaunchConfiguration")
    "MetadataOptions_HttpToken"=@("New-ASLaunchConfiguration")
    "PoolState"=@("Write-ASWarmPool")
    "PredefinedMetricSpecification_PredefinedMetricType"=@("Write-ASScalingPolicy")
    "PredictiveScalingConfiguration_MaxCapacityBreachBehavior"=@("Write-ASScalingPolicy")
    "PredictiveScalingConfiguration_Mode"=@("Write-ASScalingPolicy")
    "Preferences_ScaleInProtectedInstance"=@("Start-ASInstanceRefresh")
    "Preferences_StandbyInstance"=@("Start-ASInstanceRefresh")
    "Strategy"=@("Start-ASInstanceRefresh")
}

_awsArgumentCompleterRegistration $AS_Completers $AS_map

$AS_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.AS.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AS_SelectMap = @{
    "Select"=@("Mount-ASInstance",
               "Add-ASLoadBalancer",
               "Add-ASLoadBalancerTargetGroup",
               "Add-ASTrafficSource",
               "Remove-ASScheduledActionBatch",
               "Set-ASScheduledUpdateGroupActionBatch",
               "Stop-ASInstanceRefresh",
               "Complete-ASLifecycleAction",
               "New-ASAutoScalingGroup",
               "New-ASLaunchConfiguration",
               "Set-ASTag",
               "Remove-ASAutoScalingGroup",
               "Remove-ASLaunchConfiguration",
               "Remove-ASLifecycleHook",
               "Remove-ASNotificationConfiguration",
               "Remove-ASPolicy",
               "Remove-ASScheduledAction",
               "Remove-ASTag",
               "Remove-ASWarmPool",
               "Get-ASAccountLimit",
               "Get-ASAdjustmentType",
               "Get-ASAutoScalingGroup",
               "Get-ASAutoScalingInstance",
               "Get-ASAutoScalingNotificationType",
               "Get-ASInstanceRefresh",
               "Get-ASLaunchConfiguration",
               "Get-ASLifecycleHook",
               "Get-ASLifecycleHookType",
               "Get-ASLoadBalancer",
               "Get-ASLoadBalancerTargetGroup",
               "Get-ASMetricCollectionType",
               "Get-ASNotificationConfiguration",
               "Get-ASPolicy",
               "Get-ASScalingActivity",
               "Get-ASScalingProcessType",
               "Get-ASScheduledAction",
               "Get-ASTag",
               "Get-ASTerminationPolicyType",
               "Get-ASTrafficSource",
               "Get-ASWarmPool",
               "Dismount-ASInstance",
               "Dismount-ASLoadBalancer",
               "Dismount-ASLoadBalancerTargetGroup",
               "Dismount-ASTrafficSource",
               "Disable-ASMetricsCollection",
               "Enable-ASMetricsCollection",
               "Enter-ASStandby",
               "Start-ASPolicy",
               "Exit-ASStandby",
               "Get-ASPredictiveScalingForecast",
               "Write-ASLifecycleHook",
               "Write-ASNotificationConfiguration",
               "Write-ASScalingPolicy",
               "Write-ASScheduledUpdateGroupAction",
               "Write-ASWarmPool",
               "Write-ASLifecycleActionHeartbeat",
               "Resume-ASProcess",
               "Undo-ASInstanceRefresh",
               "Set-ASDesiredCapacity",
               "Set-ASInstanceHealth",
               "Set-ASInstanceProtection",
               "Start-ASInstanceRefresh",
               "Suspend-ASProcess",
               "Stop-ASInstanceInAutoScalingGroup",
               "Update-ASAutoScalingGroup")
}

_awsArgumentCompleterRegistration $AS_SelectCompleters $AS_SelectMap
# Argument completions for service AWS Migration Hub


$MH_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.MigrationHub.ApplicationStatus
        "Send-MHApplicationStateNotification/Status"
        {
            $v = "COMPLETED","IN_PROGRESS","NOT_STARTED"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$MH_map = @{
    "Status"=@("Send-MHApplicationStateNotification")
}

_awsArgumentCompleterRegistration $MH_Completers $MH_map

$MH_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.MH.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$MH_SelectMap = @{
    "Select"=@("Add-MHCreatedArtifact",
               "Add-MHDiscoveredResource",
               "Add-MHSourceResource",
               "New-MHProgressUpdateStream",
               "Remove-MHProgressUpdateStream",
               "Get-MHApplicationState",
               "Get-MHMigrationTask",
               "Remove-MHCreatedArtifact",
               "Remove-MHDiscoveredResource",
               "Remove-MHSourceResource",
               "Import-MHMigrationTask",
               "Get-MHApplicationStateList",
               "Get-MHCreatedArtifactList",
               "Get-MHDiscoveredResourceList",
               "Get-MHMigrationTaskList",
               "Get-MHMigrationTaskUpdateList",
               "Get-MHProgressUpdateStream",
               "Get-MHSourceResourceList",
               "Send-MHApplicationStateNotification",
               "Send-MHMigrationTaskStateNotification",
               "Set-MHResourceAttribute")
}

_awsArgumentCompleterRegistration $MH_SelectCompleters $MH_SelectMap
# Argument completions for service AWS B2B Data Interchange


$B2BI_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.B2bi.CapabilityDirection
        {
            ($_ -eq "New-B2BICapability/Edi_CapabilityDirection") -Or
            ($_ -eq "Update-B2BICapability/Edi_CapabilityDirection")
        }
        {
            $v = "INBOUND","OUTBOUND"
            break
        }

        # Amazon.B2bi.CapabilityType
        "New-B2BICapability/Type"
        {
            $v = "edi"
            break
        }

        # Amazon.B2bi.ConversionSourceFormat
        "Test-B2BIConversion/Source_FileFormat"
        {
            $v = "JSON","XML"
            break
        }

        # Amazon.B2bi.ConversionTargetFormat
        "Test-B2BIConversion/Target_FileFormat"
        {
            $v = "X12"
            break
        }

        # Amazon.B2bi.FileFormat
        {
            ($_ -eq "New-B2BITransformer/FileFormat") -Or
            ($_ -eq "Test-B2BIMapping/FileFormat") -Or
            ($_ -eq "Test-B2BIParsing/FileFormat") -Or
            ($_ -eq "Update-B2BITransformer/FileFormat")
        }
        {
            $v = "JSON","NOT_USED","XML"
            break
        }

        # Amazon.B2bi.FromFormat
        {
            ($_ -eq "New-B2BITransformer/InputConversion_FromFormat") -Or
            ($_ -eq "Update-B2BITransformer/InputConversion_FromFormat")
        }
        {
            $v = "X12"
            break
        }

        # Amazon.B2bi.LineTerminator
        {
            ($_ -eq "New-B2BIPartnership/WrapOptions_LineTerminator") -Or
            ($_ -eq "Update-B2BIPartnership/WrapOptions_LineTerminator")
        }
        {
            $v = "CR","CRLF","LF"
            break
        }

        # Amazon.B2bi.Logging
        "New-B2BIProfile/Logging"
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.B2bi.MappingTemplateLanguage
        {
            ($_ -eq "New-B2BITransformer/Mapping_TemplateLanguage") -Or
            ($_ -eq "Update-B2BITransformer/Mapping_TemplateLanguage")
        }
        {
            $v = "JSONATA","XSLT"
            break
        }

        # Amazon.B2bi.MappingType
        {
            ($_ -eq "Get-B2BIGeneratedMapping/MappingType") -Or
            ($_ -eq "New-B2BIStarterMappingTemplate/MappingType")
        }
        {
            $v = "JSONATA","XSLT"
            break
        }

        # Amazon.B2bi.ToFormat
        {
            ($_ -eq "New-B2BITransformer/OutputConversion_ToFormat") -Or
            ($_ -eq "Update-B2BITransformer/OutputConversion_ToFormat")
        }
        {
            $v = "X12"
            break
        }

        # Amazon.B2bi.TransformerStatus
        "Update-B2BITransformer/Status"
        {
            $v = "active","inactive"
            break
        }

        # Amazon.B2bi.WrapFormat
        {
            ($_ -eq "New-B2BIPartnership/WrapOptions_WrapBy") -Or
            ($_ -eq "Update-B2BIPartnership/WrapOptions_WrapBy")
        }
        {
            $v = "LINE_LENGTH","ONE_LINE","SEGMENT"
            break
        }

        # Amazon.B2bi.X12FunctionalAcknowledgment
        {
            ($_ -eq "New-B2BIPartnership/AcknowledgmentOptions_FunctionalAcknowledgment") -Or
            ($_ -eq "Update-B2BIPartnership/AcknowledgmentOptions_FunctionalAcknowledgment")
        }
        {
            $v = "DO_NOT_GENERATE","GENERATE_ALL_SEGMENTS","GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP"
            break
        }

        # Amazon.B2bi.X12GS05TimeFormat
        {
            ($_ -eq "New-B2BIPartnership/Common_Gs05TimeFormat") -Or
            ($_ -eq "Update-B2BIPartnership/Common_Gs05TimeFormat")
        }
        {
            $v = "HHMM","HHMMSS","HHMMSSDD"
            break
        }

        # Amazon.B2bi.X12SplitBy
        {
            ($_ -eq "New-B2BITransformer/InputConversion_AdvancedOptions_X12_SplitOptions_SplitBy") -Or
            ($_ -eq "Update-B2BITransformer/InputConversion_AdvancedOptions_X12_SplitOptions_SplitBy") -Or
            ($_ -eq "New-B2BITransformer/OutputConversion_AdvancedOptions_X12_SplitOptions_SplitBy") -Or
            ($_ -eq "Update-B2BITransformer/OutputConversion_AdvancedOptions_X12_SplitOptions_SplitBy") -Or
            ($_ -eq "Test-B2BIConversion/SplitOptions_SplitBy") -Or
            ($_ -eq "Test-B2BIParsing/SplitOptions_SplitBy")
        }
        {
            $v = "NONE","TRANSACTION"
            break
        }

        # Amazon.B2bi.X12TechnicalAcknowledgment
        {
            ($_ -eq "New-B2BIPartnership/AcknowledgmentOptions_TechnicalAcknowledgment") -Or
            ($_ -eq "Update-B2BIPartnership/AcknowledgmentOptions_TechnicalAcknowledgment")
        }
        {
            $v = "DO_NOT_GENERATE","GENERATE_ALL_SEGMENTS"
            break
        }

        # Amazon.B2bi.X12TransactionSet
        {
            ($_ -eq "New-B2BITransformer/InputConversion_FormatOptions_X12_TransactionSet") -Or
            ($_ -eq "Update-B2BITransformer/InputConversion_FormatOptions_X12_TransactionSet") -Or
            ($_ -eq "New-B2BITransformer/OutputConversion_FormatOptions_X12_TransactionSet") -Or
            ($_ -eq "Update-B2BITransformer/OutputConversion_FormatOptions_X12_TransactionSet") -Or
            ($_ -eq "New-B2BIStarterMappingTemplate/X12_TransactionSet") -Or
            ($_ -eq "Test-B2BIConversion/X12_TransactionSet") -Or
            ($_ -eq "New-B2BICapability/X12Details_TransactionSet") -Or
            ($_ -eq "New-B2BITransformer/X12Details_TransactionSet") -Or
            ($_ -eq "Test-B2BIParsing/X12Details_TransactionSet") -Or
            ($_ -eq "Update-B2BICapability/X12Details_TransactionSet") -Or
            ($_ -eq "Update-B2BITransformer/X12Details_TransactionSet")
        }
        {
            $v = "X12_100","X12_101","X12_102","X12_103","X12_104","X12_105","X12_106","X12_107","X12_108","X12_109","X12_110","X12_111","X12_112","X12_113","X12_120","X12_121","X12_124","X12_125","X12_126","X12_127","X12_128","X12_129","X12_130","X12_131","X12_132","X12_133","X12_135","X12_138","X12_139","X12_140","X12_141","X12_142","X12_143","X12_144","X12_146","X12_147","X12_148","X12_149","X12_150","X12_151","X12_152","X12_153","X12_154","X12_155","X12_157","X12_158","X12_159","X12_160","X12_161","X12_163","X12_170","X12_175","X12_176","X12_179","X12_180","X12_185","X12_186","X12_187","X12_188","X12_189","X12_190","X12_191","X12_194","X12_195","X12_196","X12_197","X12_198","X12_199","X12_200","X12_201","X12_202","X12_203","X12_204","X12_205","X12_206","X12_210","X12_211","X12_212","X12_213","X12_214","X12_215","X12_216","X12_217","X12_218","X12_219","X12_220","X12_222","X12_223","X12_224","X12_225","X12_227","X12_228","X12_240","X12_242","X12_244","X12_245","X12_248","X12_249","X12_250","X12_251","X12_252","X12_255","X12_256","X12_259","X12_260","X12_261","X12_262","X12_263","X12_264","X12_265","X12_266","X12_267","X12_268","X12_269","X12_270","X12_270_X279","X12_271","X12_271_X279","X12_272","X12_273","X12_274","X12_275","X12_275_X210","X12_275_X211","X12_276","X12_276_X212","X12_277","X12_277_X212","X12_277_X214","X12_277_X364","X12_278","X12_278_X217","X12_280","X12_283","X12_284","X12_285","X12_286","X12_288","X12_290","X12_300","X12_301","X12_303","X12_304","X12_309","X12_310","X12_311","X12_312","X12_313","X12_315","X12_317","X12_319","X12_322","X12_323","X12_324","X12_325","X12_326","X12_350","X12_352","X12_353","X12_354","X12_355","X12_356","X12_357","X12_358","X12_361","X12_362","X12_404","X12_410","X12_412","X12_414","X12_417","X12_418","X12_419","X12_420","X12_421","X12_422","X12_423","X12_424","X12_425","X12_426","X12_429","X12_431","X12_432","X12_433","X12_434","X12_435","X12_436","X12_437","X12_440","X12_451","X12_452","X12_453","X12_455","X12_456","X12_460","X12_463","X12_466","X12_468","X12_470","X12_475","X12_485","X12_486","X12_490","X12_492","X12_494","X12_500","X12_501","X12_503","X12_504","X12_511","X12_517","X12_521","X12_527","X12_536","X12_540","X12_561","X12_567","X12_568","X12_601","X12_602","X12_620","X12_625","X12_650","X12_715","X12_753","X12_754","X12_805","X12_806","X12_810","X12_811","X12_812","X12_813","X12_814","X12_815","X12_816","X12_818","X12_819","X12_820","X12_820_X218","X12_820_X306","X12_821","X12_822","X12_823","X12_824","X12_824_X186","X12_826","X12_827","X12_828","X12_829","X12_830","X12_831","X12_832","X12_833","X12_834","X12_834_X220","X12_834_X307","X12_834_X318","X12_835","X12_835_X221","X12_836","X12_837","X12_837_X222","X12_837_X223","X12_837_X224","X12_837_X291","X12_837_X292","X12_837_X298","X12_838","X12_839","X12_840","X12_841","X12_842","X12_843","X12_844","X12_845","X12_846","X12_847","X12_848","X12_849","X12_850","X12_851","X12_852","X12_853","X12_854","X12_855","X12_856","X12_857","X12_858","X12_859","X12_860","X12_861","X12_862","X12_863","X12_864","X12_865","X12_866","X12_867","X12_868","X12_869","X12_870","X12_871","X12_872","X12_873","X12_874","X12_875","X12_876","X12_877","X12_878","X12_879","X12_880","X12_881","X12_882","X12_883","X12_884","X12_885","X12_886","X12_887","X12_888","X12_889","X12_891","X12_893","X12_894","X12_895","X12_896","X12_920","X12_924","X12_925","X12_926","X12_928","X12_940","X12_943","X12_944","X12_945","X12_947","X12_980","X12_990","X12_993","X12_996","X12_997","X12_998","X12_999","X12_999_X231"
            break
        }

        # Amazon.B2bi.X12Version
        {
            ($_ -eq "New-B2BITransformer/InputConversion_FormatOptions_X12_Version") -Or
            ($_ -eq "Update-B2BITransformer/InputConversion_FormatOptions_X12_Version") -Or
            ($_ -eq "New-B2BITransformer/OutputConversion_FormatOptions_X12_Version") -Or
            ($_ -eq "Update-B2BITransformer/OutputConversion_FormatOptions_X12_Version") -Or
            ($_ -eq "New-B2BIStarterMappingTemplate/X12_Version") -Or
            ($_ -eq "Test-B2BIConversion/X12_Version") -Or
            ($_ -eq "New-B2BICapability/X12Details_Version") -Or
            ($_ -eq "New-B2BITransformer/X12Details_Version") -Or
            ($_ -eq "Test-B2BIParsing/X12Details_Version") -Or
            ($_ -eq "Update-B2BICapability/X12Details_Version") -Or
            ($_ -eq "Update-B2BITransformer/X12Details_Version")
        }
        {
            $v = "VERSION_4010","VERSION_4030","VERSION_4050","VERSION_4060","VERSION_5010","VERSION_5010_HIPAA"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$B2BI_map = @{
    "AcknowledgmentOptions_FunctionalAcknowledgment"=@("New-B2BIPartnership","Update-B2BIPartnership")
    "AcknowledgmentOptions_TechnicalAcknowledgment"=@("New-B2BIPartnership","Update-B2BIPartnership")
    "Common_Gs05TimeFormat"=@("New-B2BIPartnership","Update-B2BIPartnership")
    "Edi_CapabilityDirection"=@("New-B2BICapability","Update-B2BICapability")
    "FileFormat"=@("New-B2BITransformer","Test-B2BIMapping","Test-B2BIParsing","Update-B2BITransformer")
    "InputConversion_AdvancedOptions_X12_SplitOptions_SplitBy"=@("New-B2BITransformer","Update-B2BITransformer")
    "InputConversion_FormatOptions_X12_TransactionSet"=@("New-B2BITransformer","Update-B2BITransformer")
    "InputConversion_FormatOptions_X12_Version"=@("New-B2BITransformer","Update-B2BITransformer")
    "InputConversion_FromFormat"=@("New-B2BITransformer","Update-B2BITransformer")
    "Logging"=@("New-B2BIProfile")
    "Mapping_TemplateLanguage"=@("New-B2BITransformer","Update-B2BITransformer")
    "MappingType"=@("Get-B2BIGeneratedMapping","New-B2BIStarterMappingTemplate")
    "OutputConversion_AdvancedOptions_X12_SplitOptions_SplitBy"=@("New-B2BITransformer","Update-B2BITransformer")
    "OutputConversion_FormatOptions_X12_TransactionSet"=@("New-B2BITransformer","Update-B2BITransformer")
    "OutputConversion_FormatOptions_X12_Version"=@("New-B2BITransformer","Update-B2BITransformer")
    "OutputConversion_ToFormat"=@("New-B2BITransformer","Update-B2BITransformer")
    "Source_FileFormat"=@("Test-B2BIConversion")
    "SplitOptions_SplitBy"=@("Test-B2BIConversion","Test-B2BIParsing")
    "Status"=@("Update-B2BITransformer")
    "Target_FileFormat"=@("Test-B2BIConversion")
    "Type"=@("New-B2BICapability")
    "WrapOptions_LineTerminator"=@("New-B2BIPartnership","Update-B2BIPartnership")
    "WrapOptions_WrapBy"=@("New-B2BIPartnership","Update-B2BIPartnership")
    "X12_TransactionSet"=@("New-B2BIStarterMappingTemplate","Test-B2BIConversion")
    "X12_Version"=@("New-B2BIStarterMappingTemplate","Test-B2BIConversion")
    "X12Details_TransactionSet"=@("New-B2BICapability","New-B2BITransformer","Test-B2BIParsing","Update-B2BICapability","Update-B2BITransformer")
    "X12Details_Version"=@("New-B2BICapability","New-B2BITransformer","Test-B2BIParsing","Update-B2BICapability","Update-B2BITransformer")
}

_awsArgumentCompleterRegistration $B2BI_Completers $B2BI_map

$B2BI_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.B2BI.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$B2BI_SelectMap = @{
    "Select"=@("New-B2BICapability",
               "New-B2BIPartnership",
               "New-B2BIProfile",
               "New-B2BIStarterMappingTemplate",
               "New-B2BITransformer",
               "Remove-B2BICapability",
               "Remove-B2BIPartnership",
               "Remove-B2BIProfile",
               "Remove-B2BITransformer",
               "Get-B2BIGeneratedMapping",
               "Get-B2BICapability",
               "Get-B2BIPartnership",
               "Get-B2BIProfile",
               "Get-B2BITransformer",
               "Get-B2BITransformerJob",
               "Get-B2BICapabilityList",
               "Get-B2BIPartnershipList",
               "Get-B2BIProfileList",
               "Get-B2BIResourceTag",
               "Get-B2BITransformerList",
               "Start-B2BITransformerJob",
               "Add-B2BIResourceTag",
               "Test-B2BIConversion",
               "Test-B2BIMapping",
               "Test-B2BIParsing",
               "Remove-B2BIResourceTag",
               "Update-B2BICapability",
               "Update-B2BIPartnership",
               "Update-B2BIProfile",
               "Update-B2BITransformer")
}

_awsArgumentCompleterRegistration $B2BI_SelectCompleters $B2BI_SelectMap
# Argument completions for service AWS Backup Gateway


$BUGW_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.BackupGateway.GatewayType
        "New-BUGWGateway/GatewayType"
        {
            $v = "BACKUP_VM"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BUGW_map = @{
    "GatewayType"=@("New-BUGWGateway")
}

_awsArgumentCompleterRegistration $BUGW_Completers $BUGW_map

$BUGW_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.BUGW.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BUGW_SelectMap = @{
    "Select"=@("Add-BUGWGatewayToServer",
               "New-BUGWGateway",
               "Remove-BUGWGateway",
               "Remove-BUGWHypervisor",
               "Remove-BUGWGatewayFromServer",
               "Get-BUGWBandwidthRateLimitSchedule",
               "Get-BUGWGateway",
               "Get-BUGWHypervisor",
               "Get-BUGWHypervisorPropertyMapping",
               "Get-BUGWVirtualMachine",
               "Import-BUGWHypervisorConfiguration",
               "Get-BUGWGatewayList",
               "Get-BUGWHypervisorList",
               "Get-BUGWResourceTag",
               "Get-BUGWVirtualMachineList",
               "Write-BUGWBandwidthRateLimitSchedule",
               "Write-BUGWHypervisorPropertyMapping",
               "Write-BUGWMaintenanceStartTime",
               "Start-BUGWVirtualMachinesMetadataSync",
               "Add-BUGWResourceTag",
               "Test-BUGWHypervisorConfiguration",
               "Remove-BUGWResourceTag",
               "Update-BUGWGatewayInformation",
               "Update-BUGWGatewaySoftwareNow",
               "Update-BUGWHypervisor")
}

_awsArgumentCompleterRegistration $BUGW_SelectCompleters $BUGW_SelectMap
# Argument completions for service AWS Backup


$BAK_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.Backup.AggregationPeriod
        {
            ($_ -eq "Get-BAKBackupJobSummaryList/AggregationPeriod") -Or
            ($_ -eq "Get-BAKCopyJobSummaryList/AggregationPeriod") -Or
            ($_ -eq "Get-BAKRestoreJobSummaryList/AggregationPeriod")
        }
        {
            $v = "FOURTEEN_DAYS","ONE_DAY","SEVEN_DAYS"
            break
        }

        # Amazon.Backup.BackupJobState
        "Get-BAKBackupJobList/ByState"
        {
            $v = "ABORTED","ABORTING","COMPLETED","CREATED","EXPIRED","FAILED","PARTIAL","PENDING","RUNNING"
            break
        }

        # Amazon.Backup.BackupJobStatus
        "Get-BAKBackupJobSummaryList/State"
        {
            $v = "ABORTED","ABORTING","AGGREGATE_ALL","ANY","COMPLETED","CREATED","EXPIRED","FAILED","PARTIAL","PENDING","RUNNING"
            break
        }

        # Amazon.Backup.CopyJobState
        "Get-BAKCopyJobList/ByState"
        {
            $v = "COMPLETED","CREATED","FAILED","PARTIAL","RUNNING"
            break
        }

        # Amazon.Backup.CopyJobStatus
        "Get-BAKCopyJobSummaryList/State"
        {
            $v = "ABORTED","ABORTING","AGGREGATE_ALL","ANY","COMPLETED","COMPLETING","CREATED","FAILED","FAILING","PARTIAL","RUNNING"
            break
        }

        # Amazon.Backup.Index
        {
            ($_ -eq "Start-BAKBackupJob/Index") -Or
            ($_ -eq "Update-BAKRecoveryPointIndexSetting/Index")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.Backup.IndexStatus
        "Get-BAKIndexedRecoveryPointList/IndexStatus"
        {
            $v = "ACTIVE","DELETING","FAILED","PENDING"
            break
        }

        # Amazon.Backup.RestoreJobState
        "Get-BAKRestoreJobSummaryList/State"
        {
            $v = "ABORTED","AGGREGATE_ALL","ANY","COMPLETED","CREATED","FAILED","PENDING","RUNNING"
            break
        }

        # Amazon.Backup.RestoreJobStatus
        {
            ($_ -eq "Get-BAKRestoreJobList/ByStatus") -Or
            ($_ -eq "Get-BAKRestoreJobsByProtectedResourceList/ByStatus")
        }
        {
            $v = "ABORTED","COMPLETED","FAILED","PENDING","RUNNING"
            break
        }

        # Amazon.Backup.RestoreTestingRecoveryPointSelectionAlgorithm
        {
            ($_ -eq "New-BAKRestoreTestingPlan/RecoveryPointSelection_Algorithm") -Or
            ($_ -eq "Update-BAKRestoreTestingPlan/RecoveryPointSelection_Algorithm")
        }
        {
            $v = "LATEST_WITHIN_WINDOW","RANDOM_WITHIN_WINDOW"
            break
        }

        # Amazon.Backup.RestoreValidationStatus
        "Write-BAKRestoreValidationResult/ValidationStatus"
        {
            $v = "FAILED","SUCCESSFUL","TIMED_OUT","VALIDATING"
            break
        }

        # Amazon.Backup.VaultType
        "Get-BAKBackupVaultList/ByVaultType"
        {
            $v = "BACKUP_VAULT","LOGICALLY_AIR_GAPPED_BACKUP_VAULT","RESTORE_ACCESS_BACKUP_VAULT"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BAK_map = @{
    "AggregationPeriod"=@("Get-BAKBackupJobSummaryList","Get-BAKCopyJobSummaryList","Get-BAKRestoreJobSummaryList")
    "ByState"=@("Get-BAKBackupJobList","Get-BAKCopyJobList")
    "ByStatus"=@("Get-BAKRestoreJobList","Get-BAKRestoreJobsByProtectedResourceList")
    "ByVaultType"=@("Get-BAKBackupVaultList")
    "Index"=@("Start-BAKBackupJob","Update-BAKRecoveryPointIndexSetting")
    "IndexStatus"=@("Get-BAKIndexedRecoveryPointList")
    "RecoveryPointSelection_Algorithm"=@("New-BAKRestoreTestingPlan","Update-BAKRestoreTestingPlan")
    "State"=@("Get-BAKBackupJobSummaryList","Get-BAKCopyJobSummaryList","Get-BAKRestoreJobSummaryList")
    "ValidationStatus"=@("Write-BAKRestoreValidationResult")
}

_awsArgumentCompleterRegistration $BAK_Completers $BAK_map

$BAK_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.BAK.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BAK_SelectMap = @{
    "Select"=@("Add-BAKBackupVaultMpaApprovalTeam",
               "Stop-BAKLegalHold",
               "New-BAKBackupPlan",
               "New-BAKBackupSelection",
               "New-BAKBackupVault",
               "New-BAKFramework",
               "New-BAKLegalHold",
               "New-BAKLogicallyAirGappedBackupVault",
               "New-BAKReportPlan",
               "New-BAKRestoreAccessBackupVault",
               "New-BAKRestoreTestingPlan",
               "New-BAKRestoreTestingSelection",
               "Remove-BAKBackupPlan",
               "Remove-BAKBackupSelection",
               "Remove-BAKBackupVault",
               "Remove-BAKBackupVaultAccessPolicy",
               "Remove-BAKBackupVaultLockConfiguration",
               "Remove-BAKBackupVaultNotification",
               "Remove-BAKFramework",
               "Remove-BAKRecoveryPoint",
               "Remove-BAKReportPlan",
               "Remove-BAKRestoreTestingPlan",
               "Remove-BAKRestoreTestingSelection",
               "Get-BAKBackupJob",
               "Get-BAKBackupVault",
               "Get-BAKCopyJob",
               "Get-BAKFramework",
               "Get-BAKGlobalSetting",
               "Get-BAKProtectedResource",
               "Get-BAKRecoveryPoint",
               "Get-BAKRegionSetting",
               "Get-BAKReportJob",
               "Get-BAKReportPlan",
               "Get-BAKRestoreJob",
               "Remove-BAKBackupVaultMpaApprovalTeam",
               "Unlock-BAKRecoveryPoint",
               "Move-BAKRecoveryPoint",
               "Export-BAKBackupPlanTemplate",
               "Get-BAKBackupPlan",
               "Get-BAKBackupPlanFromJSON",
               "Get-BAKBackupPlanFromTemplate",
               "Get-BAKBackupSelection",
               "Get-BAKBackupVaultAccessPolicy",
               "Get-BAKBackupVaultNotification",
               "Get-BAKLegalHold",
               "Get-BAKRecoveryPointIndexDetail",
               "Get-BAKRecoveryPointRestoreMetadata",
               "Get-BAKRestoreJobMetadata",
               "Get-BAKRestoreTestingInferredMetadata",
               "Get-BAKRestoreTestingPlan",
               "Get-BAKRestoreTestingSelection",
               "Get-BAKSupportedResourceType",
               "Get-BAKBackupJobList",
               "Get-BAKBackupJobSummaryList",
               "Get-BAKBackupPlanList",
               "Get-BAKBackupPlanTemplateList",
               "Get-BAKBackupPlanVersionList",
               "Get-BAKBackupSelectionList",
               "Get-BAKBackupVaultList",
               "Get-BAKCopyJobList",
               "Get-BAKCopyJobSummaryList",
               "Get-BAKFrameworkList",
               "Get-BAKIndexedRecoveryPointList",
               "Get-BAKLegalHoldList",
               "Get-BAKProtectedResourceList",
               "Get-BAKProtectedResourcesByBackupVaultList",
               "Get-BAKRecoveryPointsByBackupVaultList",
               "Get-BAKRecoveryPointsByLegalHoldList",
               "Get-BAKRecoveryPointsByResourceList",
               "Get-BAKReportJobList",
               "Get-BAKReportPlanList",
               "Get-BAKRestoreAccessBackupVaultList",
               "Get-BAKRestoreJobList",
               "Get-BAKRestoreJobsByProtectedResourceList",
               "Get-BAKRestoreJobSummaryList",
               "Get-BAKRestoreTestingPlanList",
               "Get-BAKRestoreTestingSelectionList",
               "Get-BAKResourceTag",
               "Write-BAKBackupVaultAccessPolicy",
               "Write-BAKBackupVaultLockConfiguration",
               "Write-BAKBackupVaultNotification",
               "Write-BAKRestoreValidationResult",
               "Revoke-BAKRestoreAccessBackupVault",
               "Start-BAKBackupJob",
               "Start-BAKCopyJob",
               "Start-BAKReportJob",
               "Start-BAKRestoreJob",
               "Stop-BAKBackupJob",
               "Add-BAKResourceTag",
               "Remove-BAKResourceTag",
               "Update-BAKBackupPlan",
               "Update-BAKFramework",
               "Update-BAKGlobalSetting",
               "Update-BAKRecoveryPointIndexSetting",
               "Update-BAKRecoveryPointLifecycle",
               "Update-BAKRegionSetting",
               "Update-BAKReportPlan",
               "Update-BAKRestoreTestingPlan",
               "Update-BAKRestoreTestingSelection")
}

_awsArgumentCompleterRegistration $BAK_SelectCompleters $BAK_SelectMap
# Argument completions for service AWS Backup Search


$BAKS_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.BackupSearch.ExportJobStatus
        "Get-BAKSSearchResultExportJobList/Status"
        {
            $v = "COMPLETED","FAILED","RUNNING"
            break
        }

        # Amazon.BackupSearch.SearchJobState
        "Get-BAKSSearchJobList/ByStatus"
        {
            $v = "COMPLETED","FAILED","RUNNING","STOPPED","STOPPING"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BAKS_map = @{
    "ByStatus"=@("Get-BAKSSearchJobList")
    "Status"=@("Get-BAKSSearchResultExportJobList")
}

_awsArgumentCompleterRegistration $BAKS_Completers $BAKS_map

$BAKS_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.BAKS.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BAKS_SelectMap = @{
    "Select"=@("Get-BAKSSearchJob",
               "Get-BAKSSearchResultExportJob",
               "Get-BAKSSearchJobBackupList",
               "Get-BAKSSearchJobResultList",
               "Get-BAKSSearchJobList",
               "Get-BAKSSearchResultExportJobList",
               "Get-BAKSResourceTag",
               "Start-BAKSSearchJob",
               "Start-BAKSSearchResultExportJob",
               "Stop-BAKSSearchJob",
               "Add-BAKSResourceTag",
               "Remove-BAKSResourceTag")
}

_awsArgumentCompleterRegistration $BAKS_SelectCompleters $BAKS_SelectMap
# Argument completions for service AWS Batch


$BAT_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.Batch.AssignPublicIp
        "Register-BATJobDefinition/NetworkConfiguration_AssignPublicIp"
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.Batch.CEState
        {
            ($_ -eq "New-BATComputeEnvironment/State") -Or
            ($_ -eq "Update-BATComputeEnvironment/State")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.Batch.CEType
        "New-BATComputeEnvironment/Type"
        {
            $v = "MANAGED","UNMANAGED"
            break
        }

        # Amazon.Batch.CRAllocationStrategy
        "New-BATComputeEnvironment/ComputeResources_AllocationStrategy"
        {
            $v = "BEST_FIT","BEST_FIT_PROGRESSIVE","SPOT_CAPACITY_OPTIMIZED","SPOT_PRICE_CAPACITY_OPTIMIZED"
            break
        }

        # Amazon.Batch.CRType
        {
            ($_ -eq "New-BATComputeEnvironment/ComputeResources_Type") -Or
            ($_ -eq "Update-BATComputeEnvironment/ComputeResources_Type")
        }
        {
            $v = "EC2","FARGATE","FARGATE_SPOT","SPOT"
            break
        }

        # Amazon.Batch.CRUpdateAllocationStrategy
        "Update-BATComputeEnvironment/ComputeResources_AllocationStrategy"
        {
            $v = "BEST_FIT_PROGRESSIVE","SPOT_CAPACITY_OPTIMIZED","SPOT_PRICE_CAPACITY_OPTIMIZED"
            break
        }

        # Amazon.Batch.JobDefinitionType
        "Register-BATJobDefinition/Type"
        {
            $v = "container","multinode"
            break
        }

        # Amazon.Batch.JobQueueType
        "New-BATJobQueue/JobQueueType"
        {
            $v = "ECS","ECS_FARGATE","EKS","SAGEMAKER_TRAINING"
            break
        }

        # Amazon.Batch.JobStatus
        "Get-BATJobList/JobStatus"
        {
            $v = "FAILED","PENDING","RUNNABLE","RUNNING","STARTING","SUBMITTED","SUCCEEDED"
            break
        }

        # Amazon.Batch.JQState
        {
            ($_ -eq "New-BATJobQueue/State") -Or
            ($_ -eq "Update-BATJobQueue/State")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.Batch.LogDriver
        "Register-BATJobDefinition/LogConfiguration_LogDriver"
        {
            $v = "awsfirelens","awslogs","fluentd","gelf","journald","json-file","splunk","syslog"
            break
        }

        # Amazon.Batch.ServiceEnvironmentState
        {
            ($_ -eq "New-BATServiceEnvironment/State") -Or
            ($_ -eq "Update-BATServiceEnvironment/State")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.Batch.ServiceEnvironmentType
        "New-BATServiceEnvironment/ServiceEnvironmentType"
        {
            $v = "SAGEMAKER_TRAINING"
            break
        }

        # Amazon.Batch.ServiceJobStatus
        "Get-BATServiceJobList/JobStatus"
        {
            $v = "FAILED","PENDING","RUNNABLE","RUNNING","SCHEDULED","STARTING","SUBMITTED","SUCCEEDED"
            break
        }

        # Amazon.Batch.ServiceJobType
        "Submit-BATServiceJob/ServiceJobType"
        {
            $v = "SAGEMAKER_TRAINING"
            break
        }

        # Amazon.Batch.UserdataType
        {
            ($_ -eq "New-BATComputeEnvironment/LaunchTemplate_UserdataType") -Or
            ($_ -eq "Update-BATComputeEnvironment/LaunchTemplate_UserdataType")
        }
        {
            $v = "EKS_BOOTSTRAP_SH","EKS_NODEADM"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BAT_map = @{
    "ComputeResources_AllocationStrategy"=@("New-BATComputeEnvironment","Update-BATComputeEnvironment")
    "ComputeResources_Type"=@("New-BATComputeEnvironment","Update-BATComputeEnvironment")
    "JobQueueType"=@("New-BATJobQueue")
    "JobStatus"=@("Get-BATJobList","Get-BATServiceJobList")
    "LaunchTemplate_UserdataType"=@("New-BATComputeEnvironment","Update-BATComputeEnvironment")
    "LogConfiguration_LogDriver"=@("Register-BATJobDefinition")
    "NetworkConfiguration_AssignPublicIp"=@("Register-BATJobDefinition")
    "ServiceEnvironmentType"=@("New-BATServiceEnvironment")
    "ServiceJobType"=@("Submit-BATServiceJob")
    "State"=@("New-BATComputeEnvironment","New-BATJobQueue","New-BATServiceEnvironment","Update-BATComputeEnvironment","Update-BATJobQueue","Update-BATServiceEnvironment")
    "Type"=@("New-BATComputeEnvironment","Register-BATJobDefinition")
}

_awsArgumentCompleterRegistration $BAT_Completers $BAT_map

$BAT_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.BAT.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BAT_SelectMap = @{
    "Select"=@("Stop-BATJob",
               "New-BATComputeEnvironment",
               "New-BATConsumableResource",
               "New-BATJobQueue",
               "New-BATSchedulingPolicy",
               "New-BATServiceEnvironment",
               "Remove-BATComputeEnvironment",
               "Remove-BATConsumableResource",
               "Remove-BATJobQueue",
               "Remove-BATSchedulingPolicy",
               "Remove-BATServiceEnvironment",
               "Unregister-BATJobDefinition",
               "Get-BATComputeEnvironment",
               "Get-BATConsumableResource",
               "Get-BATJobDefinition",
               "Get-BATJobQueue",
               "Get-BATJobDetail",
               "Get-BATSchedulingPolicy",
               "Get-BATServiceEnvironment",
               "Get-BATServiceJob",
               "Get-BATJobQueueSnapshot",
               "Get-BATConsumableResourceList",
               "Get-BATJobList",
               "Get-BATJobsByConsumableResourceList",
               "Get-BATSchedulingPolicyList",
               "Get-BATServiceJobList",
               "Get-BATResourceTag",
               "Register-BATJobDefinition",
               "Submit-BATJob",
               "Submit-BATServiceJob",
               "Add-BATResourceTag",
               "Remove-BATJob",
               "Stop-BATServiceJob",
               "Remove-BATResourceTag",
               "Update-BATComputeEnvironment",
               "Update-BATConsumableResource",
               "Update-BATJobQueue",
               "Update-BATSchedulingPolicy",
               "Update-BATServiceEnvironment")
}

_awsArgumentCompleterRegistration $BAT_SelectCompleters $BAT_SelectMap
# Argument completions for service AWSBillingAndCostManagementDataExports


$BCMDE_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.BCMDataExports.CompressionOption
        {
            ($_ -eq "New-BCMDEExport/S3OutputConfigurations_Compression") -Or
            ($_ -eq "Update-BCMDEExport/S3OutputConfigurations_Compression")
        }
        {
            $v = "GZIP","PARQUET"
            break
        }

        # Amazon.BCMDataExports.FormatOption
        {
            ($_ -eq "New-BCMDEExport/S3OutputConfigurations_Format") -Or
            ($_ -eq "Update-BCMDEExport/S3OutputConfigurations_Format")
        }
        {
            $v = "PARQUET","TEXT_OR_CSV"
            break
        }

        # Amazon.BCMDataExports.FrequencyOption
        {
            ($_ -eq "New-BCMDEExport/RefreshCadence_Frequency") -Or
            ($_ -eq "Update-BCMDEExport/RefreshCadence_Frequency")
        }
        {
            $v = "SYNCHRONOUS"
            break
        }

        # Amazon.BCMDataExports.OverwriteOption
        {
            ($_ -eq "New-BCMDEExport/S3OutputConfigurations_Overwrite") -Or
            ($_ -eq "Update-BCMDEExport/S3OutputConfigurations_Overwrite")
        }
        {
            $v = "CREATE_NEW_REPORT","OVERWRITE_REPORT"
            break
        }

        # Amazon.BCMDataExports.S3OutputType
        {
            ($_ -eq "New-BCMDEExport/S3OutputConfigurations_OutputType") -Or
            ($_ -eq "Update-BCMDEExport/S3OutputConfigurations_OutputType")
        }
        {
            $v = "CUSTOM"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BCMDE_map = @{
    "RefreshCadence_Frequency"=@("New-BCMDEExport","Update-BCMDEExport")
    "S3OutputConfigurations_Compression"=@("New-BCMDEExport","Update-BCMDEExport")
    "S3OutputConfigurations_Format"=@("New-BCMDEExport","Update-BCMDEExport")
    "S3OutputConfigurations_OutputType"=@("New-BCMDEExport","Update-BCMDEExport")
    "S3OutputConfigurations_Overwrite"=@("New-BCMDEExport","Update-BCMDEExport")
}

_awsArgumentCompleterRegistration $BCMDE_Completers $BCMDE_map

$BCMDE_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.BCMDE.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BCMDE_SelectMap = @{
    "Select"=@("New-BCMDEExport",
               "Remove-BCMDEExport",
               "Get-BCMDEExecution",
               "Get-BCMDEExport",
               "Get-BCMDETable",
               "Get-BCMDEExecutionList",
               "Get-BCMDEExportList",
               "Get-BCMDETableList",
               "Get-BCMDEResourceTag",
               "Add-BCMDEResourceTag",
               "Remove-BCMDEResourceTag",
               "Update-BCMDEExport")
}

_awsArgumentCompleterRegistration $BCMDE_SelectCompleters $BCMDE_SelectMap
# Argument completions for service AWS Pricing Calculator


$BCMPC_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.BCMPricingCalculator.WorkloadEstimateRateType
        "New-BCMPCWorkloadEstimate/RateType"
        {
            $v = "AFTER_DISCOUNTS","AFTER_DISCOUNTS_AND_COMMITMENTS","BEFORE_DISCOUNTS"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BCMPC_map = @{
    "RateType"=@("New-BCMPCWorkloadEstimate")
}

_awsArgumentCompleterRegistration $BCMPC_Completers $BCMPC_map

$BCMPC_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.BCMPC.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BCMPC_SelectMap = @{
    "Select"=@("New-BCMPCCreateBillScenarioCommitmentModification",
               "New-BCMPCCreateBillScenarioUsageModification",
               "New-BCMPCCreateWorkloadEstimateUsage",
               "New-BCMPCDeleteBillScenarioCommitmentModification",
               "New-BCMPCDeleteBillScenarioUsageModification",
               "New-BCMPCDeleteWorkloadEstimateUsage",
               "New-BCMPCUpdateBillScenarioCommitmentModification",
               "New-BCMPCUpdateBillScenarioUsageModification",
               "New-BCMPCUpdateWorkloadEstimateUsage",
               "New-BCMPCBillEstimate",
               "New-BCMPCBillScenario",
               "New-BCMPCWorkloadEstimate",
               "Remove-BCMPCBillEstimate",
               "Remove-BCMPCBillScenario",
               "Remove-BCMPCWorkloadEstimate",
               "Get-BCMPCBillEstimate",
               "Get-BCMPCBillScenario",
               "Get-BCMPCPreference",
               "Get-BCMPCWorkloadEstimate",
               "Get-BCMPCBillEstimateCommitmentList",
               "Get-BCMPCBillEstimateInputCommitmentModificationList",
               "Get-BCMPCBillEstimateInputUsageModificationList",
               "Get-BCMPCBillEstimateLineItemList",
               "Get-BCMPCBillEstimateList",
               "Get-BCMPCBillScenarioCommitmentModificationList",
               "Get-BCMPCBillScenarioList",
               "Get-BCMPCBillScenarioUsageModificationList",
               "Get-BCMPCResourceTag",
               "Get-BCMPCWorkloadEstimateList",
               "Get-BCMPCWorkloadEstimateUsageList",
               "Add-BCMPCResourceTag",
               "Remove-BCMPCResourceTag",
               "Update-BCMPCBillEstimate",
               "Update-BCMPCBillScenario",
               "Update-BCMPCPreference",
               "Update-BCMPCWorkloadEstimate")
}

_awsArgumentCompleterRegistration $BCMPC_SelectCompleters $BCMPC_SelectMap
# Argument completions for service AWS Billing And Cost Management Recommended Actions


$BCMRA_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.BCMRA.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BCMRA_SelectMap = @{
    "Select"=@("Get-BCMRARecommendedActionList")
}

_awsArgumentCompleterRegistration $BCMRA_SelectCompleters $BCMRA_SelectMap
# Argument completions for service AWS Billing and Cost Management Dashboards


$BCMD_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.BCMD.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BCMD_SelectMap = @{
    "Select"=@("New-BCMDDashboard",
               "Remove-BCMDDashboard",
               "Get-BCMDDashboard",
               "Get-BCMDResourcePolicy",
               "Get-BCMDDashboardList",
               "Get-BCMDResourceTag",
               "Add-BCMDResourceTag",
               "Remove-BCMDResourceTag",
               "Update-BCMDDashboard")
}

_awsArgumentCompleterRegistration $BCMD_SelectCompleters $BCMD_SelectMap
# Argument completions for service Amazon Bedrock Agent Runtime


$BAR_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.BedrockAgentRuntime.AgentCollaboration
        "Invoke-BARInlineAgent/AgentCollaboration"
        {
            $v = "DISABLED","SUPERVISOR","SUPERVISOR_ROUTER"
            break
        }

        # Amazon.BedrockAgentRuntime.FlowExecutionEventType
        "Get-BARFlowExecutionEventList/EventType"
        {
            $v = "Flow","Node"
            break
        }

        # Amazon.BedrockAgentRuntime.InputQueryType
        "Invoke-BARGenerateQuery/QueryGenerationInput_Type"
        {
            $v = "TEXT"
            break
        }

        # Amazon.BedrockAgentRuntime.MemoryType
        "Get-BARAgentMemory/MemoryType"
        {
            $v = "SESSION_SUMMARY"
            break
        }

        # Amazon.BedrockAgentRuntime.OrchestrationType
        "Invoke-BARInlineAgent/OrchestrationType"
        {
            $v = "CUSTOM_ORCHESTRATION","DEFAULT"
            break
        }

        # Amazon.BedrockAgentRuntime.PerformanceConfigLatency
        {
            ($_ -eq "Invoke-BARRetrieveAndGenerate/ExternalSourcesConfig_PerformanceConfig_Latency") -Or
            ($_ -eq "Invoke-BARRetrieveAndGenerate/KnowledgeBaseConfig_GenerationConfig_PerformanceConfig_Latency") -Or
            ($_ -eq "Invoke-BARRetrieveAndGenerate/KnowledgeBaseConfig_OrchestrationConfig_PerformanceConfig_Latency") -Or
            ($_ -eq "Invoke-BARAgent/PerformanceConfig_Latency") -Or
            ($_ -eq "Invoke-BARFlow/PerformanceConfig_Latency") -Or
            ($_ -eq "Invoke-BARInlineAgent/PerformanceConfig_Latency") -Or
            ($_ -eq "Start-BARFlowExecution/PerformanceConfig_Latency") -Or
            ($_ -eq "Invoke-BARRetrieveAndGenerateStream/Stream_ExternalSourcesConfig_PerformanceConfig_Latency") -Or
            ($_ -eq "Invoke-BARRetrieveAndGenerateStream/Stream_KnowledgeBaseConfig_GenerationConfig_PerformanceConfig_Latency") -Or
            ($_ -eq "Invoke-BARRetrieveAndGenerateStream/Stream_KnowledgeBaseConfig_OrchestrationConfig_PerformanceConfig_Latency")
        }
        {
            $v = "optimized","standard"
            break
        }

        # Amazon.BedrockAgentRuntime.QueryTransformationMode
        "Invoke-BARGenerateQuery/TransformationConfiguration_Mode"
        {
            $v = "TEXT_TO_SQL"
            break
        }

        # Amazon.BedrockAgentRuntime.QueryTransformationType
        {
            ($_ -eq "Invoke-BARRetrieveAndGenerate/QueryTransformationConfiguration_Type") -Or
            ($_ -eq "Invoke-BARRetrieveAndGenerateStream/QueryTransformationConfiguration_Type")
        }
        {
            $v = "QUERY_DECOMPOSITION"
            break
        }

        # Amazon.BedrockAgentRuntime.RerankingConfigurationType
        "Invoke-BARRerank/RerankingConfiguration_Type"
        {
            $v = "BEDROCK_RERANKING_MODEL"
            break
        }

        # Amazon.BedrockAgentRuntime.RerankingMetadataSelectionMode
        {
            ($_ -eq "Invoke-BARRetrieve/MetadataConfiguration_SelectionMode") -Or
            ($_ -eq "Invoke-BARRetrieveAndGenerate/MetadataConfiguration_SelectionMode") -Or
            ($_ -eq "Invoke-BARRetrieveAndGenerateStream/MetadataConfiguration_SelectionMode")
        }
        {
            $v = "ALL","SELECTIVE"
            break
        }

        # Amazon.BedrockAgentRuntime.RetrieveAndGenerateType
        {
            ($_ -eq "Invoke-BARRetrieveAndGenerate/RetrieveAndGenerateConfiguration_Type") -Or
            ($_ -eq "Invoke-BARRetrieveAndGenerateStream/RetrieveAndGenerateConfiguration_Type")
        }
        {
            $v = "EXTERNAL_SOURCES","KNOWLEDGE_BASE"
            break
        }

        # Amazon.BedrockAgentRuntime.SearchType
        {
            ($_ -eq "Invoke-BARRetrieve/VectorSearchConfiguration_OverrideSearchType") -Or
            ($_ -eq "Invoke-BARRetrieveAndGenerate/VectorSearchConfiguration_OverrideSearchType") -Or
            ($_ -eq "Invoke-BARRetrieveAndGenerateStream/VectorSearchConfiguration_OverrideSearchType")
        }
        {
            $v = "HYBRID","SEMANTIC"
            break
        }

        # Amazon.BedrockAgentRuntime.TextToSqlConfigurationType
        "Invoke-BARGenerateQuery/TextToSqlConfiguration_Type"
        {
            $v = "KNOWLEDGE_BASE"
            break
        }

        # Amazon.BedrockAgentRuntime.VectorSearchRerankingConfigurationType
        {
            ($_ -eq "Invoke-BARRetrieve/RerankingConfiguration_Type") -Or
            ($_ -eq "Invoke-BARRetrieveAndGenerate/RerankingConfiguration_Type") -Or
            ($_ -eq "Invoke-BARRetrieveAndGenerateStream/RerankingConfiguration_Type")
        }
        {
            $v = "BEDROCK_RERANKING_MODEL"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BAR_map = @{
    "AgentCollaboration"=@("Invoke-BARInlineAgent")
    "EventType"=@("Get-BARFlowExecutionEventList")
    "ExternalSourcesConfig_PerformanceConfig_Latency"=@("Invoke-BARRetrieveAndGenerate")
    "KnowledgeBaseConfig_GenerationConfig_PerformanceConfig_Latency"=@("Invoke-BARRetrieveAndGenerate")
    "KnowledgeBaseConfig_OrchestrationConfig_PerformanceConfig_Latency"=@("Invoke-BARRetrieveAndGenerate")
    "MemoryType"=@("Get-BARAgentMemory")
    "MetadataConfiguration_SelectionMode"=@("Invoke-BARRetrieve","Invoke-BARRetrieveAndGenerate","Invoke-BARRetrieveAndGenerateStream")
    "OrchestrationType"=@("Invoke-BARInlineAgent")
    "PerformanceConfig_Latency"=@("Invoke-BARAgent","Invoke-BARFlow","Invoke-BARInlineAgent","Start-BARFlowExecution")
    "QueryGenerationInput_Type"=@("Invoke-BARGenerateQuery")
    "QueryTransformationConfiguration_Type"=@("Invoke-BARRetrieveAndGenerate","Invoke-BARRetrieveAndGenerateStream")
    "RerankingConfiguration_Type"=@("Invoke-BARRerank","Invoke-BARRetrieve","Invoke-BARRetrieveAndGenerate","Invoke-BARRetrieveAndGenerateStream")
    "RetrieveAndGenerateConfiguration_Type"=@("Invoke-BARRetrieveAndGenerate","Invoke-BARRetrieveAndGenerateStream")
    "Stream_ExternalSourcesConfig_PerformanceConfig_Latency"=@("Invoke-BARRetrieveAndGenerateStream")
    "Stream_KnowledgeBaseConfig_GenerationConfig_PerformanceConfig_Latency"=@("Invoke-BARRetrieveAndGenerateStream")
    "Stream_KnowledgeBaseConfig_OrchestrationConfig_PerformanceConfig_Latency"=@("Invoke-BARRetrieveAndGenerateStream")
    "TextToSqlConfiguration_Type"=@("Invoke-BARGenerateQuery")
    "TransformationConfiguration_Mode"=@("Invoke-BARGenerateQuery")
    "VectorSearchConfiguration_OverrideSearchType"=@("Invoke-BARRetrieve","Invoke-BARRetrieveAndGenerate","Invoke-BARRetrieveAndGenerateStream")
}

_awsArgumentCompleterRegistration $BAR_Completers $BAR_map

$BAR_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.BAR.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BAR_SelectMap = @{
    "Select"=@("New-BARInvocation",
               "New-BARSession",
               "Remove-BARAgentMemory",
               "Remove-BARSession",
               "Close-BARSession",
               "Invoke-BARGenerateQuery",
               "Get-BARAgentMemory",
               "Get-BARExecutionFlowSnapshot",
               "Get-BARFlowExecution",
               "Get-BARInvocationStep",
               "Get-BARSession",
               "Invoke-BARAgent",
               "Invoke-BARFlow",
               "Invoke-BARInlineAgent",
               "Get-BARFlowExecutionEventList",
               "Get-BARFlowExecutionList",
               "Get-BARInvocationList",
               "Get-BARInvocationStepList",
               "Get-BARSessionList",
               "Get-BARResourceTag",
               "Get-BAROptimizePrompt",
               "Write-BARInvocationStep",
               "Invoke-BARRerank",
               "Invoke-BARRetrieve",
               "Invoke-BARRetrieveAndGenerate",
               "Invoke-BARRetrieveAndGenerateStream",
               "Start-BARFlowExecution",
               "Stop-BARFlowExecution",
               "Add-BARResourceTag",
               "Remove-BARResourceTag",
               "Update-BARSession")
}

_awsArgumentCompleterRegistration $BAR_SelectCompleters $BAR_SelectMap
# Argument completions for service Agents for Amazon Bedrock


$AAB_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.BedrockAgent.ActionGroupSignature
        {
            ($_ -eq "New-AABAgentActionGroup/ParentActionGroupSignature") -Or
            ($_ -eq "Update-AABAgentActionGroup/ParentActionGroupSignature")
        }
        {
            $v = "AMAZON.CodeInterpreter","AMAZON.UserInput","ANTHROPIC.Bash","ANTHROPIC.Computer","ANTHROPIC.TextEditor"
            break
        }

        # Amazon.BedrockAgent.ActionGroupState
        {
            ($_ -eq "New-AABAgentActionGroup/ActionGroupState") -Or
            ($_ -eq "Update-AABAgentActionGroup/ActionGroupState")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.BedrockAgent.AgentCollaboration
        {
            ($_ -eq "New-AABAgent/AgentCollaboration") -Or
            ($_ -eq "Update-AABAgent/AgentCollaboration")
        }
        {
            $v = "DISABLED","SUPERVISOR","SUPERVISOR_ROUTER"
            break
        }

        # Amazon.BedrockAgent.AliasInvocationState
        "Update-AABAgentAlias/AliasInvocationState"
        {
            $v = "ACCEPT_INVOCATIONS","REJECT_INVOCATIONS"
            break
        }

        # Amazon.BedrockAgent.ChunkingStrategy
        {
            ($_ -eq "New-AABDataSource/ChunkingConfiguration_ChunkingStrategy") -Or
            ($_ -eq "Update-AABDataSource/ChunkingConfiguration_ChunkingStrategy")
        }
        {
            $v = "FIXED_SIZE","HIERARCHICAL","NONE","SEMANTIC"
            break
        }

        # Amazon.BedrockAgent.ConcurrencyType
        {
            ($_ -eq "New-AABFlowAlias/ConcurrencyConfiguration_Type") -Or
            ($_ -eq "Update-AABFlowAlias/ConcurrencyConfiguration_Type")
        }
        {
            $v = "Automatic","Manual"
            break
        }

        # Amazon.BedrockAgent.ConfluenceAuthType
        {
            ($_ -eq "New-AABDataSource/DataSourceConfiguration_ConfluenceConfiguration_SourceConfiguration_AuthType") -Or
            ($_ -eq "Update-AABDataSource/DataSourceConfiguration_ConfluenceConfiguration_SourceConfiguration_AuthType")
        }
        {
            $v = "BASIC","OAUTH2_CLIENT_CREDENTIALS"
            break
        }

        # Amazon.BedrockAgent.ConfluenceHostType
        {
            ($_ -eq "New-AABDataSource/DataSourceConfiguration_ConfluenceConfiguration_SourceConfiguration_HostType") -Or
            ($_ -eq "Update-AABDataSource/DataSourceConfiguration_ConfluenceConfiguration_SourceConfiguration_HostType")
        }
        {
            $v = "SAAS"
            break
        }

        # Amazon.BedrockAgent.ContextEnrichmentType
        {
            ($_ -eq "New-AABDataSource/ContextEnrichmentConfiguration_Type") -Or
            ($_ -eq "Update-AABDataSource/ContextEnrichmentConfiguration_Type")
        }
        {
            $v = "BEDROCK_FOUNDATION_MODEL"
            break
        }

        # Amazon.BedrockAgent.CrawlFilterConfigurationType
        {
            ($_ -eq "New-AABDataSource/DataSourceConfiguration_ConfluenceConfiguration_CrawlerConfiguration_FilterConfiguration_Type") -Or
            ($_ -eq "Update-AABDataSource/DataSourceConfiguration_ConfluenceConfiguration_CrawlerConfiguration_FilterConfiguration_Type") -Or
            ($_ -eq "New-AABDataSource/DataSourceConfiguration_SalesforceConfiguration_CrawlerConfiguration_FilterConfiguration_Type") -Or
            ($_ -eq "Update-AABDataSource/DataSourceConfiguration_SalesforceConfiguration_CrawlerConfiguration_FilterConfiguration_Type") -Or
            ($_ -eq "New-AABDataSource/DataSourceConfiguration_SharePointConfiguration_CrawlerConfiguration_FilterConfiguration_Type") -Or
            ($_ -eq "Update-AABDataSource/DataSourceConfiguration_SharePointConfiguration_CrawlerConfiguration_FilterConfiguration_Type")
        }
        {
            $v = "PATTERN"
            break
        }

        # Amazon.BedrockAgent.CustomControlMethod
        {
            ($_ -eq "New-AABAgentActionGroup/ActionGroupExecutor_CustomControl") -Or
            ($_ -eq "Update-AABAgentActionGroup/ActionGroupExecutor_CustomControl")
        }
        {
            $v = "RETURN_CONTROL"
            break
        }

        # Amazon.BedrockAgent.DataDeletionPolicy
        {
            ($_ -eq "New-AABDataSource/DataDeletionPolicy") -Or
            ($_ -eq "Update-AABDataSource/DataDeletionPolicy")
        }
        {
            $v = "DELETE","RETAIN"
            break
        }

        # Amazon.BedrockAgent.DataSourceType
        {
            ($_ -eq "New-AABDataSource/DataSourceConfiguration_Type") -Or
            ($_ -eq "Update-AABDataSource/DataSourceConfiguration_Type")
        }
        {
            $v = "CONFLUENCE","CUSTOM","REDSHIFT_METADATA","S3","SALESFORCE","SHAREPOINT","WEB"
            break
        }

        # Amazon.BedrockAgent.EmbeddingDataType
        {
            ($_ -eq "New-AABKnowledgeBase/BedrockEmbeddingModelConfiguration_EmbeddingDataType") -Or
            ($_ -eq "Update-AABKnowledgeBase/BedrockEmbeddingModelConfiguration_EmbeddingDataType")
        }
        {
            $v = "BINARY","FLOAT32"
            break
        }

        # Amazon.BedrockAgent.EnrichmentStrategyMethod
        {
            ($_ -eq "New-AABDataSource/EnrichmentStrategyConfiguration_Method") -Or
            ($_ -eq "Update-AABDataSource/EnrichmentStrategyConfiguration_Method")
        }
        {
            $v = "CHUNK_ENTITY_EXTRACTION"
            break
        }

        # Amazon.BedrockAgent.IngestionJobSortByAttribute
        "Get-AABIngestionJobList/SortBy_Attribute"
        {
            $v = "STARTED_AT","STATUS"
            break
        }

        # Amazon.BedrockAgent.KnowledgeBaseState
        {
            ($_ -eq "Register-AABAgentKnowledgeBase/KnowledgeBaseState") -Or
            ($_ -eq "Update-AABAgentKnowledgeBase/KnowledgeBaseState")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.BedrockAgent.KnowledgeBaseStorageType
        {
            ($_ -eq "New-AABKnowledgeBase/StorageConfiguration_Type") -Or
            ($_ -eq "Update-AABKnowledgeBase/StorageConfiguration_Type")
        }
        {
            $v = "MONGO_DB_ATLAS","NEPTUNE_ANALYTICS","OPENSEARCH_MANAGED_CLUSTER","OPENSEARCH_SERVERLESS","PINECONE","RDS","REDIS_ENTERPRISE_CLOUD","S3_VECTORS"
            break
        }

        # Amazon.BedrockAgent.KnowledgeBaseType
        {
            ($_ -eq "New-AABKnowledgeBase/KnowledgeBaseConfiguration_Type") -Or
            ($_ -eq "Update-AABKnowledgeBase/KnowledgeBaseConfiguration_Type")
        }
        {
            $v = "KENDRA","SQL","VECTOR"
            break
        }

        # Amazon.BedrockAgent.OrchestrationType
        {
            ($_ -eq "New-AABAgent/OrchestrationType") -Or
            ($_ -eq "Update-AABAgent/OrchestrationType")
        }
        {
            $v = "CUSTOM_ORCHESTRATION","DEFAULT"
            break
        }

        # Amazon.BedrockAgent.ParsingModality
        {
            ($_ -eq "New-AABDataSource/BedrockDataAutomationConfiguration_ParsingModality") -Or
            ($_ -eq "Update-AABDataSource/BedrockDataAutomationConfiguration_ParsingModality") -Or
            ($_ -eq "New-AABDataSource/BedrockFoundationModelConfiguration_ParsingModality") -Or
            ($_ -eq "Update-AABDataSource/BedrockFoundationModelConfiguration_ParsingModality")
        }
        {
            $v = "MULTIMODAL"
            break
        }

        # Amazon.BedrockAgent.ParsingStrategy
        {
            ($_ -eq "New-AABDataSource/ParsingConfiguration_ParsingStrategy") -Or
            ($_ -eq "Update-AABDataSource/ParsingConfiguration_ParsingStrategy")
        }
        {
            $v = "BEDROCK_DATA_AUTOMATION","BEDROCK_FOUNDATION_MODEL"
            break
        }

        # Amazon.BedrockAgent.QueryEngineType
        {
            ($_ -eq "New-AABKnowledgeBase/SqlKnowledgeBaseConfiguration_Type") -Or
            ($_ -eq "Update-AABKnowledgeBase/SqlKnowledgeBaseConfiguration_Type")
        }
        {
            $v = "REDSHIFT"
            break
        }

        # Amazon.BedrockAgent.RedshiftProvisionedAuthType
        {
            ($_ -eq "New-AABKnowledgeBase/KnowledgeBaseConfiguration_SqlKnowledgeBaseConfiguration_RedshiftConfiguration_QueryEngineConfiguration_ProvisionedConfiguration_AuthConfiguration_Type") -Or
            ($_ -eq "Update-AABKnowledgeBase/KnowledgeBaseConfiguration_SqlKnowledgeBaseConfiguration_RedshiftConfiguration_QueryEngineConfiguration_ProvisionedConfiguration_AuthConfiguration_Type")
        }
        {
            $v = "IAM","USERNAME","USERNAME_PASSWORD"
            break
        }

        # Amazon.BedrockAgent.RedshiftQueryEngineType
        {
            ($_ -eq "New-AABKnowledgeBase/QueryEngineConfiguration_Type") -Or
            ($_ -eq "Update-AABKnowledgeBase/QueryEngineConfiguration_Type")
        }
        {
            $v = "PROVISIONED","SERVERLESS"
            break
        }

        # Amazon.BedrockAgent.RedshiftServerlessAuthType
        {
            ($_ -eq "New-AABKnowledgeBase/AuthConfiguration_Type") -Or
            ($_ -eq "Update-AABKnowledgeBase/AuthConfiguration_Type")
        }
        {
            $v = "IAM","USERNAME_PASSWORD"
            break
        }

        # Amazon.BedrockAgent.RelayConversationHistory
        {
            ($_ -eq "Register-AABAgentCollaborator/RelayConversationHistory") -Or
            ($_ -eq "Update-AABAgentCollaborator/RelayConversationHistory")
        }
        {
            $v = "DISABLED","TO_COLLABORATOR"
            break
        }

        # Amazon.BedrockAgent.SalesforceAuthType
        {
            ($_ -eq "New-AABDataSource/DataSourceConfiguration_SalesforceConfiguration_SourceConfiguration_AuthType") -Or
            ($_ -eq "Update-AABDataSource/DataSourceConfiguration_SalesforceConfiguration_SourceConfiguration_AuthType")
        }
        {
            $v = "OAUTH2_CLIENT_CREDENTIALS"
            break
        }

        # Amazon.BedrockAgent.SharePointAuthType
        {
            ($_ -eq "New-AABDataSource/DataSourceConfiguration_SharePointConfiguration_SourceConfiguration_AuthType") -Or
            ($_ -eq "Update-AABDataSource/DataSourceConfiguration_SharePointConfiguration_SourceConfiguration_AuthType")
        }
        {
            $v = "OAUTH2_CLIENT_CREDENTIALS","OAUTH2_SHAREPOINT_APP_ONLY_CLIENT_CREDENTIALS"
            break
        }

        # Amazon.BedrockAgent.SharePointHostType
        {
            ($_ -eq "New-AABDataSource/DataSourceConfiguration_SharePointConfiguration_SourceConfiguration_HostType") -Or
            ($_ -eq "Update-AABDataSource/DataSourceConfiguration_SharePointConfiguration_SourceConfiguration_HostType")
        }
        {
            $v = "ONLINE"
            break
        }

        # Amazon.BedrockAgent.SortOrder
        "Get-AABIngestionJobList/SortBy_Order"
        {
            $v = "ASCENDING","DESCENDING"
            break
        }

        # Amazon.BedrockAgent.WebScopeType
        {
            ($_ -eq "New-AABDataSource/CrawlerConfiguration_Scope") -Or
            ($_ -eq "Update-AABDataSource/CrawlerConfiguration_Scope")
        }
        {
            $v = "HOST_ONLY","SUBDOMAINS"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AAB_map = @{
    "ActionGroupExecutor_CustomControl"=@("New-AABAgentActionGroup","Update-AABAgentActionGroup")
    "ActionGroupState"=@("New-AABAgentActionGroup","Update-AABAgentActionGroup")
    "AgentCollaboration"=@("New-AABAgent","Update-AABAgent")
    "AliasInvocationState"=@("Update-AABAgentAlias")
    "AuthConfiguration_Type"=@("New-AABKnowledgeBase","Update-AABKnowledgeBase")
    "BedrockDataAutomationConfiguration_ParsingModality"=@("New-AABDataSource","Update-AABDataSource")
    "BedrockEmbeddingModelConfiguration_EmbeddingDataType"=@("New-AABKnowledgeBase","Update-AABKnowledgeBase")
    "BedrockFoundationModelConfiguration_ParsingModality"=@("New-AABDataSource","Update-AABDataSource")
    "ChunkingConfiguration_ChunkingStrategy"=@("New-AABDataSource","Update-AABDataSource")
    "ConcurrencyConfiguration_Type"=@("New-AABFlowAlias","Update-AABFlowAlias")
    "ContextEnrichmentConfiguration_Type"=@("New-AABDataSource","Update-AABDataSource")
    "CrawlerConfiguration_Scope"=@("New-AABDataSource","Update-AABDataSource")
    "DataDeletionPolicy"=@("New-AABDataSource","Update-AABDataSource")
    "DataSourceConfiguration_ConfluenceConfiguration_CrawlerConfiguration_FilterConfiguration_Type"=@("New-AABDataSource","Update-AABDataSource")
    "DataSourceConfiguration_ConfluenceConfiguration_SourceConfiguration_AuthType"=@("New-AABDataSource","Update-AABDataSource")
    "DataSourceConfiguration_ConfluenceConfiguration_SourceConfiguration_HostType"=@("New-AABDataSource","Update-AABDataSource")
    "DataSourceConfiguration_SalesforceConfiguration_CrawlerConfiguration_FilterConfiguration_Type"=@("New-AABDataSource","Update-AABDataSource")
    "DataSourceConfiguration_SalesforceConfiguration_SourceConfiguration_AuthType"=@("New-AABDataSource","Update-AABDataSource")
    "DataSourceConfiguration_SharePointConfiguration_CrawlerConfiguration_FilterConfiguration_Type"=@("New-AABDataSource","Update-AABDataSource")
    "DataSourceConfiguration_SharePointConfiguration_SourceConfiguration_AuthType"=@("New-AABDataSource","Update-AABDataSource")
    "DataSourceConfiguration_SharePointConfiguration_SourceConfiguration_HostType"=@("New-AABDataSource","Update-AABDataSource")
    "DataSourceConfiguration_Type"=@("New-AABDataSource","Update-AABDataSource")
    "EnrichmentStrategyConfiguration_Method"=@("New-AABDataSource","Update-AABDataSource")
    "KnowledgeBaseConfiguration_SqlKnowledgeBaseConfiguration_RedshiftConfiguration_QueryEngineConfiguration_ProvisionedConfiguration_AuthConfiguration_Type"=@("New-AABKnowledgeBase","Update-AABKnowledgeBase")
    "KnowledgeBaseConfiguration_Type"=@("New-AABKnowledgeBase","Update-AABKnowledgeBase")
    "KnowledgeBaseState"=@("Register-AABAgentKnowledgeBase","Update-AABAgentKnowledgeBase")
    "OrchestrationType"=@("New-AABAgent","Update-AABAgent")
    "ParentActionGroupSignature"=@("New-AABAgentActionGroup","Update-AABAgentActionGroup")
    "ParsingConfiguration_ParsingStrategy"=@("New-AABDataSource","Update-AABDataSource")
    "QueryEngineConfiguration_Type"=@("New-AABKnowledgeBase","Update-AABKnowledgeBase")
    "RelayConversationHistory"=@("Register-AABAgentCollaborator","Update-AABAgentCollaborator")
    "SortBy_Attribute"=@("Get-AABIngestionJobList")
    "SortBy_Order"=@("Get-AABIngestionJobList")
    "SqlKnowledgeBaseConfiguration_Type"=@("New-AABKnowledgeBase","Update-AABKnowledgeBase")
    "StorageConfiguration_Type"=@("New-AABKnowledgeBase","Update-AABKnowledgeBase")
}

_awsArgumentCompleterRegistration $AAB_Completers $AAB_map

$AAB_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.AAB.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AAB_SelectMap = @{
    "Select"=@("Register-AABAgentCollaborator",
               "Register-AABAgentKnowledgeBase",
               "New-AABAgent",
               "New-AABAgentActionGroup",
               "New-AABAgentAlias",
               "New-AABDataSource",
               "New-AABFlow",
               "New-AABFlowAlias",
               "New-AABFlowVersion",
               "New-AABKnowledgeBase",
               "New-AABPrompt",
               "New-AABPromptVersion",
               "Remove-AABAgent",
               "Remove-AABAgentActionGroup",
               "Remove-AABAgentAlias",
               "Remove-AABAgentVersion",
               "Remove-AABDataSource",
               "Remove-AABFlow",
               "Remove-AABFlowAlias",
               "Remove-AABFlowVersion",
               "Remove-AABKnowledgeBase",
               "Remove-AABKnowledgeBaseDocument",
               "Remove-AABPrompt",
               "Unregister-AABAgentCollaborator",
               "Unregister-AABAgentKnowledgeBase",
               "Get-AABAgent",
               "Get-AABAgentActionGroup",
               "Get-AABAgentAlias",
               "Get-AABAgentCollaborator",
               "Get-AABAgentKnowledgeBase",
               "Get-AABAgentVersion",
               "Get-AABDataSource",
               "Get-AABFlow",
               "Get-AABFlowAlias",
               "Get-AABFlowVersion",
               "Get-AABIngestionJob",
               "Get-AABKnowledgeBase",
               "Get-AABKnowledgeBaseDocument",
               "Get-AABPrompt",
               "Add-AABKnowledgeBaseDocument",
               "Get-AABAgentActionGroupList",
               "Get-AABAgentAliasList",
               "Get-AABAgentCollaboratorList",
               "Get-AABAgentKnowledgeBasisList",
               "Get-AABAgentList",
               "Get-AABAgentVersionList",
               "Get-AABDataSourceList",
               "Get-AABFlowAliasList",
               "Get-AABFlowList",
               "Get-AABFlowVersionList",
               "Get-AABIngestionJobList",
               "Get-AABKnowledgeBaseDocumentList",
               "Get-AABKnowledgeBasisList",
               "Get-AABPromptList",
               "Get-AABResourceTag",
               "Initialize-AABAgent",
               "Initialize-AABFlow",
               "Start-AABIngestionJob",
               "Stop-AABIngestionJob",
               "Add-AABResourceTag",
               "Remove-AABResourceTag",
               "Update-AABAgent",
               "Update-AABAgentActionGroup",
               "Update-AABAgentAlias",
               "Update-AABAgentCollaborator",
               "Update-AABAgentKnowledgeBase",
               "Update-AABDataSource",
               "Update-AABFlow",
               "Update-AABFlowAlias",
               "Update-AABKnowledgeBase",
               "Update-AABPrompt",
               "Confirm-AABFlowDefinition")
}

_awsArgumentCompleterRegistration $AAB_SelectCompleters $AAB_SelectMap
# Argument completions for service Amazon Bedrock Agent Core Control Plane Fronting Layer


$BACC_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.BedrockAgentCoreControl.AuthorizerType
        {
            ($_ -eq "New-BACCGateway/AuthorizerType") -Or
            ($_ -eq "Update-BACCGateway/AuthorizerType")
        }
        {
            $v = "AWS_IAM","CUSTOM_JWT"
            break
        }

        # Amazon.BedrockAgentCoreControl.BrowserNetworkMode
        "New-BACCBrowser/NetworkConfiguration_NetworkMode"
        {
            $v = "PUBLIC","VPC"
            break
        }

        # Amazon.BedrockAgentCoreControl.CodeInterpreterNetworkMode
        "New-BACCCodeInterpreter/NetworkConfiguration_NetworkMode"
        {
            $v = "PUBLIC","SANDBOX","VPC"
            break
        }

        # Amazon.BedrockAgentCoreControl.CredentialProviderVendorType
        {
            ($_ -eq "New-BACCOauth2CredentialProvider/CredentialProviderVendor") -Or
            ($_ -eq "Update-BACCOauth2CredentialProvider/CredentialProviderVendor")
        }
        {
            $v = "AtlassianOauth2","Auth0Oauth2","CognitoOauth2","CustomOauth2","CyberArkOauth2","DropboxOauth2","FacebookOauth2","FusionAuthOauth2","GithubOauth2","GoogleOauth2","HubspotOauth2","LinkedinOauth2","MicrosoftOauth2","NotionOauth2","OktaOauth2","OneLoginOauth2","PingOneOauth2","RedditOauth2","SalesforceOauth2","SlackOauth2","SpotifyOauth2","TwitchOauth2","XOauth2","YandexOauth2","ZoomOauth2"
            break
        }

        # Amazon.BedrockAgentCoreControl.ExceptionLevel
        {
            ($_ -eq "New-BACCGateway/ExceptionLevel") -Or
            ($_ -eq "Update-BACCGateway/ExceptionLevel")
        }
        {
            $v = "DEBUG"
            break
        }

        # Amazon.BedrockAgentCoreControl.GatewayProtocolType
        {
            ($_ -eq "New-BACCGateway/ProtocolType") -Or
            ($_ -eq "Update-BACCGateway/ProtocolType")
        }
        {
            $v = "MCP"
            break
        }

        # Amazon.BedrockAgentCoreControl.KeyType
        "Set-BACCTokenVaultCMK/KmsConfiguration_KeyType"
        {
            $v = "CustomerManagedKey","ServiceManagedKey"
            break
        }

        # Amazon.BedrockAgentCoreControl.NetworkMode
        {
            ($_ -eq "New-BACCAgentRuntime/NetworkConfiguration_NetworkMode") -Or
            ($_ -eq "Update-BACCAgentRuntime/NetworkConfiguration_NetworkMode")
        }
        {
            $v = "PUBLIC","VPC"
            break
        }

        # Amazon.BedrockAgentCoreControl.ResourceType
        {
            ($_ -eq "Get-BACCBrowserList/Type") -Or
            ($_ -eq "Get-BACCCodeInterpreterList/Type")
        }
        {
            $v = "CUSTOM","SYSTEM"
            break
        }

        # Amazon.BedrockAgentCoreControl.SearchType
        {
            ($_ -eq "New-BACCGateway/Mcp_SearchType") -Or
            ($_ -eq "Update-BACCGateway/Mcp_SearchType")
        }
        {
            $v = "SEMANTIC"
            break
        }

        # Amazon.BedrockAgentCoreControl.ServerProtocol
        {
            ($_ -eq "New-BACCAgentRuntime/ProtocolConfiguration_ServerProtocol") -Or
            ($_ -eq "Update-BACCAgentRuntime/ProtocolConfiguration_ServerProtocol")
        }
        {
            $v = "A2A","HTTP","MCP"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BACC_map = @{
    "AuthorizerType"=@("New-BACCGateway","Update-BACCGateway")
    "CredentialProviderVendor"=@("New-BACCOauth2CredentialProvider","Update-BACCOauth2CredentialProvider")
    "ExceptionLevel"=@("New-BACCGateway","Update-BACCGateway")
    "KmsConfiguration_KeyType"=@("Set-BACCTokenVaultCMK")
    "Mcp_SearchType"=@("New-BACCGateway","Update-BACCGateway")
    "NetworkConfiguration_NetworkMode"=@("New-BACCAgentRuntime","New-BACCBrowser","New-BACCCodeInterpreter","Update-BACCAgentRuntime")
    "ProtocolConfiguration_ServerProtocol"=@("New-BACCAgentRuntime","Update-BACCAgentRuntime")
    "ProtocolType"=@("New-BACCGateway","Update-BACCGateway")
    "Type"=@("Get-BACCBrowserList","Get-BACCCodeInterpreterList")
}

_awsArgumentCompleterRegistration $BACC_Completers $BACC_map

$BACC_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.BACC.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BACC_SelectMap = @{
    "Select"=@("New-BACCAgentRuntime",
               "New-BACCAgentRuntimeEndpoint",
               "New-BACCApiKeyCredentialProvider",
               "New-BACCBrowser",
               "New-BACCCodeInterpreter",
               "New-BACCGateway",
               "New-BACCGatewayTarget",
               "New-BACCMemory",
               "New-BACCOauth2CredentialProvider",
               "New-BACCWorkloadIdentity",
               "Remove-BACCAgentRuntime",
               "Remove-BACCAgentRuntimeEndpoint",
               "Remove-BACCApiKeyCredentialProvider",
               "Remove-BACCBrowser",
               "Remove-BACCCodeInterpreter",
               "Remove-BACCGateway",
               "Remove-BACCGatewayTarget",
               "Remove-BACCMemory",
               "Remove-BACCOauth2CredentialProvider",
               "Remove-BACCWorkloadIdentity",
               "Get-BACCAgentRuntime",
               "Get-BACCAgentRuntimeEndpoint",
               "Get-BACCApiKeyCredentialProvider",
               "Get-BACCBrowser",
               "Get-BACCCodeInterpreter",
               "Get-BACCGateway",
               "Get-BACCGatewayTarget",
               "Get-BACCMemory",
               "Get-BACCOauth2CredentialProvider",
               "Get-BACCTokenVault",
               "Get-BACCWorkloadIdentity",
               "Get-BACCAgentRuntimeEndpointList",
               "Get-BACCAgentRuntimeList",
               "Get-BACCAgentRuntimeVersionList",
               "Get-BACCApiKeyCredentialProviderList",
               "Get-BACCBrowserList",
               "Get-BACCCodeInterpreterList",
               "Get-BACCGatewayList",
               "Get-BACCGatewayTargetList",
               "Get-BACCMemoryList",
               "Get-BACCOauth2CredentialProviderList",
               "Get-BACCResourceTag",
               "Get-BACCWorkloadIdentityList",
               "Set-BACCTokenVaultCMK",
               "Sync-BACCGatewayTarget",
               "Add-BACCResourceTag",
               "Remove-BACCResourceTag",
               "Update-BACCAgentRuntime",
               "Update-BACCAgentRuntimeEndpoint",
               "Update-BACCApiKeyCredentialProvider",
               "Update-BACCGateway",
               "Update-BACCGatewayTarget",
               "Update-BACCMemory",
               "Update-BACCOauth2CredentialProvider",
               "Update-BACCWorkloadIdentity")
}

_awsArgumentCompleterRegistration $BACC_SelectCompleters $BACC_SelectMap
# Argument completions for service Amazon Bedrock AgentCore Data Plane Fronting Layer


$BAC_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.BedrockAgentCore.AutomationStreamStatus
        "Update-BACBrowserStream/AutomationStreamUpdate_StreamStatus"
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.BedrockAgentCore.BrowserSessionStatus
        "Get-BACBrowserSessionList/Status"
        {
            $v = "READY","TERMINATED"
            break
        }

        # Amazon.BedrockAgentCore.CodeInterpreterSessionStatus
        "Get-BACCodeInterpreterSessionList/Status"
        {
            $v = "READY","TERMINATED"
            break
        }

        # Amazon.BedrockAgentCore.Oauth2FlowType
        "Get-BACResourceOauth2Token/Oauth2Flow"
        {
            $v = "M2M","USER_FEDERATION"
            break
        }

        # Amazon.BedrockAgentCore.ProgrammingLanguage
        "Invoke-BACCodeInterpreter/Arguments_Language"
        {
            $v = "javascript","python","typescript"
            break
        }

        # Amazon.BedrockAgentCore.ToolName
        "Invoke-BACCodeInterpreter/Name"
        {
            $v = "executeCode","executeCommand","getTask","listFiles","readFiles","removeFiles","startCommandExecution","stopTask","writeFiles"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BAC_map = @{
    "Arguments_Language"=@("Invoke-BACCodeInterpreter")
    "AutomationStreamUpdate_StreamStatus"=@("Update-BACBrowserStream")
    "Name"=@("Invoke-BACCodeInterpreter")
    "Oauth2Flow"=@("Get-BACResourceOauth2Token")
    "Status"=@("Get-BACBrowserSessionList","Get-BACCodeInterpreterSessionList")
}

_awsArgumentCompleterRegistration $BAC_Completers $BAC_map

$BAC_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.BAC.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BAC_SelectMap = @{
    "Select"=@("New-BACBatchMemoryRecord",
               "Remove-BACBatchMemoryRecord",
               "Update-BACBatchMemoryRecord",
               "Complete-BACResourceTokenAuth",
               "New-BACEvent",
               "Remove-BACEvent",
               "Remove-BACMemoryRecord",
               "Get-BACAgentCard",
               "Get-BACBrowserSession",
               "Get-BACCodeInterpreterSession",
               "Get-BACEvent",
               "Get-BACMemoryRecord",
               "Get-BACResourceApiKey",
               "Get-BACResourceOauth2Token",
               "Get-BACWorkloadAccessToken",
               "Get-BACWorkloadAccessTokenForJWT",
               "Get-BACWorkloadAccessTokenForUserId",
               "Invoke-BACAgentRuntime",
               "Invoke-BACCodeInterpreter",
               "Get-BACActorList",
               "Get-BACBrowserSessionList",
               "Get-BACCodeInterpreterSessionList",
               "Get-BACEventList",
               "Get-BACMemoryRecordList",
               "Get-BACSessionList",
               "Invoke-BACMemoryRecord",
               "Start-BACBrowserSession",
               "Start-BACCodeInterpreterSession",
               "Stop-BACBrowserSession",
               "Stop-BACCodeInterpreterSession",
               "Stop-BACRuntimeSession",
               "Update-BACBrowserStream")
}

_awsArgumentCompleterRegistration $BAC_SelectCompleters $BAC_SelectMap
# Argument completions for service Runtime for Amazon Bedrock Data Automation


$BDAR_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.BedrockDataAutomationRuntime.DataAutomationStage
        "Invoke-BDARDataAutomationAsync/DataAutomationConfiguration_Stage"
        {
            $v = "DEVELOPMENT","LIVE"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BDAR_map = @{
    "DataAutomationConfiguration_Stage"=@("Invoke-BDARDataAutomationAsync")
}

_awsArgumentCompleterRegistration $BDAR_Completers $BDAR_map

$BDAR_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.BDAR.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BDAR_SelectMap = @{
    "Select"=@("Get-BDARDataAutomationStatus",
               "Invoke-BDARDataAutomationAsync",
               "Get-BDARResourceTag",
               "Add-BDARResourceTag",
               "Remove-BDARResourceTag")
}

_awsArgumentCompleterRegistration $BDAR_SelectCompleters $BDAR_SelectMap
# Argument completions for service Data Automation for Amazon Bedrock


$BDA_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.BedrockDataAutomation.BlueprintStage
        {
            ($_ -eq "Get-BDADataAutomationProjectList/BlueprintFilter_BlueprintStage") -Or
            ($_ -eq "Get-BDABlueprint/BlueprintStage") -Or
            ($_ -eq "New-BDABlueprint/BlueprintStage") -Or
            ($_ -eq "Update-BDABlueprint/BlueprintStage")
        }
        {
            $v = "DEVELOPMENT","LIVE"
            break
        }

        # Amazon.BedrockDataAutomation.BlueprintStageFilter
        "Get-BDABlueprintList/BlueprintStageFilter"
        {
            $v = "ALL","DEVELOPMENT","LIVE"
            break
        }

        # Amazon.BedrockDataAutomation.DataAutomationProjectStage
        {
            ($_ -eq "Get-BDABlueprintList/ProjectFilter_ProjectStage") -Or
            ($_ -eq "Get-BDADataAutomationProject/ProjectStage") -Or
            ($_ -eq "New-BDADataAutomationProject/ProjectStage") -Or
            ($_ -eq "Update-BDADataAutomationProject/ProjectStage")
        }
        {
            $v = "DEVELOPMENT","LIVE"
            break
        }

        # Amazon.BedrockDataAutomation.DataAutomationProjectStageFilter
        "Get-BDADataAutomationProjectList/ProjectStageFilter"
        {
            $v = "ALL","DEVELOPMENT","LIVE"
            break
        }

        # Amazon.BedrockDataAutomation.DesiredModality
        {
            ($_ -eq "New-BDADataAutomationProject/ModalityRouting_Jpeg") -Or
            ($_ -eq "Update-BDADataAutomationProject/ModalityRouting_Jpeg") -Or
            ($_ -eq "New-BDADataAutomationProject/ModalityRouting_Mov") -Or
            ($_ -eq "Update-BDADataAutomationProject/ModalityRouting_Mov") -Or
            ($_ -eq "New-BDADataAutomationProject/ModalityRouting_Mp4") -Or
            ($_ -eq "Update-BDADataAutomationProject/ModalityRouting_Mp4") -Or
            ($_ -eq "New-BDADataAutomationProject/ModalityRouting_Png") -Or
            ($_ -eq "Update-BDADataAutomationProject/ModalityRouting_Png")
        }
        {
            $v = "AUDIO","DOCUMENT","IMAGE","VIDEO"
            break
        }

        # Amazon.BedrockDataAutomation.ResourceOwner
        {
            ($_ -eq "Get-BDABlueprintList/ResourceOwner") -Or
            ($_ -eq "Get-BDADataAutomationProjectList/ResourceOwner")
        }
        {
            $v = "ACCOUNT","SERVICE"
            break
        }

        # Amazon.BedrockDataAutomation.State
        {
            ($_ -eq "New-BDADataAutomationProject/AdditionalFileFormat_State") -Or
            ($_ -eq "Update-BDADataAutomationProject/AdditionalFileFormat_State") -Or
            ($_ -eq "New-BDADataAutomationProject/ChannelLabeling_State") -Or
            ($_ -eq "Update-BDADataAutomationProject/ChannelLabeling_State") -Or
            ($_ -eq "New-BDADataAutomationProject/OverrideConfiguration_Audio_ModalityProcessing_State") -Or
            ($_ -eq "Update-BDADataAutomationProject/OverrideConfiguration_Audio_ModalityProcessing_State") -Or
            ($_ -eq "New-BDADataAutomationProject/OverrideConfiguration_Document_ModalityProcessing_State") -Or
            ($_ -eq "Update-BDADataAutomationProject/OverrideConfiguration_Document_ModalityProcessing_State") -Or
            ($_ -eq "New-BDADataAutomationProject/OverrideConfiguration_Image_ModalityProcessing_State") -Or
            ($_ -eq "Update-BDADataAutomationProject/OverrideConfiguration_Image_ModalityProcessing_State") -Or
            ($_ -eq "New-BDADataAutomationProject/OverrideConfiguration_Video_ModalityProcessing_State") -Or
            ($_ -eq "Update-BDADataAutomationProject/OverrideConfiguration_Video_ModalityProcessing_State") -Or
            ($_ -eq "New-BDADataAutomationProject/SpeakerLabeling_State") -Or
            ($_ -eq "Update-BDADataAutomationProject/SpeakerLabeling_State") -Or
            ($_ -eq "New-BDADataAutomationProject/Splitter_State") -Or
            ($_ -eq "Update-BDADataAutomationProject/Splitter_State") -Or
            ($_ -eq "New-BDADataAutomationProject/StandardOutputConfiguration_Audio_Extraction_Category_State") -Or
            ($_ -eq "Update-BDADataAutomationProject/StandardOutputConfiguration_Audio_Extraction_Category_State") -Or
            ($_ -eq "New-BDADataAutomationProject/StandardOutputConfiguration_Audio_GenerativeField_State") -Or
            ($_ -eq "Update-BDADataAutomationProject/StandardOutputConfiguration_Audio_GenerativeField_State") -Or
            ($_ -eq "New-BDADataAutomationProject/StandardOutputConfiguration_Document_Extraction_BoundingBox_State") -Or
            ($_ -eq "Update-BDADataAutomationProject/StandardOutputConfiguration_Document_Extraction_BoundingBox_State") -Or
            ($_ -eq "New-BDADataAutomationProject/StandardOutputConfiguration_Document_GenerativeField_State") -Or
            ($_ -eq "Update-BDADataAutomationProject/StandardOutputConfiguration_Document_GenerativeField_State") -Or
            ($_ -eq "New-BDADataAutomationProject/StandardOutputConfiguration_Image_Extraction_BoundingBox_State") -Or
            ($_ -eq "Update-BDADataAutomationProject/StandardOutputConfiguration_Image_Extraction_BoundingBox_State") -Or
            ($_ -eq "New-BDADataAutomationProject/StandardOutputConfiguration_Image_Extraction_Category_State") -Or
            ($_ -eq "Update-BDADataAutomationProject/StandardOutputConfiguration_Image_Extraction_Category_State") -Or
            ($_ -eq "New-BDADataAutomationProject/StandardOutputConfiguration_Image_GenerativeField_State") -Or
            ($_ -eq "Update-BDADataAutomationProject/StandardOutputConfiguration_Image_GenerativeField_State") -Or
            ($_ -eq "New-BDADataAutomationProject/StandardOutputConfiguration_Video_Extraction_BoundingBox_State") -Or
            ($_ -eq "Update-BDADataAutomationProject/StandardOutputConfiguration_Video_Extraction_BoundingBox_State") -Or
            ($_ -eq "New-BDADataAutomationProject/StandardOutputConfiguration_Video_Extraction_Category_State") -Or
            ($_ -eq "Update-BDADataAutomationProject/StandardOutputConfiguration_Video_Extraction_Category_State") -Or
            ($_ -eq "New-BDADataAutomationProject/StandardOutputConfiguration_Video_GenerativeField_State") -Or
            ($_ -eq "Update-BDADataAutomationProject/StandardOutputConfiguration_Video_GenerativeField_State")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.BedrockDataAutomation.Type
        "New-BDABlueprint/Type"
        {
            $v = "AUDIO","DOCUMENT","IMAGE","VIDEO"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BDA_map = @{
    "AdditionalFileFormat_State"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "BlueprintFilter_BlueprintStage"=@("Get-BDADataAutomationProjectList")
    "BlueprintStage"=@("Get-BDABlueprint","New-BDABlueprint","Update-BDABlueprint")
    "BlueprintStageFilter"=@("Get-BDABlueprintList")
    "ChannelLabeling_State"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "ModalityRouting_Jpeg"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "ModalityRouting_Mov"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "ModalityRouting_Mp4"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "ModalityRouting_Png"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "OverrideConfiguration_Audio_ModalityProcessing_State"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "OverrideConfiguration_Document_ModalityProcessing_State"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "OverrideConfiguration_Image_ModalityProcessing_State"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "OverrideConfiguration_Video_ModalityProcessing_State"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "ProjectFilter_ProjectStage"=@("Get-BDABlueprintList")
    "ProjectStage"=@("Get-BDADataAutomationProject","New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "ProjectStageFilter"=@("Get-BDADataAutomationProjectList")
    "ResourceOwner"=@("Get-BDABlueprintList","Get-BDADataAutomationProjectList")
    "SpeakerLabeling_State"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "Splitter_State"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "StandardOutputConfiguration_Audio_Extraction_Category_State"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "StandardOutputConfiguration_Audio_GenerativeField_State"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "StandardOutputConfiguration_Document_Extraction_BoundingBox_State"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "StandardOutputConfiguration_Document_GenerativeField_State"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "StandardOutputConfiguration_Image_Extraction_BoundingBox_State"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "StandardOutputConfiguration_Image_Extraction_Category_State"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "StandardOutputConfiguration_Image_GenerativeField_State"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "StandardOutputConfiguration_Video_Extraction_BoundingBox_State"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "StandardOutputConfiguration_Video_Extraction_Category_State"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "StandardOutputConfiguration_Video_GenerativeField_State"=@("New-BDADataAutomationProject","Update-BDADataAutomationProject")
    "Type"=@("New-BDABlueprint")
}

_awsArgumentCompleterRegistration $BDA_Completers $BDA_map

$BDA_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.BDA.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BDA_SelectMap = @{
    "Select"=@("New-BDABlueprint",
               "New-BDABlueprintVersion",
               "New-BDADataAutomationProject",
               "Remove-BDABlueprint",
               "Remove-BDADataAutomationProject",
               "Get-BDABlueprint",
               "Get-BDADataAutomationProject",
               "Get-BDABlueprintList",
               "Get-BDADataAutomationProjectList",
               "Get-BDAResourceTag",
               "Add-BDAResourceTag",
               "Remove-BDAResourceTag",
               "Update-BDABlueprint",
               "Update-BDADataAutomationProject")
}

_awsArgumentCompleterRegistration $BDA_SelectCompleters $BDA_SelectMap
# Argument completions for service Amazon Bedrock Runtime


$BDRR_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.BedrockRuntime.AsyncInvokeStatus
        "Get-BDRRAsyncInvokeList/StatusEqual"
        {
            $v = "Completed","Failed","InProgress"
            break
        }

        # Amazon.BedrockRuntime.GuardrailContentSource
        "Invoke-BDRRGuardrail/Source"
        {
            $v = "INPUT","OUTPUT"
            break
        }

        # Amazon.BedrockRuntime.GuardrailOutputScope
        "Invoke-BDRRGuardrail/OutputScope"
        {
            $v = "FULL","INTERVENTIONS"
            break
        }

        # Amazon.BedrockRuntime.GuardrailStreamProcessingMode
        "Invoke-BDRRConverseStream/GuardrailConfig_StreamProcessingMode"
        {
            $v = "async","sync"
            break
        }

        # Amazon.BedrockRuntime.GuardrailTrace
        {
            ($_ -eq "Invoke-BDRRConverse/GuardrailConfig_Trace") -Or
            ($_ -eq "Invoke-BDRRConverseStream/GuardrailConfig_Trace")
        }
        {
            $v = "disabled","enabled","enabled_full"
            break
        }

        # Amazon.BedrockRuntime.PerformanceConfigLatency
        {
            ($_ -eq "Invoke-BDRRConverse/PerformanceConfig_Latency") -Or
            ($_ -eq "Invoke-BDRRConverseStream/PerformanceConfig_Latency") -Or
            ($_ -eq "Invoke-BDRRModel/PerformanceConfigLatency") -Or
            ($_ -eq "Invoke-BDRRModelWithResponseStream/PerformanceConfigLatency")
        }
        {
            $v = "optimized","standard"
            break
        }

        # Amazon.BedrockRuntime.SortAsyncInvocationBy
        "Get-BDRRAsyncInvokeList/SortBy"
        {
            $v = "SubmissionTime"
            break
        }

        # Amazon.BedrockRuntime.SortOrder
        "Get-BDRRAsyncInvokeList/SortOrder"
        {
            $v = "Ascending","Descending"
            break
        }

        # Amazon.BedrockRuntime.Trace
        {
            ($_ -eq "Invoke-BDRRModel/Trace") -Or
            ($_ -eq "Invoke-BDRRModelWithResponseStream/Trace")
        }
        {
            $v = "DISABLED","ENABLED","ENABLED_FULL"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BDRR_map = @{
    "GuardrailConfig_StreamProcessingMode"=@("Invoke-BDRRConverseStream")
    "GuardrailConfig_Trace"=@("Invoke-BDRRConverse","Invoke-BDRRConverseStream")
    "OutputScope"=@("Invoke-BDRRGuardrail")
    "PerformanceConfig_Latency"=@("Invoke-BDRRConverse","Invoke-BDRRConverseStream")
    "PerformanceConfigLatency"=@("Invoke-BDRRModel","Invoke-BDRRModelWithResponseStream")
    "SortBy"=@("Get-BDRRAsyncInvokeList")
    "SortOrder"=@("Get-BDRRAsyncInvokeList")
    "Source"=@("Invoke-BDRRGuardrail")
    "StatusEqual"=@("Get-BDRRAsyncInvokeList")
    "Trace"=@("Invoke-BDRRModel","Invoke-BDRRModelWithResponseStream")
}

_awsArgumentCompleterRegistration $BDRR_Completers $BDRR_map

$BDRR_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.BDRR.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BDRR_SelectMap = @{
    "Select"=@("Invoke-BDRRGuardrail",
               "Invoke-BDRRConverse",
               "Invoke-BDRRConverseStream",
               "Get-BDRRCountToken",
               "Get-BDRRAsyncInvoke",
               "Invoke-BDRRModel",
               "Invoke-BDRRModelWithResponseStream",
               "Get-BDRRAsyncInvokeList",
               "Start-BDRRAsyncInvoke")
}

_awsArgumentCompleterRegistration $BDRR_SelectCompleters $BDRR_SelectMap
# Argument completions for service Amazon Bedrock


$BDR_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.Bedrock.ApplicationType
        {
            ($_ -eq "New-BDREvaluationJob/ApplicationType") -Or
            ($_ -eq "Get-BDREvaluationJobList/ApplicationTypeEqual")
        }
        {
            $v = "ModelEvaluation","RagEvaluation"
            break
        }

        # Amazon.Bedrock.AutomatedReasoningCheckResult
        {
            ($_ -eq "New-BDRAutomatedReasoningPolicyTestCase/ExpectedAggregatedFindingsResult") -Or
            ($_ -eq "Update-BDRAutomatedReasoningPolicyTestCase/ExpectedAggregatedFindingsResult")
        }
        {
            $v = "IMPOSSIBLE","INVALID","NO_TRANSLATION","SATISFIABLE","TOO_COMPLEX","TRANSLATION_AMBIGUOUS","VALID"
            break
        }

        # Amazon.Bedrock.AutomatedReasoningPolicyBuildResultAssetType
        "Get-BDRAutomatedReasoningPolicyBuildWorkflowResultAsset/AssetType"
        {
            $v = "BUILD_LOG","POLICY_DEFINITION","QUALITY_REPORT"
            break
        }

        # Amazon.Bedrock.AutomatedReasoningPolicyBuildWorkflowType
        "Start-BDRAutomatedReasoningPolicyBuildWorkflow/BuildWorkflowType"
        {
            $v = "IMPORT_POLICY","INGEST_CONTENT","REFINE_POLICY"
            break
        }

        # Amazon.Bedrock.CommitmentDuration
        "New-BDRProvisionedModelThroughput/CommitmentDuration"
        {
            $v = "OneMonth","SixMonths"
            break
        }

        # Amazon.Bedrock.CustomizationType
        "New-BDRModelCustomizationJob/CustomizationType"
        {
            $v = "CONTINUED_PRE_TRAINING","DISTILLATION","FINE_TUNING","IMPORTED"
            break
        }

        # Amazon.Bedrock.CustomModelDeploymentStatus
        "Get-BDRCustomModelDeploymentList/StatusEqual"
        {
            $v = "Active","Creating","Failed"
            break
        }

        # Amazon.Bedrock.EvaluationJobStatus
        "Get-BDREvaluationJobList/StatusEqual"
        {
            $v = "Completed","Deleting","Failed","InProgress","Stopped","Stopping"
            break
        }

        # Amazon.Bedrock.FineTuningJobStatus
        "Get-BDRModelCustomizationJobList/StatusEqual"
        {
            $v = "Completed","Failed","InProgress","Stopped","Stopping"
            break
        }

        # Amazon.Bedrock.GuardrailContentFiltersTierName
        {
            ($_ -eq "New-BDRGuardrail/ContentPolicyConfig_TierConfig_TierName") -Or
            ($_ -eq "Update-BDRGuardrail/ContentPolicyConfig_TierConfig_TierName")
        }
        {
            $v = "CLASSIC","STANDARD"
            break
        }

        # Amazon.Bedrock.GuardrailTopicsTierName
        {
            ($_ -eq "New-BDRGuardrail/TopicPolicyConfig_TierConfig_TierName") -Or
            ($_ -eq "Update-BDRGuardrail/TopicPolicyConfig_TierConfig_TierName")
        }
        {
            $v = "CLASSIC","STANDARD"
            break
        }

        # Amazon.Bedrock.InferenceProfileType
        "Get-BDRInferenceProfileList/TypeEqual"
        {
            $v = "APPLICATION","SYSTEM_DEFINED"
            break
        }

        # Amazon.Bedrock.InferenceType
        "Get-BDRFoundationModelList/ByInferenceType"
        {
            $v = "ON_DEMAND","PROVISIONED"
            break
        }

        # Amazon.Bedrock.ModelCopyJobStatus
        "Get-BDRModelCopyJobList/StatusEqual"
        {
            $v = "Completed","Failed","InProgress"
            break
        }

        # Amazon.Bedrock.ModelCustomization
        "Get-BDRFoundationModelList/ByCustomizationType"
        {
            $v = "CONTINUED_PRE_TRAINING","DISTILLATION","FINE_TUNING"
            break
        }

        # Amazon.Bedrock.ModelImportJobStatus
        "Get-BDRModelImportJobList/StatusEqual"
        {
            $v = "Completed","Failed","InProgress"
            break
        }

        # Amazon.Bedrock.ModelInvocationJobStatus
        "Get-BDRModelInvocationJobList/StatusEqual"
        {
            $v = "Completed","Expired","Failed","InProgress","PartiallyCompleted","Scheduled","Stopped","Stopping","Submitted","Validating"
            break
        }

        # Amazon.Bedrock.ModelModality
        "Get-BDRFoundationModelList/ByOutputModality"
        {
            $v = "EMBEDDING","IMAGE","TEXT"
            break
        }

        # Amazon.Bedrock.ModelStatus
        "Get-BDRCustomModelList/ModelStatus"
        {
            $v = "Active","Creating","Failed"
            break
        }

        # Amazon.Bedrock.OfferType
        "Get-BDRFoundationModelAgreementOfferList/OfferType"
        {
            $v = "ALL","PUBLIC"
            break
        }

        # Amazon.Bedrock.PromptRouterType
        "Get-BDRPromptRouterList/Type"
        {
            $v = "custom","default"
            break
        }

        # Amazon.Bedrock.ProvisionedModelStatus
        "Get-BDRProvisionedModelThroughputList/StatusEqual"
        {
            $v = "Creating","Failed","InService","Updating"
            break
        }

        # Amazon.Bedrock.S3InputFormat
        "New-BDRModelInvocationJob/S3InputDataConfig_S3InputFormat"
        {
            $v = "JSONL"
            break
        }

        # Amazon.Bedrock.SortByProvisionedModels
        "Get-BDRProvisionedModelThroughputList/SortBy"
        {
            $v = "CreationTime"
            break
        }

        # Amazon.Bedrock.SortJobsBy
        {
            ($_ -eq "Get-BDREvaluationJobList/SortBy") -Or
            ($_ -eq "Get-BDRModelCopyJobList/SortBy") -Or
            ($_ -eq "Get-BDRModelCustomizationJobList/SortBy") -Or
            ($_ -eq "Get-BDRModelImportJobList/SortBy") -Or
            ($_ -eq "Get-BDRModelInvocationJobList/SortBy")
        }
        {
            $v = "CreationTime"
            break
        }

        # Amazon.Bedrock.SortModelsBy
        {
            ($_ -eq "Get-BDRCustomModelDeploymentList/SortBy") -Or
            ($_ -eq "Get-BDRCustomModelList/SortBy") -Or
            ($_ -eq "Get-BDRImportedModelList/SortBy")
        }
        {
            $v = "CreationTime"
            break
        }

        # Amazon.Bedrock.SortOrder
        {
            ($_ -eq "Get-BDRCustomModelDeploymentList/SortOrder") -Or
            ($_ -eq "Get-BDRCustomModelList/SortOrder") -Or
            ($_ -eq "Get-BDREvaluationJobList/SortOrder") -Or
            ($_ -eq "Get-BDRImportedModelList/SortOrder") -Or
            ($_ -eq "Get-BDRModelCopyJobList/SortOrder") -Or
            ($_ -eq "Get-BDRModelCustomizationJobList/SortOrder") -Or
            ($_ -eq "Get-BDRModelImportJobList/SortOrder") -Or
            ($_ -eq "Get-BDRModelInvocationJobList/SortOrder") -Or
            ($_ -eq "Get-BDRProvisionedModelThroughputList/SortOrder")
        }
        {
            $v = "Ascending","Descending"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BDR_map = @{
    "ApplicationType"=@("New-BDREvaluationJob")
    "ApplicationTypeEqual"=@("Get-BDREvaluationJobList")
    "AssetType"=@("Get-BDRAutomatedReasoningPolicyBuildWorkflowResultAsset")
    "BuildWorkflowType"=@("Start-BDRAutomatedReasoningPolicyBuildWorkflow")
    "ByCustomizationType"=@("Get-BDRFoundationModelList")
    "ByInferenceType"=@("Get-BDRFoundationModelList")
    "ByOutputModality"=@("Get-BDRFoundationModelList")
    "CommitmentDuration"=@("New-BDRProvisionedModelThroughput")
    "ContentPolicyConfig_TierConfig_TierName"=@("New-BDRGuardrail","Update-BDRGuardrail")
    "CustomizationType"=@("New-BDRModelCustomizationJob")
    "ExpectedAggregatedFindingsResult"=@("New-BDRAutomatedReasoningPolicyTestCase","Update-BDRAutomatedReasoningPolicyTestCase")
    "ModelStatus"=@("Get-BDRCustomModelList")
    "OfferType"=@("Get-BDRFoundationModelAgreementOfferList")
    "S3InputDataConfig_S3InputFormat"=@("New-BDRModelInvocationJob")
    "SortBy"=@("Get-BDRCustomModelDeploymentList","Get-BDRCustomModelList","Get-BDREvaluationJobList","Get-BDRImportedModelList","Get-BDRModelCopyJobList","Get-BDRModelCustomizationJobList","Get-BDRModelImportJobList","Get-BDRModelInvocationJobList","Get-BDRProvisionedModelThroughputList")
    "SortOrder"=@("Get-BDRCustomModelDeploymentList","Get-BDRCustomModelList","Get-BDREvaluationJobList","Get-BDRImportedModelList","Get-BDRModelCopyJobList","Get-BDRModelCustomizationJobList","Get-BDRModelImportJobList","Get-BDRModelInvocationJobList","Get-BDRProvisionedModelThroughputList")
    "StatusEqual"=@("Get-BDRCustomModelDeploymentList","Get-BDREvaluationJobList","Get-BDRModelCopyJobList","Get-BDRModelCustomizationJobList","Get-BDRModelImportJobList","Get-BDRModelInvocationJobList","Get-BDRProvisionedModelThroughputList")
    "TopicPolicyConfig_TierConfig_TierName"=@("New-BDRGuardrail","Update-BDRGuardrail")
    "Type"=@("Get-BDRPromptRouterList")
    "TypeEqual"=@("Get-BDRInferenceProfileList")
}

_awsArgumentCompleterRegistration $BDR_Completers $BDR_map

$BDR_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.BDR.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BDR_SelectMap = @{
    "Select"=@("Set-BDRBatchDeleteEvaluationJob",
               "Stop-BDRAutomatedReasoningPolicyBuildWorkflow",
               "New-BDRAutomatedReasoningPolicy",
               "New-BDRAutomatedReasoningPolicyTestCase",
               "New-BDRAutomatedReasoningPolicyVersion",
               "New-BDRCustomModel",
               "New-BDRCustomModelDeployment",
               "New-BDREvaluationJob",
               "New-BDRFoundationModelAgreement",
               "New-BDRGuardrail",
               "New-BDRGuardrailVersion",
               "New-BDRInferenceProfile",
               "New-BDRMarketplaceModelEndpoint",
               "New-BDRModelCopyJob",
               "New-BDRModelCustomizationJob",
               "New-BDRModelImportJob",
               "New-BDRModelInvocationJob",
               "New-BDRPromptRouter",
               "New-BDRProvisionedModelThroughput",
               "Remove-BDRAutomatedReasoningPolicy",
               "Remove-BDRAutomatedReasoningPolicyBuildWorkflow",
               "Remove-BDRAutomatedReasoningPolicyTestCase",
               "Remove-BDRCustomModel",
               "Remove-BDRCustomModelDeployment",
               "Remove-BDRFoundationModelAgreement",
               "Remove-BDRGuardrail",
               "Remove-BDRImportedModel",
               "Remove-BDRInferenceProfile",
               "Remove-BDRMarketplaceModelEndpoint",
               "Remove-BDRModelInvocationLoggingConfiguration",
               "Remove-BDRPromptRouter",
               "Remove-BDRProvisionedModelThroughput",
               "Unregister-BDRMarketplaceModelEndpoint",
               "Export-BDRAutomatedReasoningPolicyVersion",
               "Get-BDRAutomatedReasoningPolicy",
               "Get-BDRAutomatedReasoningPolicyAnnotation",
               "Get-BDRAutomatedReasoningPolicyBuildWorkflow",
               "Get-BDRAutomatedReasoningPolicyBuildWorkflowResultAsset",
               "Get-BDRAutomatedReasoningPolicyNextScenario",
               "Get-BDRAutomatedReasoningPolicyTestCase",
               "Get-BDRAutomatedReasoningPolicyTestResult",
               "Get-BDRCustomModel",
               "Get-BDRCustomModelDeployment",
               "Get-BDREvaluationJob",
               "Get-BDRFoundationModel",
               "Get-BDRFoundationModelAvailability",
               "Get-BDRGuardrail",
               "Get-BDRImportedModel",
               "Get-BDRInferenceProfile",
               "Get-BDRMarketplaceModelEndpoint",
               "Get-BDRModelCopyJob",
               "Get-BDRModelCustomizationJob",
               "Get-BDRModelImportJob",
               "Get-BDRModelInvocationJob",
               "Get-BDRModelInvocationLoggingConfiguration",
               "Get-BDRPromptRouter",
               "Get-BDRProvisionedModelThroughput",
               "Get-BDRUseCaseForModelAccess",
               "Get-BDRAutomatedReasoningPolicyList",
               "Get-BDRAutomatedReasoningPolicyBuildWorkflowList",
               "Get-BDRAutomatedReasoningPolicyTestCaseList",
               "Get-BDRAutomatedReasoningPolicyTestResultList",
               "Get-BDRCustomModelDeploymentList",
               "Get-BDRCustomModelList",
               "Get-BDREvaluationJobList",
               "Get-BDRFoundationModelAgreementOfferList",
               "Get-BDRFoundationModelList",
               "Get-BDRGuardrailList",
               "Get-BDRImportedModelList",
               "Get-BDRInferenceProfileList",
               "Get-BDRMarketplaceModelEndpointList",
               "Get-BDRModelCopyJobList",
               "Get-BDRModelCustomizationJobList",
               "Get-BDRModelImportJobList",
               "Get-BDRModelInvocationJobList",
               "Get-BDRPromptRouterList",
               "Get-BDRProvisionedModelThroughputList",
               "Get-BDRResourceTag",
               "Write-BDRModelInvocationLoggingConfiguration",
               "Write-BDRUseCaseForModelAccess",
               "Register-BDRMarketplaceModelEndpoint",
               "Start-BDRAutomatedReasoningPolicyBuildWorkflow",
               "Start-BDRAutomatedReasoningPolicyTestWorkflow",
               "Stop-BDREvaluationJob",
               "Stop-BDRModelCustomizationJob",
               "Stop-BDRModelInvocationJob",
               "Add-BDRResourceTag",
               "Remove-BDRResourceTag",
               "Update-BDRAutomatedReasoningPolicy",
               "Update-BDRAutomatedReasoningPolicyAnnotation",
               "Update-BDRAutomatedReasoningPolicyTestCase",
               "Update-BDRGuardrail",
               "Update-BDRMarketplaceModelEndpoint",
               "Update-BDRProvisionedModelThroughput")
}

_awsArgumentCompleterRegistration $BDR_SelectCompleters $BDR_SelectMap
# Argument completions for service AWS Billing


$AWSB_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.Billing.Dimension
        {
            ($_ -eq "New-AWSBBillingView/Dimensions_Key") -Or
            ($_ -eq "Update-AWSBBillingView/Dimensions_Key")
        }
        {
            $v = "LINKED_ACCOUNT"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AWSB_map = @{
    "Dimensions_Key"=@("New-AWSBBillingView","Update-AWSBBillingView")
}

_awsArgumentCompleterRegistration $AWSB_Completers $AWSB_map

$AWSB_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.AWSB.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$AWSB_SelectMap = @{
    "Select"=@("Add-AWSBSourceView",
               "New-AWSBBillingView",
               "Remove-AWSBBillingView",
               "Remove-AWSBSourceView",
               "Get-AWSBBillingView",
               "Get-AWSBResourcePolicy",
               "Get-AWSBBillingViewList",
               "Get-AWSBSourceViewsForBillingViewList",
               "Get-AWSBResourceTag",
               "Add-AWSBResourceTag",
               "Remove-AWSBResourceTag",
               "Update-AWSBBillingView")
}

_awsArgumentCompleterRegistration $AWSB_SelectCompleters $AWSB_SelectMap
# Argument completions for service AWSBillingConductor


$ABC_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.BillingConductor.BillingGroupStatus
        "Update-ABCBillingGroup/Status"
        {
            $v = "ACTIVE","PRIMARY_ACCOUNT_MISSING"
            break
        }

        # Amazon.BillingConductor.ComputationRuleEnum
        "New-ABCCustomLineItem/ComputationRule"
        {
            $v = "CONSOLIDATED"
            break
        }

        # Amazon.BillingConductor.CustomLineItemRelationship
        "Get-ABCResourcesAssociatedToCustomLineItemList/Filters_Relationship"
        {
            $v = "CHILD","PARENT"
            break
        }

        # Amazon.BillingConductor.CustomLineItemType
        "New-ABCCustomLineItem/ChargeDetails_Type"
        {
            $v = "CREDIT","FEE"
            break
        }

        # Amazon.BillingConductor.PricingRuleScope
        "New-ABCPricingRule/Scope"
        {
            $v = "BILLING_ENTITY","GLOBAL","SERVICE","SKU"
            break
        }

        # Amazon.BillingConductor.PricingRuleType
        {
            ($_ -eq "New-ABCPricingRule/Type") -Or
            ($_ -eq "Update-ABCPricingRule/Type")
        }
        {
            $v = "DISCOUNT","MARKUP","TIERING"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ABC_map = @{
    "ChargeDetails_Type"=@("New-ABCCustomLineItem")
    "ComputationRule"=@("New-ABCCustomLineItem")
    "Filters_Relationship"=@("Get-ABCResourcesAssociatedToCustomLineItemList")
    "Scope"=@("New-ABCPricingRule")
    "Status"=@("Update-ABCBillingGroup")
    "Type"=@("New-ABCPricingRule","Update-ABCPricingRule")
}

_awsArgumentCompleterRegistration $ABC_Completers $ABC_map

$ABC_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.ABC.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ABC_SelectMap = @{
    "Select"=@("Register-ABCAccount",
               "Register-ABCPricingRule",
               "Register-ABCResourceBatchToCustomLineItem",
               "Unregister-ABCResourceBatchFromCustomLineItem",
               "New-ABCBillingGroup",
               "New-ABCCustomLineItem",
               "New-ABCPricingPlan",
               "New-ABCPricingRule",
               "Remove-ABCBillingGroup",
               "Remove-ABCCustomLineItem",
               "Remove-ABCPricingPlan",
               "Remove-ABCPricingRule",
               "Unregister-ABCAccount",
               "Unregister-ABCPricingRule",
               "Get-ABCBillingGroupCostReport",
               "Get-ABCAccountAssociationList",
               "Get-ABCBillingGroupCostReportList",
               "Get-ABCBillingGroupList",
               "Get-ABCCustomLineItemList",
               "Get-ABCCustomLineItemVersionList",
               "Get-ABCPricingPlanList",
               "Get-ABCPricingPlansAssociatedWithPricingRuleList",
               "Get-ABCPricingRuleList",
               "Get-ABCPricingRulesAssociatedToPricingPlanList",
               "Get-ABCResourcesAssociatedToCustomLineItemList",
               "Get-ABCResourceTag",
               "Add-ABCResourceTag",
               "Remove-ABCResourceTag",
               "Update-ABCBillingGroup",
               "Update-ABCCustomLineItem",
               "Update-ABCPricingPlan",
               "Update-ABCPricingRule")
}

_awsArgumentCompleterRegistration $ABC_SelectCompleters $ABC_SelectMap
# Argument completions for service Amazon Braket


$BRKT_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.Braket.CompressionType
        "New-BRKTJob/ScriptModeConfig_CompressionType"
        {
            $v = "GZIP","NONE"
            break
        }

        # Amazon.Braket.InstanceType
        "New-BRKTJob/InstanceConfig_InstanceType"
        {
            $v = "ml.c4.2xlarge","ml.c4.4xlarge","ml.c4.8xlarge","ml.c4.xlarge","ml.c5.18xlarge","ml.c5.2xlarge","ml.c5.4xlarge","ml.c5.9xlarge","ml.c5.xlarge","ml.c5n.18xlarge","ml.c5n.2xlarge","ml.c5n.4xlarge","ml.c5n.9xlarge","ml.c5n.xlarge","ml.g4dn.12xlarge","ml.g4dn.16xlarge","ml.g4dn.2xlarge","ml.g4dn.4xlarge","ml.g4dn.8xlarge","ml.g4dn.xlarge","ml.m4.10xlarge","ml.m4.16xlarge","ml.m4.2xlarge","ml.m4.4xlarge","ml.m4.xlarge","ml.m5.12xlarge","ml.m5.24xlarge","ml.m5.2xlarge","ml.m5.4xlarge","ml.m5.large","ml.m5.xlarge","ml.p2.16xlarge","ml.p2.8xlarge","ml.p2.xlarge","ml.p3.16xlarge","ml.p3.2xlarge","ml.p3.8xlarge","ml.p3dn.24xlarge","ml.p4d.24xlarge"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BRKT_map = @{
    "InstanceConfig_InstanceType"=@("New-BRKTJob")
    "ScriptModeConfig_CompressionType"=@("New-BRKTJob")
}

_awsArgumentCompleterRegistration $BRKT_Completers $BRKT_map

$BRKT_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.BRKT.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BRKT_SelectMap = @{
    "Select"=@("Stop-BRKTJob",
               "Stop-BRKTQuantumTask",
               "New-BRKTJob",
               "New-BRKTQuantumTask",
               "Get-BRKTDevice",
               "Get-BRKTJob",
               "Get-BRKTQuantumTask",
               "Get-BRKTResourceTag",
               "Search-BRKTDevice",
               "Search-BRKTJob",
               "Search-BRKTQuantumTask",
               "Add-BRKTResourceTag",
               "Remove-BRKTResourceTag")
}

_awsArgumentCompleterRegistration $BRKT_SelectCompleters $BRKT_SelectMap
# Argument completions for service AWS Budgets


$BGT_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.Budgets.ActionSubType
        {
            ($_ -eq "New-BGTBudgetAction/SsmActionDefinition_ActionSubType") -Or
            ($_ -eq "Update-BGTBudgetAction/SsmActionDefinition_ActionSubType")
        }
        {
            $v = "STOP_EC2_INSTANCES","STOP_RDS_INSTANCES"
            break
        }

        # Amazon.Budgets.ActionType
        "New-BGTBudgetAction/ActionType"
        {
            $v = "APPLY_IAM_POLICY","APPLY_SCP_POLICY","RUN_SSM_DOCUMENTS"
            break
        }

        # Amazon.Budgets.ApprovalModel
        {
            ($_ -eq "New-BGTBudgetAction/ApprovalModel") -Or
            ($_ -eq "Update-BGTBudgetAction/ApprovalModel")
        }
        {
            $v = "AUTOMATIC","MANUAL"
            break
        }

        # Amazon.Budgets.AutoAdjustType
        {
            ($_ -eq "New-BGTBudget/AutoAdjustData_AutoAdjustType") -Or
            ($_ -eq "Update-BGTBudget/AutoAdjustData_AutoAdjustType")
        }
        {
            $v = "FORECAST","HISTORICAL"
            break
        }

        # Amazon.Budgets.BudgetType
        {
            ($_ -eq "New-BGTBudget/Budget_BudgetType") -Or
            ($_ -eq "Update-BGTBudget/NewBudget_BudgetType")
        }
        {
            $v = "COST","RI_COVERAGE","RI_UTILIZATION","SAVINGS_PLANS_COVERAGE","SAVINGS_PLANS_UTILIZATION","USAGE"
            break
        }

        # Amazon.Budgets.ComparisonOperator
        {
            ($_ -eq "Update-BGTNotification/NewNotification_ComparisonOperator") -Or
            ($_ -eq "Get-BGTSubscribersForNotification/Notification_ComparisonOperator") -Or
            ($_ -eq "New-BGTNotification/Notification_ComparisonOperator") -Or
            ($_ -eq "New-BGTSubscriber/Notification_ComparisonOperator") -Or
            ($_ -eq "Remove-BGTNotification/Notification_ComparisonOperator") -Or
            ($_ -eq "Remove-BGTSubscriber/Notification_ComparisonOperator") -Or
            ($_ -eq "Update-BGTSubscriber/Notification_ComparisonOperator") -Or
            ($_ -eq "Update-BGTNotification/OldNotification_ComparisonOperator")
        }
        {
            $v = "EQUAL_TO","GREATER_THAN","LESS_THAN"
            break
        }

        # Amazon.Budgets.ExecutionType
        "Invoke-BGTBudgetAction/ExecutionType"
        {
            $v = "APPROVE_BUDGET_ACTION","RESET_BUDGET_ACTION","RETRY_BUDGET_ACTION","REVERSE_BUDGET_ACTION"
            break
        }

        # Amazon.Budgets.HealthStatusReason
        {
            ($_ -eq "New-BGTBudget/HealthStatus_StatusReason") -Or
            ($_ -eq "Update-BGTBudget/HealthStatus_StatusReason")
        }
        {
            $v = "BILLING_VIEW_NO_ACCESS","BILLING_VIEW_UNHEALTHY","FILTER_INVALID","MULTI_YEAR_HISTORICAL_DATA_DISABLED"
            break
        }

        # Amazon.Budgets.HealthStatusValue
        {
            ($_ -eq "New-BGTBudget/HealthStatus_Status") -Or
            ($_ -eq "Update-BGTBudget/HealthStatus_Status")
        }
        {
            $v = "HEALTHY","UNHEALTHY"
            break
        }

        # Amazon.Budgets.NotificationState
        {
            ($_ -eq "Update-BGTNotification/NewNotification_NotificationState") -Or
            ($_ -eq "Get-BGTSubscribersForNotification/Notification_NotificationState") -Or
            ($_ -eq "New-BGTNotification/Notification_NotificationState") -Or
            ($_ -eq "New-BGTSubscriber/Notification_NotificationState") -Or
            ($_ -eq "Remove-BGTNotification/Notification_NotificationState") -Or
            ($_ -eq "Remove-BGTSubscriber/Notification_NotificationState") -Or
            ($_ -eq "Update-BGTSubscriber/Notification_NotificationState") -Or
            ($_ -eq "Update-BGTNotification/OldNotification_NotificationState")
        }
        {
            $v = "ALARM","OK"
            break
        }

        # Amazon.Budgets.NotificationType
        {
            ($_ -eq "Update-BGTNotification/NewNotification_NotificationType") -Or
            ($_ -eq "Get-BGTSubscribersForNotification/Notification_NotificationType") -Or
            ($_ -eq "New-BGTNotification/Notification_NotificationType") -Or
            ($_ -eq "New-BGTSubscriber/Notification_NotificationType") -Or
            ($_ -eq "Remove-BGTNotification/Notification_NotificationType") -Or
            ($_ -eq "Remove-BGTSubscriber/Notification_NotificationType") -Or
            ($_ -eq "Update-BGTSubscriber/Notification_NotificationType") -Or
            ($_ -eq "New-BGTBudgetAction/NotificationType") -Or
            ($_ -eq "Update-BGTBudgetAction/NotificationType") -Or
            ($_ -eq "Update-BGTNotification/OldNotification_NotificationType")
        }
        {
            $v = "ACTUAL","FORECASTED"
            break
        }

        # Amazon.Budgets.SubscriptionType
        {
            ($_ -eq "Update-BGTSubscriber/NewSubscriber_SubscriptionType") -Or
            ($_ -eq "Update-BGTSubscriber/OldSubscriber_SubscriptionType") -Or
            ($_ -eq "New-BGTSubscriber/Subscriber_SubscriptionType") -Or
            ($_ -eq "Remove-BGTSubscriber/Subscriber_SubscriptionType")
        }
        {
            $v = "EMAIL","SNS"
            break
        }

        # Amazon.Budgets.ThresholdType
        {
            ($_ -eq "New-BGTBudgetAction/ActionThreshold_ActionThresholdType") -Or
            ($_ -eq "Update-BGTBudgetAction/ActionThreshold_ActionThresholdType") -Or
            ($_ -eq "Update-BGTNotification/NewNotification_ThresholdType") -Or
            ($_ -eq "Get-BGTSubscribersForNotification/Notification_ThresholdType") -Or
            ($_ -eq "New-BGTNotification/Notification_ThresholdType") -Or
            ($_ -eq "New-BGTSubscriber/Notification_ThresholdType") -Or
            ($_ -eq "Remove-BGTNotification/Notification_ThresholdType") -Or
            ($_ -eq "Remove-BGTSubscriber/Notification_ThresholdType") -Or
            ($_ -eq "Update-BGTSubscriber/Notification_ThresholdType") -Or
            ($_ -eq "Update-BGTNotification/OldNotification_ThresholdType")
        }
        {
            $v = "ABSOLUTE_VALUE","PERCENTAGE"
            break
        }

        # Amazon.Budgets.TimeUnit
        {
            ($_ -eq "New-BGTBudget/Budget_TimeUnit") -Or
            ($_ -eq "Update-BGTBudget/NewBudget_TimeUnit")
        }
        {
            $v = "ANNUALLY","CUSTOM","DAILY","MONTHLY","QUARTERLY"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BGT_map = @{
    "ActionThreshold_ActionThresholdType"=@("New-BGTBudgetAction","Update-BGTBudgetAction")
    "ActionType"=@("New-BGTBudgetAction")
    "ApprovalModel"=@("New-BGTBudgetAction","Update-BGTBudgetAction")
    "AutoAdjustData_AutoAdjustType"=@("New-BGTBudget","Update-BGTBudget")
    "Budget_BudgetType"=@("New-BGTBudget")
    "Budget_TimeUnit"=@("New-BGTBudget")
    "ExecutionType"=@("Invoke-BGTBudgetAction")
    "HealthStatus_Status"=@("New-BGTBudget","Update-BGTBudget")
    "HealthStatus_StatusReason"=@("New-BGTBudget","Update-BGTBudget")
    "NewBudget_BudgetType"=@("Update-BGTBudget")
    "NewBudget_TimeUnit"=@("Update-BGTBudget")
    "NewNotification_ComparisonOperator"=@("Update-BGTNotification")
    "NewNotification_NotificationState"=@("Update-BGTNotification")
    "NewNotification_NotificationType"=@("Update-BGTNotification")
    "NewNotification_ThresholdType"=@("Update-BGTNotification")
    "NewSubscriber_SubscriptionType"=@("Update-BGTSubscriber")
    "Notification_ComparisonOperator"=@("Get-BGTSubscribersForNotification","New-BGTNotification","New-BGTSubscriber","Remove-BGTNotification","Remove-BGTSubscriber","Update-BGTSubscriber")
    "Notification_NotificationState"=@("Get-BGTSubscribersForNotification","New-BGTNotification","New-BGTSubscriber","Remove-BGTNotification","Remove-BGTSubscriber","Update-BGTSubscriber")
    "Notification_NotificationType"=@("Get-BGTSubscribersForNotification","New-BGTNotification","New-BGTSubscriber","Remove-BGTNotification","Remove-BGTSubscriber","Update-BGTSubscriber")
    "Notification_ThresholdType"=@("Get-BGTSubscribersForNotification","New-BGTNotification","New-BGTSubscriber","Remove-BGTNotification","Remove-BGTSubscriber","Update-BGTSubscriber")
    "NotificationType"=@("New-BGTBudgetAction","Update-BGTBudgetAction")
    "OldNotification_ComparisonOperator"=@("Update-BGTNotification")
    "OldNotification_NotificationState"=@("Update-BGTNotification")
    "OldNotification_NotificationType"=@("Update-BGTNotification")
    "OldNotification_ThresholdType"=@("Update-BGTNotification")
    "OldSubscriber_SubscriptionType"=@("Update-BGTSubscriber")
    "SsmActionDefinition_ActionSubType"=@("New-BGTBudgetAction","Update-BGTBudgetAction")
    "Subscriber_SubscriptionType"=@("New-BGTSubscriber","Remove-BGTSubscriber")
}

_awsArgumentCompleterRegistration $BGT_Completers $BGT_map

$BGT_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.BGT.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$BGT_SelectMap = @{
    "Select"=@("New-BGTBudget",
               "New-BGTBudgetAction",
               "New-BGTNotification",
               "New-BGTSubscriber",
               "Remove-BGTBudget",
               "Remove-BGTBudgetAction",
               "Remove-BGTNotification",
               "Remove-BGTSubscriber",
               "Get-BGTBudget",
               "Get-BGTBudgetAction",
               "Get-BGTBudgetActionHistory",
               "Get-BGTBudgetActionsForAccount",
               "Get-BGTBudgetActionsForBudget",
               "Get-BGTBudgetNotificationsForAccount",
               "Get-BGTBudgetPerformanceHistory",
               "Get-BGTBudgetList",
               "Get-BGTNotificationsForBudget",
               "Get-BGTSubscribersForNotification",
               "Invoke-BGTBudgetAction",
               "Get-BGTResourceTag",
               "Add-BGTResourceTag",
               "Remove-BGTResourceTag",
               "Update-BGTBudget",
               "Update-BGTBudgetAction",
               "Update-BGTNotification",
               "Update-BGTSubscriber")
}

_awsArgumentCompleterRegistration $BGT_SelectCompleters $BGT_SelectMap
# Argument completions for service AWS Cost Explorer


$CE_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CostExplorer.AccountScope
        {
            ($_ -eq "Get-CEReservationPurchaseRecommendation/AccountScope") -Or
            ($_ -eq "Get-CESavingsPlansPurchaseRecommendation/AccountScope") -Or
            ($_ -eq "Start-CECommitmentPurchaseAnalysis/SavingsPlansPurchaseAnalysisConfiguration_AccountScope")
        }
        {
            $v = "LINKED","PAYER"
            break
        }

        # Amazon.CostExplorer.AnalysisStatus
        "Get-CECommitmentPurchaseAnalysisList/AnalysisStatus"
        {
            $v = "FAILED","PROCESSING","SUCCEEDED"
            break
        }

        # Amazon.CostExplorer.AnalysisType
        "Start-CECommitmentPurchaseAnalysis/SavingsPlansPurchaseAnalysisConfiguration_AnalysisType"
        {
            $v = "CUSTOM_COMMITMENT","MAX_SAVINGS"
            break
        }

        # Amazon.CostExplorer.AnomalyFeedbackType
        {
            ($_ -eq "Get-CEAnomaly/Feedback") -Or
            ($_ -eq "Set-CEAnomalyFeedback/Feedback")
        }
        {
            $v = "NO","PLANNED_ACTIVITY","YES"
            break
        }

        # Amazon.CostExplorer.AnomalySubscriptionFrequency
        {
            ($_ -eq "New-CEAnomalySubscription/AnomalySubscription_Frequency") -Or
            ($_ -eq "Update-CEAnomalySubscription/Frequency")
        }
        {
            $v = "DAILY","IMMEDIATE","WEEKLY"
            break
        }

        # Amazon.CostExplorer.ApproximationDimension
        "Get-CEApproximateUsageRecord/ApproximationDimension"
        {
            $v = "RESOURCE","SERVICE"
            break
        }

        # Amazon.CostExplorer.Context
        "Get-CEDimensionValue/Context"
        {
            $v = "COST_AND_USAGE","RESERVATIONS","SAVINGS_PLANS"
            break
        }

        # Amazon.CostExplorer.CostAllocationTagStatus
        "Get-CECostAllocationTagList/Status"
        {
            $v = "Active","Inactive"
            break
        }

        # Amazon.CostExplorer.CostAllocationTagType
        "Get-CECostAllocationTagList/Type"
        {
            $v = "AWSGenerated","UserDefined"
            break
        }

        # Amazon.CostExplorer.CostCategoryRuleVersion
        {
            ($_ -eq "New-CECostCategoryDefinition/RuleVersion") -Or
            ($_ -eq "Update-CECostCategoryDefinition/RuleVersion")
        }
        {
            $v = "CostCategoryExpression.v1"
            break
        }

        # Amazon.CostExplorer.Dimension
        "Get-CEDimensionValue/Dimension"
        {
            $v = "AGREEMENT_END_DATE_TIME_AFTER","AGREEMENT_END_DATE_TIME_BEFORE","ANOMALY_TOTAL_IMPACT_ABSOLUTE","ANOMALY_TOTAL_IMPACT_PERCENTAGE","AZ","BILLING_ENTITY","CACHE_ENGINE","DATABASE_ENGINE","DEPLOYMENT_OPTION","INSTANCE_TYPE","INSTANCE_TYPE_FAMILY","INVOICING_ENTITY","LEGAL_ENTITY_NAME","LINKED_ACCOUNT","LINKED_ACCOUNT_NAME","OPERATING_SYSTEM","OPERATION","PAYER_ACCOUNT","PAYMENT_OPTION","PLATFORM","PURCHASE_TYPE","RECORD_TYPE","REGION","RESERVATION_ID","RESOURCE_ID","RIGHTSIZING_TYPE","SAVINGS_PLANS_TYPE","SAVINGS_PLAN_ARN","SCOPE","SERVICE","SERVICE_CODE","SUBSCRIPTION_ID","TENANCY","USAGE_TYPE","USAGE_TYPE_GROUP"
            break
        }

        # Amazon.CostExplorer.GenerationStatus
        "Get-CESavingsPlansPurchaseRecommendationGenerationList/GenerationStatus"
        {
            $v = "FAILED","PROCESSING","SUCCEEDED"
            break
        }

        # Amazon.CostExplorer.Granularity
        {
            ($_ -eq "Get-CEApproximateUsageRecord/Granularity") -Or
            ($_ -eq "Get-CECostAndUsage/Granularity") -Or
            ($_ -eq "Get-CECostAndUsageWithResource/Granularity") -Or
            ($_ -eq "Get-CECostForecast/Granularity") -Or
            ($_ -eq "Get-CEReservationCoverage/Granularity") -Or
            ($_ -eq "Get-CEReservationUtilization/Granularity") -Or
            ($_ -eq "Get-CESavingsPlansCoverage/Granularity") -Or
            ($_ -eq "Get-CESavingsPlansUtilization/Granularity") -Or
            ($_ -eq "Get-CEUsageForecast/Granularity")
        }
        {
            $v = "DAILY","HOURLY","MONTHLY"
            break
        }

        # Amazon.CostExplorer.LookbackPeriodInDays
        {
            ($_ -eq "Get-CEReservationPurchaseRecommendation/LookbackPeriodInDay") -Or
            ($_ -eq "Get-CESavingsPlansPurchaseRecommendation/LookbackPeriodInDay")
        }
        {
            $v = "SEVEN_DAYS","SIXTY_DAYS","THIRTY_DAYS"
            break
        }

        # Amazon.CostExplorer.Metric
        {
            ($_ -eq "Get-CECostForecast/Metric") -Or
            ($_ -eq "Get-CEUsageForecast/Metric")
        }
        {
            $v = "AMORTIZED_COST","BLENDED_COST","NET_AMORTIZED_COST","NET_UNBLENDED_COST","NORMALIZED_USAGE_AMOUNT","UNBLENDED_COST","USAGE_QUANTITY"
            break
        }

        # Amazon.CostExplorer.MonitorDimension
        "New-CEAnomalyMonitor/AnomalyMonitor_MonitorDimension"
        {
            $v = "SERVICE"
            break
        }

        # Amazon.CostExplorer.MonitorType
        "New-CEAnomalyMonitor/AnomalyMonitor_MonitorType"
        {
            $v = "CUSTOM","DIMENSIONAL"
            break
        }

        # Amazon.CostExplorer.NumericOperator
        "Get-CEAnomaly/TotalImpact_NumericOperator"
        {
            $v = "BETWEEN","EQUAL","GREATER_THAN","GREATER_THAN_OR_EQUAL","LESS_THAN","LESS_THAN_OR_EQUAL"
            break
        }

        # Amazon.CostExplorer.OfferingClass
        "Get-CEReservationPurchaseRecommendation/EC2Specification_OfferingClass"
        {
            $v = "CONVERTIBLE","STANDARD"
            break
        }

        # Amazon.CostExplorer.PaymentOption
        {
            ($_ -eq "Get-CEReservationPurchaseRecommendation/PaymentOption") -Or
            ($_ -eq "Get-CESavingsPlansPurchaseRecommendation/PaymentOption")
        }
        {
            $v = "ALL_UPFRONT","HEAVY_UTILIZATION","LIGHT_UTILIZATION","MEDIUM_UTILIZATION","NO_UPFRONT","PARTIAL_UPFRONT"
            break
        }

        # Amazon.CostExplorer.RecommendationTarget
        "Get-CERightsizingRecommendation/Configuration_RecommendationTarget"
        {
            $v = "CROSS_INSTANCE_FAMILY","SAME_INSTANCE_FAMILY"
            break
        }

        # Amazon.CostExplorer.SortOrder
        {
            ($_ -eq "Get-CEReservationCoverage/SortBy_SortOrder") -Or
            ($_ -eq "Get-CEReservationUtilization/SortBy_SortOrder") -Or
            ($_ -eq "Get-CESavingsPlansCoverage/SortBy_SortOrder") -Or
            ($_ -eq "Get-CESavingsPlansUtilization/SortBy_SortOrder") -Or
            ($_ -eq "Get-CESavingsPlansUtilizationDetail/SortBy_SortOrder")
        }
        {
            $v = "ASCENDING","DESCENDING"
            break
        }

        # Amazon.CostExplorer.SupportedSavingsPlansType
        "Get-CESavingsPlansPurchaseRecommendation/SavingsPlansType"
        {
            $v = "COMPUTE_SP","EC2_INSTANCE_SP","SAGEMAKER_SP"
            break
        }

        # Amazon.CostExplorer.TermInYears
        {
            ($_ -eq "Get-CEReservationPurchaseRecommendation/TermInYear") -Or
            ($_ -eq "Get-CESavingsPlansPurchaseRecommendation/TermInYear")
        }
        {
            $v = "ONE_YEAR","THREE_YEARS"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CE_map = @{
    "AccountScope"=@("Get-CEReservationPurchaseRecommendation","Get-CESavingsPlansPurchaseRecommendation")
    "AnalysisStatus"=@("Get-CECommitmentPurchaseAnalysisList")
    "AnomalyMonitor_MonitorDimension"=@("New-CEAnomalyMonitor")
    "AnomalyMonitor_MonitorType"=@("New-CEAnomalyMonitor")
    "AnomalySubscription_Frequency"=@("New-CEAnomalySubscription")
    "ApproximationDimension"=@("Get-CEApproximateUsageRecord")
    "Configuration_RecommendationTarget"=@("Get-CERightsizingRecommendation")
    "Context"=@("Get-CEDimensionValue")
    "Dimension"=@("Get-CEDimensionValue")
    "EC2Specification_OfferingClass"=@("Get-CEReservationPurchaseRecommendation")
    "Feedback"=@("Get-CEAnomaly","Set-CEAnomalyFeedback")
    "Frequency"=@("Update-CEAnomalySubscription")
    "GenerationStatus"=@("Get-CESavingsPlansPurchaseRecommendationGenerationList")
    "Granularity"=@("Get-CEApproximateUsageRecord","Get-CECostAndUsage","Get-CECostAndUsageWithResource","Get-CECostForecast","Get-CEReservationCoverage","Get-CEReservationUtilization","Get-CESavingsPlansCoverage","Get-CESavingsPlansUtilization","Get-CEUsageForecast")
    "LookbackPeriodInDay"=@("Get-CEReservationPurchaseRecommendation","Get-CESavingsPlansPurchaseRecommendation")
    "Metric"=@("Get-CECostForecast","Get-CEUsageForecast")
    "PaymentOption"=@("Get-CEReservationPurchaseRecommendation","Get-CESavingsPlansPurchaseRecommendation")
    "RuleVersion"=@("New-CECostCategoryDefinition","Update-CECostCategoryDefinition")
    "SavingsPlansPurchaseAnalysisConfiguration_AccountScope"=@("Start-CECommitmentPurchaseAnalysis")
    "SavingsPlansPurchaseAnalysisConfiguration_AnalysisType"=@("Start-CECommitmentPurchaseAnalysis")
    "SavingsPlansType"=@("Get-CESavingsPlansPurchaseRecommendation")
    "SortBy_SortOrder"=@("Get-CEReservationCoverage","Get-CEReservationUtilization","Get-CESavingsPlansCoverage","Get-CESavingsPlansUtilization","Get-CESavingsPlansUtilizationDetail")
    "Status"=@("Get-CECostAllocationTagList")
    "TermInYear"=@("Get-CEReservationPurchaseRecommendation","Get-CESavingsPlansPurchaseRecommendation")
    "TotalImpact_NumericOperator"=@("Get-CEAnomaly")
    "Type"=@("Get-CECostAllocationTagList")
}

_awsArgumentCompleterRegistration $CE_Completers $CE_map

$CE_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CE.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CE_SelectMap = @{
    "Select"=@("New-CEAnomalyMonitor",
               "New-CEAnomalySubscription",
               "New-CECostCategoryDefinition",
               "Remove-CEAnomalyMonitor",
               "Remove-CEAnomalySubscription",
               "Remove-CECostCategoryDefinition",
               "Get-CECostCategoryDefinition",
               "Get-CEAnomaly",
               "Get-CEAnomalyMonitor",
               "Get-CEAnomalySubscription",
               "Get-CEApproximateUsageRecord",
               "Get-CECommitmentPurchaseAnalysis",
               "Get-CECostAndUsage",
               "Get-CECostAndUsageComparison",
               "Get-CECostAndUsageWithResource",
               "Get-CECostCategory",
               "Get-CECostComparisonDriver",
               "Get-CECostForecast",
               "Get-CEDimensionValue",
               "Get-CEReservationCoverage",
               "Get-CEReservationPurchaseRecommendation",
               "Get-CEReservationUtilization",
               "Get-CERightsizingRecommendation",
               "Get-CESavingsPlanPurchaseRecommendationDetail",
               "Get-CESavingsPlansCoverage",
               "Get-CESavingsPlansPurchaseRecommendation",
               "Get-CESavingsPlansUtilization",
               "Get-CESavingsPlansUtilizationDetail",
               "Get-CETag",
               "Get-CEUsageForecast",
               "Get-CECommitmentPurchaseAnalysisList",
               "Get-CECostAllocationTagBackfillHistoryList",
               "Get-CECostAllocationTagList",
               "Get-CECostCategoryDefinitionList",
               "Get-CESavingsPlansPurchaseRecommendationGenerationList",
               "Get-CEResourceTag",
               "Set-CEAnomalyFeedback",
               "Start-CECommitmentPurchaseAnalysis",
               "Start-CECostAllocationTagBackfill",
               "Start-CESavingsPlansPurchaseRecommendationGeneration",
               "Add-CEResourceTag",
               "Remove-CEResourceTag",
               "Update-CEAnomalyMonitor",
               "Update-CEAnomalySubscription",
               "Update-CECostAllocationTagsStatus",
               "Update-CECostCategoryDefinition")
}

_awsArgumentCompleterRegistration $CE_SelectCompleters $CE_SelectMap
# Argument completions for service AWS Chatbot


$CHAT_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CHAT.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CHAT_SelectMap = @{
    "Select"=@("Register-CHATAssociation",
               "New-CHATChimeWebhookConfiguration",
               "New-CHATCustomAction",
               "New-CHATMicrosoftTeamsChannelConfiguration",
               "New-CHATSlackChannelConfiguration",
               "Remove-CHATChimeWebhookConfiguration",
               "Remove-CHATCustomAction",
               "Remove-CHATMicrosoftTeamsChannelConfiguration",
               "Remove-CHATMicrosoftTeamsConfiguredTeam",
               "Remove-CHATMicrosoftTeamsUserIdentity",
               "Remove-CHATSlackChannelConfiguration",
               "Remove-CHATSlackUserIdentity",
               "Remove-CHATSlackWorkspaceAuthorization",
               "Get-CHATChimeWebhookConfiguration",
               "Get-CHATSlackChannelConfiguration",
               "Get-CHATSlackUserIdentity",
               "Get-CHATSlackWorkspace",
               "Unregister-CHATAssociation",
               "Get-CHATAccountPreference",
               "Get-CHATCustomAction",
               "Get-CHATMicrosoftTeamsChannelConfiguration",
               "Get-CHATAssociationList",
               "Get-CHATCustomActionList",
               "Get-CHATMicrosoftTeamsChannelConfigurationList",
               "Get-CHATMicrosoftTeamsConfiguredTeamList",
               "Get-CHATMicrosoftTeamsUserIdentityList",
               "Get-CHATResourceTag",
               "Add-CHATResourceTag",
               "Remove-CHATResourceTag",
               "Update-CHATAccountPreference",
               "Update-CHATChimeWebhookConfiguration",
               "Update-CHATCustomAction",
               "Update-CHATMicrosoftTeamsChannelConfiguration",
               "Update-CHATSlackChannelConfiguration")
}

_awsArgumentCompleterRegistration $CHAT_SelectCompleters $CHAT_SelectMap
# Argument completions for service Amazon Chime SDK Identity


$CHMID_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ChimeSDKIdentity.AllowMessages
        {
            ($_ -eq "Register-CHMIDAppInstanceUserEndpoint/AllowMessage") -Or
            ($_ -eq "Update-CHMIDAppInstanceUserEndpoint/AllowMessage")
        }
        {
            $v = "ALL","NONE"
            break
        }

        # Amazon.ChimeSDKIdentity.AppInstanceUserEndpointType
        "Register-CHMIDAppInstanceUserEndpoint/Type"
        {
            $v = "APNS","APNS_SANDBOX","GCM"
            break
        }

        # Amazon.ChimeSDKIdentity.ExpirationCriterion
        {
            ($_ -eq "New-CHMIDAppInstanceUser/ExpirationSettings_ExpirationCriterion") -Or
            ($_ -eq "Write-CHMIDAppInstanceUserExpirationSetting/ExpirationSettings_ExpirationCriterion")
        }
        {
            $v = "CREATED_TIMESTAMP"
            break
        }

        # Amazon.ChimeSDKIdentity.RespondsTo
        {
            ($_ -eq "New-CHMIDAppInstanceBot/Lex_RespondsTo") -Or
            ($_ -eq "Update-CHMIDAppInstanceBot/Lex_RespondsTo")
        }
        {
            $v = "STANDARD_MESSAGES"
            break
        }

        # Amazon.ChimeSDKIdentity.StandardMessages
        {
            ($_ -eq "New-CHMIDAppInstanceBot/InvokedBy_StandardMessage") -Or
            ($_ -eq "Update-CHMIDAppInstanceBot/InvokedBy_StandardMessage")
        }
        {
            $v = "ALL","AUTO","MENTIONS","NONE"
            break
        }

        # Amazon.ChimeSDKIdentity.TargetedMessages
        {
            ($_ -eq "New-CHMIDAppInstanceBot/InvokedBy_TargetedMessage") -Or
            ($_ -eq "Update-CHMIDAppInstanceBot/InvokedBy_TargetedMessage")
        }
        {
            $v = "ALL","NONE"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CHMID_map = @{
    "AllowMessage"=@("Register-CHMIDAppInstanceUserEndpoint","Update-CHMIDAppInstanceUserEndpoint")
    "ExpirationSettings_ExpirationCriterion"=@("New-CHMIDAppInstanceUser","Write-CHMIDAppInstanceUserExpirationSetting")
    "InvokedBy_StandardMessage"=@("New-CHMIDAppInstanceBot","Update-CHMIDAppInstanceBot")
    "InvokedBy_TargetedMessage"=@("New-CHMIDAppInstanceBot","Update-CHMIDAppInstanceBot")
    "Lex_RespondsTo"=@("New-CHMIDAppInstanceBot","Update-CHMIDAppInstanceBot")
    "Type"=@("Register-CHMIDAppInstanceUserEndpoint")
}

_awsArgumentCompleterRegistration $CHMID_Completers $CHMID_map

$CHMID_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CHMID.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CHMID_SelectMap = @{
    "Select"=@("New-CHMIDAppInstance",
               "New-CHMIDAppInstanceAdmin",
               "New-CHMIDAppInstanceBot",
               "New-CHMIDAppInstanceUser",
               "Remove-CHMIDAppInstance",
               "Remove-CHMIDAppInstanceAdmin",
               "Remove-CHMIDAppInstanceBot",
               "Remove-CHMIDAppInstanceUser",
               "Unregister-CHMIDAppInstanceUserEndpoint",
               "Get-CHMIDAppInstance",
               "Get-CHMIDAppInstanceAdmin",
               "Get-CHMIDAppInstanceBot",
               "Get-CHMIDAppInstanceUser",
               "Get-CHMIDAppInstanceUserEndpoint",
               "Get-CHMIDAppInstanceRetentionSetting",
               "Get-CHMIDAppInstanceAdminList",
               "Get-CHMIDAppInstanceBotList",
               "Get-CHMIDAppInstanceList",
               "Get-CHMIDAppInstanceUserEndpointList",
               "Get-CHMIDAppInstanceUserList",
               "Get-CHMIDResourceTag",
               "Write-CHMIDAppInstanceRetentionSetting",
               "Write-CHMIDAppInstanceUserExpirationSetting",
               "Register-CHMIDAppInstanceUserEndpoint",
               "Add-CHMIDResourceTag",
               "Remove-CHMIDResourceTag",
               "Update-CHMIDAppInstance",
               "Update-CHMIDAppInstanceBot",
               "Update-CHMIDAppInstanceUser",
               "Update-CHMIDAppInstanceUserEndpoint")
}

_awsArgumentCompleterRegistration $CHMID_SelectCompleters $CHMID_SelectMap
# Argument completions for service Amazon Chime SDK Media Pipelines


$CHMMP_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ChimeSDKMediaPipelines.ActiveSpeakerPosition
        "New-CHMMPMediaCapturePipeline/ActiveSpeakerOnlyConfiguration_ActiveSpeakerPosition"
        {
            $v = "BottomLeft","BottomRight","TopLeft","TopRight"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.ArtifactsState
        {
            ($_ -eq "New-CHMMPMediaCapturePipeline/Content_State") -Or
            ($_ -eq "New-CHMMPMediaCapturePipeline/Video_State")
        }
        {
            $v = "Disabled","Enabled"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.AudioMuxType
        "New-CHMMPMediaCapturePipeline/Audio_MuxType"
        {
            $v = "AudioOnly","AudioWithActiveSpeakerVideo","AudioWithCompositedVideo"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.BorderColor
        "New-CHMMPMediaCapturePipeline/VideoAttribute_BorderColor"
        {
            $v = "Black","Blue","Green","Red","White","Yellow"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.CanvasOrientation
        "New-CHMMPMediaCapturePipeline/GridViewConfiguration_CanvasOrientation"
        {
            $v = "Landscape","Portrait"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.ContentMuxType
        "New-CHMMPMediaCapturePipeline/Content_MuxType"
        {
            $v = "ContentOnly"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.ContentShareLayoutOption
        "New-CHMMPMediaCapturePipeline/GridViewConfiguration_ContentShareLayout"
        {
            $v = "ActiveSpeakerOnly","Horizontal","PresenterOnly","Vertical"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.FragmentSelectorType
        "New-CHMMPMediaInsightsPipeline/FragmentSelector_FragmentSelectorType"
        {
            $v = "ProducerTimestamp","ServerTimestamp"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.HighlightColor
        "New-CHMMPMediaCapturePipeline/VideoAttribute_HighlightColor"
        {
            $v = "Black","Blue","Green","Red","White","Yellow"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.HorizontalTilePosition
        "New-CHMMPMediaCapturePipeline/HorizontalLayoutConfiguration_TilePosition"
        {
            $v = "Bottom","Top"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.LayoutOption
        "New-CHMMPMediaCapturePipeline/CompositedVideo_Layout"
        {
            $v = "GridView"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.MediaEncoding
        "New-CHMMPMediaInsightsPipeline/KinesisVideoStreamSourceRuntimeConfiguration_MediaEncoding"
        {
            $v = "pcm"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.MediaPipelineSinkType
        "New-CHMMPMediaCapturePipeline/SinkType"
        {
            $v = "S3Bucket"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.MediaPipelineSourceType
        "New-CHMMPMediaCapturePipeline/SourceType"
        {
            $v = "ChimeSdkMeeting"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.MediaPipelineStatusUpdate
        "Update-CHMMPMediaInsightsPipelineStatus/UpdateStatus"
        {
            $v = "Pause","Resume"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.PresenterPosition
        "New-CHMMPMediaCapturePipeline/PresenterOnlyConfiguration_PresenterPosition"
        {
            $v = "BottomLeft","BottomRight","TopLeft","TopRight"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.RecordingFileFormat
        "New-CHMMPMediaInsightsPipeline/S3RecordingSinkRuntimeConfiguration_RecordingFileFormat"
        {
            $v = "Opus","Wav"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.ResolutionOption
        "New-CHMMPMediaCapturePipeline/CompositedVideo_Resolution"
        {
            $v = "FHD","HD"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.TileOrder
        {
            ($_ -eq "New-CHMMPMediaCapturePipeline/HorizontalLayoutConfiguration_TileOrder") -Or
            ($_ -eq "New-CHMMPMediaCapturePipeline/VerticalLayoutConfiguration_TileOrder")
        }
        {
            $v = "JoinSequence","SpeakerSequence"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.VerticalTilePosition
        "New-CHMMPMediaCapturePipeline/VerticalLayoutConfiguration_TilePosition"
        {
            $v = "Left","Right"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.VideoMuxType
        "New-CHMMPMediaCapturePipeline/Video_MuxType"
        {
            $v = "VideoOnly"
            break
        }

        # Amazon.ChimeSDKMediaPipelines.VoiceAnalyticsLanguageCode
        "Start-CHMMPVoiceToneAnalysisTask/LanguageCode"
        {
            $v = "en-US"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CHMMP_map = @{
    "ActiveSpeakerOnlyConfiguration_ActiveSpeakerPosition"=@("New-CHMMPMediaCapturePipeline")
    "Audio_MuxType"=@("New-CHMMPMediaCapturePipeline")
    "CompositedVideo_Layout"=@("New-CHMMPMediaCapturePipeline")
    "CompositedVideo_Resolution"=@("New-CHMMPMediaCapturePipeline")
    "Content_MuxType"=@("New-CHMMPMediaCapturePipeline")
    "Content_State"=@("New-CHMMPMediaCapturePipeline")
    "FragmentSelector_FragmentSelectorType"=@("New-CHMMPMediaInsightsPipeline")
    "GridViewConfiguration_CanvasOrientation"=@("New-CHMMPMediaCapturePipeline")
    "GridViewConfiguration_ContentShareLayout"=@("New-CHMMPMediaCapturePipeline")
    "HorizontalLayoutConfiguration_TileOrder"=@("New-CHMMPMediaCapturePipeline")
    "HorizontalLayoutConfiguration_TilePosition"=@("New-CHMMPMediaCapturePipeline")
    "KinesisVideoStreamSourceRuntimeConfiguration_MediaEncoding"=@("New-CHMMPMediaInsightsPipeline")
    "LanguageCode"=@("Start-CHMMPVoiceToneAnalysisTask")
    "PresenterOnlyConfiguration_PresenterPosition"=@("New-CHMMPMediaCapturePipeline")
    "S3RecordingSinkRuntimeConfiguration_RecordingFileFormat"=@("New-CHMMPMediaInsightsPipeline")
    "SinkType"=@("New-CHMMPMediaCapturePipeline")
    "SourceType"=@("New-CHMMPMediaCapturePipeline")
    "UpdateStatus"=@("Update-CHMMPMediaInsightsPipelineStatus")
    "VerticalLayoutConfiguration_TileOrder"=@("New-CHMMPMediaCapturePipeline")
    "VerticalLayoutConfiguration_TilePosition"=@("New-CHMMPMediaCapturePipeline")
    "Video_MuxType"=@("New-CHMMPMediaCapturePipeline")
    "Video_State"=@("New-CHMMPMediaCapturePipeline")
    "VideoAttribute_BorderColor"=@("New-CHMMPMediaCapturePipeline")
    "VideoAttribute_HighlightColor"=@("New-CHMMPMediaCapturePipeline")
}

_awsArgumentCompleterRegistration $CHMMP_Completers $CHMMP_map

$CHMMP_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CHMMP.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CHMMP_SelectMap = @{
    "Select"=@("New-CHMMPMediaCapturePipeline",
               "New-CHMMPMediaConcatenationPipeline",
               "New-CHMMPMediaInsightsPipeline",
               "New-CHMMPMediaInsightsPipelineConfiguration",
               "New-CHMMPMediaLiveConnectorPipeline",
               "New-CHMMPMediaPipelineKinesisVideoStreamPool",
               "New-CHMMPMediaStreamPipeline",
               "Remove-CHMMPMediaCapturePipeline",
               "Remove-CHMMPMediaInsightsPipelineConfiguration",
               "Remove-CHMMPMediaPipeline",
               "Remove-CHMMPMediaPipelineKinesisVideoStreamPool",
               "Get-CHMMPMediaCapturePipeline",
               "Get-CHMMPMediaInsightsPipelineConfiguration",
               "Get-CHMMPMediaPipeline",
               "Get-CHMMPMediaPipelineKinesisVideoStreamPool",
               "Get-CHMMPSpeakerSearchTask",
               "Get-CHMMPVoiceToneAnalysisTask",
               "Get-CHMMPMediaCapturePipelineList",
               "Get-CHMMPMediaInsightsPipelineConfigurationList",
               "Get-CHMMPMediaPipelineKinesisVideoStreamPoolList",
               "Get-CHMMPMediaPipelineList",
               "Get-CHMMPResourceTag",
               "Start-CHMMPSpeakerSearchTask",
               "Start-CHMMPVoiceToneAnalysisTask",
               "Stop-CHMMPSpeakerSearchTask",
               "Stop-CHMMPVoiceToneAnalysisTask",
               "Add-CHMMPResourceTag",
               "Remove-CHMMPResourceTag",
               "Update-CHMMPMediaInsightsPipelineConfiguration",
               "Update-CHMMPMediaInsightsPipelineStatus",
               "Update-CHMMPMediaPipelineKinesisVideoStreamPool")
}

_awsArgumentCompleterRegistration $CHMMP_SelectCompleters $CHMMP_SelectMap
# Argument completions for service Amazon Chime SDK Meetings


$CHMTG_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ChimeSDKMeetings.ContentResolution
        {
            ($_ -eq "New-CHMTGMeeting/Content_MaxResolution") -Or
            ($_ -eq "New-CHMTGMeetingWithAttendee/Content_MaxResolution")
        }
        {
            $v = "FHD","None","UHD"
            break
        }

        # Amazon.ChimeSDKMeetings.MediaCapabilities
        {
            ($_ -eq "New-CHMTGAttendee/Capabilities_Audio") -Or
            ($_ -eq "Update-CHMTGAttendeeCapability/Capabilities_Audio") -Or
            ($_ -eq "Update-CHMTGUpdateAttendeeCapabilitiesExcept/Capabilities_Audio") -Or
            ($_ -eq "New-CHMTGAttendee/Capabilities_Content") -Or
            ($_ -eq "Update-CHMTGAttendeeCapability/Capabilities_Content") -Or
            ($_ -eq "Update-CHMTGUpdateAttendeeCapabilitiesExcept/Capabilities_Content") -Or
            ($_ -eq "New-CHMTGAttendee/Capabilities_Video") -Or
            ($_ -eq "Update-CHMTGAttendeeCapability/Capabilities_Video") -Or
            ($_ -eq "Update-CHMTGUpdateAttendeeCapabilitiesExcept/Capabilities_Video")
        }
        {
            $v = "None","Receive","Send","SendReceive"
            break
        }

        # Amazon.ChimeSDKMeetings.MediaPlacementNetworkType
        {
            ($_ -eq "New-CHMTGMeeting/MediaPlacementNetworkType") -Or
            ($_ -eq "New-CHMTGMeetingWithAttendee/MediaPlacementNetworkType")
        }
        {
            $v = "DualStack","Ipv4Only"
            break
        }

        # Amazon.ChimeSDKMeetings.MeetingFeatureStatus
        {
            ($_ -eq "New-CHMTGMeeting/Audio_EchoReduction") -Or
            ($_ -eq "New-CHMTGMeetingWithAttendee/Audio_EchoReduction")
        }
        {
            $v = "AVAILABLE","UNAVAILABLE"
            break
        }

        # Amazon.ChimeSDKMeetings.TranscribeContentIdentificationType
        "Start-CHMTGMeetingTranscription/EngineTranscribeSettings_ContentIdentificationType"
        {
            $v = "PII"
            break
        }

        # Amazon.ChimeSDKMeetings.TranscribeContentRedactionType
        "Start-CHMTGMeetingTranscription/EngineTranscribeSettings_ContentRedactionType"
        {
            $v = "PII"
            break
        }

        # Amazon.ChimeSDKMeetings.TranscribeLanguageCode
        {
            ($_ -eq "Start-CHMTGMeetingTranscription/EngineTranscribeSettings_LanguageCode") -Or
            ($_ -eq "Start-CHMTGMeetingTranscription/EngineTranscribeSettings_PreferredLanguage")
        }
        {
            $v = "de-DE","en-AU","en-GB","en-US","es-US","fr-CA","fr-FR","hi-IN","it-IT","ja-JP","ko-KR","pt-BR","th-TH","zh-CN"
            break
        }

        # Amazon.ChimeSDKMeetings.TranscribeMedicalContentIdentificationType
        "Start-CHMTGMeetingTranscription/EngineTranscribeMedicalSettings_ContentIdentificationType"
        {
            $v = "PHI"
            break
        }

        # Amazon.ChimeSDKMeetings.TranscribeMedicalLanguageCode
        "Start-CHMTGMeetingTranscription/EngineTranscribeMedicalSettings_LanguageCode"
        {
            $v = "en-US"
            break
        }

        # Amazon.ChimeSDKMeetings.TranscribeMedicalRegion
        "Start-CHMTGMeetingTranscription/EngineTranscribeMedicalSettings_Region"
        {
            $v = "ap-southeast-2","auto","ca-central-1","eu-west-1","us-east-1","us-east-2","us-west-2"
            break
        }

        # Amazon.ChimeSDKMeetings.TranscribeMedicalSpecialty
        "Start-CHMTGMeetingTranscription/EngineTranscribeMedicalSettings_Specialty"
        {
            $v = "CARDIOLOGY","NEUROLOGY","ONCOLOGY","PRIMARYCARE","RADIOLOGY","UROLOGY"
            break
        }

        # Amazon.ChimeSDKMeetings.TranscribeMedicalType
        "Start-CHMTGMeetingTranscription/EngineTranscribeMedicalSettings_Type"
        {
            $v = "CONVERSATION","DICTATION"
            break
        }

        # Amazon.ChimeSDKMeetings.TranscribePartialResultsStability
        "Start-CHMTGMeetingTranscription/EngineTranscribeSettings_PartialResultsStability"
        {
            $v = "high","low","medium"
            break
        }

        # Amazon.ChimeSDKMeetings.TranscribeRegion
        "Start-CHMTGMeetingTranscription/EngineTranscribeSettings_Region"
        {
            $v = "ap-northeast-1","ap-northeast-2","ap-southeast-2","auto","ca-central-1","eu-central-1","eu-west-1","eu-west-2","sa-east-1","us-east-1","us-east-2","us-gov-west-1","us-west-2"
            break
        }

        # Amazon.ChimeSDKMeetings.TranscribeVocabularyFilterMethod
        "Start-CHMTGMeetingTranscription/EngineTranscribeSettings_VocabularyFilterMethod"
        {
            $v = "mask","remove","tag"
            break
        }

        # Amazon.ChimeSDKMeetings.VideoResolution
        {
            ($_ -eq "New-CHMTGMeeting/Video_MaxResolution") -Or
            ($_ -eq "New-CHMTGMeetingWithAttendee/Video_MaxResolution")
        }
        {
            $v = "FHD","HD","None"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CHMTG_map = @{
    "Audio_EchoReduction"=@("New-CHMTGMeeting","New-CHMTGMeetingWithAttendee")
    "Capabilities_Audio"=@("New-CHMTGAttendee","Update-CHMTGAttendeeCapability","Update-CHMTGUpdateAttendeeCapabilitiesExcept")
    "Capabilities_Content"=@("New-CHMTGAttendee","Update-CHMTGAttendeeCapability","Update-CHMTGUpdateAttendeeCapabilitiesExcept")
    "Capabilities_Video"=@("New-CHMTGAttendee","Update-CHMTGAttendeeCapability","Update-CHMTGUpdateAttendeeCapabilitiesExcept")
    "Content_MaxResolution"=@("New-CHMTGMeeting","New-CHMTGMeetingWithAttendee")
    "EngineTranscribeMedicalSettings_ContentIdentificationType"=@("Start-CHMTGMeetingTranscription")
    "EngineTranscribeMedicalSettings_LanguageCode"=@("Start-CHMTGMeetingTranscription")
    "EngineTranscribeMedicalSettings_Region"=@("Start-CHMTGMeetingTranscription")
    "EngineTranscribeMedicalSettings_Specialty"=@("Start-CHMTGMeetingTranscription")
    "EngineTranscribeMedicalSettings_Type"=@("Start-CHMTGMeetingTranscription")
    "EngineTranscribeSettings_ContentIdentificationType"=@("Start-CHMTGMeetingTranscription")
    "EngineTranscribeSettings_ContentRedactionType"=@("Start-CHMTGMeetingTranscription")
    "EngineTranscribeSettings_LanguageCode"=@("Start-CHMTGMeetingTranscription")
    "EngineTranscribeSettings_PartialResultsStability"=@("Start-CHMTGMeetingTranscription")
    "EngineTranscribeSettings_PreferredLanguage"=@("Start-CHMTGMeetingTranscription")
    "EngineTranscribeSettings_Region"=@("Start-CHMTGMeetingTranscription")
    "EngineTranscribeSettings_VocabularyFilterMethod"=@("Start-CHMTGMeetingTranscription")
    "MediaPlacementNetworkType"=@("New-CHMTGMeeting","New-CHMTGMeetingWithAttendee")
    "Video_MaxResolution"=@("New-CHMTGMeeting","New-CHMTGMeetingWithAttendee")
}

_awsArgumentCompleterRegistration $CHMTG_Completers $CHMTG_map

$CHMTG_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CHMTG.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CHMTG_SelectMap = @{
    "Select"=@("New-CHMTGAttendeeBatch",
               "Update-CHMTGUpdateAttendeeCapabilitiesExcept",
               "New-CHMTGAttendee",
               "New-CHMTGMeeting",
               "New-CHMTGMeetingWithAttendee",
               "Remove-CHMTGAttendee",
               "Remove-CHMTGMeeting",
               "Get-CHMTGAttendee",
               "Get-CHMTGMeeting",
               "Get-CHMTGAttendeeList",
               "Get-CHMTGResourceTag",
               "Start-CHMTGMeetingTranscription",
               "Stop-CHMTGMeetingTranscription",
               "Add-CHMTGResourceTag",
               "Remove-CHMTGResourceTag",
               "Update-CHMTGAttendeeCapability")
}

_awsArgumentCompleterRegistration $CHMTG_SelectCompleters $CHMTG_SelectMap
# Argument completions for service Amazon Chime SDK Messaging


$CHMMG_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ChimeSDKMessaging.AllowNotifications
        "Write-CHMMGChannelMembershipPreference/PushNotifications_AllowNotification"
        {
            $v = "ALL","FILTERED","NONE"
            break
        }

        # Amazon.ChimeSDKMessaging.ChannelMembershipType
        {
            ($_ -eq "Get-CHMMGChannelMembershipList/Type") -Or
            ($_ -eq "New-CHMMGChannelMembership/Type") -Or
            ($_ -eq "New-CHMMGCreateChannelMembership/Type")
        }
        {
            $v = "DEFAULT","HIDDEN"
            break
        }

        # Amazon.ChimeSDKMessaging.ChannelMessagePersistenceType
        "Send-CHMMGChannelMessage/Persistence"
        {
            $v = "NON_PERSISTENT","PERSISTENT"
            break
        }

        # Amazon.ChimeSDKMessaging.ChannelMessageType
        "Send-CHMMGChannelMessage/Type"
        {
            $v = "CONTROL","STANDARD"
            break
        }

        # Amazon.ChimeSDKMessaging.ChannelMode
        {
            ($_ -eq "New-CHMMGChannel/Mode") -Or
            ($_ -eq "Update-CHMMGChannel/Mode")
        }
        {
            $v = "RESTRICTED","UNRESTRICTED"
            break
        }

        # Amazon.ChimeSDKMessaging.ChannelPrivacy
        {
            ($_ -eq "Get-CHMMGChannelList/Privacy") -Or
            ($_ -eq "New-CHMMGChannel/Privacy")
        }
        {
            $v = "PRIVATE","PUBLIC"
            break
        }

        # Amazon.ChimeSDKMessaging.ExpirationCriterion
        {
            ($_ -eq "New-CHMMGChannel/ExpirationSettings_ExpirationCriterion") -Or
            ($_ -eq "Write-CHMMGChannelExpirationSetting/ExpirationSettings_ExpirationCriterion")
        }
        {
            $v = "CREATED_TIMESTAMP","LAST_MESSAGE_TIMESTAMP"
            break
        }

        # Amazon.ChimeSDKMessaging.NetworkType
        "Get-CHMMGMessagingSessionEndpoint/NetworkType"
        {
            $v = "DUAL_STACK","IPV4_ONLY"
            break
        }

        # Amazon.ChimeSDKMessaging.PushNotificationType
        {
            ($_ -eq "Send-CHMMGChannelFlowCallback/PushNotification_Type") -Or
            ($_ -eq "Send-CHMMGChannelMessage/PushNotification_Type")
        }
        {
            $v = "DEFAULT","VOIP"
            break
        }

        # Amazon.ChimeSDKMessaging.SortOrder
        "Get-CHMMGChannelMessageList/SortOrder"
        {
            $v = "ASCENDING","DESCENDING"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CHMMG_map = @{
    "ExpirationSettings_ExpirationCriterion"=@("New-CHMMGChannel","Write-CHMMGChannelExpirationSetting")
    "Mode"=@("New-CHMMGChannel","Update-CHMMGChannel")
    "NetworkType"=@("Get-CHMMGMessagingSessionEndpoint")
    "Persistence"=@("Send-CHMMGChannelMessage")
    "Privacy"=@("Get-CHMMGChannelList","New-CHMMGChannel")
    "PushNotification_Type"=@("Send-CHMMGChannelFlowCallback","Send-CHMMGChannelMessage")
    "PushNotifications_AllowNotification"=@("Write-CHMMGChannelMembershipPreference")
    "SortOrder"=@("Get-CHMMGChannelMessageList")
    "Type"=@("Get-CHMMGChannelMembershipList","New-CHMMGChannelMembership","New-CHMMGCreateChannelMembership","Send-CHMMGChannelMessage")
}

_awsArgumentCompleterRegistration $CHMMG_Completers $CHMMG_map

$CHMMG_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CHMMG.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CHMMG_SelectMap = @{
    "Select"=@("Register-CHMMGChannelFlow",
               "New-CHMMGCreateChannelMembership",
               "Send-CHMMGChannelFlowCallback",
               "New-CHMMGChannel",
               "New-CHMMGChannelBan",
               "New-CHMMGChannelFlow",
               "New-CHMMGChannelMembership",
               "New-CHMMGChannelModerator",
               "Remove-CHMMGChannel",
               "Remove-CHMMGChannelBan",
               "Remove-CHMMGChannelFlow",
               "Remove-CHMMGChannelMembership",
               "Remove-CHMMGChannelMessage",
               "Remove-CHMMGChannelModerator",
               "Remove-CHMMGMessagingStreamingConfiguration",
               "Get-CHMMGChannel",
               "Get-CHMMGChannelBan",
               "Get-CHMMGChannelFlow",
               "Get-CHMMGChannelMembership",
               "Get-CHMMGChannelMembershipForAppInstanceUser",
               "Get-CHMMGChannelModeratedByAppInstanceUser",
               "Get-CHMMGChannelModerator",
               "Unregister-CHMMGChannelFlow",
               "Get-CHMMGChannelMembershipPreference",
               "Get-CHMMGChannelMessage",
               "Get-CHMMGChannelMessageStatus",
               "Get-CHMMGMessagingSessionEndpoint",
               "Get-CHMMGMessagingStreamingConfiguration",
               "Get-CHMMGChannelBanList",
               "Get-CHMMGChannelFlowList",
               "Get-CHMMGChannelMembershipList",
               "Get-CHMMGChannelMembershipsForAppInstanceUserList",
               "Get-CHMMGChannelMessageList",
               "Get-CHMMGChannelModeratorList",
               "Get-CHMMGChannelList",
               "Get-CHMMGChannelsAssociatedWithChannelFlowList",
               "Get-CHMMGChannelsModeratedByAppInstanceUserList",
               "Get-CHMMGSubChannelList",
               "Get-CHMMGResourceTag",
               "Write-CHMMGChannelExpirationSetting",
               "Write-CHMMGChannelMembershipPreference",
               "Write-CHMMGMessagingStreamingConfiguration",
               "Hide-CHMMGChannelMessage",
               "Search-CHMMGChannel",
               "Send-CHMMGChannelMessage",
               "Add-CHMMGResourceTag",
               "Remove-CHMMGResourceTag",
               "Update-CHMMGChannel",
               "Update-CHMMGChannelFlow",
               "Update-CHMMGChannelMessage",
               "Update-CHMMGChannelReadMarker")
}

_awsArgumentCompleterRegistration $CHMMG_SelectCompleters $CHMMG_SelectMap
# Argument completions for service Amazon Chime SDK Voice


$CHMVO_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ChimeSDKVoice.AlexaSkillStatus
        "Write-CHMVOSipMediaApplicationAlexaSkillConfiguration/SipMediaApplicationAlexaSkillConfiguration_AlexaSkillStatus"
        {
            $v = "ACTIVE","INACTIVE"
            break
        }

        # Amazon.ChimeSDKVoice.CallLegType
        "Start-CHMVOSpeakerSearchTask/CallLeg"
        {
            $v = "Callee","Caller"
            break
        }

        # Amazon.ChimeSDKVoice.GeoMatchLevel
        "New-CHMVOProxySession/GeoMatchLevel"
        {
            $v = "AreaCode","Country"
            break
        }

        # Amazon.ChimeSDKVoice.LanguageCode
        "Start-CHMVOVoiceToneAnalysisTask/LanguageCode"
        {
            $v = "en-US"
            break
        }

        # Amazon.ChimeSDKVoice.NetworkType
        "New-CHMVOVoiceConnector/NetworkType"
        {
            $v = "DUAL_STACK","IPV4_ONLY"
            break
        }

        # Amazon.ChimeSDKVoice.NumberSelectionBehavior
        "New-CHMVOProxySession/NumberSelectionBehavior"
        {
            $v = "AvoidSticky","PreferSticky"
            break
        }

        # Amazon.ChimeSDKVoice.PhoneNumberAssociationName
        "Get-CHMVOPhoneNumberList/FilterName"
        {
            $v = "SipRuleId","VoiceConnectorGroupId","VoiceConnectorId"
            break
        }

        # Amazon.ChimeSDKVoice.PhoneNumberProductType
        {
            ($_ -eq "Get-CHMVOPhoneNumberList/ProductType") -Or
            ($_ -eq "Get-CHMVOSupportedPhoneNumberCountryList/ProductType") -Or
            ($_ -eq "New-CHMVOPhoneNumberOrder/ProductType") -Or
            ($_ -eq "Update-CHMVOPhoneNumber/ProductType")
        }
        {
            $v = "SipMediaApplicationDialIn","VoiceConnector"
            break
        }

        # Amazon.ChimeSDKVoice.PhoneNumberType
        "Search-CHMVOAvailablePhoneNumber/PhoneNumberType"
        {
            $v = "Local","TollFree"
            break
        }

        # Amazon.ChimeSDKVoice.ProxySessionStatus
        "Get-CHMVOProxySessionList/Status"
        {
            $v = "Closed","InProgress","Open"
            break
        }

        # Amazon.ChimeSDKVoice.SipRuleTriggerType
        "New-CHMVOSipRule/TriggerType"
        {
            $v = "RequestUriHostname","ToPhoneNumber"
            break
        }

        # Amazon.ChimeSDKVoice.VoiceConnectorAwsRegion
        "New-CHMVOVoiceConnector/AwsRegion"
        {
            $v = "ap-northeast-1","ap-northeast-2","ap-southeast-1","ap-southeast-2","ca-central-1","eu-central-1","eu-west-1","eu-west-2","us-east-1","us-west-2"
            break
        }

        # Amazon.ChimeSDKVoice.VoiceConnectorIntegrationType
        "New-CHMVOVoiceConnector/IntegrationType"
        {
            $v = "CONNECT_ANALYTICS_CONNECTOR","CONNECT_CALL_TRANSFER_CONNECTOR"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CHMVO_map = @{
    "AwsRegion"=@("New-CHMVOVoiceConnector")
    "CallLeg"=@("Start-CHMVOSpeakerSearchTask")
    "FilterName"=@("Get-CHMVOPhoneNumberList")
    "GeoMatchLevel"=@("New-CHMVOProxySession")
    "IntegrationType"=@("New-CHMVOVoiceConnector")
    "LanguageCode"=@("Start-CHMVOVoiceToneAnalysisTask")
    "NetworkType"=@("New-CHMVOVoiceConnector")
    "NumberSelectionBehavior"=@("New-CHMVOProxySession")
    "PhoneNumberType"=@("Search-CHMVOAvailablePhoneNumber")
    "ProductType"=@("Get-CHMVOPhoneNumberList","Get-CHMVOSupportedPhoneNumberCountryList","New-CHMVOPhoneNumberOrder","Update-CHMVOPhoneNumber")
    "SipMediaApplicationAlexaSkillConfiguration_AlexaSkillStatus"=@("Write-CHMVOSipMediaApplicationAlexaSkillConfiguration")
    "Status"=@("Get-CHMVOProxySessionList")
    "TriggerType"=@("New-CHMVOSipRule")
}

_awsArgumentCompleterRegistration $CHMVO_Completers $CHMVO_map

$CHMVO_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CHMVO.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CHMVO_SelectMap = @{
    "Select"=@("Add-CHMVOPhoneNumbersWithVoiceConnector",
               "Add-CHMVOPhoneNumbersWithVoiceConnectorGroup",
               "Group-CHMVODeletePhoneNumber",
               "Group-CHMVOUpdatePhoneNumber",
               "New-CHMVOPhoneNumberOrder",
               "New-CHMVOProxySession",
               "New-CHMVOSipMediaApplication",
               "New-CHMVOSipMediaApplicationCall",
               "New-CHMVOSipRule",
               "New-CHMVOVoiceConnector",
               "New-CHMVOVoiceConnectorGroup",
               "New-CHMVOVoiceProfile",
               "New-CHMVOVoiceProfileDomain",
               "Remove-CHMVOPhoneNumber",
               "Remove-CHMVOProxySession",
               "Remove-CHMVOSipMediaApplication",
               "Remove-CHMVOSipRule",
               "Remove-CHMVOVoiceConnector",
               "Remove-CHMVOVoiceConnectorEmergencyCallingConfiguration",
               "Remove-CHMVOVoiceConnectorExternalSystemsConfiguration",
               "Remove-CHMVOVoiceConnectorGroup",
               "Remove-CHMVOVoiceConnectorOrigination",
               "Remove-CHMVOVoiceConnectorProxy",
               "Remove-CHMVOVoiceConnectorStreamingConfiguration",
               "Remove-CHMVOVoiceConnectorTermination",
               "Remove-CHMVOVoiceConnectorTerminationCredential",
               "Remove-CHMVOVoiceProfile",
               "Remove-CHMVOVoiceProfileDomain",
               "Remove-CHMVOPhoneNumbersFromVoiceConnector",
               "Remove-CHMVOPhoneNumbersFromVoiceConnectorGroup",
               "Get-CHMVOGlobalSetting",
               "Get-CHMVOPhoneNumber",
               "Get-CHMVOPhoneNumberOrder",
               "Get-CHMVOPhoneNumberSetting",
               "Get-CHMVOProxySession",
               "Get-CHMVOSipMediaApplication",
               "Get-CHMVOSipMediaApplicationAlexaSkillConfiguration",
               "Get-CHMVOSipMediaApplicationLoggingConfiguration",
               "Get-CHMVOSipRule",
               "Get-CHMVOSpeakerSearchTask",
               "Get-CHMVOVoiceConnector",
               "Get-CHMVOVoiceConnectorEmergencyCallingConfiguration",
               "Get-CHMVOVoiceConnectorExternalSystemsConfiguration",
               "Get-CHMVOVoiceConnectorGroup",
               "Get-CHMVOVoiceConnectorLoggingConfiguration",
               "Get-CHMVOVoiceConnectorOrigination",
               "Get-CHMVOVoiceConnectorProxy",
               "Get-CHMVOVoiceConnectorStreamingConfiguration",
               "Get-CHMVOVoiceConnectorTermination",
               "Get-CHMVOVoiceConnectorTerminationHealth",
               "Get-CHMVOVoiceProfile",
               "Get-CHMVOVoiceProfileDomain",
               "Get-CHMVOVoiceToneAnalysisTask",
               "Get-CHMVOAvailableVoiceConnectorRegionList",
               "Get-CHMVOPhoneNumberOrderList",
               "Get-CHMVOPhoneNumberList",
               "Get-CHMVOProxySessionList",
               "Get-CHMVOSipMediaApplicationList",
               "Get-CHMVOSipRuleList",
               "Get-CHMVOSupportedPhoneNumberCountryList",
               "Get-CHMVOResourceTag",
               "Get-CHMVOVoiceConnectorGroupList",
               "Get-CHMVOVoiceConnectorList",
               "Get-CHMVOVoiceConnectorTerminationCredentialList",
               "Get-CHMVOVoiceProfileDomainList",
               "Get-CHMVOVoiceProfileList",
               "Write-CHMVOSipMediaApplicationAlexaSkillConfiguration",
               "Write-CHMVOSipMediaApplicationLoggingConfiguration",
               "Write-CHMVOVoiceConnectorEmergencyCallingConfiguration",
               "Write-CHMVOVoiceConnectorExternalSystemsConfiguration",
               "Write-CHMVOVoiceConnectorLoggingConfiguration",
               "Write-CHMVOVoiceConnectorOrigination",
               "Write-CHMVOVoiceConnectorProxy",
               "Write-CHMVOVoiceConnectorStreamingConfiguration",
               "Write-CHMVOVoiceConnectorTermination",
               "Write-CHMVOVoiceConnectorTerminationCredential",
               "Restore-CHMVOPhoneNumber",
               "Search-CHMVOAvailablePhoneNumber",
               "Start-CHMVOSpeakerSearchTask",
               "Start-CHMVOVoiceToneAnalysisTask",
               "Stop-CHMVOSpeakerSearchTask",
               "Stop-CHMVOVoiceToneAnalysisTask",
               "Add-CHMVOResourceTag",
               "Remove-CHMVOResourceTag",
               "Update-CHMVOGlobalSetting",
               "Update-CHMVOPhoneNumber",
               "Update-CHMVOPhoneNumberSetting",
               "Update-CHMVOProxySession",
               "Update-CHMVOSipMediaApplication",
               "Update-CHMVOSipMediaApplicationCall",
               "Update-CHMVOSipRule",
               "Update-CHMVOVoiceConnector",
               "Update-CHMVOVoiceConnectorGroup",
               "Update-CHMVOVoiceProfile",
               "Update-CHMVOVoiceProfileDomain",
               "Confirm-CHMVOE911Address")
}

_awsArgumentCompleterRegistration $CHMVO_SelectCompleters $CHMVO_SelectMap
# Argument completions for service Amazon Chime


$CHM_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.Chime.License
        {
            ($_ -eq "Update-CHMAccount/DefaultLicense") -Or
            ($_ -eq "Update-CHMUser/LicenseType")
        }
        {
            $v = "Basic","Plus","Pro","ProTrial"
            break
        }

        # Amazon.Chime.PhoneNumberAssociationName
        "Get-CHMPhoneNumberList/FilterName"
        {
            $v = "AccountId","SipRuleId","UserId","VoiceConnectorGroupId","VoiceConnectorId"
            break
        }

        # Amazon.Chime.PhoneNumberProductType
        {
            ($_ -eq "Get-CHMPhoneNumberList/ProductType") -Or
            ($_ -eq "Get-CHMSupportedPhoneNumberCountryList/ProductType") -Or
            ($_ -eq "New-CHMPhoneNumberOrder/ProductType") -Or
            ($_ -eq "Update-CHMPhoneNumber/ProductType")
        }
        {
            $v = "BusinessCalling","SipMediaApplicationDialIn","VoiceConnector"
            break
        }

        # Amazon.Chime.PhoneNumberStatus
        "Get-CHMPhoneNumberList/Status"
        {
            $v = "AcquireFailed","AcquireInProgress","Assigned","DeleteFailed","DeleteInProgress","ReleaseFailed","ReleaseInProgress","Unassigned"
            break
        }

        # Amazon.Chime.PhoneNumberType
        "Search-CHMAvailablePhoneNumber/PhoneNumberType"
        {
            $v = "Local","TollFree"
            break
        }

        # Amazon.Chime.RoomMembershipRole
        {
            ($_ -eq "New-CHMRoomMembership/Role") -Or
            ($_ -eq "Update-CHMRoomMembership/Role")
        }
        {
            $v = "Administrator","Member"
            break
        }

        # Amazon.Chime.UserType
        {
            ($_ -eq "Get-CHMUserList/UserType") -Or
            ($_ -eq "New-CHMUser/UserType") -Or
            ($_ -eq "Send-CHMUserInvitation/UserType") -Or
            ($_ -eq "Update-CHMUser/UserType")
        }
        {
            $v = "PrivateUser","SharedDevice"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CHM_map = @{
    "DefaultLicense"=@("Update-CHMAccount")
    "FilterName"=@("Get-CHMPhoneNumberList")
    "LicenseType"=@("Update-CHMUser")
    "PhoneNumberType"=@("Search-CHMAvailablePhoneNumber")
    "ProductType"=@("Get-CHMPhoneNumberList","Get-CHMSupportedPhoneNumberCountryList","New-CHMPhoneNumberOrder","Update-CHMPhoneNumber")
    "Role"=@("New-CHMRoomMembership","Update-CHMRoomMembership")
    "Status"=@("Get-CHMPhoneNumberList")
    "UserType"=@("Get-CHMUserList","New-CHMUser","Send-CHMUserInvitation","Update-CHMUser")
}

_awsArgumentCompleterRegistration $CHM_Completers $CHM_map

$CHM_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CHM.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CHM_SelectMap = @{
    "Select"=@("Add-CHMPhoneNumberToUser",
               "Add-CHMSigninDelegateGroupsToAccount",
               "New-CHMRoomMembershipBatch",
               "Remove-CHMPhoneNumberBatch",
               "Enable-CHMUserSuspensionBatch",
               "Disable-CHMUserSuspensionBatch",
               "Update-CHMPhoneNumberBatch",
               "Update-CHMUserBatch",
               "New-CHMAccount",
               "New-CHMBot",
               "New-CHMMeetingDialOut",
               "New-CHMPhoneNumberOrder",
               "New-CHMRoom",
               "New-CHMRoomMembership",
               "New-CHMUser",
               "Remove-CHMAccount",
               "Remove-CHMEventsConfiguration",
               "Remove-CHMPhoneNumber",
               "Remove-CHMRoom",
               "Remove-CHMRoomMembership",
               "Remove-CHMPhoneNumberFromUser",
               "Remove-CHMSigninDelegateGroupsFromAccount",
               "Get-CHMAccount",
               "Get-CHMAccountSetting",
               "Get-CHMBot",
               "Get-CHMEventsConfiguration",
               "Get-CHMGlobalSetting",
               "Get-CHMPhoneNumber",
               "Get-CHMPhoneNumberOrder",
               "Get-CHMPhoneNumberSetting",
               "Get-CHMRetentionSetting",
               "Get-CHMRoom",
               "Get-CHMUser",
               "Get-CHMUserSetting",
               "Send-CHMUserInvitation",
               "Get-CHMAccountList",
               "Get-CHMBotList",
               "Get-CHMPhoneNumberOrderList",
               "Get-CHMPhoneNumberList",
               "Get-CHMRoomMembershipList",
               "Get-CHMRoomList",
               "Get-CHMSupportedPhoneNumberCountryList",
               "Get-CHMUserList",
               "Invoke-CHMUserLogout",
               "Write-CHMEventsConfiguration",
               "Write-CHMRetentionSetting",
               "Hide-CHMConversationMessage",
               "Hide-CHMRoomMessage",
               "Update-CHMSecurityToken",
               "Reset-CHMPersonalPIN",
               "Restore-CHMPhoneNumber",
               "Search-CHMAvailablePhoneNumber",
               "Update-CHMAccount",
               "Update-CHMAccountSetting",
               "Update-CHMBot",
               "Update-CHMGlobalSetting",
               "Update-CHMPhoneNumber",
               "Update-CHMPhoneNumberSetting",
               "Update-CHMRoom",
               "Update-CHMRoomMembership",
               "Update-CHMUser",
               "Update-CHMUserSetting")
}

_awsArgumentCompleterRegistration $CHM_SelectCompleters $CHM_SelectMap
# Argument completions for service AWS Clean Rooms Service


$CRS_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CleanRooms.AdditionalAnalyses
        {
            ($_ -eq "New-CRSConfiguredTableAnalysisRule/Aggregation_AdditionalAnalysis") -Or
            ($_ -eq "Update-CRSConfiguredTableAnalysisRule/Aggregation_AdditionalAnalysis") -Or
            ($_ -eq "New-CRSConfiguredTableAnalysisRule/Custom_AdditionalAnalysis") -Or
            ($_ -eq "Update-CRSConfiguredTableAnalysisRule/Custom_AdditionalAnalysis") -Or
            ($_ -eq "New-CRSConfiguredTableAnalysisRule/List_AdditionalAnalysis") -Or
            ($_ -eq "Update-CRSConfiguredTableAnalysisRule/List_AdditionalAnalysis")
        }
        {
            $v = "ALLOWED","NOT_ALLOWED","REQUIRED"
            break
        }

        # Amazon.CleanRooms.AnalysisFormat
        "New-CRSAnalysisTemplate/Format"
        {
            $v = "PYSPARK_1_0","SQL"
            break
        }

        # Amazon.CleanRooms.AnalysisMethod
        {
            ($_ -eq "New-CRSConfiguredTable/AnalysisMethod") -Or
            ($_ -eq "Update-CRSConfiguredTable/AnalysisMethod")
        }
        {
            $v = "DIRECT_JOB","DIRECT_QUERY","MULTIPLE"
            break
        }

        # Amazon.CleanRooms.AnalysisRuleType
        "Get-CRSSchemaAnalysisRule/Type"
        {
            $v = "AGGREGATION","CUSTOM","ID_MAPPING_TABLE","LIST"
            break
        }

        # Amazon.CleanRooms.AnalyticsEngine
        {
            ($_ -eq "New-CRSCollaboration/AnalyticsEngine") -Or
            ($_ -eq "Update-CRSCollaboration/AnalyticsEngine")
        }
        {
            $v = "CLEAN_ROOMS_SQL","SPARK"
            break
        }

        # Amazon.CleanRooms.ChangeRequestStatus
        "Get-CRSCollaborationChangeRequestList/Status"
        {
            $v = "APPROVED","CANCELLED","COMMITTED","DENIED","PENDING"
            break
        }

        # Amazon.CleanRooms.CollaborationJobLogStatus
        "New-CRSCollaboration/JobLogStatus"
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.CleanRooms.CollaborationQueryLogStatus
        "New-CRSCollaboration/QueryLogStatus"
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.CleanRooms.CommercialRegion
        {
            ($_ -eq "New-CRSConfiguredTable/Athena_Region") -Or
            ($_ -eq "Update-CRSConfiguredTable/Athena_Region") -Or
            ($_ -eq "New-CRSConfiguredTable/Glue_Region") -Or
            ($_ -eq "Update-CRSConfiguredTable/Glue_Region")
        }
        {
            $v = "af-south-1","ap-east-1","ap-east-2","ap-northeast-1","ap-northeast-2","ap-northeast-3","ap-south-1","ap-south-2","ap-southeast-1","ap-southeast-2","ap-southeast-3","ap-southeast-4","ap-southeast-5","ap-southeast-7","ca-central-1","ca-west-1","eu-central-1","eu-central-2","eu-north-1","eu-south-1","eu-south-2","eu-west-1","eu-west-2","eu-west-3","il-central-1","me-central-1","me-south-1","mx-central-1","sa-east-1","us-east-1","us-east-2","us-west-1","us-west-2"
            break
        }

        # Amazon.CleanRooms.ConfiguredTableAnalysisRuleType
        {
            ($_ -eq "Get-CRSConfiguredTableAnalysisRule/AnalysisRuleType") -Or
            ($_ -eq "New-CRSConfiguredTableAnalysisRule/AnalysisRuleType") -Or
            ($_ -eq "Remove-CRSConfiguredTableAnalysisRule/AnalysisRuleType") -Or
            ($_ -eq "Update-CRSConfiguredTableAnalysisRule/AnalysisRuleType")
        }
        {
            $v = "AGGREGATION","CUSTOM","LIST"
            break
        }

        # Amazon.CleanRooms.ConfiguredTableAssociationAnalysisRuleType
        {
            ($_ -eq "Get-CRSConfiguredTableAssociationAnalysisRule/AnalysisRuleType") -Or
            ($_ -eq "New-CRSConfiguredTableAssociationAnalysisRule/AnalysisRuleType") -Or
            ($_ -eq "Remove-CRSConfiguredTableAssociationAnalysisRule/AnalysisRuleType") -Or
            ($_ -eq "Update-CRSConfiguredTableAssociationAnalysisRule/AnalysisRuleType")
        }
        {
            $v = "AGGREGATION","CUSTOM","LIST"
            break
        }

        # Amazon.CleanRooms.ErrorMessageType
        "New-CRSAnalysisTemplate/ErrorMessageConfiguration_Type"
        {
            $v = "DETAILED"
            break
        }

        # Amazon.CleanRooms.FilterableMemberStatus
        "Get-CRSCollaborationList/MemberStatus"
        {
            $v = "ACTIVE","INVITED"
            break
        }

        # Amazon.CleanRooms.JobType
        "Invoke-CRSIdMappingTable/JobType"
        {
            $v = "BATCH","DELETE_ONLY","INCREMENTAL"
            break
        }

        # Amazon.CleanRooms.JoinRequiredOption
        {
            ($_ -eq "New-CRSConfiguredTableAnalysisRule/Aggregation_JoinRequired") -Or
            ($_ -eq "Update-CRSConfiguredTableAnalysisRule/Aggregation_JoinRequired")
        }
        {
            $v = "QUERY_RUNNER"
            break
        }

        # Amazon.CleanRooms.MembershipJobLogStatus
        {
            ($_ -eq "New-CRSMembership/JobLogStatus") -Or
            ($_ -eq "Update-CRSMembership/JobLogStatus")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.CleanRooms.MembershipQueryLogStatus
        {
            ($_ -eq "New-CRSMembership/QueryLogStatus") -Or
            ($_ -eq "Update-CRSMembership/QueryLogStatus")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.CleanRooms.MembershipStatus
        "Get-CRSMembershipList/Status"
        {
            $v = "ACTIVE","COLLABORATION_DELETED","REMOVED"
            break
        }

        # Amazon.CleanRooms.PrivacyBudgetTemplateAutoRefresh
        "New-CRSPrivacyBudgetTemplate/AutoRefresh"
        {
            $v = "CALENDAR_MONTH","NONE"
            break
        }

        # Amazon.CleanRooms.PrivacyBudgetType
        {
            ($_ -eq "Get-CRSCollaborationPrivacyBudgetList/PrivacyBudgetType") -Or
            ($_ -eq "Get-CRSPrivacyBudgetList/PrivacyBudgetType") -Or
            ($_ -eq "New-CRSPrivacyBudgetTemplate/PrivacyBudgetType") -Or
            ($_ -eq "Update-CRSPrivacyBudgetTemplate/PrivacyBudgetType")
        }
        {
            $v = "ACCESS_BUDGET","DIFFERENTIAL_PRIVACY"
            break
        }

        # Amazon.CleanRooms.ProtectedJobStatus
        "Get-CRSProtectedJobList/Status"
        {
            $v = "CANCELLED","CANCELLING","FAILED","STARTED","SUBMITTED","SUCCESS"
            break
        }

        # Amazon.CleanRooms.ProtectedJobType
        "Start-CRSProtectedJob/Type"
        {
            $v = "PYSPARK"
            break
        }

        # Amazon.CleanRooms.ProtectedJobWorkerComputeType
        "Start-CRSProtectedJob/Worker_Type"
        {
            $v = "CR.1X","CR.4X"
            break
        }

        # Amazon.CleanRooms.ProtectedQueryStatus
        "Get-CRSProtectedQueryList/Status"
        {
            $v = "CANCELLED","CANCELLING","FAILED","STARTED","SUBMITTED","SUCCESS","TIMED_OUT"
            break
        }

        # Amazon.CleanRooms.ProtectedQueryType
        "Start-CRSProtectedQuery/Type"
        {
            $v = "SQL"
            break
        }

        # Amazon.CleanRooms.ResultFormat
        {
            ($_ -eq "New-CRSMembership/S3_ResultFormat") -Or
            ($_ -eq "Start-CRSProtectedQuery/S3_ResultFormat") -Or
            ($_ -eq "Update-CRSMembership/S3_ResultFormat")
        }
        {
            $v = "CSV","PARQUET"
            break
        }

        # Amazon.CleanRooms.SchemaType
        "Get-CRSSchemaList/SchemaType"
        {
            $v = "ID_MAPPING_TABLE","TABLE"
            break
        }

        # Amazon.CleanRooms.TargetProtectedJobStatus
        "Update-CRSProtectedJob/TargetStatus"
        {
            $v = "CANCELLED"
            break
        }

        # Amazon.CleanRooms.TargetProtectedQueryStatus
        "Update-CRSProtectedQuery/TargetStatus"
        {
            $v = "CANCELLED"
            break
        }

        # Amazon.CleanRooms.WorkerComputeType
        "Start-CRSProtectedQuery/Worker_Type"
        {
            $v = "CR.1X","CR.4X"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CRS_map = @{
    "Aggregation_AdditionalAnalysis"=@("New-CRSConfiguredTableAnalysisRule","Update-CRSConfiguredTableAnalysisRule")
    "Aggregation_JoinRequired"=@("New-CRSConfiguredTableAnalysisRule","Update-CRSConfiguredTableAnalysisRule")
    "AnalysisMethod"=@("New-CRSConfiguredTable","Update-CRSConfiguredTable")
    "AnalysisRuleType"=@("Get-CRSConfiguredTableAnalysisRule","Get-CRSConfiguredTableAssociationAnalysisRule","New-CRSConfiguredTableAnalysisRule","New-CRSConfiguredTableAssociationAnalysisRule","Remove-CRSConfiguredTableAnalysisRule","Remove-CRSConfiguredTableAssociationAnalysisRule","Update-CRSConfiguredTableAnalysisRule","Update-CRSConfiguredTableAssociationAnalysisRule")
    "AnalyticsEngine"=@("New-CRSCollaboration","Update-CRSCollaboration")
    "Athena_Region"=@("New-CRSConfiguredTable","Update-CRSConfiguredTable")
    "AutoRefresh"=@("New-CRSPrivacyBudgetTemplate")
    "Custom_AdditionalAnalysis"=@("New-CRSConfiguredTableAnalysisRule","Update-CRSConfiguredTableAnalysisRule")
    "ErrorMessageConfiguration_Type"=@("New-CRSAnalysisTemplate")
    "Format"=@("New-CRSAnalysisTemplate")
    "Glue_Region"=@("New-CRSConfiguredTable","Update-CRSConfiguredTable")
    "JobLogStatus"=@("New-CRSCollaboration","New-CRSMembership","Update-CRSMembership")
    "JobType"=@("Invoke-CRSIdMappingTable")
    "List_AdditionalAnalysis"=@("New-CRSConfiguredTableAnalysisRule","Update-CRSConfiguredTableAnalysisRule")
    "MemberStatus"=@("Get-CRSCollaborationList")
    "PrivacyBudgetType"=@("Get-CRSCollaborationPrivacyBudgetList","Get-CRSPrivacyBudgetList","New-CRSPrivacyBudgetTemplate","Update-CRSPrivacyBudgetTemplate")
    "QueryLogStatus"=@("New-CRSCollaboration","New-CRSMembership","Update-CRSMembership")
    "S3_ResultFormat"=@("New-CRSMembership","Start-CRSProtectedQuery","Update-CRSMembership")
    "SchemaType"=@("Get-CRSSchemaList")
    "Status"=@("Get-CRSCollaborationChangeRequestList","Get-CRSMembershipList","Get-CRSProtectedJobList","Get-CRSProtectedQueryList")
    "TargetStatus"=@("Update-CRSProtectedJob","Update-CRSProtectedQuery")
    "Type"=@("Get-CRSSchemaAnalysisRule","Start-CRSProtectedJob","Start-CRSProtectedQuery")
    "Worker_Type"=@("Start-CRSProtectedJob","Start-CRSProtectedQuery")
}

_awsArgumentCompleterRegistration $CRS_Completers $CRS_map

$CRS_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CRS.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CRS_SelectMap = @{
    "Select"=@("Get-CRSBatchCollaborationAnalysisTemplate",
               "Get-CRSBatchSchema",
               "Get-CRSBatchGetSchemaAnalysisRule",
               "New-CRSAnalysisTemplate",
               "New-CRSCollaboration",
               "New-CRSCollaborationChangeRequest",
               "New-CRSConfiguredAudienceModelAssociation",
               "New-CRSConfiguredTable",
               "New-CRSConfiguredTableAnalysisRule",
               "New-CRSConfiguredTableAssociation",
               "New-CRSConfiguredTableAssociationAnalysisRule",
               "New-CRSIdMappingTable",
               "New-CRSIdNamespaceAssociation",
               "New-CRSMembership",
               "New-CRSPrivacyBudgetTemplate",
               "Remove-CRSAnalysisTemplate",
               "Remove-CRSCollaboration",
               "Remove-CRSConfiguredAudienceModelAssociation",
               "Remove-CRSConfiguredTable",
               "Remove-CRSConfiguredTableAnalysisRule",
               "Remove-CRSConfiguredTableAssociation",
               "Remove-CRSConfiguredTableAssociationAnalysisRule",
               "Remove-CRSIdMappingTable",
               "Remove-CRSIdNamespaceAssociation",
               "Remove-CRSMember",
               "Remove-CRSMembership",
               "Remove-CRSPrivacyBudgetTemplate",
               "Get-CRSAnalysisTemplate",
               "Get-CRSCollaboration",
               "Get-CRSCollaborationAnalysisTemplate",
               "Get-CRSCollaborationChangeRequest",
               "Get-CRSCollaborationConfiguredAudienceModelAssociation",
               "Get-CRSCollaborationIdNamespaceAssociation",
               "Get-CRSCollaborationPrivacyBudgetTemplate",
               "Get-CRSConfiguredAudienceModelAssociation",
               "Get-CRSConfiguredTable",
               "Get-CRSConfiguredTableAnalysisRule",
               "Get-CRSConfiguredTableAssociation",
               "Get-CRSConfiguredTableAssociationAnalysisRule",
               "Get-CRSIdMappingTable",
               "Get-CRSIdNamespaceAssociation",
               "Get-CRSMembership",
               "Get-CRSPrivacyBudgetTemplate",
               "Get-CRSProtectedJob",
               "Get-CRSProtectedQuery",
               "Get-CRSSchema",
               "Get-CRSSchemaAnalysisRule",
               "Get-CRSAnalysisTemplateList",
               "Get-CRSCollaborationAnalysisTemplateList",
               "Get-CRSCollaborationChangeRequestList",
               "Get-CRSCollaborationConfiguredAudienceModelAssociationList",
               "Get-CRSCollaborationIdNamespaceAssociationList",
               "Get-CRSCollaborationPrivacyBudgetList",
               "Get-CRSCollaborationPrivacyBudgetTemplateList",
               "Get-CRSCollaborationList",
               "Get-CRSConfiguredAudienceModelAssociationList",
               "Get-CRSConfiguredTableAssociationList",
               "Get-CRSConfiguredTableList",
               "Get-CRSIdMappingTableList",
               "Get-CRSIdNamespaceAssociationList",
               "Get-CRSMemberList",
               "Get-CRSMembershipList",
               "Get-CRSPrivacyBudgetList",
               "Get-CRSPrivacyBudgetTemplateList",
               "Get-CRSProtectedJobList",
               "Get-CRSProtectedQueryList",
               "Get-CRSSchemaList",
               "Get-CRSResourceTag",
               "Invoke-CRSIdMappingTable",
               "Test-CRSPrivacyImpact",
               "Start-CRSProtectedJob",
               "Start-CRSProtectedQuery",
               "Add-CRSResourceTag",
               "Remove-CRSResourceTag",
               "Update-CRSAnalysisTemplate",
               "Update-CRSCollaboration",
               "Update-CRSConfiguredAudienceModelAssociation",
               "Update-CRSConfiguredTable",
               "Update-CRSConfiguredTableAnalysisRule",
               "Update-CRSConfiguredTableAssociation",
               "Update-CRSConfiguredTableAssociationAnalysisRule",
               "Update-CRSIdMappingTable",
               "Update-CRSIdNamespaceAssociation",
               "Update-CRSMembership",
               "Update-CRSPrivacyBudgetTemplate",
               "Update-CRSProtectedJob",
               "Update-CRSProtectedQuery")
}

_awsArgumentCompleterRegistration $CRS_SelectCompleters $CRS_SelectMap
# Argument completions for service CleanRoomsML


$CRML_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CleanRoomsML.AudienceSizeType
        {
            ($_ -eq "Start-CRMLAudienceExportJob/AudienceSize_Type") -Or
            ($_ -eq "New-CRMLConfiguredAudienceModel/AudienceSizeConfig_AudienceSizeType") -Or
            ($_ -eq "Update-CRMLConfiguredAudienceModel/AudienceSizeConfig_AudienceSizeType")
        }
        {
            $v = "ABSOLUTE","PERCENTAGE"
            break
        }

        # Amazon.CleanRoomsML.InferenceInstanceType
        "Start-CRMLTrainedModelInferenceJob/ResourceConfig_InstanceType"
        {
            $v = "ml.c4.2xlarge","ml.c4.4xlarge","ml.c4.8xlarge","ml.c4.xlarge","ml.c5.18xlarge","ml.c5.2xlarge","ml.c5.4xlarge","ml.c5.9xlarge","ml.c5.xlarge","ml.c6i.12xlarge","ml.c6i.16xlarge","ml.c6i.24xlarge","ml.c6i.2xlarge","ml.c6i.32xlarge","ml.c6i.4xlarge","ml.c6i.8xlarge","ml.c6i.large","ml.c6i.xlarge","ml.c7i.12xlarge","ml.c7i.16xlarge","ml.c7i.24xlarge","ml.c7i.2xlarge","ml.c7i.48xlarge","ml.c7i.4xlarge","ml.c7i.8xlarge","ml.c7i.large","ml.c7i.xlarge","ml.g4dn.12xlarge","ml.g4dn.16xlarge","ml.g4dn.2xlarge","ml.g4dn.4xlarge","ml.g4dn.8xlarge","ml.g4dn.xlarge","ml.g5.12xlarge","ml.g5.16xlarge","ml.g5.24xlarge","ml.g5.2xlarge","ml.g5.48xlarge","ml.g5.4xlarge","ml.g5.8xlarge","ml.g5.xlarge","ml.m4.10xlarge","ml.m4.16xlarge","ml.m4.2xlarge","ml.m4.4xlarge","ml.m4.xlarge","ml.m5.12xlarge","ml.m5.24xlarge","ml.m5.2xlarge","ml.m5.4xlarge","ml.m5.large","ml.m5.xlarge","ml.m6i.12xlarge","ml.m6i.16xlarge","ml.m6i.24xlarge","ml.m6i.2xlarge","ml.m6i.32xlarge","ml.m6i.4xlarge","ml.m6i.8xlarge","ml.m6i.large","ml.m6i.xlarge","ml.m7i.12xlarge","ml.m7i.16xlarge","ml.m7i.24xlarge","ml.m7i.2xlarge","ml.m7i.48xlarge","ml.m7i.4xlarge","ml.m7i.8xlarge","ml.m7i.large","ml.m7i.xlarge","ml.p2.16xlarge","ml.p2.8xlarge","ml.p2.xlarge","ml.p3.16xlarge","ml.p3.2xlarge","ml.p3.8xlarge","ml.r6i.12xlarge","ml.r6i.16xlarge","ml.r6i.24xlarge","ml.r6i.2xlarge","ml.r6i.32xlarge","ml.r6i.4xlarge","ml.r6i.8xlarge","ml.r6i.large","ml.r6i.xlarge","ml.r7i.12xlarge","ml.r7i.16xlarge","ml.r7i.24xlarge","ml.r7i.2xlarge","ml.r7i.48xlarge","ml.r7i.4xlarge","ml.r7i.8xlarge","ml.r7i.large","ml.r7i.xlarge"
            break
        }

        # Amazon.CleanRoomsML.InstanceType
        "New-CRMLTrainedModel/ResourceConfig_InstanceType"
        {
            $v = "ml.c4.2xlarge","ml.c4.4xlarge","ml.c4.8xlarge","ml.c4.xlarge","ml.c5.18xlarge","ml.c5.2xlarge","ml.c5.4xlarge","ml.c5.9xlarge","ml.c5.xlarge","ml.c5n.18xlarge","ml.c5n.2xlarge","ml.c5n.4xlarge","ml.c5n.9xlarge","ml.c5n.xlarge","ml.c6i.12xlarge","ml.c6i.16xlarge","ml.c6i.24xlarge","ml.c6i.2xlarge","ml.c6i.32xlarge","ml.c6i.4xlarge","ml.c6i.8xlarge","ml.c6i.xlarge","ml.c7i.12xlarge","ml.c7i.16xlarge","ml.c7i.24xlarge","ml.c7i.2xlarge","ml.c7i.48xlarge","ml.c7i.4xlarge","ml.c7i.8xlarge","ml.c7i.large","ml.c7i.xlarge","ml.g4dn.12xlarge","ml.g4dn.16xlarge","ml.g4dn.2xlarge","ml.g4dn.4xlarge","ml.g4dn.8xlarge","ml.g4dn.xlarge","ml.g5.12xlarge","ml.g5.16xlarge","ml.g5.24xlarge","ml.g5.2xlarge","ml.g5.48xlarge","ml.g5.4xlarge","ml.g5.8xlarge","ml.g5.xlarge","ml.g6.12xlarge","ml.g6.16xlarge","ml.g6.24xlarge","ml.g6.2xlarge","ml.g6.48xlarge","ml.g6.4xlarge","ml.g6.8xlarge","ml.g6.xlarge","ml.g6e.12xlarge","ml.g6e.16xlarge","ml.g6e.24xlarge","ml.g6e.2xlarge","ml.g6e.48xlarge","ml.g6e.4xlarge","ml.g6e.8xlarge","ml.g6e.xlarge","ml.m4.10xlarge","ml.m4.16xlarge","ml.m4.2xlarge","ml.m4.4xlarge","ml.m4.xlarge","ml.m5.12xlarge","ml.m5.24xlarge","ml.m5.2xlarge","ml.m5.4xlarge","ml.m5.large","ml.m5.xlarge","ml.m6i.12xlarge","ml.m6i.16xlarge","ml.m6i.24xlarge","ml.m6i.2xlarge","ml.m6i.32xlarge","ml.m6i.4xlarge","ml.m6i.8xlarge","ml.m6i.large","ml.m6i.xlarge","ml.m7i.12xlarge","ml.m7i.16xlarge","ml.m7i.24xlarge","ml.m7i.2xlarge","ml.m7i.48xlarge","ml.m7i.4xlarge","ml.m7i.8xlarge","ml.m7i.large","ml.m7i.xlarge","ml.p2.16xlarge","ml.p2.8xlarge","ml.p2.xlarge","ml.p3.16xlarge","ml.p3.2xlarge","ml.p3.8xlarge","ml.p3dn.24xlarge","ml.p4d.24xlarge","ml.p4de.24xlarge","ml.p5.48xlarge","ml.p5en.48xlarge","ml.r5.12xlarge","ml.r5.16xlarge","ml.r5.24xlarge","ml.r5.2xlarge","ml.r5.4xlarge","ml.r5.8xlarge","ml.r5.large","ml.r5.xlarge","ml.r5d.12xlarge","ml.r5d.16xlarge","ml.r5d.24xlarge","ml.r5d.2xlarge","ml.r5d.4xlarge","ml.r5d.8xlarge","ml.r5d.large","ml.r5d.xlarge","ml.r7i.12xlarge","ml.r7i.16xlarge","ml.r7i.24xlarge","ml.r7i.2xlarge","ml.r7i.48xlarge","ml.r7i.4xlarge","ml.r7i.8xlarge","ml.r7i.large","ml.r7i.xlarge","ml.t3.2xlarge","ml.t3.large","ml.t3.medium","ml.t3.xlarge","ml.trn1.2xlarge","ml.trn1.32xlarge","ml.trn1n.32xlarge"
            break
        }

        # Amazon.CleanRoomsML.NoiseLevelType
        "New-CRMLConfiguredModelAlgorithmAssociation/ContainerMetrics_NoiseLevel"
        {
            $v = "HIGH","LOW","MEDIUM","NONE"
            break
        }

        # Amazon.CleanRoomsML.PolicyExistenceCondition
        "Write-CRMLConfiguredAudienceModelPolicy/PolicyExistenceCondition"
        {
            $v = "POLICY_MUST_EXIST","POLICY_MUST_NOT_EXIST"
            break
        }

        # Amazon.CleanRoomsML.ResultFormat
        "New-CRMLMLInputChannel/ProtectedQueryInputParameters_ResultFormat"
        {
            $v = "CSV","PARQUET"
            break
        }

        # Amazon.CleanRoomsML.TagOnCreatePolicy
        "New-CRMLConfiguredAudienceModel/ChildResourceTagOnCreatePolicy"
        {
            $v = "FROM_PARENT_RESOURCE","NONE"
            break
        }

        # Amazon.CleanRoomsML.TrainedModelArtifactMaxSizeUnitType
        "New-CRMLConfiguredModelAlgorithmAssociation/MaxArtifactSize_Unit"
        {
            $v = "GB"
            break
        }

        # Amazon.CleanRoomsML.TrainedModelExportsMaxSizeUnitType
        "New-CRMLConfiguredModelAlgorithmAssociation/MaxSize_Unit"
        {
            $v = "GB"
            break
        }

        # Amazon.CleanRoomsML.TrainedModelInferenceMaxOutputSizeUnitType
        "New-CRMLConfiguredModelAlgorithmAssociation/MaxOutputSize_Unit"
        {
            $v = "GB"
            break
        }

        # Amazon.CleanRoomsML.TrainedModelStatus
        "Get-CRMLTrainedModelVersionList/Status"
        {
            $v = "ACTIVE","CANCEL_FAILED","CANCEL_IN_PROGRESS","CANCEL_PENDING","CREATE_FAILED","CREATE_IN_PROGRESS","CREATE_PENDING","DELETE_FAILED","DELETE_IN_PROGRESS","DELETE_PENDING","INACTIVE"
            break
        }

        # Amazon.CleanRoomsML.TrainingInputMode
        "New-CRMLTrainedModel/TrainingInputMode"
        {
            $v = "FastFile","File","Pipe"
            break
        }

        # Amazon.CleanRoomsML.WorkerComputeType
        {
            ($_ -eq "New-CRMLMLInputChannel/Worker_Type") -Or
            ($_ -eq "Start-CRMLAudienceGenerationJob/Worker_Type")
        }
        {
            $v = "CR.1X","CR.4X"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CRML_map = @{
    "AudienceSize_Type"=@("Start-CRMLAudienceExportJob")
    "AudienceSizeConfig_AudienceSizeType"=@("New-CRMLConfiguredAudienceModel","Update-CRMLConfiguredAudienceModel")
    "ChildResourceTagOnCreatePolicy"=@("New-CRMLConfiguredAudienceModel")
    "ContainerMetrics_NoiseLevel"=@("New-CRMLConfiguredModelAlgorithmAssociation")
    "MaxArtifactSize_Unit"=@("New-CRMLConfiguredModelAlgorithmAssociation")
    "MaxOutputSize_Unit"=@("New-CRMLConfiguredModelAlgorithmAssociation")
    "MaxSize_Unit"=@("New-CRMLConfiguredModelAlgorithmAssociation")
    "PolicyExistenceCondition"=@("Write-CRMLConfiguredAudienceModelPolicy")
    "ProtectedQueryInputParameters_ResultFormat"=@("New-CRMLMLInputChannel")
    "ResourceConfig_InstanceType"=@("New-CRMLTrainedModel","Start-CRMLTrainedModelInferenceJob")
    "Status"=@("Get-CRMLTrainedModelVersionList")
    "TrainingInputMode"=@("New-CRMLTrainedModel")
    "Worker_Type"=@("New-CRMLMLInputChannel","Start-CRMLAudienceGenerationJob")
}

_awsArgumentCompleterRegistration $CRML_Completers $CRML_map

$CRML_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CRML.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CRML_SelectMap = @{
    "Select"=@("Stop-CRMLTrainedModel",
               "Stop-CRMLTrainedModelInferenceJob",
               "New-CRMLAudienceModel",
               "New-CRMLConfiguredAudienceModel",
               "New-CRMLConfiguredModelAlgorithm",
               "New-CRMLConfiguredModelAlgorithmAssociation",
               "New-CRMLMLInputChannel",
               "New-CRMLTrainedModel",
               "New-CRMLTrainingDataset",
               "Remove-CRMLAudienceGenerationJob",
               "Remove-CRMLAudienceModel",
               "Remove-CRMLConfiguredAudienceModel",
               "Remove-CRMLConfiguredAudienceModelPolicy",
               "Remove-CRMLConfiguredModelAlgorithm",
               "Remove-CRMLConfiguredModelAlgorithmAssociation",
               "Remove-CRMLMLConfiguration",
               "Remove-CRMLMLInputChannelData",
               "Remove-CRMLTrainedModelOutput",
               "Remove-CRMLTrainingDataset",
               "Get-CRMLAudienceGenerationJob",
               "Get-CRMLAudienceModel",
               "Get-CRMLCollaborationConfiguredModelAlgorithmAssociation",
               "Get-CRMLCollaborationMLInputChannel",
               "Get-CRMLCollaborationTrainedModel",
               "Get-CRMLConfiguredAudienceModel",
               "Get-CRMLConfiguredAudienceModelPolicy",
               "Get-CRMLConfiguredModelAlgorithm",
               "Get-CRMLConfiguredModelAlgorithmAssociation",
               "Get-CRMLMLConfiguration",
               "Get-CRMLMLInputChannel",
               "Get-CRMLTrainedModel",
               "Get-CRMLTrainedModelInferenceJob",
               "Get-CRMLTrainingDataset",
               "Get-CRMLAudienceExportJobList",
               "Get-CRMLAudienceGenerationJobList",
               "Get-CRMLAudienceModelList",
               "Get-CRMLCollaborationConfiguredModelAlgorithmAssociationList",
               "Get-CRMLCollaborationMLInputChannelList",
               "Get-CRMLCollaborationTrainedModelExportJobList",
               "Get-CRMLCollaborationTrainedModelInferenceJobList",
               "Get-CRMLCollaborationTrainedModelList",
               "Get-CRMLConfiguredAudienceModelList",
               "Get-CRMLConfiguredModelAlgorithmAssociationList",
               "Get-CRMLConfiguredModelAlgorithmList",
               "Get-CRMLMLInputChannelList",
               "Get-CRMLResourceTag",
               "Get-CRMLTrainedModelInferenceJobList",
               "Get-CRMLTrainedModelList",
               "Get-CRMLTrainedModelVersionList",
               "Get-CRMLTrainingDatasetList",
               "Write-CRMLConfiguredAudienceModelPolicy",
               "Write-CRMLMLConfiguration",
               "Start-CRMLAudienceExportJob",
               "Start-CRMLAudienceGenerationJob",
               "Start-CRMLTrainedModelExportJob",
               "Start-CRMLTrainedModelInferenceJob",
               "Add-CRMLResourceTag",
               "Remove-CRMLResourceTag",
               "Update-CRMLConfiguredAudienceModel")
}

_awsArgumentCompleterRegistration $CRML_SelectCompleters $CRML_SelectMap
# Argument completions for service AWS Cloud9


$C9_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.Cloud9.ConnectionType
        "New-C9EnvironmentEC2/ConnectionType"
        {
            $v = "CONNECT_SSH","CONNECT_SSM"
            break
        }

        # Amazon.Cloud9.ManagedCredentialsAction
        "Update-C9Environment/ManagedCredentialsAction"
        {
            $v = "DISABLE","ENABLE"
            break
        }

        # Amazon.Cloud9.MemberPermissions
        {
            ($_ -eq "New-C9EnvironmentMembership/Permission") -Or
            ($_ -eq "Update-C9EnvironmentMembership/Permission")
        }
        {
            $v = "read-only","read-write"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$C9_map = @{
    "ConnectionType"=@("New-C9EnvironmentEC2")
    "ManagedCredentialsAction"=@("Update-C9Environment")
    "Permission"=@("New-C9EnvironmentMembership","Update-C9EnvironmentMembership")
}

_awsArgumentCompleterRegistration $C9_Completers $C9_map

$C9_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.C9.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$C9_SelectMap = @{
    "Select"=@("New-C9EnvironmentEC2",
               "New-C9EnvironmentMembership",
               "Remove-C9Environment",
               "Remove-C9EnvironmentMembership",
               "Get-C9EnvironmentMembershipList",
               "Get-C9EnvironmentData",
               "Get-C9EnvironmentStatus",
               "Get-C9EnvironmentList",
               "Get-C9ResourceTag",
               "Add-C9ResourceTag",
               "Remove-C9ResourceTag",
               "Update-C9Environment",
               "Update-C9EnvironmentMembership")
}

_awsArgumentCompleterRegistration $C9_SelectCompleters $C9_SelectMap
# Argument completions for service AWS Cloud Control API


$CCA_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CCA.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CCA_SelectMap = @{
    "Select"=@("Stop-CCAResourceRequest",
               "New-CCAResource",
               "Remove-CCAResource",
               "Get-CCAResource",
               "Get-CCAResourceRequestStatus",
               "Get-CCAResourceRequestList",
               "Get-CCAResourceList",
               "Update-CCAResource")
}

_awsArgumentCompleterRegistration $CCA_SelectCompleters $CCA_SelectMap
# Argument completions for service Amazon Cloud Directory


$CDIR_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CloudDirectory.ConsistencyLevel
        {
            ($_ -eq "Get-CDIRIncomingTypedLink/ConsistencyLevel") -Or
            ($_ -eq "Get-CDIRIndex/ConsistencyLevel") -Or
            ($_ -eq "Get-CDIRLinkAttribute/ConsistencyLevel") -Or
            ($_ -eq "Get-CDIRObjectAttribute/ConsistencyLevel") -Or
            ($_ -eq "Get-CDIRObjectAttributeList/ConsistencyLevel") -Or
            ($_ -eq "Get-CDIRObjectChild/ConsistencyLevel") -Or
            ($_ -eq "Get-CDIRObjectIndex/ConsistencyLevel") -Or
            ($_ -eq "Get-CDIRObjectInformation/ConsistencyLevel") -Or
            ($_ -eq "Get-CDIRObjectParent/ConsistencyLevel") -Or
            ($_ -eq "Get-CDIRObjectPolicy/ConsistencyLevel") -Or
            ($_ -eq "Get-CDIROutgoingTypedLink/ConsistencyLevel") -Or
            ($_ -eq "Get-CDIRPolicyAttachment/ConsistencyLevel") -Or
            ($_ -eq "Read-CDIRDirectoryBatch/ConsistencyLevel")
        }
        {
            $v = "EVENTUAL","SERIALIZABLE"
            break
        }

        # Amazon.CloudDirectory.DirectoryState
        "Get-CDIRDirectory/State"
        {
            $v = "DELETED","DISABLED","ENABLED"
            break
        }

        # Amazon.CloudDirectory.FacetStyle
        "New-CDIRFacet/FacetStyle"
        {
            $v = "DYNAMIC","STATIC"
            break
        }

        # Amazon.CloudDirectory.ObjectType
        {
            ($_ -eq "New-CDIRFacet/ObjectType") -Or
            ($_ -eq "Update-CDIRFacet/ObjectType")
        }
        {
            $v = "INDEX","LEAF_NODE","NODE","POLICY"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CDIR_map = @{
    "ConsistencyLevel"=@("Get-CDIRIncomingTypedLink","Get-CDIRIndex","Get-CDIRLinkAttribute","Get-CDIRObjectAttribute","Get-CDIRObjectAttributeList","Get-CDIRObjectChild","Get-CDIRObjectIndex","Get-CDIRObjectInformation","Get-CDIRObjectParent","Get-CDIRObjectPolicy","Get-CDIROutgoingTypedLink","Get-CDIRPolicyAttachment","Read-CDIRDirectoryBatch")
    "FacetStyle"=@("New-CDIRFacet")
    "ObjectType"=@("New-CDIRFacet","Update-CDIRFacet")
    "State"=@("Get-CDIRDirectory")
}

_awsArgumentCompleterRegistration $CDIR_Completers $CDIR_map

$CDIR_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CDIR.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CDIR_SelectMap = @{
    "Select"=@("Add-CDIRFacetToObject",
               "Add-CDIRSchema",
               "Connect-CDIRObject",
               "Mount-CDIRPolicy",
               "Mount-CDIRObjectToIndex",
               "Mount-CDIRTypedLink",
               "Read-CDIRDirectoryBatch",
               "Write-CDIRDirectoryBatch",
               "New-CDIRDirectory",
               "New-CDIRFacet",
               "New-CDIRIndex",
               "New-CDIRDirectoryObject",
               "New-CDIRSchema",
               "New-CDIRTypedLinkFacet",
               "Remove-CDIRDirectory",
               "Remove-CDIRFacet",
               "Remove-CDIRDirectoryObject",
               "Remove-CDIRSchema",
               "Remove-CDIRTypedLinkFacet",
               "Dismount-CDIRObjectFromIndex",
               "Disconnect-CDIRObject",
               "Dismount-CDIRPolicyFromObject",
               "Dismount-CDIRTypedLink",
               "Disable-CDIRDirectory",
               "Enable-CDIRDirectory",
               "Get-CDIRAppliedSchemaVersion",
               "Get-CDIRDirectoryMetadata",
               "Get-CDIRFacet",
               "Get-CDIRLinkAttribute",
               "Get-CDIRObjectAttribute",
               "Get-CDIRObjectInformation",
               "Get-CDIRSchemaAsJson",
               "Get-CDIRTypedLinkFacetInformation",
               "Get-CDIRAppliedSchemaArn",
               "Get-CDIRObjectIndex",
               "Get-CDIRDevelopmentSchemaArn",
               "Get-CDIRDirectory",
               "Get-CDIRFacetAttribute",
               "Get-CDIRFacetName",
               "Get-CDIRIncomingTypedLink",
               "Get-CDIRIndex",
               "Get-CDIRManagedSchemaArn",
               "Get-CDIRObjectAttributeList",
               "Get-CDIRObjectChild",
               "Get-CDIRObjectParentPath",
               "Get-CDIRObjectParent",
               "Get-CDIRObjectPolicy",
               "Get-CDIROutgoingTypedLink",
               "Get-CDIRPolicyAttachment",
               "Get-CDIRPublishedSchemaArn",
               "Get-CDIRResourceTag",
               "Get-CDIRTypedLinkFacetAttribute",
               "Get-CDIRTypedLinkFacetName",
               "Get-CDIRDirectoryPolicy",
               "Publish-CDIRSchema",
               "Write-CDIRSchemaFromJson",
               "Remove-CDIRFacetFromObject",
               "Add-CDIRResourceTag",
               "Remove-CDIRResourceTag",
               "Update-CDIRFacet",
               "Update-CDIRLinkAttribute",
               "Update-CDIRObjectAttribute",
               "Update-CDIRSchema",
               "Update-CDIRTypedLinkFacet",
               "Update-CDIRAppliedSchema",
               "Update-CDIRPublishedSchema")
}

_awsArgumentCompleterRegistration $CDIR_SelectCompleters $CDIR_SelectMap
# Argument completions for service AWS CloudFormation


$CFN_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CloudFormation.AccountFilterType
        {
            ($_ -eq "New-CFNStackInstance/DeploymentTargets_AccountFilterType") -Or
            ($_ -eq "Remove-CFNStackInstance/DeploymentTargets_AccountFilterType") -Or
            ($_ -eq "Update-CFNStackInstance/DeploymentTargets_AccountFilterType") -Or
            ($_ -eq "Update-CFNStackSet/DeploymentTargets_AccountFilterType")
        }
        {
            $v = "DIFFERENCE","INTERSECTION","NONE","UNION"
            break
        }

        # Amazon.CloudFormation.CallAs
        {
            ($_ -eq "Get-CFNOrganizationsAccess/CallAs") -Or
            ($_ -eq "Get-CFNStackInstance/CallAs") -Or
            ($_ -eq "Get-CFNStackInstanceList/CallAs") -Or
            ($_ -eq "Get-CFNStackInstanceResourceDrift/CallAs") -Or
            ($_ -eq "Get-CFNStackSet/CallAs") -Or
            ($_ -eq "Get-CFNStackSetAutoDeploymentTarget/CallAs") -Or
            ($_ -eq "Get-CFNStackSetList/CallAs") -Or
            ($_ -eq "Get-CFNStackSetOperation/CallAs") -Or
            ($_ -eq "Get-CFNStackSetOperationList/CallAs") -Or
            ($_ -eq "Get-CFNStackSetOperationResultList/CallAs") -Or
            ($_ -eq "Get-CFNTemplateSummary/CallAs") -Or
            ($_ -eq "Import-CFNStacksToStackSet/CallAs") -Or
            ($_ -eq "New-CFNStackInstance/CallAs") -Or
            ($_ -eq "New-CFNStackSet/CallAs") -Or
            ($_ -eq "Remove-CFNStackInstance/CallAs") -Or
            ($_ -eq "Remove-CFNStackSet/CallAs") -Or
            ($_ -eq "Start-CFNStackSetDriftDetection/CallAs") -Or
            ($_ -eq "Stop-CFNStackSetOperation/CallAs") -Or
            ($_ -eq "Update-CFNStackInstance/CallAs") -Or
            ($_ -eq "Update-CFNStackSet/CallAs")
        }
        {
            $v = "DELEGATED_ADMIN","SELF"
            break
        }

        # Amazon.CloudFormation.Category
        "Get-CFNTypeList/Filters_Category"
        {
            $v = "ACTIVATED","AWS_TYPES","REGISTERED","THIRD_PARTY"
            break
        }

        # Amazon.CloudFormation.ChangeSetType
        "New-CFNChangeSet/ChangeSetType"
        {
            $v = "CREATE","IMPORT","UPDATE"
            break
        }

        # Amazon.CloudFormation.DeletionMode
        "Remove-CFNStack/DeletionMode"
        {
            $v = "FORCE_DELETE_STACK","STANDARD"
            break
        }

        # Amazon.CloudFormation.DeprecatedStatus
        {
            ($_ -eq "Get-CFNTypeList/DeprecatedStatus") -Or
            ($_ -eq "Get-CFNTypeVersion/DeprecatedStatus")
        }
        {
            $v = "DEPRECATED","LIVE"
            break
        }

        # Amazon.CloudFormation.GeneratedTemplateDeletionPolicy
        {
            ($_ -eq "New-CFNGeneratedTemplate/TemplateConfiguration_DeletionPolicy") -Or
            ($_ -eq "Update-CFNGeneratedTemplate/TemplateConfiguration_DeletionPolicy")
        }
        {
            $v = "DELETE","RETAIN"
            break
        }

        # Amazon.CloudFormation.GeneratedTemplateUpdateReplacePolicy
        {
            ($_ -eq "New-CFNGeneratedTemplate/TemplateConfiguration_UpdateReplacePolicy") -Or
            ($_ -eq "Update-CFNGeneratedTemplate/TemplateConfiguration_UpdateReplacePolicy")
        }
        {
            $v = "DELETE","RETAIN"
            break
        }

        # Amazon.CloudFormation.HandlerErrorCode
        "Write-CFNHandlerProgress/ErrorCode"
        {
            $v = "AccessDenied","AlreadyExists","GeneralServiceException","HandlerInternalFailure","InternalFailure","InvalidCredentials","InvalidRequest","InvalidTypeConfiguration","NetworkFailure","NonCompliant","NotFound","NotStabilized","NotUpdatable","ResourceConflict","ServiceInternalError","ServiceLimitExceeded","Throttling","Unknown","UnsupportedTarget"
            break
        }

        # Amazon.CloudFormation.HookStatus
        "Get-CFNHookResult/Status"
        {
            $v = "HOOK_COMPLETE_FAILED","HOOK_COMPLETE_SUCCEEDED","HOOK_FAILED","HOOK_IN_PROGRESS"
            break
        }

        # Amazon.CloudFormation.ListHookResultsTargetType
        "Get-CFNHookResult/TargetType"
        {
            $v = "CHANGE_SET","CLOUD_CONTROL","RESOURCE","STACK"
            break
        }

        # Amazon.CloudFormation.OnFailure
        "New-CFNStack/OnFailure"
        {
            $v = "DELETE","DO_NOTHING","ROLLBACK"
            break
        }

        # Amazon.CloudFormation.OnStackFailure
        "New-CFNChangeSet/OnStackFailure"
        {
            $v = "DELETE","DO_NOTHING","ROLLBACK"
            break
        }

        # Amazon.CloudFormation.OperationStatus
        {
            ($_ -eq "Write-CFNHandlerProgress/CurrentOperationStatus") -Or
            ($_ -eq "Write-CFNHandlerProgress/OperationStatus")
        }
        {
            $v = "FAILED","IN_PROGRESS","PENDING","SUCCESS"
            break
        }

        # Amazon.CloudFormation.PermissionModels
        {
            ($_ -eq "New-CFNStackSet/PermissionModel") -Or
            ($_ -eq "Update-CFNStackSet/PermissionModel")
        }
        {
            $v = "SELF_MANAGED","SERVICE_MANAGED"
            break
        }

        # Amazon.CloudFormation.ProvisioningType
        "Get-CFNTypeList/ProvisioningType"
        {
            $v = "FULLY_MUTABLE","IMMUTABLE","NON_PROVISIONABLE"
            break
        }

        # Amazon.CloudFormation.RegistrationStatus
        "Get-CFNTypeRegistrationList/RegistrationStatusFilter"
        {
            $v = "COMPLETE","FAILED","IN_PROGRESS"
            break
        }

        # Amazon.CloudFormation.RegistryType
        {
            ($_ -eq "Get-CFNType/Type") -Or
            ($_ -eq "Get-CFNTypeList/Type") -Or
            ($_ -eq "Get-CFNTypeRegistrationList/Type") -Or
            ($_ -eq "Get-CFNTypeVersion/Type") -Or
            ($_ -eq "Register-CFNType/Type") -Or
            ($_ -eq "Set-CFNTypeDefaultVersion/Type") -Or
            ($_ -eq "Unregister-CFNType/Type")
        }
        {
            $v = "HOOK","MODULE","RESOURCE"
            break
        }

        # Amazon.CloudFormation.ResourceSignalStatus
        "Send-CFNResourceSignal/Status"
        {
            $v = "FAILURE","SUCCESS"
            break
        }

        # Amazon.CloudFormation.ScanType
        "Get-CFNResourceScanList/ScanTypeFilter"
        {
            $v = "FULL","PARTIAL"
            break
        }

        # Amazon.CloudFormation.StackSetStatus
        "Get-CFNStackSetList/Status"
        {
            $v = "ACTIVE","DELETED"
            break
        }

        # Amazon.CloudFormation.StackStatus
        {
            ($_ -eq "Test-CFNStack/Status") -Or
            ($_ -eq "Wait-CFNStack/Status")
        }
        {
            $v = "CREATE_COMPLETE","CREATE_FAILED","CREATE_IN_PROGRESS","DELETE_COMPLETE","DELETE_FAILED","DELETE_IN_PROGRESS","IMPORT_COMPLETE","IMPORT_IN_PROGRESS","IMPORT_ROLLBACK_COMPLETE","IMPORT_ROLLBACK_FAILED","IMPORT_ROLLBACK_IN_PROGRESS","REVIEW_IN_PROGRESS","ROLLBACK_COMPLETE","ROLLBACK_FAILED","ROLLBACK_IN_PROGRESS","UPDATE_COMPLETE","UPDATE_COMPLETE_CLEANUP_IN_PROGRESS","UPDATE_FAILED","UPDATE_IN_PROGRESS","UPDATE_ROLLBACK_COMPLETE","UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS","UPDATE_ROLLBACK_FAILED","UPDATE_ROLLBACK_IN_PROGRESS"
            break
        }

        # Amazon.CloudFormation.TemplateFormat
        "Get-CFNGeneratedTemplate/Format"
        {
            $v = "JSON","YAML"
            break
        }

        # Amazon.CloudFormation.TemplateStage
        "Get-CFNTemplate/TemplateStage"
        {
            $v = "Original","Processed"
            break
        }

        # Amazon.CloudFormation.ThirdPartyType
        {
            ($_ -eq "Disable-CFNType/Type") -Or
            ($_ -eq "Enable-CFNType/Type") -Or
            ($_ -eq "Publish-CFNType/Type") -Or
            ($_ -eq "Set-CFNTypeConfiguration/Type") -Or
            ($_ -eq "Test-CFNType/Type")
        }
        {
            $v = "HOOK","MODULE","RESOURCE"
            break
        }

        # Amazon.CloudFormation.VersionBump
        "Enable-CFNType/VersionBump"
        {
            $v = "MAJOR","MINOR"
            break
        }

        # Amazon.CloudFormation.Visibility
        "Get-CFNTypeList/Visibility"
        {
            $v = "PRIVATE","PUBLIC"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CFN_map = @{
    "CallAs"=@("Get-CFNOrganizationsAccess","Get-CFNStackInstance","Get-CFNStackInstanceList","Get-CFNStackInstanceResourceDrift","Get-CFNStackSet","Get-CFNStackSetAutoDeploymentTarget","Get-CFNStackSetList","Get-CFNStackSetOperation","Get-CFNStackSetOperationList","Get-CFNStackSetOperationResultList","Get-CFNTemplateSummary","Import-CFNStacksToStackSet","New-CFNStackInstance","New-CFNStackSet","Remove-CFNStackInstance","Remove-CFNStackSet","Start-CFNStackSetDriftDetection","Stop-CFNStackSetOperation","Update-CFNStackInstance","Update-CFNStackSet")
    "ChangeSetType"=@("New-CFNChangeSet")
    "CurrentOperationStatus"=@("Write-CFNHandlerProgress")
    "DeletionMode"=@("Remove-CFNStack")
    "DeploymentTargets_AccountFilterType"=@("New-CFNStackInstance","Remove-CFNStackInstance","Update-CFNStackInstance","Update-CFNStackSet")
    "DeprecatedStatus"=@("Get-CFNTypeList","Get-CFNTypeVersion")
    "ErrorCode"=@("Write-CFNHandlerProgress")
    "Filters_Category"=@("Get-CFNTypeList")
    "Format"=@("Get-CFNGeneratedTemplate")
    "OnFailure"=@("New-CFNStack")
    "OnStackFailure"=@("New-CFNChangeSet")
    "OperationStatus"=@("Write-CFNHandlerProgress")
    "PermissionModel"=@("New-CFNStackSet","Update-CFNStackSet")
    "ProvisioningType"=@("Get-CFNTypeList")
    "RegistrationStatusFilter"=@("Get-CFNTypeRegistrationList")
    "ScanTypeFilter"=@("Get-CFNResourceScanList")
    "Status"=@("Get-CFNHookResult","Get-CFNStackSetList","Send-CFNResourceSignal","Test-CFNStack","Wait-CFNStack")
    "TargetType"=@("Get-CFNHookResult")
    "TemplateConfiguration_DeletionPolicy"=@("New-CFNGeneratedTemplate","Update-CFNGeneratedTemplate")
    "TemplateConfiguration_UpdateReplacePolicy"=@("New-CFNGeneratedTemplate","Update-CFNGeneratedTemplate")
    "TemplateStage"=@("Get-CFNTemplate")
    "Type"=@("Disable-CFNType","Enable-CFNType","Get-CFNType","Get-CFNTypeList","Get-CFNTypeRegistrationList","Get-CFNTypeVersion","Publish-CFNType","Register-CFNType","Set-CFNTypeConfiguration","Set-CFNTypeDefaultVersion","Test-CFNType","Unregister-CFNType")
    "VersionBump"=@("Enable-CFNType")
    "Visibility"=@("Get-CFNTypeList")
}

_awsArgumentCompleterRegistration $CFN_Completers $CFN_map

$CFN_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CFN.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CFN_SelectMap = @{
    "Select"=@("Enable-CFNOrganizationsAccess",
               "Enable-CFNType",
               "Get-CFNDescribeTypeConfiguration",
               "Stop-CFNUpdateStack",
               "Resume-CFNUpdateRollback",
               "New-CFNChangeSet",
               "New-CFNGeneratedTemplate",
               "New-CFNStack",
               "New-CFNStackInstance",
               "New-CFNCFNStackRefactor",
               "New-CFNStackSet",
               "Disable-CFNOrganizationsAccess",
               "Disable-CFNType",
               "Remove-CFNChangeSet",
               "Remove-CFNGeneratedTemplate",
               "Remove-CFNStack",
               "Remove-CFNStackInstance",
               "Remove-CFNStackSet",
               "Unregister-CFNType",
               "Get-CFNAccountLimit",
               "Get-CFNChangeSet",
               "Get-CFNChangeSetHook",
               "Get-CFNGeneratedTemplateInformation",
               "Get-CFNOrganizationsAccess",
               "Get-CFNPublisher",
               "Get-CFNResourceScan",
               "Get-CFNStackDriftDetectionStatus",
               "Get-CFNStackEvent",
               "Get-CFNStackInstance",
               "Get-CFNCFNStackRefactor",
               "Get-CFNStackResource",
               "Get-CFNDetectedStackResourceDrift",
               "Get-CFNStackResourceList",
               "Get-CFNStack",
               "Get-CFNStackSet",
               "Get-CFNStackSetOperation",
               "Get-CFNType",
               "Get-CFNTypeRegistration",
               "Start-CFNStackDriftDetection",
               "Get-CFNStackResourceDrift",
               "Start-CFNStackSetDriftDetection",
               "Measure-CFNTemplateCost",
               "Start-CFNChangeSet",
               "Start-CFNCFNStackRefactor",
               "Get-CFNGeneratedTemplate",
               "Get-CFNStackPolicy",
               "Get-CFNTemplate",
               "Get-CFNTemplateSummary",
               "Import-CFNStacksToStackSet",
               "Get-CFNChangeSetList",
               "Get-CFNExport",
               "Get-CFNGeneratedTemplateList",
               "Get-CFNHookResult",
               "Get-CFNImportList",
               "Get-CFNResourceScanRelatedResource",
               "Get-CFNResourceScanResource",
               "Get-CFNResourceScanList",
               "Get-CFNStackInstanceResourceDrift",
               "Get-CFNStackInstanceList",
               "Get-CFNCFNStackRefactorActionList",
               "Get-CFNCFNStackRefactorList",
               "Get-CFNStackResourceSummary",
               "Get-CFNStackSummary",
               "Get-CFNStackSetAutoDeploymentTarget",
               "Get-CFNStackSetOperationResultList",
               "Get-CFNStackSetOperationList",
               "Get-CFNStackSetList",
               "Get-CFNTypeRegistrationList",
               "Get-CFNTypeList",
               "Get-CFNTypeVersion",
               "Publish-CFNType",
               "Write-CFNHandlerProgress",
               "Register-CFNPublisher",
               "Register-CFNType",
               "Undo-CFNStack",
               "Set-CFNStackPolicy",
               "Set-CFNTypeConfiguration",
               "Set-CFNTypeDefaultVersion",
               "Send-CFNResourceSignal",
               "Start-CFNResourceScan",
               "Stop-CFNStackSetOperation",
               "Test-CFNType",
               "Update-CFNGeneratedTemplate",
               "Update-CFNStack",
               "Update-CFNStackInstance",
               "Update-CFNStackSet",
               "Update-CFNTerminationProtection",
               "Test-CFNTemplate",
               "Test-CFNStack",
               "Wait-CFNStack")
}

_awsArgumentCompleterRegistration $CFN_SelectCompleters $CFN_SelectMap
# Argument completions for service Amazon CloudFront KeyValueStore


$CFKV_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CFKV.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CFKV_SelectMap = @{
    "Select"=@("Remove-CFKVKey",
               "Get-CFKVKeyValueStore",
               "Get-CFKVKey",
               "Get-CFKVKeyList",
               "Write-CFKVKey",
               "Update-CFKVKey")
}

_awsArgumentCompleterRegistration $CFKV_SelectCompleters $CFKV_SelectMap
# Argument completions for service Amazon CloudFront


$CF_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CloudFront.CachePolicyCookieBehavior
        {
            ($_ -eq "New-CFCachePolicy/CookiesConfig_CookieBehavior") -Or
            ($_ -eq "Update-CFCachePolicy/CookiesConfig_CookieBehavior")
        }
        {
            $v = "all","allExcept","none","whitelist"
            break
        }

        # Amazon.CloudFront.CachePolicyHeaderBehavior
        {
            ($_ -eq "New-CFCachePolicy/HeadersConfig_HeaderBehavior") -Or
            ($_ -eq "Update-CFCachePolicy/HeadersConfig_HeaderBehavior")
        }
        {
            $v = "none","whitelist"
            break
        }

        # Amazon.CloudFront.CachePolicyQueryStringBehavior
        {
            ($_ -eq "New-CFCachePolicy/QueryStringsConfig_QueryStringBehavior") -Or
            ($_ -eq "Update-CFCachePolicy/QueryStringsConfig_QueryStringBehavior")
        }
        {
            $v = "all","allExcept","none","whitelist"
            break
        }

        # Amazon.CloudFront.CachePolicyType
        "Get-CFCachePolicyList/Type"
        {
            $v = "custom","managed"
            break
        }

        # Amazon.CloudFront.CertificateSource
        {
            ($_ -eq "New-CFDistribution/ViewerCertificate_CertificateSource") -Or
            ($_ -eq "New-CFDistributionWithTag/ViewerCertificate_CertificateSource") -Or
            ($_ -eq "Update-CFDistribution/ViewerCertificate_CertificateSource")
        }
        {
            $v = "acm","cloudfront","iam"
            break
        }

        # Amazon.CloudFront.CertificateTransparencyLoggingPreference
        {
            ($_ -eq "New-CFDistributionTenant/ManagedCertificateRequest_CertificateTransparencyLoggingPreference") -Or
            ($_ -eq "Update-CFDistributionTenant/ManagedCertificateRequest_CertificateTransparencyLoggingPreference")
        }
        {
            $v = "disabled","enabled"
            break
        }

        # Amazon.CloudFront.ConnectionMode
        {
            ($_ -eq "Get-CFDistributionsByConnectionMode/ConnectionMode") -Or
            ($_ -eq "New-CFDistribution/DistributionConfig_ConnectionMode") -Or
            ($_ -eq "New-CFDistributionWithTag/DistributionConfig_ConnectionMode") -Or
            ($_ -eq "Update-CFDistribution/DistributionConfig_ConnectionMode")
        }
        {
            $v = "direct","tenant-only"
            break
        }

        # Amazon.CloudFront.ContinuousDeploymentPolicyType
        {
            ($_ -eq "New-CFContinuousDeploymentPolicy/TrafficConfig_Type") -Or
            ($_ -eq "Update-CFContinuousDeploymentPolicy/TrafficConfig_Type")
        }
        {
            $v = "SingleHeader","SingleWeight"
            break
        }

        # Amazon.CloudFront.CustomizationActionType
        {
            ($_ -eq "New-CFDistributionTenant/WebAcl_Action") -Or
            ($_ -eq "Update-CFDistributionTenant/WebAcl_Action")
        }
        {
            $v = "disable","override"
            break
        }

        # Amazon.CloudFront.FrameOptionsList
        {
            ($_ -eq "New-CFResponseHeadersPolicy/FrameOptions_FrameOption") -Or
            ($_ -eq "Update-CFResponseHeadersPolicy/FrameOptions_FrameOption")
        }
        {
            $v = "DENY","SAMEORIGIN"
            break
        }

        # Amazon.CloudFront.FunctionRuntime
        {
            ($_ -eq "New-CFFunction/FunctionConfig_Runtime") -Or
            ($_ -eq "Update-CFFunction/FunctionConfig_Runtime")
        }
        {
            $v = "cloudfront-js-1.0","cloudfront-js-2.0"
            break
        }

        # Amazon.CloudFront.FunctionStage
        {
            ($_ -eq "Get-CFFunction/Stage") -Or
            ($_ -eq "Get-CFFunctionList/Stage") -Or
            ($_ -eq "Get-CFFunctionSummary/Stage") -Or
            ($_ -eq "Test-CFFunction/Stage")
        }
        {
            $v = "DEVELOPMENT","LIVE"
            break
        }

        # Amazon.CloudFront.GeoRestrictionType
        {
            ($_ -eq "New-CFDistribution/GeoRestriction_RestrictionType") -Or
            ($_ -eq "New-CFDistributionWithTag/GeoRestriction_RestrictionType") -Or
            ($_ -eq "Update-CFDistribution/GeoRestriction_RestrictionType") -Or
            ($_ -eq "New-CFDistributionTenant/GeoRestrictions_RestrictionType") -Or
            ($_ -eq "Update-CFDistributionTenant/GeoRestrictions_RestrictionType")
        }
        {
            $v = "blacklist","none","whitelist"
            break
        }

        # Amazon.CloudFront.HttpVersion
        {
            ($_ -eq "New-CFDistribution/DistributionConfig_HttpVersion") -Or
            ($_ -eq "New-CFDistributionWithTag/DistributionConfig_HttpVersion") -Or
            ($_ -eq "Update-CFDistribution/DistributionConfig_HttpVersion")
        }
        {
            $v = "http1.1","http2","http2and3","http3"
            break
        }

        # Amazon.CloudFront.ImportSourceType
        "New-CFKeyValueStore/ImportSource_SourceType"
        {
            $v = "S3"
            break
        }

        # Amazon.CloudFront.ItemSelection
        {
            ($_ -eq "New-CFDistribution/Cookies_Forward") -Or
            ($_ -eq "New-CFDistributionWithTag/Cookies_Forward") -Or
            ($_ -eq "Update-CFDistribution/Cookies_Forward")
        }
        {
            $v = "all","none","whitelist"
            break
        }

        # Amazon.CloudFront.MinimumProtocolVersion
        {
            ($_ -eq "New-CFDistribution/ViewerCertificate_MinimumProtocolVersion") -Or
            ($_ -eq "New-CFDistributionWithTag/ViewerCertificate_MinimumProtocolVersion") -Or
            ($_ -eq "Update-CFDistribution/ViewerCertificate_MinimumProtocolVersion")
        }
        {
            $v = "SSLv3","TLSv1","TLSv1.1_2016","TLSv1.2_2018","TLSv1.2_2019","TLSv1.2_2021","TLSv1.2_2025","TLSv1.3_2025","TLSv1_2016"
            break
        }

        # Amazon.CloudFront.OriginAccessControlOriginTypes
        {
            ($_ -eq "New-CFOriginAccessControl/OriginAccessControlConfig_OriginAccessControlOriginType") -Or
            ($_ -eq "Update-CFOriginAccessControl/OriginAccessControlConfig_OriginAccessControlOriginType")
        }
        {
            $v = "lambda","mediapackagev2","mediastore","s3"
            break
        }

        # Amazon.CloudFront.OriginAccessControlSigningBehaviors
        {
            ($_ -eq "New-CFOriginAccessControl/OriginAccessControlConfig_SigningBehavior") -Or
            ($_ -eq "Update-CFOriginAccessControl/OriginAccessControlConfig_SigningBehavior")
        }
        {
            $v = "always","never","no-override"
            break
        }

        # Amazon.CloudFront.OriginAccessControlSigningProtocols
        {
            ($_ -eq "New-CFOriginAccessControl/OriginAccessControlConfig_SigningProtocol") -Or
            ($_ -eq "Update-CFOriginAccessControl/OriginAccessControlConfig_SigningProtocol")
        }
        {
            $v = "sigv4"
            break
        }

        # Amazon.CloudFront.OriginProtocolPolicy
        {
            ($_ -eq "New-CFVpcOrigin/VpcOriginEndpointConfig_OriginProtocolPolicy") -Or
            ($_ -eq "Update-CFVpcOrigin/VpcOriginEndpointConfig_OriginProtocolPolicy")
        }
        {
            $v = "http-only","https-only","match-viewer"
            break
        }

        # Amazon.CloudFront.OriginRequestPolicyCookieBehavior
        {
            ($_ -eq "New-CFOriginRequestPolicy/CookiesConfig_CookieBehavior") -Or
            ($_ -eq "Update-CFOriginRequestPolicy/CookiesConfig_CookieBehavior")
        }
        {
            $v = "all","allExcept","none","whitelist"
            break
        }

        # Amazon.CloudFront.OriginRequestPolicyHeaderBehavior
        {
            ($_ -eq "New-CFOriginRequestPolicy/HeadersConfig_HeaderBehavior") -Or
            ($_ -eq "Update-CFOriginRequestPolicy/HeadersConfig_HeaderBehavior")
        }
        {
            $v = "allExcept","allViewer","allViewerAndWhitelistCloudFront","none","whitelist"
            break
        }

        # Amazon.CloudFront.OriginRequestPolicyQueryStringBehavior
        {
            ($_ -eq "New-CFOriginRequestPolicy/QueryStringsConfig_QueryStringBehavior") -Or
            ($_ -eq "Update-CFOriginRequestPolicy/QueryStringsConfig_QueryStringBehavior")
        }
        {
            $v = "all","allExcept","none","whitelist"
            break
        }

        # Amazon.CloudFront.OriginRequestPolicyType
        "Get-CFOriginRequestPolicyList/Type"
        {
            $v = "custom","managed"
            break
        }

        # Amazon.CloudFront.PriceClass
        {
            ($_ -eq "New-CFDistribution/DistributionConfig_PriceClass") -Or
            ($_ -eq "New-CFDistributionWithTag/DistributionConfig_PriceClass") -Or
            ($_ -eq "Update-CFDistribution/DistributionConfig_PriceClass") -Or
            ($_ -eq "New-CFStreamingDistribution/StreamingDistributionConfig_PriceClass") -Or
            ($_ -eq "New-CFStreamingDistributionWithTag/StreamingDistributionConfig_PriceClass") -Or
            ($_ -eq "Update-CFStreamingDistribution/StreamingDistributionConfig_PriceClass")
        }
        {
            $v = "None","PriceClass_100","PriceClass_200","PriceClass_All"
            break
        }

        # Amazon.CloudFront.RealtimeMetricsSubscriptionStatus
        "New-CFMonitoringSubscription/RealtimeMetricsSubscriptionConfig_RealtimeMetricsSubscriptionStatus"
        {
            $v = "Disabled","Enabled"
            break
        }

        # Amazon.CloudFront.ReferrerPolicyList
        {
            ($_ -eq "New-CFResponseHeadersPolicy/ReferrerPolicy_ReferrerPolicy") -Or
            ($_ -eq "Update-CFResponseHeadersPolicy/ReferrerPolicy_ReferrerPolicy")
        }
        {
            $v = "no-referrer","no-referrer-when-downgrade","origin","origin-when-cross-origin","same-origin","strict-origin","strict-origin-when-cross-origin","unsafe-url"
            break
        }

        # Amazon.CloudFront.ResponseHeadersPolicyType
        "Get-CFResponseHeadersPolicyList/Type"
        {
            $v = "custom","managed"
            break
        }

        # Amazon.CloudFront.SSLSupportMethod
        {
            ($_ -eq "New-CFDistribution/ViewerCertificate_SSLSupportMethod") -Or
            ($_ -eq "New-CFDistributionWithTag/ViewerCertificate_SSLSupportMethod") -Or
            ($_ -eq "Update-CFDistribution/ViewerCertificate_SSLSupportMethod")
        }
        {
            $v = "sni-only","static-ip","vip"
            break
        }

        # Amazon.CloudFront.ValidationTokenHost
        {
            ($_ -eq "New-CFDistributionTenant/ManagedCertificateRequest_ValidationTokenHost") -Or
            ($_ -eq "Update-CFDistributionTenant/ManagedCertificateRequest_ValidationTokenHost")
        }
        {
            $v = "cloudfront","self-hosted"
            break
        }

        # Amazon.CloudFront.ViewerProtocolPolicy
        {
            ($_ -eq "New-CFDistribution/DefaultCacheBehavior_ViewerProtocolPolicy") -Or
            ($_ -eq "New-CFDistributionWithTag/DefaultCacheBehavior_ViewerProtocolPolicy") -Or
            ($_ -eq "Update-CFDistribution/DefaultCacheBehavior_ViewerProtocolPolicy")
        }
        {
            $v = "allow-all","https-only","redirect-to-https"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CF_map = @{
    "ConnectionMode"=@("Get-CFDistributionsByConnectionMode")
    "Cookies_Forward"=@("New-CFDistribution","New-CFDistributionWithTag","Update-CFDistribution")
    "CookiesConfig_CookieBehavior"=@("New-CFCachePolicy","New-CFOriginRequestPolicy","Update-CFCachePolicy","Update-CFOriginRequestPolicy")
    "DefaultCacheBehavior_ViewerProtocolPolicy"=@("New-CFDistribution","New-CFDistributionWithTag","Update-CFDistribution")
    "DistributionConfig_ConnectionMode"=@("New-CFDistribution","New-CFDistributionWithTag","Update-CFDistribution")
    "DistributionConfig_HttpVersion"=@("New-CFDistribution","New-CFDistributionWithTag","Update-CFDistribution")
    "DistributionConfig_PriceClass"=@("New-CFDistribution","New-CFDistributionWithTag","Update-CFDistribution")
    "FrameOptions_FrameOption"=@("New-CFResponseHeadersPolicy","Update-CFResponseHeadersPolicy")
    "FunctionConfig_Runtime"=@("New-CFFunction","Update-CFFunction")
    "GeoRestriction_RestrictionType"=@("New-CFDistribution","New-CFDistributionWithTag","Update-CFDistribution")
    "GeoRestrictions_RestrictionType"=@("New-CFDistributionTenant","Update-CFDistributionTenant")
    "HeadersConfig_HeaderBehavior"=@("New-CFCachePolicy","New-CFOriginRequestPolicy","Update-CFCachePolicy","Update-CFOriginRequestPolicy")
    "ImportSource_SourceType"=@("New-CFKeyValueStore")
    "ManagedCertificateRequest_CertificateTransparencyLoggingPreference"=@("New-CFDistributionTenant","Update-CFDistributionTenant")
    "ManagedCertificateRequest_ValidationTokenHost"=@("New-CFDistributionTenant","Update-CFDistributionTenant")
    "OriginAccessControlConfig_OriginAccessControlOriginType"=@("New-CFOriginAccessControl","Update-CFOriginAccessControl")
    "OriginAccessControlConfig_SigningBehavior"=@("New-CFOriginAccessControl","Update-CFOriginAccessControl")
    "OriginAccessControlConfig_SigningProtocol"=@("New-CFOriginAccessControl","Update-CFOriginAccessControl")
    "QueryStringsConfig_QueryStringBehavior"=@("New-CFCachePolicy","New-CFOriginRequestPolicy","Update-CFCachePolicy","Update-CFOriginRequestPolicy")
    "RealtimeMetricsSubscriptionConfig_RealtimeMetricsSubscriptionStatus"=@("New-CFMonitoringSubscription")
    "ReferrerPolicy_ReferrerPolicy"=@("New-CFResponseHeadersPolicy","Update-CFResponseHeadersPolicy")
    "Stage"=@("Get-CFFunction","Get-CFFunctionList","Get-CFFunctionSummary","Test-CFFunction")
    "StreamingDistributionConfig_PriceClass"=@("New-CFStreamingDistribution","New-CFStreamingDistributionWithTag","Update-CFStreamingDistribution")
    "TrafficConfig_Type"=@("New-CFContinuousDeploymentPolicy","Update-CFContinuousDeploymentPolicy")
    "Type"=@("Get-CFCachePolicyList","Get-CFOriginRequestPolicyList","Get-CFResponseHeadersPolicyList")
    "ViewerCertificate_CertificateSource"=@("New-CFDistribution","New-CFDistributionWithTag","Update-CFDistribution")
    "ViewerCertificate_MinimumProtocolVersion"=@("New-CFDistribution","New-CFDistributionWithTag","Update-CFDistribution")
    "ViewerCertificate_SSLSupportMethod"=@("New-CFDistribution","New-CFDistributionWithTag","Update-CFDistribution")
    "VpcOriginEndpointConfig_OriginProtocolPolicy"=@("New-CFVpcOrigin","Update-CFVpcOrigin")
    "WebAcl_Action"=@("New-CFDistributionTenant","Update-CFDistributionTenant")
}

_awsArgumentCompleterRegistration $CF_Completers $CF_map

$CF_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CF.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CF_SelectMap = @{
    "Select"=@("Move-CFAlias",
               "Add-CFDistributionTenantWebACL",
               "Add-CFDistributionWebACL",
               "Copy-CFDistribution",
               "New-CFAnycastIpList",
               "New-CFCachePolicy",
               "New-CFCloudFrontOriginAccessIdentity",
               "New-CFConnectionGroup",
               "New-CFContinuousDeploymentPolicy",
               "New-CFDistribution",
               "New-CFDistributionTenant",
               "New-CFDistributionWithTag",
               "New-CFFieldLevelEncryptionConfig",
               "New-CFFieldLevelEncryptionProfile",
               "New-CFFunction",
               "New-CFInvalidation",
               "New-CFInvalidationForDistributionTenant",
               "New-CFKeyGroup",
               "New-CFKeyValueStore",
               "New-CFMonitoringSubscription",
               "New-CFOriginAccessControl",
               "New-CFOriginRequestPolicy",
               "New-CFPublicKey",
               "New-CFRealtimeLogConfig",
               "New-CFResponseHeadersPolicy",
               "New-CFStreamingDistribution",
               "New-CFStreamingDistributionWithTag",
               "New-CFVpcOrigin",
               "Remove-CFAnycastIpList",
               "Remove-CFCachePolicy",
               "Remove-CFCloudFrontOriginAccessIdentity",
               "Remove-CFConnectionGroup",
               "Remove-CFContinuousDeploymentPolicy",
               "Remove-CFDistribution",
               "Remove-CFDistributionTenant",
               "Remove-CFFieldLevelEncryptionConfig",
               "Remove-CFFieldLevelEncryptionProfile",
               "Remove-CFFunction",
               "Remove-CFKeyGroup",
               "Remove-CFKeyValueStore",
               "Remove-CFMonitoringSubscription",
               "Remove-CFOriginAccessControl",
               "Remove-CFOriginRequestPolicy",
               "Remove-CFPublicKey",
               "Remove-CFRealtimeLogConfig",
               "Remove-CFResponseHeadersPolicy",
               "Remove-CFStreamingDistribution",
               "Remove-CFVpcOrigin",
               "Get-CFFunctionSummary",
               "Get-CFKeyValueStore",
               "Remove-CFDistributionTenantWebACL",
               "Remove-CFDistributionWebACL",
               "Get-CFAnycastIpList",
               "Get-CFCachePolicy",
               "Get-CFCachePolicyConfig",
               "Get-CFCloudFrontOriginAccessIdentity",
               "Get-CFCloudFrontOriginAccessIdentityConfig",
               "Get-CFConnectionGroup",
               "Get-CFConnectionGroupByRoutingEndpoint",
               "Get-CFContinuousDeploymentPolicy",
               "Get-CFContinuousDeploymentPolicyConfig",
               "Get-CFDistribution",
               "Get-CFDistributionConfig",
               "Get-CFDistributionTenant",
               "Get-CFDistributionTenantByDomain",
               "Get-CFFieldLevelEncryption",
               "Get-CFFieldLevelEncryptionConfig",
               "Get-CFFieldLevelEncryptionProfile",
               "Get-CFFieldLevelEncryptionProfileConfig",
               "Get-CFFunction",
               "Get-CFInvalidation",
               "Get-CFInvalidationForDistributionTenant",
               "Get-CFKeyGroup",
               "Get-CFKeyGroupConfig",
               "Get-CFManagedCertificateDetail",
               "Get-CFMonitoringSubscription",
               "Get-CFOriginAccessControl",
               "Get-CFOriginAccessControlConfig",
               "Get-CFOriginRequestPolicy",
               "Get-CFOriginRequestPolicyConfig",
               "Get-CFPublicKey",
               "Get-CFPublicKeyConfig",
               "Get-CFRealtimeLogConfig",
               "Get-CFResponseHeadersPolicy",
               "Get-CFResponseHeadersPolicyConfig",
               "Get-CFStreamingDistribution",
               "Get-CFStreamingDistributionConfig",
               "Get-CFVpcOrigin",
               "Get-CFAnycastIpListList",
               "Get-CFCachePolicyList",
               "Get-CFCloudFrontOriginAccessIdentityList",
               "Get-CFConflictingAlias",
               "Get-CFConnectionGroupList",
               "Get-CFContinuousDeploymentPolicyList",
               "Get-CFDistributionList",
               "Get-CFDistributionsByAnycastIpListId",
               "Get-CFDistributionsByCachePolicyId",
               "Get-CFDistributionsByConnectionMode",
               "Get-CFDistributionsByKeyGroup",
               "Get-CFDistributionsByOriginRequestPolicyId",
               "Get-CFDistributionsByRealtimeLogConfig",
               "Get-CFDistributionsByResponseHeadersPolicyId",
               "Get-CFDistributionsByVpcOriginId",
               "Get-CFDistributionListByWebACLId",
               "Get-CFDistributionTenantList",
               "Get-CFDistributionTenantsByCustomization",
               "Get-CFDomainConflict",
               "Get-CFFieldLevelEncryptionConfigList",
               "Get-CFFieldLevelEncryptionProfileList",
               "Get-CFFunctionList",
               "Get-CFInvalidationList",
               "Get-CFInvalidationsForDistributionTenant",
               "Get-CFKeyGroupList",
               "Get-CFKeyValueStoreListItem",
               "Get-CFOriginAccessControlList",
               "Get-CFOriginRequestPolicyList",
               "Get-CFPublicKeyList",
               "Get-CFRealtimeLogConfigList",
               "Get-CFResponseHeadersPolicyList",
               "Get-CFStreamingDistributionList",
               "Get-CFResourceTag",
               "Get-CFVpcOriginList",
               "Publish-CFFunction",
               "Add-CFResourceTag",
               "Test-CFFunction",
               "Remove-CFResourceTag",
               "Update-CFCachePolicy",
               "Update-CFCloudFrontOriginAccessIdentity",
               "Update-CFConnectionGroup",
               "Update-CFContinuousDeploymentPolicy",
               "Update-CFDistribution",
               "Update-CFDistributionTenant",
               "Update-CFDistributionWithStagingConfig",
               "Update-CFDomainAssociation",
               "Update-CFFieldLevelEncryptionConfig",
               "Update-CFFieldLevelEncryptionProfile",
               "Update-CFFunction",
               "Update-CFKeyGroup",
               "Update-CFKeyValueStore",
               "Update-CFOriginAccessControl",
               "Update-CFOriginRequestPolicy",
               "Update-CFPublicKey",
               "Update-CFRealtimeLogConfig",
               "Update-CFResponseHeadersPolicy",
               "Update-CFStreamingDistribution",
               "Update-CFVpcOrigin",
               "Test-CFDnsConfiguration",
               "New-CFSignedCookie",
               "New-CFSignedUrl")
}

_awsArgumentCompleterRegistration $CF_SelectCompleters $CF_SelectMap
# Argument completions for service AWS CloudHSM


$HSM_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CloudHSM.ClientVersion
        "Get-HSMConfig/ClientVersion"
        {
            $v = "5.1","5.3"
            break
        }

        # Amazon.CloudHSM.SubscriptionType
        "New-HSMItem/SubscriptionType"
        {
            $v = "PRODUCTION"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$HSM_map = @{
    "ClientVersion"=@("Get-HSMConfig")
    "SubscriptionType"=@("New-HSMItem")
}

_awsArgumentCompleterRegistration $HSM_Completers $HSM_map

$HSM_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.HSM.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$HSM_SelectMap = @{
    "Select"=@("Set-HSMResourceTag",
               "New-HSMPartitionGroup",
               "New-HSMItem",
               "New-HSMLunaClient",
               "Remove-HSMPartitionGroup",
               "Remove-HSMItem",
               "Remove-HSMLunaClient",
               "Get-HSMPartitionGroup",
               "Get-HSMItem",
               "Get-HSMLunaClient",
               "Get-HSMConfig",
               "Get-HSMAvailableZone",
               "Get-HSMPartitionGroupList",
               "Get-HSMItemList",
               "Get-HSMLunaClientList",
               "Get-HSMResourceTag",
               "Edit-HSMPartitionGroup",
               "Edit-HSMItem",
               "Edit-HSMLunaClient",
               "Remove-HSMResourceTag")
}

_awsArgumentCompleterRegistration $HSM_SelectCompleters $HSM_SelectMap
# Argument completions for service AWS CloudHSM V2


$HSM2_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CloudHSMV2.BackupRetentionType
        {
            ($_ -eq "Edit-HSM2Cluster/BackupRetentionPolicy_Type") -Or
            ($_ -eq "New-HSM2Cluster/BackupRetentionPolicy_Type")
        }
        {
            $v = "DAYS"
            break
        }

        # Amazon.CloudHSMV2.ClusterMode
        "New-HSM2Cluster/Mode"
        {
            $v = "FIPS","NON_FIPS"
            break
        }

        # Amazon.CloudHSMV2.NetworkType
        "New-HSM2Cluster/NetworkType"
        {
            $v = "DUALSTACK","IPV4"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$HSM2_map = @{
    "BackupRetentionPolicy_Type"=@("Edit-HSM2Cluster","New-HSM2Cluster")
    "Mode"=@("New-HSM2Cluster")
    "NetworkType"=@("New-HSM2Cluster")
}

_awsArgumentCompleterRegistration $HSM2_Completers $HSM2_map

$HSM2_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.HSM2.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$HSM2_SelectMap = @{
    "Select"=@("Copy-HSM2BackupToRegion",
               "New-HSM2Cluster",
               "New-HSM2Hsm",
               "Remove-HSM2Backup",
               "Remove-HSM2Cluster",
               "Remove-HSM2Hsm",
               "Remove-HSM2ResourcePolicy",
               "Get-HSM2Backup",
               "Get-HSM2Cluster",
               "Get-HSM2ResourcePolicy",
               "Initialize-HSM2Cluster",
               "Get-HSM2ResourceTag",
               "Edit-HSM2BackupAttribute",
               "Edit-HSM2Cluster",
               "Write-HSM2ResourcePolicy",
               "Restore-HSM2Backup",
               "Add-HSM2ResourceTag",
               "Remove-HSM2ResourceTag")
}

_awsArgumentCompleterRegistration $HSM2_SelectCompleters $HSM2_SelectMap
# Argument completions for service Amazon CloudSearch


$CS_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CloudSearch.AlgorithmicStemming
        "Set-CSAnalysisScheme/AnalysisOptions_AlgorithmicStemming"
        {
            $v = "full","light","minimal","none"
            break
        }

        # Amazon.CloudSearch.AnalysisSchemeLanguage
        "Set-CSAnalysisScheme/AnalysisScheme_AnalysisSchemeLanguage"
        {
            $v = "ar","bg","ca","cs","da","de","el","en","es","eu","fa","fi","fr","ga","gl","he","hi","hu","hy","id","it","ja","ko","lv","mul","nl","no","pt","ro","ru","sv","th","tr","zh-Hans","zh-Hant"
            break
        }

        # Amazon.CloudSearch.IndexFieldType
        "Set-CSIndexField/IndexField_IndexFieldType"
        {
            $v = "date","date-array","double","double-array","int","int-array","latlon","literal","literal-array","text","text-array"
            break
        }

        # Amazon.CloudSearch.PartitionInstanceType
        "Update-CSScalingParameter/ScalingParameters_DesiredInstanceType"
        {
            $v = "search.2xlarge","search.large","search.m1.large","search.m1.small","search.m2.2xlarge","search.m2.xlarge","search.m3.2xlarge","search.m3.large","search.m3.medium","search.m3.xlarge","search.medium","search.previousgeneration.2xlarge","search.previousgeneration.large","search.previousgeneration.small","search.previousgeneration.xlarge","search.small","search.xlarge"
            break
        }

        # Amazon.CloudSearch.SuggesterFuzzyMatching
        "Set-CSSuggester/DocumentSuggesterOptions_FuzzyMatching"
        {
            $v = "high","low","none"
            break
        }

        # Amazon.CloudSearch.TLSSecurityPolicy
        "Update-CSDomainEndpointOption/DomainEndpointOptions_TLSSecurityPolicy"
        {
            $v = "Policy-Min-TLS-1-0-2019-07","Policy-Min-TLS-1-2-2019-07"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CS_map = @{
    "AnalysisOptions_AlgorithmicStemming"=@("Set-CSAnalysisScheme")
    "AnalysisScheme_AnalysisSchemeLanguage"=@("Set-CSAnalysisScheme")
    "DocumentSuggesterOptions_FuzzyMatching"=@("Set-CSSuggester")
    "DomainEndpointOptions_TLSSecurityPolicy"=@("Update-CSDomainEndpointOption")
    "IndexField_IndexFieldType"=@("Set-CSIndexField")
    "ScalingParameters_DesiredInstanceType"=@("Update-CSScalingParameter")
}

_awsArgumentCompleterRegistration $CS_Completers $CS_map

$CS_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CS.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CS_SelectMap = @{
    "Select"=@("Start-CSSuggestersBuild",
               "New-CSDomain",
               "Set-CSAnalysisScheme",
               "Set-CSExpression",
               "Set-CSIndexField",
               "Set-CSSuggester",
               "Remove-CSAnalysisScheme",
               "Remove-CSDomain",
               "Remove-CSExpression",
               "Remove-CSIndexField",
               "Remove-CSSuggester",
               "Get-CSAnalysisScheme",
               "Get-CSAvailabilityOption",
               "Get-CSDomainEndpointOption",
               "Get-CSDomain",
               "Get-CSExpression",
               "Get-CSIndexField",
               "Get-CSScalingParameter",
               "Get-CSServiceAccessPolicy",
               "Get-CSSuggester",
               "Start-CSIndex",
               "Get-CSDomainNameList",
               "Update-CSAvailabilityOption",
               "Update-CSDomainEndpointOption",
               "Update-CSScalingParameter",
               "Update-CSServiceAccessPolicy")
}

_awsArgumentCompleterRegistration $CS_SelectCompleters $CS_SelectMap
# Argument completions for service Amazon CloudSearch Domain


$CSD_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CloudSearchDomain.ContentType
        "Write-CSDDocument/ContentType"
        {
            $v = "application/json","application/xml"
            break
        }

        # Amazon.CloudSearchDomain.QueryParser
        "Search-CSDDocument/QueryParser"
        {
            $v = "dismax","lucene","simple","structured"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CSD_map = @{
    "ContentType"=@("Write-CSDDocument")
    "QueryParser"=@("Search-CSDDocument")
}

_awsArgumentCompleterRegistration $CSD_Completers $CSD_map

$CSD_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CSD.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CSD_SelectMap = @{
    "Select"=@("Get-CSDSuggestion",
               "Search-CSDDocument",
               "Write-CSDDocument")
}

_awsArgumentCompleterRegistration $CSD_SelectCompleters $CSD_SelectMap
# Argument completions for service AWS CloudTrail


$CT_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CloudTrail.BillingMode
        {
            ($_ -eq "New-CTEventDataStore/BillingMode") -Or
            ($_ -eq "Update-CTEventDataStore/BillingMode")
        }
        {
            $v = "EXTENDABLE_RETENTION_PRICING","FIXED_RETENTION_PRICING"
            break
        }

        # Amazon.CloudTrail.DashboardType
        "Get-CTDashboardSummary/Type"
        {
            $v = "CUSTOM","MANAGED"
            break
        }

        # Amazon.CloudTrail.EventCategory
        "Find-CTEvent/EventCategory"
        {
            $v = "insight"
            break
        }

        # Amazon.CloudTrail.ImportStatus
        "Get-CTImportList/ImportStatus"
        {
            $v = "COMPLETED","FAILED","INITIALIZING","IN_PROGRESS","STOPPED"
            break
        }

        # Amazon.CloudTrail.InsightsMetricDataType
        "Get-CTInsightsMetricData/DataType"
        {
            $v = "FillWithZeros","NonZeroData"
            break
        }

        # Amazon.CloudTrail.InsightType
        "Get-CTInsightsMetricData/InsightType"
        {
            $v = "ApiCallRateInsight","ApiErrorRateInsight"
            break
        }

        # Amazon.CloudTrail.MaxEventSize
        "Write-CTEventConfiguration/MaxEventSize"
        {
            $v = "Large","Standard"
            break
        }

        # Amazon.CloudTrail.QueryStatus
        "Get-CTQuerySummary/QueryStatus"
        {
            $v = "CANCELLED","FAILED","FINISHED","QUEUED","RUNNING","TIMED_OUT"
            break
        }

        # Amazon.CloudTrail.RefreshScheduleFrequencyUnit
        {
            ($_ -eq "New-CTDashboard/Frequency_Unit") -Or
            ($_ -eq "Update-CTDashboard/Frequency_Unit")
        }
        {
            $v = "DAYS","HOURS"
            break
        }

        # Amazon.CloudTrail.RefreshScheduleStatus
        {
            ($_ -eq "New-CTDashboard/RefreshSchedule_Status") -Or
            ($_ -eq "Update-CTDashboard/RefreshSchedule_Status")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CT_map = @{
    "BillingMode"=@("New-CTEventDataStore","Update-CTEventDataStore")
    "DataType"=@("Get-CTInsightsMetricData")
    "EventCategory"=@("Find-CTEvent")
    "Frequency_Unit"=@("New-CTDashboard","Update-CTDashboard")
    "ImportStatus"=@("Get-CTImportList")
    "InsightType"=@("Get-CTInsightsMetricData")
    "MaxEventSize"=@("Write-CTEventConfiguration")
    "QueryStatus"=@("Get-CTQuerySummary")
    "RefreshSchedule_Status"=@("New-CTDashboard","Update-CTDashboard")
    "Type"=@("Get-CTDashboardSummary")
}

_awsArgumentCompleterRegistration $CT_Completers $CT_map

$CT_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CT.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CT_SelectMap = @{
    "Select"=@("Add-CTResourceTag",
               "Stop-CTQuery",
               "New-CTChannel",
               "New-CTDashboard",
               "New-CTEventDataStore",
               "New-CTTrail",
               "Remove-CTChannel",
               "Remove-CTDashboard",
               "Remove-CTEventDataStore",
               "Remove-CTResourcePolicy",
               "Remove-CTTrail",
               "Unregister-CTOrganizationDelegatedAdmin",
               "Get-CTQuery",
               "Get-CTTrail",
               "Disable-CTFederation",
               "Enable-CTFederation",
               "Invoke-CTGenerateQuery",
               "Get-CTChannel",
               "Get-CTDashboard",
               "Get-CTEventConfiguration",
               "Get-CTEventDataStore",
               "Get-CTEventSelector",
               "Get-CTImport",
               "Get-CTInsightSelector",
               "Get-CTQueryResult",
               "Get-CTResourcePolicy",
               "Get-CTTrailByName",
               "Get-CTTrailStatus",
               "Get-CTChannelSummary",
               "Get-CTDashboardSummary",
               "Get-CTEventDataStoreSummary",
               "Get-CTImportFailure",
               "Get-CTImportList",
               "Get-CTInsightsMetricData",
               "Get-CTPublicKey",
               "Get-CTQuerySummary",
               "Get-CTResourceTag",
               "Get-CTTrailSummary",
               "Find-CTEvent",
               "Write-CTEventConfiguration",
               "Write-CTEventSelector",
               "Write-CTInsightSelector",
               "Write-CTResourcePolicy",
               "Register-CTOrganizationDelegatedAdmin",
               "Remove-CTResourceTag",
               "Restore-CTEventDataStore",
               "Search-CTSampleQuery",
               "Start-CTDashboardRefresh",
               "Start-CTEventDataStoreIngestion",
               "Start-CTImport",
               "Start-CTLogging",
               "Start-CTQuery",
               "Stop-CTEventDataStoreIngestion",
               "Stop-CTImport",
               "Stop-CTLogging",
               "Update-CTChannel",
               "Update-CTDashboard",
               "Update-CTEventDataStore",
               "Update-CTTrail")
}

_awsArgumentCompleterRegistration $CT_SelectCompleters $CT_SelectMap
# Argument completions for service AWS CloudTrail Data Service


$CTD_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CTD.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CTD_SelectMap = @{
    "Select"=@("Write-CTDAuditEvent")
}

_awsArgumentCompleterRegistration $CTD_SelectCompleters $CTD_SelectMap
# Argument completions for service AWS CodeArtifact


$CA_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CodeArtifact.AllowPublish
        {
            ($_ -eq "Get-CAPackageList/Publish") -Or
            ($_ -eq "Write-CAPackageOriginConfiguration/Restrictions_Publish")
        }
        {
            $v = "ALLOW","BLOCK"
            break
        }

        # Amazon.CodeArtifact.AllowUpstream
        {
            ($_ -eq "Write-CAPackageOriginConfiguration/Restrictions_Upstream") -Or
            ($_ -eq "Get-CAPackageList/Upstream")
        }
        {
            $v = "ALLOW","BLOCK"
            break
        }

        # Amazon.CodeArtifact.EndpointType
        "Get-CARepositoryEndpoint/EndpointType"
        {
            $v = "dualstack","ipv4"
            break
        }

        # Amazon.CodeArtifact.PackageFormat
        {
            ($_ -eq "Copy-CAPackageVersion/Format") -Or
            ($_ -eq "Get-CAAssociatedPackageGroup/Format") -Or
            ($_ -eq "Get-CAPackage/Format") -Or
            ($_ -eq "Get-CAPackageList/Format") -Or
            ($_ -eq "Get-CAPackageVersion/Format") -Or
            ($_ -eq "Get-CAPackageVersionAsset/Format") -Or
            ($_ -eq "Get-CAPackageVersionAssetList/Format") -Or
            ($_ -eq "Get-CAPackageVersionDependencyList/Format") -Or
            ($_ -eq "Get-CAPackageVersionList/Format") -Or
            ($_ -eq "Get-CAPackageVersionReadme/Format") -Or
            ($_ -eq "Get-CARepositoryEndpoint/Format") -Or
            ($_ -eq "Publish-CAPackageVersion/Format") -Or
            ($_ -eq "Remove-CAPackage/Format") -Or
            ($_ -eq "Remove-CAPackageVersion/Format") -Or
            ($_ -eq "Unpublish-CAPackageVersion/Format") -Or
            ($_ -eq "Update-CAPackageVersionsStatus/Format") -Or
            ($_ -eq "Write-CAPackageOriginConfiguration/Format")
        }
        {
            $v = "cargo","generic","maven","npm","nuget","pypi","ruby","swift"
            break
        }

        # Amazon.CodeArtifact.PackageGroupOriginRestrictionType
        "Get-CAAllowedRepositoriesForGroupList/OriginRestrictionType"
        {
            $v = "EXTERNAL_UPSTREAM","INTERNAL_UPSTREAM","PUBLISH"
            break
        }

        # Amazon.CodeArtifact.PackageVersionOriginType
        "Get-CAPackageVersionList/OriginType"
        {
            $v = "EXTERNAL","INTERNAL","UNKNOWN"
            break
        }

        # Amazon.CodeArtifact.PackageVersionSortType
        "Get-CAPackageVersionList/SortBy"
        {
            $v = "PUBLISHED_TIME"
            break
        }

        # Amazon.CodeArtifact.PackageVersionStatus
        {
            ($_ -eq "Remove-CAPackageVersion/ExpectedStatus") -Or
            ($_ -eq "Unpublish-CAPackageVersion/ExpectedStatus") -Or
            ($_ -eq "Update-CAPackageVersionsStatus/ExpectedStatus") -Or
            ($_ -eq "Get-CAPackageVersionList/Status") -Or
            ($_ -eq "Update-CAPackageVersionsStatus/TargetStatus")
        }
        {
            $v = "Archived","Deleted","Disposed","Published","Unfinished","Unlisted"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CA_map = @{
    "EndpointType"=@("Get-CARepositoryEndpoint")
    "ExpectedStatus"=@("Remove-CAPackageVersion","Unpublish-CAPackageVersion","Update-CAPackageVersionsStatus")
    "Format"=@("Copy-CAPackageVersion","Get-CAAssociatedPackageGroup","Get-CAPackage","Get-CAPackageList","Get-CAPackageVersion","Get-CAPackageVersionAsset","Get-CAPackageVersionAssetList","Get-CAPackageVersionDependencyList","Get-CAPackageVersionList","Get-CAPackageVersionReadme","Get-CARepositoryEndpoint","Publish-CAPackageVersion","Remove-CAPackage","Remove-CAPackageVersion","Unpublish-CAPackageVersion","Update-CAPackageVersionsStatus","Write-CAPackageOriginConfiguration")
    "OriginRestrictionType"=@("Get-CAAllowedRepositoriesForGroupList")
    "OriginType"=@("Get-CAPackageVersionList")
    "Publish"=@("Get-CAPackageList")
    "Restrictions_Publish"=@("Write-CAPackageOriginConfiguration")
    "Restrictions_Upstream"=@("Write-CAPackageOriginConfiguration")
    "SortBy"=@("Get-CAPackageVersionList")
    "Status"=@("Get-CAPackageVersionList")
    "TargetStatus"=@("Update-CAPackageVersionsStatus")
    "Upstream"=@("Get-CAPackageList")
}

_awsArgumentCompleterRegistration $CA_Completers $CA_map

$CA_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CA.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CA_SelectMap = @{
    "Select"=@("Connect-CAExternalConnection",
               "Copy-CAPackageVersion",
               "New-CADomain",
               "New-CAPackageGroup",
               "New-CARepository",
               "Remove-CADomain",
               "Remove-CADomainPermissionsPolicy",
               "Remove-CAPackage",
               "Remove-CAPackageGroup",
               "Remove-CAPackageVersion",
               "Remove-CARepository",
               "Remove-CARepositoryPermissionsPolicy",
               "Get-CADomain",
               "Get-CAPackage",
               "Get-CAPackageGroup",
               "Get-CAPackageVersion",
               "Get-CARepository",
               "Disconnect-CAExternalConnection",
               "Unpublish-CAPackageVersion",
               "Get-CAAssociatedPackageGroup",
               "Get-CAAuthorizationToken",
               "Get-CADomainPermissionsPolicy",
               "Get-CAPackageVersionAsset",
               "Get-CAPackageVersionReadme",
               "Get-CARepositoryEndpoint",
               "Get-CARepositoryPermissionsPolicy",
               "Get-CAAllowedRepositoriesForGroupList",
               "Get-CAAssociatedPackageList",
               "Get-CADomainList",
               "Get-CAPackageGroupList",
               "Get-CAPackageList",
               "Get-CAPackageVersionAssetList",
               "Get-CAPackageVersionDependencyList",
               "Get-CAPackageVersionList",
               "Get-CARepositoryList",
               "Get-CARepositoriesInDomainList",
               "Get-CASubPackageGroupList",
               "Get-CAResourceTag",
               "Publish-CAPackageVersion",
               "Write-CADomainPermissionsPolicy",
               "Write-CAPackageOriginConfiguration",
               "Write-CARepositoryPermissionsPolicy",
               "Add-CAResourceTag",
               "Remove-CAResourceTag",
               "Update-CAPackageGroup",
               "Update-CAPackageGroupOriginConfiguration",
               "Update-CAPackageVersionsStatus",
               "Update-CARepository")
}

_awsArgumentCompleterRegistration $CA_SelectCompleters $CA_SelectMap
# Argument completions for service AWS CodeBuild


$CB_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CodeBuild.ArtifactNamespace
        {
            ($_ -eq "New-CBProject/Artifacts_NamespaceType") -Or
            ($_ -eq "Update-CBProject/Artifacts_NamespaceType") -Or
            ($_ -eq "Start-CBBatch/ArtifactsOverride_NamespaceType") -Or
            ($_ -eq "Start-CBBuild/ArtifactsOverride_NamespaceType")
        }
        {
            $v = "BUILD_ID","NONE"
            break
        }

        # Amazon.CodeBuild.ArtifactPackaging
        {
            ($_ -eq "New-CBProject/Artifacts_Packaging") -Or
            ($_ -eq "Update-CBProject/Artifacts_Packaging") -Or
            ($_ -eq "Start-CBBatch/ArtifactsOverride_Packaging") -Or
            ($_ -eq "Start-CBBuild/ArtifactsOverride_Packaging")
        }
        {
            $v = "NONE","ZIP"
            break
        }

        # Amazon.CodeBuild.ArtifactsType
        {
            ($_ -eq "New-CBProject/Artifacts_Type") -Or
            ($_ -eq "Update-CBProject/Artifacts_Type") -Or
            ($_ -eq "Start-CBBatch/ArtifactsOverride_Type") -Or
            ($_ -eq "Start-CBBuild/ArtifactsOverride_Type")
        }
        {
            $v = "CODEPIPELINE","NO_ARTIFACTS","S3"
            break
        }

        # Amazon.CodeBuild.AuthType
        "Import-CBSourceCredential/AuthType"
        {
            $v = "BASIC_AUTH","CODECONNECTIONS","OAUTH","PERSONAL_ACCESS_TOKEN","SECRETS_MANAGER"
            break
        }

        # Amazon.CodeBuild.BatchReportModeType
        {
            ($_ -eq "New-CBProject/BuildBatchConfig_BatchReportMode") -Or
            ($_ -eq "Update-CBProject/BuildBatchConfig_BatchReportMode") -Or
            ($_ -eq "Start-CBBatch/BuildBatchConfigOverride_BatchReportMode")
        }
        {
            $v = "REPORT_AGGREGATED_BATCH","REPORT_INDIVIDUAL_BUILDS"
            break
        }

        # Amazon.CodeBuild.BucketOwnerAccess
        {
            ($_ -eq "New-CBProject/Artifacts_BucketOwnerAccess") -Or
            ($_ -eq "Update-CBProject/Artifacts_BucketOwnerAccess") -Or
            ($_ -eq "Start-CBBatch/ArtifactsOverride_BucketOwnerAccess") -Or
            ($_ -eq "Start-CBBuild/ArtifactsOverride_BucketOwnerAccess") -Or
            ($_ -eq "New-CBProject/S3Logs_BucketOwnerAccess") -Or
            ($_ -eq "Start-CBBatch/S3Logs_BucketOwnerAccess") -Or
            ($_ -eq "Start-CBBuild/S3Logs_BucketOwnerAccess") -Or
            ($_ -eq "Update-CBProject/S3Logs_BucketOwnerAccess")
        }
        {
            $v = "FULL","NONE","READ_ONLY"
            break
        }

        # Amazon.CodeBuild.CacheType
        {
            ($_ -eq "New-CBProject/Cache_Type") -Or
            ($_ -eq "Update-CBProject/Cache_Type") -Or
            ($_ -eq "Start-CBBatch/CacheOverride_Type") -Or
            ($_ -eq "Start-CBBuild/CacheOverride_Type")
        }
        {
            $v = "LOCAL","NO_CACHE","S3"
            break
        }

        # Amazon.CodeBuild.CommandType
        "Start-CBCommandExecution/Type"
        {
            $v = "SHELL"
            break
        }

        # Amazon.CodeBuild.ComputeType
        {
            ($_ -eq "New-CBFleet/ComputeType") -Or
            ($_ -eq "Update-CBFleet/ComputeType") -Or
            ($_ -eq "Start-CBBatch/ComputeTypeOverride") -Or
            ($_ -eq "Start-CBBuild/ComputeTypeOverride") -Or
            ($_ -eq "New-CBProject/DockerServer_ComputeType") -Or
            ($_ -eq "Update-CBProject/DockerServer_ComputeType") -Or
            ($_ -eq "New-CBProject/Environment_ComputeType") -Or
            ($_ -eq "Update-CBProject/Environment_ComputeType")
        }
        {
            $v = "ATTRIBUTE_BASED_COMPUTE","BUILD_GENERAL1_2XLARGE","BUILD_GENERAL1_LARGE","BUILD_GENERAL1_MEDIUM","BUILD_GENERAL1_SMALL","BUILD_GENERAL1_XLARGE","BUILD_LAMBDA_10GB","BUILD_LAMBDA_1GB","BUILD_LAMBDA_2GB","BUILD_LAMBDA_4GB","BUILD_LAMBDA_8GB","CUSTOM_INSTANCE_TYPE"
            break
        }

        # Amazon.CodeBuild.CredentialProviderType
        {
            ($_ -eq "New-CBProject/RegistryCredential_CredentialProvider") -Or
            ($_ -eq "Update-CBProject/RegistryCredential_CredentialProvider") -Or
            ($_ -eq "Start-CBBatch/RegistryCredentialOverride_CredentialProvider") -Or
            ($_ -eq "Start-CBBuild/RegistryCredentialOverride_CredentialProvider")
        }
        {
            $v = "SECRETS_MANAGER"
            break
        }

        # Amazon.CodeBuild.EnvironmentType
        {
            ($_ -eq "New-CBProject/Environment_Type") -Or
            ($_ -eq "Update-CBProject/Environment_Type") -Or
            ($_ -eq "New-CBFleet/EnvironmentType") -Or
            ($_ -eq "Update-CBFleet/EnvironmentType") -Or
            ($_ -eq "Start-CBBatch/EnvironmentTypeOverride") -Or
            ($_ -eq "Start-CBBuild/EnvironmentTypeOverride")
        }
        {
            $v = "ARM_CONTAINER","ARM_EC2","ARM_LAMBDA_CONTAINER","LINUX_CONTAINER","LINUX_EC2","LINUX_GPU_CONTAINER","LINUX_LAMBDA_CONTAINER","MAC_ARM","WINDOWS_CONTAINER","WINDOWS_EC2","WINDOWS_SERVER_2019_CONTAINER","WINDOWS_SERVER_2022_CONTAINER"
            break
        }

        # Amazon.CodeBuild.FleetOverflowBehavior
        {
            ($_ -eq "New-CBFleet/OverflowBehavior") -Or
            ($_ -eq "Update-CBFleet/OverflowBehavior")
        }
        {
            $v = "ON_DEMAND","QUEUE"
            break
        }

        # Amazon.CodeBuild.FleetProxyRuleBehavior
        {
            ($_ -eq "New-CBFleet/ProxyConfiguration_DefaultBehavior") -Or
            ($_ -eq "Update-CBFleet/ProxyConfiguration_DefaultBehavior")
        }
        {
            $v = "ALLOW_ALL","DENY_ALL"
            break
        }

        # Amazon.CodeBuild.FleetScalingType
        {
            ($_ -eq "New-CBFleet/ScalingConfiguration_ScalingType") -Or
            ($_ -eq "Update-CBFleet/ScalingConfiguration_ScalingType")
        }
        {
            $v = "TARGET_TRACKING_SCALING"
            break
        }

        # Amazon.CodeBuild.FleetSortByType
        "Get-CBFleetList/SortBy"
        {
            $v = "CREATED_TIME","LAST_MODIFIED_TIME","NAME"
            break
        }

        # Amazon.CodeBuild.ImagePullCredentialsType
        {
            ($_ -eq "New-CBProject/Environment_ImagePullCredentialsType") -Or
            ($_ -eq "Update-CBProject/Environment_ImagePullCredentialsType") -Or
            ($_ -eq "Start-CBBatch/ImagePullCredentialsTypeOverride") -Or
            ($_ -eq "Start-CBBuild/ImagePullCredentialsTypeOverride")
        }
        {
            $v = "CODEBUILD","SERVICE_ROLE"
            break
        }

        # Amazon.CodeBuild.LogsConfigStatusType
        {
            ($_ -eq "New-CBProject/CloudWatchLogs_Status") -Or
            ($_ -eq "Start-CBBatch/CloudWatchLogs_Status") -Or
            ($_ -eq "Start-CBBuild/CloudWatchLogs_Status") -Or
            ($_ -eq "Update-CBProject/CloudWatchLogs_Status") -Or
            ($_ -eq "New-CBProject/S3Logs_Status") -Or
            ($_ -eq "Start-CBBatch/S3Logs_Status") -Or
            ($_ -eq "Start-CBBuild/S3Logs_Status") -Or
            ($_ -eq "Update-CBProject/S3Logs_Status")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.CodeBuild.MachineType
        {
            ($_ -eq "New-CBFleet/ComputeConfiguration_MachineType") -Or
            ($_ -eq "New-CBProject/ComputeConfiguration_MachineType") -Or
            ($_ -eq "Update-CBFleet/ComputeConfiguration_MachineType") -Or
            ($_ -eq "Update-CBProject/ComputeConfiguration_MachineType")
        }
        {
            $v = "GENERAL","NVME"
            break
        }

        # Amazon.CodeBuild.ProjectSortByType
        "Get-CBProjectList/SortBy"
        {
            $v = "CREATED_TIME","LAST_MODIFIED_TIME","NAME"
            break
        }

        # Amazon.CodeBuild.ProjectVisibilityType
        "Update-CBProjectVisibility/ProjectVisibility"
        {
            $v = "PRIVATE","PUBLIC_READ"
            break
        }

        # Amazon.CodeBuild.PullRequestBuildCommentApproval
        {
            ($_ -eq "New-CBWebhook/PullRequestBuildPolicy_RequiresCommentApproval") -Or
            ($_ -eq "Update-CBWebhook/PullRequestBuildPolicy_RequiresCommentApproval")
        }
        {
            $v = "ALL_PULL_REQUESTS","DISABLED","FORK_PULL_REQUESTS"
            break
        }

        # Amazon.CodeBuild.ReportCodeCoverageSortByType
        "Get-CBCodeCoverage/SortBy"
        {
            $v = "FILE_PATH","LINE_COVERAGE_PERCENTAGE"
            break
        }

        # Amazon.CodeBuild.ReportExportConfigType
        {
            ($_ -eq "New-CBReportGroup/ExportConfig_ExportConfigType") -Or
            ($_ -eq "Update-CBReportGroup/ExportConfig_ExportConfigType")
        }
        {
            $v = "NO_EXPORT","S3"
            break
        }

        # Amazon.CodeBuild.ReportGroupSortByType
        "Get-CBReportGroupList/SortBy"
        {
            $v = "CREATED_TIME","LAST_MODIFIED_TIME","NAME"
            break
        }

        # Amazon.CodeBuild.ReportGroupTrendFieldType
        "Get-CBReportGroupTrend/TrendField"
        {
            $v = "BRANCHES_COVERED","BRANCHES_MISSED","BRANCH_COVERAGE","DURATION","LINES_COVERED","LINES_MISSED","LINE_COVERAGE","PASS_RATE","TOTAL"
            break
        }

        # Amazon.CodeBuild.ReportPackagingType
        {
            ($_ -eq "New-CBReportGroup/S3Destination_Packaging") -Or
            ($_ -eq "Update-CBReportGroup/S3Destination_Packaging")
        }
        {
            $v = "NONE","ZIP"
            break
        }

        # Amazon.CodeBuild.ReportStatusType
        {
            ($_ -eq "Get-CBReportList/Filter_Status") -Or
            ($_ -eq "Get-CBReportsForReportGroupList/Filter_Status")
        }
        {
            $v = "DELETING","FAILED","GENERATING","INCOMPLETE","SUCCEEDED"
            break
        }

        # Amazon.CodeBuild.ReportType
        "New-CBReportGroup/Type"
        {
            $v = "CODE_COVERAGE","TEST"
            break
        }

        # Amazon.CodeBuild.RetryBuildBatchType
        "Redo-CBBatch/RetryType"
        {
            $v = "RETRY_ALL_BUILDS","RETRY_FAILED_BUILDS"
            break
        }

        # Amazon.CodeBuild.ServerType
        "Import-CBSourceCredential/ServerType"
        {
            $v = "BITBUCKET","GITHUB","GITHUB_ENTERPRISE","GITLAB","GITLAB_SELF_MANAGED"
            break
        }

        # Amazon.CodeBuild.SharedResourceSortByType
        {
            ($_ -eq "Get-CBSharedProjectList/SortBy") -Or
            ($_ -eq "Get-CBSharedReportGroupList/SortBy")
        }
        {
            $v = "ARN","MODIFIED_TIME"
            break
        }

        # Amazon.CodeBuild.SortOrderType
        {
            ($_ -eq "Get-CBBatchIdList/SortOrder") -Or
            ($_ -eq "Get-CBBatchIdListForProject/SortOrder") -Or
            ($_ -eq "Get-CBBuildIdList/SortOrder") -Or
            ($_ -eq "Get-CBBuildIdListForProject/SortOrder") -Or
            ($_ -eq "Get-CBCodeCoverage/SortOrder") -Or
            ($_ -eq "Get-CBCommandExecutionListForSandbox/SortOrder") -Or
            ($_ -eq "Get-CBFleetList/SortOrder") -Or
            ($_ -eq "Get-CBProjectList/SortOrder") -Or
            ($_ -eq "Get-CBReportGroupList/SortOrder") -Or
            ($_ -eq "Get-CBReportList/SortOrder") -Or
            ($_ -eq "Get-CBReportsForReportGroupList/SortOrder") -Or
            ($_ -eq "Get-CBSandboxIdList/SortOrder") -Or
            ($_ -eq "Get-CBSandboxIdListForProject/SortOrder") -Or
            ($_ -eq "Get-CBSharedProjectList/SortOrder") -Or
            ($_ -eq "Get-CBSharedReportGroupList/SortOrder")
        }
        {
            $v = "ASCENDING","DESCENDING"
            break
        }

        # Amazon.CodeBuild.SourceAuthType
        {
            ($_ -eq "New-CBProject/Auth_Type") -Or
            ($_ -eq "Update-CBProject/Auth_Type") -Or
            ($_ -eq "Start-CBBatch/SourceAuthOverride_Type") -Or
            ($_ -eq "Start-CBBuild/SourceAuthOverride_Type")
        }
        {
            $v = "CODECONNECTIONS","OAUTH","SECRETS_MANAGER"
            break
        }

        # Amazon.CodeBuild.SourceType
        {
            ($_ -eq "New-CBProject/Source_Type") -Or
            ($_ -eq "Update-CBProject/Source_Type") -Or
            ($_ -eq "Start-CBBatch/SourceTypeOverride") -Or
            ($_ -eq "Start-CBBuild/SourceTypeOverride")
        }
        {
            $v = "BITBUCKET","CODECOMMIT","CODEPIPELINE","GITHUB","GITHUB_ENTERPRISE","GITLAB","GITLAB_SELF_MANAGED","NO_SOURCE","S3"
            break
        }

        # Amazon.CodeBuild.StatusType
        {
            ($_ -eq "Get-CBBatchIdList/Filter_Status") -Or
            ($_ -eq "Get-CBBatchIdListForProject/Filter_Status")
        }
        {
            $v = "FAILED","FAULT","IN_PROGRESS","STOPPED","SUCCEEDED","TIMED_OUT"
            break
        }

        # Amazon.CodeBuild.WebhookBuildType
        {
            ($_ -eq "New-CBWebhook/BuildType") -Or
            ($_ -eq "Update-CBWebhook/BuildType")
        }
        {
            $v = "BUILD","BUILD_BATCH","RUNNER_BUILDKITE_BUILD"
            break
        }

        # Amazon.CodeBuild.WebhookScopeType
        "New-CBWebhook/ScopeConfiguration_Scope"
        {
            $v = "GITHUB_GLOBAL","GITHUB_ORGANIZATION","GITLAB_GROUP"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CB_map = @{
    "Artifacts_BucketOwnerAccess"=@("New-CBProject","Update-CBProject")
    "Artifacts_NamespaceType"=@("New-CBProject","Update-CBProject")
    "Artifacts_Packaging"=@("New-CBProject","Update-CBProject")
    "Artifacts_Type"=@("New-CBProject","Update-CBProject")
    "ArtifactsOverride_BucketOwnerAccess"=@("Start-CBBatch","Start-CBBuild")
    "ArtifactsOverride_NamespaceType"=@("Start-CBBatch","Start-CBBuild")
    "ArtifactsOverride_Packaging"=@("Start-CBBatch","Start-CBBuild")
    "ArtifactsOverride_Type"=@("Start-CBBatch","Start-CBBuild")
    "Auth_Type"=@("New-CBProject","Update-CBProject")
    "AuthType"=@("Import-CBSourceCredential")
    "BuildBatchConfig_BatchReportMode"=@("New-CBProject","Update-CBProject")
    "BuildBatchConfigOverride_BatchReportMode"=@("Start-CBBatch")
    "BuildType"=@("New-CBWebhook","Update-CBWebhook")
    "Cache_Type"=@("New-CBProject","Update-CBProject")
    "CacheOverride_Type"=@("Start-CBBatch","Start-CBBuild")
    "CloudWatchLogs_Status"=@("New-CBProject","Start-CBBatch","Start-CBBuild","Update-CBProject")
    "ComputeConfiguration_MachineType"=@("New-CBFleet","New-CBProject","Update-CBFleet","Update-CBProject")
    "ComputeType"=@("New-CBFleet","Update-CBFleet")
    "ComputeTypeOverride"=@("Start-CBBatch","Start-CBBuild")
    "DockerServer_ComputeType"=@("New-CBProject","Update-CBProject")
    "Environment_ComputeType"=@("New-CBProject","Update-CBProject")
    "Environment_ImagePullCredentialsType"=@("New-CBProject","Update-CBProject")
    "Environment_Type"=@("New-CBProject","Update-CBProject")
    "EnvironmentType"=@("New-CBFleet","Update-CBFleet")
    "EnvironmentTypeOverride"=@("Start-CBBatch","Start-CBBuild")
    "ExportConfig_ExportConfigType"=@("New-CBReportGroup","Update-CBReportGroup")
    "Filter_Status"=@("Get-CBBatchIdList","Get-CBBatchIdListForProject","Get-CBReportList","Get-CBReportsForReportGroupList")
    "ImagePullCredentialsTypeOverride"=@("Start-CBBatch","Start-CBBuild")
    "OverflowBehavior"=@("New-CBFleet","Update-CBFleet")
    "ProjectVisibility"=@("Update-CBProjectVisibility")
    "ProxyConfiguration_DefaultBehavior"=@("New-CBFleet","Update-CBFleet")
    "PullRequestBuildPolicy_RequiresCommentApproval"=@("New-CBWebhook","Update-CBWebhook")
    "RegistryCredential_CredentialProvider"=@("New-CBProject","Update-CBProject")
    "RegistryCredentialOverride_CredentialProvider"=@("Start-CBBatch","Start-CBBuild")
    "RetryType"=@("Redo-CBBatch")
    "S3Destination_Packaging"=@("New-CBReportGroup","Update-CBReportGroup")
    "S3Logs_BucketOwnerAccess"=@("New-CBProject","Start-CBBatch","Start-CBBuild","Update-CBProject")
    "S3Logs_Status"=@("New-CBProject","Start-CBBatch","Start-CBBuild","Update-CBProject")
    "ScalingConfiguration_ScalingType"=@("New-CBFleet","Update-CBFleet")
    "ScopeConfiguration_Scope"=@("New-CBWebhook")
    "ServerType"=@("Import-CBSourceCredential")
    "SortBy"=@("Get-CBCodeCoverage","Get-CBFleetList","Get-CBProjectList","Get-CBReportGroupList","Get-CBSharedProjectList","Get-CBSharedReportGroupList")
    "SortOrder"=@("Get-CBBatchIdList","Get-CBBatchIdListForProject","Get-CBBuildIdList","Get-CBBuildIdListForProject","Get-CBCodeCoverage","Get-CBCommandExecutionListForSandbox","Get-CBFleetList","Get-CBProjectList","Get-CBReportGroupList","Get-CBReportList","Get-CBReportsForReportGroupList","Get-CBSandboxIdList","Get-CBSandboxIdListForProject","Get-CBSharedProjectList","Get-CBSharedReportGroupList")
    "Source_Type"=@("New-CBProject","Update-CBProject")
    "SourceAuthOverride_Type"=@("Start-CBBatch","Start-CBBuild")
    "SourceTypeOverride"=@("Start-CBBatch","Start-CBBuild")
    "TrendField"=@("Get-CBReportGroupTrend")
    "Type"=@("New-CBReportGroup","Start-CBCommandExecution")
}

_awsArgumentCompleterRegistration $CB_Completers $CB_map

$CB_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CB.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CB_SelectMap = @{
    "Select"=@("Remove-CBBuildBatch",
               "Get-CBBatch",
               "Get-CBBuildBatch",
               "Get-CBCommandExecutionBatch",
               "Get-CBCBFleetBatch",
               "Get-CBProjectBatch",
               "Get-CBReportGroupBatch",
               "Get-CBReportBatch",
               "Get-CBSandboxBatch",
               "New-CBFleet",
               "New-CBProject",
               "New-CBReportGroup",
               "New-CBWebhook",
               "Remove-CBBatch",
               "Remove-CBFleet",
               "Remove-CBProject",
               "Remove-CBReport",
               "Remove-CBReportGroup",
               "Remove-CBResourcePolicy",
               "Remove-CBSourceCredential",
               "Remove-CBWebhook",
               "Get-CBCodeCoverage",
               "Get-CBTestCase",
               "Get-CBReportGroupTrend",
               "Get-CBResourcePolicy",
               "Import-CBSourceCredential",
               "Reset-CBProjectCache",
               "Get-CBBatchIdList",
               "Get-CBBatchIdListForProject",
               "Get-CBBuildIdList",
               "Get-CBBuildIdListForProject",
               "Get-CBCommandExecutionListForSandbox",
               "Get-CBCuratedEnvironmentImageList",
               "Get-CBFleetList",
               "Get-CBProjectList",
               "Get-CBReportGroupList",
               "Get-CBReportList",
               "Get-CBReportsForReportGroupList",
               "Get-CBSandboxIdList",
               "Get-CBSandboxIdListForProject",
               "Get-CBSharedProjectList",
               "Get-CBSharedReportGroupList",
               "Get-CBSourceCredentialList",
               "Write-CBResourcePolicy",
               "Redo-CBBuild",
               "Redo-CBBatch",
               "Start-CBBuild",
               "Start-CBBatch",
               "Start-CBCommandExecution",
               "Start-CBSandbox",
               "Start-CBSandboxConnection",
               "Stop-CBBuild",
               "Stop-CBBatch",
               "Stop-CBSandbox",
               "Update-CBFleet",
               "Update-CBProject",
               "Update-CBProjectVisibility",
               "Update-CBReportGroup",
               "Update-CBWebhook")
}

_awsArgumentCompleterRegistration $CB_SelectCompleters $CB_SelectMap
# Argument completions for service AWS CodeCatalyst


$CCAT_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CodeCatalyst.DevEnvironmentSessionType
        "Start-CCATDevEnvironmentSession/SessionConfiguration_SessionType"
        {
            $v = "SSH","SSM"
            break
        }

        # Amazon.CodeCatalyst.InstanceType
        {
            ($_ -eq "New-CCATDevEnvironment/InstanceType") -Or
            ($_ -eq "Start-CCATDevEnvironment/InstanceType") -Or
            ($_ -eq "Update-CCATDevEnvironment/InstanceType")
        }
        {
            $v = "dev.standard1.large","dev.standard1.medium","dev.standard1.small","dev.standard1.xlarge"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CCAT_map = @{
    "InstanceType"=@("New-CCATDevEnvironment","Start-CCATDevEnvironment","Update-CCATDevEnvironment")
    "SessionConfiguration_SessionType"=@("Start-CCATDevEnvironmentSession")
}

_awsArgumentCompleterRegistration $CCAT_Completers $CCAT_map

$CCAT_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CCAT.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CCAT_SelectMap = @{
    "Select"=@("New-CCATAccessToken",
               "New-CCATDevEnvironment",
               "New-CCATProject",
               "New-CCATSourceRepository",
               "New-CCATSourceRepositoryBranch",
               "Remove-CCATAccessToken",
               "Remove-CCATDevEnvironment",
               "Remove-CCATProject",
               "Remove-CCATSourceRepository",
               "Remove-CCATSpace",
               "Get-CCATDevEnvironment",
               "Get-CCATProject",
               "Get-CCATSourceRepository",
               "Get-CCATSourceRepositoryCloneUrl",
               "Get-CCATSpace",
               "Get-CCATSubscription",
               "Get-CCATUserDetail",
               "Get-CCATWorkflow",
               "Get-CCATWorkflowRun",
               "Get-CCATAccessTokenList",
               "Get-CCATDevEnvironmentList",
               "Get-CCATDevEnvironmentSessionList",
               "Get-CCATEventLogList",
               "Get-CCATProjectList",
               "Get-CCATSourceRepositoryList",
               "Get-CCATSourceRepositoryBranchList",
               "Get-CCATSpaceList",
               "Get-CCATWorkflowRunList",
               "Get-CCATWorkflowList",
               "Start-CCATDevEnvironment",
               "Start-CCATDevEnvironmentSession",
               "Start-CCATWorkflowRun",
               "Stop-CCATDevEnvironment",
               "Stop-CCATDevEnvironmentSession",
               "Update-CCATDevEnvironment",
               "Update-CCATProject",
               "Update-CCATSpace",
               "Confirm-CCATSession")
}

_awsArgumentCompleterRegistration $CCAT_SelectCompleters $CCAT_SelectMap
# Argument completions for service AWS CodeCommit


$CC_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CodeCommit.ApprovalState
        "Update-CCPullRequestApprovalState/ApprovalState"
        {
            $v = "APPROVE","REVOKE"
            break
        }

        # Amazon.CodeCommit.ConflictDetailLevelTypeEnum
        {
            ($_ -eq "Get-CCFileMergeConflict/ConflictDetailLevel") -Or
            ($_ -eq "Get-CCFileMergeConflictBatch/ConflictDetailLevel") -Or
            ($_ -eq "Get-CCMergeCommit/ConflictDetailLevel") -Or
            ($_ -eq "Get-CCMergeConflict/ConflictDetailLevel") -Or
            ($_ -eq "Get-CCMergeOption/ConflictDetailLevel") -Or
            ($_ -eq "Merge-CCBranchesBySquash/ConflictDetailLevel") -Or
            ($_ -eq "Merge-CCBranchesByThreeWay/ConflictDetailLevel") -Or
            ($_ -eq "Merge-CCPullRequestBySquash/ConflictDetailLevel") -Or
            ($_ -eq "Merge-CCPullRequestByThreeWay/ConflictDetailLevel") -Or
            ($_ -eq "New-CCUnreferencedMergeCommit/ConflictDetailLevel")
        }
        {
            $v = "FILE_LEVEL","LINE_LEVEL"
            break
        }

        # Amazon.CodeCommit.ConflictResolutionStrategyTypeEnum
        {
            ($_ -eq "Get-CCFileMergeConflict/ConflictResolutionStrategy") -Or
            ($_ -eq "Get-CCFileMergeConflictBatch/ConflictResolutionStrategy") -Or
            ($_ -eq "Get-CCMergeCommit/ConflictResolutionStrategy") -Or
            ($_ -eq "Get-CCMergeConflict/ConflictResolutionStrategy") -Or
            ($_ -eq "Get-CCMergeOption/ConflictResolutionStrategy") -Or
            ($_ -eq "Merge-CCBranchesBySquash/ConflictResolutionStrategy") -Or
            ($_ -eq "Merge-CCBranchesByThreeWay/ConflictResolutionStrategy") -Or
            ($_ -eq "Merge-CCPullRequestBySquash/ConflictResolutionStrategy") -Or
            ($_ -eq "Merge-CCPullRequestByThreeWay/ConflictResolutionStrategy") -Or
            ($_ -eq "New-CCUnreferencedMergeCommit/ConflictResolutionStrategy")
        }
        {
            $v = "ACCEPT_DESTINATION","ACCEPT_SOURCE","AUTOMERGE","NONE"
            break
        }

        # Amazon.CodeCommit.FileModeTypeEnum
        "Write-CCFile/FileMode"
        {
            $v = "EXECUTABLE","NORMAL","SYMLINK"
            break
        }

        # Amazon.CodeCommit.MergeOptionTypeEnum
        {
            ($_ -eq "Get-CCFileMergeConflict/MergeOption") -Or
            ($_ -eq "Get-CCFileMergeConflictBatch/MergeOption") -Or
            ($_ -eq "Get-CCMergeConflict/MergeOption") -Or
            ($_ -eq "New-CCUnreferencedMergeCommit/MergeOption")
        }
        {
            $v = "FAST_FORWARD_MERGE","SQUASH_MERGE","THREE_WAY_MERGE"
            break
        }

        # Amazon.CodeCommit.OrderEnum
        "Get-CCRepositoryList/Order"
        {
            $v = "ascending","descending"
            break
        }

        # Amazon.CodeCommit.OverrideStatus
        "Skip-CCPullRequestApprovalRule/OverrideStatus"
        {
            $v = "OVERRIDE","REVOKE"
            break
        }

        # Amazon.CodeCommit.PullRequestEventType
        "Get-CCPullRequestEvent/PullRequestEventType"
        {
            $v = "PULL_REQUEST_APPROVAL_RULE_CREATED","PULL_REQUEST_APPROVAL_RULE_DELETED","PULL_REQUEST_APPROVAL_RULE_OVERRIDDEN","PULL_REQUEST_APPROVAL_RULE_UPDATED","PULL_REQUEST_APPROVAL_STATE_CHANGED","PULL_REQUEST_CREATED","PULL_REQUEST_MERGE_STATE_CHANGED","PULL_REQUEST_SOURCE_REFERENCE_UPDATED","PULL_REQUEST_STATUS_CHANGED"
            break
        }

        # Amazon.CodeCommit.PullRequestStatusEnum
        {
            ($_ -eq "Get-CCPullRequestList/PullRequestStatus") -Or
            ($_ -eq "Update-CCPullRequestStatus/PullRequestStatus")
        }
        {
            $v = "CLOSED","OPEN"
            break
        }

        # Amazon.CodeCommit.RelativeFileVersionEnum
        {
            ($_ -eq "Send-CCCommentForComparedCommit/Location_RelativeFileVersion") -Or
            ($_ -eq "Send-CCCommentForPullRequest/Location_RelativeFileVersion")
        }
        {
            $v = "AFTER","BEFORE"
            break
        }

        # Amazon.CodeCommit.SortByEnum
        "Get-CCRepositoryList/SortBy"
        {
            $v = "lastModifiedDate","repositoryName"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CC_map = @{
    "ApprovalState"=@("Update-CCPullRequestApprovalState")
    "ConflictDetailLevel"=@("Get-CCFileMergeConflict","Get-CCFileMergeConflictBatch","Get-CCMergeCommit","Get-CCMergeConflict","Get-CCMergeOption","Merge-CCBranchesBySquash","Merge-CCBranchesByThreeWay","Merge-CCPullRequestBySquash","Merge-CCPullRequestByThreeWay","New-CCUnreferencedMergeCommit")
    "ConflictResolutionStrategy"=@("Get-CCFileMergeConflict","Get-CCFileMergeConflictBatch","Get-CCMergeCommit","Get-CCMergeConflict","Get-CCMergeOption","Merge-CCBranchesBySquash","Merge-CCBranchesByThreeWay","Merge-CCPullRequestBySquash","Merge-CCPullRequestByThreeWay","New-CCUnreferencedMergeCommit")
    "FileMode"=@("Write-CCFile")
    "Location_RelativeFileVersion"=@("Send-CCCommentForComparedCommit","Send-CCCommentForPullRequest")
    "MergeOption"=@("Get-CCFileMergeConflict","Get-CCFileMergeConflictBatch","Get-CCMergeConflict","New-CCUnreferencedMergeCommit")
    "Order"=@("Get-CCRepositoryList")
    "OverrideStatus"=@("Skip-CCPullRequestApprovalRule")
    "PullRequestEventType"=@("Get-CCPullRequestEvent")
    "PullRequestStatus"=@("Get-CCPullRequestList","Update-CCPullRequestStatus")
    "SortBy"=@("Get-CCRepositoryList")
}

_awsArgumentCompleterRegistration $CC_Completers $CC_map

$CC_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CC.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CC_SelectMap = @{
    "Select"=@("Add-CCApprovalRuleTemplateToRepository",
               "Add-CCApprovalRuleTemplateToRepositoryBatch",
               "Get-CCFileMergeConflictBatch",
               "Remove-CCApprovalRuleTemplateFromRepositoryBatch",
               "Get-CCCommitBatch",
               "Get-CCRepositoryBatch",
               "New-CCApprovalRuleTemplate",
               "New-CCBranch",
               "New-CCCommit",
               "New-CCPullRequest",
               "New-CCPullRequestApprovalRule",
               "New-CCRepository",
               "New-CCUnreferencedMergeCommit",
               "Remove-CCApprovalRuleTemplate",
               "Remove-CCBranch",
               "Remove-CCCommentContent",
               "Remove-CCFile",
               "Remove-CCPullRequestApprovalRule",
               "Remove-CCRepository",
               "Get-CCFileMergeConflict",
               "Get-CCPullRequestEvent",
               "Remove-CCApprovalRuleTemplateFromRepository",
               "Invoke-CCPullRequestApprovalRule",
               "Get-CCApprovalRuleTemplate",
               "Get-CCBlob",
               "Get-CCBranch",
               "Get-CCComment",
               "Get-CCCommentReaction",
               "Get-CCCommentsForComparedCommit",
               "Get-CCCommentsForPullRequest",
               "Get-CCCommit",
               "Get-CCDifferenceList",
               "Get-CCFile",
               "Get-CCFolder",
               "Get-CCMergeCommit",
               "Get-CCMergeConflict",
               "Get-CCMergeOption",
               "Get-CCPullRequest",
               "Get-CCPullRequestApprovalState",
               "Get-CCPullRequestOverrideState",
               "Get-CCRepository",
               "Get-CCRepositoryTrigger",
               "Get-CCApprovalRuleTemplateList",
               "Get-CCAssociatedApprovalRuleTemplatesForRepositoryList",
               "Get-CCBranchList",
               "Get-CCFileCommitHistoryList",
               "Get-CCPullRequestList",
               "Get-CCRepositoryList",
               "Get-CCRepositoriesForApprovalRuleTemplateList",
               "Get-CCResourceTag",
               "Merge-CCBranchesByFastForward",
               "Merge-CCBranchesBySquash",
               "Merge-CCBranchesByThreeWay",
               "Merge-CCPullRequestByFastForward",
               "Merge-CCPullRequestBySquash",
               "Merge-CCPullRequestByThreeWay",
               "Skip-CCPullRequestApprovalRule",
               "Send-CCCommentForComparedCommit",
               "Send-CCCommentForPullRequest",
               "Send-CCCommentReply",
               "Write-CCCommentReaction",
               "Write-CCFile",
               "Set-CCRepositoryTrigger",
               "Add-CCResourceTag",
               "Test-CCRepositoryTrigger",
               "Remove-CCResourceTag",
               "Update-CCApprovalRuleTemplateContent",
               "Update-CCApprovalRuleTemplateDescription",
               "Update-CCApprovalRuleTemplateName",
               "Update-CCComment",
               "Update-CCDefaultBranch",
               "Update-CCPullRequestApprovalRuleContent",
               "Update-CCPullRequestApprovalState",
               "Update-CCPullRequestDescription",
               "Update-CCPullRequestStatus",
               "Update-CCPullRequestTitle",
               "Update-CCRepositoryDescription",
               "Update-CCRepositoryEncryptionKey",
               "Update-CCRepositoryName")
}

_awsArgumentCompleterRegistration $CC_SelectCompleters $CC_SelectMap
# Argument completions for service AWS CodeConnections


$CCON_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CodeConnections.ProviderType
        {
            ($_ -eq "New-CCONConnection/ProviderType") -Or
            ($_ -eq "New-CCONHost/ProviderType") -Or
            ($_ -eq "Get-CCONConnectionList/ProviderTypeFilter")
        }
        {
            $v = "AzureDevOps","Bitbucket","GitHub","GitHubEnterpriseServer","GitLab","GitLabSelfManaged"
            break
        }

        # Amazon.CodeConnections.PublishDeploymentStatus
        {
            ($_ -eq "New-CCONSyncConfiguration/PublishDeploymentStatus") -Or
            ($_ -eq "Update-CCONSyncConfiguration/PublishDeploymentStatus")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.CodeConnections.PullRequestComment
        {
            ($_ -eq "New-CCONSyncConfiguration/PullRequestComment") -Or
            ($_ -eq "Update-CCONSyncConfiguration/PullRequestComment")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.CodeConnections.SyncConfigurationType
        {
            ($_ -eq "Get-CCONRepositorySyncDefinitionList/SyncType") -Or
            ($_ -eq "Get-CCONRepositorySyncStatus/SyncType") -Or
            ($_ -eq "Get-CCONResourceSyncStatus/SyncType") -Or
            ($_ -eq "Get-CCONSyncBlockerSummary/SyncType") -Or
            ($_ -eq "Get-CCONSyncConfiguration/SyncType") -Or
            ($_ -eq "Get-CCONSyncConfigurationList/SyncType") -Or
            ($_ -eq "New-CCONSyncConfiguration/SyncType") -Or
            ($_ -eq "Remove-CCONSyncConfiguration/SyncType") -Or
            ($_ -eq "Update-CCONSyncBlocker/SyncType") -Or
            ($_ -eq "Update-CCONSyncConfiguration/SyncType")
        }
        {
            $v = "CFN_STACK_SYNC"
            break
        }

        # Amazon.CodeConnections.TriggerResourceUpdateOn
        {
            ($_ -eq "New-CCONSyncConfiguration/TriggerResourceUpdateOn") -Or
            ($_ -eq "Update-CCONSyncConfiguration/TriggerResourceUpdateOn")
        }
        {
            $v = "ANY_CHANGE","FILE_CHANGE"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CCON_map = @{
    "ProviderType"=@("New-CCONConnection","New-CCONHost")
    "ProviderTypeFilter"=@("Get-CCONConnectionList")
    "PublishDeploymentStatus"=@("New-CCONSyncConfiguration","Update-CCONSyncConfiguration")
    "PullRequestComment"=@("New-CCONSyncConfiguration","Update-CCONSyncConfiguration")
    "SyncType"=@("Get-CCONRepositorySyncDefinitionList","Get-CCONRepositorySyncStatus","Get-CCONResourceSyncStatus","Get-CCONSyncBlockerSummary","Get-CCONSyncConfiguration","Get-CCONSyncConfigurationList","New-CCONSyncConfiguration","Remove-CCONSyncConfiguration","Update-CCONSyncBlocker","Update-CCONSyncConfiguration")
    "TriggerResourceUpdateOn"=@("New-CCONSyncConfiguration","Update-CCONSyncConfiguration")
}

_awsArgumentCompleterRegistration $CCON_Completers $CCON_map

$CCON_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CCON.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CCON_SelectMap = @{
    "Select"=@("New-CCONConnection",
               "New-CCONHost",
               "New-CCONRepositoryLink",
               "New-CCONSyncConfiguration",
               "Remove-CCONConnection",
               "Remove-CCONHost",
               "Remove-CCONRepositoryLink",
               "Remove-CCONSyncConfiguration",
               "Get-CCONConnection",
               "Get-CCONHost",
               "Get-CCONRepositoryLink",
               "Get-CCONRepositorySyncStatus",
               "Get-CCONResourceSyncStatus",
               "Get-CCONSyncBlockerSummary",
               "Get-CCONSyncConfiguration",
               "Get-CCONConnectionList",
               "Get-CCONHostList",
               "Get-CCONRepositoryLinkList",
               "Get-CCONRepositorySyncDefinitionList",
               "Get-CCONSyncConfigurationList",
               "Get-CCONResourceTag",
               "Add-CCONResourceTag",
               "Remove-CCONResourceTag",
               "Update-CCONHost",
               "Update-CCONRepositoryLink",
               "Update-CCONSyncBlocker",
               "Update-CCONSyncConfiguration")
}

_awsArgumentCompleterRegistration $CCON_SelectCompleters $CCON_SelectMap
# Argument completions for service AWS CodeDeploy


$CD_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CodeDeploy.ApplicationRevisionSortBy
        "Get-CDApplicationRevisionList/SortBy"
        {
            $v = "firstUsedTime","lastUsedTime","registerTime"
            break
        }

        # Amazon.CodeDeploy.BundleType
        {
            ($_ -eq "Get-CDApplicationRevision/S3Location_BundleType") -Or
            ($_ -eq "New-CDDeployment/S3Location_BundleType") -Or
            ($_ -eq "Register-CDApplicationRevision/S3Location_BundleType")
        }
        {
            $v = "JSON","tar","tgz","YAML","zip"
            break
        }

        # Amazon.CodeDeploy.ComputePlatform
        {
            ($_ -eq "New-CDApplication/ComputePlatform") -Or
            ($_ -eq "New-CDDeploymentConfig/ComputePlatform")
        }
        {
            $v = "ECS","Lambda","Server"
            break
        }

        # Amazon.CodeDeploy.DeploymentOption
        {
            ($_ -eq "New-CDDeploymentGroup/DeploymentStyleOption") -Or
            ($_ -eq "Update-CDDeploymentGroup/DeploymentStyleOption")
        }
        {
            $v = "WITHOUT_TRAFFIC_CONTROL","WITH_TRAFFIC_CONTROL"
            break
        }

        # Amazon.CodeDeploy.DeploymentReadyAction
        {
            ($_ -eq "New-CDDeploymentGroup/DeploymentReadyOptionTimeoutAction") -Or
            ($_ -eq "Update-CDDeploymentGroup/DeploymentReadyOptionTimeoutAction")
        }
        {
            $v = "CONTINUE_DEPLOYMENT","STOP_DEPLOYMENT"
            break
        }

        # Amazon.CodeDeploy.DeploymentType
        {
            ($_ -eq "New-CDDeploymentGroup/DeploymentStyleType") -Or
            ($_ -eq "Update-CDDeploymentGroup/DeploymentStyleType")
        }
        {
            $v = "BLUE_GREEN","IN_PLACE"
            break
        }

        # Amazon.CodeDeploy.DeploymentWaitType
        "Resume-CDDeployment/DeploymentWaitType"
        {
            $v = "READY_WAIT","TERMINATION_WAIT"
            break
        }

        # Amazon.CodeDeploy.FileExistsBehavior
        "New-CDDeployment/FileExistsBehavior"
        {
            $v = "DISALLOW","OVERWRITE","RETAIN"
            break
        }

        # Amazon.CodeDeploy.GreenFleetProvisioningAction
        {
            ($_ -eq "New-CDDeploymentGroup/GreenFleetProvisioningOptionAction") -Or
            ($_ -eq "Update-CDDeploymentGroup/GreenFleetProvisioningOptionAction")
        }
        {
            $v = "COPY_AUTO_SCALING_GROUP","DISCOVER_EXISTING"
            break
        }

        # Amazon.CodeDeploy.InstanceAction
        {
            ($_ -eq "New-CDDeploymentGroup/OnSuccessBlueInstanceTerminationAction") -Or
            ($_ -eq "Update-CDDeploymentGroup/OnSuccessBlueInstanceTerminationAction")
        }
        {
            $v = "KEEP_ALIVE","TERMINATE"
            break
        }

        # Amazon.CodeDeploy.LifecycleEventStatus
        "Write-CDLifecycleEventHookExecutionStatus/Status"
        {
            $v = "Failed","InProgress","Pending","Skipped","Succeeded","Unknown"
            break
        }

        # Amazon.CodeDeploy.ListStateFilterAction
        "Get-CDApplicationRevisionList/Deployed"
        {
            $v = "exclude","ignore","include"
            break
        }

        # Amazon.CodeDeploy.MinimumHealthyHostsPerZoneType
        "New-CDDeploymentConfig/MinimumHealthyHostsPerZone_Type"
        {
            $v = "FLEET_PERCENT","HOST_COUNT"
            break
        }

        # Amazon.CodeDeploy.MinimumHealthyHostsType
        "New-CDDeploymentConfig/MinimumHealthyHosts_Type"
        {
            $v = "FLEET_PERCENT","HOST_COUNT"
            break
        }

        # Amazon.CodeDeploy.OutdatedInstancesStrategy
        {
            ($_ -eq "New-CDDeploymentGroup/OutdatedInstancesStrategy") -Or
            ($_ -eq "Update-CDDeploymentGroup/OutdatedInstancesStrategy")
        }
        {
            $v = "IGNORE","UPDATE"
            break
        }

        # Amazon.CodeDeploy.RegistrationStatus
        "Get-CDOnPremiseInstanceList/RegistrationStatus"
        {
            $v = "Deregistered","Registered"
            break
        }

        # Amazon.CodeDeploy.RevisionLocationType
        {
            ($_ -eq "Get-CDApplicationRevision/Revision_RevisionType") -Or
            ($_ -eq "Register-CDApplicationRevision/Revision_RevisionType") -Or
            ($_ -eq "New-CDDeployment/RevisionType")
        }
        {
            $v = "AppSpecContent","GitHub","S3","String"
            break
        }

        # Amazon.CodeDeploy.SortOrder
        "Get-CDApplicationRevisionList/SortOrder"
        {
            $v = "ascending","descending"
            break
        }

        # Amazon.CodeDeploy.TrafficRoutingType
        "New-CDDeploymentConfig/TrafficRoutingConfig_Type"
        {
            $v = "AllAtOnce","TimeBasedCanary","TimeBasedLinear"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CD_map = @{
    "ComputePlatform"=@("New-CDApplication","New-CDDeploymentConfig")
    "Deployed"=@("Get-CDApplicationRevisionList")
    "DeploymentReadyOptionTimeoutAction"=@("New-CDDeploymentGroup","Update-CDDeploymentGroup")
    "DeploymentStyleOption"=@("New-CDDeploymentGroup","Update-CDDeploymentGroup")
    "DeploymentStyleType"=@("New-CDDeploymentGroup","Update-CDDeploymentGroup")
    "DeploymentWaitType"=@("Resume-CDDeployment")
    "FileExistsBehavior"=@("New-CDDeployment")
    "GreenFleetProvisioningOptionAction"=@("New-CDDeploymentGroup","Update-CDDeploymentGroup")
    "MinimumHealthyHosts_Type"=@("New-CDDeploymentConfig")
    "MinimumHealthyHostsPerZone_Type"=@("New-CDDeploymentConfig")
    "OnSuccessBlueInstanceTerminationAction"=@("New-CDDeploymentGroup","Update-CDDeploymentGroup")
    "OutdatedInstancesStrategy"=@("New-CDDeploymentGroup","Update-CDDeploymentGroup")
    "RegistrationStatus"=@("Get-CDOnPremiseInstanceList")
    "Revision_RevisionType"=@("Get-CDApplicationRevision","Register-CDApplicationRevision")
    "RevisionType"=@("New-CDDeployment")
    "S3Location_BundleType"=@("Get-CDApplicationRevision","New-CDDeployment","Register-CDApplicationRevision")
    "SortBy"=@("Get-CDApplicationRevisionList")
    "SortOrder"=@("Get-CDApplicationRevisionList")
    "Status"=@("Write-CDLifecycleEventHookExecutionStatus")
    "TrafficRoutingConfig_Type"=@("New-CDDeploymentConfig")
}

_awsArgumentCompleterRegistration $CD_Completers $CD_map

$CD_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CD.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CD_SelectMap = @{
    "Select"=@("Add-CDOnPremiseInstanceTag",
               "Get-CDApplicationRevisionBatch",
               "Get-CDApplicationBatch",
               "Get-CDDeploymentGroupBatch",
               "Get-CDDeploymentInstanceBatch",
               "Get-CDDeploymentBatch",
               "Get-CDDeploymentTargetBatch",
               "Get-CDOnPremiseInstanceBatch",
               "Resume-CDDeployment",
               "New-CDApplication",
               "New-CDDeployment",
               "New-CDDeploymentConfig",
               "New-CDDeploymentGroup",
               "Remove-CDApplication",
               "Remove-CDDeploymentConfig",
               "Remove-CDDeploymentGroup",
               "Remove-CDGitHubAccountToken",
               "Remove-CDResourcesByExternalId",
               "Unregister-CDOnPremiseInstance",
               "Get-CDApplication",
               "Get-CDApplicationRevision",
               "Get-CDDeployment",
               "Get-CDDeploymentConfig",
               "Get-CDDeploymentGroup",
               "Get-CDDeploymentInstance",
               "Get-CDDeploymentTarget",
               "Get-CDOnPremiseInstance",
               "Get-CDApplicationRevisionList",
               "Get-CDApplicationList",
               "Get-CDDeploymentConfigList",
               "Get-CDDeploymentGroupList",
               "Get-CDDeploymentInstanceList",
               "Get-CDDeploymentList",
               "Get-CDDeploymentTargetList",
               "Get-CDGitHubAccountTokenNameList",
               "Get-CDOnPremiseInstanceList",
               "Get-CDResourceTag",
               "Write-CDLifecycleEventHookExecutionStatus",
               "Register-CDApplicationRevision",
               "Register-CDOnPremiseInstance",
               "Remove-CDOnPremiseInstanceTag",
               "Skip-CDWaitTimeForInstanceTermination",
               "Stop-CDDeployment",
               "Add-CDResourceTag",
               "Remove-CDResourceTag",
               "Update-CDApplication",
               "Update-CDDeploymentGroup")
}

_awsArgumentCompleterRegistration $CD_SelectCompleters $CD_SelectMap
# Argument completions for service Amazon CodeGuru Reviewer


$CGR_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CodeGuruReviewer.EncryptionOption
        "Register-CGRRepository/KMSKeyDetails_EncryptionOption"
        {
            $v = "AWS_OWNED_CMK","CUSTOMER_MANAGED_CMK"
            break
        }

        # Amazon.CodeGuruReviewer.Type
        "Get-CGRCodeReviewList/Type"
        {
            $v = "PullRequest","RepositoryAnalysis"
            break
        }

        # Amazon.CodeGuruReviewer.VendorName
        "New-CGRCodeReview/RequestMetadata_VendorName"
        {
            $v = "GitHub","GitLab","NativeS3"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CGR_map = @{
    "KMSKeyDetails_EncryptionOption"=@("Register-CGRRepository")
    "RequestMetadata_VendorName"=@("New-CGRCodeReview")
    "Type"=@("Get-CGRCodeReviewList")
}

_awsArgumentCompleterRegistration $CGR_Completers $CGR_map

$CGR_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CGR.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CGR_SelectMap = @{
    "Select"=@("Register-CGRRepository",
               "New-CGRCodeReview",
               "Get-CGRCodeReview",
               "Get-CGRRecommendationFeedback",
               "Get-CGRRepositoryAssociation",
               "Unregister-CGRRepository",
               "Get-CGRCodeReviewList",
               "Get-CGRRecommendationFeedbackList",
               "Get-CGRRecommendationList",
               "Get-CGRRepositoryAssociationList",
               "Get-CGRResourceTag",
               "Write-CGRRecommendationFeedback",
               "Add-CGRResourceTag",
               "Remove-CGRResourceTag")
}

_awsArgumentCompleterRegistration $CGR_SelectCompleters $CGR_SelectMap
# Argument completions for service Amazon CodeGuru Profiler


$CGP_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CodeGuruProfiler.ActionGroup
        {
            ($_ -eq "Remove-CGPPermission/ActionGroup") -Or
            ($_ -eq "Write-CGPPermission/ActionGroup")
        }
        {
            $v = "agentPermissions"
            break
        }

        # Amazon.CodeGuruProfiler.AggregationPeriod
        {
            ($_ -eq "Get-CGPProfileTimeList/Period") -Or
            ($_ -eq "Get-CGPGetFrameMetricData/TargetResolution")
        }
        {
            $v = "P1D","PT1H","PT5M"
            break
        }

        # Amazon.CodeGuruProfiler.ComputePlatform
        "New-CGPProfilingGroup/ComputePlatform"
        {
            $v = "AWSLambda","Default"
            break
        }

        # Amazon.CodeGuruProfiler.FeedbackType
        "Submit-CGPFeedback/Type"
        {
            $v = "Negative","Positive"
            break
        }

        # Amazon.CodeGuruProfiler.OrderBy
        "Get-CGPProfileTimeList/OrderBy"
        {
            $v = "TimestampAscending","TimestampDescending"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CGP_map = @{
    "ActionGroup"=@("Remove-CGPPermission","Write-CGPPermission")
    "ComputePlatform"=@("New-CGPProfilingGroup")
    "OrderBy"=@("Get-CGPProfileTimeList")
    "Period"=@("Get-CGPProfileTimeList")
    "TargetResolution"=@("Get-CGPGetFrameMetricData")
    "Type"=@("Submit-CGPFeedback")
}

_awsArgumentCompleterRegistration $CGP_Completers $CGP_map

$CGP_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CGP.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CGP_SelectMap = @{
    "Select"=@("Add-CGPNotificationChannel",
               "Get-CGPGetFrameMetricData",
               "Set-CGPAgentConfiguration",
               "New-CGPProfilingGroup",
               "Remove-CGPProfilingGroup",
               "Get-CGPProfilingGroup",
               "Get-CGPFindingsReportAccountSummary",
               "Get-CGPNotificationConfiguration",
               "Get-CGPPolicy",
               "Get-CGPProfile",
               "Get-CGPRecommendation",
               "Get-CGPFindingsReportList",
               "Get-CGPProfileTimeList",
               "Get-CGPProfilingGroupList",
               "Get-CGPResourceTag",
               "Send-CGPAgentProfile",
               "Write-CGPPermission",
               "Remove-CGPNotificationChannel",
               "Remove-CGPPermission",
               "Submit-CGPFeedback",
               "Add-CGPResourceTag",
               "Remove-CGPResourceTag",
               "Update-CGPProfilingGroup")
}

_awsArgumentCompleterRegistration $CGP_SelectCompleters $CGP_SelectMap
# Argument completions for service Amazon CodeGuru Security


$CGS_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CodeGuruSecurity.AnalysisType
        "New-CGSScan/AnalysisType"
        {
            $v = "All","Security"
            break
        }

        # Amazon.CodeGuruSecurity.ScanType
        "New-CGSScan/ScanType"
        {
            $v = "Express","Standard"
            break
        }

        # Amazon.CodeGuruSecurity.Status
        "Get-CGSFinding/Status"
        {
            $v = "All","Closed","Open"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CGS_map = @{
    "AnalysisType"=@("New-CGSScan")
    "ScanType"=@("New-CGSScan")
    "Status"=@("Get-CGSFinding")
}

_awsArgumentCompleterRegistration $CGS_Completers $CGS_map

$CGS_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CGS.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CGS_SelectMap = @{
    "Select"=@("Get-CGSGetFinding",
               "New-CGSScan",
               "New-CGSUploadUrl",
               "Get-CGSAccountConfiguration",
               "Get-CGSFinding",
               "Get-CGSMetricsSummary",
               "Get-CGSScan",
               "Get-CGSFindingsMetricList",
               "Get-CGSScanList",
               "Get-CGSResourceTag",
               "Add-CGSResourceTag",
               "Remove-CGSResourceTag",
               "Update-CGSAccountConfiguration")
}

_awsArgumentCompleterRegistration $CGS_SelectCompleters $CGS_SelectMap
# Argument completions for service AWS CodePipeline


$CP_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CodePipeline.ActionCategory
        {
            ($_ -eq "Get-CPActionableJobList/ActionTypeId_Category") -Or
            ($_ -eq "Get-CPActionableThirdPartyJobList/ActionTypeId_Category") -Or
            ($_ -eq "Get-CPActionTypeDeclaration/Category") -Or
            ($_ -eq "New-CPCustomActionType/Category") -Or
            ($_ -eq "Remove-CPCustomActionType/Category") -Or
            ($_ -eq "Update-CPActionType/Id_Category")
        }
        {
            $v = "Approval","Build","Compute","Deploy","Invoke","Source","Test"
            break
        }

        # Amazon.CodePipeline.ActionOwner
        {
            ($_ -eq "Get-CPActionType/ActionOwnerFilter") -Or
            ($_ -eq "Get-CPActionableJobList/ActionTypeId_Owner") -Or
            ($_ -eq "Get-CPActionableThirdPartyJobList/ActionTypeId_Owner")
        }
        {
            $v = "AWS","Custom","ThirdParty"
            break
        }

        # Amazon.CodePipeline.ApprovalStatus
        "Write-CPApprovalResult/Result_Status"
        {
            $v = "Approved","Rejected"
            break
        }

        # Amazon.CodePipeline.ConditionType
        "Skip-CPStageCondition/ConditionType"
        {
            $v = "BEFORE_ENTRY","ON_SUCCESS"
            break
        }

        # Amazon.CodePipeline.ExecutorType
        "Update-CPActionType/Executor_Type"
        {
            $v = "JobWorker","Lambda"
            break
        }

        # Amazon.CodePipeline.FailureType
        {
            ($_ -eq "Write-CPJobFailureResult/FailureDetails_Type") -Or
            ($_ -eq "Write-CPThirdPartyJobFailureResult/FailureDetails_Type")
        }
        {
            $v = "ConfigurationError","JobFailed","PermissionError","RevisionOutOfSync","RevisionUnavailable","SystemUnavailable"
            break
        }

        # Amazon.CodePipeline.RuleOwner
        "Get-CPRuleTypeList/RuleOwnerFilter"
        {
            $v = "AWS"
            break
        }

        # Amazon.CodePipeline.StageRetryMode
        "Redo-CPStageExecution/RetryMode"
        {
            $v = "ALL_ACTIONS","FAILED_ACTIONS"
            break
        }

        # Amazon.CodePipeline.StageTransitionType
        {
            ($_ -eq "Disable-CPStageTransition/TransitionType") -Or
            ($_ -eq "Enable-CPStageTransition/TransitionType")
        }
        {
            $v = "Inbound","Outbound"
            break
        }

        # Amazon.CodePipeline.StartTimeRange
        {
            ($_ -eq "Get-CPActionExecutionList/LatestInPipelineExecution_StartTimeRange") -Or
            ($_ -eq "Get-CPRuleExecutionList/LatestInPipelineExecution_StartTimeRange")
        }
        {
            $v = "All","Latest"
            break
        }

        # Amazon.CodePipeline.WebhookAuthenticationType
        "Write-CPWebhook/Webhook_Authentication"
        {
            $v = "GITHUB_HMAC","IP","UNAUTHENTICATED"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CP_map = @{
    "ActionOwnerFilter"=@("Get-CPActionType")
    "ActionTypeId_Category"=@("Get-CPActionableJobList","Get-CPActionableThirdPartyJobList")
    "ActionTypeId_Owner"=@("Get-CPActionableJobList","Get-CPActionableThirdPartyJobList")
    "Category"=@("Get-CPActionTypeDeclaration","New-CPCustomActionType","Remove-CPCustomActionType")
    "ConditionType"=@("Skip-CPStageCondition")
    "Executor_Type"=@("Update-CPActionType")
    "FailureDetails_Type"=@("Write-CPJobFailureResult","Write-CPThirdPartyJobFailureResult")
    "Id_Category"=@("Update-CPActionType")
    "LatestInPipelineExecution_StartTimeRange"=@("Get-CPActionExecutionList","Get-CPRuleExecutionList")
    "Result_Status"=@("Write-CPApprovalResult")
    "RetryMode"=@("Redo-CPStageExecution")
    "RuleOwnerFilter"=@("Get-CPRuleTypeList")
    "TransitionType"=@("Disable-CPStageTransition","Enable-CPStageTransition")
    "Webhook_Authentication"=@("Write-CPWebhook")
}

_awsArgumentCompleterRegistration $CP_Completers $CP_map

$CP_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CP.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CP_SelectMap = @{
    "Select"=@("Confirm-CPJob",
               "Confirm-CPThirdPartyJob",
               "New-CPCustomActionType",
               "New-CPPipeline",
               "Remove-CPCustomActionType",
               "Remove-CPPipeline",
               "Remove-CPWebhook",
               "Unregister-CPWebhookWithThirdParty",
               "Disable-CPStageTransition",
               "Enable-CPStageTransition",
               "Get-CPActionTypeDeclaration",
               "Get-CPJobDetail",
               "Get-CPPipeline",
               "Get-CPPipelineExecution",
               "Get-CPPipelineState",
               "Get-CPThirdPartyJobDetail",
               "Get-CPActionExecutionList",
               "Get-CPActionType",
               "Get-CPDeployActionExecutionTargetList",
               "Get-CPPipelineExecutionSummary",
               "Get-CPPipelineList",
               "Get-CPRuleExecutionList",
               "Get-CPRuleTypeList",
               "Get-CPResourceTag",
               "Get-CPWebhookList",
               "Skip-CPStageCondition",
               "Get-CPActionableJobList",
               "Get-CPActionableThirdPartyJobList",
               "Write-CPActionRevision",
               "Write-CPApprovalResult",
               "Write-CPJobFailureResult",
               "Write-CPJobSuccessResult",
               "Write-CPThirdPartyJobFailureResult",
               "Write-CPThirdPartyJobSuccessResult",
               "Write-CPWebhook",
               "Register-CPWebhookWithThirdParty",
               "Redo-CPStageExecution",
               "Undo-CPStageExecution",
               "Start-CPPipelineExecution",
               "Stop-CPPipelineExecution",
               "Add-CPResourceTag",
               "Remove-CPResourceTag",
               "Update-CPActionType",
               "Update-CPPipeline")
}

_awsArgumentCompleterRegistration $CP_SelectCompleters $CP_SelectMap
# Argument completions for service AWS CodeStar Connections


$CSTC_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CodeStarconnections.ProviderType
        {
            ($_ -eq "New-CSTCConnection/ProviderType") -Or
            ($_ -eq "New-CSTCHost/ProviderType") -Or
            ($_ -eq "Get-CSTCConnectionList/ProviderTypeFilter")
        }
        {
            $v = "Bitbucket","GitHub","GitHubEnterpriseServer","GitLab","GitLabSelfManaged"
            break
        }

        # Amazon.CodeStarconnections.PublishDeploymentStatus
        {
            ($_ -eq "New-CSTCSyncConfiguration/PublishDeploymentStatus") -Or
            ($_ -eq "Update-CSTCSyncConfiguration/PublishDeploymentStatus")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.CodeStarconnections.SyncConfigurationType
        {
            ($_ -eq "Get-CSTCRepositorySyncDefinitionList/SyncType") -Or
            ($_ -eq "Get-CSTCRepositorySyncStatus/SyncType") -Or
            ($_ -eq "Get-CSTCResourceSyncStatus/SyncType") -Or
            ($_ -eq "Get-CSTCSyncBlockerSummary/SyncType") -Or
            ($_ -eq "Get-CSTCSyncConfiguration/SyncType") -Or
            ($_ -eq "Get-CSTCSyncConfigurationList/SyncType") -Or
            ($_ -eq "New-CSTCSyncConfiguration/SyncType") -Or
            ($_ -eq "Remove-CSTCSyncConfiguration/SyncType") -Or
            ($_ -eq "Update-CSTCSyncBlocker/SyncType") -Or
            ($_ -eq "Update-CSTCSyncConfiguration/SyncType")
        }
        {
            $v = "CFN_STACK_SYNC"
            break
        }

        # Amazon.CodeStarconnections.TriggerResourceUpdateOn
        {
            ($_ -eq "New-CSTCSyncConfiguration/TriggerResourceUpdateOn") -Or
            ($_ -eq "Update-CSTCSyncConfiguration/TriggerResourceUpdateOn")
        }
        {
            $v = "ANY_CHANGE","FILE_CHANGE"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CSTC_map = @{
    "ProviderType"=@("New-CSTCConnection","New-CSTCHost")
    "ProviderTypeFilter"=@("Get-CSTCConnectionList")
    "PublishDeploymentStatus"=@("New-CSTCSyncConfiguration","Update-CSTCSyncConfiguration")
    "SyncType"=@("Get-CSTCRepositorySyncDefinitionList","Get-CSTCRepositorySyncStatus","Get-CSTCResourceSyncStatus","Get-CSTCSyncBlockerSummary","Get-CSTCSyncConfiguration","Get-CSTCSyncConfigurationList","New-CSTCSyncConfiguration","Remove-CSTCSyncConfiguration","Update-CSTCSyncBlocker","Update-CSTCSyncConfiguration")
    "TriggerResourceUpdateOn"=@("New-CSTCSyncConfiguration","Update-CSTCSyncConfiguration")
}

_awsArgumentCompleterRegistration $CSTC_Completers $CSTC_map

$CSTC_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CSTC.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CSTC_SelectMap = @{
    "Select"=@("New-CSTCConnection",
               "New-CSTCHost",
               "New-CSTCRepositoryLink",
               "New-CSTCSyncConfiguration",
               "Remove-CSTCConnection",
               "Remove-CSTCHost",
               "Remove-CSTCRepositoryLink",
               "Remove-CSTCSyncConfiguration",
               "Get-CSTCConnection",
               "Get-CSTCHost",
               "Get-CSTCRepositoryLink",
               "Get-CSTCRepositorySyncStatus",
               "Get-CSTCResourceSyncStatus",
               "Get-CSTCSyncBlockerSummary",
               "Get-CSTCSyncConfiguration",
               "Get-CSTCConnectionList",
               "Get-CSTCHostList",
               "Get-CSTCRepositoryLinkList",
               "Get-CSTCRepositorySyncDefinitionList",
               "Get-CSTCSyncConfigurationList",
               "Get-CSTCResourceTagList",
               "Add-CSTCResourceTag",
               "Remove-CSTCResourceTag",
               "Update-CSTCHost",
               "Update-CSTCRepositoryLink",
               "Update-CSTCSyncBlocker",
               "Update-CSTCSyncConfiguration")
}

_awsArgumentCompleterRegistration $CSTC_SelectCompleters $CSTC_SelectMap
# Argument completions for service AWS CodeStar Notifications


$CSTN_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CodeStarNotifications.DetailType
        {
            ($_ -eq "New-CSTNNotificationRule/DetailType") -Or
            ($_ -eq "Update-CSTNNotificationRule/DetailType")
        }
        {
            $v = "BASIC","FULL"
            break
        }

        # Amazon.CodeStarNotifications.NotificationRuleStatus
        {
            ($_ -eq "New-CSTNNotificationRule/Status") -Or
            ($_ -eq "Update-CSTNNotificationRule/Status")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CSTN_map = @{
    "DetailType"=@("New-CSTNNotificationRule","Update-CSTNNotificationRule")
    "Status"=@("New-CSTNNotificationRule","Update-CSTNNotificationRule")
}

_awsArgumentCompleterRegistration $CSTN_Completers $CSTN_map

$CSTN_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CSTN.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CSTN_SelectMap = @{
    "Select"=@("New-CSTNNotificationRule",
               "Remove-CSTNNotificationRule",
               "Remove-CSTNTarget",
               "Get-CSTNNotificationRule",
               "Get-CSTNEventTypeList",
               "Get-CSTNNotificationRuleList",
               "Get-CSTNResourceTag",
               "Get-CSTNTargetList",
               "Add-CSTNSubscription",
               "Add-CSTNResourceTag",
               "Remove-CSTNSubscription",
               "Remove-CSTNResourceTag",
               "Update-CSTNNotificationRule")
}

_awsArgumentCompleterRegistration $CSTN_SelectCompleters $CSTN_SelectMap
# Argument completions for service Amazon Cognito Identity


$CGI_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CGI.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CGI_SelectMap = @{
    "Select"=@("New-CGIIdentityPool",
               "Remove-CGIIdentity",
               "Remove-CGIIdentityPool",
               "Get-CGIIdentity",
               "Get-CGIIdentityPool",
               "Get-CGICredentialsForIdentity",
               "Get-CGIId",
               "Get-CGIIdentityPoolRole",
               "Get-CGIOpenIdToken",
               "Get-CGIOpenIdTokenForDeveloperIdentity",
               "Get-CGIPrincipalTagAttributeMap",
               "Get-CGIIdentityList",
               "Get-CGIIdentityPoolList",
               "Get-CGIResourceTag",
               "Find-CGIDeveloperIdentity",
               "Merge-CGIDeveloperIdentity",
               "Set-CGIIdentityPoolRole",
               "Set-CGIPrincipalTagAttributeMap",
               "Add-CGIResourceTag",
               "Dismount-CGIDeveloperIdentity",
               "Dismount-CGIIdentity",
               "Remove-CGIResourceTag",
               "Update-CGIIdentityPool")
}

_awsArgumentCompleterRegistration $CGI_SelectCompleters $CGI_SelectMap
# Argument completions for service Amazon Cognito Identity Provider


$CGIP_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CognitoIdentityProvider.AccountTakeoverEventActionType
        {
            ($_ -eq "Set-CGIPRiskConfiguration/HighAction_EventAction") -Or
            ($_ -eq "Set-CGIPRiskConfiguration/LowAction_EventAction") -Or
            ($_ -eq "Set-CGIPRiskConfiguration/MediumAction_EventAction")
        }
        {
            $v = "BLOCK","MFA_IF_CONFIGURED","MFA_REQUIRED","NO_ACTION"
            break
        }

        # Amazon.CognitoIdentityProvider.AdvancedSecurityEnabledModeType
        {
            ($_ -eq "New-CGIPUserPool/AdvancedSecurityAdditionalFlows_CustomAuthMode") -Or
            ($_ -eq "Update-CGIPUserPool/AdvancedSecurityAdditionalFlows_CustomAuthMode")
        }
        {
            $v = "AUDIT","ENFORCED"
            break
        }

        # Amazon.CognitoIdentityProvider.AdvancedSecurityModeType
        {
            ($_ -eq "New-CGIPUserPool/UserPoolAddOns_AdvancedSecurityMode") -Or
            ($_ -eq "Update-CGIPUserPool/UserPoolAddOns_AdvancedSecurityMode")
        }
        {
            $v = "AUDIT","ENFORCED","OFF"
            break
        }

        # Amazon.CognitoIdentityProvider.AuthFlowType
        {
            ($_ -eq "Start-CGIPAuth/AuthFlow") -Or
            ($_ -eq "Start-CGIPAuthAdmin/AuthFlow")
        }
        {
            $v = "ADMIN_NO_SRP_AUTH","ADMIN_USER_PASSWORD_AUTH","CUSTOM_AUTH","REFRESH_TOKEN","REFRESH_TOKEN_AUTH","USER_AUTH","USER_PASSWORD_AUTH","USER_SRP_AUTH"
            break
        }

        # Amazon.CognitoIdentityProvider.ChallengeNameType
        {
            ($_ -eq "Send-CGIPAuthChallengeResponse/ChallengeName") -Or
            ($_ -eq "Send-CGIPAuthChallengeResponseAdmin/ChallengeName")
        }
        {
            $v = "ADMIN_NO_SRP_AUTH","CUSTOM_CHALLENGE","DEVICE_PASSWORD_VERIFIER","DEVICE_SRP_AUTH","EMAIL_OTP","MFA_SETUP","NEW_PASSWORD_REQUIRED","PASSWORD","PASSWORD_SRP","PASSWORD_VERIFIER","SELECT_CHALLENGE","SELECT_MFA_TYPE","SMS_MFA","SMS_OTP","SOFTWARE_TOKEN_MFA","WEB_AUTHN"
            break
        }

        # Amazon.CognitoIdentityProvider.CompromisedCredentialsEventActionType
        "Set-CGIPRiskConfiguration/Actions_EventAction"
        {
            $v = "BLOCK","NO_ACTION"
            break
        }

        # Amazon.CognitoIdentityProvider.CustomEmailSenderLambdaVersionType
        {
            ($_ -eq "New-CGIPUserPool/CustomEmailSender_LambdaVersion") -Or
            ($_ -eq "Update-CGIPUserPool/CustomEmailSender_LambdaVersion")
        }
        {
            $v = "V1_0"
            break
        }

        # Amazon.CognitoIdentityProvider.CustomSMSSenderLambdaVersionType
        {
            ($_ -eq "New-CGIPUserPool/CustomSMSSender_LambdaVersion") -Or
            ($_ -eq "Update-CGIPUserPool/CustomSMSSender_LambdaVersion")
        }
        {
            $v = "V1_0"
            break
        }

        # Amazon.CognitoIdentityProvider.DefaultEmailOptionType
        {
            ($_ -eq "New-CGIPUserPool/VerificationMessageTemplate_DefaultEmailOption") -Or
            ($_ -eq "Update-CGIPUserPool/VerificationMessageTemplate_DefaultEmailOption")
        }
        {
            $v = "CONFIRM_WITH_CODE","CONFIRM_WITH_LINK"
            break
        }

        # Amazon.CognitoIdentityProvider.DeletionProtectionType
        {
            ($_ -eq "New-CGIPUserPool/DeletionProtection") -Or
            ($_ -eq "Update-CGIPUserPool/DeletionProtection")
        }
        {
            $v = "ACTIVE","INACTIVE"
            break
        }

        # Amazon.CognitoIdentityProvider.DeviceRememberedStatusType
        {
            ($_ -eq "Edit-CGIPDeviceStatus/DeviceRememberedStatus") -Or
            ($_ -eq "Edit-CGIPDeviceStatusAdmin/DeviceRememberedStatus")
        }
        {
            $v = "not_remembered","remembered"
            break
        }

        # Amazon.CognitoIdentityProvider.EmailSendingAccountType
        {
            ($_ -eq "New-CGIPUserPool/EmailConfiguration_EmailSendingAccount") -Or
            ($_ -eq "Update-CGIPUserPool/EmailConfiguration_EmailSendingAccount")
        }
        {
            $v = "COGNITO_DEFAULT","DEVELOPER"
            break
        }

        # Amazon.CognitoIdentityProvider.FeatureType
        {
            ($_ -eq "New-CGIPUserPoolClient/RefreshTokenRotation_Feature") -Or
            ($_ -eq "Update-CGIPUserPoolClient/RefreshTokenRotation_Feature")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.CognitoIdentityProvider.FeedbackValueType
        {
            ($_ -eq "Update-CGIPAuthEventFeedback/FeedbackValue") -Or
            ($_ -eq "Update-CGIPAuthEventFeedbackAdmin/FeedbackValue")
        }
        {
            $v = "Invalid","Valid"
            break
        }

        # Amazon.CognitoIdentityProvider.IdentityProviderTypeType
        "New-CGIPIdentityProvider/ProviderType"
        {
            $v = "Facebook","Google","LoginWithAmazon","OIDC","SAML","SignInWithApple"
            break
        }

        # Amazon.CognitoIdentityProvider.MessageActionType
        "New-CGIPUserAdmin/MessageAction"
        {
            $v = "RESEND","SUPPRESS"
            break
        }

        # Amazon.CognitoIdentityProvider.PreTokenGenerationLambdaVersionType
        {
            ($_ -eq "New-CGIPUserPool/PreTokenGenerationConfig_LambdaVersion") -Or
            ($_ -eq "Update-CGIPUserPool/PreTokenGenerationConfig_LambdaVersion")
        }
        {
            $v = "V1_0","V2_0","V3_0"
            break
        }

        # Amazon.CognitoIdentityProvider.PreventUserExistenceErrorTypes
        {
            ($_ -eq "New-CGIPUserPoolClient/PreventUserExistenceError") -Or
            ($_ -eq "Update-CGIPUserPoolClient/PreventUserExistenceError")
        }
        {
            $v = "ENABLED","LEGACY"
            break
        }

        # Amazon.CognitoIdentityProvider.TermsEnforcementType
        {
            ($_ -eq "New-CGIPTerm/Enforcement") -Or
            ($_ -eq "Update-CGIPTerm/Enforcement")
        }
        {
            $v = "NONE"
            break
        }

        # Amazon.CognitoIdentityProvider.TermsSourceType
        {
            ($_ -eq "New-CGIPTerm/TermsSource") -Or
            ($_ -eq "Update-CGIPTerm/TermsSource")
        }
        {
            $v = "LINK"
            break
        }

        # Amazon.CognitoIdentityProvider.TimeUnitsType
        {
            ($_ -eq "New-CGIPUserPoolClient/TokenValidityUnits_AccessToken") -Or
            ($_ -eq "Update-CGIPUserPoolClient/TokenValidityUnits_AccessToken") -Or
            ($_ -eq "New-CGIPUserPoolClient/TokenValidityUnits_IdToken") -Or
            ($_ -eq "Update-CGIPUserPoolClient/TokenValidityUnits_IdToken") -Or
            ($_ -eq "New-CGIPUserPoolClient/TokenValidityUnits_RefreshToken") -Or
            ($_ -eq "Update-CGIPUserPoolClient/TokenValidityUnits_RefreshToken")
        }
        {
            $v = "days","hours","minutes","seconds"
            break
        }

        # Amazon.CognitoIdentityProvider.UserPoolMfaType
        {
            ($_ -eq "New-CGIPUserPool/MfaConfiguration") -Or
            ($_ -eq "Set-CGIPUserPoolMfaConfig/MfaConfiguration") -Or
            ($_ -eq "Update-CGIPUserPool/MfaConfiguration")
        }
        {
            $v = "OFF","ON","OPTIONAL"
            break
        }

        # Amazon.CognitoIdentityProvider.UserPoolTierType
        {
            ($_ -eq "New-CGIPUserPool/UserPoolTier") -Or
            ($_ -eq "Update-CGIPUserPool/UserPoolTier")
        }
        {
            $v = "ESSENTIALS","LITE","PLUS"
            break
        }

        # Amazon.CognitoIdentityProvider.UserVerificationType
        "Set-CGIPUserPoolMfaConfig/WebAuthnConfiguration_UserVerification"
        {
            $v = "preferred","required"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CGIP_map = @{
    "Actions_EventAction"=@("Set-CGIPRiskConfiguration")
    "AdvancedSecurityAdditionalFlows_CustomAuthMode"=@("New-CGIPUserPool","Update-CGIPUserPool")
    "AuthFlow"=@("Start-CGIPAuth","Start-CGIPAuthAdmin")
    "ChallengeName"=@("Send-CGIPAuthChallengeResponse","Send-CGIPAuthChallengeResponseAdmin")
    "CustomEmailSender_LambdaVersion"=@("New-CGIPUserPool","Update-CGIPUserPool")
    "CustomSMSSender_LambdaVersion"=@("New-CGIPUserPool","Update-CGIPUserPool")
    "DeletionProtection"=@("New-CGIPUserPool","Update-CGIPUserPool")
    "DeviceRememberedStatus"=@("Edit-CGIPDeviceStatus","Edit-CGIPDeviceStatusAdmin")
    "EmailConfiguration_EmailSendingAccount"=@("New-CGIPUserPool","Update-CGIPUserPool")
    "Enforcement"=@("New-CGIPTerm","Update-CGIPTerm")
    "FeedbackValue"=@("Update-CGIPAuthEventFeedback","Update-CGIPAuthEventFeedbackAdmin")
    "HighAction_EventAction"=@("Set-CGIPRiskConfiguration")
    "LowAction_EventAction"=@("Set-CGIPRiskConfiguration")
    "MediumAction_EventAction"=@("Set-CGIPRiskConfiguration")
    "MessageAction"=@("New-CGIPUserAdmin")
    "MfaConfiguration"=@("New-CGIPUserPool","Set-CGIPUserPoolMfaConfig","Update-CGIPUserPool")
    "PreTokenGenerationConfig_LambdaVersion"=@("New-CGIPUserPool","Update-CGIPUserPool")
    "PreventUserExistenceError"=@("New-CGIPUserPoolClient","Update-CGIPUserPoolClient")
    "ProviderType"=@("New-CGIPIdentityProvider")
    "RefreshTokenRotation_Feature"=@("New-CGIPUserPoolClient","Update-CGIPUserPoolClient")
    "TermsSource"=@("New-CGIPTerm","Update-CGIPTerm")
    "TokenValidityUnits_AccessToken"=@("New-CGIPUserPoolClient","Update-CGIPUserPoolClient")
    "TokenValidityUnits_IdToken"=@("New-CGIPUserPoolClient","Update-CGIPUserPoolClient")
    "TokenValidityUnits_RefreshToken"=@("New-CGIPUserPoolClient","Update-CGIPUserPoolClient")
    "UserPoolAddOns_AdvancedSecurityMode"=@("New-CGIPUserPool","Update-CGIPUserPool")
    "UserPoolTier"=@("New-CGIPUserPool","Update-CGIPUserPool")
    "VerificationMessageTemplate_DefaultEmailOption"=@("New-CGIPUserPool","Update-CGIPUserPool")
    "WebAuthnConfiguration_UserVerification"=@("Set-CGIPUserPoolMfaConfig")
}

_awsArgumentCompleterRegistration $CGIP_Completers $CGIP_map

$CGIP_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CGIP.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CGIP_SelectMap = @{
    "Select"=@("Add-CGIPCustomAttribute",
               "Add-CGIPUserToGroupAdmin",
               "Confirm-CGIPUserRegistrationAdmin",
               "New-CGIPUserAdmin",
               "Remove-CGIPUserAdmin",
               "Remove-CGIPUserAttributeAdmin",
               "Disable-CGIPProviderForUserAdmin",
               "Disable-CGIPUserAdmin",
               "Enable-CGIPUserAdmin",
               "Stop-CGIPDeviceTrackingAdmin",
               "Get-CGIPDeviceAdmin",
               "Get-CGIPUserAdmin",
               "Start-CGIPAuthAdmin",
               "Connect-CGIPProviderForUserAdmin",
               "Get-CGIPDeviceListAdmin",
               "Get-CGIPGroupsForUserAdmin",
               "Get-CGIPUserAuthEventListAdmin",
               "Remove-CGIPUserFromGroupAdmin",
               "Reset-CGIPUserPasswordAdmin",
               "Send-CGIPAuthChallengeResponseAdmin",
               "Set-CGIPUserMFAPreferenceAdmin",
               "Set-CGIPUserPasswordAdmin",
               "Set-CGIPUserSettingAdmin",
               "Update-CGIPAuthEventFeedbackAdmin",
               "Edit-CGIPDeviceStatusAdmin",
               "Update-CGIPUserAttributeAdmin",
               "Disconnect-CGIPUserGlobalAdmin",
               "Add-CGIPSoftwareToken",
               "Update-CGIPPassword",
               "Complete-CGIPWebAuthnRegistration",
               "Approve-CGIPDevice",
               "Confirm-CGIPForgotPassword",
               "Confirm-CGIPUserRegistration",
               "New-CGIPGroup",
               "New-CGIPIdentityProvider",
               "New-CGIPManagedLoginBranding",
               "New-CGIPResourceServer",
               "New-CGIPTerm",
               "New-CGIPUserImportJob",
               "New-CGIPUserPool",
               "New-CGIPUserPoolClient",
               "New-CGIPUserPoolDomain",
               "Remove-CGIPGroup",
               "Remove-CGIPIdentityProvider",
               "Remove-CGIPManagedLoginBranding",
               "Remove-CGIPResourceServer",
               "Remove-CGIPTerm",
               "Remove-CGIPUser",
               "Remove-CGIPUserAttribute",
               "Remove-CGIPUserPool",
               "Remove-CGIPUserPoolClient",
               "Remove-CGIPUserPoolDomain",
               "Remove-CGIPWebAuthnCredential",
               "Get-CGIPIdentityProvider",
               "Get-CGIPManagedLoginBranding",
               "Get-CGIPManagedLoginBrandingByClient",
               "Get-CGIPResourceServer",
               "Get-CGIPRiskConfiguration",
               "Get-CGIPTerm",
               "Get-CGIPUserImportJob",
               "Get-CGIPUserPool",
               "Get-CGIPUserPoolClient",
               "Get-CGIPUserPoolDomain",
               "Stop-CGIPDeviceTracking",
               "Reset-CGIPForgottenPassword",
               "Get-CGIPCSVHeader",
               "Get-CGIPDevice",
               "Get-CGIPGroup",
               "Get-CGIPIdentityProviderByIdentifier",
               "Get-CGIPLogDeliveryConfiguration",
               "Get-CGIPSigningCertificate",
               "Get-CGIPTokensFromRefreshToken",
               "Get-CGIPUICustomization",
               "Get-CGIPUser",
               "Get-CGIPUserAttributeVerificationCode",
               "Get-CGIPUserAuthFactor",
               "Get-CGIPUserPoolMfaConfig",
               "Disconnect-CGIPDeviceGlobal",
               "Start-CGIPAuth",
               "Get-CGIPDeviceList",
               "Get-CGIPGroupList",
               "Get-CGIPIdentityProviderList",
               "Get-CGIPResourceServerList",
               "Get-CGIPResourceTag",
               "Get-CGIPTermList",
               "Get-CGIPUserImportJobList",
               "Get-CGIPUserPoolClientList",
               "Get-CGIPUserPoolList",
               "Get-CGIPUserList",
               "Get-CGIPUsersInGroup",
               "Get-CGIPWebAuthnCredentialList",
               "Send-CGIPConfirmationCode",
               "Send-CGIPAuthChallengeResponse",
               "Revoke-CGIPToken",
               "Set-CGIPLogDeliveryConfiguration",
               "Set-CGIPRiskConfiguration",
               "Set-CGIPUICustomization",
               "Set-CGIPUserMFAPreference",
               "Set-CGIPUserPoolMfaConfig",
               "Set-CGIPUserSetting",
               "Register-CGIPUserInPool",
               "Start-CGIPUserImportJob",
               "Start-CGIPWebAuthnRegistration",
               "Stop-CGIPUserImportJob",
               "Add-CGIPResourceTag",
               "Remove-CGIPResourceTag",
               "Update-CGIPAuthEventFeedback",
               "Edit-CGIPDeviceStatus",
               "Update-CGIPGroup",
               "Update-CGIPIdentityProvider",
               "Update-CGIPManagedLoginBranding",
               "Update-CGIPResourceServer",
               "Update-CGIPTerm",
               "Update-CGIPUserAttribute",
               "Update-CGIPUserPool",
               "Update-CGIPUserPoolClient",
               "Update-CGIPUserPoolDomain",
               "Test-CGIPSoftwareToken",
               "Test-CGIPUserAttribute")
}

_awsArgumentCompleterRegistration $CGIP_SelectCompleters $CGIP_SelectMap
# Argument completions for service Amazon Cognito Sync


$CGIS_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CognitoSync.Platform
        "Register-CGISDevice/Platform"
        {
            $v = "ADM","APNS","APNS_SANDBOX","GCM"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CGIS_map = @{
    "Platform"=@("Register-CGISDevice")
}

_awsArgumentCompleterRegistration $CGIS_Completers $CGIS_map

$CGIS_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CGIS.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CGIS_SelectMap = @{
    "Select"=@("Publish-CGISBulkDataset",
               "Remove-CGISDataset",
               "Get-CGISDataset",
               "Get-CGISIdentityPoolUsage",
               "Get-CGISIdentityUsage",
               "Get-CGISBulkPublishDetail",
               "Get-CGISCognitoEvent",
               "Get-CGISIdentityPoolConfiguration",
               "Get-CGISDatasetList",
               "Get-CGISIdentityPoolUsageList",
               "Get-CGISRecordList",
               "Register-CGISDevice",
               "Set-CGISCognitoEventLambdaFunction",
               "Set-CGISIdentityPoolConfiguration",
               "Add-CGISDatasetSubscription",
               "Remove-CGISDatasetSubscription",
               "Update-CGISRecord")
}

_awsArgumentCompleterRegistration $CGIS_SelectCompleters $CGIS_SelectMap
# Argument completions for service Amazon Comprehend


$COMP_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.Comprehend.DatasetDataFormat
        "New-COMPDataset/InputDataConfig_DataFormat"
        {
            $v = "AUGMENTED_MANIFEST","COMPREHEND_CSV"
            break
        }

        # Amazon.Comprehend.DatasetStatus
        "Get-COMPDatasetList/Filter_Status"
        {
            $v = "COMPLETED","CREATING","FAILED"
            break
        }

        # Amazon.Comprehend.DatasetType
        {
            ($_ -eq "New-COMPDataset/DatasetType") -Or
            ($_ -eq "Get-COMPDatasetList/Filter_DatasetType")
        }
        {
            $v = "TEST","TRAIN"
            break
        }

        # Amazon.Comprehend.DocumentClassifierDataFormat
        "New-COMPDocumentClassifier/InputDataConfig_DataFormat"
        {
            $v = "AUGMENTED_MANIFEST","COMPREHEND_CSV"
            break
        }

        # Amazon.Comprehend.DocumentClassifierDocumentTypeFormat
        "New-COMPDocumentClassifier/InputDataConfig_DocumentType"
        {
            $v = "PLAIN_TEXT_DOCUMENT","SEMI_STRUCTURED_DOCUMENT"
            break
        }

        # Amazon.Comprehend.DocumentClassifierMode
        {
            ($_ -eq "New-COMPFlywheel/DocumentClassificationConfig_Mode") -Or
            ($_ -eq "New-COMPDocumentClassifier/Mode")
        }
        {
            $v = "MULTI_CLASS","MULTI_LABEL"
            break
        }

        # Amazon.Comprehend.DocumentReadAction
        {
            ($_ -eq "Find-COMPEntity/DocumentReaderConfig_DocumentReadAction") -Or
            ($_ -eq "Invoke-COMPDocumentClassification/DocumentReaderConfig_DocumentReadAction") -Or
            ($_ -eq "New-COMPDocumentClassifier/DocumentReaderConfig_DocumentReadAction")
        }
        {
            $v = "TEXTRACT_ANALYZE_DOCUMENT","TEXTRACT_DETECT_DOCUMENT_TEXT"
            break
        }

        # Amazon.Comprehend.DocumentReadMode
        {
            ($_ -eq "Find-COMPEntity/DocumentReaderConfig_DocumentReadMode") -Or
            ($_ -eq "Invoke-COMPDocumentClassification/DocumentReaderConfig_DocumentReadMode") -Or
            ($_ -eq "New-COMPDocumentClassifier/DocumentReaderConfig_DocumentReadMode")
        }
        {
            $v = "FORCE_DOCUMENT_READ_ACTION","SERVICE_DEFAULT"
            break
        }

        # Amazon.Comprehend.EndpointStatus
        "Get-COMPEndpointList/Filter_Status"
        {
            $v = "CREATING","DELETING","FAILED","IN_SERVICE","UPDATING"
            break
        }

        # Amazon.Comprehend.EntityRecognizerDataFormat
        "New-COMPEntityRecognizer/InputDataConfig_DataFormat"
        {
            $v = "AUGMENTED_MANIFEST","COMPREHEND_CSV"
            break
        }

        # Amazon.Comprehend.FlywheelStatus
        "Get-COMPFlywheelList/Filter_Status"
        {
            $v = "ACTIVE","CREATING","DELETING","FAILED","UPDATING"
            break
        }

        # Amazon.Comprehend.InputFormat
        {
            ($_ -eq "New-COMPDataset/Documents_InputFormat") -Or
            ($_ -eq "New-COMPEntityRecognizer/Documents_InputFormat")
        }
        {
            $v = "ONE_DOC_PER_FILE","ONE_DOC_PER_LINE"
            break
        }

        # Amazon.Comprehend.JobStatus
        {
            ($_ -eq "Get-COMPDocumentClassificationJobList/Filter_JobStatus") -Or
            ($_ -eq "Get-COMPEventsDetectionJobList/Filter_JobStatus") -Or
            ($_ -eq "Get-COMPTargetedSentimentDetectionJobList/Filter_JobStatus")
        }
        {
            $v = "COMPLETED","FAILED","IN_PROGRESS","STOPPED","STOP_REQUESTED","SUBMITTED"
            break
        }

        # Amazon.Comprehend.LanguageCode
        {
            ($_ -eq "Find-COMPEntity/LanguageCode") -Or
            ($_ -eq "Find-COMPEntityBatch/LanguageCode") -Or
            ($_ -eq "Find-COMPKeyPhrase/LanguageCode") -Or
            ($_ -eq "Find-COMPKeyPhrasesBatch/LanguageCode") -Or
            ($_ -eq "Find-COMPPiiEntity/LanguageCode") -Or
            ($_ -eq "Find-COMPPiiEntityType/LanguageCode") -Or
            ($_ -eq "Find-COMPSentiment/LanguageCode") -Or
            ($_ -eq "Find-COMPSentimentBatch/LanguageCode") -Or
            ($_ -eq "Find-COMPTargetedSentiment/LanguageCode") -Or
            ($_ -eq "Find-COMPTargetedSentimentBatch/LanguageCode") -Or
            ($_ -eq "Find-COMPToxicContent/LanguageCode") -Or
            ($_ -eq "New-COMPDocumentClassifier/LanguageCode") -Or
            ($_ -eq "New-COMPEntityRecognizer/LanguageCode") -Or
            ($_ -eq "Start-COMPEntitiesDetectionJob/LanguageCode") -Or
            ($_ -eq "Start-COMPEventsDetectionJob/LanguageCode") -Or
            ($_ -eq "Start-COMPKeyPhrasesDetectionJob/LanguageCode") -Or
            ($_ -eq "Start-COMPPiiEntitiesDetectionJob/LanguageCode") -Or
            ($_ -eq "Start-COMPSentimentDetectionJob/LanguageCode") -Or
            ($_ -eq "Start-COMPTargetedSentimentDetectionJob/LanguageCode") -Or
            ($_ -eq "New-COMPFlywheel/TaskConfig_LanguageCode")
        }
        {
            $v = "ar","de","en","es","fr","hi","it","ja","ko","pt","zh","zh-TW"
            break
        }

        # Amazon.Comprehend.ModelStatus
        {
            ($_ -eq "Get-COMPDocumentClassifierList/Filter_Status") -Or
            ($_ -eq "Get-COMPEntityRecognizerList/Filter_Status")
        }
        {
            $v = "DELETING","IN_ERROR","STOPPED","STOP_REQUESTED","SUBMITTED","TRAINED","TRAINED_WITH_WARNING","TRAINING"
            break
        }

        # Amazon.Comprehend.ModelType
        "New-COMPFlywheel/ModelType"
        {
            $v = "DOCUMENT_CLASSIFIER","ENTITY_RECOGNIZER"
            break
        }

        # Amazon.Comprehend.PiiEntitiesDetectionMaskMode
        "Start-COMPPiiEntitiesDetectionJob/RedactionConfig_MaskMode"
        {
            $v = "MASK","REPLACE_WITH_PII_ENTITY_TYPE"
            break
        }

        # Amazon.Comprehend.PiiEntitiesDetectionMode
        "Start-COMPPiiEntitiesDetectionJob/Mode"
        {
            $v = "ONLY_OFFSETS","ONLY_REDACTION"
            break
        }

        # Amazon.Comprehend.SyntaxLanguageCode
        {
            ($_ -eq "Find-COMPSyntax/LanguageCode") -Or
            ($_ -eq "Find-COMPSyntaxBatch/LanguageCode")
        }
        {
            $v = "de","en","es","fr","it","pt"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$COMP_map = @{
    "DatasetType"=@("New-COMPDataset")
    "DocumentClassificationConfig_Mode"=@("New-COMPFlywheel")
    "DocumentReaderConfig_DocumentReadAction"=@("Find-COMPEntity","Invoke-COMPDocumentClassification","New-COMPDocumentClassifier")
    "DocumentReaderConfig_DocumentReadMode"=@("Find-COMPEntity","Invoke-COMPDocumentClassification","New-COMPDocumentClassifier")
    "Documents_InputFormat"=@("New-COMPDataset","New-COMPEntityRecognizer")
    "Filter_DatasetType"=@("Get-COMPDatasetList")
    "Filter_JobStatus"=@("Get-COMPDocumentClassificationJobList","Get-COMPEventsDetectionJobList","Get-COMPTargetedSentimentDetectionJobList")
    "Filter_Status"=@("Get-COMPDatasetList","Get-COMPDocumentClassifierList","Get-COMPEndpointList","Get-COMPEntityRecognizerList","Get-COMPFlywheelList")
    "InputDataConfig_DataFormat"=@("New-COMPDataset","New-COMPDocumentClassifier","New-COMPEntityRecognizer")
    "InputDataConfig_DocumentType"=@("New-COMPDocumentClassifier")
    "LanguageCode"=@("Find-COMPEntity","Find-COMPEntityBatch","Find-COMPKeyPhrase","Find-COMPKeyPhrasesBatch","Find-COMPPiiEntity","Find-COMPPiiEntityType","Find-COMPSentiment","Find-COMPSentimentBatch","Find-COMPSyntax","Find-COMPSyntaxBatch","Find-COMPTargetedSentiment","Find-COMPTargetedSentimentBatch","Find-COMPToxicContent","New-COMPDocumentClassifier","New-COMPEntityRecognizer","Start-COMPEntitiesDetectionJob","Start-COMPEventsDetectionJob","Start-COMPKeyPhrasesDetectionJob","Start-COMPPiiEntitiesDetectionJob","Start-COMPSentimentDetectionJob","Start-COMPTargetedSentimentDetectionJob")
    "Mode"=@("New-COMPDocumentClassifier","Start-COMPPiiEntitiesDetectionJob")
    "ModelType"=@("New-COMPFlywheel")
    "RedactionConfig_MaskMode"=@("Start-COMPPiiEntitiesDetectionJob")
    "TaskConfig_LanguageCode"=@("New-COMPFlywheel")
}

_awsArgumentCompleterRegistration $COMP_Completers $COMP_map

$COMP_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.COMP.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$COMP_SelectMap = @{
    "Select"=@("Find-COMPDominantLanguageBatch",
               "Find-COMPEntityBatch",
               "Find-COMPKeyPhrasesBatch",
               "Find-COMPSentimentBatch",
               "Find-COMPSyntaxBatch",
               "Find-COMPTargetedSentimentBatch",
               "Invoke-COMPDocumentClassification",
               "Find-COMPPiiEntityType",
               "New-COMPDataset",
               "New-COMPDocumentClassifier",
               "New-COMPEndpoint",
               "New-COMPEntityRecognizer",
               "New-COMPFlywheel",
               "Remove-COMPDocumentClassifier",
               "Remove-COMPEndpoint",
               "Remove-COMPEntityRecognizer",
               "Remove-COMPFlywheel",
               "Remove-COMPResourcePolicy",
               "Get-COMPDataset",
               "Get-COMPDocumentClassificationJob",
               "Get-COMPDocumentClassifier",
               "Get-COMPDominantLanguageDetectionJob",
               "Get-COMPEndpoint",
               "Get-COMPEntitiesDetectionJob",
               "Get-COMPEntityRecognizer",
               "Get-COMPEventsDetectionJob",
               "Get-COMPFlywheel",
               "Get-COMPFlywheelIteration",
               "Get-COMPKeyPhrasesDetectionJob",
               "Get-COMPPiiEntitiesDetectionJob",
               "Get-COMPResourcePolicy",
               "Get-COMPSentimentDetectionJob",
               "Get-COMPTargetedSentimentDetectionJob",
               "Get-COMPTopicsDetectionJob",
               "Find-COMPDominantLanguage",
               "Find-COMPEntity",
               "Find-COMPKeyPhrase",
               "Find-COMPPiiEntity",
               "Find-COMPSentiment",
               "Find-COMPSyntax",
               "Find-COMPTargetedSentiment",
               "Find-COMPToxicContent",
               "Import-COMPModel",
               "Get-COMPDatasetList",
               "Get-COMPDocumentClassificationJobList",
               "Get-COMPDocumentClassifierList",
               "Get-COMPDocumentClassifierSummaryList",
               "Get-COMPDominantLanguageDetectionJobList",
               "Get-COMPEndpointList",
               "Get-COMPEntitiesDetectionJobList",
               "Get-COMPEntityRecognizerList",
               "Get-COMPEntityRecognizerSummaryList",
               "Get-COMPEventsDetectionJobList",
               "Get-COMPFlywheelIterationHistoryList",
               "Get-COMPFlywheelList",
               "Get-COMPKeyPhrasesDetectionJobList",
               "Get-COMPPiiEntitiesDetectionJobList",
               "Get-COMPSentimentDetectionJobList",
               "Get-COMPResourceTag",
               "Get-COMPTargetedSentimentDetectionJobList",
               "Get-COMPTopicsDetectionJobList",
               "Write-COMPResourcePolicy",
               "Start-COMPDocumentClassificationJob",
               "Start-COMPDominantLanguageDetectionJob",
               "Start-COMPEntitiesDetectionJob",
               "Start-COMPEventsDetectionJob",
               "Start-COMPFlywheelIteration",
               "Start-COMPKeyPhrasesDetectionJob",
               "Start-COMPPiiEntitiesDetectionJob",
               "Start-COMPSentimentDetectionJob",
               "Start-COMPTargetedSentimentDetectionJob",
               "Start-COMPTopicsDetectionJob",
               "Stop-COMPDominantLanguageDetectionJob",
               "Stop-COMPEntitiesDetectionJob",
               "Stop-COMPEventsDetectionJob",
               "Stop-COMPKeyPhrasesDetectionJob",
               "Stop-COMPPiiEntitiesDetectionJob",
               "Stop-COMPSentimentDetectionJob",
               "Stop-COMPTargetedSentimentDetectionJob",
               "Stop-COMPTrainingDocumentClassifier",
               "Stop-COMPTrainingEntityRecognizer",
               "Add-COMPResourceTag",
               "Remove-COMPResourceTag",
               "Update-COMPEndpoint",
               "Update-COMPFlywheel")
}

_awsArgumentCompleterRegistration $COMP_SelectCompleters $COMP_SelectMap
# Argument completions for service AWS Comprehend Medical


$CMPM_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ComprehendMedical.JobStatus
        {
            ($_ -eq "Get-CMPMEntitiesDetectionV2JobList/Filter_JobStatus") -Or
            ($_ -eq "Get-CMPMICD10CMInferenceJobList/Filter_JobStatus") -Or
            ($_ -eq "Get-CMPMPersonalHealthInformationDetectionJobList/Filter_JobStatus") -Or
            ($_ -eq "Get-CMPMRxNormInferenceJobList/Filter_JobStatus") -Or
            ($_ -eq "Get-CMPMSNOMEDCTInferenceJobList/Filter_JobStatus")
        }
        {
            $v = "COMPLETED","FAILED","IN_PROGRESS","PARTIAL_SUCCESS","STOPPED","STOP_REQUESTED","SUBMITTED"
            break
        }

        # Amazon.ComprehendMedical.LanguageCode
        {
            ($_ -eq "Start-CMPMEntitiesDetectionV2Job/LanguageCode") -Or
            ($_ -eq "Start-CMPMICD10CMInferenceJob/LanguageCode") -Or
            ($_ -eq "Start-CMPMPersonalHealthInformationDetectionJob/LanguageCode") -Or
            ($_ -eq "Start-CMPMRxNormInferenceJob/LanguageCode") -Or
            ($_ -eq "Start-CMPMSNOMEDCTInferenceJob/LanguageCode")
        }
        {
            $v = "en"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CMPM_map = @{
    "Filter_JobStatus"=@("Get-CMPMEntitiesDetectionV2JobList","Get-CMPMICD10CMInferenceJobList","Get-CMPMPersonalHealthInformationDetectionJobList","Get-CMPMRxNormInferenceJobList","Get-CMPMSNOMEDCTInferenceJobList")
    "LanguageCode"=@("Start-CMPMEntitiesDetectionV2Job","Start-CMPMICD10CMInferenceJob","Start-CMPMPersonalHealthInformationDetectionJob","Start-CMPMRxNormInferenceJob","Start-CMPMSNOMEDCTInferenceJob")
}

_awsArgumentCompleterRegistration $CMPM_Completers $CMPM_map

$CMPM_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CMPM.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CMPM_SelectMap = @{
    "Select"=@("Get-CMPMEntitiesDetectionV2Job",
               "Get-CMPMICD10CMInferenceJob",
               "Get-CMPMPersonalHealthInformationDetectionJob",
               "Get-CMPMRxNormInferenceJob",
               "Get-CMPMSNOMEDCTInferenceJob",
               "Find-CMPMMedicalEntity",
               "Find-CMPMMedicalEntityV2",
               "Find-CMPMPersonalHealthInformation",
               "Find-CMPMICD10CM",
               "Find-CMPMRxNorm",
               "Find-CMPMSNOMEDCT",
               "Get-CMPMEntitiesDetectionV2JobList",
               "Get-CMPMICD10CMInferenceJobList",
               "Get-CMPMPersonalHealthInformationDetectionJobList",
               "Get-CMPMRxNormInferenceJobList",
               "Get-CMPMSNOMEDCTInferenceJobList",
               "Start-CMPMEntitiesDetectionV2Job",
               "Start-CMPMICD10CMInferenceJob",
               "Start-CMPMPersonalHealthInformationDetectionJob",
               "Start-CMPMRxNormInferenceJob",
               "Start-CMPMSNOMEDCTInferenceJob",
               "Stop-CMPMEntitiesDetectionV2Job",
               "Stop-CMPMICD10CMInferenceJob",
               "Stop-CMPMPersonalHealthInformationDetectionJob",
               "Stop-CMPMRxNormInferenceJob",
               "Stop-CMPMSNOMEDCTInferenceJob")
}

_awsArgumentCompleterRegistration $CMPM_SelectCompleters $CMPM_SelectMap
# Argument completions for service AWS Compute Optimizer


$CO_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ComputeOptimizer.Dimension
        "Get-COIdleRecommendation/OrderBy_Dimension"
        {
            $v = "SavingsValue","SavingsValueAfterDiscount"
            break
        }

        # Amazon.ComputeOptimizer.EnhancedInfrastructureMetrics
        "Write-CORecommendationPreference/EnhancedInfrastructureMetric"
        {
            $v = "Active","Inactive"
            break
        }

        # Amazon.ComputeOptimizer.ExternalMetricsSource
        "Write-CORecommendationPreference/ExternalMetricsPreference_Source"
        {
            $v = "Datadog","Dynatrace","Instana","NewRelic"
            break
        }

        # Amazon.ComputeOptimizer.FileFormat
        {
            ($_ -eq "Export-COAutoScalingGroupRecommendation/FileFormat") -Or
            ($_ -eq "Export-COEBSVolumeRecommendation/FileFormat") -Or
            ($_ -eq "Export-COEC2InstanceRecommendation/FileFormat") -Or
            ($_ -eq "Export-COECSServiceRecommendation/FileFormat") -Or
            ($_ -eq "Export-COIdleRecommendation/FileFormat") -Or
            ($_ -eq "Export-COLambdaFunctionRecommendation/FileFormat") -Or
            ($_ -eq "Export-COLicenseRecommendation/FileFormat") -Or
            ($_ -eq "Export-CORDSDatabaseRecommendation/FileFormat")
        }
        {
            $v = "Csv"
            break
        }

        # Amazon.ComputeOptimizer.InferredWorkloadTypesPreference
        "Write-CORecommendationPreference/InferredWorkloadType"
        {
            $v = "Active","Inactive"
            break
        }

        # Amazon.ComputeOptimizer.LookBackPeriodPreference
        "Write-CORecommendationPreference/LookBackPeriod"
        {
            $v = "DAYS_14","DAYS_32","DAYS_93"
            break
        }

        # Amazon.ComputeOptimizer.MetricStatistic
        {
            ($_ -eq "Get-COEC2RecommendationProjectedMetric/Stat") -Or
            ($_ -eq "Get-COECSServiceRecommendationProjectedMetric/Stat") -Or
            ($_ -eq "Get-CORDSDatabaseRecommendationProjectedMetric/Stat")
        }
        {
            $v = "Average","Maximum"
            break
        }

        # Amazon.ComputeOptimizer.Order
        "Get-COIdleRecommendation/OrderBy_Order"
        {
            $v = "Asc","Desc"
            break
        }

        # Amazon.ComputeOptimizer.ResourceType
        {
            ($_ -eq "Get-CORecommendationPreference/ResourceType") -Or
            ($_ -eq "Remove-CORecommendationPreference/ResourceType") -Or
            ($_ -eq "Write-CORecommendationPreference/ResourceType")
        }
        {
            $v = "AuroraDBClusterStorage","AutoScalingGroup","EbsVolume","Ec2Instance","EcsService","Idle","LambdaFunction","License","NotApplicable","RdsDBInstance"
            break
        }

        # Amazon.ComputeOptimizer.SavingsEstimationMode
        "Write-CORecommendationPreference/SavingsEstimationMode"
        {
            $v = "AfterDiscounts","BeforeDiscounts"
            break
        }

        # Amazon.ComputeOptimizer.ScopeName
        {
            ($_ -eq "Get-CORecommendationPreference/Scope_Name") -Or
            ($_ -eq "Remove-CORecommendationPreference/Scope_Name") -Or
            ($_ -eq "Write-CORecommendationPreference/Scope_Name")
        }
        {
            $v = "AccountId","Organization","ResourceArn"
            break
        }

        # Amazon.ComputeOptimizer.Status
        "Update-COEnrollmentStatus/Status"
        {
            $v = "Active","Failed","Inactive","Pending"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CO_map = @{
    "EnhancedInfrastructureMetric"=@("Write-CORecommendationPreference")
    "ExternalMetricsPreference_Source"=@("Write-CORecommendationPreference")
    "FileFormat"=@("Export-COAutoScalingGroupRecommendation","Export-COEBSVolumeRecommendation","Export-COEC2InstanceRecommendation","Export-COECSServiceRecommendation","Export-COIdleRecommendation","Export-COLambdaFunctionRecommendation","Export-COLicenseRecommendation","Export-CORDSDatabaseRecommendation")
    "InferredWorkloadType"=@("Write-CORecommendationPreference")
    "LookBackPeriod"=@("Write-CORecommendationPreference")
    "OrderBy_Dimension"=@("Get-COIdleRecommendation")
    "OrderBy_Order"=@("Get-COIdleRecommendation")
    "ResourceType"=@("Get-CORecommendationPreference","Remove-CORecommendationPreference","Write-CORecommendationPreference")
    "SavingsEstimationMode"=@("Write-CORecommendationPreference")
    "Scope_Name"=@("Get-CORecommendationPreference","Remove-CORecommendationPreference","Write-CORecommendationPreference")
    "Stat"=@("Get-COEC2RecommendationProjectedMetric","Get-COECSServiceRecommendationProjectedMetric","Get-CORDSDatabaseRecommendationProjectedMetric")
    "Status"=@("Update-COEnrollmentStatus")
}

_awsArgumentCompleterRegistration $CO_Completers $CO_map

$CO_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CO.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CO_SelectMap = @{
    "Select"=@("Remove-CORecommendationPreference",
               "Get-CORecommendationExportJob",
               "Export-COAutoScalingGroupRecommendation",
               "Export-COEBSVolumeRecommendation",
               "Export-COEC2InstanceRecommendation",
               "Export-COECSServiceRecommendation",
               "Export-COIdleRecommendation",
               "Export-COLambdaFunctionRecommendation",
               "Export-COLicenseRecommendation",
               "Export-CORDSDatabaseRecommendation",
               "Get-COAutoScalingGroupRecommendation",
               "Get-COEBSVolumeRecommendation",
               "Get-COEC2InstanceRecommendation",
               "Get-COEC2RecommendationProjectedMetric",
               "Get-COECSServiceRecommendationProjectedMetric",
               "Get-COECSServiceRecommendation",
               "Get-COEffectiveRecommendationPreference",
               "Get-COEnrollmentStatus",
               "Get-COEnrollmentStatusesForOrganization",
               "Get-COIdleRecommendation",
               "Get-COLambdaFunctionRecommendation",
               "Get-COLicenseRecommendation",
               "Get-CORDSDatabaseRecommendationProjectedMetric",
               "Get-CORDSDatabaseRecommendation",
               "Get-CORecommendationPreference",
               "Get-CORecommendationSummary",
               "Write-CORecommendationPreference",
               "Update-COEnrollmentStatus")
}

_awsArgumentCompleterRegistration $CO_SelectCompleters $CO_SelectMap
# Argument completions for service AWS Config


$CFG_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ConfigService.AggregateConformancePackComplianceSummaryGroupKey
        "Get-CFGAggregateConformancePackComplianceSummary/GroupByKey"
        {
            $v = "ACCOUNT_ID","AWS_REGION"
            break
        }

        # Amazon.ConfigService.AggregatorFilterType
        {
            ($_ -eq "Write-CFGConfigurationAggregator/ResourceType_Type") -Or
            ($_ -eq "Write-CFGConfigurationAggregator/ServicePrincipal_Type")
        }
        {
            $v = "INCLUDE"
            break
        }

        # Amazon.ConfigService.ChronologicalOrder
        "Get-CFGResourceConfigHistory/ChronologicalOrder"
        {
            $v = "Forward","Reverse"
            break
        }

        # Amazon.ConfigService.ComplianceType
        {
            ($_ -eq "Get-CFGAggregateComplianceDetailsByConfigRule/ComplianceType") -Or
            ($_ -eq "Write-CFGExternalEvaluation/ExternalEvaluation_ComplianceType") -Or
            ($_ -eq "Get-CFGAggregateComplianceByConfigRuleList/Filters_ComplianceType")
        }
        {
            $v = "COMPLIANT","INSUFFICIENT_DATA","NON_COMPLIANT","NOT_APPLICABLE"
            break
        }

        # Amazon.ConfigService.ConfigRuleComplianceSummaryGroupKey
        "Get-CFGAggregateConfigRuleComplianceSummary/GroupByKey"
        {
            $v = "ACCOUNT_ID","AWS_REGION"
            break
        }

        # Amazon.ConfigService.ConfigRuleState
        "Write-CFGConfigRule/ConfigRule_ConfigRuleState"
        {
            $v = "ACTIVE","DELETING","DELETING_RESULTS","EVALUATING"
            break
        }

        # Amazon.ConfigService.ConformancePackComplianceType
        {
            ($_ -eq "Get-CFGAggregateComplianceByConformancePack/Filters_ComplianceType") -Or
            ($_ -eq "Get-CFGConformancePackCompliance/Filters_ComplianceType") -Or
            ($_ -eq "Get-CFGConformancePackComplianceDetail/Filters_ComplianceType")
        }
        {
            $v = "COMPLIANT","INSUFFICIENT_DATA","NON_COMPLIANT"
            break
        }

        # Amazon.ConfigService.EvaluationMode
        {
            ($_ -eq "Start-CFGResourceEvaluation/EvaluationMode") -Or
            ($_ -eq "Get-CFGConfigRule/Filters_EvaluationMode") -Or
            ($_ -eq "Get-CFGResourceEvaluationList/Filters_EvaluationMode")
        }
        {
            $v = "DETECTIVE","PROACTIVE"
            break
        }

        # Amazon.ConfigService.MaximumExecutionFrequency
        {
            ($_ -eq "Write-CFGConfigRule/ConfigRule_MaximumExecutionFrequency") -Or
            ($_ -eq "Write-CFGDeliveryChannel/ConfigSnapshotDeliveryProperties_DeliveryFrequency") -Or
            ($_ -eq "Write-CFGOrganizationConfigRule/OrganizationCustomPolicyRuleMetadata_MaximumExecutionFrequency") -Or
            ($_ -eq "Write-CFGOrganizationConfigRule/OrganizationCustomRuleMetadata_MaximumExecutionFrequency") -Or
            ($_ -eq "Write-CFGOrganizationConfigRule/OrganizationManagedRuleMetadata_MaximumExecutionFrequency")
        }
        {
            $v = "One_Hour","Six_Hours","Three_Hours","Twelve_Hours","TwentyFour_Hours"
            break
        }

        # Amazon.ConfigService.MemberAccountRuleStatus
        "Get-CFGOrganizationConfigRuleDetailedStatus/Filters_MemberAccountRuleStatus"
        {
            $v = "CREATE_FAILED","CREATE_IN_PROGRESS","CREATE_SUCCESSFUL","DELETE_FAILED","DELETE_IN_PROGRESS","DELETE_SUCCESSFUL","UPDATE_FAILED","UPDATE_IN_PROGRESS","UPDATE_SUCCESSFUL"
            break
        }

        # Amazon.ConfigService.OrganizationResourceDetailedStatus
        "Get-CFGOrganizationConformancePackDetailedStatus/Filters_Status"
        {
            $v = "CREATE_FAILED","CREATE_IN_PROGRESS","CREATE_SUCCESSFUL","DELETE_FAILED","DELETE_IN_PROGRESS","DELETE_SUCCESSFUL","UPDATE_FAILED","UPDATE_IN_PROGRESS","UPDATE_SUCCESSFUL"
            break
        }

        # Amazon.ConfigService.Owner
        "Write-CFGConfigRule/Source_Owner"
        {
            $v = "AWS","CUSTOM_LAMBDA","CUSTOM_POLICY"
            break
        }

        # Amazon.ConfigService.RecordingFrequency
        "Write-CFGConfigurationRecorder/RecordingMode_RecordingFrequency"
        {
            $v = "CONTINUOUS","DAILY"
            break
        }

        # Amazon.ConfigService.RecordingScope
        "Write-CFGConfigurationRecorder/ConfigurationRecorder_RecordingScope"
        {
            $v = "INTERNAL","PAID"
            break
        }

        # Amazon.ConfigService.RecordingStrategyType
        "Write-CFGConfigurationRecorder/RecordingStrategy_UseOnly"
        {
            $v = "ALL_SUPPORTED_RESOURCE_TYPES","EXCLUSION_BY_RESOURCE_TYPES","INCLUSION_BY_RESOURCE_TYPES"
            break
        }

        # Amazon.ConfigService.ResourceConfigurationSchemaType
        "Start-CFGResourceEvaluation/ResourceDetails_ResourceConfigurationSchemaType"
        {
            $v = "CFN_RESOURCE_SCHEMA"
            break
        }

        # Amazon.ConfigService.ResourceCountGroupKey
        "Get-CFGAggregateDiscoveredResourceCount/GroupByKey"
        {
            $v = "ACCOUNT_ID","AWS_REGION","RESOURCE_TYPE"
            break
        }

        # Amazon.ConfigService.ResourceType
        {
            ($_ -eq "Get-CFGAggregateDiscoveredResourceCount/Filters_ResourceType") -Or
            ($_ -eq "Get-CFGAggregateResourceConfig/ResourceIdentifier_ResourceType") -Or
            ($_ -eq "Get-CFGAggregateDiscoveredResourceList/ResourceType") -Or
            ($_ -eq "Get-CFGDiscoveredResource/ResourceType") -Or
            ($_ -eq "Get-CFGResourceConfigHistory/ResourceType")
        }
        {
            $v = "AWS::AccessAnalyzer::Analyzer","AWS::ACM::Certificate","AWS::ACMPCA::CertificateAuthority","AWS::ACMPCA::CertificateAuthorityActivation","AWS::AmazonMQ::Broker","AWS::Amplify::App","AWS::Amplify::Branch","AWS::ApiGateway::RestApi","AWS::ApiGateway::Stage","AWS::ApiGatewayV2::Api","AWS::ApiGatewayV2::Stage","AWS::AppConfig::Application","AWS::AppConfig::ConfigurationProfile","AWS::AppConfig::DeploymentStrategy","AWS::AppConfig::Environment","AWS::AppConfig::ExtensionAssociation","AWS::AppConfig::HostedConfigurationVersion","AWS::AppFlow::Flow","AWS::AppIntegrations::Application","AWS::AppIntegrations::EventIntegration","AWS::AppMesh::GatewayRoute","AWS::AppMesh::Mesh","AWS::AppMesh::Route","AWS::AppMesh::VirtualGateway","AWS::AppMesh::VirtualNode","AWS::AppMesh::VirtualRouter","AWS::AppMesh::VirtualService","AWS::AppRunner::Service","AWS::AppRunner::VpcConnector","AWS::AppStream::Application","AWS::AppStream::DirectoryConfig","AWS::AppStream::Fleet","AWS::AppStream::Stack","AWS::AppSync::ApiCache","AWS::AppSync::GraphQLApi","AWS::APS::RuleGroupsNamespace","AWS::Athena::DataCatalog","AWS::Athena::PreparedStatement","AWS::Athena::WorkGroup","AWS::AuditManager::Assessment","AWS::AutoScaling::AutoScalingGroup","AWS::AutoScaling::LaunchConfiguration","AWS::AutoScaling::ScalingPolicy","AWS::AutoScaling::ScheduledAction","AWS::AutoScaling::WarmPool","AWS::Backup::BackupPlan","AWS::Backup::BackupSelection","AWS::Backup::BackupVault","AWS::Backup::RecoveryPoint","AWS::Backup::ReportPlan","AWS::Batch::ComputeEnvironment","AWS::Batch::JobQueue","AWS::Batch::SchedulingPolicy","AWS::Bedrock::Guardrail","AWS::Bedrock::KnowledgeBase","AWS::Budgets::BudgetsAction","AWS::Cassandra::Keyspace","AWS::Cloud9::EnvironmentEC2","AWS::CloudFormation::Stack","AWS::CloudFront::Distribution","AWS::CloudFront::StreamingDistribution","AWS::CloudTrail::Trail","AWS::CloudWatch::Alarm","AWS::CloudWatch::MetricStream","AWS::CodeArtifact::Repository","AWS::CodeBuild::Project","AWS::CodeBuild::ReportGroup","AWS::CodeDeploy::Application","AWS::CodeDeploy::DeploymentConfig","AWS::CodeDeploy::DeploymentGroup","AWS::CodeGuruProfiler::ProfilingGroup","AWS::CodeGuruReviewer::RepositoryAssociation","AWS::CodePipeline::Pipeline","AWS::Cognito::IdentityPool","AWS::Cognito::UserPool","AWS::Cognito::UserPoolClient","AWS::Cognito::UserPoolGroup","AWS::Config::ConformancePackCompliance","AWS::Config::ResourceCompliance","AWS::Connect::Instance","AWS::Connect::PhoneNumber","AWS::Connect::QuickConnect","AWS::Connect::Rule","AWS::Connect::User","AWS::CustomerProfiles::Domain","AWS::CustomerProfiles::ObjectType","AWS::DataSync::LocationEFS","AWS::DataSync::LocationFSxLustre","AWS::DataSync::LocationFSxWindows","AWS::DataSync::LocationHDFS","AWS::DataSync::LocationNFS","AWS::DataSync::LocationObjectStorage","AWS::DataSync::LocationS3","AWS::DataSync::LocationSMB","AWS::DataSync::Task","AWS::Detective::Graph","AWS::DeviceFarm::InstanceProfile","AWS::DeviceFarm::Project","AWS::DeviceFarm::TestGridProject","AWS::DMS::Certificate","AWS::DMS::Endpoint","AWS::DMS::EventSubscription","AWS::DMS::ReplicationSubnetGroup","AWS::DynamoDB::Table","AWS::EC2::CapacityReservation","AWS::EC2::CarrierGateway","AWS::EC2::ClientVpnEndpoint","AWS::EC2::ClientVpnTargetNetworkAssociation","AWS::EC2::CustomerGateway","AWS::EC2::DHCPOptions","AWS::EC2::EC2Fleet","AWS::EC2::EgressOnlyInternetGateway","AWS::EC2::EIP","AWS::EC2::EIPAssociation","AWS::EC2::FlowLog","AWS::EC2::Host","AWS::EC2::Instance","AWS::EC2::InstanceConnectEndpoint","AWS::EC2::InternetGateway","AWS::EC2::IPAM","AWS::EC2::IPAMPool","AWS::EC2::IPAMResourceDiscovery","AWS::EC2::IPAMResourceDiscoveryAssociation","AWS::EC2::IPAMScope","AWS::EC2::LaunchTemplate","AWS::EC2::NatGateway","AWS::EC2::NetworkAcl","AWS::EC2::NetworkInsightsAccessScope","AWS::EC2::NetworkInsightsAccessScopeAnalysis","AWS::EC2::NetworkInsightsAnalysis","AWS::EC2::NetworkInsightsPath","AWS::EC2::NetworkInterface","AWS::EC2::PrefixList","AWS::EC2::RegisteredHAInstance","AWS::EC2::RouteTable","AWS::EC2::SecurityGroup","AWS::EC2::SnapshotBlockPublicAccess","AWS::EC2::SpotFleet","AWS::EC2::Subnet","AWS::EC2::SubnetRouteTableAssociation","AWS::EC2::TrafficMirrorFilter","AWS::EC2::TrafficMirrorSession","AWS::EC2::TrafficMirrorTarget","AWS::EC2::TransitGateway","AWS::EC2::TransitGatewayAttachment","AWS::EC2::TransitGatewayConnect","AWS::EC2::TransitGatewayMulticastDomain","AWS::EC2::TransitGatewayRouteTable","AWS::EC2::Volume","AWS::EC2::VPC","AWS::EC2::VPCBlockPublicAccessExclusion","AWS::EC2::VPCBlockPublicAccessOptions","AWS::EC2::VPCEndpoint","AWS::EC2::VPCEndpointConnectionNotification","AWS::EC2::VPCEndpointService","AWS::EC2::VPCPeeringConnection","AWS::EC2::VPNConnection","AWS::EC2::VPNConnectionRoute","AWS::EC2::VPNGateway","AWS::ECR::PublicRepository","AWS::ECR::PullThroughCacheRule","AWS::ECR::RegistryPolicy","AWS::ECR::Repository","AWS::ECS::CapacityProvider","AWS::ECS::Cluster","AWS::ECS::Service","AWS::ECS::TaskDefinition","AWS::ECS::TaskSet","AWS::EFS::AccessPoint","AWS::EFS::FileSystem","AWS::EKS::Addon","AWS::EKS::Cluster","AWS::EKS::FargateProfile","AWS::EKS::IdentityProviderConfig","AWS::ElasticBeanstalk::Application","AWS::ElasticBeanstalk::ApplicationVersion","AWS::ElasticBeanstalk::Environment","AWS::ElasticLoadBalancing::LoadBalancer","AWS::ElasticLoadBalancingV2::Listener","AWS::ElasticLoadBalancingV2::LoadBalancer","AWS::Elasticsearch::Domain","AWS::EMR::SecurityConfiguration","AWS::Events::ApiDestination","AWS::Events::Archive","AWS::Events::Connection","AWS::Events::Endpoint","AWS::Events::EventBus","AWS::Events::Rule","AWS::EventSchemas::Discoverer","AWS::EventSchemas::Registry","AWS::EventSchemas::RegistryPolicy","AWS::EventSchemas::Schema","AWS::Evidently::Launch","AWS::Evidently::Project","AWS::Evidently::Segment","AWS::FIS::ExperimentTemplate","AWS::Forecast::Dataset","AWS::Forecast::DatasetGroup","AWS::FraudDetector::EntityType","AWS::FraudDetector::Label","AWS::FraudDetector::Outcome","AWS::FraudDetector::Variable","AWS::GlobalAccelerator::Accelerator","AWS::GlobalAccelerator::EndpointGroup","AWS::GlobalAccelerator::Listener","AWS::Glue::Classifier","AWS::Glue::Job","AWS::Glue::MLTransform","AWS::Grafana::Workspace","AWS::GreengrassV2::ComponentVersion","AWS::GroundStation::Config","AWS::GroundStation::DataflowEndpointGroup","AWS::GroundStation::MissionProfile","AWS::GuardDuty::Detector","AWS::GuardDuty::Filter","AWS::GuardDuty::IPSet","AWS::GuardDuty::ThreatIntelSet","AWS::HealthLake::FHIRDatastore","AWS::IAM::Group","AWS::IAM::InstanceProfile","AWS::IAM::OIDCProvider","AWS::IAM::Policy","AWS::IAM::Role","AWS::IAM::SAMLProvider","AWS::IAM::ServerCertificate","AWS::IAM::User","AWS::ImageBuilder::ContainerRecipe","AWS::ImageBuilder::DistributionConfiguration","AWS::ImageBuilder::ImagePipeline","AWS::ImageBuilder::ImageRecipe","AWS::ImageBuilder::InfrastructureConfiguration","AWS::InspectorV2::Activation","AWS::InspectorV2::Filter","AWS::IoT::AccountAuditConfiguration","AWS::IoT::Authorizer","AWS::IoT::CACertificate","AWS::IoT::CustomMetric","AWS::IoT::Dimension","AWS::IoT::FleetMetric","AWS::IoT::JobTemplate","AWS::IoT::MitigationAction","AWS::IoT::Policy","AWS::IoT::ProvisioningTemplate","AWS::IoT::RoleAlias","AWS::IoT::ScheduledAudit","AWS::IoT::SecurityProfile","AWS::IoTAnalytics::Channel","AWS::IoTAnalytics::Dataset","AWS::IoTAnalytics::Datastore","AWS::IoTAnalytics::Pipeline","AWS::IoTEvents::AlarmModel","AWS::IoTEvents::DetectorModel","AWS::IoTEvents::Input","AWS::IoTSiteWise::AssetModel","AWS::IoTSiteWise::Dashboard","AWS::IoTSiteWise::Gateway","AWS::IoTSiteWise::Portal","AWS::IoTSiteWise::Project","AWS::IoTTwinMaker::ComponentType","AWS::IoTTwinMaker::Entity","AWS::IoTTwinMaker::Scene","AWS::IoTTwinMaker::SyncJob","AWS::IoTTwinMaker::Workspace","AWS::IoTWireless::FuotaTask","AWS::IoTWireless::MulticastGroup","AWS::IoTWireless::ServiceProfile","AWS::IVS::Channel","AWS::IVS::PlaybackKeyPair","AWS::IVS::RecordingConfiguration","AWS::KafkaConnect::Connector","AWS::Kendra::Index","AWS::Kinesis::Stream","AWS::Kinesis::StreamConsumer","AWS::KinesisAnalyticsV2::Application","AWS::KinesisFirehose::DeliveryStream","AWS::KinesisVideo::SignalingChannel","AWS::KinesisVideo::Stream","AWS::KMS::Alias","AWS::KMS::Key","AWS::Lambda::CodeSigningConfig","AWS::Lambda::Function","AWS::Lex::Bot","AWS::Lex::BotAlias","AWS::Lightsail::Bucket","AWS::Lightsail::Certificate","AWS::Lightsail::Disk","AWS::Lightsail::StaticIp","AWS::Logs::Destination","AWS::LookoutMetrics::Alert","AWS::LookoutVision::Project","AWS::M2::Environment","AWS::MediaConnect::FlowEntitlement","AWS::MediaConnect::FlowSource","AWS::MediaConnect::FlowVpcInterface","AWS::MediaConnect::Gateway","AWS::MediaPackage::PackagingConfiguration","AWS::MediaPackage::PackagingGroup","AWS::MediaTailor::PlaybackConfiguration","AWS::MemoryDB::SubnetGroup","AWS::MSK::BatchScramSecret","AWS::MSK::Cluster","AWS::MSK::ClusterPolicy","AWS::MSK::Configuration","AWS::MSK::VpcConnection","AWS::NetworkFirewall::Firewall","AWS::NetworkFirewall::FirewallPolicy","AWS::NetworkFirewall::RuleGroup","AWS::NetworkManager::ConnectPeer","AWS::NetworkManager::CustomerGatewayAssociation","AWS::NetworkManager::Device","AWS::NetworkManager::GlobalNetwork","AWS::NetworkManager::Link","AWS::NetworkManager::LinkAssociation","AWS::NetworkManager::Site","AWS::NetworkManager::TransitGatewayRegistration","AWS::OpenSearch::Domain","AWS::OpenSearchServerless::Collection","AWS::OpenSearchServerless::VpcEndpoint","AWS::Panorama::Package","AWS::Personalize::Dataset","AWS::Personalize::DatasetGroup","AWS::Personalize::Schema","AWS::Personalize::Solution","AWS::Pinpoint::App","AWS::Pinpoint::ApplicationSettings","AWS::Pinpoint::Campaign","AWS::Pinpoint::EmailChannel","AWS::Pinpoint::EmailTemplate","AWS::Pinpoint::EventStream","AWS::Pinpoint::InAppTemplate","AWS::Pinpoint::Segment","AWS::QLDB::Ledger","AWS::QuickSight::DataSource","AWS::QuickSight::Template","AWS::QuickSight::Theme","AWS::RDS::DBCluster","AWS::RDS::DBClusterSnapshot","AWS::RDS::DBInstance","AWS::RDS::DBSecurityGroup","AWS::RDS::DBSnapshot","AWS::RDS::DBSubnetGroup","AWS::RDS::EventSubscription","AWS::RDS::GlobalCluster","AWS::RDS::OptionGroup","AWS::Redshift::Cluster","AWS::Redshift::ClusterParameterGroup","AWS::Redshift::ClusterSecurityGroup","AWS::Redshift::ClusterSnapshot","AWS::Redshift::ClusterSubnetGroup","AWS::Redshift::EndpointAccess","AWS::Redshift::EndpointAuthorization","AWS::Redshift::EventSubscription","AWS::Redshift::ScheduledAction","AWS::ResilienceHub::App","AWS::ResilienceHub::ResiliencyPolicy","AWS::ResourceExplorer2::Index","AWS::RoboMaker::RobotApplication","AWS::RoboMaker::RobotApplicationVersion","AWS::RoboMaker::SimulationApplication","AWS::Route53::HostedZone","AWS::Route53Profiles::Profile","AWS::Route53RecoveryControl::Cluster","AWS::Route53RecoveryControl::ControlPanel","AWS::Route53RecoveryControl::RoutingControl","AWS::Route53RecoveryControl::SafetyRule","AWS::Route53RecoveryReadiness::Cell","AWS::Route53RecoveryReadiness::ReadinessCheck","AWS::Route53RecoveryReadiness::RecoveryGroup","AWS::Route53RecoveryReadiness::ResourceSet","AWS::Route53Resolver::FirewallDomainList","AWS::Route53Resolver::FirewallRuleGroup","AWS::Route53Resolver::FirewallRuleGroupAssociation","AWS::Route53Resolver::ResolverEndpoint","AWS::Route53Resolver::ResolverQueryLoggingConfig","AWS::Route53Resolver::ResolverQueryLoggingConfigAssociation","AWS::Route53Resolver::ResolverRule","AWS::Route53Resolver::ResolverRuleAssociation","AWS::RUM::AppMonitor","AWS::S3::AccessPoint","AWS::S3::AccountPublicAccessBlock","AWS::S3::Bucket","AWS::S3::MultiRegionAccessPoint","AWS::S3::StorageLens","AWS::S3::StorageLensGroup","AWS::S3Express::BucketPolicy","AWS::S3Express::DirectoryBucket","AWS::SageMaker::AppImageConfig","AWS::SageMaker::CodeRepository","AWS::SageMaker::Domain","AWS::SageMaker::FeatureGroup","AWS::SageMaker::Image","AWS::SageMaker::InferenceExperiment","AWS::SageMaker::Model","AWS::SageMaker::NotebookInstanceLifecycleConfig","AWS::SageMaker::Workteam","AWS::SecretsManager::Secret","AWS::SecurityHub::Standard","AWS::ServiceCatalog::CloudFormationProduct","AWS::ServiceCatalog::CloudFormationProvisionedProduct","AWS::ServiceCatalog::Portfolio","AWS::ServiceDiscovery::HttpNamespace","AWS::ServiceDiscovery::Instance","AWS::ServiceDiscovery::PublicDnsNamespace","AWS::ServiceDiscovery::Service","AWS::SES::ConfigurationSet","AWS::SES::ContactList","AWS::SES::ReceiptFilter","AWS::SES::ReceiptRuleSet","AWS::SES::Template","AWS::Shield::Protection","AWS::ShieldRegional::Protection","AWS::Signer::SigningProfile","AWS::SNS::Topic","AWS::SQS::Queue","AWS::SSM::AssociationCompliance","AWS::SSM::Document","AWS::SSM::FileData","AWS::SSM::ManagedInstanceInventory","AWS::SSM::PatchCompliance","AWS::StepFunctions::Activity","AWS::StepFunctions::StateMachine","AWS::Transfer::Agreement","AWS::Transfer::Certificate","AWS::Transfer::Connector","AWS::Transfer::Profile","AWS::Transfer::Workflow","AWS::WAF::RateBasedRule","AWS::WAF::Rule","AWS::WAF::RuleGroup","AWS::WAF::WebACL","AWS::WAFRegional::RateBasedRule","AWS::WAFRegional::Rule","AWS::WAFRegional::RuleGroup","AWS::WAFRegional::WebACL","AWS::WAFv2::IPSet","AWS::WAFv2::ManagedRuleSet","AWS::WAFv2::RegexPatternSet","AWS::WAFv2::RuleGroup","AWS::WAFv2::WebACL","AWS::WorkSpaces::ConnectionAlias","AWS::WorkSpaces::Workspace","AWS::XRay::EncryptionConfig"
            break
        }

        # Amazon.ConfigService.SortBy
        "Get-CFGConformancePackComplianceScoreList/SortBy"
        {
            $v = "SCORE"
            break
        }

        # Amazon.ConfigService.SortOrder
        "Get-CFGConformancePackComplianceScoreList/SortOrder"
        {
            $v = "ASCENDING","DESCENDING"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CFG_map = @{
    "ChronologicalOrder"=@("Get-CFGResourceConfigHistory")
    "ComplianceType"=@("Get-CFGAggregateComplianceDetailsByConfigRule")
    "ConfigRule_ConfigRuleState"=@("Write-CFGConfigRule")
    "ConfigRule_MaximumExecutionFrequency"=@("Write-CFGConfigRule")
    "ConfigSnapshotDeliveryProperties_DeliveryFrequency"=@("Write-CFGDeliveryChannel")
    "ConfigurationRecorder_RecordingScope"=@("Write-CFGConfigurationRecorder")
    "EvaluationMode"=@("Start-CFGResourceEvaluation")
    "ExternalEvaluation_ComplianceType"=@("Write-CFGExternalEvaluation")
    "Filters_ComplianceType"=@("Get-CFGAggregateComplianceByConfigRuleList","Get-CFGAggregateComplianceByConformancePack","Get-CFGConformancePackCompliance","Get-CFGConformancePackComplianceDetail")
    "Filters_EvaluationMode"=@("Get-CFGConfigRule","Get-CFGResourceEvaluationList")
    "Filters_MemberAccountRuleStatus"=@("Get-CFGOrganizationConfigRuleDetailedStatus")
    "Filters_ResourceType"=@("Get-CFGAggregateDiscoveredResourceCount")
    "Filters_Status"=@("Get-CFGOrganizationConformancePackDetailedStatus")
    "GroupByKey"=@("Get-CFGAggregateConfigRuleComplianceSummary","Get-CFGAggregateConformancePackComplianceSummary","Get-CFGAggregateDiscoveredResourceCount")
    "OrganizationCustomPolicyRuleMetadata_MaximumExecutionFrequency"=@("Write-CFGOrganizationConfigRule")
    "OrganizationCustomRuleMetadata_MaximumExecutionFrequency"=@("Write-CFGOrganizationConfigRule")
    "OrganizationManagedRuleMetadata_MaximumExecutionFrequency"=@("Write-CFGOrganizationConfigRule")
    "RecordingMode_RecordingFrequency"=@("Write-CFGConfigurationRecorder")
    "RecordingStrategy_UseOnly"=@("Write-CFGConfigurationRecorder")
    "ResourceDetails_ResourceConfigurationSchemaType"=@("Start-CFGResourceEvaluation")
    "ResourceIdentifier_ResourceType"=@("Get-CFGAggregateResourceConfig")
    "ResourceType"=@("Get-CFGAggregateDiscoveredResourceList","Get-CFGDiscoveredResource","Get-CFGResourceConfigHistory")
    "ResourceType_Type"=@("Write-CFGConfigurationAggregator")
    "ServicePrincipal_Type"=@("Write-CFGConfigurationAggregator")
    "SortBy"=@("Get-CFGConformancePackComplianceScoreList")
    "SortOrder"=@("Get-CFGConformancePackComplianceScoreList")
    "Source_Owner"=@("Write-CFGConfigRule")
}

_awsArgumentCompleterRegistration $CFG_Completers $CFG_map

$CFG_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CFG.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CFG_SelectMap = @{
    "Select"=@("Add-CFGResourceType",
               "Get-CFGAggregateResourceConfigBatch",
               "Get-CFGGetResourceConfigBatch",
               "Remove-CFGAggregationAuthorization",
               "Remove-CFGConfigRule",
               "Remove-CFGConfigurationAggregator",
               "Remove-CFGConfigurationRecorder",
               "Remove-CFGConformancePack",
               "Remove-CFGDeliveryChannel",
               "Remove-CFGEvaluationResult",
               "Remove-CFGOrganizationConfigRule",
               "Remove-CFGOrganizationConformancePack",
               "Remove-CFGPendingAggregationRequest",
               "Remove-CFGRemediationConfiguration",
               "Remove-CFGRemediationException",
               "Remove-CFGResourceConfig",
               "Remove-CFGRetentionConfiguration",
               "Remove-CFGServiceLinkedConfigurationRecorder",
               "Remove-CFGStoredQuery",
               "Submit-CFGConfigSnapshotDelivery",
               "Get-CFGAggregateComplianceByConfigRuleList",
               "Get-CFGAggregateComplianceByConformancePack",
               "Get-CFGAggregationAuthorizationList",
               "Get-CFGComplianceByConfigRule",
               "Get-CFGComplianceByResource",
               "Get-CFGConfigRuleEvaluationStatus",
               "Get-CFGConfigRule",
               "Get-CFGConfigurationAggregatorList",
               "Get-CFGConfigurationAggregatorSourcesStatus",
               "Get-CFGConfigurationRecorder",
               "Get-CFGConfigurationRecorderStatus",
               "Get-CFGConformancePackCompliance",
               "Get-CFGConformancePack",
               "Get-CFGConformancePackStatus",
               "Get-CFGDeliveryChannel",
               "Get-CFGDeliveryChannelStatus",
               "Get-CFGOrganizationConfigRule",
               "Get-CFGOrganizationConfigRuleStatus",
               "Get-CFGOrganizationConformancePack",
               "Get-CFGOrganizationConformancePackStatus",
               "Get-CFGPendingAggregationRequestList",
               "Get-CFGRemediationConfiguration",
               "Get-CFGRemediationException",
               "Get-CFGRemediationExecutionStatus",
               "Get-CFGRetentionConfiguration",
               "Remove-CFGResourceType",
               "Get-CFGAggregateComplianceDetailsByConfigRule",
               "Get-CFGAggregateConfigRuleComplianceSummary",
               "Get-CFGAggregateConformancePackComplianceSummary",
               "Get-CFGAggregateDiscoveredResourceCount",
               "Get-CFGAggregateResourceConfig",
               "Get-CFGComplianceDetailsByConfigRule",
               "Get-CFGComplianceDetailsByResource",
               "Get-CFGComplianceSummaryByConfigRule",
               "Get-CFGComplianceSummaryByResourceType",
               "Get-CFGConformancePackComplianceDetail",
               "Get-CFGConformancePackComplianceSummary",
               "Get-CFGCustomRulePolicy",
               "Get-CFGDiscoveredResourceCount",
               "Get-CFGOrganizationConfigRuleDetailedStatus",
               "Get-CFGOrganizationConformancePackDetailedStatus",
               "Get-CFGOrganizationCustomRulePolicy",
               "Get-CFGResourceConfigHistory",
               "Get-CFGResourceEvaluationSummary",
               "Get-CFGStoredQuery",
               "Get-CFGAggregateDiscoveredResourceList",
               "Get-CFGConfigurationRecorderList",
               "Get-CFGConformancePackComplianceScoreList",
               "Get-CFGDiscoveredResource",
               "Get-CFGResourceEvaluationList",
               "Get-CFGStoredQueryList",
               "Get-CFGResourceTag",
               "Write-CFGAggregationAuthorization",
               "Write-CFGConfigRule",
               "Write-CFGConfigurationAggregator",
               "Write-CFGConfigurationRecorder",
               "Write-CFGConformancePack",
               "Write-CFGDeliveryChannel",
               "Write-CFGEvaluation",
               "Write-CFGExternalEvaluation",
               "Write-CFGOrganizationConfigRule",
               "Write-CFGOrganizationConformancePack",
               "Write-CFGRemediationConfiguration",
               "Write-CFGRemediationException",
               "Write-CFGResourceConfig",
               "Write-CFGRetentionConfiguration",
               "Write-CFGServiceLinkedConfigurationRecorder",
               "Write-CFGStoredQuery",
               "Select-CFGAggregateResourceConfig",
               "Select-CFGResourceConfig",
               "Start-CFGConfigRulesEvaluation",
               "Start-CFGConfigurationRecorder",
               "Start-CFGRemediationExecution",
               "Start-CFGResourceEvaluation",
               "Stop-CFGConfigurationRecorder",
               "Add-CFGResourceTag",
               "Remove-CFGResourceTag")
}

_awsArgumentCompleterRegistration $CFG_SelectCompleters $CFG_SelectMap
# Argument completions for service Amazon Connect Contact Lens


$CCL_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CCL.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CCL_SelectMap = @{
    "Select"=@("Get-CCLRealtimeContactAnalysisSegmentList")
}

_awsArgumentCompleterRegistration $CCL_SelectCompleters $CCL_SelectMap
# Argument completions for service Amazon Connect Service


$CONN_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.Connect.AgentAvailabilityTimer
        {
            ($_ -eq "New-CONNRoutingProfile/AgentAvailabilityTimer") -Or
            ($_ -eq "Update-CONNRoutingProfileAgentAvailabilityTimer/AgentAvailabilityTimer")
        }
        {
            $v = "TIME_SINCE_LAST_ACTIVITY","TIME_SINCE_LAST_INBOUND"
            break
        }

        # Amazon.Connect.AgentStatusState
        {
            ($_ -eq "New-CONNAgentStatus/State") -Or
            ($_ -eq "Update-CONNAgentStatus/State")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.Connect.Channel
        "New-CONNContact/Channel"
        {
            $v = "CHAT","EMAIL","TASK","VOICE"
            break
        }

        # Amazon.Connect.ChatEventType
        "Send-CONNChatIntegrationEvent/Event_Type"
        {
            $v = "DISCONNECT","EVENT","MESSAGE"
            break
        }

        # Amazon.Connect.ContactFlowModuleState
        {
            ($_ -eq "Get-CONNContactFlowModuleList/ContactFlowModuleState") -Or
            ($_ -eq "Search-CONNContactFlowModule/SearchCriteria_StateCondition") -Or
            ($_ -eq "Update-CONNContactFlowModuleMetadata/State")
        }
        {
            $v = "ACTIVE","ARCHIVED"
            break
        }

        # Amazon.Connect.ContactFlowModuleStatus
        "Search-CONNContactFlowModule/SearchCriteria_StatusCondition"
        {
            $v = "PUBLISHED","SAVED"
            break
        }

        # Amazon.Connect.ContactFlowState
        {
            ($_ -eq "Update-CONNContactFlowMetadata/ContactFlowState") -Or
            ($_ -eq "Search-CONNContactFlow/SearchCriteria_StateCondition")
        }
        {
            $v = "ACTIVE","ARCHIVED"
            break
        }

        # Amazon.Connect.ContactFlowStatus
        {
            ($_ -eq "Search-CONNContactFlow/SearchCriteria_StatusCondition") -Or
            ($_ -eq "New-CONNContactFlow/Status")
        }
        {
            $v = "PUBLISHED","SAVED"
            break
        }

        # Amazon.Connect.ContactFlowType
        {
            ($_ -eq "Search-CONNContactFlow/SearchCriteria_TypeCondition") -Or
            ($_ -eq "New-CONNContactFlow/Type")
        }
        {
            $v = "AGENT_HOLD","AGENT_TRANSFER","AGENT_WHISPER","CAMPAIGN","CONTACT_FLOW","CUSTOMER_HOLD","CUSTOMER_QUEUE","CUSTOMER_WHISPER","OUTBOUND_WHISPER","QUEUE_TRANSFER"
            break
        }

        # Amazon.Connect.ContactInitiationMethod
        "New-CONNContact/InitiationMethod"
        {
            $v = "AGENT_REPLY","API","CALLBACK","DISCONNECT","EXTERNAL_OUTBOUND","FLOW","INBOUND","MONITOR","OUTBOUND","QUEUE_TRANSFER","TRANSFER","WEBRTC_API"
            break
        }

        # Amazon.Connect.ContactRecordingType
        {
            ($_ -eq "Resume-CONNContactRecording/ContactRecordingType") -Or
            ($_ -eq "Stop-CONNContactRecording/ContactRecordingType") -Or
            ($_ -eq "Suspend-CONNContactRecording/ContactRecordingType")
        }
        {
            $v = "AGENT","IVR","SCREEN"
            break
        }

        # Amazon.Connect.DateComparisonType
        "Search-CONNHoursOfOperationOverride/DateCondition_ComparisonType"
        {
            $v = "EQUAL_TO","GREATER_THAN","GREATER_THAN_OR_EQUAL_TO","LESS_THAN","LESS_THAN_OR_EQUAL_TO"
            break
        }

        # Amazon.Connect.DeviceType
        "New-CONNPushNotificationRegistration/DeviceType"
        {
            $v = "APNS","APNS_SANDBOX","GCM"
            break
        }

        # Amazon.Connect.DirectoryType
        "New-CONNInstance/IdentityManagementType"
        {
            $v = "CONNECT_MANAGED","EXISTING_DIRECTORY","SAML"
            break
        }

        # Amazon.Connect.EncryptionType
        {
            ($_ -eq "Add-CONNInstanceStorageConfig/StorageConfigKinesisVideoStreamConfigEncryptionConfigEncryptionType") -Or
            ($_ -eq "Update-CONNInstanceStorageConfig/StorageConfigKinesisVideoStreamConfigEncryptionConfigEncryptionType") -Or
            ($_ -eq "Add-CONNInstanceStorageConfig/StorageConfigS3ConfigEncryptionConfigEncryptionType") -Or
            ($_ -eq "Update-CONNInstanceStorageConfig/StorageConfigS3ConfigEncryptionConfigEncryptionType")
        }
        {
            $v = "KMS"
            break
        }

        # Amazon.Connect.EndpointType
        {
            ($_ -eq "Update-CONNContact/CustomerEndpoint_Type") -Or
            ($_ -eq "Start-CONNOutboundChatContact/DestinationEndpoint_Type") -Or
            ($_ -eq "Start-CONNOutboundChatContact/SourceEndpoint_Type") -Or
            ($_ -eq "Update-CONNContact/SystemEndpoint_Type")
        }
        {
            $v = "CONNECT_PHONENUMBER_ARN","CONTACT_FLOW","EMAIL_ADDRESS","TELEPHONE_NUMBER","VOIP"
            break
        }

        # Amazon.Connect.EvaluationFormScoringMode
        {
            ($_ -eq "New-CONNEvaluationForm/ScoringStrategy_Mode") -Or
            ($_ -eq "Update-CONNEvaluationForm/ScoringStrategy_Mode")
        }
        {
            $v = "QUESTION_ONLY","SECTION_ONLY"
            break
        }

        # Amazon.Connect.EvaluationFormScoringStatus
        {
            ($_ -eq "New-CONNEvaluationForm/ScoringStrategy_Status") -Or
            ($_ -eq "Update-CONNEvaluationForm/ScoringStrategy_Status")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.Connect.EventSourceName
        {
            ($_ -eq "Get-CONNRuleList/EventSourceName") -Or
            ($_ -eq "New-CONNRule/TriggerEventSource_EventSourceName")
        }
        {
            $v = "OnCaseCreate","OnCaseUpdate","OnContactEvaluationSubmit","OnMetricDataUpdate","OnPostCallAnalysisAvailable","OnPostChatAnalysisAvailable","OnRealTimeCallAnalysisAvailable","OnRealTimeChatAnalysisAvailable","OnSalesforceCaseCreate","OnSlaBreach","OnZendeskTicketCreate","OnZendeskTicketStatusUpdate"
            break
        }

        # Amazon.Connect.FileUseCaseType
        "Start-CONNAttachedFileUpload/FileUseCaseType"
        {
            $v = "ATTACHMENT","EMAIL_MESSAGE"
            break
        }

        # Amazon.Connect.FlowAssociationResourceType
        {
            ($_ -eq "Add-CONNFlow/ResourceType") -Or
            ($_ -eq "Get-CONNFlowAssociation/ResourceType") -Or
            ($_ -eq "Remove-CONNFlow/ResourceType")
        }
        {
            $v = "ANALYTICS_CONNECTOR","INBOUND_EMAIL","OUTBOUND_EMAIL","SMS_PHONE_NUMBER","WHATSAPP_MESSAGING_PHONE_NUMBER"
            break
        }

        # Amazon.Connect.HierarchyGroupMatchType
        {
            ($_ -eq "Search-CONNUser/HierarchyGroupCondition_HierarchyGroupMatchType") -Or
            ($_ -eq "Search-CONNUser/SearchFilter_UserAttributeFilter_AndCondition_HierarchyGroupCondition_HierarchyGroupMatchType") -Or
            ($_ -eq "Search-CONNUser/SearchFilter_UserAttributeFilter_HierarchyGroupCondition_HierarchyGroupMatchType")
        }
        {
            $v = "EXACT","WITH_CHILD_GROUPS"
            break
        }

        # Amazon.Connect.InboundMessageSourceType
        "Start-CONNEmailContact/EmailMessage_MessageSourceType"
        {
            $v = "RAW"
            break
        }

        # Amazon.Connect.InitiateAs
        "New-CONNContact/InitiateAs"
        {
            $v = "COMPLETED","CONNECTED_TO_USER"
            break
        }

        # Amazon.Connect.InstanceAttributeType
        {
            ($_ -eq "Get-CONNInstanceAttribute/AttributeType") -Or
            ($_ -eq "Update-CONNInstanceAttribute/AttributeType")
        }
        {
            $v = "AUTO_RESOLVE_BEST_VOICES","CONTACTFLOW_LOGS","CONTACT_LENS","EARLY_MEDIA","ENHANCED_CHAT_MONITORING","ENHANCED_CONTACT_MONITORING","HIGH_VOLUME_OUTBOUND","INBOUND_CALLS","MULTI_PARTY_CHAT_CONFERENCE","MULTI_PARTY_CONFERENCE","OUTBOUND_CALLS","USE_CUSTOM_TTS_VOICES"
            break
        }

        # Amazon.Connect.InstanceStorageResourceType
        {
            ($_ -eq "Add-CONNInstanceStorageConfig/ResourceType") -Or
            ($_ -eq "Get-CONNInstanceStorageConfig/ResourceType") -Or
            ($_ -eq "Get-CONNInstanceStorageConfigList/ResourceType") -Or
            ($_ -eq "Remove-CONNInstanceStorageConfig/ResourceType") -Or
            ($_ -eq "Update-CONNInstanceStorageConfig/ResourceType")
        }
        {
            $v = "AGENT_EVENTS","ATTACHMENTS","CALL_RECORDINGS","CHAT_TRANSCRIPTS","CONTACT_EVALUATIONS","CONTACT_TRACE_RECORDS","EMAIL_MESSAGES","MEDIA_STREAMS","REAL_TIME_CONTACT_ANALYSIS_CHAT_SEGMENTS","REAL_TIME_CONTACT_ANALYSIS_SEGMENTS","REAL_TIME_CONTACT_ANALYSIS_VOICE_SEGMENTS","SCHEDULED_REPORTS","SCREEN_RECORDINGS"
            break
        }

        # Amazon.Connect.IntegrationType
        {
            ($_ -eq "Get-CONNIntegrationAssociationList/IntegrationType") -Or
            ($_ -eq "New-CONNIntegrationAssociation/IntegrationType")
        }
        {
            $v = "ANALYTICS_CONNECTOR","APPLICATION","CALL_TRANSFER_CONNECTOR","CASES_DOMAIN","COGNITO_USER_POOL","EVENT","FILE_SCANNER","PINPOINT_APP","Q_MESSAGE_TEMPLATES","SES_IDENTITY","VOICE_ID","WISDOM_ASSISTANT","WISDOM_KNOWLEDGE_BASE","WISDOM_QUICK_RESPONSES"
            break
        }

        # Amazon.Connect.IntervalPeriod
        "Get-CONNMetricDataV2/Interval_IntervalPeriod"
        {
            $v = "DAY","FIFTEEN_MIN","HOUR","THIRTY_MIN","TOTAL","WEEK"
            break
        }

        # Amazon.Connect.IvrRecordingTrack
        "Start-CONNContactRecording/VoiceRecordingConfiguration_IvrRecordingTrack"
        {
            $v = "ALL"
            break
        }

        # Amazon.Connect.LexVersion
        "Get-CONNBotList/LexVersion"
        {
            $v = "V1","V2"
            break
        }

        # Amazon.Connect.ListFlowAssociationResourceType
        {
            ($_ -eq "Get-CONNFlowAssociationBatch/ResourceType") -Or
            ($_ -eq "Get-CONNFlowAssociationList/ResourceType")
        }
        {
            $v = "ANALYTICS_CONNECTOR","INBOUND_EMAIL","OUTBOUND_EMAIL","VOICE_PHONE_NUMBER","WHATSAPP_MESSAGING_PHONE_NUMBER"
            break
        }

        # Amazon.Connect.OutboundMessageSourceType
        {
            ($_ -eq "Send-CONNOutboundEmail/EmailMessage_MessageSourceType") -Or
            ($_ -eq "Start-CONNOutboundEmailContact/EmailMessage_MessageSourceType")
        }
        {
            $v = "RAW","TEMPLATE"
            break
        }

        # Amazon.Connect.OutboundStrategyType
        "Start-CONNOutboundVoiceContact/OutboundStrategy_Type"
        {
            $v = "AGENT_FIRST"
            break
        }

        # Amazon.Connect.ParticipantRole
        {
            ($_ -eq "New-CONNPushNotificationRegistration/ContactConfiguration_ParticipantRole") -Or
            ($_ -eq "New-CONNParticipant/ParticipantDetails_ParticipantRole")
        }
        {
            $v = "AGENT","CUSTOMER","CUSTOM_BOT","SUPERVISOR","SYSTEM"
            break
        }

        # Amazon.Connect.PhoneNumberCountryCode
        "Search-CONNAvailablePhoneNumber/PhoneNumberCountryCode"
        {
            $v = "AD","AE","AF","AG","AI","AL","AM","AN","AO","AQ","AR","AS","AT","AU","AW","AZ","BA","BB","BD","BE","BF","BG","BH","BI","BJ","BL","BM","BN","BO","BR","BS","BT","BW","BY","BZ","CA","CC","CD","CF","CG","CH","CI","CK","CL","CM","CN","CO","CR","CU","CV","CW","CX","CY","CZ","DE","DJ","DK","DM","DO","DZ","EC","EE","EG","EH","ER","ES","ET","FI","FJ","FK","FM","FO","FR","GA","GB","GD","GE","GG","GH","GI","GL","GM","GN","GQ","GR","GT","GU","GW","GY","HK","HN","HR","HT","HU","ID","IE","IL","IM","IN","IO","IQ","IR","IS","IT","JE","JM","JO","JP","KE","KG","KH","KI","KM","KN","KP","KR","KW","KY","KZ","LA","LB","LC","LI","LK","LR","LS","LT","LU","LV","LY","MA","MC","MD","ME","MF","MG","MH","MK","ML","MM","MN","MO","MP","MR","MS","MT","MU","MV","MW","MX","MY","MZ","NA","NC","NE","NG","NI","NL","NO","NP","NR","NU","NZ","OM","PA","PE","PF","PG","PH","PK","PL","PM","PN","PR","PT","PW","PY","QA","RE","RO","RS","RU","RW","SA","SB","SC","SD","SE","SG","SH","SI","SJ","SK","SL","SM","SN","SO","SR","ST","SV","SX","SY","SZ","TC","TD","TG","TH","TJ","TK","TL","TM","TN","TO","TR","TT","TV","TW","TZ","UA","UG","US","UY","UZ","VA","VC","VE","VG","VI","VN","VU","WF","WS","YE","YT","ZA","ZM","ZW"
            break
        }

        # Amazon.Connect.PhoneNumberType
        "Search-CONNAvailablePhoneNumber/PhoneNumberType"
        {
            $v = "DID","SHARED","SHORT_CODE","THIRD_PARTY_DID","THIRD_PARTY_TF","TOLL_FREE","UIFN"
            break
        }

        # Amazon.Connect.QueueStatus
        "Update-CONNQueueStatus/Status"
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.Connect.QuickConnectType
        {
            ($_ -eq "New-CONNQuickConnect/QuickConnectConfig_QuickConnectType") -Or
            ($_ -eq "Update-CONNQuickConnectConfig/QuickConnectConfig_QuickConnectType")
        }
        {
            $v = "PHONE_NUMBER","QUEUE","USER"
            break
        }

        # Amazon.Connect.RealTimeContactAnalysisOutputType
        "Get-CONNRealtimeContactAnalysisSegmentsV2List/OutputType"
        {
            $v = "Raw","Redacted"
            break
        }

        # Amazon.Connect.RehydrationType
        {
            ($_ -eq "Start-CONNChatContact/PersistentChat_RehydrationType") -Or
            ($_ -eq "New-CONNPersistentContactAssociation/RehydrationType")
        }
        {
            $v = "ENTIRE_PAST_SESSION","FROM_SEGMENT"
            break
        }

        # Amazon.Connect.RulePublishStatus
        {
            ($_ -eq "Get-CONNRuleList/PublishStatus") -Or
            ($_ -eq "New-CONNRule/PublishStatus") -Or
            ($_ -eq "Update-CONNRule/PublishStatus")
        }
        {
            $v = "DRAFT","PUBLISHED"
            break
        }

        # Amazon.Connect.ScreenShareCapability
        {
            ($_ -eq "Start-CONNWebRTCContact/Agent_ScreenShare") -Or
            ($_ -eq "Start-CONNWebRTCContact/Customer_ScreenShare") -Or
            ($_ -eq "New-CONNParticipant/ParticipantCapabilities_ScreenShare")
        }
        {
            $v = "SEND"
            break
        }

        # Amazon.Connect.SearchableQueueType
        "Search-CONNQueue/SearchCriteria_QueueTypeCondition"
        {
            $v = "STANDARD"
            break
        }

        # Amazon.Connect.SearchContactsMatchType
        {
            ($_ -eq "Search-CONNContact/AdditionalTimeRange_MatchType") -Or
            ($_ -eq "Search-CONNContact/Name_MatchType") -Or
            ($_ -eq "Search-CONNContact/SearchableContactAttributes_MatchType") -Or
            ($_ -eq "Search-CONNContact/SearchableSegmentAttributes_MatchType") -Or
            ($_ -eq "Search-CONNContact/Transcript_MatchType")
        }
        {
            $v = "MATCH_ALL","MATCH_ANY","MATCH_EXACT","MATCH_NONE"
            break
        }

        # Amazon.Connect.SearchContactsTimeRangeType
        "Search-CONNContact/TimeRange_Type"
        {
            $v = "CONNECTED_TO_AGENT_TIMESTAMP","DISCONNECT_TIMESTAMP","ENQUEUE_TIMESTAMP","INITIATION_TIMESTAMP","SCHEDULED_TIMESTAMP"
            break
        }

        # Amazon.Connect.SortableFieldName
        "Search-CONNContact/Sort_FieldName"
        {
            $v = "CHANNEL","CONNECTED_TO_AGENT_TIMESTAMP","DISCONNECT_TIMESTAMP","EXPIRY_TIMESTAMP","INITIATION_METHOD","INITIATION_TIMESTAMP","SCHEDULED_TIMESTAMP"
            break
        }

        # Amazon.Connect.SortOrder
        "Search-CONNContact/Sort_Order"
        {
            $v = "ASCENDING","DESCENDING"
            break
        }

        # Amazon.Connect.SourceType
        "New-CONNIntegrationAssociation/SourceType"
        {
            $v = "CASES","SALESFORCE","ZENDESK"
            break
        }

        # Amazon.Connect.StorageType
        {
            ($_ -eq "Add-CONNInstanceStorageConfig/StorageConfig_StorageType") -Or
            ($_ -eq "Update-CONNInstanceStorageConfig/StorageConfig_StorageType")
        }
        {
            $v = "KINESIS_FIREHOSE","KINESIS_STREAM","KINESIS_VIDEO_STREAM","S3"
            break
        }

        # Amazon.Connect.StringComparisonType
        {
            ($_ -eq "Search-CONNAgentStatus/StringCondition_ComparisonType") -Or
            ($_ -eq "Search-CONNContactFlow/StringCondition_ComparisonType") -Or
            ($_ -eq "Search-CONNContactFlowModule/StringCondition_ComparisonType") -Or
            ($_ -eq "Search-CONNEmailAddress/StringCondition_ComparisonType") -Or
            ($_ -eq "Search-CONNHoursOfOperation/StringCondition_ComparisonType") -Or
            ($_ -eq "Search-CONNHoursOfOperationOverride/StringCondition_ComparisonType") -Or
            ($_ -eq "Search-CONNPredefinedAttribute/StringCondition_ComparisonType") -Or
            ($_ -eq "Search-CONNPrompt/StringCondition_ComparisonType") -Or
            ($_ -eq "Search-CONNQueue/StringCondition_ComparisonType") -Or
            ($_ -eq "Search-CONNQuickConnect/StringCondition_ComparisonType") -Or
            ($_ -eq "Search-CONNRoutingProfile/StringCondition_ComparisonType") -Or
            ($_ -eq "Search-CONNSecurityProfile/StringCondition_ComparisonType") -Or
            ($_ -eq "Search-CONNUser/StringCondition_ComparisonType") -Or
            ($_ -eq "Search-CONNUserHierarchyGroup/StringCondition_ComparisonType") -Or
            ($_ -eq "Search-CONNResourceTag/TagSearchCondition_TagKeyComparisonType") -Or
            ($_ -eq "Search-CONNResourceTag/TagSearchCondition_TagValueComparisonType")
        }
        {
            $v = "CONTAINS","EXACT","STARTS_WITH"
            break
        }

        # Amazon.Connect.TargetListType
        "Search-CONNUser/ListCondition_TargetListType"
        {
            $v = "PROFICIENCIES"
            break
        }

        # Amazon.Connect.TaskTemplateStatus
        {
            ($_ -eq "Get-CONNTaskTemplateList/Status") -Or
            ($_ -eq "New-CONNTaskTemplate/Status") -Or
            ($_ -eq "Update-CONNTaskTemplate/Status")
        }
        {
            $v = "ACTIVE","INACTIVE"
            break
        }

        # Amazon.Connect.TrafficType
        {
            ($_ -eq "Send-CONNOutboundEmail/TrafficType") -Or
            ($_ -eq "Start-CONNOutboundVoiceContact/TrafficType")
        }
        {
            $v = "CAMPAIGN","GENERAL"
            break
        }

        # Amazon.Connect.UseCaseType
        "New-CONNUseCase/UseCaseType"
        {
            $v = "CONNECT_CAMPAIGNS","RULES_EVALUATION"
            break
        }

        # Amazon.Connect.VideoCapability
        {
            ($_ -eq "Start-CONNWebRTCContact/Agent_Video") -Or
            ($_ -eq "Start-CONNWebRTCContact/Customer_Video") -Or
            ($_ -eq "New-CONNParticipant/ParticipantCapabilities_Video")
        }
        {
            $v = "SEND"
            break
        }

        # Amazon.Connect.ViewStatus
        {
            ($_ -eq "New-CONNView/Status") -Or
            ($_ -eq "Update-CONNViewContent/Status")
        }
        {
            $v = "PUBLISHED","SAVED"
            break
        }

        # Amazon.Connect.ViewType
        "Get-CONNViewList/Type"
        {
            $v = "AWS_MANAGED","CUSTOMER_MANAGED"
            break
        }

        # Amazon.Connect.VocabularyLanguageCode
        {
            ($_ -eq "Add-CONNDefaultVocabulary/LanguageCode") -Or
            ($_ -eq "Get-CONNDefaultVocabularyList/LanguageCode") -Or
            ($_ -eq "New-CONNVocabulary/LanguageCode") -Or
            ($_ -eq "Search-CONNVocabulary/LanguageCode")
        }
        {
            $v = "ar-AE","ca-ES","da-DK","de-CH","de-DE","en-AB","en-AU","en-GB","en-IE","en-IN","en-NZ","en-US","en-WL","en-ZA","es-ES","es-US","fi-FI","fr-CA","fr-FR","hi-IN","id-ID","it-IT","ja-JP","ko-KR","ms-MY","nl-NL","no-NO","pl-PL","pt-BR","pt-PT","sv-SE","tl-PH","zh-CN"
            break
        }

        # Amazon.Connect.VocabularyState
        "Search-CONNVocabulary/State"
        {
            $v = "ACTIVE","CREATION_FAILED","CREATION_IN_PROGRESS","DELETE_IN_PROGRESS"
            break
        }

        # Amazon.Connect.VoiceRecordingTrack
        "Start-CONNContactRecording/VoiceRecordingConfiguration_VoiceRecordingTrack"
        {
            $v = "ALL","FROM_AGENT","TO_AGENT"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CONN_map = @{
    "AdditionalTimeRange_MatchType"=@("Search-CONNContact")
    "Agent_ScreenShare"=@("Start-CONNWebRTCContact")
    "Agent_Video"=@("Start-CONNWebRTCContact")
    "AgentAvailabilityTimer"=@("New-CONNRoutingProfile","Update-CONNRoutingProfileAgentAvailabilityTimer")
    "AttributeType"=@("Get-CONNInstanceAttribute","Update-CONNInstanceAttribute")
    "Channel"=@("New-CONNContact")
    "ContactConfiguration_ParticipantRole"=@("New-CONNPushNotificationRegistration")
    "ContactFlowModuleState"=@("Get-CONNContactFlowModuleList")
    "ContactFlowState"=@("Update-CONNContactFlowMetadata")
    "ContactRecordingType"=@("Resume-CONNContactRecording","Stop-CONNContactRecording","Suspend-CONNContactRecording")
    "Customer_ScreenShare"=@("Start-CONNWebRTCContact")
    "Customer_Video"=@("Start-CONNWebRTCContact")
    "CustomerEndpoint_Type"=@("Update-CONNContact")
    "DateCondition_ComparisonType"=@("Search-CONNHoursOfOperationOverride")
    "DestinationEndpoint_Type"=@("Start-CONNOutboundChatContact")
    "DeviceType"=@("New-CONNPushNotificationRegistration")
    "EmailMessage_MessageSourceType"=@("Send-CONNOutboundEmail","Start-CONNEmailContact","Start-CONNOutboundEmailContact")
    "Event_Type"=@("Send-CONNChatIntegrationEvent")
    "EventSourceName"=@("Get-CONNRuleList")
    "FileUseCaseType"=@("Start-CONNAttachedFileUpload")
    "HierarchyGroupCondition_HierarchyGroupMatchType"=@("Search-CONNUser")
    "IdentityManagementType"=@("New-CONNInstance")
    "InitiateAs"=@("New-CONNContact")
    "InitiationMethod"=@("New-CONNContact")
    "IntegrationType"=@("Get-CONNIntegrationAssociationList","New-CONNIntegrationAssociation")
    "Interval_IntervalPeriod"=@("Get-CONNMetricDataV2")
    "LanguageCode"=@("Add-CONNDefaultVocabulary","Get-CONNDefaultVocabularyList","New-CONNVocabulary","Search-CONNVocabulary")
    "LexVersion"=@("Get-CONNBotList")
    "ListCondition_TargetListType"=@("Search-CONNUser")
    "Name_MatchType"=@("Search-CONNContact")
    "OutboundStrategy_Type"=@("Start-CONNOutboundVoiceContact")
    "OutputType"=@("Get-CONNRealtimeContactAnalysisSegmentsV2List")
    "ParticipantCapabilities_ScreenShare"=@("New-CONNParticipant")
    "ParticipantCapabilities_Video"=@("New-CONNParticipant")
    "ParticipantDetails_ParticipantRole"=@("New-CONNParticipant")
    "PersistentChat_RehydrationType"=@("Start-CONNChatContact")
    "PhoneNumberCountryCode"=@("Search-CONNAvailablePhoneNumber")
    "PhoneNumberType"=@("Search-CONNAvailablePhoneNumber")
    "PublishStatus"=@("Get-CONNRuleList","New-CONNRule","Update-CONNRule")
    "QuickConnectConfig_QuickConnectType"=@("New-CONNQuickConnect","Update-CONNQuickConnectConfig")
    "RehydrationType"=@("New-CONNPersistentContactAssociation")
    "ResourceType"=@("Add-CONNFlow","Add-CONNInstanceStorageConfig","Get-CONNFlowAssociation","Get-CONNFlowAssociationBatch","Get-CONNFlowAssociationList","Get-CONNInstanceStorageConfig","Get-CONNInstanceStorageConfigList","Remove-CONNFlow","Remove-CONNInstanceStorageConfig","Update-CONNInstanceStorageConfig")
    "ScoringStrategy_Mode"=@("New-CONNEvaluationForm","Update-CONNEvaluationForm")
    "ScoringStrategy_Status"=@("New-CONNEvaluationForm","Update-CONNEvaluationForm")
    "SearchableContactAttributes_MatchType"=@("Search-CONNContact")
    "SearchableSegmentAttributes_MatchType"=@("Search-CONNContact")
    "SearchCriteria_QueueTypeCondition"=@("Search-CONNQueue")
    "SearchCriteria_StateCondition"=@("Search-CONNContactFlow","Search-CONNContactFlowModule")
    "SearchCriteria_StatusCondition"=@("Search-CONNContactFlow","Search-CONNContactFlowModule")
    "SearchCriteria_TypeCondition"=@("Search-CONNContactFlow")
    "SearchFilter_UserAttributeFilter_AndCondition_HierarchyGroupCondition_HierarchyGroupMatchType"=@("Search-CONNUser")
    "SearchFilter_UserAttributeFilter_HierarchyGroupCondition_HierarchyGroupMatchType"=@("Search-CONNUser")
    "Sort_FieldName"=@("Search-CONNContact")
    "Sort_Order"=@("Search-CONNContact")
    "SourceEndpoint_Type"=@("Start-CONNOutboundChatContact")
    "SourceType"=@("New-CONNIntegrationAssociation")
    "State"=@("New-CONNAgentStatus","Search-CONNVocabulary","Update-CONNAgentStatus","Update-CONNContactFlowModuleMetadata")
    "Status"=@("Get-CONNTaskTemplateList","New-CONNContactFlow","New-CONNTaskTemplate","New-CONNView","Update-CONNQueueStatus","Update-CONNTaskTemplate","Update-CONNViewContent")
    "StorageConfig_StorageType"=@("Add-CONNInstanceStorageConfig","Update-CONNInstanceStorageConfig")
    "StorageConfigKinesisVideoStreamConfigEncryptionConfigEncryptionType"=@("Add-CONNInstanceStorageConfig","Update-CONNInstanceStorageConfig")
    "StorageConfigS3ConfigEncryptionConfigEncryptionType"=@("Add-CONNInstanceStorageConfig","Update-CONNInstanceStorageConfig")
    "StringCondition_ComparisonType"=@("Search-CONNAgentStatus","Search-CONNContactFlow","Search-CONNContactFlowModule","Search-CONNEmailAddress","Search-CONNHoursOfOperation","Search-CONNHoursOfOperationOverride","Search-CONNPredefinedAttribute","Search-CONNPrompt","Search-CONNQueue","Search-CONNQuickConnect","Search-CONNRoutingProfile","Search-CONNSecurityProfile","Search-CONNUser","Search-CONNUserHierarchyGroup")
    "SystemEndpoint_Type"=@("Update-CONNContact")
    "TagSearchCondition_TagKeyComparisonType"=@("Search-CONNResourceTag")
    "TagSearchCondition_TagValueComparisonType"=@("Search-CONNResourceTag")
    "TimeRange_Type"=@("Search-CONNContact")
    "TrafficType"=@("Send-CONNOutboundEmail","Start-CONNOutboundVoiceContact")
    "Transcript_MatchType"=@("Search-CONNContact")
    "TriggerEventSource_EventSourceName"=@("New-CONNRule")
    "Type"=@("Get-CONNViewList","New-CONNContactFlow")
    "UseCaseType"=@("New-CONNUseCase")
    "VoiceRecordingConfiguration_IvrRecordingTrack"=@("Start-CONNContactRecording")
    "VoiceRecordingConfiguration_VoiceRecordingTrack"=@("Start-CONNContactRecording")
}

_awsArgumentCompleterRegistration $CONN_Completers $CONN_map

$CONN_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CONN.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CONN_SelectMap = @{
    "Select"=@("Enable-CONNEvaluationForm",
               "Register-CONNAnalyticsDataSet",
               "Add-CONNApprovedOrigin",
               "Add-CONNBot",
               "Join-CONNContactWithUser",
               "Add-CONNDefaultVocabulary",
               "Add-CONNEmailAddressAlias",
               "Add-CONNFlow",
               "Add-CONNInstanceStorageConfig",
               "Add-CONNLambdaFunction",
               "Add-CONNLexBot",
               "Add-CONNPhoneNumberContactFlow",
               "Add-CONNQueueQuickConnect",
               "Join-CONNRoutingProfileQueue",
               "Add-CONNSecurityKey",
               "Add-CONNTrafficDistributionGroupUser",
               "Add-CONNUserProficiency",
               "Register-CONNBatchAnalyticsDataSet",
               "Unregister-CONNBatchAnalyticsDataSet",
               "Get-CONNBatchAttachedFileMetadata",
               "Get-CONNFlowAssociationBatch",
               "Set-CONNBatchPutContact",
               "Request-CONNPhoneNumber",
               "Complete-CONNAttachedFileUpload",
               "New-CONNAgentStatus",
               "New-CONNContact",
               "New-CONNContactFlow",
               "New-CONNContactFlowModule",
               "New-CONNContactFlowVersion",
               "New-CONNEmailAddress",
               "New-CONNEvaluationForm",
               "New-CONNHoursOfOperation",
               "New-CONNHoursOfOperationOverride",
               "New-CONNInstance",
               "New-CONNIntegrationAssociation",
               "New-CONNParticipant",
               "New-CONNPersistentContactAssociation",
               "New-CONNPredefinedAttribute",
               "New-CONNPrompt",
               "New-CONNPushNotificationRegistration",
               "New-CONNQueue",
               "New-CONNQuickConnect",
               "New-CONNRoutingProfile",
               "New-CONNRule",
               "New-CONNSecurityProfile",
               "New-CONNTaskTemplate",
               "New-CONNTrafficDistributionGroup",
               "New-CONNUseCase",
               "New-CONNUser",
               "New-CONNUserHierarchyGroup",
               "New-CONNView",
               "New-CONNViewVersion",
               "New-CONNVocabulary",
               "Disable-CONNEvaluationForm",
               "Remove-CONNAttachedFile",
               "Remove-CONNContactEvaluation",
               "Remove-CONNContactFlow",
               "Remove-CONNContactFlowModule",
               "Remove-CONNContactFlowVersion",
               "Remove-CONNEmailAddress",
               "Remove-CONNEvaluationForm",
               "Remove-CONNHoursOfOperation",
               "Remove-CONNHoursOfOperationOverride",
               "Remove-CONNInstance",
               "Remove-CONNIntegrationAssociation",
               "Remove-CONNPredefinedAttribute",
               "Remove-CONNPrompt",
               "Remove-CONNPushNotificationRegistration",
               "Remove-CONNQueue",
               "Remove-CONNQuickConnect",
               "Remove-CONNRoutingProfile",
               "Remove-CONNRule",
               "Remove-CONNSecurityProfile",
               "Remove-CONNTaskTemplate",
               "Remove-CONNTrafficDistributionGroup",
               "Remove-CONNUseCase",
               "Remove-CONNUser",
               "Remove-CONNUserHierarchyGroup",
               "Remove-CONNView",
               "Remove-CONNViewVersion",
               "Remove-CONNVocabulary",
               "Get-CONNAgentStatus",
               "Get-CONNAuthenticationProfile",
               "Get-CONNContact",
               "Get-CONNContactEvaluation",
               "Get-CONNContactFlow",
               "Get-CONNContactFlowModule",
               "Get-CONNEmailAddress",
               "Get-CONNEvaluationForm",
               "Get-CONNHoursOfOperation",
               "Get-CONNHoursOfOperationOverride",
               "Get-CONNInstance",
               "Get-CONNInstanceAttribute",
               "Get-CONNInstanceStorageConfig",
               "Get-CONNPhoneNumber",
               "Get-CONNPredefinedAttribute",
               "Get-CONNPrompt",
               "Get-CONNQueue",
               "Get-CONNQuickConnect",
               "Get-CONNRoutingProfile",
               "Get-CONNRule",
               "Get-CONNSecurityProfile",
               "Get-CONNTrafficDistributionGroup",
               "Get-CONNUser",
               "Get-CONNUserHierarchyGroup",
               "Get-CONNUserHierarchyStructure",
               "Get-CONNView",
               "Get-CONNVocabulary",
               "Unregister-CONNAnalyticsDataSet",
               "Remove-CONNApprovedOrigin",
               "Remove-CONNBot",
               "Remove-CONNEmailAddressAlias",
               "Remove-CONNFlow",
               "Remove-CONNInstanceStorageConfig",
               "Remove-CONNLambdaFunction",
               "Remove-CONNLexBot",
               "Remove-CONNPhoneNumberContactFlow",
               "Remove-CONNQueueQuickConnect",
               "Disconnect-CONNRoutingProfileQueue",
               "Remove-CONNSecurityKey",
               "Remove-CONNTrafficDistributionGroupUser",
               "Remove-CONNUserProficiency",
               "Write-CONNUserContact",
               "Get-CONNAttachedFile",
               "Get-CONNContactAttribute",
               "Get-CONNContactMetric",
               "Get-CONNCurrentMetricData",
               "Get-CONNCurrentUserData",
               "Get-CONNEffectiveHoursOfOperation",
               "Get-CONNFederationToken",
               "Get-CONNFlowAssociation",
               "Get-CONNMetricData",
               "Get-CONNMetricDataV2",
               "Get-CONNPromptFile",
               "Get-CONNTaskTemplate",
               "Get-CONNTrafficDistribution",
               "Import-CONNPhoneNumber",
               "Get-CONNAgentStatusList",
               "Get-CONNAnalyticsDataAssociationList",
               "Get-CONNAnalyticsDataLakeDataSetList",
               "Get-CONNApprovedOriginList",
               "Get-CONNAssociatedContactList",
               "Get-CONNAuthenticationProfileList",
               "Get-CONNBotList",
               "Get-CONNContactEvaluationList",
               "Get-CONNContactFlowModuleList",
               "Get-CONNContactFlowList",
               "Get-CONNContactFlowVersionList",
               "Get-CONNContactReferenceList",
               "Get-CONNDefaultVocabularyList",
               "Get-CONNEvaluationFormList",
               "Get-CONNEvaluationFormVersionList",
               "Get-CONNFlowAssociationList",
               "Get-CONNHoursOfOperationOverrideList",
               "Get-CONNHoursOfOperationList",
               "Get-CONNInstanceAttributeList",
               "Get-CONNInstanceList",
               "Get-CONNInstanceStorageConfigList",
               "Get-CONNIntegrationAssociationList",
               "Get-CONNLambdaFunctionList",
               "Get-CONNLexBotList",
               "Get-CONNPhoneNumberList",
               "Get-CONNPhoneNumbersV2List",
               "Get-CONNPredefinedAttributeList",
               "Get-CONNPromptList",
               "Get-CONNQueueQuickConnectList",
               "Get-CONNQueueList",
               "Get-CONNQuickConnectList",
               "Get-CONNRealtimeContactAnalysisSegmentsV2List",
               "Get-CONNRoutingProfileManualAssignmentQueueList",
               "Get-CONNRoutingProfileQueueList",
               "Get-CONNRoutingProfileList",
               "Get-CONNRuleList",
               "Get-CONNSecurityKeyList",
               "Get-CONNSecurityProfileApplicationList",
               "Get-CONNSecurityProfilePermissionList",
               "Get-CONNSecurityProfileList",
               "Get-CONNResourceTag",
               "Get-CONNTaskTemplateList",
               "Get-CONNTrafficDistributionGroupList",
               "Get-CONNTrafficDistributionGroupUserList",
               "Get-CONNUseCaseList",
               "Get-CONNUserHierarchyGroupList",
               "Get-CONNUserProficiencyList",
               "Get-CONNUserList",
               "Get-CONNViewList",
               "Get-CONNViewVersionList",
               "Start-CONNContactMonitoring",
               "Invoke-CONNPauseContact",
               "Write-CONNUserStatus",
               "Remove-CONNPhoneNumber",
               "Copy-CONNInstance",
               "Invoke-CONNResumeContact",
               "Resume-CONNContactRecording",
               "Search-CONNAgentStatus",
               "Search-CONNAvailablePhoneNumber",
               "Search-CONNContactFlowModule",
               "Search-CONNContactFlow",
               "Search-CONNContact",
               "Search-CONNEmailAddress",
               "Search-CONNHoursOfOperationOverride",
               "Search-CONNHoursOfOperation",
               "Search-CONNPredefinedAttribute",
               "Search-CONNPrompt",
               "Search-CONNQueue",
               "Search-CONNQuickConnect",
               "Search-CONNResourceTag",
               "Search-CONNRoutingProfile",
               "Search-CONNSecurityProfile",
               "Search-CONNUserHierarchyGroup",
               "Search-CONNUser",
               "Search-CONNVocabulary",
               "Send-CONNChatIntegrationEvent",
               "Send-CONNOutboundEmail",
               "Start-CONNAttachedFileUpload",
               "Start-CONNChatContact",
               "Start-CONNContactEvaluation",
               "Start-CONNContactRecording",
               "Start-CONNContactStreaming",
               "Start-CONNEmailContact",
               "Start-CONNOutboundChatContact",
               "Start-CONNOutboundEmailContact",
               "Start-CONNOutboundVoiceContact",
               "Start-CONNScreenSharing",
               "Start-CONNTaskContact",
               "Start-CONNWebRTCContact",
               "Stop-CONNContact",
               "Stop-CONNContactRecording",
               "Stop-CONNContactStreaming",
               "Submit-CONNContactEvaluation",
               "Suspend-CONNContactRecording",
               "Add-CONNContactTag",
               "Add-CONNResourceTag",
               "Move-CONNContact",
               "Remove-CONNContactTag",
               "Remove-CONNResourceTag",
               "Update-CONNAgentStatus",
               "Update-CONNAuthenticationProfile",
               "Update-CONNContact",
               "Update-CONNContactAttribute",
               "Update-CONNContactEvaluation",
               "Update-CONNContactFlowContent",
               "Update-CONNContactFlowMetadata",
               "Update-CONNContactFlowModuleContent",
               "Update-CONNContactFlowModuleMetadata",
               "Update-CONNContactFlowName",
               "Update-CONNContactRoutingData",
               "Update-CONNContactSchedule",
               "Update-CONNEmailAddressMetadata",
               "Update-CONNEvaluationForm",
               "Update-CONNHoursOfOperation",
               "Update-CONNHoursOfOperationOverride",
               "Update-CONNInstanceAttribute",
               "Update-CONNInstanceStorageConfig",
               "Update-CONNParticipantAuthentication",
               "Update-CONNParticipantRoleConfig",
               "Update-CONNPhoneNumber",
               "Update-CONNPhoneNumberMetadata",
               "Update-CONNPredefinedAttribute",
               "Update-CONNPrompt",
               "Update-CONNQueueHoursOfOperation",
               "Update-CONNQueueMaxContact",
               "Update-CONNQueueName",
               "Update-CONNQueueOutboundCallerConfig",
               "Update-CONNQueueOutboundEmailConfig",
               "Update-CONNQueueStatus",
               "Update-CONNQuickConnectConfig",
               "Update-CONNQuickConnectName",
               "Update-CONNRoutingProfileAgentAvailabilityTimer",
               "Update-CONNRoutingProfileConcurrency",
               "Update-CONNRoutingProfileDefaultOutboundQueue",
               "Update-CONNRoutingProfileName",
               "Update-CONNRoutingProfileQueue",
               "Update-CONNRule",
               "Update-CONNSecurityProfile",
               "Update-CONNTaskTemplate",
               "Update-CONNTrafficDistribution",
               "Update-CONNUserHierarchy",
               "Update-CONNUserHierarchyGroupName",
               "Update-CONNUserHierarchyStructure",
               "Update-CONNUserIdentityInfo",
               "Update-CONNUserPhoneConfig",
               "Update-CONNUserProficiency",
               "Update-CONNUserRoutingProfile",
               "Update-CONNUserSecurityProfile",
               "Update-CONNViewContent",
               "Update-CONNViewMetadata")
}

_awsArgumentCompleterRegistration $CONN_SelectCompleters $CONN_SelectMap
# Argument completions for service Amazon Connect Campaign Service


$CCS_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ConnectCampaignService.EncryptionType
        "Start-CCSInstanceOnboardingJob/EncryptionConfig_EncryptionType"
        {
            $v = "KMS"
            break
        }

        # Amazon.ConnectCampaignService.InstanceIdFilterOperator
        "Get-CCSCampaignList/InstanceIdFilter_Operator"
        {
            $v = "Eq"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CCS_map = @{
    "EncryptionConfig_EncryptionType"=@("Start-CCSInstanceOnboardingJob")
    "InstanceIdFilter_Operator"=@("Get-CCSCampaignList")
}

_awsArgumentCompleterRegistration $CCS_Completers $CCS_map

$CCS_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CCS.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CCS_SelectMap = @{
    "Select"=@("New-CCSCampaign",
               "Remove-CCSCampaign",
               "Remove-CCSConnectInstanceConfig",
               "Remove-CCSInstanceOnboardingJob",
               "Get-CCSCampaign",
               "Get-CCSCampaignState",
               "Get-CCSCampaignStateBatch",
               "Get-CCSConnectInstanceConfig",
               "Get-CCSInstanceOnboardingJobStatus",
               "Get-CCSCampaignList",
               "Get-CCSResourceTag",
               "Suspend-CCSCampaign",
               "Write-CCSDialRequestBatch",
               "Resume-CCSCampaign",
               "Start-CCSCampaign",
               "Start-CCSInstanceOnboardingJob",
               "Stop-CCSCampaign",
               "Add-CCSResourceTag",
               "Remove-CCSResourceTag",
               "Update-CCSCampaignDialerConfig",
               "Update-CCSCampaignName",
               "Update-CCSCampaignOutboundCallConfig")
}

_awsArgumentCompleterRegistration $CCS_SelectCompleters $CCS_SelectMap
# Argument completions for service AmazonConnectCampaignServiceV2


$CCS2_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ConnectCampaignsV2.CampaignDeletionPolicy
        "Remove-CCS2ConnectInstanceConfig/CampaignDeletionPolicy"
        {
            $v = "DELETE_ALL","RETAIN_ALL"
            break
        }

        # Amazon.ConnectCampaignsV2.ChannelSubtype
        "Remove-CCS2CampaignChannelSubtypeConfig/ChannelSubtype"
        {
            $v = "EMAIL","SMS","TELEPHONY"
            break
        }

        # Amazon.ConnectCampaignsV2.CommunicationLimitsConfigType
        "Remove-CCS2CampaignCommunicationLimit/Config"
        {
            $v = "ALL_CHANNEL_SUBTYPES"
            break
        }

        # Amazon.ConnectCampaignsV2.CommunicationTimeConfigType
        "Remove-CCS2CampaignCommunicationTime/Config"
        {
            $v = "EMAIL","SMS","TELEPHONY"
            break
        }

        # Amazon.ConnectCampaignsV2.EncryptionType
        "Start-CCS2InstanceOnboardingJob/EncryptionConfig_EncryptionType"
        {
            $v = "KMS"
            break
        }

        # Amazon.ConnectCampaignsV2.InstanceIdFilterOperator
        "Get-CCS2CampaignList/InstanceIdFilter_Operator"
        {
            $v = "Eq"
            break
        }

        # Amazon.ConnectCampaignsV2.InstanceLimitsHandling
        {
            ($_ -eq "New-CCS2Campaign/CommunicationLimitsOverride_InstanceLimitsHandling") -Or
            ($_ -eq "Update-CCS2CampaignCommunicationLimit/CommunicationLimitsOverride_InstanceLimitsHandling")
        }
        {
            $v = "OPT_IN","OPT_OUT"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CCS2_map = @{
    "CampaignDeletionPolicy"=@("Remove-CCS2ConnectInstanceConfig")
    "ChannelSubtype"=@("Remove-CCS2CampaignChannelSubtypeConfig")
    "CommunicationLimitsOverride_InstanceLimitsHandling"=@("New-CCS2Campaign","Update-CCS2CampaignCommunicationLimit")
    "Config"=@("Remove-CCS2CampaignCommunicationLimit","Remove-CCS2CampaignCommunicationTime")
    "EncryptionConfig_EncryptionType"=@("Start-CCS2InstanceOnboardingJob")
    "InstanceIdFilter_Operator"=@("Get-CCS2CampaignList")
}

_awsArgumentCompleterRegistration $CCS2_Completers $CCS2_map

$CCS2_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CCS2.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CCS2_SelectMap = @{
    "Select"=@("New-CCS2Campaign",
               "Remove-CCS2Campaign",
               "Remove-CCS2CampaignChannelSubtypeConfig",
               "Remove-CCS2CampaignCommunicationLimit",
               "Remove-CCS2CampaignCommunicationTime",
               "Remove-CCS2ConnectInstanceConfig",
               "Remove-CCS2ConnectInstanceIntegration",
               "Remove-CCS2InstanceOnboardingJob",
               "Get-CCS2Campaign",
               "Get-CCS2CampaignState",
               "Get-CCS2CampaignStateBatch",
               "Get-CCS2ConnectInstanceConfig",
               "Get-CCS2InstanceCommunicationLimit",
               "Get-CCS2InstanceOnboardingJobStatus",
               "Get-CCS2CampaignList",
               "Get-CCS2ConnectInstanceIntegrationList",
               "Get-CCS2ResourceTag",
               "Suspend-CCS2Campaign",
               "Write-CCS2ConnectInstanceIntegration",
               "Write-CCS2InstanceCommunicationLimit",
               "Write-CCS2OutboundRequestBatch",
               "Write-CCS2ProfileOutboundRequestBatch",
               "Resume-CCS2Campaign",
               "Start-CCS2Campaign",
               "Start-CCS2InstanceOnboardingJob",
               "Stop-CCS2Campaign",
               "Add-CCS2ResourceTag",
               "Remove-CCS2ResourceTag",
               "Update-CCS2CampaignChannelSubtypeConfig",
               "Update-CCS2CampaignCommunicationLimit",
               "Update-CCS2CampaignCommunicationTime",
               "Update-CCS2CampaignFlowAssociation",
               "Update-CCS2CampaignName",
               "Update-CCS2CampaignSchedule",
               "Update-CCS2CampaignSource")
}

_awsArgumentCompleterRegistration $CCS2_SelectCompleters $CCS2_SelectMap
# Argument completions for service Amazon Connect Cases


$CCAS_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ConnectCases.CommentBodyTextType
        "New-CCASRelatedItem/Comment_ContentType"
        {
            $v = "Text/Plain"
            break
        }

        # Amazon.ConnectCases.FieldType
        "New-CCASField/Type"
        {
            $v = "Boolean","DateTime","Number","SingleSelect","Text","Url","User"
            break
        }

        # Amazon.ConnectCases.RelatedItemType
        "New-CCASRelatedItem/Type"
        {
            $v = "Comment","ConnectCase","Contact","Custom","File","Sla"
            break
        }

        # Amazon.ConnectCases.SlaType
        "New-CCASRelatedItem/SlaInputConfiguration_Type"
        {
            $v = "CaseField"
            break
        }

        # Amazon.ConnectCases.TemplateStatus
        {
            ($_ -eq "New-CCASTemplate/Status") -Or
            ($_ -eq "Update-CCASTemplate/Status")
        }
        {
            $v = "Active","Inactive"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CCAS_map = @{
    "Comment_ContentType"=@("New-CCASRelatedItem")
    "SlaInputConfiguration_Type"=@("New-CCASRelatedItem")
    "Status"=@("New-CCASTemplate","Update-CCASTemplate")
    "Type"=@("New-CCASField","New-CCASRelatedItem")
}

_awsArgumentCompleterRegistration $CCAS_Completers $CCAS_map

$CCAS_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CCAS.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CCAS_SelectMap = @{
    "Select"=@("Group-CCASGetCaseRule",
               "Group-CCASGetField",
               "Group-CCASPutFieldOption",
               "New-CCASCase",
               "New-CCASCaseRule",
               "New-CCASDomain",
               "New-CCASField",
               "New-CCASLayout",
               "New-CCASRelatedItem",
               "New-CCASTemplate",
               "Remove-CCASCase",
               "Remove-CCASCaseRule",
               "Remove-CCASDomain",
               "Remove-CCASField",
               "Remove-CCASLayout",
               "Remove-CCASRelatedItem",
               "Remove-CCASTemplate",
               "Get-CCASCase",
               "Get-CCASCaseAuditEvent",
               "Get-CCASCaseEventConfiguration",
               "Get-CCASDomain",
               "Get-CCASLayout",
               "Get-CCASTemplate",
               "Get-CCASCaseRuleList",
               "Get-CCASCasesForContactList",
               "Get-CCASDomainList",
               "Get-CCASFieldOptionList",
               "Get-CCASFieldList",
               "Get-CCASLayoutList",
               "Get-CCASResourceTag",
               "Get-CCASTemplateList",
               "Write-CCASCaseEventConfiguration",
               "Search-CCASAllRelatedItem",
               "Search-CCASCase",
               "Search-CCASRelatedItem",
               "Add-CCASResourceTag",
               "Remove-CCASResourceTag",
               "Update-CCASCase",
               "Update-CCASCaseRule",
               "Update-CCASField",
               "Update-CCASLayout",
               "Update-CCASTemplate")
}

_awsArgumentCompleterRegistration $CCAS_SelectCompleters $CCAS_SelectMap
# Argument completions for service Amazon Connect Participant Service


$CONNP_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ConnectParticipant.ScanDirection
        "Get-CONNPTranscript/ScanDirection"
        {
            $v = "BACKWARD","FORWARD"
            break
        }

        # Amazon.ConnectParticipant.SortKey
        "Get-CONNPTranscript/SortOrder"
        {
            $v = "ASCENDING","DESCENDING"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CONNP_map = @{
    "ScanDirection"=@("Get-CONNPTranscript")
    "SortOrder"=@("Get-CONNPTranscript")
}

_awsArgumentCompleterRegistration $CONNP_Completers $CONNP_map

$CONNP_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CONNP.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CONNP_SelectMap = @{
    "Select"=@("Stop-CONNPParticipantAuthentication",
               "Complete-CONNPAttachmentUpload",
               "New-CONNPParticipantConnection",
               "Get-CONNPView",
               "Disconnect-CONNPParticipant",
               "Get-CONNPAttachment",
               "Get-CONNPAuthenticationUrl",
               "Get-CONNPTranscript",
               "Send-CONNPEvent",
               "Send-CONNPMessage",
               "Start-CONNPAttachmentUpload")
}

_awsArgumentCompleterRegistration $CONNP_SelectCompleters $CONNP_SelectMap
# Argument completions for service AWS Control Catalog


$CLCAT_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CLCAT.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CLCAT_SelectMap = @{
    "Select"=@("Get-CLCATControl",
               "Get-CLCATCommonControlList",
               "Get-CLCATControlMappingList",
               "Get-CLCATControlList",
               "Get-CLCATDomainList",
               "Get-CLCATObjectiveList")
}

_awsArgumentCompleterRegistration $CLCAT_SelectCompleters $CLCAT_SelectMap
# Argument completions for service AWS Control Tower


$ACT_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.ACT.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ACT_SelectMap = @{
    "Select"=@("New-ACTLandingZone",
               "Remove-ACTLandingZone",
               "Disable-ACTBaseline",
               "Disable-ACTControl",
               "Enable-ACTBaseline",
               "Enable-ACTControl",
               "Get-ACTBaseline",
               "Get-ACTBaselineOperation",
               "Get-ACTControlOperation",
               "Get-ACTEnabledBaseline",
               "Get-ACTEnabledControl",
               "Get-ACTLandingZone",
               "Get-ACTLandingZoneOperation",
               "Get-ACTBaselineList",
               "Get-ACTControlOperationList",
               "Get-ACTEnabledBaselineList",
               "Get-ACTEnabledControlList",
               "Get-ACTLandingZoneOperationList",
               "Get-ACTLandingZoneList",
               "Get-ACTResourceTag",
               "Reset-ACTEnabledBaseline",
               "Reset-ACTEnabledControl",
               "Reset-ACTLandingZone",
               "Add-ACTResourceTag",
               "Remove-ACTResourceTag",
               "Update-ACTEnabledBaseline",
               "Update-ACTEnabledControl",
               "Update-ACTLandingZone")
}

_awsArgumentCompleterRegistration $ACT_SelectCompleters $ACT_SelectMap
# Argument completions for service Cost Optimization Hub


$COH_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CostOptimizationHub.EnrollmentStatus
        "Update-COHEnrollmentStatus/Status"
        {
            $v = "Active","Inactive"
            break
        }

        # Amazon.CostOptimizationHub.MemberAccountDiscountVisibility
        "Update-COHPreference/MemberAccountDiscountVisibility"
        {
            $v = "All","None"
            break
        }

        # Amazon.CostOptimizationHub.Order
        "Get-COHRecommendationList/OrderBy_Order"
        {
            $v = "Asc","Desc"
            break
        }

        # Amazon.CostOptimizationHub.PaymentOption
        "Update-COHPreference/PreferredCommitment_PaymentOption"
        {
            $v = "AllUpfront","NoUpfront","PartialUpfront"
            break
        }

        # Amazon.CostOptimizationHub.SavingsEstimationMode
        "Update-COHPreference/SavingsEstimationMode"
        {
            $v = "AfterDiscounts","BeforeDiscounts"
            break
        }

        # Amazon.CostOptimizationHub.Term
        "Update-COHPreference/PreferredCommitment_Term"
        {
            $v = "OneYear","ThreeYears"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$COH_map = @{
    "MemberAccountDiscountVisibility"=@("Update-COHPreference")
    "OrderBy_Order"=@("Get-COHRecommendationList")
    "PreferredCommitment_PaymentOption"=@("Update-COHPreference")
    "PreferredCommitment_Term"=@("Update-COHPreference")
    "SavingsEstimationMode"=@("Update-COHPreference")
    "Status"=@("Update-COHEnrollmentStatus")
}

_awsArgumentCompleterRegistration $COH_Completers $COH_map

$COH_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.COH.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$COH_SelectMap = @{
    "Select"=@("Get-COHPreference",
               "Get-COHRecommendation",
               "Get-COHEnrollmentStatusList",
               "Get-COHRecommendationList",
               "Get-COHRecommendationSummaryList",
               "Update-COHEnrollmentStatus",
               "Update-COHPreference")
}

_awsArgumentCompleterRegistration $COH_SelectCompleters $COH_SelectMap
# Argument completions for service AWS Cost and Usage Report


$CUR_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CostAndUsageReport.AWSRegion
        {
            ($_ -eq "Edit-CURReportDefinition/ReportDefinition_S3Region") -Or
            ($_ -eq "Write-CURReportDefinition/ReportDefinition_S3Region")
        }
        {
            $v = "af-south-1","ap-east-1","ap-northeast-1","ap-northeast-2","ap-northeast-3","ap-south-1","ap-south-2","ap-southeast-1","ap-southeast-2","ap-southeast-3","ca-central-1","cn-north-1","cn-northwest-1","eu-central-1","eu-central-2","eu-north-1","eu-south-1","eu-south-2","eu-west-1","eu-west-2","eu-west-3","me-central-1","me-south-1","sa-east-1","us-east-1","us-east-2","us-west-1","us-west-2"
            break
        }

        # Amazon.CostAndUsageReport.CompressionFormat
        {
            ($_ -eq "Edit-CURReportDefinition/ReportDefinition_Compression") -Or
            ($_ -eq "Write-CURReportDefinition/ReportDefinition_Compression")
        }
        {
            $v = "GZIP","Parquet","ZIP"
            break
        }

        # Amazon.CostAndUsageReport.LastStatus
        {
            ($_ -eq "Edit-CURReportDefinition/ReportStatus_LastStatus") -Or
            ($_ -eq "Write-CURReportDefinition/ReportStatus_LastStatus")
        }
        {
            $v = "ERROR_NO_BUCKET","ERROR_PERMISSIONS","SUCCESS"
            break
        }

        # Amazon.CostAndUsageReport.ReportFormat
        {
            ($_ -eq "Edit-CURReportDefinition/ReportDefinition_Format") -Or
            ($_ -eq "Write-CURReportDefinition/ReportDefinition_Format")
        }
        {
            $v = "Parquet","textORcsv"
            break
        }

        # Amazon.CostAndUsageReport.ReportVersioning
        {
            ($_ -eq "Edit-CURReportDefinition/ReportDefinition_ReportVersioning") -Or
            ($_ -eq "Write-CURReportDefinition/ReportDefinition_ReportVersioning")
        }
        {
            $v = "CREATE_NEW_REPORT","OVERWRITE_REPORT"
            break
        }

        # Amazon.CostAndUsageReport.TimeUnit
        {
            ($_ -eq "Edit-CURReportDefinition/ReportDefinition_TimeUnit") -Or
            ($_ -eq "Write-CURReportDefinition/ReportDefinition_TimeUnit")
        }
        {
            $v = "DAILY","HOURLY","MONTHLY"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CUR_map = @{
    "ReportDefinition_Compression"=@("Edit-CURReportDefinition","Write-CURReportDefinition")
    "ReportDefinition_Format"=@("Edit-CURReportDefinition","Write-CURReportDefinition")
    "ReportDefinition_ReportVersioning"=@("Edit-CURReportDefinition","Write-CURReportDefinition")
    "ReportDefinition_S3Region"=@("Edit-CURReportDefinition","Write-CURReportDefinition")
    "ReportDefinition_TimeUnit"=@("Edit-CURReportDefinition","Write-CURReportDefinition")
    "ReportStatus_LastStatus"=@("Edit-CURReportDefinition","Write-CURReportDefinition")
}

_awsArgumentCompleterRegistration $CUR_Completers $CUR_map

$CUR_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CUR.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CUR_SelectMap = @{
    "Select"=@("Remove-CURReportDefinition",
               "Get-CURReportDefinition",
               "Get-CURResourceTag",
               "Edit-CURReportDefinition",
               "Write-CURReportDefinition",
               "Add-CURResourceTag",
               "Remove-CURResourceTag")
}

_awsArgumentCompleterRegistration $CUR_SelectCompleters $CUR_SelectMap
# Argument completions for service Amazon Connect Customer Profiles


$CPF_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.CustomerProfiles.ActionType
        "Get-CPFProfileHistoryRecordList/ActionType"
        {
            $v = "ADDED_PROFILE_KEY","CREATED","DELETED_BY_CUSTOMER","DELETED_BY_MERGE","DELETED_PROFILE_KEY","EXPIRED","INGESTED","MERGED","UPDATED"
            break
        }

        # Amazon.CustomerProfiles.AttributeMatchingModel
        {
            ($_ -eq "New-CPFDomain/AttributeTypesSelector_AttributeMatchingModel") -Or
            ($_ -eq "Update-CPFDomain/AttributeTypesSelector_AttributeMatchingModel")
        }
        {
            $v = "MANY_TO_MANY","ONE_TO_ONE"
            break
        }

        # Amazon.CustomerProfiles.ConflictResolvingModel
        {
            ($_ -eq "Get-CPFAutoMergingPreview/ConflictResolution_ConflictResolvingModel") -Or
            ($_ -eq "New-CPFDomain/ConflictResolution_ConflictResolvingModel") -Or
            ($_ -eq "Update-CPFDomain/ConflictResolution_ConflictResolvingModel") -Or
            ($_ -eq "New-CPFDomain/RuleBasedMatching_ConflictResolution_ConflictResolvingModel") -Or
            ($_ -eq "Update-CPFDomain/RuleBasedMatching_ConflictResolution_ConflictResolvingModel")
        }
        {
            $v = "RECENCY","SOURCE"
            break
        }

        # Amazon.CustomerProfiles.DataFormat
        "New-CPFSegmentSnapshot/DataFormat"
        {
            $v = "CSV","JSONL","ORC"
            break
        }

        # Amazon.CustomerProfiles.DataPullMode
        {
            ($_ -eq "New-CPFIntegrationWorkflow/Scheduled_DataPullMode") -Or
            ($_ -eq "Write-CPFIntegration/Scheduled_DataPullMode")
        }
        {
            $v = "Complete","Incremental"
            break
        }

        # Amazon.CustomerProfiles.Gender
        {
            ($_ -eq "New-CPFProfile/Gender") -Or
            ($_ -eq "Update-CPFProfile/Gender")
        }
        {
            $v = "FEMALE","MALE","UNSPECIFIED"
            break
        }

        # Amazon.CustomerProfiles.Include
        "New-CPFCalculatedAttributeDefinition/Filter_Include"
        {
            $v = "ALL","ANY","NONE"
            break
        }

        # Amazon.CustomerProfiles.IncludeOptions
        {
            ($_ -eq "New-CPFSegmentDefinition/SegmentGroups_Include") -Or
            ($_ -eq "New-CPFSegmentEstimate/SegmentQuery_Include")
        }
        {
            $v = "ALL","ANY","NONE"
            break
        }

        # Amazon.CustomerProfiles.JobScheduleDayOfTheWeek
        {
            ($_ -eq "New-CPFDomain/JobSchedule_DayOfTheWeek") -Or
            ($_ -eq "Update-CPFDomain/JobSchedule_DayOfTheWeek")
        }
        {
            $v = "FRIDAY","MONDAY","SATURDAY","SUNDAY","THURSDAY","TUESDAY","WEDNESDAY"
            break
        }

        # Amazon.CustomerProfiles.LayoutType
        {
            ($_ -eq "New-CPFDomainLayout/LayoutType") -Or
            ($_ -eq "Update-CPFDomainLayout/LayoutType")
        }
        {
            $v = "PROFILE_EXPLORER"
            break
        }

        # Amazon.CustomerProfiles.LogicalOperator
        "Search-CPFProfile/LogicalOperator"
        {
            $v = "AND","OR"
            break
        }

        # Amazon.CustomerProfiles.MatchType
        "Get-CPFSimilarProfile/MatchType"
        {
            $v = "ML_BASED_MATCHING","RULE_BASED_MATCHING"
            break
        }

        # Amazon.CustomerProfiles.Operator
        {
            ($_ -eq "New-CPFCalculatedAttributeDefinition/Threshold_Operator") -Or
            ($_ -eq "Update-CPFCalculatedAttributeDefinition/Threshold_Operator")
        }
        {
            $v = "EQUAL_TO","GREATER_THAN","LESS_THAN","NOT_EQUAL_TO"
            break
        }

        # Amazon.CustomerProfiles.PartyType
        {
            ($_ -eq "New-CPFProfile/PartyType") -Or
            ($_ -eq "Update-CPFProfile/PartyType")
        }
        {
            $v = "BUSINESS","INDIVIDUAL","OTHER"
            break
        }

        # Amazon.CustomerProfiles.ProfileType
        {
            ($_ -eq "New-CPFProfile/ProfileType") -Or
            ($_ -eq "Update-CPFProfile/ProfileType")
        }
        {
            $v = "ACCOUNT_PROFILE","PROFILE"
            break
        }

        # Amazon.CustomerProfiles.RangeUnit
        "Get-CPFGetCalculatedAttributeForProfile/Range_Unit"
        {
            $v = "DAYS"
            break
        }

        # Amazon.CustomerProfiles.SourceConnectorType
        {
            ($_ -eq "New-CPFIntegrationWorkflow/SourceFlowConfig_ConnectorType") -Or
            ($_ -eq "Write-CPFIntegration/SourceFlowConfig_ConnectorType")
        }
        {
            $v = "Marketo","S3","Salesforce","Servicenow","Zendesk"
            break
        }

        # Amazon.CustomerProfiles.Statistic
        "New-CPFCalculatedAttributeDefinition/Statistic"
        {
            $v = "AVERAGE","COUNT","FIRST_OCCURRENCE","LAST_OCCURRENCE","MAXIMUM","MAX_OCCURRENCE","MINIMUM","SUM"
            break
        }

        # Amazon.CustomerProfiles.Status
        "Get-CPFWorkflowList/Status"
        {
            $v = "CANCELLED","COMPLETE","FAILED","IN_PROGRESS","NOT_STARTED","RETRY","SPLIT"
            break
        }

        # Amazon.CustomerProfiles.TriggerType
        {
            ($_ -eq "New-CPFIntegrationWorkflow/TriggerConfig_TriggerType") -Or
            ($_ -eq "Write-CPFIntegration/TriggerConfig_TriggerType")
        }
        {
            $v = "Event","OnDemand","Scheduled"
            break
        }

        # Amazon.CustomerProfiles.Unit
        {
            ($_ -eq "New-CPFCalculatedAttributeDefinition/Range_Unit") -Or
            ($_ -eq "Update-CPFCalculatedAttributeDefinition/Range_Unit")
        }
        {
            $v = "DAYS"
            break
        }

        # Amazon.CustomerProfiles.WorkflowType
        {
            ($_ -eq "Get-CPFWorkflowList/WorkflowType") -Or
            ($_ -eq "New-CPFIntegrationWorkflow/WorkflowType")
        }
        {
            $v = "APPFLOW_INTEGRATION"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CPF_map = @{
    "ActionType"=@("Get-CPFProfileHistoryRecordList")
    "AttributeTypesSelector_AttributeMatchingModel"=@("New-CPFDomain","Update-CPFDomain")
    "ConflictResolution_ConflictResolvingModel"=@("Get-CPFAutoMergingPreview","New-CPFDomain","Update-CPFDomain")
    "DataFormat"=@("New-CPFSegmentSnapshot")
    "Filter_Include"=@("New-CPFCalculatedAttributeDefinition")
    "Gender"=@("New-CPFProfile","Update-CPFProfile")
    "JobSchedule_DayOfTheWeek"=@("New-CPFDomain","Update-CPFDomain")
    "LayoutType"=@("New-CPFDomainLayout","Update-CPFDomainLayout")
    "LogicalOperator"=@("Search-CPFProfile")
    "MatchType"=@("Get-CPFSimilarProfile")
    "PartyType"=@("New-CPFProfile","Update-CPFProfile")
    "ProfileType"=@("New-CPFProfile","Update-CPFProfile")
    "Range_Unit"=@("Get-CPFGetCalculatedAttributeForProfile","New-CPFCalculatedAttributeDefinition","Update-CPFCalculatedAttributeDefinition")
    "RuleBasedMatching_ConflictResolution_ConflictResolvingModel"=@("New-CPFDomain","Update-CPFDomain")
    "Scheduled_DataPullMode"=@("New-CPFIntegrationWorkflow","Write-CPFIntegration")
    "SegmentGroups_Include"=@("New-CPFSegmentDefinition")
    "SegmentQuery_Include"=@("New-CPFSegmentEstimate")
    "SourceFlowConfig_ConnectorType"=@("New-CPFIntegrationWorkflow","Write-CPFIntegration")
    "Statistic"=@("New-CPFCalculatedAttributeDefinition")
    "Status"=@("Get-CPFWorkflowList")
    "Threshold_Operator"=@("New-CPFCalculatedAttributeDefinition","Update-CPFCalculatedAttributeDefinition")
    "TriggerConfig_TriggerType"=@("New-CPFIntegrationWorkflow","Write-CPFIntegration")
    "WorkflowType"=@("Get-CPFWorkflowList","New-CPFIntegrationWorkflow")
}

_awsArgumentCompleterRegistration $CPF_Completers $CPF_map

$CPF_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.CPF.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$CPF_SelectMap = @{
    "Select"=@("Add-CPFProfileKey",
               "Get-CPFGetCalculatedAttributeForProfile",
               "Get-CPFGetProfile",
               "New-CPFCalculatedAttributeDefinition",
               "New-CPFDomain",
               "New-CPFDomainLayout",
               "New-CPFEventStream",
               "New-CPFEventTrigger",
               "New-CPFIntegrationWorkflow",
               "New-CPFProfile",
               "New-CPFSegmentDefinition",
               "New-CPFSegmentEstimate",
               "New-CPFSegmentSnapshot",
               "New-CPFUploadJob",
               "Remove-CPFCalculatedAttributeDefinition",
               "Remove-CPFDomain",
               "Remove-CPFDomainLayout",
               "Remove-CPFEventStream",
               "Remove-CPFEventTrigger",
               "Remove-CPFIntegration",
               "Remove-CPFProfile",
               "Remove-CPFProfileKey",
               "Remove-CPFProfileObject",
               "Remove-CPFProfileObjectType",
               "Remove-CPFSegmentDefinition",
               "Remove-CPFWorkflow",
               "Find-CPFProfileObjectType",
               "Get-CPFAutoMergingPreview",
               "Get-CPFCalculatedAttributeDefinition",
               "Get-CPFCalculatedAttributeForProfile",
               "Get-CPFDomain",
               "Get-CPFDomainLayout",
               "Get-CPFEventStream",
               "Get-CPFEventTrigger",
               "Get-CPFIdentityResolutionJob",
               "Get-CPFIntegration",
               "Get-CPFMatch",
               "Get-CPFProfileHistoryRecord",
               "Get-CPFProfileObjectType",
               "Get-CPFProfileObjectTypeTemplate",
               "Get-CPFSegmentDefinition",
               "Get-CPFSegmentEstimate",
               "Get-CPFSegmentMembership",
               "Get-CPFSegmentSnapshot",
               "Get-CPFSimilarProfile",
               "Get-CPFUploadJob",
               "Get-CPFUploadJobPath",
               "Get-CPFWorkflow",
               "Get-CPFWorkflowStep",
               "Get-CPFAccountIntegrationList",
               "Get-CPFCalculatedAttributeDefinitionList",
               "Get-CPFCalculatedAttributesForProfileList",
               "Get-CPFDomainLayoutList",
               "Get-CPFDomainList",
               "Get-CPFEventStreamList",
               "Get-CPFEventTriggerList",
               "Get-CPFIdentityResolutionJobList",
               "Get-CPFIntegrationList",
               "Get-CPFObjectTypeAttributeList",
               "Get-CPFProfileAttributeValueList",
               "Get-CPFProfileHistoryRecordList",
               "Get-CPFProfileObjectList",
               "Get-CPFProfileObjectTypeList",
               "Get-CPFProfileObjectTypeTemplateList",
               "Get-CPFRuleBasedMatchList",
               "Get-CPFSegmentDefinitionList",
               "Get-CPFResourceTag",
               "Get-CPFUploadJobList",
               "Get-CPFWorkflowList",
               "Merge-CPFProfile",
               "Write-CPFIntegration",
               "Write-CPFProfileObject",
               "Write-CPFProfileObjectType",
               "Search-CPFProfile",
               "Start-CPFUploadJob",
               "Stop-CPFUploadJob",
               "Add-CPFResourceTag",
               "Remove-CPFResourceTag",
               "Update-CPFCalculatedAttributeDefinition",
               "Update-CPFDomain",
               "Update-CPFDomainLayout",
               "Update-CPFEventTrigger",
               "Update-CPFProfile")
}

_awsArgumentCompleterRegistration $CPF_SelectCompleters $CPF_SelectMap
# Argument completions for service AWS Glue DataBrew


$GDB_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.GlueDataBrew.AnalyticsMode
        "Send-GDBProjectSessionAction/ViewFrame_Analytic"
        {
            $v = "DISABLE","ENABLE"
            break
        }

        # Amazon.GlueDataBrew.EncryptionMode
        {
            ($_ -eq "New-GDBProfileJob/EncryptionMode") -Or
            ($_ -eq "New-GDBRecipeJob/EncryptionMode") -Or
            ($_ -eq "Update-GDBProfileJob/EncryptionMode") -Or
            ($_ -eq "Update-GDBRecipeJob/EncryptionMode")
        }
        {
            $v = "SSE-KMS","SSE-S3"
            break
        }

        # Amazon.GlueDataBrew.InputFormat
        {
            ($_ -eq "New-GDBDataset/Format") -Or
            ($_ -eq "Update-GDBDataset/Format")
        }
        {
            $v = "CSV","EXCEL","JSON","ORC","PARQUET"
            break
        }

        # Amazon.GlueDataBrew.LogSubscription
        {
            ($_ -eq "New-GDBProfileJob/LogSubscription") -Or
            ($_ -eq "New-GDBRecipeJob/LogSubscription") -Or
            ($_ -eq "Update-GDBProfileJob/LogSubscription") -Or
            ($_ -eq "Update-GDBRecipeJob/LogSubscription")
        }
        {
            $v = "DISABLE","ENABLE"
            break
        }

        # Amazon.GlueDataBrew.Order
        {
            ($_ -eq "New-GDBDataset/FilesLimit_Order") -Or
            ($_ -eq "Update-GDBDataset/FilesLimit_Order")
        }
        {
            $v = "ASCENDING","DESCENDING"
            break
        }

        # Amazon.GlueDataBrew.OrderedBy
        {
            ($_ -eq "New-GDBDataset/FilesLimit_OrderedBy") -Or
            ($_ -eq "Update-GDBDataset/FilesLimit_OrderedBy")
        }
        {
            $v = "LAST_MODIFIED_DATE"
            break
        }

        # Amazon.GlueDataBrew.SampleMode
        {
            ($_ -eq "New-GDBProfileJob/JobSample_Mode") -Or
            ($_ -eq "Update-GDBProfileJob/JobSample_Mode")
        }
        {
            $v = "CUSTOM_ROWS","FULL_DATASET"
            break
        }

        # Amazon.GlueDataBrew.SampleType
        {
            ($_ -eq "New-GDBProject/Sample_Type") -Or
            ($_ -eq "Update-GDBProject/Sample_Type")
        }
        {
            $v = "FIRST_N","LAST_N","RANDOM"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$GDB_map = @{
    "EncryptionMode"=@("New-GDBProfileJob","New-GDBRecipeJob","Update-GDBProfileJob","Update-GDBRecipeJob")
    "FilesLimit_Order"=@("New-GDBDataset","Update-GDBDataset")
    "FilesLimit_OrderedBy"=@("New-GDBDataset","Update-GDBDataset")
    "Format"=@("New-GDBDataset","Update-GDBDataset")
    "JobSample_Mode"=@("New-GDBProfileJob","Update-GDBProfileJob")
    "LogSubscription"=@("New-GDBProfileJob","New-GDBRecipeJob","Update-GDBProfileJob","Update-GDBRecipeJob")
    "Sample_Type"=@("New-GDBProject","Update-GDBProject")
    "ViewFrame_Analytic"=@("Send-GDBProjectSessionAction")
}

_awsArgumentCompleterRegistration $GDB_Completers $GDB_map

$GDB_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.GDB.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$GDB_SelectMap = @{
    "Select"=@("Remove-GDBRecipeVersionBatch",
               "New-GDBDataset",
               "New-GDBProfileJob",
               "New-GDBProject",
               "New-GDBRecipe",
               "New-GDBRecipeJob",
               "New-GDBRuleset",
               "New-GDBSchedule",
               "Remove-GDBDataset",
               "Remove-GDBJob",
               "Remove-GDBProject",
               "Remove-GDBRecipeVersion",
               "Remove-GDBRuleset",
               "Remove-GDBSchedule",
               "Get-GDBDataset",
               "Get-GDBJob",
               "Get-GDBJobRun",
               "Get-GDBProject",
               "Get-GDBRecipe",
               "Get-GDBRuleset",
               "Get-GDBSchedule",
               "Get-GDBDatasetList",
               "Get-GDBJobRunList",
               "Get-GDBJobList",
               "Get-GDBProjectList",
               "Get-GDBRecipeList",
               "Get-GDBRecipeVersionList",
               "Get-GDBRulesetList",
               "Get-GDBScheduleList",
               "Get-GDBResourceTag",
               "Publish-GDBRecipe",
               "Send-GDBProjectSessionAction",
               "Start-GDBJobRun",
               "Start-GDBProjectSession",
               "Stop-GDBJobRun",
               "Add-GDBResourceTag",
               "Remove-GDBResourceTag",
               "Update-GDBDataset",
               "Update-GDBProfileJob",
               "Update-GDBProject",
               "Update-GDBRecipe",
               "Update-GDBRecipeJob",
               "Update-GDBRuleset",
               "Update-GDBSchedule")
}

_awsArgumentCompleterRegistration $GDB_SelectCompleters $GDB_SelectMap
# Argument completions for service AWS Data Exchange


$DTEX_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.DataExchange.AssetType
        "New-DTEXDataSet/AssetType"
        {
            $v = "API_GATEWAY_API","LAKE_FORMATION_DATA_PERMISSION","REDSHIFT_DATA_SHARE","S3_DATA_ACCESS","S3_SNAPSHOT"
            break
        }

        # Amazon.DataExchange.GrantDistributionScope
        "New-DTEXDataGrant/GrantDistributionScope"
        {
            $v = "AWS_ORGANIZATION","NONE"
            break
        }

        # Amazon.DataExchange.NotificationType
        "Send-DTEXDataSetNotification/Type"
        {
            $v = "DATA_DELAY","DATA_UPDATE","DEPRECATION","SCHEMA_CHANGE"
            break
        }

        # Amazon.DataExchange.ProtocolType
        "New-DTEXJob/ImportAssetFromApiGatewayApi_ProtocolType"
        {
            $v = "REST"
            break
        }

        # Amazon.DataExchange.ServerSideEncryptionTypes
        {
            ($_ -eq "New-DTEXJob/Details_ExportRevisionsToS3_Encryption_Type") -Or
            ($_ -eq "New-DTEXEventAction/Encryption_Type") -Or
            ($_ -eq "New-DTEXJob/Encryption_Type") -Or
            ($_ -eq "Update-DTEXEventAction/Encryption_Type")
        }
        {
            $v = "AES256","aws:kms"
            break
        }

        # Amazon.DataExchange.Type
        "New-DTEXJob/Type"
        {
            $v = "CREATE_S3_DATA_ACCESS_FROM_S3_BUCKET","EXPORT_ASSETS_TO_S3","EXPORT_ASSET_TO_SIGNED_URL","EXPORT_REVISIONS_TO_S3","IMPORT_ASSETS_FROM_LAKE_FORMATION_TAG_POLICY","IMPORT_ASSETS_FROM_REDSHIFT_DATA_SHARES","IMPORT_ASSETS_FROM_S3","IMPORT_ASSET_FROM_API_GATEWAY_API","IMPORT_ASSET_FROM_SIGNED_URL"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DTEX_map = @{
    "AssetType"=@("New-DTEXDataSet")
    "Details_ExportRevisionsToS3_Encryption_Type"=@("New-DTEXJob")
    "Encryption_Type"=@("New-DTEXEventAction","New-DTEXJob","Update-DTEXEventAction")
    "GrantDistributionScope"=@("New-DTEXDataGrant")
    "ImportAssetFromApiGatewayApi_ProtocolType"=@("New-DTEXJob")
    "Type"=@("New-DTEXJob","Send-DTEXDataSetNotification")
}

_awsArgumentCompleterRegistration $DTEX_Completers $DTEX_map

$DTEX_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.DTEX.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DTEX_SelectMap = @{
    "Select"=@("Receive-DTEXDataGrant",
               "Stop-DTEXJob",
               "New-DTEXDataGrant",
               "New-DTEXDataSet",
               "New-DTEXEventAction",
               "New-DTEXJob",
               "New-DTEXRevision",
               "Remove-DTEXAsset",
               "Remove-DTEXDataGrant",
               "Remove-DTEXDataSet",
               "Remove-DTEXEventAction",
               "Remove-DTEXRevision",
               "Get-DTEXAsset",
               "Get-DTEXDataGrant",
               "Get-DTEXDataSet",
               "Get-DTEXEventAction",
               "Get-DTEXJob",
               "Get-DTEXReceivedDataGrant",
               "Get-DTEXRevision",
               "Get-DTEXDataGrantList",
               "Get-DTEXDataSetRevisionList",
               "Get-DTEXDataSetList",
               "Get-DTEXEventActionList",
               "Get-DTEXJobList",
               "Get-DTEXReceivedDataGrantList",
               "Get-DTEXRevisionAssetList",
               "Get-DTEXResourceTag",
               "Revoke-DTEXRevision",
               "Send-DTEXApiAsset",
               "Send-DTEXDataSetNotification",
               "Start-DTEXJob",
               "Add-DTEXResourceTag",
               "Remove-DTEXResourceTag",
               "Update-DTEXAsset",
               "Update-DTEXDataSet",
               "Update-DTEXEventAction",
               "Update-DTEXRevision")
}

_awsArgumentCompleterRegistration $DTEX_SelectCompleters $DTEX_SelectMap
# Argument completions for service AWS Data Pipeline


$DP_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.DataPipeline.TaskStatus
        "Set-DPTaskStatus/TaskStatus"
        {
            $v = "FAILED","FALSE","FINISHED"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DP_map = @{
    "TaskStatus"=@("Set-DPTaskStatus")
}

_awsArgumentCompleterRegistration $DP_Completers $DP_map

$DP_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.DP.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DP_SelectMap = @{
    "Select"=@("Enable-DPPipeline",
               "Add-DPResourceTag",
               "New-DPPipeline",
               "Disable-DPPipeline",
               "Remove-DPPipeline",
               "Get-DPObject",
               "Get-DPPipelineDescription",
               "Invoke-DPExpression",
               "Get-DPPipelineDefinition",
               "Get-DPPipeline",
               "Get-DPTask",
               "Write-DPPipelineDefinition",
               "Find-DPObject",
               "Remove-DPResourceTag",
               "Update-DPTaskProgress",
               "Update-DPTaskRunnerHeartbeat",
               "Set-DPStatus",
               "Set-DPTaskStatus",
               "Test-DPPipelineDefinition")
}

_awsArgumentCompleterRegistration $DP_SelectCompleters $DP_SelectMap
# Argument completions for service AWS DataSync


$DSYN_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.DataSync.AzureAccessTier
        {
            ($_ -eq "New-DSYNLocationAzureBlob/AccessTier") -Or
            ($_ -eq "Update-DSYNLocationAzureBlob/AccessTier")
        }
        {
            $v = "ARCHIVE","COOL","HOT"
            break
        }

        # Amazon.DataSync.AzureBlobAuthenticationType
        {
            ($_ -eq "New-DSYNLocationAzureBlob/AuthenticationType") -Or
            ($_ -eq "Update-DSYNLocationAzureBlob/AuthenticationType")
        }
        {
            $v = "NONE","SAS"
            break
        }

        # Amazon.DataSync.AzureBlobType
        {
            ($_ -eq "New-DSYNLocationAzureBlob/BlobType") -Or
            ($_ -eq "Update-DSYNLocationAzureBlob/BlobType")
        }
        {
            $v = "BLOCK"
            break
        }

        # Amazon.DataSync.EfsInTransitEncryption
        {
            ($_ -eq "New-DSYNLocationEfs/InTransitEncryption") -Or
            ($_ -eq "Update-DSYNLocationEfs/InTransitEncryption")
        }
        {
            $v = "NONE","TLS1_2"
            break
        }

        # Amazon.DataSync.HdfsAuthenticationType
        {
            ($_ -eq "New-DSYNLocationHdf/AuthenticationType") -Or
            ($_ -eq "Update-DSYNLocationHdf/AuthenticationType")
        }
        {
            $v = "KERBEROS","SIMPLE"
            break
        }

        # Amazon.DataSync.HdfsDataTransferProtection
        {
            ($_ -eq "New-DSYNLocationHdf/QopConfiguration_DataTransferProtection") -Or
            ($_ -eq "Update-DSYNLocationHdf/QopConfiguration_DataTransferProtection")
        }
        {
            $v = "AUTHENTICATION","DISABLED","INTEGRITY","PRIVACY"
            break
        }

        # Amazon.DataSync.HdfsRpcProtection
        {
            ($_ -eq "New-DSYNLocationHdf/QopConfiguration_RpcProtection") -Or
            ($_ -eq "Update-DSYNLocationHdf/QopConfiguration_RpcProtection")
        }
        {
            $v = "AUTHENTICATION","DISABLED","INTEGRITY","PRIVACY"
            break
        }

        # Amazon.DataSync.ManifestAction
        {
            ($_ -eq "New-DSYNTask/ManifestConfig_Action") -Or
            ($_ -eq "Start-DSYNTaskExecution/ManifestConfig_Action") -Or
            ($_ -eq "Update-DSYNTask/ManifestConfig_Action")
        }
        {
            $v = "TRANSFER"
            break
        }

        # Amazon.DataSync.ManifestFormat
        {
            ($_ -eq "New-DSYNTask/ManifestConfig_Format") -Or
            ($_ -eq "Start-DSYNTaskExecution/ManifestConfig_Format") -Or
            ($_ -eq "Update-DSYNTask/ManifestConfig_Format")
        }
        {
            $v = "CSV"
            break
        }

        # Amazon.DataSync.NfsVersion
        {
            ($_ -eq "New-DSYNLocationFsxOpenZf/MountOptions_Version") -Or
            ($_ -eq "New-DSYNLocationNfs/MountOptions_Version") -Or
            ($_ -eq "Update-DSYNLocationNfs/MountOptions_Version") -Or
            ($_ -eq "New-DSYNLocationFsxOntap/Protocol_NFS_MountOptions_Version") -Or
            ($_ -eq "Update-DSYNLocationFsxOntap/Protocol_NFS_MountOptions_Version") -Or
            ($_ -eq "Update-DSYNLocationFsxOpenZf/Protocol_NFS_MountOptions_Version")
        }
        {
            $v = "AUTOMATIC","NFS3","NFS4_0","NFS4_1"
            break
        }

        # Amazon.DataSync.ObjectStorageServerProtocol
        {
            ($_ -eq "New-DSYNLocationObjectStorage/ServerProtocol") -Or
            ($_ -eq "Update-DSYNLocationObjectStorage/ServerProtocol")
        }
        {
            $v = "HTTP","HTTPS"
            break
        }

        # Amazon.DataSync.ObjectVersionIds
        {
            ($_ -eq "New-DSYNTask/TaskReportConfig_ObjectVersionId") -Or
            ($_ -eq "Start-DSYNTaskExecution/TaskReportConfig_ObjectVersionId") -Or
            ($_ -eq "Update-DSYNTask/TaskReportConfig_ObjectVersionId")
        }
        {
            $v = "INCLUDE","NONE"
            break
        }

        # Amazon.DataSync.ReportLevel
        {
            ($_ -eq "New-DSYNTask/Deleted_ReportLevel") -Or
            ($_ -eq "Start-DSYNTaskExecution/Deleted_ReportLevel") -Or
            ($_ -eq "Update-DSYNTask/Deleted_ReportLevel") -Or
            ($_ -eq "New-DSYNTask/Skipped_ReportLevel") -Or
            ($_ -eq "Start-DSYNTaskExecution/Skipped_ReportLevel") -Or
            ($_ -eq "Update-DSYNTask/Skipped_ReportLevel") -Or
            ($_ -eq "New-DSYNTask/TaskReportConfig_ReportLevel") -Or
            ($_ -eq "Start-DSYNTaskExecution/TaskReportConfig_ReportLevel") -Or
            ($_ -eq "Update-DSYNTask/TaskReportConfig_ReportLevel") -Or
            ($_ -eq "New-DSYNTask/Transferred_ReportLevel") -Or
            ($_ -eq "Start-DSYNTaskExecution/Transferred_ReportLevel") -Or
            ($_ -eq "Update-DSYNTask/Transferred_ReportLevel") -Or
            ($_ -eq "New-DSYNTask/Verified_ReportLevel") -Or
            ($_ -eq "Start-DSYNTaskExecution/Verified_ReportLevel") -Or
            ($_ -eq "Update-DSYNTask/Verified_ReportLevel")
        }
        {
            $v = "ERRORS_ONLY","SUCCESSES_AND_ERRORS"
            break
        }

        # Amazon.DataSync.ReportOutputType
        {
            ($_ -eq "New-DSYNTask/TaskReportConfig_OutputType") -Or
            ($_ -eq "Start-DSYNTaskExecution/TaskReportConfig_OutputType") -Or
            ($_ -eq "Update-DSYNTask/TaskReportConfig_OutputType")
        }
        {
            $v = "STANDARD","SUMMARY_ONLY"
            break
        }

        # Amazon.DataSync.S3StorageClass
        {
            ($_ -eq "New-DSYNLocationS3/S3StorageClass") -Or
            ($_ -eq "Update-DSYNLocationS3/S3StorageClass")
        }
        {
            $v = "DEEP_ARCHIVE","GLACIER","GLACIER_INSTANT_RETRIEVAL","INTELLIGENT_TIERING","ONEZONE_IA","OUTPOSTS","STANDARD","STANDARD_IA"
            break
        }

        # Amazon.DataSync.ScheduleStatus
        {
            ($_ -eq "New-DSYNTask/Schedule_Status") -Or
            ($_ -eq "Update-DSYNTask/Schedule_Status")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.DataSync.SmbAuthenticationType
        {
            ($_ -eq "New-DSYNLocationSmb/AuthenticationType") -Or
            ($_ -eq "Update-DSYNLocationSmb/AuthenticationType")
        }
        {
            $v = "KERBEROS","NTLM"
            break
        }

        # Amazon.DataSync.SmbVersion
        {
            ($_ -eq "New-DSYNLocationSmb/MountOptions_Version") -Or
            ($_ -eq "Update-DSYNLocationSmb/MountOptions_Version") -Or
            ($_ -eq "New-DSYNLocationFsxOntap/Protocol_SMB_MountOptions_Version") -Or
            ($_ -eq "New-DSYNLocationFsxOpenZf/Protocol_SMB_MountOptions_Version") -Or
            ($_ -eq "Update-DSYNLocationFsxOntap/Protocol_SMB_MountOptions_Version") -Or
            ($_ -eq "Update-DSYNLocationFsxOpenZf/Protocol_SMB_MountOptions_Version")
        }
        {
            $v = "AUTOMATIC","SMB1","SMB2","SMB2_0","SMB3"
            break
        }

        # Amazon.DataSync.TaskMode
        "New-DSYNTask/TaskMode"
        {
            $v = "BASIC","ENHANCED"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DSYN_map = @{
    "AccessTier"=@("New-DSYNLocationAzureBlob","Update-DSYNLocationAzureBlob")
    "AuthenticationType"=@("New-DSYNLocationAzureBlob","New-DSYNLocationHdf","New-DSYNLocationSmb","Update-DSYNLocationAzureBlob","Update-DSYNLocationHdf","Update-DSYNLocationSmb")
    "BlobType"=@("New-DSYNLocationAzureBlob","Update-DSYNLocationAzureBlob")
    "Deleted_ReportLevel"=@("New-DSYNTask","Start-DSYNTaskExecution","Update-DSYNTask")
    "InTransitEncryption"=@("New-DSYNLocationEfs","Update-DSYNLocationEfs")
    "ManifestConfig_Action"=@("New-DSYNTask","Start-DSYNTaskExecution","Update-DSYNTask")
    "ManifestConfig_Format"=@("New-DSYNTask","Start-DSYNTaskExecution","Update-DSYNTask")
    "MountOptions_Version"=@("New-DSYNLocationFsxOpenZf","New-DSYNLocationNfs","New-DSYNLocationSmb","Update-DSYNLocationNfs","Update-DSYNLocationSmb")
    "Protocol_NFS_MountOptions_Version"=@("New-DSYNLocationFsxOntap","Update-DSYNLocationFsxOntap","Update-DSYNLocationFsxOpenZf")
    "Protocol_SMB_MountOptions_Version"=@("New-DSYNLocationFsxOntap","New-DSYNLocationFsxOpenZf","Update-DSYNLocationFsxOntap","Update-DSYNLocationFsxOpenZf")
    "QopConfiguration_DataTransferProtection"=@("New-DSYNLocationHdf","Update-DSYNLocationHdf")
    "QopConfiguration_RpcProtection"=@("New-DSYNLocationHdf","Update-DSYNLocationHdf")
    "S3StorageClass"=@("New-DSYNLocationS3","Update-DSYNLocationS3")
    "Schedule_Status"=@("New-DSYNTask","Update-DSYNTask")
    "ServerProtocol"=@("New-DSYNLocationObjectStorage","Update-DSYNLocationObjectStorage")
    "Skipped_ReportLevel"=@("New-DSYNTask","Start-DSYNTaskExecution","Update-DSYNTask")
    "TaskMode"=@("New-DSYNTask")
    "TaskReportConfig_ObjectVersionId"=@("New-DSYNTask","Start-DSYNTaskExecution","Update-DSYNTask")
    "TaskReportConfig_OutputType"=@("New-DSYNTask","Start-DSYNTaskExecution","Update-DSYNTask")
    "TaskReportConfig_ReportLevel"=@("New-DSYNTask","Start-DSYNTaskExecution","Update-DSYNTask")
    "Transferred_ReportLevel"=@("New-DSYNTask","Start-DSYNTaskExecution","Update-DSYNTask")
    "Verified_ReportLevel"=@("New-DSYNTask","Start-DSYNTaskExecution","Update-DSYNTask")
}

_awsArgumentCompleterRegistration $DSYN_Completers $DSYN_map

$DSYN_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.DSYN.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DSYN_SelectMap = @{
    "Select"=@("Stop-DSYNTaskExecution",
               "New-DSYNAgent",
               "New-DSYNLocationAzureBlob",
               "New-DSYNLocationEfs",
               "New-DSYNLocationFsxLustre",
               "New-DSYNLocationFsxOntap",
               "New-DSYNLocationFsxOpenZf",
               "New-DSYNLocationFsxWindow",
               "New-DSYNLocationHdf",
               "New-DSYNLocationNfs",
               "New-DSYNLocationObjectStorage",
               "New-DSYNLocationS3",
               "New-DSYNLocationSmb",
               "New-DSYNTask",
               "Remove-DSYNAgent",
               "Remove-DSYNLocation",
               "Remove-DSYNTask",
               "Get-DSYNAgent",
               "Get-DSYNLocationAzureBlob",
               "Get-DSYNLocationEfs",
               "Get-DSYNLocationFsxLustre",
               "Get-DSYNLocationFsxOntap",
               "Get-DSYNLocationFsxOpenZf",
               "Get-DSYNLocationFsxWindow",
               "Get-DSYNLocationHdf",
               "Get-DSYNLocationNfs",
               "Get-DSYNLocationObjectStorage",
               "Get-DSYNLocationS3",
               "Get-DSYNLocationSmb",
               "Get-DSYNTask",
               "Get-DSYNTaskExecution",
               "Get-DSYNAgentList",
               "Get-DSYNLocationList",
               "Get-DSYNResourceTagList",
               "Get-DSYNTaskExecutionList",
               "Get-DSYNTaskList",
               "Start-DSYNTaskExecution",
               "Add-DSYNResourceTag",
               "Remove-DSYNResourceTag",
               "Update-DSYNAgent",
               "Update-DSYNLocationAzureBlob",
               "Update-DSYNLocationEfs",
               "Update-DSYNLocationFsxLustre",
               "Update-DSYNLocationFsxOntap",
               "Update-DSYNLocationFsxOpenZf",
               "Update-DSYNLocationFsxWindow",
               "Update-DSYNLocationHdf",
               "Update-DSYNLocationNfs",
               "Update-DSYNLocationObjectStorage",
               "Update-DSYNLocationS3",
               "Update-DSYNLocationSmb",
               "Update-DSYNTask",
               "Update-DSYNTaskExecution")
}

_awsArgumentCompleterRegistration $DSYN_SelectCompleters $DSYN_SelectMap
# Argument completions for service Amazon DataZone


$DZ_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.DataZone.AcceptRuleBehavior
        "Approve-DZPrediction/AcceptRule_Rule"
        {
            $v = "ALL","NONE"
            break
        }

        # Amazon.DataZone.AuthenticationType
        "New-DZConnection/AuthenticationConfiguration_AuthenticationType"
        {
            $v = "BASIC","CUSTOM","OAUTH2"
            break
        }

        # Amazon.DataZone.AuthType
        {
            ($_ -eq "New-DZDomain/SingleSignOn_Type") -Or
            ($_ -eq "Update-DZDomain/SingleSignOn_Type")
        }
        {
            $v = "DISABLED","IAM_IDC"
            break
        }

        # Amazon.DataZone.ChangeAction
        "New-DZListingChangeSet/Action"
        {
            $v = "PUBLISH","UNPUBLISH"
            break
        }

        # Amazon.DataZone.ConnectionScope
        {
            ($_ -eq "Get-DZConnectionList/Scope") -Or
            ($_ -eq "New-DZConnection/Scope")
        }
        {
            $v = "DOMAIN","PROJECT"
            break
        }

        # Amazon.DataZone.ConnectionType
        "Get-DZConnectionList/Type"
        {
            $v = "AMAZON_Q","ATHENA","BIGQUERY","DATABRICKS","DOCUMENTDB","DYNAMODB","HYPERPOD","IAM","MLFLOW","MYSQL","OPENSEARCH","ORACLE","POSTGRESQL","REDSHIFT","S3","SAPHANA","SNOWFLAKE","SPARK","SQLSERVER","TERADATA","VERTICA","WORKFLOWS_MWAA"
            break
        }

        # Amazon.DataZone.DataAssetActivityStatus
        "Get-DZDataSourceRunActivityList/Status"
        {
            $v = "FAILED","PUBLISHING_FAILED","SKIPPED_ALREADY_IMPORTED","SKIPPED_ARCHIVED","SKIPPED_NO_ACCESS","SUCCEEDED_CREATED","SUCCEEDED_UPDATED","UNCHANGED"
            break
        }

        # Amazon.DataZone.DataSourceRunStatus
        "Get-DZDataSourceRunList/Status"
        {
            $v = "FAILED","PARTIALLY_SUCCEEDED","REQUESTED","RUNNING","SUCCESS"
            break
        }

        # Amazon.DataZone.DataSourceStatus
        "Get-DZDataSourceList/Status"
        {
            $v = "CREATING","DELETING","FAILED_CREATION","FAILED_DELETION","FAILED_UPDATE","READY","RUNNING","UPDATING"
            break
        }

        # Amazon.DataZone.DataZoneEntityType
        {
            ($_ -eq "Add-DZEntityOwner/EntityType") -Or
            ($_ -eq "Get-DZEntityOwnerList/EntityType") -Or
            ($_ -eq "Remove-DZEntityOwner/EntityType")
        }
        {
            $v = "DOMAIN_UNIT"
            break
        }

        # Amazon.DataZone.DomainStatus
        "Get-DZDomainList/Status"
        {
            $v = "AVAILABLE","CREATING","CREATION_FAILED","DELETED","DELETING","DELETION_FAILED"
            break
        }

        # Amazon.DataZone.DomainUnitDesignation
        {
            ($_ -eq "Add-DZPolicyGrant/DomainUnit_DomainUnitDesignation") -Or
            ($_ -eq "Remove-DZPolicyGrant/DomainUnit_DomainUnitDesignation")
        }
        {
            $v = "OWNER"
            break
        }

        # Amazon.DataZone.DomainVersion
        "New-DZDomain/DomainVersion"
        {
            $v = "V1","V2"
            break
        }

        # Amazon.DataZone.EdgeDirection
        "Get-DZLineageNodeHistoryList/Direction"
        {
            $v = "DOWNSTREAM","UPSTREAM"
            break
        }

        # Amazon.DataZone.EnableSetting
        {
            ($_ -eq "New-DZDataSource/EnableSetting") -Or
            ($_ -eq "Update-DZDataSource/EnableSetting")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.DataZone.EntityType
        "New-DZListingChangeSet/EntityType"
        {
            $v = "ASSET","DATA_PRODUCT"
            break
        }

        # Amazon.DataZone.EnvironmentStatus
        "Get-DZEnvironmentList/Status"
        {
            $v = "ACTIVE","CREATE_FAILED","CREATING","DELETED","DELETE_FAILED","DELETING","DISABLED","EXPIRED","INACCESSIBLE","SUSPENDED","UPDATE_FAILED","UPDATING","VALIDATION_FAILED"
            break
        }

        # Amazon.DataZone.FilterStatus
        "Get-DZAssetFilterList/Status"
        {
            $v = "INVALID","VALID"
            break
        }

        # Amazon.DataZone.FormTypeStatus
        "New-DZFormType/Status"
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.DataZone.GlossaryStatus
        {
            ($_ -eq "New-DZGlossary/Status") -Or
            ($_ -eq "Update-DZGlossary/Status")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.DataZone.GlossaryTermStatus
        {
            ($_ -eq "New-DZGlossaryTerm/Status") -Or
            ($_ -eq "Update-DZGlossaryTerm/Status")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.DataZone.GlueConnectionType
        "New-DZConnection/GlueConnectionInput_ConnectionType"
        {
            $v = "BIGQUERY","DOCUMENTDB","DYNAMODB","MYSQL","OPENSEARCH","ORACLE","POSTGRESQL","REDSHIFT","SAPHANA","SNOWFLAKE","SQLSERVER","TERADATA","VERTICA"
            break
        }

        # Amazon.DataZone.GovernedEntityType
        {
            ($_ -eq "Add-DZGovernedTerm/EntityType") -Or
            ($_ -eq "Remove-DZGovernedTerm/EntityType")
        }
        {
            $v = "ASSET"
            break
        }

        # Amazon.DataZone.GroupProfileStatus
        "Update-DZGroupProfile/Status"
        {
            $v = "ASSIGNED","NOT_ASSIGNED"
            break
        }

        # Amazon.DataZone.GroupSearchType
        "Search-DZGroupProfile/GroupType"
        {
            $v = "DATAZONE_SSO_GROUP","SSO_GROUP"
            break
        }

        # Amazon.DataZone.InventorySearchScope
        "Search-DZResource/SearchScope"
        {
            $v = "ASSET","DATA_PRODUCT","GLOSSARY","GLOSSARY_TERM"
            break
        }

        # Amazon.DataZone.JobRunStatus
        "Get-DZJobRunList/Status"
        {
            $v = "ABORTED","CANCELED","FAILED","IN_PROGRESS","PARTIALLY_SUCCEEDED","SCHEDULED","SUCCESS","TIMED_OUT"
            break
        }

        # Amazon.DataZone.LineageEventProcessingStatus
        "Get-DZLineageEventList/ProcessingStatus"
        {
            $v = "FAILED","PROCESSING","REQUESTED","SUCCESS"
            break
        }

        # Amazon.DataZone.ManagedPolicyType
        {
            ($_ -eq "Add-DZPolicyGrant/PolicyType") -Or
            ($_ -eq "Get-DZPolicyGrantList/PolicyType") -Or
            ($_ -eq "Remove-DZPolicyGrant/PolicyType")
        }
        {
            $v = "ADD_TO_PROJECT_MEMBER_POOL","CREATE_ASSET_TYPE","CREATE_DOMAIN_UNIT","CREATE_ENVIRONMENT","CREATE_ENVIRONMENT_FROM_BLUEPRINT","CREATE_ENVIRONMENT_PROFILE","CREATE_FORM_TYPE","CREATE_GLOSSARY","CREATE_PROJECT","CREATE_PROJECT_FROM_PROJECT_PROFILE","DELEGATE_CREATE_ENVIRONMENT_PROFILE","OVERRIDE_DOMAIN_UNIT_OWNERS","OVERRIDE_PROJECT_OWNERS","USE_ASSET_TYPE"
            break
        }

        # Amazon.DataZone.MetadataGenerationRunStatus
        "Get-DZMetadataGenerationRunList/Status"
        {
            $v = "CANCELED","FAILED","IN_PROGRESS","SUBMITTED","SUCCEEDED"
            break
        }

        # Amazon.DataZone.MetadataGenerationRunType
        {
            ($_ -eq "Get-DZMetadataGenerationRunList/Type") -Or
            ($_ -eq "Start-DZMetadataGenerationRun/Type")
        }
        {
            $v = "BUSINESS_DESCRIPTIONS"
            break
        }

        # Amazon.DataZone.MetadataGenerationTargetType
        "Start-DZMetadataGenerationRun/Target_Type"
        {
            $v = "ASSET"
            break
        }

        # Amazon.DataZone.NotificationType
        "Get-DZNotificationList/Type"
        {
            $v = "EVENT","TASK"
            break
        }

        # Amazon.DataZone.OAuth2GrantType
        "New-DZConnection/OAuth2Properties_OAuth2GrantType"
        {
            $v = "AUTHORIZATION_CODE","CLIENT_CREDENTIALS","JWT_BEARER"
            break
        }

        # Amazon.DataZone.OverallDeploymentStatus
        "Update-DZProject/EnvironmentDeploymentDetails_OverallDeploymentStatus"
        {
            $v = "FAILED_DEPLOYMENT","FAILED_VALIDATION","IN_PROGRESS","PENDING_DEPLOYMENT","SUCCESSFUL"
            break
        }

        # Amazon.DataZone.ProjectDesignation
        {
            ($_ -eq "Add-DZPolicyGrant/Project_ProjectDesignation") -Or
            ($_ -eq "Remove-DZPolicyGrant/Project_ProjectDesignation")
        }
        {
            $v = "CONTRIBUTOR","OWNER","PROJECT_CATALOG_STEWARD"
            break
        }

        # Amazon.DataZone.RejectRuleBehavior
        "Deny-DZPrediction/RejectRule_Rule"
        {
            $v = "ALL","NONE"
            break
        }

        # Amazon.DataZone.ResolutionStrategy
        {
            ($_ -eq "New-DZAccountPool/ResolutionStrategy") -Or
            ($_ -eq "Update-DZAccountPool/ResolutionStrategy")
        }
        {
            $v = "MANUAL"
            break
        }

        # Amazon.DataZone.RuleAction
        {
            ($_ -eq "Get-DZRuleList/Action") -Or
            ($_ -eq "New-DZRule/Action")
        }
        {
            $v = "CREATE_LISTING_CHANGE_SET","CREATE_SUBSCRIPTION_REQUEST"
            break
        }

        # Amazon.DataZone.RuleTargetType
        "Get-DZRuleList/TargetType"
        {
            $v = "DOMAIN_UNIT"
            break
        }

        # Amazon.DataZone.RuleType
        "Get-DZRuleList/RuleType"
        {
            $v = "METADATA_FORM_ENFORCEMENT"
            break
        }

        # Amazon.DataZone.SortFieldAccountPool
        "Get-DZAccountPoolList/SortBy"
        {
            $v = "NAME"
            break
        }

        # Amazon.DataZone.SortFieldConnection
        "Get-DZConnectionList/SortBy"
        {
            $v = "NAME"
            break
        }

        # Amazon.DataZone.SortFieldProject
        {
            ($_ -eq "Get-DZProjectMembershipList/SortBy") -Or
            ($_ -eq "Get-DZProjectProfileList/SortBy")
        }
        {
            $v = "NAME"
            break
        }

        # Amazon.DataZone.SortKey
        {
            ($_ -eq "Get-DZSubscriptionGrantList/SortBy") -Or
            ($_ -eq "Get-DZSubscriptionList/SortBy") -Or
            ($_ -eq "Get-DZSubscriptionRequestList/SortBy") -Or
            ($_ -eq "Get-DZSubscriptionTargetList/SortBy")
        }
        {
            $v = "CREATED_AT","UPDATED_AT"
            break
        }

        # Amazon.DataZone.SortOrder
        {
            ($_ -eq "Search-DZListing/Sort_Order") -Or
            ($_ -eq "Search-DZResource/Sort_Order") -Or
            ($_ -eq "Search-DZType/Sort_Order") -Or
            ($_ -eq "Get-DZAccountPoolList/SortOrder") -Or
            ($_ -eq "Get-DZConnectionList/SortOrder") -Or
            ($_ -eq "Get-DZJobRunList/SortOrder") -Or
            ($_ -eq "Get-DZLineageEventList/SortOrder") -Or
            ($_ -eq "Get-DZLineageNodeHistoryList/SortOrder") -Or
            ($_ -eq "Get-DZProjectMembershipList/SortOrder") -Or
            ($_ -eq "Get-DZProjectProfileList/SortOrder") -Or
            ($_ -eq "Get-DZSubscriptionGrantList/SortOrder") -Or
            ($_ -eq "Get-DZSubscriptionList/SortOrder") -Or
            ($_ -eq "Get-DZSubscriptionRequestList/SortOrder") -Or
            ($_ -eq "Get-DZSubscriptionTargetList/SortOrder")
        }
        {
            $v = "ASCENDING","DESCENDING"
            break
        }

        # Amazon.DataZone.Status
        {
            ($_ -eq "New-DZProjectProfile/Status") -Or
            ($_ -eq "Update-DZProjectProfile/Status")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.DataZone.SubscriptionGrantStatus
        "Update-DZSubscriptionGrantStatus/Status"
        {
            $v = "GRANTED","GRANT_FAILED","GRANT_IN_PROGRESS","GRANT_PENDING","REVOKED","REVOKE_FAILED","REVOKE_IN_PROGRESS","REVOKE_PENDING"
            break
        }

        # Amazon.DataZone.SubscriptionRequestStatus
        "Get-DZSubscriptionRequestList/Status"
        {
            $v = "ACCEPTED","PENDING","REJECTED"
            break
        }

        # Amazon.DataZone.SubscriptionStatus
        "Get-DZSubscriptionList/Status"
        {
            $v = "APPROVED","CANCELLED","REVOKED"
            break
        }

        # Amazon.DataZone.TargetEntityType
        {
            ($_ -eq "Add-DZPolicyGrant/EntityType") -Or
            ($_ -eq "Get-DZPolicyGrantList/EntityType") -Or
            ($_ -eq "Remove-DZPolicyGrant/EntityType")
        }
        {
            $v = "ASSET_TYPE","DOMAIN_UNIT","ENVIRONMENT_BLUEPRINT_CONFIGURATION","ENVIRONMENT_PROFILE"
            break
        }

        # Amazon.DataZone.TaskStatus
        "Get-DZNotificationList/TaskStatus"
        {
            $v = "ACTIVE","INACTIVE"
            break
        }

        # Amazon.DataZone.TimeSeriesEntityType
        {
            ($_ -eq "Get-DZTimeSeriesDataPoint/EntityType") -Or
            ($_ -eq "Get-DZTimeSeriesDataPointList/EntityType") -Or
            ($_ -eq "New-DZTimeSeriesDataPoint/EntityType") -Or
            ($_ -eq "Remove-DZTimeSeriesDataPoint/EntityType")
        }
        {
            $v = "ASSET","LISTING"
            break
        }

        # Amazon.DataZone.Timezone
        {
            ($_ -eq "New-DZDataSource/Schedule_Timezone") -Or
            ($_ -eq "Update-DZDataSource/Schedule_Timezone")
        }
        {
            $v = "AFRICA_JOHANNESBURG","AMERICA_MONTREAL","AMERICA_SAO_PAULO","ASIA_BAHRAIN","ASIA_BANGKOK","ASIA_CALCUTTA","ASIA_DUBAI","ASIA_HONG_KONG","ASIA_JAKARTA","ASIA_KUALA_LUMPUR","ASIA_SEOUL","ASIA_SHANGHAI","ASIA_SINGAPORE","ASIA_TAIPEI","ASIA_TOKYO","AUSTRALIA_MELBOURNE","AUSTRALIA_SYDNEY","CANADA_CENTRAL","CET","CST6CDT","ETC_GMT","ETC_GMT0","ETC_GMT_ADD_0","ETC_GMT_ADD_1","ETC_GMT_ADD_10","ETC_GMT_ADD_11","ETC_GMT_ADD_12","ETC_GMT_ADD_2","ETC_GMT_ADD_3","ETC_GMT_ADD_4","ETC_GMT_ADD_5","ETC_GMT_ADD_6","ETC_GMT_ADD_7","ETC_GMT_ADD_8","ETC_GMT_ADD_9","ETC_GMT_NEG_0","ETC_GMT_NEG_1","ETC_GMT_NEG_10","ETC_GMT_NEG_11","ETC_GMT_NEG_12","ETC_GMT_NEG_13","ETC_GMT_NEG_14","ETC_GMT_NEG_2","ETC_GMT_NEG_3","ETC_GMT_NEG_4","ETC_GMT_NEG_5","ETC_GMT_NEG_6","ETC_GMT_NEG_7","ETC_GMT_NEG_8","ETC_GMT_NEG_9","EUROPE_DUBLIN","EUROPE_LONDON","EUROPE_PARIS","EUROPE_STOCKHOLM","EUROPE_ZURICH","ISRAEL","MEXICO_GENERAL","MST7MDT","PACIFIC_AUCKLAND","US_CENTRAL","US_EASTERN","US_MOUNTAIN","US_PACIFIC","UTC"
            break
        }

        # Amazon.DataZone.TypesSearchScope
        "Search-DZType/SearchScope"
        {
            $v = "ASSET_TYPE","FORM_TYPE","LINEAGE_NODE_TYPE"
            break
        }

        # Amazon.DataZone.UserAssignment
        {
            ($_ -eq "New-DZDomain/SingleSignOn_UserAssignment") -Or
            ($_ -eq "Update-DZDomain/SingleSignOn_UserAssignment")
        }
        {
            $v = "AUTOMATIC","MANUAL"
            break
        }

        # Amazon.DataZone.UserDesignation
        "New-DZProjectMembership/Designation"
        {
            $v = "PROJECT_CATALOG_CONSUMER","PROJECT_CATALOG_STEWARD","PROJECT_CATALOG_VIEWER","PROJECT_CONTRIBUTOR","PROJECT_OWNER"
            break
        }

        # Amazon.DataZone.UserProfileStatus
        "Update-DZUserProfile/Status"
        {
            $v = "ACTIVATED","ASSIGNED","DEACTIVATED","NOT_ASSIGNED"
            break
        }

        # Amazon.DataZone.UserProfileType
        {
            ($_ -eq "Get-DZUserProfile/Type") -Or
            ($_ -eq "Update-DZUserProfile/Type")
        }
        {
            $v = "IAM","SSO"
            break
        }

        # Amazon.DataZone.UserSearchType
        "Search-DZUserProfile/UserType"
        {
            $v = "DATAZONE_IAM_USER","DATAZONE_SSO_USER","DATAZONE_USER","SSO_USER"
            break
        }

        # Amazon.DataZone.UserType
        "New-DZUserProfile/UserType"
        {
            $v = "IAM_ROLE","IAM_USER","SSO_USER"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DZ_map = @{
    "AcceptRule_Rule"=@("Approve-DZPrediction")
    "Action"=@("Get-DZRuleList","New-DZListingChangeSet","New-DZRule")
    "AuthenticationConfiguration_AuthenticationType"=@("New-DZConnection")
    "Designation"=@("New-DZProjectMembership")
    "Direction"=@("Get-DZLineageNodeHistoryList")
    "DomainUnit_DomainUnitDesignation"=@("Add-DZPolicyGrant","Remove-DZPolicyGrant")
    "DomainVersion"=@("New-DZDomain")
    "EnableSetting"=@("New-DZDataSource","Update-DZDataSource")
    "EntityType"=@("Add-DZEntityOwner","Add-DZGovernedTerm","Add-DZPolicyGrant","Get-DZEntityOwnerList","Get-DZPolicyGrantList","Get-DZTimeSeriesDataPoint","Get-DZTimeSeriesDataPointList","New-DZListingChangeSet","New-DZTimeSeriesDataPoint","Remove-DZEntityOwner","Remove-DZGovernedTerm","Remove-DZPolicyGrant","Remove-DZTimeSeriesDataPoint")
    "EnvironmentDeploymentDetails_OverallDeploymentStatus"=@("Update-DZProject")
    "GlueConnectionInput_ConnectionType"=@("New-DZConnection")
    "GroupType"=@("Search-DZGroupProfile")
    "OAuth2Properties_OAuth2GrantType"=@("New-DZConnection")
    "PolicyType"=@("Add-DZPolicyGrant","Get-DZPolicyGrantList","Remove-DZPolicyGrant")
    "ProcessingStatus"=@("Get-DZLineageEventList")
    "Project_ProjectDesignation"=@("Add-DZPolicyGrant","Remove-DZPolicyGrant")
    "RejectRule_Rule"=@("Deny-DZPrediction")
    "ResolutionStrategy"=@("New-DZAccountPool","Update-DZAccountPool")
    "RuleType"=@("Get-DZRuleList")
    "Schedule_Timezone"=@("New-DZDataSource","Update-DZDataSource")
    "Scope"=@("Get-DZConnectionList","New-DZConnection")
    "SearchScope"=@("Search-DZResource","Search-DZType")
    "SingleSignOn_Type"=@("New-DZDomain","Update-DZDomain")
    "SingleSignOn_UserAssignment"=@("New-DZDomain","Update-DZDomain")
    "Sort_Order"=@("Search-DZListing","Search-DZResource","Search-DZType")
    "SortBy"=@("Get-DZAccountPoolList","Get-DZConnectionList","Get-DZProjectMembershipList","Get-DZProjectProfileList","Get-DZSubscriptionGrantList","Get-DZSubscriptionList","Get-DZSubscriptionRequestList","Get-DZSubscriptionTargetList")
    "SortOrder"=@("Get-DZAccountPoolList","Get-DZConnectionList","Get-DZJobRunList","Get-DZLineageEventList","Get-DZLineageNodeHistoryList","Get-DZProjectMembershipList","Get-DZProjectProfileList","Get-DZSubscriptionGrantList","Get-DZSubscriptionList","Get-DZSubscriptionRequestList","Get-DZSubscriptionTargetList")
    "Status"=@("Get-DZAssetFilterList","Get-DZDataSourceList","Get-DZDataSourceRunActivityList","Get-DZDataSourceRunList","Get-DZDomainList","Get-DZEnvironmentList","Get-DZJobRunList","Get-DZMetadataGenerationRunList","Get-DZSubscriptionList","Get-DZSubscriptionRequestList","New-DZFormType","New-DZGlossary","New-DZGlossaryTerm","New-DZProjectProfile","Update-DZGlossary","Update-DZGlossaryTerm","Update-DZGroupProfile","Update-DZProjectProfile","Update-DZSubscriptionGrantStatus","Update-DZUserProfile")
    "Target_Type"=@("Start-DZMetadataGenerationRun")
    "TargetType"=@("Get-DZRuleList")
    "TaskStatus"=@("Get-DZNotificationList")
    "Type"=@("Get-DZConnectionList","Get-DZMetadataGenerationRunList","Get-DZNotificationList","Get-DZUserProfile","Start-DZMetadataGenerationRun","Update-DZUserProfile")
    "UserType"=@("New-DZUserProfile","Search-DZUserProfile")
}

_awsArgumentCompleterRegistration $DZ_Completers $DZ_map

$DZ_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.DZ.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DZ_SelectMap = @{
    "Select"=@("Approve-DZPrediction",
               "Approve-DZSubscriptionRequest",
               "Add-DZEntityOwner",
               "Add-DZPolicyGrant",
               "Set-DZEnvironmentRole",
               "Add-DZGovernedTerm",
               "Stop-DZMetadataGenerationRun",
               "Stop-DZSubscription",
               "New-DZAccountPool",
               "New-DZAsset",
               "New-DZAssetFilter",
               "New-DZAssetRevision",
               "New-DZAssetType",
               "New-DZConnection",
               "New-DZDataProduct",
               "New-DZDataProductRevision",
               "New-DZDataSource",
               "New-DZDomain",
               "New-DZDomainUnit",
               "New-DZEnvironment",
               "New-DZEnvironmentAction",
               "New-DZEnvironmentBlueprint",
               "New-DZEnvironmentProfile",
               "New-DZFormType",
               "New-DZGlossary",
               "New-DZGlossaryTerm",
               "New-DZGroupProfile",
               "New-DZListingChangeSet",
               "New-DZProject",
               "New-DZProjectMembership",
               "New-DZProjectProfile",
               "New-DZRule",
               "New-DZSubscriptionGrant",
               "New-DZSubscriptionRequest",
               "New-DZSubscriptionTarget",
               "New-DZUserProfile",
               "Remove-DZAccountPool",
               "Remove-DZAsset",
               "Remove-DZAssetFilter",
               "Remove-DZAssetType",
               "Remove-DZConnection",
               "Remove-DZDataProduct",
               "Remove-DZDataSource",
               "Remove-DZDomain",
               "Remove-DZDomainUnit",
               "Remove-DZEnvironment",
               "Remove-DZEnvironmentAction",
               "Remove-DZEnvironmentBlueprint",
               "Remove-DZEnvironmentBlueprintConfiguration",
               "Remove-DZEnvironmentProfile",
               "Remove-DZFormType",
               "Remove-DZGlossary",
               "Remove-DZGlossaryTerm",
               "Remove-DZListing",
               "Remove-DZProject",
               "Remove-DZProjectMembership",
               "Remove-DZProjectProfile",
               "Remove-DZRule",
               "Remove-DZSubscriptionGrant",
               "Remove-DZSubscriptionRequest",
               "Remove-DZSubscriptionTarget",
               "Remove-DZTimeSeriesDataPoint",
               "Reset-DZEnvironmentRole",
               "Remove-DZGovernedTerm",
               "Get-DZAccountPool",
               "Get-DZAsset",
               "Get-DZAssetFilter",
               "Get-DZAssetType",
               "Get-DZConnection",
               "Get-DZDataProduct",
               "Get-DZDataSource",
               "Get-DZDataSourceRun",
               "Get-DZDomain",
               "Get-DZDomainUnit",
               "Get-DZEnvironment",
               "Get-DZEnvironmentAction",
               "Get-DZEnvironmentBlueprint",
               "Get-DZEnvironmentBlueprintConfiguration",
               "Get-DZEnvironmentCredential",
               "Get-DZEnvironmentProfile",
               "Get-DZFormType",
               "Get-DZGlossary",
               "Get-DZGlossaryTerm",
               "Get-DZGroupProfile",
               "Get-DZIamPortalLoginUrl",
               "Get-DZJobRun",
               "Get-DZLineageEvent",
               "Get-DZLineageNode",
               "Get-DZListing",
               "Get-DZMetadataGenerationRun",
               "Get-DZProject",
               "Get-DZProjectProfile",
               "Get-DZRule",
               "Get-DZSubscription",
               "Get-DZSubscriptionGrant",
               "Get-DZSubscriptionRequestDetail",
               "Get-DZSubscriptionTarget",
               "Get-DZTimeSeriesDataPoint",
               "Get-DZUserProfile",
               "Get-DZAccountPoolList",
               "Get-DZAccountsInAccountPoolList",
               "Get-DZAssetFilterList",
               "Get-DZAssetRevisionList",
               "Get-DZConnectionList",
               "Get-DZDataProductRevisionList",
               "Get-DZDataSourceRunActivityList",
               "Get-DZDataSourceRunList",
               "Get-DZDataSourceList",
               "Get-DZDomainList",
               "Get-DZDomainUnitsForParentList",
               "Get-DZEntityOwnerList",
               "Get-DZEnvironmentActionList",
               "Get-DZEnvironmentBlueprintConfigurationList",
               "Get-DZEnvironmentBlueprintList",
               "Get-DZEnvironmentProfileList",
               "Get-DZEnvironmentList",
               "Get-DZJobRunList",
               "Get-DZLineageEventList",
               "Get-DZLineageNodeHistoryList",
               "Get-DZMetadataGenerationRunList",
               "Get-DZNotificationList",
               "Get-DZPolicyGrantList",
               "Get-DZProjectMembershipList",
               "Get-DZProjectProfileList",
               "Get-DZProjectList",
               "Get-DZRuleList",
               "Get-DZSubscriptionGrantList",
               "Get-DZSubscriptionRequestList",
               "Get-DZSubscriptionList",
               "Get-DZSubscriptionTargetList",
               "Get-DZResourceTag",
               "Get-DZTimeSeriesDataPointList",
               "Submit-DZLineageEvent",
               "New-DZTimeSeriesDataPoint",
               "Write-DZEnvironmentBlueprintConfiguration",
               "Deny-DZPrediction",
               "Deny-DZSubscriptionRequest",
               "Remove-DZEntityOwner",
               "Remove-DZPolicyGrant",
               "Revoke-DZSubscription",
               "Search-DZResource",
               "Search-DZGroupProfile",
               "Search-DZListing",
               "Search-DZType",
               "Search-DZUserProfile",
               "Start-DZDataSourceRun",
               "Start-DZMetadataGenerationRun",
               "Add-DZResourceTag",
               "Remove-DZResourceTag",
               "Update-DZAccountPool",
               "Update-DZAssetFilter",
               "Update-DZConnection",
               "Update-DZDataSource",
               "Update-DZDomain",
               "Update-DZDomainUnit",
               "Update-DZEnvironment",
               "Update-DZEnvironmentAction",
               "Update-DZEnvironmentBlueprint",
               "Update-DZEnvironmentProfile",
               "Update-DZGlossary",
               "Update-DZGlossaryTerm",
               "Update-DZGroupProfile",
               "Update-DZProject",
               "Update-DZProjectProfile",
               "Update-DZRule",
               "Update-DZSubscriptionGrantStatus",
               "Update-DZSubscriptionRequest",
               "Update-DZSubscriptionTarget",
               "Update-DZUserProfile")
}

_awsArgumentCompleterRegistration $DZ_SelectCompleters $DZ_SelectMap
# Argument completions for service Amazon DynamoDB Accelerator (DAX)


$DAX_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.DAX.ClusterEndpointEncryptionType
        "New-DAXCluster/ClusterEndpointEncryptionType"
        {
            $v = "NONE","TLS"
            break
        }

        # Amazon.DAX.NetworkType
        "New-DAXCluster/NetworkType"
        {
            $v = "dual_stack","ipv4","ipv6"
            break
        }

        # Amazon.DAX.SourceType
        "Get-DAXEvent/SourceType"
        {
            $v = "CLUSTER","PARAMETER_GROUP","SUBNET_GROUP"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DAX_map = @{
    "ClusterEndpointEncryptionType"=@("New-DAXCluster")
    "NetworkType"=@("New-DAXCluster")
    "SourceType"=@("Get-DAXEvent")
}

_awsArgumentCompleterRegistration $DAX_Completers $DAX_map

$DAX_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.DAX.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DAX_SelectMap = @{
    "Select"=@("New-DAXCluster",
               "New-DAXParameterGroup",
               "New-DAXSubnetGroup",
               "Set-DAXReplicationFactorDecrease",
               "Remove-DAXCluster",
               "Remove-DAXParameterGroup",
               "Remove-DAXSubnetGroup",
               "Get-DAXCluster",
               "Get-DAXDefaultParameter",
               "Get-DAXEvent",
               "Get-DAXParameterGroup",
               "Get-DAXParameter",
               "Get-DAXSubnetGroup",
               "Set-DAXReplicationFactorIncrease",
               "Get-DAXResourceTag",
               "Restart-DAXNode",
               "Add-DAXResourceTag",
               "Remove-DAXResourceTag",
               "Update-DAXCluster",
               "Update-DAXParameterGroup",
               "Update-DAXSubnetGroup")
}

_awsArgumentCompleterRegistration $DAX_SelectCompleters $DAX_SelectMap
# Argument completions for service AWSDeadlineCloud


$ADC_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.Deadline.AutoScalingMode
        {
            ($_ -eq "New-ADCFleet/CustomerManaged_Mode") -Or
            ($_ -eq "Update-ADCFleet/CustomerManaged_Mode")
        }
        {
            $v = "EVENT_BASED_AUTO_SCALING","NO_SCALING"
            break
        }

        # Amazon.Deadline.BudgetStatus
        {
            ($_ -eq "Get-ADCBudgetList/Status") -Or
            ($_ -eq "Update-ADCBudget/Status")
        }
        {
            $v = "ACTIVE","INACTIVE"
            break
        }

        # Amazon.Deadline.CpuArchitectureType
        {
            ($_ -eq "New-ADCFleet/InstanceCapabilities_CpuArchitectureType") -Or
            ($_ -eq "Update-ADCFleet/InstanceCapabilities_CpuArchitectureType") -Or
            ($_ -eq "New-ADCFleet/WorkerCapabilities_CpuArchitectureType") -Or
            ($_ -eq "Update-ADCFleet/WorkerCapabilities_CpuArchitectureType")
        }
        {
            $v = "arm64","x86_64"
            break
        }

        # Amazon.Deadline.CreateJobTargetTaskRunStatus
        "New-ADCJob/TargetTaskRunStatus"
        {
            $v = "READY","SUSPENDED"
            break
        }

        # Amazon.Deadline.CustomerManagedFleetOperatingSystemFamily
        {
            ($_ -eq "New-ADCFleet/WorkerCapabilities_OsFamily") -Or
            ($_ -eq "Update-ADCFleet/WorkerCapabilities_OsFamily")
        }
        {
            $v = "LINUX","MACOS","WINDOWS"
            break
        }

        # Amazon.Deadline.DefaultQueueBudgetAction
        {
            ($_ -eq "New-ADCQueue/DefaultBudgetAction") -Or
            ($_ -eq "Update-ADCQueue/DefaultBudgetAction")
        }
        {
            $v = "NONE","STOP_SCHEDULING_AND_CANCEL_TASKS","STOP_SCHEDULING_AND_COMPLETE_TASKS"
            break
        }

        # Amazon.Deadline.Ec2MarketType
        {
            ($_ -eq "New-ADCFleet/InstanceMarketOptions_Type") -Or
            ($_ -eq "Update-ADCFleet/InstanceMarketOptions_Type")
        }
        {
            $v = "on-demand","spot","wait-and-save"
            break
        }

        # Amazon.Deadline.EnvironmentTemplateType
        {
            ($_ -eq "New-ADCQueueEnvironment/TemplateType") -Or
            ($_ -eq "Update-ADCQueueEnvironment/TemplateType")
        }
        {
            $v = "JSON","YAML"
            break
        }

        # Amazon.Deadline.FleetStatus
        "Get-ADCFleetList/Status"
        {
            $v = "ACTIVE","CREATE_FAILED","CREATE_IN_PROGRESS","SUSPENDED","UPDATE_FAILED","UPDATE_IN_PROGRESS"
            break
        }

        # Amazon.Deadline.JobAttachmentsFileSystem
        "New-ADCJob/Attachments_FileSystem"
        {
            $v = "COPIED","VIRTUAL"
            break
        }

        # Amazon.Deadline.JobTargetTaskRunStatus
        "Update-ADCJob/TargetTaskRunStatus"
        {
            $v = "CANCELED","FAILED","PENDING","READY","SUCCEEDED","SUSPENDED"
            break
        }

        # Amazon.Deadline.JobTemplateType
        "New-ADCJob/TemplateType"
        {
            $v = "JSON","YAML"
            break
        }

        # Amazon.Deadline.LogicalOperator
        {
            ($_ -eq "Search-ADCJob/FilterExpressions_Operator") -Or
            ($_ -eq "Search-ADCStep/FilterExpressions_Operator") -Or
            ($_ -eq "Search-ADCTask/FilterExpressions_Operator") -Or
            ($_ -eq "Search-ADCWorker/FilterExpressions_Operator")
        }
        {
            $v = "AND","OR"
            break
        }

        # Amazon.Deadline.MembershipLevel
        {
            ($_ -eq "Add-ADCMemberToFarm/MembershipLevel") -Or
            ($_ -eq "Add-ADCMemberToFleet/MembershipLevel") -Or
            ($_ -eq "Add-ADCMemberToJob/MembershipLevel") -Or
            ($_ -eq "Add-ADCMemberToQueue/MembershipLevel")
        }
        {
            $v = "CONTRIBUTOR","MANAGER","OWNER","VIEWER"
            break
        }

        # Amazon.Deadline.Period
        "Start-ADCSessionsStatisticsAggregation/Period"
        {
            $v = "DAILY","HOURLY","MONTHLY","WEEKLY"
            break
        }

        # Amazon.Deadline.PrincipalType
        {
            ($_ -eq "Add-ADCMemberToFarm/PrincipalType") -Or
            ($_ -eq "Add-ADCMemberToFleet/PrincipalType") -Or
            ($_ -eq "Add-ADCMemberToJob/PrincipalType") -Or
            ($_ -eq "Add-ADCMemberToQueue/PrincipalType")
        }
        {
            $v = "GROUP","USER"
            break
        }

        # Amazon.Deadline.QueueStatus
        "Get-ADCQueueList/Status"
        {
            $v = "IDLE","SCHEDULING","SCHEDULING_BLOCKED"
            break
        }

        # Amazon.Deadline.RunAs
        {
            ($_ -eq "New-ADCQueue/JobRunAsUser_RunAs") -Or
            ($_ -eq "Update-ADCQueue/JobRunAsUser_RunAs")
        }
        {
            $v = "QUEUE_CONFIGURED_USER","WORKER_AGENT_USER"
            break
        }

        # Amazon.Deadline.ServiceManagedFleetOperatingSystemFamily
        {
            ($_ -eq "New-ADCFleet/InstanceCapabilities_OsFamily") -Or
            ($_ -eq "Update-ADCFleet/InstanceCapabilities_OsFamily")
        }
        {
            $v = "LINUX","WINDOWS"
            break
        }

        # Amazon.Deadline.SessionLifecycleTargetStatus
        "Update-ADCSession/TargetLifecycleStatus"
        {
            $v = "ENDED"
            break
        }

        # Amazon.Deadline.StepTargetTaskRunStatus
        "Update-ADCStep/TargetTaskRunStatus"
        {
            $v = "CANCELED","FAILED","PENDING","READY","SUCCEEDED","SUSPENDED"
            break
        }

        # Amazon.Deadline.StorageProfileOperatingSystemFamily
        {
            ($_ -eq "New-ADCStorageProfile/OsFamily") -Or
            ($_ -eq "Update-ADCStorageProfile/OsFamily")
        }
        {
            $v = "LINUX","MACOS","WINDOWS"
            break
        }

        # Amazon.Deadline.TagPropagationMode
        {
            ($_ -eq "New-ADCFleet/CustomerManaged_TagPropagationMode") -Or
            ($_ -eq "Update-ADCFleet/CustomerManaged_TagPropagationMode")
        }
        {
            $v = "NO_PROPAGATION","PROPAGATE_TAGS_TO_WORKERS_AT_LAUNCH"
            break
        }

        # Amazon.Deadline.TaskTargetRunStatus
        "Update-ADCTask/TargetRunStatus"
        {
            $v = "CANCELED","FAILED","PENDING","READY","SUCCEEDED","SUSPENDED"
            break
        }

        # Amazon.Deadline.UpdatedWorkerStatus
        "Update-ADCWorker/Status"
        {
            $v = "STARTED","STOPPED","STOPPING"
            break
        }

        # Amazon.Deadline.UpdateJobLifecycleStatus
        "Update-ADCJob/LifecycleStatus"
        {
            $v = "ARCHIVED"
            break
        }

        # Amazon.Deadline.UpdateQueueFleetAssociationStatus
        "Update-ADCQueueFleetAssociation/Status"
        {
            $v = "ACTIVE","STOP_SCHEDULING_AND_CANCEL_TASKS","STOP_SCHEDULING_AND_COMPLETE_TASKS"
            break
        }

        # Amazon.Deadline.UpdateQueueLimitAssociationStatus
        "Update-ADCQueueLimitAssociation/Status"
        {
            $v = "ACTIVE","STOP_LIMIT_USAGE_AND_CANCEL_TASKS","STOP_LIMIT_USAGE_AND_COMPLETE_TASKS"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ADC_map = @{
    "Attachments_FileSystem"=@("New-ADCJob")
    "CustomerManaged_Mode"=@("New-ADCFleet","Update-ADCFleet")
    "CustomerManaged_TagPropagationMode"=@("New-ADCFleet","Update-ADCFleet")
    "DefaultBudgetAction"=@("New-ADCQueue","Update-ADCQueue")
    "FilterExpressions_Operator"=@("Search-ADCJob","Search-ADCStep","Search-ADCTask","Search-ADCWorker")
    "InstanceCapabilities_CpuArchitectureType"=@("New-ADCFleet","Update-ADCFleet")
    "InstanceCapabilities_OsFamily"=@("New-ADCFleet","Update-ADCFleet")
    "InstanceMarketOptions_Type"=@("New-ADCFleet","Update-ADCFleet")
    "JobRunAsUser_RunAs"=@("New-ADCQueue","Update-ADCQueue")
    "LifecycleStatus"=@("Update-ADCJob")
    "MembershipLevel"=@("Add-ADCMemberToFarm","Add-ADCMemberToFleet","Add-ADCMemberToJob","Add-ADCMemberToQueue")
    "OsFamily"=@("New-ADCStorageProfile","Update-ADCStorageProfile")
    "Period"=@("Start-ADCSessionsStatisticsAggregation")
    "PrincipalType"=@("Add-ADCMemberToFarm","Add-ADCMemberToFleet","Add-ADCMemberToJob","Add-ADCMemberToQueue")
    "Status"=@("Get-ADCBudgetList","Get-ADCFleetList","Get-ADCQueueList","Update-ADCBudget","Update-ADCQueueFleetAssociation","Update-ADCQueueLimitAssociation","Update-ADCWorker")
    "TargetLifecycleStatus"=@("Update-ADCSession")
    "TargetRunStatus"=@("Update-ADCTask")
    "TargetTaskRunStatus"=@("New-ADCJob","Update-ADCJob","Update-ADCStep")
    "TemplateType"=@("New-ADCJob","New-ADCQueueEnvironment","Update-ADCQueueEnvironment")
    "WorkerCapabilities_CpuArchitectureType"=@("New-ADCFleet","Update-ADCFleet")
    "WorkerCapabilities_OsFamily"=@("New-ADCFleet","Update-ADCFleet")
}

_awsArgumentCompleterRegistration $ADC_Completers $ADC_map

$ADC_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.ADC.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ADC_SelectMap = @{
    "Select"=@("Add-ADCMemberToFarm",
               "Add-ADCMemberToFleet",
               "Add-ADCMemberToJob",
               "Add-ADCMemberToQueue",
               "Get-ADCFleetRoleForRead",
               "Get-ADCFleetRoleForWorker",
               "Get-ADCQueueRoleForRead",
               "Get-ADCQueueRoleForUser",
               "Get-ADCQueueRoleForWorker",
               "Get-ADCBatchJobEntity",
               "Copy-ADCJobTemplate",
               "New-ADCBudget",
               "New-ADCFarm",
               "New-ADCFleet",
               "New-ADCJob",
               "New-ADCLicenseEndpoint",
               "New-ADCLimit",
               "New-ADCMonitor",
               "New-ADCQueue",
               "New-ADCQueueEnvironment",
               "New-ADCQueueFleetAssociation",
               "New-ADCQueueLimitAssociation",
               "New-ADCStorageProfile",
               "New-ADCWorker",
               "Remove-ADCBudget",
               "Remove-ADCFarm",
               "Remove-ADCFleet",
               "Remove-ADCLicenseEndpoint",
               "Remove-ADCLimit",
               "Remove-ADCMeteredProduct",
               "Remove-ADCMonitor",
               "Remove-ADCQueue",
               "Remove-ADCQueueEnvironment",
               "Remove-ADCQueueFleetAssociation",
               "Remove-ADCQueueLimitAssociation",
               "Remove-ADCStorageProfile",
               "Remove-ADCWorker",
               "Remove-ADCMemberFromFarm",
               "Remove-ADCMemberFromFleet",
               "Remove-ADCMemberFromJob",
               "Remove-ADCMemberFromQueue",
               "Get-ADCBudget",
               "Get-ADCFarm",
               "Get-ADCFleet",
               "Get-ADCJob",
               "Get-ADCLicenseEndpoint",
               "Get-ADCLimit",
               "Get-ADCMonitor",
               "Get-ADCQueue",
               "Get-ADCQueueEnvironment",
               "Get-ADCQueueFleetAssociation",
               "Get-ADCQueueLimitAssociation",
               "Get-ADCSession",
               "Get-ADCSessionAction",
               "Get-ADCSessionsStatisticsAggregation",
               "Get-ADCStep",
               "Get-ADCStorageProfile",
               "Get-ADCStorageProfileForQueue",
               "Get-ADCTask",
               "Get-ADCWorker",
               "Get-ADCAvailableMeteredProductList",
               "Get-ADCBudgetList",
               "Get-ADCFarmMemberList",
               "Get-ADCFarmList",
               "Get-ADCFleetMemberList",
               "Get-ADCFleetList",
               "Get-ADCJobMemberList",
               "Get-ADCJobParameterDefinitionList",
               "Get-ADCJobList",
               "Get-ADCLicenseEndpointList",
               "Get-ADCLimitList",
               "Get-ADCMeteredProductList",
               "Get-ADCMonitorList",
               "Get-ADCQueueEnvironmentList",
               "Get-ADCQueueFleetAssociationList",
               "Get-ADCQueueLimitAssociationList",
               "Get-ADCQueueMemberList",
               "Get-ADCQueueList",
               "Get-ADCSessionActionList",
               "Get-ADCSessionList",
               "Get-ADCSessionsForWorkerList",
               "Get-ADCStepConsumerList",
               "Get-ADCStepDependencyList",
               "Get-ADCStepList",
               "Get-ADCStorageProfileList",
               "Get-ADCStorageProfilesForQueueList",
               "Get-ADCResourceTag",
               "Get-ADCTaskList",
               "Get-ADCWorkerList",
               "Write-ADCMeteredProduct",
               "Search-ADCJob",
               "Search-ADCStep",
               "Search-ADCTask",
               "Search-ADCWorker",
               "Start-ADCSessionsStatisticsAggregation",
               "Add-ADCResourceTag",
               "Remove-ADCResourceTag",
               "Update-ADCBudget",
               "Update-ADCFarm",
               "Update-ADCFleet",
               "Update-ADCJob",
               "Update-ADCLimit",
               "Update-ADCMonitor",
               "Update-ADCQueue",
               "Update-ADCQueueEnvironment",
               "Update-ADCQueueFleetAssociation",
               "Update-ADCQueueLimitAssociation",
               "Update-ADCSession",
               "Update-ADCStep",
               "Update-ADCStorageProfile",
               "Update-ADCTask",
               "Update-ADCWorker",
               "Update-ADCWorkerSchedule")
}

_awsArgumentCompleterRegistration $ADC_SelectCompleters $ADC_SelectMap
# Argument completions for service Amazon Detective


$DTCT_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.Detective.Field
        "Get-DTCTInvestigationList/SortCriteria_Field"
        {
            $v = "CREATED_TIME","SEVERITY","STATUS"
            break
        }

        # Amazon.Detective.IndicatorType
        "Get-DTCTIndicatorList/IndicatorType"
        {
            $v = "FLAGGED_IP_ADDRESS","IMPOSSIBLE_TRAVEL","NEW_ASO","NEW_GEOLOCATION","NEW_USER_AGENT","RELATED_FINDING","RELATED_FINDING_GROUP","TTP_OBSERVED"
            break
        }

        # Amazon.Detective.SortOrder
        "Get-DTCTInvestigationList/SortCriteria_SortOrder"
        {
            $v = "ASC","DESC"
            break
        }

        # Amazon.Detective.State
        "Update-DTCTInvestigationState/State"
        {
            $v = "ACTIVE","ARCHIVED"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DTCT_map = @{
    "IndicatorType"=@("Get-DTCTIndicatorList")
    "SortCriteria_Field"=@("Get-DTCTInvestigationList")
    "SortCriteria_SortOrder"=@("Get-DTCTInvestigationList")
    "State"=@("Update-DTCTInvestigationState")
}

_awsArgumentCompleterRegistration $DTCT_Completers $DTCT_map

$DTCT_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.DTCT.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DTCT_SelectMap = @{
    "Select"=@("Approve-DTCTInvitation",
               "Get-DTCTGraphMemberDatasource",
               "Get-DTCTMembershipDatasource",
               "New-DTCTGraph",
               "New-DTCTMember",
               "Remove-DTCTGraph",
               "Remove-DTCTMember",
               "Get-DTCTOrganizationConfiguration",
               "Disable-DTCTOrganizationAdminAccount",
               "Remove-DTCTMembership",
               "Enable-DTCTOrganizationAdminAccount",
               "Get-DTCTInvestigation",
               "Get-DTCTMember",
               "Get-DTCTDatasourcePackageList",
               "Get-DTCTGraphList",
               "Get-DTCTIndicatorList",
               "Get-DTCTInvestigationList",
               "Get-DTCTInvitationList",
               "Get-DTCTMemberList",
               "Get-DTCTOrganizationAdminAccountList",
               "Get-DTCTResourceTag",
               "Deny-DTCTInvitation",
               "Start-DTCTInvestigation",
               "Start-DTCTMonitoringMember",
               "Add-DTCTResourceTag",
               "Remove-DTCTResourceTag",
               "Update-DTCTDatasourcePackage",
               "Update-DTCTInvestigationState",
               "Update-DTCTOrganizationConfiguration")
}

_awsArgumentCompleterRegistration $DTCT_SelectCompleters $DTCT_SelectMap
# Argument completions for service AWS Device Farm


$DF_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.DeviceFarm.ArtifactCategory
        "Get-DFArtifactList/Type"
        {
            $v = "FILE","LOG","SCREENSHOT"
            break
        }

        # Amazon.DeviceFarm.BillingMethod
        {
            ($_ -eq "Get-DFDevicePoolCompatibility/Configuration_BillingMethod") -Or
            ($_ -eq "New-DFRemoteAccessSession/Configuration_BillingMethod") -Or
            ($_ -eq "Submit-DFTestRun/Configuration_BillingMethod")
        }
        {
            $v = "METERED","UNMETERED"
            break
        }

        # Amazon.DeviceFarm.DevicePoolType
        "Get-DFDevicePoolList/Type"
        {
            $v = "CURATED","PRIVATE"
            break
        }

        # Amazon.DeviceFarm.InteractionMode
        "New-DFRemoteAccessSession/InteractionMode"
        {
            $v = "INTERACTIVE","NO_VIDEO","VIDEO_ONLY"
            break
        }

        # Amazon.DeviceFarm.NetworkProfileType
        {
            ($_ -eq "Get-DFNetworkProfileList/Type") -Or
            ($_ -eq "New-DFNetworkProfile/Type") -Or
            ($_ -eq "Update-DFNetworkProfile/Type")
        }
        {
            $v = "CURATED","PRIVATE"
            break
        }

        # Amazon.DeviceFarm.TestGridSessionArtifactCategory
        "Get-DFTestGridSessionArtifactList/Type"
        {
            $v = "LOG","VIDEO"
            break
        }

        # Amazon.DeviceFarm.TestGridSessionStatus
        "Get-DFTestGridSessionList/Status"
        {
            $v = "ACTIVE","CLOSED","ERRORED"
            break
        }

        # Amazon.DeviceFarm.TestType
        {
            ($_ -eq "Get-DFDevicePoolCompatibility/Test_Type") -Or
            ($_ -eq "Submit-DFTestRun/Test_Type") -Or
            ($_ -eq "Get-DFDevicePoolCompatibility/TestType")
        }
        {
            $v = "APPIUM_JAVA_JUNIT","APPIUM_JAVA_TESTNG","APPIUM_NODE","APPIUM_PYTHON","APPIUM_RUBY","APPIUM_WEB_JAVA_JUNIT","APPIUM_WEB_JAVA_TESTNG","APPIUM_WEB_NODE","APPIUM_WEB_PYTHON","APPIUM_WEB_RUBY","BUILTIN_FUZZ","INSTRUMENTATION","XCTEST","XCTEST_UI"
            break
        }

        # Amazon.DeviceFarm.UploadType
        {
            ($_ -eq "Get-DFUploadList/Type") -Or
            ($_ -eq "New-DFUpload/Type")
        }
        {
            $v = "ANDROID_APP","APPIUM_JAVA_JUNIT_TEST_PACKAGE","APPIUM_JAVA_JUNIT_TEST_SPEC","APPIUM_JAVA_TESTNG_TEST_PACKAGE","APPIUM_JAVA_TESTNG_TEST_SPEC","APPIUM_NODE_TEST_PACKAGE","APPIUM_NODE_TEST_SPEC","APPIUM_PYTHON_TEST_PACKAGE","APPIUM_PYTHON_TEST_SPEC","APPIUM_RUBY_TEST_PACKAGE","APPIUM_RUBY_TEST_SPEC","APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE","APPIUM_WEB_JAVA_JUNIT_TEST_SPEC","APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE","APPIUM_WEB_JAVA_TESTNG_TEST_SPEC","APPIUM_WEB_NODE_TEST_PACKAGE","APPIUM_WEB_NODE_TEST_SPEC","APPIUM_WEB_PYTHON_TEST_PACKAGE","APPIUM_WEB_PYTHON_TEST_SPEC","APPIUM_WEB_RUBY_TEST_PACKAGE","APPIUM_WEB_RUBY_TEST_SPEC","CALABASH_TEST_PACKAGE","EXTERNAL_DATA","INSTRUMENTATION_TEST_PACKAGE","INSTRUMENTATION_TEST_SPEC","IOS_APP","UIAUTOMATION_TEST_PACKAGE","UIAUTOMATOR_TEST_PACKAGE","WEB_APP","XCTEST_TEST_PACKAGE","XCTEST_UI_TEST_PACKAGE","XCTEST_UI_TEST_SPEC"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DF_map = @{
    "Configuration_BillingMethod"=@("Get-DFDevicePoolCompatibility","New-DFRemoteAccessSession","Submit-DFTestRun")
    "InteractionMode"=@("New-DFRemoteAccessSession")
    "Status"=@("Get-DFTestGridSessionList")
    "Test_Type"=@("Get-DFDevicePoolCompatibility","Submit-DFTestRun")
    "TestType"=@("Get-DFDevicePoolCompatibility")
    "Type"=@("Get-DFArtifactList","Get-DFDevicePoolList","Get-DFNetworkProfileList","Get-DFTestGridSessionArtifactList","Get-DFUploadList","New-DFNetworkProfile","New-DFUpload","Update-DFNetworkProfile")
}

_awsArgumentCompleterRegistration $DF_Completers $DF_map

$DF_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.DF.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DF_SelectMap = @{
    "Select"=@("New-DFDevicePool",
               "New-DFInstanceProfile",
               "New-DFNetworkProfile",
               "New-DFProject",
               "New-DFRemoteAccessSession",
               "New-DFTestGridProject",
               "New-DFTestGridUrl",
               "New-DFUpload",
               "New-DFVPCEConfiguration",
               "Remove-DFDevicePool",
               "Remove-DFInstanceProfile",
               "Remove-DFNetworkProfile",
               "Remove-DFProject",
               "Remove-DFRemoteAccessSession",
               "Remove-DFRun",
               "Remove-DFTestGridProject",
               "Remove-DFUpload",
               "Remove-DFVPCEConfiguration",
               "Get-DFAccountSettingList",
               "Get-DFDevice",
               "Get-DFDeviceInstance",
               "Get-DFDevicePool",
               "Get-DFDevicePoolCompatibility",
               "Get-DFInstanceProfile",
               "Get-DFJob",
               "Get-DFNetworkProfile",
               "Get-DFOfferingStatus",
               "Get-DFProject",
               "Get-DFRemoteAccessSession",
               "Get-DFRun",
               "Get-DFSuite",
               "Get-DFTest",
               "Get-DFTestGridProject",
               "Get-DFTestGridSession",
               "Get-DFUpload",
               "Get-DFVPCEConfiguration",
               "Install-DFToRemoteAccessSession",
               "Get-DFArtifactList",
               "Get-DFDeviceInstanceList",
               "Get-DFDevicePoolList",
               "Get-DFDeviceList",
               "Get-DFInstanceProfileList",
               "Get-DFJobList",
               "Get-DFNetworkProfileList",
               "Get-DFOfferingPromotion",
               "Get-DFOffering",
               "Get-DFOfferingTransaction",
               "Get-DFProjectList",
               "Get-DFRemoteAccessSessionList",
               "Get-DFRunList",
               "Get-DFSampleList",
               "Get-DFSuiteList",
               "Get-DFResourceTag",
               "Get-DFTestGridProjectList",
               "Get-DFTestGridSessionActionList",
               "Get-DFTestGridSessionArtifactList",
               "Get-DFTestGridSessionList",
               "Get-DFTestList",
               "Get-DFUniqueProblemList",
               "Get-DFUploadList",
               "Get-DFVPCEConfigurationList",
               "New-DFOfferingPurchase",
               "New-DFOfferingRenewal",
               "Submit-DFTestRun",
               "Stop-DFJob",
               "Stop-DFRemoteAccessSession",
               "Stop-DFRun",
               "Add-DFResourceTag",
               "Remove-DFResourceTag",
               "Update-DFDeviceInstance",
               "Update-DFDevicePool",
               "Update-DFInstanceProfile",
               "Update-DFNetworkProfile",
               "Update-DFProject",
               "Update-DFTestGridProject",
               "Update-DFUpload",
               "Update-DFVPCEConfiguration")
}

_awsArgumentCompleterRegistration $DF_SelectCompleters $DF_SelectMap
# Argument completions for service Amazon DevOps Guru


$DGURU_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.DevOpsGuru.EventClass
        "Get-DGURUEventList/Filters_EventClass"
        {
            $v = "CONFIG_CHANGE","DEPLOYMENT","INFRASTRUCTURE","SCHEMA_CHANGE","SECURITY_CHANGE"
            break
        }

        # Amazon.DevOpsGuru.EventDataSource
        "Get-DGURUEventList/Filters_DataSource"
        {
            $v = "AWS_CLOUD_TRAIL","AWS_CODE_DEPLOY"
            break
        }

        # Amazon.DevOpsGuru.EventSourceOptInStatus
        "Update-DGURUEventSourcesConfig/AmazonCodeGuruProfiler_Status"
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.DevOpsGuru.InsightType
        {
            ($_ -eq "Get-DGURUOrganizationInsightList/Any_Type") -Or
            ($_ -eq "Get-DGURUOrganizationInsightList/Closed_Type") -Or
            ($_ -eq "Get-DGURUOrganizationInsightList/Ongoing_Type") -Or
            ($_ -eq "Search-DGURUInsight/Type") -Or
            ($_ -eq "Search-DGURUOrganizationInsight/Type")
        }
        {
            $v = "PROACTIVE","REACTIVE"
            break
        }

        # Amazon.DevOpsGuru.Locale
        "Get-DGURURecommendationList/Locale"
        {
            $v = "DE_DE","EN_GB","EN_US","ES_ES","FR_FR","IT_IT","JA_JP","KO_KR","PT_BR","ZH_CN","ZH_TW"
            break
        }

        # Amazon.DevOpsGuru.OptInStatus
        {
            ($_ -eq "Update-DGURUServiceIntegration/KMSServerSideEncryption_OptInStatus") -Or
            ($_ -eq "Update-DGURUServiceIntegration/LogsAnomalyDetection_OptInStatus")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }

        # Amazon.DevOpsGuru.OrganizationResourceCollectionType
        "Get-DGURUOrganizationResourceCollectionHealth/OrganizationResourceCollectionType"
        {
            $v = "AWS_ACCOUNT","AWS_CLOUD_FORMATION","AWS_SERVICE","AWS_TAGS"
            break
        }

        # Amazon.DevOpsGuru.ResourceCollectionType
        {
            ($_ -eq "Get-DGURUResourceCollection/ResourceCollectionType") -Or
            ($_ -eq "Get-DGURUResourceCollectionHealth/ResourceCollectionType")
        }
        {
            $v = "AWS_CLOUD_FORMATION","AWS_SERVICE","AWS_TAGS"
            break
        }

        # Amazon.DevOpsGuru.ResourcePermission
        "Get-DGURUMonitoredResourceList/Filters_ResourcePermission"
        {
            $v = "FULL_PERMISSION","MISSING_PERMISSION"
            break
        }

        # Amazon.DevOpsGuru.ServerSideEncryptionType
        "Update-DGURUServiceIntegration/KMSServerSideEncryption_Type"
        {
            $v = "AWS_OWNED_KMS_KEY","CUSTOMER_MANAGED_KEY"
            break
        }

        # Amazon.DevOpsGuru.UpdateResourceCollectionAction
        "Update-DGURUResourceCollection/Action"
        {
            $v = "ADD","REMOVE"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DGURU_map = @{
    "Action"=@("Update-DGURUResourceCollection")
    "AmazonCodeGuruProfiler_Status"=@("Update-DGURUEventSourcesConfig")
    "Any_Type"=@("Get-DGURUOrganizationInsightList")
    "Closed_Type"=@("Get-DGURUOrganizationInsightList")
    "Filters_DataSource"=@("Get-DGURUEventList")
    "Filters_EventClass"=@("Get-DGURUEventList")
    "Filters_ResourcePermission"=@("Get-DGURUMonitoredResourceList")
    "KMSServerSideEncryption_OptInStatus"=@("Update-DGURUServiceIntegration")
    "KMSServerSideEncryption_Type"=@("Update-DGURUServiceIntegration")
    "Locale"=@("Get-DGURURecommendationList")
    "LogsAnomalyDetection_OptInStatus"=@("Update-DGURUServiceIntegration")
    "Ongoing_Type"=@("Get-DGURUOrganizationInsightList")
    "OrganizationResourceCollectionType"=@("Get-DGURUOrganizationResourceCollectionHealth")
    "ResourceCollectionType"=@("Get-DGURUResourceCollection","Get-DGURUResourceCollectionHealth")
    "Type"=@("Search-DGURUInsight","Search-DGURUOrganizationInsight")
}

_awsArgumentCompleterRegistration $DGURU_Completers $DGURU_map

$DGURU_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.DGURU.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DGURU_SelectMap = @{
    "Select"=@("Add-DGURUNotificationChannel",
               "Remove-DGURUInsight",
               "Get-DGURUAccountHealth",
               "Get-DGURUAccountOverview",
               "Get-DGURUAnomaly",
               "Get-DGURUEventSourcesConfig",
               "Get-DGURUFeedback",
               "Get-DGURUInsight",
               "Get-DGURUOrganizationHealth",
               "Get-DGURUOrganizationOverview",
               "Get-DGURUOrganizationResourceCollectionHealth",
               "Get-DGURUResourceCollectionHealth",
               "Get-DGURUServiceIntegration",
               "Get-DGURUCostEstimation",
               "Get-DGURUResourceCollection",
               "Get-DGURUAnomaliesForInsightList",
               "Get-DGURUAnomalousLogGroupList",
               "Get-DGURUEventList",
               "Get-DGURUInsightList",
               "Get-DGURUMonitoredResourceList",
               "Get-DGURUNotificationChannelList",
               "Get-DGURUOrganizationInsightList",
               "Get-DGURURecommendationList",
               "Write-DGURUFeedback",
               "Remove-DGURUNotificationChannel",
               "Search-DGURUInsight",
               "Search-DGURUOrganizationInsight",
               "Start-DGURUCostEstimation",
               "Update-DGURUEventSourcesConfig",
               "Update-DGURUResourceCollection",
               "Update-DGURUServiceIntegration")
}

_awsArgumentCompleterRegistration $DGURU_SelectCompleters $DGURU_SelectMap
# Argument completions for service AWS Direct Connect


$DC_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.DirectConnect.AddressFamily
        {
            ($_ -eq "New-DCBGPPeer/NewBGPPeer_AddressFamily") -Or
            ($_ -eq "New-DCPrivateVirtualInterface/NewPrivateVirtualInterface_AddressFamily") -Or
            ($_ -eq "Enable-DCPrivateVirtualInterface/NewPrivateVirtualInterfaceAllocation_AddressFamily") -Or
            ($_ -eq "New-DCPublicVirtualInterface/NewPublicVirtualInterface_AddressFamily") -Or
            ($_ -eq "Enable-DCPublicVirtualInterface/NewPublicVirtualInterfaceAllocation_AddressFamily") -Or
            ($_ -eq "New-DCTransitVirtualInterface/NewTransitVirtualInterface_AddressFamily") -Or
            ($_ -eq "Enable-DCTransitVirtualInterface/NewTransitVirtualInterfaceAllocation_AddressFamily")
        }
        {
            $v = "ipv4","ipv6"
            break
        }

        # Amazon.DirectConnect.LoaContentType
        {
            ($_ -eq "Get-DCConnectionLoa/LoaContentType") -Or
            ($_ -eq "Get-DCInterconnectLoa/LoaContentType") -Or
            ($_ -eq "Get-DCLoa/LoaContentType")
        }
        {
            $v = "application/pdf"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DC_map = @{
    "LoaContentType"=@("Get-DCConnectionLoa","Get-DCInterconnectLoa","Get-DCLoa")
    "NewBGPPeer_AddressFamily"=@("New-DCBGPPeer")
    "NewPrivateVirtualInterface_AddressFamily"=@("New-DCPrivateVirtualInterface")
    "NewPrivateVirtualInterfaceAllocation_AddressFamily"=@("Enable-DCPrivateVirtualInterface")
    "NewPublicVirtualInterface_AddressFamily"=@("New-DCPublicVirtualInterface")
    "NewPublicVirtualInterfaceAllocation_AddressFamily"=@("Enable-DCPublicVirtualInterface")
    "NewTransitVirtualInterface_AddressFamily"=@("New-DCTransitVirtualInterface")
    "NewTransitVirtualInterfaceAllocation_AddressFamily"=@("Enable-DCTransitVirtualInterface")
}

_awsArgumentCompleterRegistration $DC_Completers $DC_map

$DC_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.DC.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DC_SelectMap = @{
    "Select"=@("Confirm-DCDirectConnectGatewayAssociationProposal",
               "Enable-DCConnectionOnInterconnect",
               "New-DCHostedConnection",
               "Enable-DCPrivateVirtualInterface",
               "Enable-DCPublicVirtualInterface",
               "Enable-DCTransitVirtualInterface",
               "Register-DCConnectionWithLag",
               "Register-DCHostedConnection",
               "Add-DCMacSecKey",
               "Register-DCVirtualInterface",
               "Confirm-DCConnection",
               "Confirm-DCCustomerAgreement",
               "Confirm-DCPrivateVirtualInterface",
               "Confirm-DCPublicVirtualInterface",
               "Confirm-DCTransitVirtualInterface",
               "New-DCBGPPeer",
               "New-DCConnection",
               "New-DCGateway",
               "New-DCGatewayAssociation",
               "New-DCDirectConnectGatewayAssociationProposal",
               "New-DCInterconnect",
               "New-DCLag",
               "New-DCPrivateVirtualInterface",
               "New-DCPublicVirtualInterface",
               "New-DCTransitVirtualInterface",
               "Remove-DCBGPPeer",
               "Remove-DCConnection",
               "Remove-DCGateway",
               "Remove-DCGatewayAssociation",
               "Remove-DCDirectConnectGatewayAssociationProposal",
               "Remove-DCInterconnect",
               "Remove-DCLag",
               "Remove-DCVirtualInterface",
               "Get-DCConnectionLoa",
               "Get-DCConnection",
               "Get-DCConnectionsOnInterconnect",
               "Get-DCCustomerMetadata",
               "Get-DCDirectConnectGatewayAssociationProposal",
               "Get-DCGatewayAssociation",
               "Get-DCGatewayAttachment",
               "Get-DCGateway",
               "Get-DCHostedConnection",
               "Get-DCInterconnectLoa",
               "Get-DCInterconnect",
               "Get-DCLag",
               "Get-DCLoa",
               "Get-DCLocation",
               "Get-DCRouterConfiguration",
               "Get-DCResourceTag",
               "Get-DCVirtualGateway",
               "Get-DCVirtualInterface",
               "Unregister-DCConnectionFromLag",
               "Remove-DCMacSecKey",
               "Get-DCVirtualInterfaceTestHistoryList",
               "Start-DCBgpFailoverTest",
               "Stop-DCBgpFailoverTest",
               "Add-DCResourceTag",
               "Remove-DCResourceTag",
               "Update-DCConnection",
               "Update-DCDirectConnectGateway",
               "Update-DCDirectConnectGatewayAssociation",
               "Update-DCLag",
               "Update-DCVirtualInterfaceAttribute")
}

_awsArgumentCompleterRegistration $DC_SelectCompleters $DC_SelectMap
# Argument completions for service AWS Directory Service Data


$DSD_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.DirectoryServiceData.GroupScope
        {
            ($_ -eq "New-DSDGroup/GroupScope") -Or
            ($_ -eq "Update-DSDGroup/GroupScope")
        }
        {
            $v = "BuiltinLocal","DomainLocal","Global","Universal"
            break
        }

        # Amazon.DirectoryServiceData.GroupType
        {
            ($_ -eq "New-DSDGroup/GroupType") -Or
            ($_ -eq "Update-DSDGroup/GroupType")
        }
        {
            $v = "Distribution","Security"
            break
        }

        # Amazon.DirectoryServiceData.UpdateType
        {
            ($_ -eq "Update-DSDGroup/UpdateType") -Or
            ($_ -eq "Update-DSDUser/UpdateType")
        }
        {
            $v = "ADD","REMOVE","REPLACE"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DSD_map = @{
    "GroupScope"=@("New-DSDGroup","Update-DSDGroup")
    "GroupType"=@("New-DSDGroup","Update-DSDGroup")
    "UpdateType"=@("Update-DSDGroup","Update-DSDUser")
}

_awsArgumentCompleterRegistration $DSD_Completers $DSD_map

$DSD_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.DSD.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DSD_SelectMap = @{
    "Select"=@("Add-DSDGroupMember",
               "New-DSDGroup",
               "New-DSDUser",
               "Remove-DSDGroup",
               "Remove-DSDUser",
               "Get-DSDGroup",
               "Get-DSDUser",
               "Disable-DSDUser",
               "Get-DSDGroupMemberList",
               "Get-DSDGroupList",
               "Get-DSDGroupsForMemberList",
               "Get-DSDUserList",
               "Remove-DSDGroupMember",
               "Search-DSDGroup",
               "Search-DSDUser",
               "Update-DSDGroup",
               "Update-DSDUser")
}

_awsArgumentCompleterRegistration $DSD_SelectCompleters $DSD_SelectMap
# Argument completions for service AWS Application Discovery Service


$ADS_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.ApplicationDiscoveryService.ConfigurationItemType
        "Get-ADSConfigurationList/ConfigurationType"
        {
            $v = "APPLICATION","CONNECTION","PROCESS","SERVER"
            break
        }

        # Amazon.ApplicationDiscoveryService.DeletionConfigurationItemType
        "Start-ADSBatchDeleteConfigurationTask/ConfigurationType"
        {
            $v = "SERVER"
            break
        }

        # Amazon.ApplicationDiscoveryService.OfferingClass
        "Start-ADSExportTask/ReservedInstanceOptions_OfferingClass"
        {
            $v = "CONVERTIBLE","STANDARD"
            break
        }

        # Amazon.ApplicationDiscoveryService.PurchasingOption
        "Start-ADSExportTask/ReservedInstanceOptions_PurchasingOption"
        {
            $v = "ALL_UPFRONT","NO_UPFRONT","PARTIAL_UPFRONT"
            break
        }

        # Amazon.ApplicationDiscoveryService.Tenancy
        "Start-ADSExportTask/Ec2RecommendationsPreferences_Tenancy"
        {
            $v = "DEDICATED","SHARED"
            break
        }

        # Amazon.ApplicationDiscoveryService.TermLength
        "Start-ADSExportTask/ReservedInstanceOptions_TermLength"
        {
            $v = "ONE_YEAR","THREE_YEAR"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ADS_map = @{
    "ConfigurationType"=@("Get-ADSConfigurationList","Start-ADSBatchDeleteConfigurationTask")
    "Ec2RecommendationsPreferences_Tenancy"=@("Start-ADSExportTask")
    "ReservedInstanceOptions_OfferingClass"=@("Start-ADSExportTask")
    "ReservedInstanceOptions_PurchasingOption"=@("Start-ADSExportTask")
    "ReservedInstanceOptions_TermLength"=@("Start-ADSExportTask")
}

_awsArgumentCompleterRegistration $ADS_Completers $ADS_map

$ADS_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.ADS.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$ADS_SelectMap = @{
    "Select"=@("Add-ADSConfigurationItemsToApplication",
               "Remove-ADSBatchAgent",
               "Remove-ADSImportDataBatch",
               "New-ADSApplication",
               "New-ADSTag",
               "Remove-ADSApplication",
               "Remove-ADSTag",
               "Get-ADSAgent",
               "Get-ADSBatchDeleteConfigurationTask",
               "Get-ADSConfiguration",
               "Get-ADSContinuousExport",
               "Get-ADSExportConfiguration",
               "Get-ADSExportTask",
               "Get-ADSImportTask",
               "Get-ADSTag",
               "Remove-ADSConfigurationItemsFromApplication",
               "Get-ADSExportConfigurationsId",
               "Get-ADSDiscoverySummary",
               "Get-ADSConfigurationList",
               "Get-ADSServerNeighborList",
               "Start-ADSBatchDeleteConfigurationTask",
               "Start-ADSContinuousExport",
               "Start-ADSDataCollectionByAgentId",
               "Start-ADSExportTask",
               "Start-ADSImportTask",
               "Stop-ADSContinuousExport",
               "Stop-ADSDataCollectionByAgentId",
               "Update-ADSApplication")
}

_awsArgumentCompleterRegistration $ADS_SelectCompleters $ADS_SelectMap
# Argument completions for service Amazon Data Lifecycle Manager


$DLM_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.DLM.DefaultPoliciesTypeValues
        "Get-DLMLifecyclePolicySummary/DefaultPolicyType"
        {
            $v = "ALL","INSTANCE","VOLUME"
            break
        }

        # Amazon.DLM.DefaultPolicyTypeValues
        "New-DLMLifecyclePolicy/DefaultPolicy"
        {
            $v = "INSTANCE","VOLUME"
            break
        }

        # Amazon.DLM.EventSourceValues
        {
            ($_ -eq "New-DLMLifecyclePolicy/EventSource_Type") -Or
            ($_ -eq "Update-DLMLifecyclePolicy/EventSource_Type")
        }
        {
            $v = "MANAGED_CWE"
            break
        }

        # Amazon.DLM.EventTypeValues
        {
            ($_ -eq "New-DLMLifecyclePolicy/Parameters_EventType") -Or
            ($_ -eq "Update-DLMLifecyclePolicy/Parameters_EventType")
        }
        {
            $v = "shareSnapshot"
            break
        }

        # Amazon.DLM.GettablePolicyStateValues
        "Get-DLMLifecyclePolicySummary/State"
        {
            $v = "DISABLED","ENABLED","ERROR"
            break
        }

        # Amazon.DLM.PolicyLanguageValues
        {
            ($_ -eq "New-DLMLifecyclePolicy/PolicyDetails_PolicyLanguage") -Or
            ($_ -eq "Update-DLMLifecyclePolicy/PolicyDetails_PolicyLanguage")
        }
        {
            $v = "SIMPLIFIED","STANDARD"
            break
        }

        # Amazon.DLM.PolicyTypeValues
        {
            ($_ -eq "New-DLMLifecyclePolicy/PolicyDetails_PolicyType") -Or
            ($_ -eq "Update-DLMLifecyclePolicy/PolicyDetails_PolicyType")
        }
        {
            $v = "EBS_SNAPSHOT_MANAGEMENT","EVENT_BASED_POLICY","IMAGE_MANAGEMENT"
            break
        }

        # Amazon.DLM.ResourceTypeValues
        {
            ($_ -eq "New-DLMLifecyclePolicy/PolicyDetails_SimplifiedResourceType") -Or
            ($_ -eq "Update-DLMLifecyclePolicy/PolicyDetails_SimplifiedResourceType")
        }
        {
            $v = "INSTANCE","VOLUME"
            break
        }

        # Amazon.DLM.SettablePolicyStateValues
        {
            ($_ -eq "New-DLMLifecyclePolicy/State") -Or
            ($_ -eq "Update-DLMLifecyclePolicy/State")
        }
        {
            $v = "DISABLED","ENABLED"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DLM_map = @{
    "DefaultPolicy"=@("New-DLMLifecyclePolicy")
    "DefaultPolicyType"=@("Get-DLMLifecyclePolicySummary")
    "EventSource_Type"=@("New-DLMLifecyclePolicy","Update-DLMLifecyclePolicy")
    "Parameters_EventType"=@("New-DLMLifecyclePolicy","Update-DLMLifecyclePolicy")
    "PolicyDetails_PolicyLanguage"=@("New-DLMLifecyclePolicy","Update-DLMLifecyclePolicy")
    "PolicyDetails_PolicyType"=@("New-DLMLifecyclePolicy","Update-DLMLifecyclePolicy")
    "PolicyDetails_SimplifiedResourceType"=@("New-DLMLifecyclePolicy","Update-DLMLifecyclePolicy")
    "State"=@("Get-DLMLifecyclePolicySummary","New-DLMLifecyclePolicy","Update-DLMLifecyclePolicy")
}

_awsArgumentCompleterRegistration $DLM_Completers $DLM_map

$DLM_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.DLM.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DLM_SelectMap = @{
    "Select"=@("New-DLMLifecyclePolicy",
               "Remove-DLMLifecyclePolicy",
               "Get-DLMLifecyclePolicySummary",
               "Get-DLMLifecyclePolicy",
               "Get-DLMResourceTag",
               "Add-DLMResourceTag",
               "Remove-DLMResourceTag",
               "Update-DLMLifecyclePolicy")
}

_awsArgumentCompleterRegistration $DLM_SelectCompleters $DLM_SelectMap
# Argument completions for service AWS Database Migration Service


$DMS_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.DatabaseMigrationService.AuthMechanismValue
        {
            ($_ -eq "Edit-DMSDataProvider/MongoDbSettings_AuthMechanism") -Or
            ($_ -eq "Edit-DMSEndpoint/MongoDbSettings_AuthMechanism") -Or
            ($_ -eq "New-DMSDataProvider/MongoDbSettings_AuthMechanism") -Or
            ($_ -eq "New-DMSEndpoint/MongoDbSettings_AuthMechanism")
        }
        {
            $v = "default","mongodb_cr","scram_sha_1"
            break
        }

        # Amazon.DatabaseMigrationService.AuthTypeValue
        {
            ($_ -eq "Edit-DMSDataProvider/MongoDbSettings_AuthType") -Or
            ($_ -eq "Edit-DMSEndpoint/MongoDbSettings_AuthType") -Or
            ($_ -eq "New-DMSDataProvider/MongoDbSettings_AuthType") -Or
            ($_ -eq "New-DMSEndpoint/MongoDbSettings_AuthType")
        }
        {
            $v = "no","password"
            break
        }

        # Amazon.DatabaseMigrationService.CannedAclForObjectsValue
        {
            ($_ -eq "Edit-DMSEndpoint/S3Settings_CannedAclForObject") -Or
            ($_ -eq "New-DMSEndpoint/S3Settings_CannedAclForObject")
        }
        {
            $v = "authenticated-read","aws-exec-read","bucket-owner-full-control","bucket-owner-read","none","private","public-read","public-read-write"
            break
        }

        # Amazon.DatabaseMigrationService.CharLengthSemantics
        {
            ($_ -eq "Edit-DMSEndpoint/OracleSettings_CharLengthSemantic") -Or
            ($_ -eq "New-DMSEndpoint/OracleSettings_CharLengthSemantic")
        }
        {
            $v = "byte","char","default"
            break
        }

        # Amazon.DatabaseMigrationService.CompressionTypeValue
        {
            ($_ -eq "Edit-DMSEndpoint/S3Settings_CompressionType") -Or
            ($_ -eq "New-DMSEndpoint/S3Settings_CompressionType")
        }
        {
            $v = "gzip","none"
            break
        }

        # Amazon.DatabaseMigrationService.DatabaseMode
        {
            ($_ -eq "Edit-DMSEndpoint/PostgreSQLSettings_DatabaseMode") -Or
            ($_ -eq "New-DMSEndpoint/PostgreSQLSettings_DatabaseMode")
        }
        {
            $v = "babelfish","default"
            break
        }

        # Amazon.DatabaseMigrationService.DataFormatValue
        {
            ($_ -eq "Edit-DMSEndpoint/S3Settings_DataFormat") -Or
            ($_ -eq "New-DMSEndpoint/S3Settings_DataFormat")
        }
        {
            $v = "csv","parquet"
            break
        }

        # Amazon.DatabaseMigrationService.DatePartitionDelimiterValue
        {
            ($_ -eq "Edit-DMSEndpoint/S3Settings_DatePartitionDelimiter") -Or
            ($_ -eq "New-DMSEndpoint/S3Settings_DatePartitionDelimiter")
        }
        {
            $v = "DASH","NONE","SLASH","UNDERSCORE"
            break
        }

        # Amazon.DatabaseMigrationService.DatePartitionSequenceValue
        {
            ($_ -eq "Edit-DMSEndpoint/S3Settings_DatePartitionSequence") -Or
            ($_ -eq "New-DMSEndpoint/S3Settings_DatePartitionSequence")
        }
        {
            $v = "DDMMYYYY","MMYYYYDD","YYYYMM","YYYYMMDD","YYYYMMDDHH"
            break
        }

        # Amazon.DatabaseMigrationService.DmsSslModeValue
        {
            ($_ -eq "Edit-DMSDataProvider/DocDbSettings_SslMode") -Or
            ($_ -eq "New-DMSDataProvider/DocDbSettings_SslMode") -Or
            ($_ -eq "Edit-DMSDataProvider/IbmDb2LuwSettings_SslMode") -Or
            ($_ -eq "New-DMSDataProvider/IbmDb2LuwSettings_SslMode") -Or
            ($_ -eq "Edit-DMSDataProvider/IbmDb2zOsSettings_SslMode") -Or
            ($_ -eq "New-DMSDataProvider/IbmDb2zOsSettings_SslMode") -Or
            ($_ -eq "Edit-DMSDataProvider/MariaDbSettings_SslMode") -Or
            ($_ -eq "New-DMSDataProvider/MariaDbSettings_SslMode") -Or
            ($_ -eq "Edit-DMSDataProvider/MicrosoftSqlServerSettings_SslMode") -Or
            ($_ -eq "New-DMSDataProvider/MicrosoftSqlServerSettings_SslMode") -Or
            ($_ -eq "Edit-DMSDataProvider/MongoDbSettings_SslMode") -Or
            ($_ -eq "New-DMSDataProvider/MongoDbSettings_SslMode") -Or
            ($_ -eq "Edit-DMSDataProvider/MySqlSettings_SslMode") -Or
            ($_ -eq "New-DMSDataProvider/MySqlSettings_SslMode") -Or
            ($_ -eq "Edit-DMSDataProvider/OracleSettings_SslMode") -Or
            ($_ -eq "New-DMSDataProvider/OracleSettings_SslMode") -Or
            ($_ -eq "Edit-DMSDataProvider/PostgreSqlSettings_SslMode") -Or
            ($_ -eq "New-DMSDataProvider/PostgreSqlSettings_SslMode") -Or
            ($_ -eq "Edit-DMSEndpoint/SslMode") -Or
            ($_ -eq "New-DMSEndpoint/SslMode")
        }
        {
            $v = "none","require","verify-ca","verify-full"
            break
        }

        # Amazon.DatabaseMigrationService.EncodingTypeValue
        {
            ($_ -eq "Edit-DMSEndpoint/S3Settings_EncodingType") -Or
            ($_ -eq "New-DMSEndpoint/S3Settings_EncodingType")
        }
        {
            $v = "plain","plain-dictionary","rle-dictionary"
            break
        }

        # Amazon.DatabaseMigrationService.EncryptionModeValue
        {
            ($_ -eq "Edit-DMSEndpoint/RedshiftSettings_EncryptionMode") -Or
            ($_ -eq "New-DMSEndpoint/RedshiftSettings_EncryptionMode") -Or
            ($_ -eq "Edit-DMSEndpoint/S3Settings_EncryptionMode") -Or
            ($_ -eq "New-DMSEndpoint/S3Settings_EncryptionMode")
        }
        {
            $v = "sse-kms","sse-s3"
            break
        }

        # Amazon.DatabaseMigrationService.KafkaSaslMechanism
        {
            ($_ -eq "Edit-DMSEndpoint/KafkaSettings_SaslMechanism") -Or
            ($_ -eq "New-DMSEndpoint/KafkaSettings_SaslMechanism")
        }
        {
            $v = "plain","scram-sha-512"
            break
        }

        # Amazon.DatabaseMigrationService.KafkaSecurityProtocol
        {
            ($_ -eq "Edit-DMSEndpoint/KafkaSettings_SecurityProtocol") -Or
            ($_ -eq "New-DMSEndpoint/KafkaSettings_SecurityProtocol")
        }
        {
            $v = "plaintext","sasl-ssl","ssl-authentication","ssl-encryption"
            break
        }

        # Amazon.DatabaseMigrationService.KafkaSslEndpointIdentificationAlgorithm
        {
            ($_ -eq "Edit-DMSEndpoint/KafkaSettings_SslEndpointIdentificationAlgorithm") -Or
            ($_ -eq "New-DMSEndpoint/KafkaSettings_SslEndpointIdentificationAlgorithm")
        }
        {
            $v = "https","none"
            break
        }

        # Amazon.DatabaseMigrationService.LongVarcharMappingType
        {
            ($_ -eq "Edit-DMSEndpoint/PostgreSQLSettings_MapLongVarcharAs") -Or
            ($_ -eq "New-DMSEndpoint/PostgreSQLSettings_MapLongVarcharAs")
        }
        {
            $v = "clob","nclob","wstring"
            break
        }

        # Amazon.DatabaseMigrationService.MessageFormatValue
        {
            ($_ -eq "Edit-DMSEndpoint/KafkaSettings_MessageFormat") -Or
            ($_ -eq "New-DMSEndpoint/KafkaSettings_MessageFormat") -Or
            ($_ -eq "Edit-DMSEndpoint/KinesisSettings_MessageFormat") -Or
            ($_ -eq "New-DMSEndpoint/KinesisSettings_MessageFormat")
        }
        {
            $v = "json","json-unformatted"
            break
        }

        # Amazon.DatabaseMigrationService.MigrationTypeValue
        {
            ($_ -eq "Edit-DMSDataMigration/DataMigrationType") -Or
            ($_ -eq "New-DMSDataMigration/DataMigrationType") -Or
            ($_ -eq "Edit-DMSReplicationTask/MigrationType") -Or
            ($_ -eq "Get-DMSApplicableIndividualAssessment/MigrationType") -Or
            ($_ -eq "New-DMSReplicationTask/MigrationType") -Or
            ($_ -eq "Edit-DMSReplicationConfig/ReplicationType") -Or
            ($_ -eq "New-DMSReplicationConfig/ReplicationType")
        }
        {
            $v = "cdc","full-load","full-load-and-cdc"
            break
        }

        # Amazon.DatabaseMigrationService.MySQLAuthenticationMethod
        {
            ($_ -eq "Edit-DMSEndpoint/MySQLSettings_AuthenticationMethod") -Or
            ($_ -eq "New-DMSEndpoint/MySQLSettings_AuthenticationMethod")
        }
        {
            $v = "iam","password"
            break
        }

        # Amazon.DatabaseMigrationService.NestingLevelValue
        {
            ($_ -eq "Edit-DMSEndpoint/DocDbSettings_NestingLevel") -Or
            ($_ -eq "New-DMSEndpoint/DocDbSettings_NestingLevel") -Or
            ($_ -eq "Edit-DMSEndpoint/MongoDbSettings_NestingLevel") -Or
            ($_ -eq "New-DMSEndpoint/MongoDbSettings_NestingLevel")
        }
        {
            $v = "none","one"
            break
        }

        # Amazon.DatabaseMigrationService.OracleAuthenticationMethod
        {
            ($_ -eq "Edit-DMSEndpoint/OracleSettings_AuthenticationMethod") -Or
            ($_ -eq "New-DMSEndpoint/OracleSettings_AuthenticationMethod")
        }
        {
            $v = "kerberos","password"
            break
        }

        # Amazon.DatabaseMigrationService.OriginTypeValue
        {
            ($_ -eq "Start-DMSMetadataModelExportAsScript/Origin") -Or
            ($_ -eq "Start-DMSMetadataModelImport/Origin")
        }
        {
            $v = "SOURCE","TARGET"
            break
        }

        # Amazon.DatabaseMigrationService.ParquetVersionValue
        {
            ($_ -eq "Edit-DMSEndpoint/S3Settings_ParquetVersion") -Or
            ($_ -eq "New-DMSEndpoint/S3Settings_ParquetVersion")
        }
        {
            $v = "parquet-1-0","parquet-2-0"
            break
        }

        # Amazon.DatabaseMigrationService.PluginNameValue
        {
            ($_ -eq "Edit-DMSEndpoint/PostgreSQLSettings_PluginName") -Or
            ($_ -eq "New-DMSEndpoint/PostgreSQLSettings_PluginName")
        }
        {
            $v = "no-preference","pglogical","test-decoding"
            break
        }

        # Amazon.DatabaseMigrationService.PostgreSQLAuthenticationMethod
        {
            ($_ -eq "Edit-DMSEndpoint/PostgreSQLSettings_AuthenticationMethod") -Or
            ($_ -eq "New-DMSEndpoint/PostgreSQLSettings_AuthenticationMethod")
        }
        {
            $v = "iam","password"
            break
        }

        # Amazon.DatabaseMigrationService.RedisAuthTypeValue
        {
            ($_ -eq "Edit-DMSEndpoint/RedisSettings_AuthType") -Or
            ($_ -eq "New-DMSEndpoint/RedisSettings_AuthType")
        }
        {
            $v = "auth-role","auth-token","none"
            break
        }

        # Amazon.DatabaseMigrationService.ReloadOptionValue
        {
            ($_ -eq "Restore-DMSReplicationTable/ReloadOption") -Or
            ($_ -eq "Restore-DMSTable/ReloadOption")
        }
        {
            $v = "data-reload","validate-only"
            break
        }

        # Amazon.DatabaseMigrationService.ReplicationEndpointTypeValue
        {
            ($_ -eq "Edit-DMSEndpoint/EndpointType") -Or
            ($_ -eq "New-DMSEndpoint/EndpointType")
        }
        {
            $v = "source","target"
            break
        }

        # Amazon.DatabaseMigrationService.SafeguardPolicy
        {
            ($_ -eq "Edit-DMSEndpoint/MicrosoftSQLServerSettings_SafeguardPolicy") -Or
            ($_ -eq "New-DMSEndpoint/MicrosoftSQLServerSettings_SafeguardPolicy")
        }
        {
            $v = "exclusive-automatic-truncation","rely-on-sql-server-replication-agent","shared-automatic-truncation"
            break
        }

        # Amazon.DatabaseMigrationService.SourceType
        "Get-DMSEvent/SourceType"
        {
            $v = "replication-instance"
            break
        }

        # Amazon.DatabaseMigrationService.SqlServerAuthenticationMethod
        {
            ($_ -eq "Edit-DMSEndpoint/MicrosoftSQLServerSettings_AuthenticationMethod") -Or
            ($_ -eq "New-DMSEndpoint/MicrosoftSQLServerSettings_AuthenticationMethod")
        }
        {
            $v = "kerberos","password"
            break
        }

        # Amazon.DatabaseMigrationService.SslSecurityProtocolValue
        {
            ($_ -eq "Edit-DMSEndpoint/RedisSettings_SslSecurityProtocol") -Or
            ($_ -eq "New-DMSEndpoint/RedisSettings_SslSecurityProtocol")
        }
        {
            $v = "plaintext","ssl-encryption"
            break
        }

        # Amazon.DatabaseMigrationService.StartReplicationMigrationTypeValue
        "Start-DMSDataMigration/StartType"
        {
            $v = "reload-target","resume-processing","start-replication"
            break
        }

        # Amazon.DatabaseMigrationService.StartReplicationTaskTypeValue
        "Start-DMSReplicationTask/StartReplicationTaskType"
        {
            $v = "reload-target","resume-processing","start-replication"
            break
        }

        # Amazon.DatabaseMigrationService.TargetDbType
        {
            ($_ -eq "Edit-DMSEndpoint/GcpMySQLSettings_TargetDbType") -Or
            ($_ -eq "New-DMSEndpoint/GcpMySQLSettings_TargetDbType") -Or
            ($_ -eq "Edit-DMSEndpoint/MySQLSettings_TargetDbType") -Or
            ($_ -eq "New-DMSEndpoint/MySQLSettings_TargetDbType")
        }
        {
            $v = "multiple-databases","specific-database"
            break
        }

        # Amazon.DatabaseMigrationService.TlogAccessMode
        {
            ($_ -eq "Edit-DMSEndpoint/MicrosoftSQLServerSettings_TlogAccessMode") -Or
            ($_ -eq "New-DMSEndpoint/MicrosoftSQLServerSettings_TlogAccessMode")
        }
        {
            $v = "BackupOnly","PreferBackup","PreferTlog","TlogOnly"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DMS_map = @{
    "DataMigrationType"=@("Edit-DMSDataMigration","New-DMSDataMigration")
    "DocDbSettings_NestingLevel"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "DocDbSettings_SslMode"=@("Edit-DMSDataProvider","New-DMSDataProvider")
    "EndpointType"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "GcpMySQLSettings_TargetDbType"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "IbmDb2LuwSettings_SslMode"=@("Edit-DMSDataProvider","New-DMSDataProvider")
    "IbmDb2zOsSettings_SslMode"=@("Edit-DMSDataProvider","New-DMSDataProvider")
    "KafkaSettings_MessageFormat"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "KafkaSettings_SaslMechanism"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "KafkaSettings_SecurityProtocol"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "KafkaSettings_SslEndpointIdentificationAlgorithm"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "KinesisSettings_MessageFormat"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "MariaDbSettings_SslMode"=@("Edit-DMSDataProvider","New-DMSDataProvider")
    "MicrosoftSQLServerSettings_AuthenticationMethod"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "MicrosoftSQLServerSettings_SafeguardPolicy"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "MicrosoftSqlServerSettings_SslMode"=@("Edit-DMSDataProvider","New-DMSDataProvider")
    "MicrosoftSQLServerSettings_TlogAccessMode"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "MigrationType"=@("Edit-DMSReplicationTask","Get-DMSApplicableIndividualAssessment","New-DMSReplicationTask")
    "MongoDbSettings_AuthMechanism"=@("Edit-DMSDataProvider","Edit-DMSEndpoint","New-DMSDataProvider","New-DMSEndpoint")
    "MongoDbSettings_AuthType"=@("Edit-DMSDataProvider","Edit-DMSEndpoint","New-DMSDataProvider","New-DMSEndpoint")
    "MongoDbSettings_NestingLevel"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "MongoDbSettings_SslMode"=@("Edit-DMSDataProvider","New-DMSDataProvider")
    "MySQLSettings_AuthenticationMethod"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "MySqlSettings_SslMode"=@("Edit-DMSDataProvider","New-DMSDataProvider")
    "MySQLSettings_TargetDbType"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "OracleSettings_AuthenticationMethod"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "OracleSettings_CharLengthSemantic"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "OracleSettings_SslMode"=@("Edit-DMSDataProvider","New-DMSDataProvider")
    "Origin"=@("Start-DMSMetadataModelExportAsScript","Start-DMSMetadataModelImport")
    "PostgreSQLSettings_AuthenticationMethod"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "PostgreSQLSettings_DatabaseMode"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "PostgreSQLSettings_MapLongVarcharAs"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "PostgreSQLSettings_PluginName"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "PostgreSqlSettings_SslMode"=@("Edit-DMSDataProvider","New-DMSDataProvider")
    "RedisSettings_AuthType"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "RedisSettings_SslSecurityProtocol"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "RedshiftSettings_EncryptionMode"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "ReloadOption"=@("Restore-DMSReplicationTable","Restore-DMSTable")
    "ReplicationType"=@("Edit-DMSReplicationConfig","New-DMSReplicationConfig")
    "S3Settings_CannedAclForObject"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "S3Settings_CompressionType"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "S3Settings_DataFormat"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "S3Settings_DatePartitionDelimiter"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "S3Settings_DatePartitionSequence"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "S3Settings_EncodingType"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "S3Settings_EncryptionMode"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "S3Settings_ParquetVersion"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "SourceType"=@("Get-DMSEvent")
    "SslMode"=@("Edit-DMSEndpoint","New-DMSEndpoint")
    "StartReplicationTaskType"=@("Start-DMSReplicationTask")
    "StartType"=@("Start-DMSDataMigration")
}

_awsArgumentCompleterRegistration $DMS_Completers $DMS_map

$DMS_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.DMS.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DMS_SelectMap = @{
    "Select"=@("Set-DMSResourceTag",
               "Complete-DMSPendingMaintenanceAction",
               "Start-DMSBatchRecommendation",
               "Stop-DMSReplicationTaskAssessmentRun",
               "New-DMSDataMigration",
               "New-DMSDataProvider",
               "New-DMSEndpoint",
               "New-DMSEventSubscription",
               "New-DMSFleetAdvisorCollector",
               "New-DMSInstanceProfile",
               "New-DMSMigrationProject",
               "New-DMSReplicationConfig",
               "New-DMSReplicationInstance",
               "New-DMSReplicationSubnetGroup",
               "New-DMSReplicationTask",
               "Remove-DMSCertificate",
               "Remove-DMSConnection",
               "Remove-DMSDataMigration",
               "Remove-DMSDataProvider",
               "Remove-DMSEndpoint",
               "Remove-DMSEventSubscription",
               "Remove-DMSFleetAdvisorCollector",
               "Remove-DMSFleetAdvisorDatabaseId",
               "Remove-DMSInstanceProfile",
               "Remove-DMSMigrationProject",
               "Remove-DMSReplicationConfig",
               "Remove-DMSReplicationInstance",
               "Remove-DMSReplicationSubnetGroup",
               "Remove-DMSReplicationTask",
               "Remove-DMSReplicationTaskAssessmentRun",
               "Get-DMSAccountAttribute",
               "Get-DMSApplicableIndividualAssessment",
               "Get-DMSCertificate",
               "Get-DMSConnection",
               "Get-DMSConversionConfiguration",
               "Get-DMSDataMigration",
               "Get-DMSDataProvider",
               "Get-DMSEndpoint",
               "Get-DMSEndpointSetting",
               "Get-DMSEndpointType",
               "Get-DMSEngineVersion",
               "Get-DMSEventCategory",
               "Get-DMSEvent",
               "Get-DMSEventSubscription",
               "Get-DMSExtensionPackAssociation",
               "Get-DMSFleetAdvisorCollector",
               "Get-DMSFleetAdvisorDatabase",
               "Get-DMSFleetAdvisorLsaAnalysis",
               "Get-DMSFleetAdvisorSchemaObjectSummary",
               "Get-DMSFleetAdvisorSchema",
               "Get-DMSInstanceProfile",
               "Get-DMSMetadataModelAssessment",
               "Get-DMSMetadataModelConversion",
               "Get-DMSMetadataModelExportsAsScript",
               "Get-DMSMetadataModelExportsToTarget",
               "Get-DMSMetadataModelImport",
               "Get-DMSMigrationProject",
               "Get-DMSOrderableReplicationInstance",
               "Get-DMSPendingMaintenanceAction",
               "Get-DMSRecommendationLimitation",
               "Get-DMSRecommendation",
               "Get-DMSRefreshSchemasStatus",
               "Get-DMSReplicationConfig",
               "Get-DMSReplicationInstance",
               "Get-DMSReplicationInstanceTaskLog",
               "Get-DMSReplication",
               "Get-DMSReplicationSubnetGroup",
               "Get-DMSReplicationTableStatistic",
               "Get-DMSReplicationTaskAssessmentResult",
               "Get-DMSReplicationTaskAssessmentRun",
               "Get-DMSReplicationTaskIndividualAssessment",
               "Get-DMSReplicationTask",
               "Get-DMSSchema",
               "Get-DMSTableStatistic",
               "Export-DMSMetadataModelAssessment",
               "Import-DMSCertificate",
               "Get-DMSResourceTag",
               "Edit-DMSConversionConfiguration",
               "Edit-DMSDataMigration",
               "Edit-DMSDataProvider",
               "Edit-DMSEndpoint",
               "Edit-DMSEventSubscription",
               "Edit-DMSInstanceProfile",
               "Edit-DMSMigrationProject",
               "Edit-DMSReplicationConfig",
               "Edit-DMSReplicationInstance",
               "Edit-DMSReplicationSubnetGroup",
               "Edit-DMSReplicationTask",
               "Move-DMSReplicationTask",
               "Restart-DMSReplicationInstance",
               "Invoke-DMSSchemaRefresh",
               "Restore-DMSReplicationTable",
               "Restore-DMSTable",
               "Remove-DMSResourceTag",
               "Start-DMSFleetAdvisorLsaAnalysis",
               "Start-DMSDataMigration",
               "Start-DMSExtensionPackAssociation",
               "Start-DMSMetadataModelAssessment",
               "Start-DMSMetadataModelConversion",
               "Start-DMSMetadataModelExportAsScript",
               "Start-DMSMetadataModelExportToTarget",
               "Start-DMSMetadataModelImport",
               "Start-DMSRecommendation",
               "Start-DMSReplication",
               "Start-DMSReplicationTask",
               "Start-DMSReplicationTaskAssessment",
               "Start-DMSReplicationTaskAssessmentRun",
               "Stop-DMSDataMigration",
               "Stop-DMSReplication",
               "Stop-DMSReplicationTask",
               "Test-DMSConnection",
               "Update-DMSSubscriptionsToEventBridge")
}

_awsArgumentCompleterRegistration $DMS_SelectCompleters $DMS_SelectMap
# Argument completions for service Amazon DocumentDB Elastic Clusters


$DOCE_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.DocDBElastic.Auth
        {
            ($_ -eq "New-DOCECluster/AuthType") -Or
            ($_ -eq "Update-DOCECluster/AuthType")
        }
        {
            $v = "PLAIN_TEXT","SECRET_ARN"
            break
        }

        # Amazon.DocDBElastic.OptInType
        "Set-DOCEPendingMaintenanceAction/OptInType"
        {
            $v = "APPLY_ON","IMMEDIATE","NEXT_MAINTENANCE","UNDO_OPT_IN"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DOCE_map = @{
    "AuthType"=@("New-DOCECluster","Update-DOCECluster")
    "OptInType"=@("Set-DOCEPendingMaintenanceAction")
}

_awsArgumentCompleterRegistration $DOCE_Completers $DOCE_map

$DOCE_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.DOCE.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DOCE_SelectMap = @{
    "Select"=@("Set-DOCEPendingMaintenanceAction",
               "Copy-DOCEClusterSnapshot",
               "New-DOCECluster",
               "New-DOCEClusterSnapshot",
               "Remove-DOCECluster",
               "Remove-DOCEClusterSnapshot",
               "Get-DOCECluster",
               "Get-DOCEClusterSnapshot",
               "Get-DOCEPendingMaintenanceAction",
               "Get-DOCEClusterList",
               "Get-DOCEClusterSnapshotList",
               "Get-DOCEPendingMaintenanceActionList",
               "Get-DOCEResourceTag",
               "Restore-DOCEClusterFromSnapshot",
               "Start-DOCECluster",
               "Stop-DOCECluster",
               "Add-DOCEResourceTag",
               "Remove-DOCEResourceTag",
               "Update-DOCECluster")
}

_awsArgumentCompleterRegistration $DOCE_SelectCompleters $DOCE_SelectMap
# Argument completions for service Amazon DocumentDB (with MongoDB compatibility)


$DOC_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.DocDB.SourceType
        "Get-DOCEvent/SourceType"
        {
            $v = "db-cluster","db-cluster-snapshot","db-instance","db-parameter-group","db-security-group","db-snapshot"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DOC_map = @{
    "SourceType"=@("Get-DOCEvent")
}

_awsArgumentCompleterRegistration $DOC_Completers $DOC_map

$DOC_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.DOC.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$DOC_SelectMap = @{
    "Select"=@("Add-DOCSourceIdentifierToSubscription",
               "Add-DOCResourceTag",
               "Complete-DOCPendingMaintenanceAction",
               "Copy-DOCDBClusterParameterGroup",
               "Copy-DOCDBClusterSnapshot",
               "New-DOCDBCluster",
               "New-DOCDBClusterParameterGroup",
               "New-DOCDBClusterSnapshot",
               "New-DOCDBInstance",
               "New-DOCDBSubnetGroup",
               "New-DOCEventSubscription",
               "New-DOCGlobalCluster",
               "Remove-DOCDBCluster",
               "Remove-DOCDBClusterParameterGroup",
               "Remove-DOCDBClusterSnapshot",
               "Remove-DOCDBInstance",
               "Remove-DOCDBSubnetGroup",
               "Remove-DOCEventSubscription",
               "Remove-DOCGlobalCluster",
               "Get-DOCCertificate",
               "Get-DOCDBClusterParameterGroup",
               "Get-DOCDBClusterParameter",
               "Get-DOCDBCluster",
               "Get-DOCDBClusterSnapshotAttribute",
               "Get-DOCDBClusterSnapshot",
               "Get-DOCDBEngineVersion",
               "Get-DOCDBInstance",
               "Get-DOCDBSubnetGroup",
               "Get-DOCEngineDefaultClusterParameter",
               "Get-DOCEventCategory",
               "Get-DOCEvent",
               "Get-DOCEventSubscription",
               "Get-DOCGlobalCluster",
               "Get-DOCOrderableDBInstanceOption",
               "Get-DOCPendingMaintenanceAction",
               "Start-DOCDBClusterFailover",
               "Start-DOCFailoverGlobalCluster",
               "Get-DOCResourceTag",
               "Edit-DOCDBCluster",
               "Edit-DOCDBClusterParameterGroup",
               "Edit-DOCDBClusterSnapshotAttribute",
               "Edit-DOCDBInstance",
               "Edit-DOCDBSubnetGroup",
               "Edit-DOCEventSubscription",
               "Edit-DOCGlobalCluster",
               "Restart-DOCDBInstance",
               "Remove-DOCFromGlobalCluster",
               "Remove-DOCSourceIdentifierFromSubscription",
               "Remove-DOCResourceTag",
               "Reset-DOCDBClusterParameterGroup",
               "Restore-DOCDBClusterFromSnapshot",
               "Restore-DOCDBClusterToPointInTime",
               "Start-DOCDBCluster",
               "Stop-DOCDBCluster",
               "Request-DOCSwitchoverGlobalCluster")
}

_awsArgumentCompleterRegistration $DOC_SelectCompleters $DOC_SelectMap
# Argument completions for service Elastic Disaster Recovery Service


$EDRS_Completers = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    switch ($("$commandName/$parameterName"))
    {
        # Amazon.Drs.LaunchActionCategory
        "Write-EDRSLaunchAction/Category"
        {
            $v = "CONFIGURATION","MONITORING","OTHER","SECURITY","VALIDATION"
            break
        }

        # Amazon.Drs.LaunchDisposition
        {
            ($_ -eq "New-EDRSLaunchConfigurationTemplate/LaunchDisposition") -Or
            ($_ -eq "Update-EDRSLaunchConfiguration/LaunchDisposition") -Or
            ($_ -eq "Update-EDRSLaunchConfigurationTemplate/LaunchDisposition")
        }
        {
            $v = "STARTED","STOPPED"
            break
        }

        # Amazon.Drs.RecoverySnapshotsOrder
        "Get-EDRSRecoverySnapshot/Order"
        {
            $v = "ASC","DESC"
            break
        }

        # Amazon.Drs.ReplicationConfigurationDataPlaneRouting
        {
            ($_ -eq "New-EDRSReplicationConfigurationTemplate/DataPlaneRouting") -Or
            ($_ -eq "Update-EDRSReplicationConfiguration/DataPlaneRouting") -Or
            ($_ -eq "Update-EDRSReplicationConfigurationTemplate/DataPlaneRouting")
        }
        {
            $v = "PRIVATE_IP","PUBLIC_IP"
            break
        }

        # Amazon.Drs.ReplicationConfigurationDefaultLargeStagingDiskType
        {
            ($_ -eq "New-EDRSReplicationConfigurationTemplate/DefaultLargeStagingDiskType") -Or
            ($_ -eq "Update-EDRSReplicationConfiguration/DefaultLargeStagingDiskType") -Or
            ($_ -eq "Update-EDRSReplicationConfigurationTemplate/DefaultLargeStagingDiskType")
        }
        {
            $v = "AUTO","GP2","GP3","ST1"
            break
        }

        # Amazon.Drs.ReplicationConfigurationEbsEncryption
        {
            ($_ -eq "New-EDRSReplicationConfigurationTemplate/EbsEncryption") -Or
            ($_ -eq "Update-EDRSReplicationConfiguration/EbsEncryption") -Or
            ($_ -eq "Update-EDRSReplicationConfigurationTemplate/EbsEncryption")
        }
        {
            $v = "CUSTOM","DEFAULT","NONE"
            break
        }

        # Amazon.Drs.TargetInstanceTypeRightSizingMethod
        {
            ($_ -eq "New-EDRSLaunchConfigurationTemplate/TargetInstanceTypeRightSizingMethod") -Or
            ($_ -eq "Update-EDRSLaunchConfiguration/TargetInstanceTypeRightSizingMethod") -Or
            ($_ -eq "Update-EDRSLaunchConfigurationTemplate/TargetInstanceTypeRightSizingMethod")
        }
        {
            $v = "BASIC","IN_AWS","NONE"
            break
        }


    }

    $v |
        Where-Object { $_ -like "$wordToComplete*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$EDRS_map = @{
    "Category"=@("Write-EDRSLaunchAction")
    "DataPlaneRouting"=@("New-EDRSReplicationConfigurationTemplate","Update-EDRSReplicationConfiguration","Update-EDRSReplicationConfigurationTemplate")
    "DefaultLargeStagingDiskType"=@("New-EDRSReplicationConfigurationTemplate","Update-EDRSReplicationConfiguration","Update-EDRSReplicationConfigurationTemplate")
    "EbsEncryption"=@("New-EDRSReplicationConfigurationTemplate","Update-EDRSReplicationConfiguration","Update-EDRSReplicationConfigurationTemplate")
    "LaunchDisposition"=@("New-EDRSLaunchConfigurationTemplate","Update-EDRSLaunchConfiguration","Update-EDRSLaunchConfigurationTemplate")
    "Order"=@("Get-EDRSRecoverySnapshot")
    "TargetInstanceTypeRightSizingMethod"=@("New-EDRSLaunchConfigurationTemplate","Update-EDRSLaunchConfiguration","Update-EDRSLaunchConfigurationTemplate")
}

_awsArgumentCompleterRegistration $EDRS_Completers $EDRS_map

$EDRS_SelectCompleters = {
    param($commandName, $parameterName, $wordToComplete, $commandAst, $fakeBoundParameter)

    $cmdletType = Invoke-Expression "[Amazon.PowerShell.Cmdlets.EDRS.$($commandName.Replace('-', ''))Cmdlet]"
    if (-not $cmdletType) {
        return
    }
    $awsCmdletAttribute = $cmdletType.GetCustomAttributes([Amazon.PowerShell.Common.AWSCmdletAttribute], $false)
    if (-not $awsCmdletAttribute) {
        return
    }
    $type = $awsCmdletAttribute.SelectReturnType
    if (-not $type) {
        return
    }

    $splitSelect = $wordToComplete -Split '\.'
    $splitSelect | Select-Object -First ($splitSelect.Length - 1) | ForEach-Object {
        $propertyName = $_
        $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')) | Where-Object { $_.Name -ieq $propertyName }
        if ($properties.Length -ne 1) {
            break
        }
        $type = $properties.PropertyType
        $prefix += "$($properties.Name)."

        $asEnumerableType = $type.GetInterface('System.Collections.Generic.IEnumerable`1')
        if ($asEnumerableType -and $type -ne [System.String]) {
            $type =  $asEnumerableType.GetGenericArguments()[0]
        }
    }

    $v = @( '*' )
    $properties = $type.GetProperties(('Instance', 'Public', 'DeclaredOnly')).Name | Sort-Object
    if ($properties) {
        $v += ($properties | ForEach-Object { $prefix + $_ })
    }
    $parameters = $cmdletType.GetProperties(('Instance', 'Public')) | Where-Object { $_.GetCustomAttributes([System.Management.Automation.ParameterAttribute], $true) } | Select-Object -ExpandProperty Name | Sort-Object
    if ($parameters) {
        $v += ($parameters | ForEach-Object { "^$_" })
    }

    $v |
        Where-Object { $_ -match "^$([System.Text.RegularExpressions.Regex]::Escape($wordToComplete)).*" } |
        ForEach-Object { New-Object System.Management.Automation.CompletionResult $_, $_, 'ParameterValue', $_ }
}

$EDRS_SelectMap = @{
    "Select"=@("Register-EDRSSourceNetworkStack",
               "Ne