#
# Module manifest for module 'AWSPowerShell.NetCore'
#

@{
    # Script module or binary module file associated with this manifest
    RootModule = 'AWSPowerShell.NetCore.dll'

    # We are not including CompatiblePSEditions because it is not compatible with older PowerShell versions
    # CompatiblePSEditions = @('Core', 'Desktop')

    # Version number of this module.
    ModuleVersion = '5.0.88'

    # ID used to uniquely identify this module
    GUID = 'cb0b9b96-f3f2-4eff-b7f4-cbe0a9203683'

    # Author of this module
    Author = 'Amazon.com, Inc'

    # Company or vendor of this module
    CompanyName = 'Amazon.com, Inc'

    # Copyright statement for this module
    Copyright = 'Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.'

    # Description of the functionality provided by this module
    Description = 'The AWS Tools for PowerShell lets developers and administrators manage their AWS services from the PowerShell scripting environment.
This version of AWS Tools for PowerShell is compatible with Windows PowerShell 3+ and PowerShell Core 6+ on Windows, Linux and macOS. When running on Windows PowerShell, .NET Framework 4.7.2 or newer is required. An alternative module, AWSPowerShell, provides support for older versions of Windows PowerShell and .NET Framework.
This product provides support for all AWS services in a single module. As an alternative, a modular variant is also available: separate smaller modules (e.g. AWS.Tools.EC2, AWS.Tools.S3...) allow managing each AWS Service.'

    # Minimum version of the PowerShell engine required by this module
    PowerShellVersion = '3.1'

    # Name of the PowerShell host required by this module
    PowerShellHostName = ''



    # Minimum version of the PowerShell host required by this module
    PowerShellHostVersion = ''

    # Minimum version of the .NET Framework required by this module
    DotNetFrameworkVersion = '4.7.2'

    # Minimum version of the common language runtime (CLR) required by this module
    CLRVersion = ''

    # Processor architecture (None, X86, Amd64, IA64) required by this module
    ProcessorArchitecture = ''

    # Modules that must be imported into the global environment prior to importing this module
    RequiredModules = @(
    )

# Assemblies that must be loaded prior to importing this module.
    RequiredAssemblies = @(
        'AWSSDK.AccessAnalyzer.dll',
        'AWSSDK.Account.dll',
        'AWSSDK.ACMPCA.dll',
        'AWSSDK.AIOps.dll',
        'AWSSDK.Amplify.dll',
        'AWSSDK.AmplifyBackend.dll',
        'AWSSDK.AmplifyUIBuilder.dll',
        'AWSSDK.APIGateway.dll',
        'AWSSDK.ApiGatewayManagementApi.dll',
        'AWSSDK.ApiGatewayV2.dll',
        'AWSSDK.AppConfig.dll',
        'AWSSDK.AppConfigData.dll',
        'AWSSDK.AppFabric.dll',
        'AWSSDK.Appflow.dll',
        'AWSSDK.AppIntegrationsService.dll',
        'AWSSDK.ApplicationAutoScaling.dll',
        'AWSSDK.ApplicationCostProfiler.dll',
        'AWSSDK.ApplicationDiscoveryService.dll',
        'AWSSDK.ApplicationInsights.dll',
        'AWSSDK.ApplicationSignals.dll',
        'AWSSDK.AppMesh.dll',
        'AWSSDK.AppRegistry.dll',
        'AWSSDK.AppRunner.dll',
        'AWSSDK.AppStream.dll',
        'AWSSDK.AppSync.dll',
        'AWSSDK.ARCRegionswitch.dll',
        'AWSSDK.ARCZonalShift.dll',
        'AWSSDK.Artifact.dll',
        'AWSSDK.Athena.dll',
        'AWSSDK.AuditManager.dll',
        'AWSSDK.AugmentedAIRuntime.dll',
        'AWSSDK.AutoScaling.dll',
        'AWSSDK.AutoScalingPlans.dll',
        'AWSSDK.AWSHealth.dll',
        'AWSSDK.AWSMarketplaceCommerceAnalytics.dll',
        'AWSSDK.AWSMarketplaceMetering.dll',
        'AWSSDK.AWSSupport.dll',
        'AWSSDK.B2bi.dll',
        'AWSSDK.Backup.dll',
        'AWSSDK.BackupGateway.dll',
        'AWSSDK.BackupSearch.dll',
        'AWSSDK.Batch.dll',
        'AWSSDK.BCMDashboards.dll',
        'AWSSDK.BCMDataExports.dll',
        'AWSSDK.BCMPricingCalculator.dll',
        'AWSSDK.BCMRecommendedActions.dll',
        'AWSSDK.Bedrock.dll',
        'AWSSDK.BedrockAgent.dll',
        'AWSSDK.BedrockAgentCore.dll',
        'AWSSDK.BedrockAgentCoreControl.dll',
        'AWSSDK.BedrockAgentRuntime.dll',
        'AWSSDK.BedrockDataAutomation.dll',
        'AWSSDK.BedrockDataAutomationRuntime.dll',
        'AWSSDK.BedrockRuntime.dll',
        'AWSSDK.Billing.dll',
        'AWSSDK.BillingConductor.dll',
        'AWSSDK.Braket.dll',
        'AWSSDK.Budgets.dll',
        'AWSSDK.CertificateManager.dll',
        'AWSSDK.Chatbot.dll',
        'AWSSDK.Chime.dll',
        'AWSSDK.ChimeSDKIdentity.dll',
        'AWSSDK.ChimeSDKMediaPipelines.dll',
        'AWSSDK.ChimeSDKMeetings.dll',
        'AWSSDK.ChimeSDKMessaging.dll',
        'AWSSDK.ChimeSDKVoice.dll',
        'AWSSDK.CleanRooms.dll',
        'AWSSDK.CleanRoomsML.dll',
        'AWSSDK.Cloud9.dll',
        'AWSSDK.CloudControlApi.dll',
        'AWSSDK.CloudDirectory.dll',
        'AWSSDK.CloudFormation.dll',
        'AWSSDK.CloudFront.dll',
        'AWSSDK.CloudFrontKeyValueStore.dll',
        'AWSSDK.CloudHSM.dll',
        'AWSSDK.CloudHSMV2.dll',
        'AWSSDK.CloudSearch.dll',
        'AWSSDK.CloudSearchDomain.dll',
        'AWSSDK.CloudTrail.dll',
        'AWSSDK.CloudTrailData.dll',
        'AWSSDK.CloudWatch.dll',
        'AWSSDK.CloudWatchEvents.dll',
        'AWSSDK.CloudWatchEvidently.dll',
        'AWSSDK.CloudWatchLogs.dll',
        'AWSSDK.CloudWatchRUM.dll',
        'AWSSDK.CodeArtifact.dll',
        'AWSSDK.CodeBuild.dll',
        'AWSSDK.CodeCatalyst.dll',
        'AWSSDK.CodeCommit.dll',
        'AWSSDK.CodeConnections.dll',
        'AWSSDK.CodeDeploy.dll',
        'AWSSDK.CodeGuruProfiler.dll',
        'AWSSDK.CodeGuruReviewer.dll',
        'AWSSDK.CodeGuruSecurity.dll',
        'AWSSDK.CodePipeline.dll',
        'AWSSDK.CodeStarconnections.dll',
        'AWSSDK.CodeStarNotifications.dll',
        'AWSSDK.CognitoIdentity.dll',
        'AWSSDK.CognitoIdentityProvider.dll',
        'AWSSDK.CognitoSync.dll',
        'AWSSDK.Comprehend.dll',
        'AWSSDK.ComprehendMedical.dll',
        'AWSSDK.ComputeOptimizer.dll',
        'AWSSDK.ConfigService.dll',
        'AWSSDK.Connect.dll',
        'AWSSDK.ConnectCampaignService.dll',
        'AWSSDK.ConnectCampaignsV2.dll',
        'AWSSDK.ConnectCases.dll',
        'AWSSDK.ConnectContactLens.dll',
        'AWSSDK.ConnectParticipant.dll',
        'AWSSDK.ConnectWisdomService.dll',
        'AWSSDK.ControlCatalog.dll',
        'AWSSDK.ControlTower.dll',
        'AWSSDK.Core.dll',
        'AWSSDK.CostAndUsageReport.dll',
        'AWSSDK.CostExplorer.dll',
        'AWSSDK.CostOptimizationHub.dll',
        'AWSSDK.CustomerProfiles.dll',
        'AWSSDK.DatabaseMigrationService.dll',
        'AWSSDK.DataExchange.dll',
        'AWSSDK.DataPipeline.dll',
        'AWSSDK.DataSync.dll',
        'AWSSDK.DataZone.dll',
        'AWSSDK.DAX.dll',
        'AWSSDK.Deadline.dll',
        'AWSSDK.Detective.dll',
        'AWSSDK.DeviceFarm.dll',
        'AWSSDK.DevOpsGuru.dll',
        'AWSSDK.DirectConnect.dll',
        'AWSSDK.DirectoryService.dll',
        'AWSSDK.DirectoryServiceData.dll',
        'AWSSDK.DLM.dll',
        'AWSSDK.DocDB.dll',
        'AWSSDK.DocDBElastic.dll',
        'AWSSDK.Drs.dll',
        'AWSSDK.DSQL.dll',
        'AWSSDK.DynamoDBStreams.dll',
        'AWSSDK.DynamoDBv2.dll',
        'AWSSDK.EBS.dll',
        'AWSSDK.EC2.dll',
        'AWSSDK.EC2InstanceConnect.dll',
        'AWSSDK.ECR.dll',
        'AWSSDK.ECRPublic.dll',
        'AWSSDK.ECS.dll',
        'AWSSDK.EKS.dll',
        'AWSSDK.EKSAuth.dll',
        'AWSSDK.ElastiCache.dll',
        'AWSSDK.ElasticBeanstalk.dll',
        'AWSSDK.ElasticFileSystem.dll',
        'AWSSDK.ElasticLoadBalancing.dll',
        'AWSSDK.ElasticLoadBalancingV2.dll',
        'AWSSDK.ElasticMapReduce.dll',
        'AWSSDK.Elasticsearch.dll',
        'AWSSDK.ElasticTranscoder.dll',
        'AWSSDK.EMRContainers.dll',
        'AWSSDK.EMRServerless.dll',
        'AWSSDK.EntityResolution.dll',
        'AWSSDK.EventBridge.dll',
        'AWSSDK.Evs.dll',
        'AWSSDK.Finspace.dll',
        'AWSSDK.FinSpaceData.dll',
        'AWSSDK.FIS.dll',
        'AWSSDK.FMS.dll',
        'AWSSDK.ForecastQueryService.dll',
        'AWSSDK.ForecastService.dll',
        'AWSSDK.FraudDetector.dll',
        'AWSSDK.FreeTier.dll',
        'AWSSDK.FSx.dll',
        'AWSSDK.GameLift.dll',
        'AWSSDK.GameLiftStreams.dll',
        'AWSSDK.GeoMaps.dll',
        'AWSSDK.GeoPlaces.dll',
        'AWSSDK.GeoRoutes.dll',
        'AWSSDK.Glacier.dll',
        'AWSSDK.GlobalAccelerator.dll',
        'AWSSDK.Glue.dll',
        'AWSSDK.GlueDataBrew.dll',
        'AWSSDK.Greengrass.dll',
        'AWSSDK.GreengrassV2.dll',
        'AWSSDK.GroundStation.dll',
        'AWSSDK.GuardDuty.dll',
        'AWSSDK.HealthLake.dll',
        'AWSSDK.IAMRolesAnywhere.dll',
        'AWSSDK.IdentityManagement.dll',
        'AWSSDK.IdentityStore.dll',
        'AWSSDK.Imagebuilder.dll',
        'AWSSDK.ImportExport.dll',
        'AWSSDK.Inspector.dll',
        'AWSSDK.Inspector2.dll',
        'AWSSDK.InspectorScan.dll',
        'AWSSDK.InternetMonitor.dll',
        'AWSSDK.Invoicing.dll',
        'AWSSDK.IoT.dll',
        'AWSSDK.IoTDeviceAdvisor.dll',
        'AWSSDK.IoTEvents.dll',
        'AWSSDK.IoTEventsData.dll',
        'AWSSDK.IoTFleetWise.dll',
        'AWSSDK.IoTJobsDataPlane.dll',
        'AWSSDK.IoTManagedIntegrations.dll',
        'AWSSDK.IoTSecureTunneling.dll',
        'AWSSDK.IoTSiteWise.dll',
        'AWSSDK.IoTThingsGraph.dll',
        'AWSSDK.IoTTwinMaker.dll',
        'AWSSDK.IoTWireless.dll',
        'AWSSDK.IVS.dll',
        'AWSSDK.Ivschat.dll',
        'AWSSDK.IVSRealTime.dll',
        'AWSSDK.Kafka.dll',
        'AWSSDK.KafkaConnect.dll',
        'AWSSDK.Kendra.dll',
        'AWSSDK.KendraRanking.dll',
        'AWSSDK.KeyManagementService.dll',
        'AWSSDK.Keyspaces.dll',
        'AWSSDK.KeyspacesStreams.dll',
        'AWSSDK.Kinesis.dll',
        'AWSSDK.KinesisAnalytics.dll',
        'AWSSDK.KinesisAnalyticsV2.dll',
        'AWSSDK.KinesisFirehose.dll',
        'AWSSDK.KinesisVideo.dll',
        'AWSSDK.KinesisVideoMedia.dll',
        'AWSSDK.KinesisVideoSignalingChannels.dll',
        'AWSSDK.KinesisVideoWebRTCStorage.dll',
        'AWSSDK.LakeFormation.dll',
        'AWSSDK.Lambda.dll',
        'AWSSDK.LaunchWizard.dll',
        'AWSSDK.Lex.dll',
        'AWSSDK.LexModelBuildingService.dll',
        'AWSSDK.LexModelsV2.dll',
        'AWSSDK.LexRuntimeV2.dll',
        'AWSSDK.LicenseManager.dll',
        'AWSSDK.LicenseManagerLinuxSubscriptions.dll',
        'AWSSDK.LicenseManagerUserSubscriptions.dll',
        'AWSSDK.Lightsail.dll',
        'AWSSDK.LocationService.dll',
        'AWSSDK.LookoutEquipment.dll',
        'AWSSDK.MachineLearning.dll',
        'AWSSDK.Macie2.dll',
        'AWSSDK.MailManager.dll',
        'AWSSDK.MainframeModernization.dll',
        'AWSSDK.ManagedBlockchain.dll',
        'AWSSDK.ManagedBlockchainQuery.dll',
        'AWSSDK.ManagedGrafana.dll',
        'AWSSDK.MarketplaceAgreement.dll',
        'AWSSDK.MarketplaceCatalog.dll',
        'AWSSDK.MarketplaceDeployment.dll',
        'AWSSDK.MarketplaceEntitlementService.dll',
        'AWSSDK.MarketplaceReporting.dll',
        'AWSSDK.MediaConnect.dll',
        'AWSSDK.MediaConvert.dll',
        'AWSSDK.MediaLive.dll',
        'AWSSDK.MediaPackage.dll',
        'AWSSDK.MediaPackageV2.dll',
        'AWSSDK.MediaPackageVod.dll',
        'AWSSDK.MediaStore.dll',
        'AWSSDK.MediaStoreData.dll',
        'AWSSDK.MediaTailor.dll',
        'AWSSDK.MedicalImaging.dll',
        'AWSSDK.MemoryDB.dll',
        'AWSSDK.Mgn.dll',
        'AWSSDK.MigrationHub.dll',
        'AWSSDK.MigrationHubConfig.dll',
        'AWSSDK.MigrationHubOrchestrator.dll',
        'AWSSDK.MigrationHubRefactorSpaces.dll',
        'AWSSDK.MigrationHubStrategyRecommendations.dll',
        'AWSSDK.MPA.dll',
        'AWSSDK.MQ.dll',
        'AWSSDK.MTurk.dll',
        'AWSSDK.MWAA.dll',
        'AWSSDK.Neptune.dll',
        'AWSSDK.Neptunedata.dll',
        'AWSSDK.NeptuneGraph.dll',
        'AWSSDK.NetworkFirewall.dll',
        'AWSSDK.NetworkFlowMonitor.dll',
        'AWSSDK.NetworkManager.dll',
        'AWSSDK.NetworkMonitor.dll',
        'AWSSDK.Notifications.dll',
        'AWSSDK.NotificationsContacts.dll',
        'AWSSDK.OAM.dll',
        'AWSSDK.ObservabilityAdmin.dll',
        'AWSSDK.Odb.dll',
        'AWSSDK.Omics.dll',
        'AWSSDK.OpenSearchServerless.dll',
        'AWSSDK.OpenSearchService.dll',
        'AWSSDK.Organizations.dll',
        'AWSSDK.OSIS.dll',
        'AWSSDK.Outposts.dll',
        'AWSSDK.Panorama.dll',
        'AWSSDK.PartnerCentralSelling.dll',
        'AWSSDK.PaymentCryptography.dll',
        'AWSSDK.PaymentCryptographyData.dll',
        'AWSSDK.PcaConnectorAd.dll',
        'AWSSDK.PcaConnectorScep.dll',
        'AWSSDK.PCS.dll',
        'AWSSDK.Personalize.dll',
        'AWSSDK.PersonalizeEvents.dll',
        'AWSSDK.PersonalizeRuntime.dll',
        'AWSSDK.PI.dll',
        'AWSSDK.Pinpoint.dll',
        'AWSSDK.PinpointEmail.dll',
        'AWSSDK.PinpointSMSVoiceV2.dll',
        'AWSSDK.Pipes.dll',
        'AWSSDK.Polly.dll',
        'AWSSDK.Pricing.dll',
        'AWSSDK.PrometheusService.dll',
        'AWSSDK.Proton.dll',
        'AWSSDK.QApps.dll',
        'AWSSDK.QBusiness.dll',
        'AWSSDK.QConnect.dll',
        'AWSSDK.QuickSight.dll',
        'AWSSDK.RAM.dll',
        'AWSSDK.RDS.dll',
        'AWSSDK.RDSDataService.dll',
        'AWSSDK.RecycleBin.dll',
        'AWSSDK.Redshift.dll',
        'AWSSDK.RedshiftDataAPIService.dll',
        'AWSSDK.RedshiftServerless.dll',
        'AWSSDK.Rekognition.dll',
        'AWSSDK.Repostspace.dll',
        'AWSSDK.ResilienceHub.dll',
        'AWSSDK.ResourceExplorer2.dll',
        'AWSSDK.ResourceGroups.dll',
        'AWSSDK.ResourceGroupsTaggingAPI.dll',
        'AWSSDK.Route53.dll',
        'AWSSDK.Route53Domains.dll',
        'AWSSDK.Route53Profiles.dll',
        'AWSSDK.Route53RecoveryCluster.dll',
        'AWSSDK.Route53RecoveryControlConfig.dll',
        'AWSSDK.Route53RecoveryReadiness.dll',
        'AWSSDK.Route53Resolver.dll',
        'AWSSDK.RTBFabric.dll',
        'AWSSDK.S3.dll',
        'AWSSDK.S3Control.dll',
        'AWSSDK.S3Outposts.dll',
        'AWSSDK.S3Tables.dll',
        'AWSSDK.S3Vectors.dll',
        'AWSSDK.SageMaker.dll',
        'AWSSDK.SagemakerEdgeManager.dll',
        'AWSSDK.SageMakerFeatureStoreRuntime.dll',
        'AWSSDK.SageMakerGeospatial.dll',
        'AWSSDK.SageMakerMetrics.dll',
        'AWSSDK.SageMakerRuntime.dll',
        'AWSSDK.SavingsPlans.dll',
        'AWSSDK.Scheduler.dll',
        'AWSSDK.Schemas.dll',
        'AWSSDK.SecretsManager.dll',
        'AWSSDK.SecurityHub.dll',
        'AWSSDK.SecurityIR.dll',
        'AWSSDK.SecurityLake.dll',
        'AWSSDK.SecurityToken.dll',
        'AWSSDK.ServerlessApplicationRepository.dll',
        'AWSSDK.ServiceCatalog.dll',
        'AWSSDK.ServiceDiscovery.dll',
        'AWSSDK.ServiceQuotas.dll',
        'AWSSDK.Shield.dll',
        'AWSSDK.SimpleEmail.dll',
        'AWSSDK.SimpleEmailV2.dll',
        'AWSSDK.SimpleNotificationService.dll',
        'AWSSDK.SimpleSystemsManagement.dll',
        'AWSSDK.SimpleWorkflow.dll',
        'AWSSDK.SimSpaceWeaver.dll',
        'AWSSDK.Snowball.dll',
        'AWSSDK.SnowDeviceManagement.dll',
        'AWSSDK.SocialMessaging.dll',
        'AWSSDK.SQS.dll',
        'AWSSDK.SSMContacts.dll',
        'AWSSDK.SSMGuiConnect.dll',
        'AWSSDK.SSMIncidents.dll',
        'AWSSDK.SSMQuickSetup.dll',
        'AWSSDK.SsmSap.dll',
        'AWSSDK.SSO.dll',
        'AWSSDK.SSOAdmin.dll',
        'AWSSDK.SSOOIDC.dll',
        'AWSSDK.StepFunctions.dll',
        'AWSSDK.StorageGateway.dll',
        'AWSSDK.SupplyChain.dll',
        'AWSSDK.SupportApp.dll',
        'AWSSDK.Synthetics.dll',
        'AWSSDK.TaxSettings.dll',
        'AWSSDK.Textract.dll',
        'AWSSDK.TimestreamInfluxDB.dll',
        'AWSSDK.TimestreamQuery.dll',
        'AWSSDK.TimestreamWrite.dll',
        'AWSSDK.Tnb.dll',
        'AWSSDK.TranscribeService.dll',
        'AWSSDK.Transfer.dll',
        'AWSSDK.Translate.dll',
        'AWSSDK.TrustedAdvisor.dll',
        'AWSSDK.VerifiedPermissions.dll',
        'AWSSDK.VoiceID.dll',
        'AWSSDK.VPCLattice.dll',
        'AWSSDK.WAF.dll',
        'AWSSDK.WAFRegional.dll',
        'AWSSDK.WAFV2.dll',
        'AWSSDK.WellArchitected.dll',
        'AWSSDK.WorkDocs.dll',
        'AWSSDK.WorkMail.dll',
        'AWSSDK.WorkMailMessageFlow.dll',
        'AWSSDK.WorkSpaces.dll',
        'AWSSDK.WorkspacesInstances.dll',
        'AWSSDK.WorkSpacesThinClient.dll',
        'AWSSDK.WorkSpacesWeb.dll',
        'AWSSDK.XRay.dll',
        'aws-crt.dll',
        'aws-crt-auth.dll',
        'aws-crt-http.dll',
        'aws-crt-checksums.dll',
        'AWSSDK.Extensions.CrtIntegration.dll',
        'AWSSDK.Extensions.CborProtocol.dll',
        'System.Formats.Cbor.dll',
        'AWSSDK.Extensions.CloudFront.Signers.dll',
        'AWSSDK.Extensions.EC2.DecryptPassword.dll'
    )

    # Script files (.ps1) that are run in the caller's environment prior to importing this module
    ScriptsToProcess = @(
        'ImportGuard.ps1'
    )

    # Type files (.ps1xml) to be loaded when importing this module
    TypesToProcess = @(
        'AWSPowerShell.TypeExtensions.ps1xml'
    )

    # Format files (.ps1xml) to be loaded when importing this module
    FormatsToProcess = @(
        'AWSPowerShell.NetCore.Format.ps1xml'
    )

    # Modules to import as nested modules of the module specified in ModuleToProcess
    NestedModules = @(
        'AWSPowerShellCompleters.psm1',
        'AWSPowerShellLegacyAliases.psm1'
    )

    # Functions to export from this module
    FunctionsToExport = ''

    # Cmdlets to export from this module
    CmdletsToExport = '*-*'

    # Variables to export from this module
    VariablesToExport = '*'

    # Aliases to export from this module
    AliasesToExport = '*'

    # List of all modules packaged with this module
    ModuleList = @()

    # List of all files packaged with this module
    FileList = @(
        'AWSPowerShell.NetCore.dll-Help.xml', 
        'CHANGELOG.txt'
    )

    # Private data to pass to the module specified in ModuleToProcess
    PrivateData = @{

        PSData = @{
            Tags = @('AWS', 'cloud', 'Windows', 'PSEdition_Desktop', 'PSEdition_Core', 'Linux', 'MacOS', 'Mac')
            LicenseUri = 'https://aws.amazon.com/apache-2-0/'
            ProjectUri = 'https://github.com/aws/aws-tools-for-powershell'
            IconUri = 'https://sdk-for-net.amazonwebservices.com/images/AWSLogo128x128.png'
            ReleaseNotes = 'https://github.com/aws/aws-tools-for-powershell/blob/main/CHANGELOG.md'
        }
    }
}

# SIG # Begin signature block
# MIIutQYJKoZIhvcNAQcCoIIupjCCLqICAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCDRDcHEGeslq9iT
# 9rzuCRlFjw/zDKdolCogClDiZVc6faCCE+owggXAMIIEqKADAgECAhAP0bvKeWvX
# +N1MguEKmpYxMA0GCSqGSIb3DQEBCwUAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQK
# EwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xKzApBgNV
# BAMTIkRpZ2lDZXJ0IEhpZ2ggQXNzdXJhbmNlIEVWIFJvb3QgQ0EwHhcNMjIwMTEz
# MDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEVMBMGA1UEChMM
# RGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQD
# ExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3DQEBAQUAA4IC
# DwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZwuEppz1Yq3aa
# za57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4VpX6+n6lXFllV
# cq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAdYyktzuxeTsiT
# +CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3T6cw2Vbuyntd
# 463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjUN6QuBX2I9YI+
# EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNdaSaTC5qmgZ92k
# J7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtmmnTK3kse5w5j
# rubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyVw4/3IbKyEbe7
# f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3AeEPlAwhHbJU
# KSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYiCd98THU/Y+wh
# X8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmpsh3lGwIDAQAB
# o4IBZjCCAWIwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7NfjgtJxXWRM3y5n
# P+e6mK4cD08wHwYDVR0jBBgwFoAUsT7DaQP4v0cB1JgmGggC72NkK8MwDgYDVR0P
# AQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMH8GCCsGAQUFBwEBBHMwcTAk
# BggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEkGCCsGAQUFBzAC
# hj1odHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNzdXJh
# bmNlRVZSb290Q0EuY3J0MEsGA1UdHwREMEIwQKA+oDyGOmh0dHA6Ly9jcmwzLmRp
# Z2ljZXJ0LmNvbS9EaWdpQ2VydEhpZ2hBc3N1cmFuY2VFVlJvb3RDQS5jcmwwHAYD
# VR0gBBUwEzAHBgVngQwBAzAIBgZngQwBBAEwDQYJKoZIhvcNAQELBQADggEBAEHx
# qRH0DxNHecllao3A7pgEpMbjDPKisedfYk/ak1k2zfIe4R7sD+EbP5HU5A/C5pg0
# /xkPZigfT2IxpCrhKhO61z7H0ZL+q93fqpgzRh9Onr3g7QdG64AupP2uU7SkwaT1
# IY1rzAGt9Rnu15ClMlIr28xzDxj4+87eg3Gn77tRWwR2L62t0+od/P1Tk+WMieNg
# GbngLyOOLFxJy34riDkruQZhiPOuAnZ2dMFkkbiJUZflhX0901emWG4f7vtpYeJa
# 3Cgh6GO6Ps9W7Zrk9wXqyvPsEt84zdp7PiuTUy9cUQBY3pBIowrHC/Q7bVUx8ALM
# R3eWUaNetbxcyEMRoacwggawMIIEmKADAgECAhAIrUCyYNKcTJ9ezam9k67ZMA0G
# CSqGSIb3DQEBDAUAMGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJ
# bmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERpZ2lDZXJ0
# IFRydXN0ZWQgUm9vdCBHNDAeFw0yMTA0MjkwMDAwMDBaFw0zNjA0MjgyMzU5NTla
# MGkxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjFBMD8GA1UE
# AxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNpZ25pbmcgUlNBNDA5NiBTSEEz
# ODQgMjAyMSBDQTEwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDVtC9C
# 0CiteLdd1TlZG7GIQvUzjOs9gZdwxbvEhSYwn6SOaNhc9es0JAfhS0/TeEP0F9ce
# 2vnS1WcaUk8OoVf8iJnBkcyBAz5NcCRks43iCH00fUyAVxJrQ5qZ8sU7H/Lvy0da
# E6ZMswEgJfMQ04uy+wjwiuCdCcBlp/qYgEk1hz1RGeiQIXhFLqGfLOEYwhrMxe6T
# SXBCMo/7xuoc82VokaJNTIIRSFJo3hC9FFdd6BgTZcV/sk+FLEikVoQ11vkunKoA
# FdE3/hoGlMJ8yOobMubKwvSnowMOdKWvObarYBLj6Na59zHh3K3kGKDYwSNHR7Oh
# D26jq22YBoMbt2pnLdK9RBqSEIGPsDsJ18ebMlrC/2pgVItJwZPt4bRc4G/rJvmM
# 1bL5OBDm6s6R9b7T+2+TYTRcvJNFKIM2KmYoX7BzzosmJQayg9Rc9hUZTO1i4F4z
# 8ujo7AqnsAMrkbI2eb73rQgedaZlzLvjSFDzd5Ea/ttQokbIYViY9XwCFjyDKK05
# huzUtw1T0PhH5nUwjewwk3YUpltLXXRhTT8SkXbev1jLchApQfDVxW0mdmgRQRNY
# mtwmKwH0iU1Z23jPgUo+QEdfyYFQc4UQIyFZYIpkVMHMIRroOBl8ZhzNeDhFMJlP
# /2NPTLuqDQhTQXxYPUez+rbsjDIJAsxsPAxWEQIDAQABo4IBWTCCAVUwEgYDVR0T
# AQH/BAgwBgEB/wIBADAdBgNVHQ4EFgQUaDfg67Y7+F8Rhvv+YXsIiGX0TkIwHwYD
# VR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6mK4cD08wDgYDVR0PAQH/BAQDAgGGMBMG
# A1UdJQQMMAoGCCsGAQUFBwMDMHcGCCsGAQUFBwEBBGswaTAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEEGCCsGAQUFBzAChjVodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNydDBDBgNV
# HR8EPDA6MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRU
# cnVzdGVkUm9vdEc0LmNybDAcBgNVHSAEFTATMAcGBWeBDAEDMAgGBmeBDAEEATAN
# BgkqhkiG9w0BAQwFAAOCAgEAOiNEPY0Idu6PvDqZ01bgAhql+Eg08yy25nRm95Ry
# sQDKr2wwJxMSnpBEn0v9nqN8JtU3vDpdSG2V1T9J9Ce7FoFFUP2cvbaF4HZ+N3HL
# IvdaqpDP9ZNq4+sg0dVQeYiaiorBtr2hSBh+3NiAGhEZGM1hmYFW9snjdufE5Btf
# Q/g+lP92OT2e1JnPSt0o618moZVYSNUa/tcnP/2Q0XaG3RywYFzzDaju4ImhvTnh
# OE7abrs2nfvlIVNaw8rpavGiPttDuDPITzgUkpn13c5UbdldAhQfQDN8A+KVssIh
# dXNSy0bYxDQcoqVLjc1vdjcshT8azibpGL6QB7BDf5WIIIJw8MzK7/0pNVwfiThV
# 9zeKiwmhywvpMRr/LhlcOXHhvpynCgbWJme3kuZOX956rEnPLqR0kq3bPKSchh/j
# wVYbKyP/j7XqiHtwa+aguv06P0WmxOgWkVKLQcBIhEuWTatEQOON8BUozu3xGFYH
# Ki8QxAwIZDwzj64ojDzLj4gLDb879M4ee47vtevLt/B3E+bnKD+sEq6lLyJsQfmC
# XBVmzGwOysWGw/YmMwwHS6DTBwJqakAwSEs0qFEgu60bhQjiWQ1tygVQK+pKHJ6l
# /aCnHwZ05/LWUpD9r4VIIflXO7ScA+2GRfS0YW6/aOImYIbqyK+p/pQd52MbOoZW
# eE4wggduMIIFVqADAgECAhADmooc3J4LAjb9FLn2g0iAMA0GCSqGSIb3DQEBCwUA
# MGkxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjFBMD8GA1UE
# AxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNpZ25pbmcgUlNBNDA5NiBTSEEz
# ODQgMjAyMSBDQTEwHhcNMjUwNjAzMDAwMDAwWhcNMjYwNjAyMjM1OTU5WjCB9jET
# MBEGCysGAQQBgjc8AgEDEwJVUzEZMBcGCysGAQQBgjc8AgECEwhEZWxhd2FyZTEd
# MBsGA1UEDwwUUHJpdmF0ZSBPcmdhbml6YXRpb24xEDAOBgNVBAUTBzQxNTI5NTQx
# CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdTZWF0
# dGxlMSIwIAYDVQQKExlBbWF6b24gV2ViIFNlcnZpY2VzLCBJbmMuMRcwFQYDVQQL
# Ew5TREtzIGFuZCBUb29sczEiMCAGA1UEAxMZQW1hem9uIFdlYiBTZXJ2aWNlcywg
# SW5jLjCCAaIwDQYJKoZIhvcNAQEBBQADggGPADCCAYoCggGBAKc7ffRFlFB89cU3
# j76EOoK8sFXFunuUhvU6LMeAzgO2fjlMn2l3WJBPZmrHXIicBHmejbJDRgMc+FPd
# oSUR6ZsuVX08txcdv8yHqC+u2BHrj+GRakq7WF148X1PR8kOhkon+qNSh+cxoIHm
# m+Lxg9kZuddkr1m+Fuv79VGj3E9xp4YjbhvVEVbxLs86p812WgVz3eoqvpNXBC0m
# H4eM3FUmNHcDA6ubRR/qh3OGYQHyQs4PeMOGACqcySO+XNRKxMNxIzf+fkQU8cuR
# A8eYl6s0pQ+KlJudGt2psY+5nkTU9TOC99wvRmfuuG+jpG7vEMsuGy26wCOp7hry
# k5kinq/EFImAxdx1WQ3pJuk+rcuSnuOcSieW+zSKEczJOCsbemDbF+9P5Iv0f0nx
# kHPYrrjdgValyxosQENsHeq1HztsE46IbBq2S4I9kGzZcaal5hKT/Yxcom9tBfXq
# oNs1KaL54mC4ddBGx07kAGE0kiHpY5pr4al2lGpOmBH4B5xKmwIDAQABo4ICAjCC
# Af4wHwYDVR0jBBgwFoAUaDfg67Y7+F8Rhvv+YXsIiGX0TkIwHQYDVR0OBBYEFALy
# CdwoelU9i0FZLXOC5NXeXmVqMD0GA1UdIAQ2MDQwMgYFZ4EMAQMwKTAnBggrBgEF
# BQcCARYbaHR0cDovL3d3dy5kaWdpY2VydC5jb20vQ1BTMA4GA1UdDwEB/wQEAwIH
# gDATBgNVHSUEDDAKBggrBgEFBQcDAzCBtQYDVR0fBIGtMIGqMFOgUaBPhk1odHRw
# Oi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVkRzRDb2RlU2lnbmlu
# Z1JTQTQwOTZTSEEzODQyMDIxQ0ExLmNybDBToFGgT4ZNaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZEc0Q29kZVNpZ25pbmdSU0E0MDk2U0hB
# Mzg0MjAyMUNBMS5jcmwwgZQGCCsGAQUFBwEBBIGHMIGEMCQGCCsGAQUFBzABhhho
# dHRwOi8vb2NzcC5kaWdpY2VydC5jb20wXAYIKwYBBQUHMAKGUGh0dHA6Ly9jYWNl
# cnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNENvZGVTaWduaW5nUlNB
# NDA5NlNIQTM4NDIwMjFDQTEuY3J0MAkGA1UdEwQCMAAwDQYJKoZIhvcNAQELBQAD
# ggIBACHYo9QgnoH4+yG1TQT8lxxsYPuy3+FiWd2sZxn/4dwBautbZSLaP5yAKlE0
# o7SFQq5IYV2FVA4c5LwJf3eoF0/8+Bh+SMmAHTteqHcAJ3VK8+VETL/qr9kFQx8j
# cMA3kF2OOaLVWuB5ffEsGCRqCnS2r8r2lCstb/oEqJLyUXkqEDbyJxgkJ0vQp1XD
# agCi68ujhDBwVQPoHmBux2V8TWaOuAT/5kZUJsqwUhBTxYSCKVdIYYkRppaUemJ0
# oULhtxeg1M5zumgLf432qyk6xchohECA1QSXsPflhLZ+eWk3RneSt0fAV/caEBma
# mfVj4OysofDA4bCgZSWFk/16O4PEMsLZhR8FCnFr5lxFYKUgAcnVczo75KSBKp2r
# aoUVAWIw9w1Z1NQljqfZbFUxWCIWLjmXmEbfy3IXeEpvlXidjPVwdqwbleyl0WR/
# ENGBEiy+I4a/ezu+HoA5zK+1b7INjLgxk8m5MnD75k6Pq+XctyTkzEh6F4Whhq7s
# ck16llf7N+i28flIkqzcXuSHxeOZUZb2VNDIcCXiapaxS7cslbP4wafWGEYs2SN3
# +Q398T0fI7uJ4ATp58qdIp6w7Z9PomrVKE0LQMC1P1j9VDiCv7VqnU1cM/2uPpzA
# Lop57Q8mTPr7Mh7nl0/QusIr8V/o6XWwRynumecNqn1oeMlaMYIaITCCGh0CAQEw
# fTBpMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNV
# BAMTOERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5nIFJTQTQwOTYgU0hB
# Mzg0IDIwMjEgQ0ExAhADmooc3J4LAjb9FLn2g0iAMA0GCWCGSAFlAwQCAQUAoHww
# EAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYK
# KwYBBAGCNwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIFeIjzms
# Gkyg6U5swrtLENzYqEe7ldUr27e9GIJ/N56LMA0GCSqGSIb3DQEBAQUABIIBgH+G
# OLY2PIv7emMZ6XHyqcDqbmT4Lgjo1gyXeuYY8yK+2rh+mjb9PLuyr0xwyh6fOOd1
# DDu4PyfG5vBSvrmMwWYF44QgDxdD+2Vx6wtQufGpI0wgldMK/3i2zZsqT5eFNMMq
# XBQHzH/ubAExIjvZzEYZ36FWOaari1IbECg1ZG5jyWaKSPV6XbnAo0m/LK8QQZ/h
# /w73MeNi5DOLbJsJnChyZuCe8H7Vtdv29FG/5v4Tb9WlT4yl4kXgwu85oQZ53dEQ
# DTo2RNNkCTBQl9cVh4Wenwm3COXlC9vMsjJvMCdg+5OXQsJDax+QyMAwYRlmbENJ
# Odujgiycufnv8wduZqESrHVhdQoDq2r53R8hI3PwYD17mtHHeXCG7jHhnA37cvzz
# fRuIE+7UV4saFbs57fwQqPI9wUYRWDuw0xNApk7U6OGmmo4ARA0w3p2iK+uWL2rB
# p9mtOl31SrwHAcbS38+VEobE+X7HUHojW5K32S8DNq18CSA6jfHRcMm2uhB3GqGC
# F3cwghdzBgorBgEEAYI3AwMBMYIXYzCCF18GCSqGSIb3DQEHAqCCF1AwghdMAgED
# MQ8wDQYJYIZIAWUDBAIBBQAweAYLKoZIhvcNAQkQAQSgaQRnMGUCAQEGCWCGSAGG
# /WwHATAxMA0GCWCGSAFlAwQCAQUABCCo0J4P4W/r+RoGmDYeeCE4wdN99YXHFRbz
# H8Wz1UTXGgIRALPr7qogXHSgENcwMk+J5hwYDzIwMjUxMDMxMjA0NDUwWqCCEzow
# ggbtMIIE1aADAgECAhAKgO8YS43xBYLRxHanlXRoMA0GCSqGSIb3DQEBCwUAMGkx
# CzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjFBMD8GA1UEAxM4
# RGlnaUNlcnQgVHJ1c3RlZCBHNCBUaW1lU3RhbXBpbmcgUlNBNDA5NiBTSEEyNTYg
# MjAyNSBDQTEwHhcNMjUwNjA0MDAwMDAwWhcNMzYwOTAzMjM1OTU5WjBjMQswCQYD
# VQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNVBAMTMkRpZ2lD
# ZXJ0IFNIQTI1NiBSU0E0MDk2IFRpbWVzdGFtcCBSZXNwb25kZXIgMjAyNSAxMIIC
# IjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA0EasLRLGntDqrmBWsytXum9R
# /4ZwCgHfyjfMGUIwYzKomd8U1nH7C8Dr0cVMF3BsfAFI54um8+dnxk36+jx0Tb+k
# +87H9WPxNyFPJIDZHhAqlUPt281mHrBbZHqRK71Em3/hCGC5KyyneqiZ7syvFXJ9
# A72wzHpkBaMUNg7MOLxI6E9RaUueHTQKWXymOtRwJXcrcTTPPT2V1D/+cFllESvi
# H8YjoPFvZSjKs3SKO1QNUdFd2adw44wDcKgH+JRJE5Qg0NP3yiSyi5MxgU6cehGH
# r7zou1znOM8odbkqoK+lJ25LCHBSai25CFyD23DZgPfDrJJJK77epTwMP6eKA0kW
# a3osAe8fcpK40uhktzUd/Yk0xUvhDU6lvJukx7jphx40DQt82yepyekl4i0r8OEp
# s/FNO4ahfvAk12hE5FVs9HVVWcO5J4dVmVzix4A77p3awLbr89A90/nWGjXMGn7F
# QhmSlIUDy9Z2hSgctaepZTd0ILIUbWuhKuAeNIeWrzHKYueMJtItnj2Q+aTyLLKL
# M0MheP/9w6CtjuuVHJOVoIJ/DtpJRE7Ce7vMRHoRon4CWIvuiNN1Lk9Y+xZ66laz
# s2kKFSTnnkrT3pXWETTJkhd76CIDBbTRofOsNyEhzZtCGmnQigpFHti58CSmvEyJ
# cAlDVcKacJ+A9/z7eacCAwEAAaOCAZUwggGRMAwGA1UdEwEB/wQCMAAwHQYDVR0O
# BBYEFOQ7/PIx7f391/ORcWMZUEPPYYzoMB8GA1UdIwQYMBaAFO9vU0rp5AZ8esri
# kFb2L9RJ7MtOMA4GA1UdDwEB/wQEAwIHgDAWBgNVHSUBAf8EDDAKBggrBgEFBQcD
# CDCBlQYIKwYBBQUHAQEEgYgwgYUwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRp
# Z2ljZXJ0LmNvbTBdBggrBgEFBQcwAoZRaHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
# Y29tL0RpZ2lDZXJ0VHJ1c3RlZEc0VGltZVN0YW1waW5nUlNBNDA5NlNIQTI1NjIw
# MjVDQTEuY3J0MF8GA1UdHwRYMFYwVKBSoFCGTmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFRpbWVTdGFtcGluZ1JTQTQwOTZTSEEyNTYy
# MDI1Q0ExLmNybDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEwDQYJ
# KoZIhvcNAQELBQADggIBAGUqrfEcJwS5rmBB7NEIRJ5jQHIh+OT2Ik/bNYulCrVv
# hREafBYF0RkP2AGr181o2YWPoSHz9iZEN/FPsLSTwVQWo2H62yGBvg7ouCODwrx6
# ULj6hYKqdT8wv2UV+Kbz/3ImZlJ7YXwBD9R0oU62PtgxOao872bOySCILdBghQ/Z
# LcdC8cbUUO75ZSpbh1oipOhcUT8lD8QAGB9lctZTTOJM3pHfKBAEcxQFoHlt2s9s
# XoxFizTeHihsQyfFg5fxUFEp7W42fNBVN4ueLaceRf9Cq9ec1v5iQMWTFQa0xNqI
# tH3CPFTG7aEQJmmrJTV3Qhtfparz+BW60OiMEgV5GWoBy4RVPRwqxv7Mk0Sy4QHs
# 7v9y69NBqycz0BZwhB9WOfOu/CIJnzkQTwtSSpGGhLdjnQ4eBpjtP+XB3pQCtv4E
# 5UCSDag6+iX8MmB10nfldPF9SVD7weCC3yXZi/uuhqdwkgVxuiMFzGVFwYbQsiGn
# oa9F5AaAyBjFBtXVLcKtapnMG3VH3EmAp/jsJ3FVF3+d1SVDTmjFjLbNFZUWMXuZ
# yvgLfgyPehwJVxwC+UpX2MSey2ueIu9THFVkT+um1vshETaWyQo8gmBto/m3acaP
# 9QsuLj3FNwFlTxq25+T4QwX9xa6ILs84ZPvmpovq90K8eWyG2N01c4IhSOxqt81n
# MIIGtDCCBJygAwIBAgIQDcesVwX/IZkuQEMiDDpJhjANBgkqhkiG9w0BAQsFADBi
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3Qg
# RzQwHhcNMjUwNTA3MDAwMDAwWhcNMzgwMTE0MjM1OTU5WjBpMQswCQYDVQQGEwJV
# UzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMTOERpZ2lDZXJ0IFRy
# dXN0ZWQgRzQgVGltZVN0YW1waW5nIFJTQTQwOTYgU0hBMjU2IDIwMjUgQ0ExMIIC
# IjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAtHgx0wqYQXK+PEbAHKx126NG
# aHS0URedTa2NDZS1mZaDLFTtQ2oRjzUXMmxCqvkbsDpz4aH+qbxeLho8I6jY3xL1
# IusLopuW2qftJYJaDNs1+JH7Z+QdSKWM06qchUP+AbdJgMQB3h2DZ0Mal5kYp77j
# YMVQXSZH++0trj6Ao+xh/AS7sQRuQL37QXbDhAktVJMQbzIBHYJBYgzWIjk8eDrY
# hXDEpKk7RdoX0M980EpLtlrNyHw0Xm+nt5pnYJU3Gmq6bNMI1I7Gb5IBZK4ivbVC
# iZv7PNBYqHEpNVWC2ZQ8BbfnFRQVESYOszFI2Wv82wnJRfN20VRS3hpLgIR4hjzL
# 0hpoYGk81coWJ+KdPvMvaB0WkE/2qHxJ0ucS638ZxqU14lDnki7CcoKCz6eum5A1
# 9WZQHkqUJfdkDjHkccpL6uoG8pbF0LJAQQZxst7VvwDDjAmSFTUms+wV/FbWBqi7
# fTJnjq3hj0XbQcd8hjj/q8d6ylgxCZSKi17yVp2NL+cnT6Toy+rN+nM8M7LnLqCr
# O2JP3oW//1sfuZDKiDEb1AQ8es9Xr/u6bDTnYCTKIsDq1BtmXUqEG1NqzJKS4kOm
# xkYp2WyODi7vQTCBZtVFJfVZ3j7OgWmnhFr4yUozZtqgPrHRVHhGNKlYzyjlroPx
# ul+bgIspzOwbtmsgY1MCAwEAAaOCAV0wggFZMBIGA1UdEwEB/wQIMAYBAf8CAQAw
# HQYDVR0OBBYEFO9vU0rp5AZ8esrikFb2L9RJ7MtOMB8GA1UdIwQYMBaAFOzX44LS
# cV1kTN8uZz/nupiuHA9PMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggrBgEF
# BQcDCDB3BggrBgEFBQcBAQRrMGkwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRp
# Z2ljZXJ0LmNvbTBBBggrBgEFBQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
# Y29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQwQwYDVR0fBDwwOjA4oDagNIYy
# aHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5j
# cmwwIAYDVR0gBBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcBMA0GCSqGSIb3DQEB
# CwUAA4ICAQAXzvsWgBz+Bz0RdnEwvb4LyLU0pn/N0IfFiBowf0/Dm1wGc/Do7oVM
# Y2mhXZXjDNJQa8j00DNqhCT3t+s8G0iP5kvN2n7Jd2E4/iEIUBO41P5F448rSYJ5
# 9Ib61eoalhnd6ywFLerycvZTAz40y8S4F3/a+Z1jEMK/DMm/axFSgoR8n6c3nuZB
# 9BfBwAQYK9FHaoq2e26MHvVY9gCDA/JYsq7pGdogP8HRtrYfctSLANEBfHU16r3J
# 05qX3kId+ZOczgj5kjatVB+NdADVZKON/gnZruMvNYY2o1f4MXRJDMdTSlOLh0HC
# n2cQLwQCqjFbqrXuvTPSegOOzr4EWj7PtspIHBldNE2K9i697cvaiIo2p61Ed2p8
# xMJb82Yosn0z4y25xUbI7GIN/TpVfHIqQ6Ku/qjTY6hc3hsXMrS+U0yy+GWqAXam
# 4ToWd2UQ1KYT70kZjE4YtL8Pbzg0c1ugMZyZZd/BdHLiRu7hAWE6bTEm4XYRkA6T
# l4KSFLFk43esaUeqGkH/wyW4N7OigizwJWeukcyIPbAvjSabnf7+Pu0VrFgoiovR
# Diyx3zEdmcif/sYQsfch28bZeUz2rtY/9TCA6TD8dC3JE3rYkrhLULy7Dc90G6e8
# BlqmyIjlgp2+VqsS9/wQD7yFylIz0scmbKvFoW2jNrbM1pD2T7m3XDCCBY0wggR1
# oAMCAQICEA6bGI750C3n79tQ4ghAGFowDQYJKoZIhvcNAQEMBQAwZTELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4X
# DTIyMDgwMTAwMDAwMFoXDTMxMTEwOTIzNTk1OVowYjELMAkGA1UEBhMCVVMxFTAT
# BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEh
# MB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MIICIjANBgkqhkiG9w0B
# AQEFAAOCAg8AMIICCgKCAgEAv+aQc2jeu+RdSjwwIjBpM+zCpyUuySE98orYWcLh
# Kac9WKt2ms2uexuEDcQwH/MbpDgW61bGl20dq7J58soR0uRf1gU8Ug9SH8aeFaV+
# vp+pVxZZVXKvaJNwwrK6dZlqczKU0RBEEC7fgvMHhOZ0O21x4i0MG+4g1ckgHWMp
# Lc7sXk7Ik/ghYZs06wXGXuxbGrzryc/NrDRAX7F6Zu53yEioZldXn1RYjgwrt0+n
# MNlW7sp7XeOtyU9e5TXnMcvak17cjo+A2raRmECQecN4x7axxLVqGDgDEI3Y1Dek
# LgV9iPWCPhCRcKtVgkEy19sEcypukQF8IUzUvK4bA3VdeGbZOjFEmjNAvwjXWkmk
# wuapoGfdpCe8oU85tRFYF/ckXEaPZPfBaYh2mHY9WV1CdoeJl2l6SPDgohIbZpp0
# yt5LHucOY67m1O+SkjqePdwA5EUlibaaRBkrfsCUtNJhbesz2cXfSwQAzH0clcOP
# 9yGyshG3u3/y1YxwLEFgqrFjGESVGnZifvaAsPvoZKYz0YkH4b235kOkGLimdwHh
# D5QMIR2yVCkliWzlDlJRR3S+Jqy2QXXeeqxfjT/JvNNBERJb5RBQ6zHFynIWIgnf
# fEx1P2PsIV/EIFFrb7GrhotPwtZFX50g/KEexcCPorF+CiaZ9eRpL5gdLfXZqbId
# 5RsCAwEAAaOCATowggE2MA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFOzX44LS
# cV1kTN8uZz/nupiuHA9PMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6enIZ3zbcgP
# MA4GA1UdDwEB/wQEAwIBhjB5BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0
# dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2Vy
# dHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDBFBgNV
# HR8EPjA8MDqgOKA2hjRodHRwOi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRB
# c3N1cmVkSURSb290Q0EuY3JsMBEGA1UdIAQKMAgwBgYEVR0gADANBgkqhkiG9w0B
# AQwFAAOCAQEAcKC/Q1xV5zhfoKN0Gz22Ftf3v1cHvZqsoYcs7IVeqRq7IviHGmlU
# Iu2kiHdtvRoU9BNKei8ttzjv9P+Aufih9/Jy3iS8UgPITtAq3votVs/59PesMHqa
# i7Je1M/RQ0SbQyHrlnKhSLSZy51PpwYDE3cnRNTnf+hZqPC/Lwum6fI0POz3A8eH
# qNJMQBk1RmppVLC4oVaO7KTVPeix3P0c2PR3WlxUjG/voVA9/HYJaISfb8rbII01
# YBwCA8sgsKxYoA5AY8WYIsGyWfVVa88nq2x2zm8jLfR+cWojayL/ErhULSd+2DrZ
# 8LaHlv1b0VysGMNNn3O3AamfV6peKOK5lDGCA3wwggN4AgEBMH0waTELMAkGA1UE
# BhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMUEwPwYDVQQDEzhEaWdpQ2Vy
# dCBUcnVzdGVkIEc0IFRpbWVTdGFtcGluZyBSU0E0MDk2IFNIQTI1NiAyMDI1IENB
# MQIQCoDvGEuN8QWC0cR2p5V0aDANBglghkgBZQMEAgEFAKCB0TAaBgkqhkiG9w0B
# CQMxDQYLKoZIhvcNAQkQAQQwHAYJKoZIhvcNAQkFMQ8XDTI1MTAzMTIwNDQ1MFow
# KwYLKoZIhvcNAQkQAgwxHDAaMBgwFgQU3WIwrIYKLTBr2jixaHlSMAf7QX4wLwYJ
# KoZIhvcNAQkEMSIEIL4r3bf7NtnINzXOtw2V2xbdhXS4Tsegw0h3xfzJigKmMDcG
# CyqGSIb3DQEJEAIvMSgwJjAkMCIEIEqgP6Is11yExVyTj4KOZ2ucrsqzP+NtJpqj
# NPFGEQozMA0GCSqGSIb3DQEBAQUABIICAAy+2mLYZf5fhtK/qML+XC7OefhyEDmn
# 23mifiGM2f7xCbrUGESb+Kdj9fDvCwjDpQeI7o9MBSsKQWHGrBREjcQx4xL9S0sT
# 3AAIMEUbGmRfg97rQ0UItOzBrAtn2meTe/6v/YJtnwVjH9Fitsahr5kdJfxmL9ZZ
# KxiIf0YsNUG1c1PB1U42AQTtaSvcuc/mqeQxw9l/Nj4cVANLqKBGmYwgTcouoYBN
# q+iwLcUzq2AQyCWo5yMZqmfk3eMT3OsmmoRw/OE7GM0sxOhoEuXnbABIDgxsAo+v
# zpElPnCtpx1Ku2AuinOBcqwlcpXDWu+jNrfBKMI+swrfKVWy8L4pZkSui3KtMKue
# uFtpPPddW513htJUTlv6mQtwPeYlQLpWTIUWJTodQUNn/366vX2A37i0QEjWUBru
# iVXGzf5yPXIEH4RTJsrOB/9S5rPdW9XsXfWa1Pt/l0H9YYpOUd8IU7RruWlJlInu
# DeUFx24nMg50INR6lG6WxDukPsEz/XLOPHwzuBqNmW4e7Xyif8xfQW6HVLL/2wmQ
# KlO4gCfO3XDYmRQaMZtzCvuXbFgKLvn0FPAqbyFt0ymOUR6SlRqHwI/0nJX+JfSv
# co20cphA5kdH1Y2ZiVC4G67BkgsJLRMbTHSGOkmukxq47a/WXoZsP0HtrrN6qu7R
# 1CEH1NGe7FAO
# SIG # End signature block
